/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaUtils;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.MissingResultsException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.proto.Common;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.TypedValue;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.google.protobuf.Descriptors;

public interface Meta {
    public Map<DatabaseProperty, Object> getDatabaseProperties(ConnectionHandle var1);

    public MetaResultSet getTables(ConnectionHandle var1, String var2, Pat var3, Pat var4, List<String> var5);

    public MetaResultSet getColumns(ConnectionHandle var1, String var2, Pat var3, Pat var4, Pat var5);

    public MetaResultSet getSchemas(ConnectionHandle var1, String var2, Pat var3);

    public MetaResultSet getCatalogs(ConnectionHandle var1);

    public MetaResultSet getTableTypes(ConnectionHandle var1);

    public MetaResultSet getProcedures(ConnectionHandle var1, String var2, Pat var3, Pat var4);

    public MetaResultSet getProcedureColumns(ConnectionHandle var1, String var2, Pat var3, Pat var4, Pat var5);

    public MetaResultSet getColumnPrivileges(ConnectionHandle var1, String var2, String var3, String var4, Pat var5);

    public MetaResultSet getTablePrivileges(ConnectionHandle var1, String var2, Pat var3, Pat var4);

    public MetaResultSet getBestRowIdentifier(ConnectionHandle var1, String var2, String var3, String var4, int var5, boolean var6);

    public MetaResultSet getVersionColumns(ConnectionHandle var1, String var2, String var3, String var4);

    public MetaResultSet getPrimaryKeys(ConnectionHandle var1, String var2, String var3, String var4);

    public MetaResultSet getImportedKeys(ConnectionHandle var1, String var2, String var3, String var4);

    public MetaResultSet getExportedKeys(ConnectionHandle var1, String var2, String var3, String var4);

    public MetaResultSet getCrossReference(ConnectionHandle var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public MetaResultSet getTypeInfo(ConnectionHandle var1);

    public MetaResultSet getIndexInfo(ConnectionHandle var1, String var2, String var3, String var4, boolean var5, boolean var6);

    public MetaResultSet getUDTs(ConnectionHandle var1, String var2, Pat var3, Pat var4, int[] var5);

    public MetaResultSet getSuperTypes(ConnectionHandle var1, String var2, Pat var3, Pat var4);

    public MetaResultSet getSuperTables(ConnectionHandle var1, String var2, Pat var3, Pat var4);

    public MetaResultSet getAttributes(ConnectionHandle var1, String var2, Pat var3, Pat var4, Pat var5);

    public MetaResultSet getClientInfoProperties(ConnectionHandle var1);

    public MetaResultSet getFunctions(ConnectionHandle var1, String var2, Pat var3, Pat var4);

    public MetaResultSet getFunctionColumns(ConnectionHandle var1, String var2, Pat var3, Pat var4, Pat var5);

    public MetaResultSet getPseudoColumns(ConnectionHandle var1, String var2, Pat var3, Pat var4, Pat var5);

    public Iterable<Object> createIterable(StatementHandle var1, QueryState var2, Signature var3, List<TypedValue> var4, Frame var5);

    public StatementHandle prepare(ConnectionHandle var1, String var2, long var3);

    @Deprecated
    public ExecuteResult prepareAndExecute(StatementHandle var1, String var2, long var3, PrepareCallback var5) throws NoSuchStatementException;

    public ExecuteResult prepareAndExecute(StatementHandle var1, String var2, long var3, int var5, PrepareCallback var6) throws NoSuchStatementException;

    public ExecuteBatchResult prepareAndExecuteBatch(StatementHandle var1, List<String> var2) throws NoSuchStatementException;

    public ExecuteBatchResult executeBatch(StatementHandle var1, List<List<TypedValue>> var2) throws NoSuchStatementException;

    public Frame fetch(StatementHandle var1, long var2, int var4) throws NoSuchStatementException, MissingResultsException;

    @Deprecated
    public ExecuteResult execute(StatementHandle var1, List<TypedValue> var2, long var3) throws NoSuchStatementException;

    public ExecuteResult execute(StatementHandle var1, List<TypedValue> var2, int var3) throws NoSuchStatementException;

    public StatementHandle createStatement(ConnectionHandle var1);

    public void closeStatement(StatementHandle var1);

    public void openConnection(ConnectionHandle var1, Map<String, String> var2);

    public void closeConnection(ConnectionHandle var1);

    public boolean syncResults(StatementHandle var1, QueryState var2, long var3) throws NoSuchStatementException;

    public void commit(ConnectionHandle var1);

    public void rollback(ConnectionHandle var1);

    public ConnectionProperties connectionSync(ConnectionHandle var1, ConnectionProperties var2);

    public static enum StatementType {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        UPSERT,
        MERGE,
        OTHER_DML,
        IS_DML,
        CREATE,
        DROP,
        ALTER,
        OTHER_DDL,
        CALL;


        public boolean canUpdate() {
            switch (this) {
                case INSERT: {
                    return true;
                }
                case IS_DML: {
                    return true;
                }
            }
            return false;
        }

        public Common.StatementType toProto() {
            return Common.StatementType.valueOf(this.name());
        }

        public static StatementType fromProto(Common.StatementType proto) {
            return StatementType.valueOf(proto.name());
        }
    }

    public static interface PrepareCallback {
        public Object getMonitor();

        public void clear() throws SQLException;

        public void assign(Signature var1, Frame var2, long var3) throws SQLException;

        public void execute() throws SQLException;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="connProps", defaultImpl=ConnectionPropertiesImpl.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ConnectionPropertiesImpl.class, name="connPropsImpl")})
    public static interface ConnectionProperties {
        public ConnectionProperties merge(ConnectionProperties var1);

        @JsonIgnore
        public boolean isEmpty();

        public ConnectionProperties setAutoCommit(boolean var1);

        public Boolean isAutoCommit();

        public ConnectionProperties setReadOnly(boolean var1);

        public Boolean isReadOnly();

        public ConnectionProperties setTransactionIsolation(int var1);

        public Integer getTransactionIsolation();

        public ConnectionProperties setCatalog(String var1);

        public String getCatalog();

        public ConnectionProperties setSchema(String var1);

        public String getSchema();

        public Common.ConnectionProperties toProto();
    }

    public static class StatementHandle {
        private static final Descriptors.FieldDescriptor SIGNATURE_DESCRIPTOR = Common.StatementHandle.getDescriptor().findFieldByNumber(3);
        public final String connectionId;
        public final int id;
        public Signature signature;

        public String toString() {
            return this.connectionId + "::" + Integer.toString(this.id);
        }

        @JsonCreator
        public StatementHandle(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="id") int id, @JsonProperty(value="signature") Signature signature) {
            this.connectionId = connectionId;
            this.id = id;
            this.signature = signature;
        }

        public Common.StatementHandle toProto() {
            Common.StatementHandle.Builder builder = Common.StatementHandle.newBuilder().setConnectionId(this.connectionId).setId(this.id);
            if (null != this.signature) {
                builder.setSignature(this.signature.toProto());
            }
            return builder.build();
        }

        public static StatementHandle fromProto(Common.StatementHandle protoHandle) {
            Signature signature = null;
            if (protoHandle.hasField(SIGNATURE_DESCRIPTOR)) {
                signature = Signature.fromProto(protoHandle.getSignature());
            }
            return new StatementHandle(protoHandle.getConnectionId(), protoHandle.getId(), signature);
        }

        public int hashCode() {
            return Objects.hash(this.connectionId, this.id, this.signature);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof StatementHandle && Objects.equals(this.connectionId, ((StatementHandle)o).connectionId) && Objects.equals(this.signature, ((StatementHandle)o).signature) && this.id == ((StatementHandle)o).id;
        }
    }

    public static class ConnectionHandle {
        public final String id;

        public String toString() {
            return this.id;
        }

        @JsonCreator
        public ConnectionHandle(@JsonProperty(value="id") String id) {
            this.id = id;
        }
    }

    public static class Frame {
        private static final Descriptors.FieldDescriptor HAS_ARRAY_VALUE_DESCRIPTOR = Common.ColumnValue.getDescriptor().findFieldByNumber(3);
        private static final Descriptors.FieldDescriptor SCALAR_VALUE_DESCRIPTOR = Common.ColumnValue.getDescriptor().findFieldByNumber(4);
        public static final Frame EMPTY = new Frame(0L, true, Collections.emptyList());
        public static final Frame MORE = new Frame(0L, false, Collections.emptyList());
        public final long offset;
        public final boolean done;
        public final Iterable<Object> rows;

        public Frame(long offset, boolean done, Iterable<Object> rows) {
            this.offset = offset;
            this.done = done;
            this.rows = rows;
        }

        @JsonCreator
        public static Frame create(@JsonProperty(value="offset") long offset, @JsonProperty(value="done") boolean done, @JsonProperty(value="rows") List<Object> rows) {
            if (offset == 0L && done && rows.isEmpty()) {
                return EMPTY;
            }
            return new Frame(offset, done, rows);
        }

        public Common.Frame toProto() {
            Common.Frame.Builder builder = Common.Frame.newBuilder();
            builder.setDone(this.done).setOffset(this.offset);
            for (Object row : this.rows) {
                if (null == row) continue;
                Common.Row.Builder rowBuilder = Common.Row.newBuilder();
                if (row instanceof Object[]) {
                    for (Object element : (Object[])row) {
                        Frame.parseColumn(rowBuilder, element);
                    }
                } else if (row instanceof Iterable) {
                    for (Object element : (Iterable)row) {
                        Frame.parseColumn(rowBuilder, element);
                    }
                } else {
                    throw new RuntimeException("Only arrays are supported");
                }
                builder.addRows(rowBuilder.build());
            }
            return builder.build();
        }

        static void parseColumn(Common.Row.Builder rowBuilder, Object column) {
            Common.ColumnValue.Builder columnBuilder = Common.ColumnValue.newBuilder();
            if (column instanceof List) {
                columnBuilder.setHasArrayValue(true);
                List list = (List)column;
                for (Object listItem : list) {
                    Common.TypedValue scalarListItem = Frame.serializeScalar(listItem);
                    columnBuilder.addArrayValue(scalarListItem);
                    columnBuilder.addValue(scalarListItem);
                }
            } else {
                columnBuilder.setHasArrayValue(false);
                Common.TypedValue scalarVal = Frame.serializeScalar(column);
                columnBuilder.setScalarValue(scalarVal);
                columnBuilder.addValue(scalarVal);
            }
            rowBuilder.addValue(columnBuilder.build());
        }

        static Common.TypedValue serializeScalar(Object element) {
            Common.TypedValue.Builder valueBuilder = Common.TypedValue.newBuilder();
            TypedValue.toProto(valueBuilder, element);
            return valueBuilder.build();
        }

        public static Frame fromProto(Common.Frame proto) {
            ArrayList<Object> parsedRows = new ArrayList<Object>(proto.getRowsCount());
            for (Common.Row protoRow : proto.getRowsList()) {
                ArrayList<Object> row = new ArrayList<Object>(protoRow.getValueCount());
                for (Common.ColumnValue protoColumn : protoRow.getValueList()) {
                    Object value = !Frame.isNewStyleColumn(protoColumn) ? Frame.parseOldStyleColumn(protoColumn) : Frame.parseColumn(protoColumn);
                    row.add(value);
                }
                parsedRows.add(row);
            }
            return new Frame(proto.getOffset(), proto.getDone(), parsedRows);
        }

        static boolean isNewStyleColumn(Common.ColumnValue column) {
            return column.hasField(HAS_ARRAY_VALUE_DESCRIPTOR) || column.hasField(SCALAR_VALUE_DESCRIPTOR);
        }

        static Object parseOldStyleColumn(Common.ColumnValue column) {
            if (column.getValueCount() > 1) {
                ArrayList<Object> array = new ArrayList<Object>(column.getValueCount());
                for (Common.TypedValue columnValue : column.getValueList()) {
                    array.add(Frame.deserializeScalarValue(columnValue));
                }
                return array;
            }
            return Frame.deserializeScalarValue(column.getValue(0));
        }

        static Object parseColumn(Common.ColumnValue column) {
            Frame.validateColumnValue(column);
            if (!column.hasField(SCALAR_VALUE_DESCRIPTOR)) {
                ArrayList<Object> array = new ArrayList<Object>(column.getArrayValueCount());
                for (Common.TypedValue arrayValue : column.getArrayValueList()) {
                    if (Common.Rep.ARRAY == arrayValue.getType()) {
                        array.add(Frame.parseArray(arrayValue));
                        continue;
                    }
                    array.add(Frame.deserializeScalarValue(arrayValue));
                }
                return array;
            }
            return Frame.deserializeScalarValue(column.getScalarValue());
        }

        static Object parseArray(Common.TypedValue array) {
            ArrayList<Object> convertedArray = new ArrayList<Object>(array.getArrayValueCount());
            for (Common.TypedValue arrayElement : array.getArrayValueList()) {
                if (Common.Rep.ARRAY == arrayElement.getType()) {
                    convertedArray.add(Frame.parseArray(arrayElement));
                    continue;
                }
                convertedArray.add(Frame.deserializeScalarValue(arrayElement));
            }
            return convertedArray;
        }

        static void validateColumnValue(Common.ColumnValue column) {
            boolean hasArrayValue;
            boolean hasScalar = column.hasField(SCALAR_VALUE_DESCRIPTOR);
            if (hasScalar == (hasArrayValue = column.getHasArrayValue())) {
                throw new IllegalArgumentException("A column must have a scalar or array value, not " + (hasScalar ? "both" : "neither"));
            }
        }

        static Object deserializeScalarValue(Common.TypedValue protoElement) {
            if (Common.Rep.BYTE_STRING == protoElement.getType()) {
                return protoElement.getBytesValue().toByteArray();
            }
            return TypedValue.fromProto((Common.TypedValue)protoElement).value;
        }

        public int hashCode() {
            return Objects.hash(this.done, this.offset, this.rows);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Frame && Frame.equalRows(this.rows, ((Frame)o).rows) && this.offset == ((Frame)o).offset && this.done == ((Frame)o).done;
        }

        private static boolean equalRows(Iterable<Object> rows, Iterable<Object> otherRows) {
            if (null == rows) {
                if (null != otherRows) {
                    return false;
                }
            } else {
                Iterator<Object> iter1 = rows.iterator();
                Iterator<Object> iter2 = otherRows.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    List obj1List;
                    Object obj1 = iter1.next();
                    Object obj2 = iter2.next();
                    if (obj1 instanceof Object[]) {
                        if (obj2 instanceof Object[]) {
                            if (Arrays.equals((Object[])obj1, (Object[])obj2)) continue;
                            return false;
                        }
                        if (obj2 instanceof List) {
                            List obj2List = (List)obj2;
                            if (Arrays.equals((Object[])obj1, obj2List.toArray())) continue;
                            return false;
                        }
                        return false;
                    }
                    if (!(obj1 instanceof List ? (obj2 instanceof Object[] ? !Arrays.equals((obj1List = (List)obj1).toArray(), (Object[])obj2) : !obj1.equals(obj2)) : !obj1.equals(obj2))) continue;
                    return false;
                }
                if (iter1.hasNext() || iter2.hasNext()) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class Signature {
        private static final Descriptors.FieldDescriptor SQL_DESCRIPTOR = Common.Signature.getDescriptor().findFieldByNumber(2);
        private static final Descriptors.FieldDescriptor CURSOR_FACTORY_DESCRIPTOR = Common.Signature.getDescriptor().findFieldByNumber(4);
        public final List<ColumnMetaData> columns;
        public final String sql;
        public final List<AvaticaParameter> parameters;
        public final transient Map<String, Object> internalParameters;
        public final CursorFactory cursorFactory;
        public final StatementType statementType;

        public Signature(List<ColumnMetaData> columns, String sql, List<AvaticaParameter> parameters, Map<String, Object> internalParameters, CursorFactory cursorFactory, StatementType statementType) {
            this.columns = columns;
            this.sql = sql;
            this.parameters = parameters;
            this.internalParameters = internalParameters;
            this.cursorFactory = cursorFactory;
            this.statementType = statementType;
        }

        @JsonCreator
        public static Signature create(@JsonProperty(value="columns") List<ColumnMetaData> columns, @JsonProperty(value="sql") String sql, @JsonProperty(value="parameters") List<AvaticaParameter> parameters, @JsonProperty(value="cursorFactory") CursorFactory cursorFactory, @JsonProperty(value="statementType") StatementType statementType) {
            return new Signature(columns, sql, parameters, Collections.emptyMap(), cursorFactory, statementType);
        }

        public Signature setCursorFactory(CursorFactory cursorFactory) {
            return new Signature(this.columns, this.sql, this.parameters, this.internalParameters, cursorFactory, this.statementType);
        }

        public Signature sanitize() {
            if (this.columns == null || this.parameters == null || this.internalParameters == null || this.statementType == null) {
                return new Signature(this.sanitize(this.columns), this.sql, this.sanitize(this.parameters), this.sanitize(this.internalParameters), this.cursorFactory, StatementType.SELECT);
            }
            return this;
        }

        private <E> List<E> sanitize(List<E> list) {
            return list == null ? Collections.emptyList() : list;
        }

        private <K, V> Map<K, V> sanitize(Map<K, V> map) {
            return map == null ? Collections.emptyMap() : map;
        }

        public Common.Signature toProto() {
            Common.Signature.Builder builder = Common.Signature.newBuilder();
            if (null != this.sql) {
                builder.setSql(this.sql);
            }
            if (null != this.cursorFactory) {
                builder.setCursorFactory(this.cursorFactory.toProto());
            }
            if (null != this.columns) {
                for (ColumnMetaData column : this.columns) {
                    builder.addColumns(column.toProto());
                }
            }
            if (null != this.parameters) {
                for (AvaticaParameter parameter : this.parameters) {
                    builder.addParameters(parameter.toProto());
                }
            }
            return builder.build();
        }

        /*
         * WARNING - void declaration
         */
        public static Signature fromProto(Common.Signature protoSignature) {
            void var3_7;
            ArrayList<ColumnMetaData> metadata = new ArrayList<ColumnMetaData>(protoSignature.getColumnsCount());
            for (Common.ColumnMetaData columnMetaData : protoSignature.getColumnsList()) {
                metadata.add(ColumnMetaData.fromProto(columnMetaData));
            }
            ArrayList<AvaticaParameter> parameters = new ArrayList<AvaticaParameter>(protoSignature.getParametersCount());
            for (Common.AvaticaParameter protoParam : protoSignature.getParametersList()) {
                parameters.add(AvaticaParameter.fromProto(protoParam));
            }
            Object var3_5 = null;
            if (protoSignature.hasField(SQL_DESCRIPTOR)) {
                String string = protoSignature.getSql();
            }
            CursorFactory cursorFactory = null;
            if (protoSignature.hasField(CURSOR_FACTORY_DESCRIPTOR)) {
                cursorFactory = CursorFactory.fromProto(protoSignature.getCursorFactory());
            }
            StatementType statementType = StatementType.fromProto(protoSignature.getStatementType());
            return Signature.create(metadata, (String)var3_7, parameters, cursorFactory, statementType);
        }

        public int hashCode() {
            return Objects.hash(this.columns, this.cursorFactory, this.parameters, this.sql);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Signature && Objects.equals(this.columns, ((Signature)o).columns) && Objects.equals(this.cursorFactory, ((Signature)o).cursorFactory) && Objects.equals(this.parameters, ((Signature)o).parameters) && Objects.equals(this.sql, ((Signature)o).sql);
        }
    }

    public static enum Style {
        OBJECT,
        RECORD,
        ARRAY,
        LIST,
        MAP;


        public Common.CursorFactory.Style toProto() {
            return Common.CursorFactory.Style.valueOf(this.name());
        }

        public static Style fromProto(Common.CursorFactory.Style proto) {
            return Style.valueOf(proto.name());
        }
    }

    public static final class CursorFactory {
        private static final Descriptors.FieldDescriptor CLASS_NAME_DESCRIPTOR = Common.CursorFactory.getDescriptor().findFieldByNumber(2);
        public final Style style;
        public final Class clazz;
        @JsonIgnore
        public final List<Field> fields;
        public final List<String> fieldNames;
        public static final CursorFactory OBJECT = new CursorFactory(Style.OBJECT, null, null, null);
        public static final CursorFactory ARRAY = new CursorFactory(Style.ARRAY, null, null, null);
        public static final CursorFactory LIST = new CursorFactory(Style.LIST, null, null, null);

        private CursorFactory(Style style, Class clazz, List<Field> fields, List<String> fieldNames) {
            assert (fieldNames != null == (style == Style.RECORD || style == Style.MAP));
            assert (fields != null == (style == Style.RECORD));
            this.style = Objects.requireNonNull(style);
            this.clazz = clazz;
            this.fields = fields;
            this.fieldNames = fieldNames;
        }

        @JsonCreator
        public static CursorFactory create(@JsonProperty(value="style") Style style, @JsonProperty(value="clazz") Class clazz, @JsonProperty(value="fieldNames") List<String> fieldNames) {
            switch (style) {
                case OBJECT: {
                    return OBJECT;
                }
                case ARRAY: {
                    return ARRAY;
                }
                case LIST: {
                    return LIST;
                }
                case RECORD: {
                    return CursorFactory.record(clazz, null, fieldNames);
                }
                case MAP: {
                    return CursorFactory.map(fieldNames);
                }
            }
            throw new AssertionError((Object)("unknown style: " + (Object)((Object)style)));
        }

        @Deprecated
        public static CursorFactory record(Class resultClazz) {
            List<Field> fields = Arrays.asList(resultClazz.getFields());
            return new CursorFactory(Style.RECORD, resultClazz, fields, null);
        }

        public static CursorFactory record(Class resultClass, List<Field> fields, List<String> fieldNames) {
            if (fields == null) {
                fields = new ArrayList<Field>();
                for (String fieldName : fieldNames) {
                    try {
                        fields.add(resultClass.getField(fieldName));
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return new CursorFactory(Style.RECORD, resultClass, fields, fieldNames);
        }

        public static CursorFactory map(List<String> fieldNames) {
            return new CursorFactory(Style.MAP, null, null, fieldNames);
        }

        public static CursorFactory deduce(List<ColumnMetaData> columns, Class resultClazz) {
            if (columns.size() == 1) {
                return OBJECT;
            }
            if (resultClazz == null) {
                return ARRAY;
            }
            if (resultClazz.isArray()) {
                return ARRAY;
            }
            if (List.class.isAssignableFrom(resultClazz)) {
                return LIST;
            }
            return CursorFactory.record(resultClazz, null, columns.stream().map(c -> c.columnName).collect(Collectors.toList()));
        }

        public Common.CursorFactory toProto() {
            Common.CursorFactory.Builder builder = Common.CursorFactory.newBuilder();
            if (null != this.clazz) {
                builder.setClassName(this.clazz.getName());
            }
            builder.setStyle(this.style.toProto());
            if (null != this.fieldNames) {
                builder.addAllFieldNames(this.fieldNames);
            }
            return builder.build();
        }

        public static CursorFactory fromProto(Common.CursorFactory proto) {
            Class<?> clz = null;
            if (proto.hasField(CLASS_NAME_DESCRIPTOR)) {
                try {
                    clz = Class.forName(proto.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return CursorFactory.create(Style.fromProto(proto.getStyle()), clz, proto.getFieldNamesList());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.clazz, this.fieldNames, this.fields, this.style});
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CursorFactory && Objects.equals(this.clazz, ((CursorFactory)o).clazz) && Objects.equals(this.fieldNames, ((CursorFactory)o).fieldNames) && Objects.equals(this.fields, ((CursorFactory)o).fields) && this.style == ((CursorFactory)o).style;
        }
    }

    public static class MetaResultSet {
        public final String connectionId;
        public final int statementId;
        public final boolean ownStatement;
        public final Frame firstFrame;
        public final Signature signature;
        public final long updateCount;

        @Deprecated
        protected MetaResultSet(String connectionId, int statementId, boolean ownStatement, Signature signature, Frame firstFrame, int updateCount) {
            this(connectionId, statementId, ownStatement, signature, firstFrame, (long)updateCount);
        }

        protected MetaResultSet(String connectionId, int statementId, boolean ownStatement, Signature signature, Frame firstFrame, long updateCount) {
            this.signature = signature;
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.ownStatement = ownStatement;
            this.firstFrame = firstFrame;
            this.updateCount = updateCount;
        }

        public static MetaResultSet create(String connectionId, int statementId, boolean ownStatement, Signature signature, Frame firstFrame) {
            return new MetaResultSet(connectionId, statementId, ownStatement, Objects.requireNonNull(signature), firstFrame, -1L);
        }

        public static MetaResultSet create(String connectionId, int statementId, boolean ownStatement, Signature signature, Frame firstFrame, long updateCount) {
            return new MetaResultSet(connectionId, statementId, ownStatement, Objects.requireNonNull(signature), firstFrame, updateCount);
        }

        public static MetaResultSet count(String connectionId, int statementId, long updateCount) {
            assert (updateCount >= 0L) : "Meta.count(" + connectionId + ", " + statementId + ", " + updateCount + ")";
            return new MetaResultSet(connectionId, statementId, false, null, null, updateCount);
        }
    }

    public static class ExecuteBatchResult {
        public final long[] updateCounts;

        public ExecuteBatchResult(long[] updateCounts) {
            this.updateCounts = Objects.requireNonNull(updateCounts);
        }
    }

    public static class ExecuteResult {
        public final List<MetaResultSet> resultSets;

        public ExecuteResult(List<MetaResultSet> resultSets) {
            this.resultSets = resultSets;
        }
    }

    public static final class DatabaseProperty
    extends Enum<DatabaseProperty> {
        public static final /* enum */ DatabaseProperty GET_NUMERIC_FUNCTIONS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_STRING_FUNCTIONS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_SYSTEM_FUNCTIONS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_TIME_DATE_FUNCTIONS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_S_Q_L_KEYWORDS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_DEFAULT_TRANSACTION_ISOLATION = new DatabaseProperty(0);
        public static final /* enum */ DatabaseProperty AVATICA_VERSION = new DatabaseProperty("1.26.0");
        public static final /* enum */ DatabaseProperty GET_DRIVER_VERSION = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_DRIVER_MINOR_VERSION = new DatabaseProperty(-1);
        public static final /* enum */ DatabaseProperty GET_DRIVER_MAJOR_VERSION = new DatabaseProperty(-1);
        public static final /* enum */ DatabaseProperty GET_DRIVER_NAME = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_DATABASE_MINOR_VERSION = new DatabaseProperty(-1);
        public static final /* enum */ DatabaseProperty GET_DATABASE_MAJOR_VERSION = new DatabaseProperty(-1);
        public static final /* enum */ DatabaseProperty GET_DATABASE_PRODUCT_NAME = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_DATABASE_PRODUCT_VERSION = new DatabaseProperty("");
        public final Class<?> type;
        public final Object defaultValue;
        public final Method method;
        public final boolean isJdbc;
        private static final /* synthetic */ DatabaseProperty[] $VALUES;

        public static DatabaseProperty[] values() {
            return (DatabaseProperty[])$VALUES.clone();
        }

        public static DatabaseProperty valueOf(String name) {
            return Enum.valueOf(DatabaseProperty.class, name);
        }

        private <T> DatabaseProperty(T defaultValue) {
            this.defaultValue = defaultValue;
            String methodName = AvaticaUtils.toCamelCase(this.name());
            Method localMethod = null;
            try {
                localMethod = DatabaseMetaData.class.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (null == localMethod) {
                this.method = null;
                this.type = null;
                this.isJdbc = false;
            } else {
                this.method = localMethod;
                this.type = AvaticaUtils.box(this.method.getReturnType());
                this.isJdbc = true;
            }
            assert (!this.isJdbc || defaultValue == null || defaultValue.getClass() == this.type);
        }

        public <T> T getProp(Meta meta, ConnectionHandle ch, Class<T> aClass) {
            return this.getProp(meta.getDatabaseProperties(ch), aClass);
        }

        public <T> T getProp(Map<DatabaseProperty, Object> map, Class<T> aClass) {
            assert (aClass == this.type);
            Object v = map.get((Object)this);
            if (v == null) {
                v = this.defaultValue;
            }
            return aClass.cast(v);
        }

        public static DatabaseProperty fromProto(Common.DatabaseProperty proto) {
            return DatabaseProperty.valueOf(proto.getName());
        }

        public Common.DatabaseProperty toProto() {
            return Common.DatabaseProperty.newBuilder().setName(this.name()).build();
        }

        static {
            $VALUES = new DatabaseProperty[]{GET_NUMERIC_FUNCTIONS, GET_STRING_FUNCTIONS, GET_SYSTEM_FUNCTIONS, GET_TIME_DATE_FUNCTIONS, GET_S_Q_L_KEYWORDS, GET_DEFAULT_TRANSACTION_ISOLATION, AVATICA_VERSION, GET_DRIVER_VERSION, GET_DRIVER_MINOR_VERSION, GET_DRIVER_MAJOR_VERSION, GET_DRIVER_NAME, GET_DATABASE_MINOR_VERSION, GET_DATABASE_MAJOR_VERSION, GET_DATABASE_PRODUCT_NAME, GET_DATABASE_PRODUCT_VERSION};
        }
    }

    public static class Pat {
        public final String s;

        private Pat(String s) {
            this.s = s;
        }

        public String toString() {
            return "Pat[" + this.s + "]";
        }

        @JsonCreator
        public static Pat of(@JsonProperty(value="s") String name) {
            return new Pat(name);
        }
    }

    public static interface Factory {
        public Meta create(List<String> var1);
    }
}

