/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.BlockCipher;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.engines.SEEDEngine;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.engines.SEEDWrapEngine;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.macs.CMac;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.macs.GMac;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.internal.asn1.kisa.KISAObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class SEED {
    private SEED() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SEED parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[16];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = this.createParametersInstance("SEED");
                algorithmParameters.init(new IvParameterSpec(byArray));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "SEED IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(128, new CBCBlockCipher(new SEEDEngine()), 128);
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new SEEDEngine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(128, new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new SEEDEngine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new SEEDEngine())));
        }
    }

    public static class KeyFactory
    extends BaseSecretKeyFactory {
        public KeyFactory() {
            super("SEED", null);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SEED", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = SEED.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("AlgorithmParameters.SEED", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            configurableProvider.addAlgorithm("AlgorithmParameterGenerator.SEED", PREFIX + "$AlgParamGen");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            configurableProvider.addAlgorithm("Cipher.SEED", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher", KISAObjectIdentifiers.id_seedCBC, PREFIX + "$CBC");
            configurableProvider.addAlgorithm("Cipher.SEEDWRAP", PREFIX + "$Wrap");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher", KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, "SEEDWRAP");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.SEEDKW", "SEEDWRAP");
            configurableProvider.addAlgorithm("KeyGenerator.SEED", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("KeyGenerator", KISAObjectIdentifiers.id_seedCBC, PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("KeyGenerator", KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("SecretKeyFactory.SEED", PREFIX + "$KeyFactory");
            configurableProvider.addAlgorithm("Alg.Alias.SecretKeyFactory", KISAObjectIdentifiers.id_seedCBC, "SEED");
            this.addCMacAlgorithm(configurableProvider, "SEED", PREFIX + "$CMAC", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(configurableProvider, "SEED", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(configurableProvider, "SEED", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.macs.Poly1305(new SEEDEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-SEED", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Wrap
    extends BaseWrapCipher {
        public Wrap() {
            super(128, new SEEDWrapEngine());
        }
    }
}

