/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @fileoverview Compact number formatting symbols.
 *
 * File generated from CLDR ver. 39
 *
 * To reduce the file size (which may cause issues in some JS
 * developing environments), this file will only contain locales
 * that are frequently used by web applications. This is defined as
 * proto/closure_locales_data.txt and will change (most likely addition)
 * over time.  Rest of the data can be found in another file named
 * "compactnumberformatsymbolsext.js", which will be generated at
 * the same time together with this file.
 *
 * @suppress {const,useOfGoogProvide}
 */

// clang-format off

goog.provide('goog.i18n.CompactNumberFormatSymbols');
goog.provide('goog.i18n.CompactNumberFormatSymbols_af');
goog.provide('goog.i18n.CompactNumberFormatSymbols_am');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_DZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_EG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_az');
goog.provide('goog.i18n.CompactNumberFormatSymbols_be');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bg');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_br');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bs');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca');
goog.provide('goog.i18n.CompactNumberFormatSymbols_chr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cs');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cy');
goog.provide('goog.i18n.CompactNumberFormatSymbols_da');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_AT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_el');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_AU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_CA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_IE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_ZA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_419');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_MX');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_et');
goog.provide('goog.i18n.CompactNumberFormatSymbols_eu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fa');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fi');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fil');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_CA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ga');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gsw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_haw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_he');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hi');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hy');
goog.provide('goog.i18n.CompactNumberFormatSymbols_id');
goog.provide('goog.i18n.CompactNumberFormatSymbols_in');
goog.provide('goog.i18n.CompactNumberFormatSymbols_is');
goog.provide('goog.i18n.CompactNumberFormatSymbols_it');
goog.provide('goog.i18n.CompactNumberFormatSymbols_iw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ja');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ka');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kk');
goog.provide('goog.i18n.CompactNumberFormatSymbols_km');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ko');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ky');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ln');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lt');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lv');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mk');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ml');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ms');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mt');
goog.provide('goog.i18n.CompactNumberFormatSymbols_my');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nb');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ne');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_no');
goog.provide('goog.i18n.CompactNumberFormatSymbols_no_NO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_or');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pa');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_BR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_PT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ro');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sh');
goog.provide('goog.i18n.CompactNumberFormatSymbols_si');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sk');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sq');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Latn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sv');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ta');
goog.provide('goog.i18n.CompactNumberFormatSymbols_te');
goog.provide('goog.i18n.CompactNumberFormatSymbols_th');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uk');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ur');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uz');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vi');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_CN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_HK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_TW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zu');


/**
 * Compact number formatting symbols for locale af.
 */
goog.i18n.CompactNumberFormatSymbols_af = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 k'
    },
    '10000': {
      'other': '00 k'
    },
    '100000': {
      'other': '000 k'
    },
    '1000000': {
      'other': '0 m'
    },
    '10000000': {
      'other': '00 m'
    },
    '100000000': {
      'other': '000 m'
    },
    '1000000000': {
      'other': '0 mjd'
    },
    '10000000000': {
      'other': '00 mjd'
    },
    '100000000000': {
      'other': '000 mjd'
    },
    '1000000000000': {
      'other': '0 bn'
    },
    '10000000000000': {
      'other': '00 bn'
    },
    '100000000000000': {
      'other': '000 bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 duisend'
    },
    '10000': {
      'other': '00 duisend'
    },
    '100000': {
      'other': '000 duisend'
    },
    '1000000': {
      'other': '0 miljoen'
    },
    '10000000': {
      'other': '00 miljoen'
    },
    '100000000': {
      'other': '000 miljoen'
    },
    '1000000000': {
      'other': '0 miljard'
    },
    '10000000000': {
      'other': '00 miljard'
    },
    '100000000000': {
      'other': '000 miljard'
    },
    '1000000000000': {
      'other': '0 biljoen'
    },
    '10000000000000': {
      'other': '00 biljoen'
    },
    '100000000000000': {
      'other': '000 biljoen'
    }
  }
};


/**
 * Compact number formatting symbols for locale am.
 */
goog.i18n.CompactNumberFormatSymbols_am = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 ሺ'
    },
    '10000': {
      'other': '00 ሺ'
    },
    '100000': {
      'other': '000 ሺ'
    },
    '1000000': {
      'other': '0 ሚ'
    },
    '10000000': {
      'other': '00 ሚ'
    },
    '100000000': {
      'other': '000 ሚ'
    },
    '1000000000': {
      'other': '0 ቢ'
    },
    '10000000000': {
      'other': '00 ቢ'
    },
    '100000000000': {
      'other': '000 ቢ'
    },
    '1000000000000': {
      'other': '0 ት'
    },
    '10000000000000': {
      'other': '00 ት'
    },
    '100000000000000': {
      'other': '000 ት'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ሺ'
    },
    '10000': {
      'other': '00 ሺ'
    },
    '100000': {
      'other': '000 ሺ'
    },
    '1000000': {
      'other': '0 ሚሊዮን'
    },
    '10000000': {
      'other': '00 ሚሊዮን'
    },
    '100000000': {
      'other': '000 ሚሊዮን'
    },
    '1000000000': {
      'other': '0 ቢሊዮን'
    },
    '10000000000': {
      'other': '00 ቢሊዮን'
    },
    '100000000000': {
      'other': '000 ቢሊዮን'
    },
    '1000000000000': {
      'other': '0 ትሪሊዮን'
    },
    '10000000000000': {
      'other': '00 ትሪሊዮን'
    },
    '100000000000000': {
      'other': '000 ትሪሊዮን'
    }
  }
};


/**
 * Compact number formatting symbols for locale ar.
 */
goog.i18n.CompactNumberFormatSymbols_ar = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 ألف'
    },
    '10000': {
      'other': '00 ألف'
    },
    '100000': {
      'other': '000 ألف'
    },
    '1000000': {
      'other': '0 مليون'
    },
    '10000000': {
      'other': '00 مليون'
    },
    '100000000': {
      'other': '000 مليون'
    },
    '1000000000': {
      'other': '0 مليار'
    },
    '10000000000': {
      'other': '00 مليار'
    },
    '100000000000': {
      'other': '000 مليار'
    },
    '1000000000000': {
      'other': '0 ترليون'
    },
    '10000000000000': {
      'other': '00 ترليون'
    },
    '100000000000000': {
      'other': '000 ترليون'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ألف'
    },
    '10000': {
      'other': '00 ألف'
    },
    '100000': {
      'other': '000 ألف'
    },
    '1000000': {
      'other': '0 مليون'
    },
    '10000000': {
      'other': '00 مليون'
    },
    '100000000': {
      'other': '000 مليون'
    },
    '1000000000': {
      'other': '0 مليار'
    },
    '10000000000': {
      'other': '00 مليار'
    },
    '100000000000': {
      'other': '000 مليار'
    },
    '1000000000000': {
      'other': '0 ترليون'
    },
    '10000000000000': {
      'other': '00 ترليون'
    },
    '100000000000000': {
      'other': '000 ترليون'
    }
  }
};


/**
 * Compact number formatting symbols for locale ar_DZ.
 */
goog.i18n.CompactNumberFormatSymbols_ar_DZ = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_EG.
 */
goog.i18n.CompactNumberFormatSymbols_ar_EG = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale az.
 */
goog.i18n.CompactNumberFormatSymbols_az = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0 mln'
    },
    '10000000': {
      'other': '00 mln'
    },
    '100000000': {
      'other': '000 mln'
    },
    '1000000000': {
      'other': '0 mlrd'
    },
    '10000000000': {
      'other': '00 mlrd'
    },
    '100000000000': {
      'other': '000 mlrd'
    },
    '1000000000000': {
      'other': '0 trln'
    },
    '10000000000000': {
      'other': '00 trln'
    },
    '100000000000000': {
      'other': '000 trln'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 min'
    },
    '10000': {
      'other': '00 min'
    },
    '100000': {
      'other': '000 min'
    },
    '1000000': {
      'other': '0 milyon'
    },
    '10000000': {
      'other': '00 milyon'
    },
    '100000000': {
      'other': '000 milyon'
    },
    '1000000000': {
      'other': '0 milyard'
    },
    '10000000000': {
      'other': '00 milyard'
    },
    '100000000000': {
      'other': '000 milyard'
    },
    '1000000000000': {
      'other': '0 trilyon'
    },
    '10000000000000': {
      'other': '00 trilyon'
    },
    '100000000000000': {
      'other': '000 trilyon'
    }
  }
};


/**
 * Compact number formatting symbols for locale be.
 */
goog.i18n.CompactNumberFormatSymbols_be = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 тыс.'
    },
    '10000': {
      'other': '00 тыс.'
    },
    '100000': {
      'other': '000 тыс.'
    },
    '1000000': {
      'other': '0 млн'
    },
    '10000000': {
      'other': '00 млн'
    },
    '100000000': {
      'other': '000 млн'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 трлн'
    },
    '10000000000000': {
      'other': '00 трлн'
    },
    '100000000000000': {
      'other': '000 трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 тысячы'
    },
    '10000': {
      'other': '00 тысячы'
    },
    '100000': {
      'other': '000 тысячы'
    },
    '1000000': {
      'other': '0 мільёна'
    },
    '10000000': {
      'other': '00 мільёна'
    },
    '100000000': {
      'other': '000 мільёна'
    },
    '1000000000': {
      'other': '0 мільярда'
    },
    '10000000000': {
      'other': '00 мільярда'
    },
    '100000000000': {
      'other': '000 мільярда'
    },
    '1000000000000': {
      'other': '0 трыльёна'
    },
    '10000000000000': {
      'other': '00 трыльёна'
    },
    '100000000000000': {
      'other': '000 трыльёна'
    }
  }
};


/**
 * Compact number formatting symbols for locale bg.
 */
goog.i18n.CompactNumberFormatSymbols_bg = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 хил.'
    },
    '10000': {
      'other': '00 хил.'
    },
    '100000': {
      'other': '000 хил.'
    },
    '1000000': {
      'other': '0 млн.'
    },
    '10000000': {
      'other': '00 млн.'
    },
    '100000000': {
      'other': '000 млн.'
    },
    '1000000000': {
      'other': '0 млрд.'
    },
    '10000000000': {
      'other': '00 млрд.'
    },
    '100000000000': {
      'other': '000 млрд.'
    },
    '1000000000000': {
      'other': '0 трлн.'
    },
    '10000000000000': {
      'other': '00 трлн.'
    },
    '100000000000000': {
      'other': '000 трлн.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 хиляди'
    },
    '10000': {
      'other': '00 хиляди'
    },
    '100000': {
      'other': '000 хиляди'
    },
    '1000000': {
      'other': '0 милиона'
    },
    '10000000': {
      'other': '00 милиона'
    },
    '100000000': {
      'other': '000 милиона'
    },
    '1000000000': {
      'other': '0 милиарда'
    },
    '10000000000': {
      'other': '00 милиарда'
    },
    '100000000000': {
      'other': '000 милиарда'
    },
    '1000000000000': {
      'other': '0 трилиона'
    },
    '10000000000000': {
      'other': '00 трилиона'
    },
    '100000000000000': {
      'other': '000 трилиона'
    }
  }
};


/**
 * Compact number formatting symbols for locale bn.
 */
goog.i18n.CompactNumberFormatSymbols_bn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 হা'
    },
    '10000': {
      'other': '00 হা'
    },
    '100000': {
      'other': '0 লা'
    },
    '1000000': {
      'other': '00 লা'
    },
    '10000000': {
      'other': '0 কো'
    },
    '100000000': {
      'other': '00 কো'
    },
    '1000000000': {
      'other': '000 কো'
    },
    '10000000000': {
      'other': '00শত কো'
    },
    '100000000000': {
      'other': '000কো'
    },
    '1000000000000': {
      'other': '0 লা.কো.'
    },
    '10000000000000': {
      'other': '00 লা.কো.'
    },
    '100000000000000': {
      'other': '000 লা.কো.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 হাজার'
    },
    '10000': {
      'other': '00 হাজার'
    },
    '100000': {
      'other': '0 লাখ'
    },
    '1000000': {
      'other': '00 লাখ'
    },
    '10000000': {
      'other': '0 কোটি'
    },
    '100000000': {
      'other': '00 কোটি'
    },
    '1000000000': {
      'other': '000 কোটি'
    },
    '10000000000': {
      'other': '0000 কোটি'
    },
    '100000000000': {
      'other': '00000 কোটি'
    },
    '1000000000000': {
      'other': '0 লাখ কোটি'
    },
    '10000000000000': {
      'other': '00 লাখ কোটি'
    },
    '100000000000000': {
      'other': '000 লাখ কোটি'
    }
  }
};


/**
 * Compact number formatting symbols for locale br.
 */
goog.i18n.CompactNumberFormatSymbols_br = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 miliad'
    },
    '10000': {
      'other': '00 miliad'
    },
    '100000': {
      'other': '000 miliad'
    },
    '1000000': {
      'other': '0 milion'
    },
    '10000000': {
      'other': '00 milion'
    },
    '100000000': {
      'other': '000 milion'
    },
    '1000000000': {
      'other': '0 miliard'
    },
    '10000000000': {
      'other': '00 miliard'
    },
    '100000000000': {
      'other': '000 miliard'
    },
    '1000000000000': {
      'other': '0 bilion'
    },
    '10000000000000': {
      'other': '00 bilion'
    },
    '100000000000000': {
      'other': '000 bilion'
    }
  }
};


/**
 * Compact number formatting symbols for locale bs.
 */
goog.i18n.CompactNumberFormatSymbols_bs = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 hilj.'
    },
    '10000': {
      'other': '00 hilj.'
    },
    '100000': {
      'other': '000 hilj.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mlr.'
    },
    '10000000000': {
      'other': '00 mlr.'
    },
    '100000000000': {
      'other': '000 mlr.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 hiljada'
    },
    '10000': {
      'other': '00 hiljada'
    },
    '100000': {
      'other': '000 hiljada'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale ca.
 */
goog.i18n.CompactNumberFormatSymbols_ca = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0m'
    },
    '10000': {
      'other': '00m'
    },
    '100000': {
      'other': '000m'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0000 M'
    },
    '10000000000': {
      'other': '00mM'
    },
    '100000000000': {
      'other': '000mM'
    },
    '1000000000000': {
      'other': '0 B'
    },
    '10000000000000': {
      'other': '00 B'
    },
    '100000000000000': {
      'other': '000 B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 milers'
    },
    '10000': {
      'other': '00 milers'
    },
    '100000': {
      'other': '000 milers'
    },
    '1000000': {
      'other': '0 milions'
    },
    '10000000': {
      'other': '00 milions'
    },
    '100000000': {
      'other': '000 milions'
    },
    '1000000000': {
      'other': '0 milers de milions'
    },
    '10000000000': {
      'other': '00 milers de milions'
    },
    '100000000000': {
      'other': '000 milers de milions'
    },
    '1000000000000': {
      'other': '0 bilions'
    },
    '10000000000000': {
      'other': '00 bilions'
    },
    '100000000000000': {
      'other': '000 bilions'
    }
  }
};


/**
 * Compact number formatting symbols for locale chr.
 */
goog.i18n.CompactNumberFormatSymbols_chr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ᎢᏯᎦᏴᎵ'
    },
    '10000': {
      'other': '00 ᎢᏯᎦᏴᎵ'
    },
    '100000': {
      'other': '000 ᎢᏯᎦᏴᎵ'
    },
    '1000000': {
      'other': '0 ᎢᏳᏆᏗᏅᏛ'
    },
    '10000000': {
      'other': '00 ᎢᏳᏆᏗᏅᏛ'
    },
    '100000000': {
      'other': '000 ᎢᏳᏆᏗᏅᏛ'
    },
    '1000000000': {
      'other': '0 ᎢᏯᏔᎳᏗᏅᏛ'
    },
    '10000000000': {
      'other': '00 ᎢᏯᏔᎳᏗᏅᏛ'
    },
    '100000000000': {
      'other': '000 ᎢᏯᏔᎳᏗᏅᏛ'
    },
    '1000000000000': {
      'other': '0 ᎢᏯᏦᎠᏗᏅᏛ'
    },
    '10000000000000': {
      'other': '00 ᎢᏯᏦᎠᏗᏅᏛ'
    },
    '100000000000000': {
      'other': '000 ᎢᏯᏦᎠᏗᏅᏛ'
    }
  }
};


/**
 * Compact number formatting symbols for locale cs.
 */
goog.i18n.CompactNumberFormatSymbols_cs = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tis.'
    },
    '10000': {
      'other': '00 tis.'
    },
    '100000': {
      'other': '000 tis.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mld.'
    },
    '10000000000': {
      'other': '00 mld.'
    },
    '100000000000': {
      'other': '000 mld.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tisíc'
    },
    '10000': {
      'other': '00 tisíc'
    },
    '100000': {
      'other': '000 tisíc'
    },
    '1000000': {
      'other': '0 milionů'
    },
    '10000000': {
      'other': '00 milionů'
    },
    '100000000': {
      'other': '000 milionů'
    },
    '1000000000': {
      'other': '0 miliard'
    },
    '10000000000': {
      'other': '00 miliard'
    },
    '100000000000': {
      'other': '000 miliard'
    },
    '1000000000000': {
      'other': '0 bilionů'
    },
    '10000000000000': {
      'other': '00 bilionů'
    },
    '100000000000000': {
      'other': '000 bilionů'
    }
  }
};


/**
 * Compact number formatting symbols for locale cy.
 */
goog.i18n.CompactNumberFormatSymbols_cy = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 miliwn'
    },
    '10000000': {
      'other': '00 miliwn'
    },
    '100000000': {
      'other': '000 miliwn'
    },
    '1000000000': {
      'other': '0 biliwn'
    },
    '10000000000': {
      'other': '00 biliwn'
    },
    '100000000000': {
      'other': '000 biliwn'
    },
    '1000000000000': {
      'other': '0 triliwn'
    },
    '10000000000000': {
      'other': '00 triliwn'
    },
    '100000000000000': {
      'other': '000 triliwn'
    }
  }
};


/**
 * Compact number formatting symbols for locale da.
 */
goog.i18n.CompactNumberFormatSymbols_da = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 t'
    },
    '10000': {
      'other': '00 t'
    },
    '100000': {
      'other': '000 t'
    },
    '1000000': {
      'other': '0 mio.'
    },
    '10000000': {
      'other': '00 mio.'
    },
    '100000000': {
      'other': '000 mio.'
    },
    '1000000000': {
      'other': '0 mia.'
    },
    '10000000000': {
      'other': '00 mia.'
    },
    '100000000000': {
      'other': '000 mia.'
    },
    '1000000000000': {
      'other': '0 bio.'
    },
    '10000000000000': {
      'other': '00 bio.'
    },
    '100000000000000': {
      'other': '000 bio.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tusind'
    },
    '10000': {
      'other': '00 tusind'
    },
    '100000': {
      'other': '000 tusind'
    },
    '1000000': {
      'other': '0 millioner'
    },
    '10000000': {
      'other': '00 millioner'
    },
    '100000000': {
      'other': '000 millioner'
    },
    '1000000000': {
      'other': '0 milliarder'
    },
    '10000000000': {
      'other': '00 milliarder'
    },
    '100000000000': {
      'other': '000 milliarder'
    },
    '1000000000000': {
      'other': '0 billioner'
    },
    '10000000000000': {
      'other': '00 billioner'
    },
    '100000000000000': {
      'other': '000 billioner'
    }
  }
};


/**
 * Compact number formatting symbols for locale de.
 */
goog.i18n.CompactNumberFormatSymbols_de = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0'
    },
    '1000000': {
      'other': '0 Mio.'
    },
    '10000000': {
      'other': '00 Mio.'
    },
    '100000000': {
      'other': '000 Mio.'
    },
    '1000000000': {
      'other': '0 Mrd.'
    },
    '10000000000': {
      'other': '00 Mrd.'
    },
    '100000000000': {
      'other': '000 Mrd.'
    },
    '1000000000000': {
      'other': '0 Bio.'
    },
    '10000000000000': {
      'other': '00 Bio.'
    },
    '100000000000000': {
      'other': '000 Bio.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 Tausend'
    },
    '10000': {
      'other': '00 Tausend'
    },
    '100000': {
      'other': '000 Tausend'
    },
    '1000000': {
      'other': '0 Millionen'
    },
    '10000000': {
      'other': '00 Millionen'
    },
    '100000000': {
      'other': '000 Millionen'
    },
    '1000000000': {
      'other': '0 Milliarden'
    },
    '10000000000': {
      'other': '00 Milliarden'
    },
    '100000000000': {
      'other': '000 Milliarden'
    },
    '1000000000000': {
      'other': '0 Billionen'
    },
    '10000000000000': {
      'other': '00 Billionen'
    },
    '100000000000000': {
      'other': '000 Billionen'
    }
  }
};


/**
 * Compact number formatting symbols for locale de_AT.
 */
goog.i18n.CompactNumberFormatSymbols_de_AT = goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale de_CH.
 */
goog.i18n.CompactNumberFormatSymbols_de_CH = goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale el.
 */
goog.i18n.CompactNumberFormatSymbols_el = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 χιλ.'
    },
    '10000': {
      'other': '00 χιλ.'
    },
    '100000': {
      'other': '000 χιλ.'
    },
    '1000000': {
      'other': '0 εκ.'
    },
    '10000000': {
      'other': '00 εκ.'
    },
    '100000000': {
      'other': '000 εκ.'
    },
    '1000000000': {
      'other': '0 δισ.'
    },
    '10000000000': {
      'other': '00 δισ.'
    },
    '100000000000': {
      'other': '000 δισ.'
    },
    '1000000000000': {
      'other': '0 τρισ.'
    },
    '10000000000000': {
      'other': '00 τρισ.'
    },
    '100000000000000': {
      'other': '000 τρισ.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 χιλιάδες'
    },
    '10000': {
      'other': '00 χιλιάδες'
    },
    '100000': {
      'other': '000 χιλιάδες'
    },
    '1000000': {
      'other': '0 εκατομμύρια'
    },
    '10000000': {
      'other': '00 εκατομμύρια'
    },
    '100000000': {
      'other': '000 εκατομμύρια'
    },
    '1000000000': {
      'other': '0 δισεκατομμύρια'
    },
    '10000000000': {
      'other': '00 δισεκατομμύρια'
    },
    '100000000000': {
      'other': '000 δισεκατομμύρια'
    },
    '1000000000000': {
      'other': '0 τρισεκατομμύρια'
    },
    '10000000000000': {
      'other': '00 τρισεκατομμύρια'
    },
    '100000000000000': {
      'other': '000 τρισεκατομμύρια'
    }
  }
};


/**
 * Compact number formatting symbols for locale en.
 */
goog.i18n.CompactNumberFormatSymbols_en = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_AU.
 */
goog.i18n.CompactNumberFormatSymbols_en_AU = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_CA.
 */
goog.i18n.CompactNumberFormatSymbols_en_CA = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GB.
 */
goog.i18n.CompactNumberFormatSymbols_en_GB = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_IE.
 */
goog.i18n.CompactNumberFormatSymbols_en_IE = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_IN.
 */
goog.i18n.CompactNumberFormatSymbols_en_IN = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0T'
    },
    '10000': {
      'other': '00T'
    },
    '100000': {
      'other': '0L'
    },
    '1000000': {
      'other': '00L'
    },
    '10000000': {
      'other': '0Cr'
    },
    '100000000': {
      'other': '00Cr'
    },
    '1000000000': {
      'other': '000Cr'
    },
    '10000000000': {
      'other': '0TCr'
    },
    '100000000000': {
      'other': '00TCr'
    },
    '1000000000000': {
      'other': '0LCr'
    },
    '10000000000000': {
      'other': '00LCr'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_SG.
 */
goog.i18n.CompactNumberFormatSymbols_en_SG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_US.
 */
goog.i18n.CompactNumberFormatSymbols_en_US = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_ZA.
 */
goog.i18n.CompactNumberFormatSymbols_en_ZA = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale es.
 */
goog.i18n.CompactNumberFormatSymbols_es = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0000 M'
    },
    '10000000000': {
      'other': '00 mil M'
    },
    '100000000000': {
      'other': '000 mil M'
    },
    '1000000000000': {
      'other': '0 B'
    },
    '10000000000000': {
      'other': '00 B'
    },
    '100000000000000': {
      'other': '000 B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_419.
 */
goog.i18n.CompactNumberFormatSymbols_es_419 = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 K'
    },
    '10000': {
      'other': '00 k'
    },
    '100000': {
      'other': '000 k'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0000 M'
    },
    '10000000000': {
      'other': '00 mil M'
    },
    '100000000000': {
      'other': '000 mil M'
    },
    '1000000000000': {
      'other': '0 B'
    },
    '10000000000000': {
      'other': '00 B'
    },
    '100000000000000': {
      'other': '000 B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billón'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_ES.
 */
goog.i18n.CompactNumberFormatSymbols_es_ES = goog.i18n.CompactNumberFormatSymbols_es;


/**
 * Compact number formatting symbols for locale es_MX.
 */
goog.i18n.CompactNumberFormatSymbols_es_MX = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 k'
    },
    '10000': {
      'other': '00 k'
    },
    '100000': {
      'other': '000 k'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0000 M'
    },
    '10000000000': {
      'other': '00 mil M'
    },
    '100000000000': {
      'other': '000 mil M'
    },
    '1000000000000': {
      'other': '0 B'
    },
    '10000000000000': {
      'other': '00 B'
    },
    '100000000000000': {
      'other': '000 B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_US.
 */
goog.i18n.CompactNumberFormatSymbols_es_US = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 K'
    },
    '10000': {
      'other': '00 K'
    },
    '100000': {
      'other': '000 K'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 B'
    },
    '10000000000': {
      'other': '00 B'
    },
    '100000000000': {
      'other': '000 B'
    },
    '1000000000000': {
      'other': '0 T'
    },
    '10000000000000': {
      'other': '00 T'
    },
    '100000000000000': {
      'other': '000 T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 billones'
    },
    '10000000000': {
      'other': '00 billones'
    },
    '100000000000': {
      'other': '000 billones'
    },
    '1000000000000': {
      'other': '0 trillones'
    },
    '10000000000000': {
      'other': '00 trillones'
    },
    '100000000000000': {
      'other': '000 trillones'
    }
  }
};


/**
 * Compact number formatting symbols for locale et.
 */
goog.i18n.CompactNumberFormatSymbols_et = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tuh'
    },
    '10000': {
      'other': '00 tuh'
    },
    '100000': {
      'other': '000 tuh'
    },
    '1000000': {
      'other': '0 mln'
    },
    '10000000': {
      'other': '00 mln'
    },
    '100000000': {
      'other': '000 mln'
    },
    '1000000000': {
      'other': '0 mld'
    },
    '10000000000': {
      'other': '00 mld'
    },
    '100000000000': {
      'other': '000 mld'
    },
    '1000000000000': {
      'other': '0 trl'
    },
    '10000000000000': {
      'other': '00 trl'
    },
    '100000000000000': {
      'other': '000 trl'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tuhat'
    },
    '10000': {
      'other': '00 tuhat'
    },
    '100000': {
      'other': '000 tuhat'
    },
    '1000000': {
      'other': '0 miljonit'
    },
    '10000000': {
      'other': '00 miljonit'
    },
    '100000000': {
      'other': '000 miljonit'
    },
    '1000000000': {
      'other': '0 miljardit'
    },
    '10000000000': {
      'other': '00 miljardit'
    },
    '100000000000': {
      'other': '000 miljardit'
    },
    '1000000000000': {
      'other': '0 triljonit'
    },
    '10000000000000': {
      'other': '00 triljonit'
    },
    '100000000000000': {
      'other': '000 triljonit'
    }
  }
};


/**
 * Compact number formatting symbols for locale eu.
 */
goog.i18n.CompactNumberFormatSymbols_eu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0000 M'
    },
    '10000000000': {
      'other': '00000 M'
    },
    '100000000000': {
      'other': '000000 M'
    },
    '1000000000000': {
      'other': '0 B'
    },
    '10000000000000': {
      'other': '00 B'
    },
    '100000000000000': {
      'other': '000 B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0'
    },
    '1000000': {
      'other': '0 milioi'
    },
    '10000000': {
      'other': '00 milioi'
    },
    '100000000': {
      'other': '000 milioi'
    },
    '1000000000': {
      'other': '0000 milioi'
    },
    '10000000000': {
      'other': '00000 milioi'
    },
    '100000000000': {
      'other': '000000 milioi'
    },
    '1000000000000': {
      'other': '0 bilioi'
    },
    '10000000000000': {
      'other': '00 bilioi'
    },
    '100000000000000': {
      'other': '000 bilioi'
    }
  }
};


/**
 * Compact number formatting symbols for locale fa.
 */
goog.i18n.CompactNumberFormatSymbols_fa = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 هزار'
    },
    '10000': {
      'other': '00 هزار'
    },
    '100000': {
      'other': '000 هزار'
    },
    '1000000': {
      'other': '0 میلیون'
    },
    '10000000': {
      'other': '00 میلیون'
    },
    '100000000': {
      'other': '000 م'
    },
    '1000000000': {
      'other': '0 م'
    },
    '10000000000': {
      'other': '00 م'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0 تریلیون'
    },
    '10000000000000': {
      'other': '00 ت'
    },
    '100000000000000': {
      'other': '000 ت'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 هزار'
    },
    '10000': {
      'other': '00 هزار'
    },
    '100000': {
      'other': '000 هزار'
    },
    '1000000': {
      'other': '0 میلیون'
    },
    '10000000': {
      'other': '00 میلیون'
    },
    '100000000': {
      'other': '000 میلیون'
    },
    '1000000000': {
      'other': '0 میلیارد'
    },
    '10000000000': {
      'other': '00 میلیارد'
    },
    '100000000000': {
      'other': '000 میلیارد'
    },
    '1000000000000': {
      'other': '0 هزارمیلیارد'
    },
    '10000000000000': {
      'other': '00 هزارمیلیارد'
    },
    '100000000000000': {
      'other': '000 هزارمیلیارد'
    }
  }
};


/**
 * Compact number formatting symbols for locale fi.
 */
goog.i18n.CompactNumberFormatSymbols_fi = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 t.'
    },
    '10000': {
      'other': '00 t.'
    },
    '100000': {
      'other': '000 t.'
    },
    '1000000': {
      'other': '0 milj.'
    },
    '10000000': {
      'other': '00 milj.'
    },
    '100000000': {
      'other': '000 milj.'
    },
    '1000000000': {
      'other': '0 mrd.'
    },
    '10000000000': {
      'other': '00 mrd.'
    },
    '100000000000': {
      'other': '000 mrd.'
    },
    '1000000000000': {
      'other': '0 bilj.'
    },
    '10000000000000': {
      'other': '00 bilj.'
    },
    '100000000000000': {
      'other': '000 bilj.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tuhatta'
    },
    '10000': {
      'other': '00 tuhatta'
    },
    '100000': {
      'other': '000 tuhatta'
    },
    '1000000': {
      'other': '0 miljoonaa'
    },
    '10000000': {
      'other': '00 miljoonaa'
    },
    '100000000': {
      'other': '000 miljoonaa'
    },
    '1000000000': {
      'other': '0 miljardia'
    },
    '10000000000': {
      'other': '00 miljardia'
    },
    '100000000000': {
      'other': '000 miljardia'
    },
    '1000000000000': {
      'other': '0 biljoonaa'
    },
    '10000000000000': {
      'other': '00 biljoonaa'
    },
    '100000000000000': {
      'other': '000 biljoonaa'
    }
  }
};


/**
 * Compact number formatting symbols for locale fil.
 */
goog.i18n.CompactNumberFormatSymbols_fil = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 na libo'
    },
    '10000': {
      'other': '00 na libo'
    },
    '100000': {
      'other': '000 na libo'
    },
    '1000000': {
      'other': '0 na milyon'
    },
    '10000000': {
      'other': '00 na milyon'
    },
    '100000000': {
      'other': '000 na milyon'
    },
    '1000000000': {
      'other': '0 na bilyon'
    },
    '10000000000': {
      'other': '00 na bilyon'
    },
    '100000000000': {
      'other': '000 na bilyon'
    },
    '1000000000000': {
      'other': '0 na trilyon'
    },
    '10000000000000': {
      'other': '00 na trilyon'
    },
    '100000000000000': {
      'other': '000 na trilyon'
    }
  }
};


/**
 * Compact number formatting symbols for locale fr.
 */
goog.i18n.CompactNumberFormatSymbols_fr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 k'
    },
    '10000': {
      'other': '00 k'
    },
    '100000': {
      'other': '000 k'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 Md'
    },
    '10000000000': {
      'other': '00 Md'
    },
    '100000000000': {
      'other': '000 Md'
    },
    '1000000000000': {
      'other': '0 Bn'
    },
    '10000000000000': {
      'other': '00 Bn'
    },
    '100000000000000': {
      'other': '000 Bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mille'
    },
    '10000': {
      'other': '00 mille'
    },
    '100000': {
      'other': '000 mille'
    },
    '1000000': {
      'other': '0 millions'
    },
    '10000000': {
      'other': '00 millions'
    },
    '100000000': {
      'other': '000 millions'
    },
    '1000000000': {
      'other': '0 milliards'
    },
    '10000000000': {
      'other': '00 milliards'
    },
    '100000000000': {
      'other': '000 milliards'
    },
    '1000000000000': {
      'other': '0 billions'
    },
    '10000000000000': {
      'other': '00 billions'
    },
    '100000000000000': {
      'other': '000 billions'
    }
  }
};


/**
 * Compact number formatting symbols for locale fr_CA.
 */
goog.i18n.CompactNumberFormatSymbols_fr_CA = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 k'
    },
    '10000': {
      'other': '00 k'
    },
    '100000': {
      'other': '000 k'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 G'
    },
    '10000000000': {
      'other': '00 G'
    },
    '100000000000': {
      'other': '000 G'
    },
    '1000000000000': {
      'other': '0 T'
    },
    '10000000000000': {
      'other': '00 T'
    },
    '100000000000000': {
      'other': '000 T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mille'
    },
    '10000': {
      'other': '00 mille'
    },
    '100000': {
      'other': '000 mille'
    },
    '1000000': {
      'other': '0 millions'
    },
    '10000000': {
      'other': '00 millions'
    },
    '100000000': {
      'other': '000 millions'
    },
    '1000000000': {
      'other': '0 milliards'
    },
    '10000000000': {
      'other': '00 milliards'
    },
    '100000000000': {
      'other': '000 milliards'
    },
    '1000000000000': {
      'other': '0 billions'
    },
    '10000000000000': {
      'other': '00 billions'
    },
    '100000000000000': {
      'other': '000 billions'
    }
  }
};


/**
 * Compact number formatting symbols for locale ga.
 */
goog.i18n.CompactNumberFormatSymbols_ga = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 míle'
    },
    '10000': {
      'other': '00 míle'
    },
    '100000': {
      'other': '000 míle'
    },
    '1000000': {
      'other': '0 milliún'
    },
    '10000000': {
      'other': '00 milliún'
    },
    '100000000': {
      'other': '000 milliún'
    },
    '1000000000': {
      'other': '0 billiún'
    },
    '10000000000': {
      'other': '00 billiún'
    },
    '100000000000': {
      'other': '000 billiún'
    },
    '1000000000000': {
      'other': '0 trilliún'
    },
    '10000000000000': {
      'other': '00 trilliún'
    },
    '100000000000000': {
      'other': '000 trilliún'
    }
  }
};


/**
 * Compact number formatting symbols for locale gl.
 */
goog.i18n.CompactNumberFormatSymbols_gl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0000 M'
    },
    '10000000000': {
      'other': '00000 M'
    },
    '100000000000': {
      'other': '000000 M'
    },
    '1000000000000': {
      'other': '0 B'
    },
    '10000000000000': {
      'other': '00 B'
    },
    '100000000000000': {
      'other': '000 B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0'
    },
    '1000000': {
      'other': '0 millóns'
    },
    '10000000': {
      'other': '00 millóns'
    },
    '100000000': {
      'other': '000 millóns'
    },
    '1000000000': {
      'other': '0000 millóns'
    },
    '10000000000': {
      'other': '00000 millóns'
    },
    '100000000000': {
      'other': '000000 millóns'
    },
    '1000000000000': {
      'other': '0 billóns'
    },
    '10000000000000': {
      'other': '00 billóns'
    },
    '100000000000000': {
      'other': '000 billóns'
    }
  }
};


/**
 * Compact number formatting symbols for locale gsw.
 */
goog.i18n.CompactNumberFormatSymbols_gsw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 Tsg.'
    },
    '10000': {
      'other': '00 Tsg.'
    },
    '100000': {
      'other': '000 Tsg.'
    },
    '1000000': {
      'other': '0 Mio.'
    },
    '10000000': {
      'other': '00 Mio.'
    },
    '100000000': {
      'other': '000 Mio.'
    },
    '1000000000': {
      'other': '0 Mrd.'
    },
    '10000000000': {
      'other': '00 Mrd.'
    },
    '100000000000': {
      'other': '000 Mrd.'
    },
    '1000000000000': {
      'other': '0 Bio.'
    },
    '10000000000000': {
      'other': '00 Bio.'
    },
    '100000000000000': {
      'other': '000 Bio.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 Tuusig'
    },
    '10000': {
      'other': '00 Tuusig'
    },
    '100000': {
      'other': '000 Tuusig'
    },
    '1000000': {
      'other': '0 Millioone'
    },
    '10000000': {
      'other': '00 Millioone'
    },
    '100000000': {
      'other': '000 Millioone'
    },
    '1000000000': {
      'other': '0 Milliarde'
    },
    '10000000000': {
      'other': '00 Milliarde'
    },
    '100000000000': {
      'other': '000 Milliarde'
    },
    '1000000000000': {
      'other': '0 Billioone'
    },
    '10000000000000': {
      'other': '00 Billioone'
    },
    '100000000000000': {
      'other': '000 Billioone'
    }
  }
};


/**
 * Compact number formatting symbols for locale gu.
 */
goog.i18n.CompactNumberFormatSymbols_gu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 હજાર'
    },
    '10000': {
      'other': '00 હજાર'
    },
    '100000': {
      'other': '0 લાખ'
    },
    '1000000': {
      'other': '00 લાખ'
    },
    '10000000': {
      'other': '0 કરોડ'
    },
    '100000000': {
      'other': '00 કરોડ'
    },
    '1000000000': {
      'other': '0 અબજ'
    },
    '10000000000': {
      'other': '00 અબજ'
    },
    '100000000000': {
      'other': '0 નિખર્વ'
    },
    '1000000000000': {
      'other': '0 મહાપદ્મ'
    },
    '10000000000000': {
      'other': '0 શંકુ'
    },
    '100000000000000': {
      'other': '0 જલધિ'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 હજાર'
    },
    '10000': {
      'other': '00 હજાર'
    },
    '100000': {
      'other': '0 લાખ'
    },
    '1000000': {
      'other': '00 લાખ'
    },
    '10000000': {
      'other': '0 કરોડ'
    },
    '100000000': {
      'other': '00 કરોડ'
    },
    '1000000000': {
      'other': '0 અબજ'
    },
    '10000000000': {
      'other': '00 અબજ'
    },
    '100000000000': {
      'other': '0 નિખર્વ'
    },
    '1000000000000': {
      'other': '0 મહાપદ્મ'
    },
    '10000000000000': {
      'other': '0 શંકુ'
    },
    '100000000000000': {
      'other': '0 જલધિ'
    }
  }
};


/**
 * Compact number formatting symbols for locale haw.
 */
goog.i18n.CompactNumberFormatSymbols_haw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale he.
 */
goog.i18n.CompactNumberFormatSymbols_he = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K‏'
    },
    '10000': {
      'other': '00K‏'
    },
    '100000': {
      'other': '000K‏'
    },
    '1000000': {
      'other': '0M‏'
    },
    '10000000': {
      'other': '00M‏'
    },
    '100000000': {
      'other': '000M‏'
    },
    '1000000000': {
      'other': '0B‏'
    },
    '10000000000': {
      'other': '00B‏'
    },
    '100000000000': {
      'other': '000B‏'
    },
    '1000000000000': {
      'other': '0T‏'
    },
    '10000000000000': {
      'other': '00T‏'
    },
    '100000000000000': {
      'other': '000T‏'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '‏0 אלף'
    },
    '10000': {
      'other': '‏00 אלף'
    },
    '100000': {
      'other': '‏000 אלף'
    },
    '1000000': {
      'other': '‏0 מיליון'
    },
    '10000000': {
      'other': '‏00 מיליון'
    },
    '100000000': {
      'other': '‏000 מיליון'
    },
    '1000000000': {
      'other': '‏0 מיליארד'
    },
    '10000000000': {
      'other': '‏00 מיליארד'
    },
    '100000000000': {
      'other': '‏000 מיליארד'
    },
    '1000000000000': {
      'other': '‏0 טריליון'
    },
    '10000000000000': {
      'other': '‏00 טריליון'
    },
    '100000000000000': {
      'other': '‏000 טריליון'
    }
  }
};


/**
 * Compact number formatting symbols for locale hi.
 */
goog.i18n.CompactNumberFormatSymbols_hi = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 हज़ार'
    },
    '10000': {
      'other': '00 हज़ार'
    },
    '100000': {
      'other': '0 लाख'
    },
    '1000000': {
      'other': '00 लाख'
    },
    '10000000': {
      'other': '0 क॰'
    },
    '100000000': {
      'other': '00 क॰'
    },
    '1000000000': {
      'other': '0 अ॰'
    },
    '10000000000': {
      'other': '00 अ॰'
    },
    '100000000000': {
      'other': '0 ख॰'
    },
    '1000000000000': {
      'other': '00 ख॰'
    },
    '10000000000000': {
      'other': '0 नील'
    },
    '100000000000000': {
      'other': '00 नील'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 हज़ार'
    },
    '10000': {
      'other': '00 हज़ार'
    },
    '100000': {
      'other': '0 लाख'
    },
    '1000000': {
      'other': '00 लाख'
    },
    '10000000': {
      'other': '0 करोड़'
    },
    '100000000': {
      'other': '00 करोड़'
    },
    '1000000000': {
      'other': '0 अरब'
    },
    '10000000000': {
      'other': '00 अरब'
    },
    '100000000000': {
      'other': '0 खरब'
    },
    '1000000000000': {
      'other': '00 खरब'
    },
    '10000000000000': {
      'other': '000 खरब'
    },
    '100000000000000': {
      'other': '0000 खरब'
    }
  }
};


/**
 * Compact number formatting symbols for locale hr.
 */
goog.i18n.CompactNumberFormatSymbols_hr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tis.'
    },
    '10000': {
      'other': '00 tis.'
    },
    '100000': {
      'other': '000 tis.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mlr.'
    },
    '10000000000': {
      'other': '00 mlr.'
    },
    '100000000000': {
      'other': '000 mlr.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tisuća'
    },
    '10000': {
      'other': '00 tisuća'
    },
    '100000': {
      'other': '000 tisuća'
    },
    '1000000': {
      'other': '0 milijuna'
    },
    '10000000': {
      'other': '00 milijuna'
    },
    '100000000': {
      'other': '000 milijuna'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 bilijuna'
    },
    '10000000000000': {
      'other': '00 bilijuna'
    },
    '100000000000000': {
      'other': '000 bilijuna'
    }
  }
};


/**
 * Compact number formatting symbols for locale hu.
 */
goog.i18n.CompactNumberFormatSymbols_hu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 E'
    },
    '10000': {
      'other': '00 E'
    },
    '100000': {
      'other': '000 E'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 Mrd'
    },
    '10000000000': {
      'other': '00 Mrd'
    },
    '100000000000': {
      'other': '000 Mrd'
    },
    '1000000000000': {
      'other': '0 B'
    },
    '10000000000000': {
      'other': '00 B'
    },
    '100000000000000': {
      'other': '000 B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ezer'
    },
    '10000': {
      'other': '00 ezer'
    },
    '100000': {
      'other': '000 ezer'
    },
    '1000000': {
      'other': '0 millió'
    },
    '10000000': {
      'other': '00 millió'
    },
    '100000000': {
      'other': '000 millió'
    },
    '1000000000': {
      'other': '0 milliárd'
    },
    '10000000000': {
      'other': '00 milliárd'
    },
    '100000000000': {
      'other': '000 milliárd'
    },
    '1000000000000': {
      'other': '0 billió'
    },
    '10000000000000': {
      'other': '00 billió'
    },
    '100000000000000': {
      'other': '000 billió'
    }
  }
};


/**
 * Compact number formatting symbols for locale hy.
 */
goog.i18n.CompactNumberFormatSymbols_hy = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 հզր'
    },
    '10000': {
      'other': '00 հզր'
    },
    '100000': {
      'other': '000 հզր'
    },
    '1000000': {
      'other': '0 մլն'
    },
    '10000000': {
      'other': '00 մլն'
    },
    '100000000': {
      'other': '000 մլն'
    },
    '1000000000': {
      'other': '0 մլրդ'
    },
    '10000000000': {
      'other': '00 մլրդ'
    },
    '100000000000': {
      'other': '000 մլրդ'
    },
    '1000000000000': {
      'other': '0 տրլն'
    },
    '10000000000000': {
      'other': '00 տրլն'
    },
    '100000000000000': {
      'other': '000 տրլն'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 հազար'
    },
    '10000': {
      'other': '00 հազար'
    },
    '100000': {
      'other': '000 հազար'
    },
    '1000000': {
      'other': '0 միլիոն'
    },
    '10000000': {
      'other': '00 միլիոն'
    },
    '100000000': {
      'other': '000 միլիոն'
    },
    '1000000000': {
      'other': '0 միլիարդ'
    },
    '10000000000': {
      'other': '00 միլիարդ'
    },
    '100000000000': {
      'other': '000 միլիարդ'
    },
    '1000000000000': {
      'other': '0 տրիլիոն'
    },
    '10000000000000': {
      'other': '00 տրիլիոն'
    },
    '100000000000000': {
      'other': '000 տրիլիոն'
    }
  }
};


/**
 * Compact number formatting symbols for locale id.
 */
goog.i18n.CompactNumberFormatSymbols_id = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 rb'
    },
    '10000': {
      'other': '00 rb'
    },
    '100000': {
      'other': '000 rb'
    },
    '1000000': {
      'other': '0 jt'
    },
    '10000000': {
      'other': '00 jt'
    },
    '100000000': {
      'other': '000 jt'
    },
    '1000000000': {
      'other': '0 M'
    },
    '10000000000': {
      'other': '00 M'
    },
    '100000000000': {
      'other': '000 M'
    },
    '1000000000000': {
      'other': '0 T'
    },
    '10000000000000': {
      'other': '00 T'
    },
    '100000000000000': {
      'other': '000 T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ribu'
    },
    '10000': {
      'other': '00 ribu'
    },
    '100000': {
      'other': '000 ribu'
    },
    '1000000': {
      'other': '0 juta'
    },
    '10000000': {
      'other': '00 juta'
    },
    '100000000': {
      'other': '000 juta'
    },
    '1000000000': {
      'other': '0 miliar'
    },
    '10000000000': {
      'other': '00 miliar'
    },
    '100000000000': {
      'other': '000 miliar'
    },
    '1000000000000': {
      'other': '0 triliun'
    },
    '10000000000000': {
      'other': '00 triliun'
    },
    '100000000000000': {
      'other': '000 triliun'
    }
  }
};


/**
 * Compact number formatting symbols for locale in.
 */
goog.i18n.CompactNumberFormatSymbols_in = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 rb'
    },
    '10000': {
      'other': '00 rb'
    },
    '100000': {
      'other': '000 rb'
    },
    '1000000': {
      'other': '0 jt'
    },
    '10000000': {
      'other': '00 jt'
    },
    '100000000': {
      'other': '000 jt'
    },
    '1000000000': {
      'other': '0 M'
    },
    '10000000000': {
      'other': '00 M'
    },
    '100000000000': {
      'other': '000 M'
    },
    '1000000000000': {
      'other': '0 T'
    },
    '10000000000000': {
      'other': '00 T'
    },
    '100000000000000': {
      'other': '000 T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ribu'
    },
    '10000': {
      'other': '00 ribu'
    },
    '100000': {
      'other': '000 ribu'
    },
    '1000000': {
      'other': '0 juta'
    },
    '10000000': {
      'other': '00 juta'
    },
    '100000000': {
      'other': '000 juta'
    },
    '1000000000': {
      'other': '0 miliar'
    },
    '10000000000': {
      'other': '00 miliar'
    },
    '100000000000': {
      'other': '000 miliar'
    },
    '1000000000000': {
      'other': '0 triliun'
    },
    '10000000000000': {
      'other': '00 triliun'
    },
    '100000000000000': {
      'other': '000 triliun'
    }
  }
};


/**
 * Compact number formatting symbols for locale is.
 */
goog.i18n.CompactNumberFormatSymbols_is = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 þ.'
    },
    '10000': {
      'other': '00 þ.'
    },
    '100000': {
      'other': '000 þ.'
    },
    '1000000': {
      'other': '0 m.'
    },
    '10000000': {
      'other': '00 m.'
    },
    '100000000': {
      'other': '000 m.'
    },
    '1000000000': {
      'other': '0 ma.'
    },
    '10000000000': {
      'other': '00 ma.'
    },
    '100000000000': {
      'other': '000 ma.'
    },
    '1000000000000': {
      'other': '0 bn'
    },
    '10000000000000': {
      'other': '00 bn'
    },
    '100000000000000': {
      'other': '000 bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 þúsund'
    },
    '10000': {
      'other': '00 þúsund'
    },
    '100000': {
      'other': '000 þúsund'
    },
    '1000000': {
      'other': '0 milljónir'
    },
    '10000000': {
      'other': '00 milljónir'
    },
    '100000000': {
      'other': '000 milljónir'
    },
    '1000000000': {
      'other': '0 milljarðar'
    },
    '10000000000': {
      'other': '00 milljarðar'
    },
    '100000000000': {
      'other': '000 milljarðar'
    },
    '1000000000000': {
      'other': '0 billjónir'
    },
    '10000000000000': {
      'other': '00 billjónir'
    },
    '100000000000000': {
      'other': '000 billjónir'
    }
  }
};


/**
 * Compact number formatting symbols for locale it.
 */
goog.i18n.CompactNumberFormatSymbols_it = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0'
    },
    '1000000': {
      'other': '0 Mln'
    },
    '10000000': {
      'other': '00 Mln'
    },
    '100000000': {
      'other': '000 Mln'
    },
    '1000000000': {
      'other': '0 Mrd'
    },
    '10000000000': {
      'other': '00 Mrd'
    },
    '100000000000': {
      'other': '000 Mrd'
    },
    '1000000000000': {
      'other': '0 Bln'
    },
    '10000000000000': {
      'other': '00 Bln'
    },
    '100000000000000': {
      'other': '000 Bln'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mila'
    },
    '10000': {
      'other': '00 mila'
    },
    '100000': {
      'other': '000 mila'
    },
    '1000000': {
      'other': '0 milioni'
    },
    '10000000': {
      'other': '00 milioni'
    },
    '100000000': {
      'other': '000 milioni'
    },
    '1000000000': {
      'other': '0 miliardi'
    },
    '10000000000': {
      'other': '00 miliardi'
    },
    '100000000000': {
      'other': '000 miliardi'
    },
    '1000000000000': {
      'other': '0 mila miliardi'
    },
    '10000000000000': {
      'other': '00 mila miliardi'
    },
    '100000000000000': {
      'other': '000 mila miliardi'
    }
  }
};


/**
 * Compact number formatting symbols for locale iw.
 */
goog.i18n.CompactNumberFormatSymbols_iw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K‏'
    },
    '10000': {
      'other': '00K‏'
    },
    '100000': {
      'other': '000K‏'
    },
    '1000000': {
      'other': '0M‏'
    },
    '10000000': {
      'other': '00M‏'
    },
    '100000000': {
      'other': '000M‏'
    },
    '1000000000': {
      'other': '0B‏'
    },
    '10000000000': {
      'other': '00B‏'
    },
    '100000000000': {
      'other': '000B‏'
    },
    '1000000000000': {
      'other': '0T‏'
    },
    '10000000000000': {
      'other': '00T‏'
    },
    '100000000000000': {
      'other': '000T‏'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '‏0 אלף'
    },
    '10000': {
      'other': '‏00 אלף'
    },
    '100000': {
      'other': '‏000 אלף'
    },
    '1000000': {
      'other': '‏0 מיליון'
    },
    '10000000': {
      'other': '‏00 מיליון'
    },
    '100000000': {
      'other': '‏000 מיליון'
    },
    '1000000000': {
      'other': '‏0 מיליארד'
    },
    '10000000000': {
      'other': '‏00 מיליארד'
    },
    '100000000000': {
      'other': '‏000 מיליארד'
    },
    '1000000000000': {
      'other': '‏0 טריליון'
    },
    '10000000000000': {
      'other': '‏00 טריליון'
    },
    '100000000000000': {
      'other': '‏000 טריליון'
    }
  }
};


/**
 * Compact number formatting symbols for locale ja.
 */
goog.i18n.CompactNumberFormatSymbols_ja = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0万'
    },
    '100000': {
      'other': '00万'
    },
    '1000000': {
      'other': '000万'
    },
    '10000000': {
      'other': '0000万'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0万'
    },
    '100000': {
      'other': '00万'
    },
    '1000000': {
      'other': '000万'
    },
    '10000000': {
      'other': '0000万'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  }
};


/**
 * Compact number formatting symbols for locale ka.
 */
goog.i18n.CompactNumberFormatSymbols_ka = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 ათ.'
    },
    '10000': {
      'other': '00 ათ.'
    },
    '100000': {
      'other': '000 ათ.'
    },
    '1000000': {
      'other': '0 მლნ.'
    },
    '10000000': {
      'other': '00 მლნ.'
    },
    '100000000': {
      'other': '000 მლნ.'
    },
    '1000000000': {
      'other': '0 მლრდ.'
    },
    '10000000000': {
      'other': '00 მლრდ.'
    },
    '100000000000': {
      'other': '000 მლრ.'
    },
    '1000000000000': {
      'other': '0 ტრლ.'
    },
    '10000000000000': {
      'other': '00 ტრლ.'
    },
    '100000000000000': {
      'other': '000 ტრლ.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ათასი'
    },
    '10000': {
      'other': '00 ათასი'
    },
    '100000': {
      'other': '000 ათასი'
    },
    '1000000': {
      'other': '0 მილიონი'
    },
    '10000000': {
      'other': '00 მილიონი'
    },
    '100000000': {
      'other': '000 მილიონი'
    },
    '1000000000': {
      'other': '0 მილიარდი'
    },
    '10000000000': {
      'other': '00 მილიარდი'
    },
    '100000000000': {
      'other': '000 მილიარდი'
    },
    '1000000000000': {
      'other': '0 ტრილიონი'
    },
    '10000000000000': {
      'other': '00 ტრილიონი'
    },
    '100000000000000': {
      'other': '000 ტრილიონი'
    }
  }
};


/**
 * Compact number formatting symbols for locale kk.
 */
goog.i18n.CompactNumberFormatSymbols_kk = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 мың'
    },
    '10000': {
      'other': '00 мың'
    },
    '100000': {
      'other': '000 м.'
    },
    '1000000': {
      'other': '0 млн'
    },
    '10000000': {
      'other': '00 млн'
    },
    '100000000': {
      'other': '000 млн'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 трлн'
    },
    '10000000000000': {
      'other': '00 трлн'
    },
    '100000000000000': {
      'other': '000 трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 мың'
    },
    '10000': {
      'other': '00 мың'
    },
    '100000': {
      'other': '000 мың'
    },
    '1000000': {
      'other': '0 миллион'
    },
    '10000000': {
      'other': '00 миллион'
    },
    '100000000': {
      'other': '000 миллион'
    },
    '1000000000': {
      'other': '0 миллиард'
    },
    '10000000000': {
      'other': '00 миллиард'
    },
    '100000000000': {
      'other': '000 миллиард'
    },
    '1000000000000': {
      'other': '0 триллион'
    },
    '10000000000000': {
      'other': '00 триллион'
    },
    '100000000000000': {
      'other': '000 триллион'
    }
  }
};


/**
 * Compact number formatting symbols for locale km.
 */
goog.i18n.CompactNumberFormatSymbols_km = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0ពាន់'
    },
    '10000': {
      'other': '00 ពាន់'
    },
    '100000': {
      'other': '000 ពាន់'
    },
    '1000000': {
      'other': '0 លាន'
    },
    '10000000': {
      'other': '00 លាន'
    },
    '100000000': {
      'other': '000 លាន'
    },
    '1000000000': {
      'other': '0 ប៊ីលាន'
    },
    '10000000000': {
      'other': '00 ប៊ីលាន'
    },
    '100000000000': {
      'other': '000 ប៊ីលាន'
    },
    '1000000000000': {
      'other': '0 ទ្រីលាន'
    },
    '10000000000000': {
      'other': '00 ទ្រីលាន'
    },
    '100000000000000': {
      'other': '000 ទ្រីលាន'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ពាន់'
    },
    '10000': {
      'other': '00 ពាន់'
    },
    '100000': {
      'other': '000ពាន់'
    },
    '1000000': {
      'other': '0 លាន'
    },
    '10000000': {
      'other': '00 លាន'
    },
    '100000000': {
      'other': '000 លាន'
    },
    '1000000000': {
      'other': '0 ប៊ីលាន'
    },
    '10000000000': {
      'other': '00 ប៊ីលាន'
    },
    '100000000000': {
      'other': '000 ប៊ីលាន'
    },
    '1000000000000': {
      'other': '0 ទ្រីលាន'
    },
    '10000000000000': {
      'other': '00 ទ្រីលាន'
    },
    '100000000000000': {
      'other': '000 ទ្រីលាន'
    }
  }
};


/**
 * Compact number formatting symbols for locale kn.
 */
goog.i18n.CompactNumberFormatSymbols_kn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0ಸಾ'
    },
    '10000': {
      'other': '00ಸಾ'
    },
    '100000': {
      'other': '000ಸಾ'
    },
    '1000000': {
      'other': '0ಮಿ'
    },
    '10000000': {
      'other': '00ಮಿ'
    },
    '100000000': {
      'other': '000ಮಿ'
    },
    '1000000000': {
      'other': '0ಬಿ'
    },
    '10000000000': {
      'other': '00ಬಿ'
    },
    '100000000000': {
      'other': '000ಬಿ'
    },
    '1000000000000': {
      'other': '0ಟ್ರಿ'
    },
    '10000000000000': {
      'other': '00ಟ್ರಿ'
    },
    '100000000000000': {
      'other': '000ಟ್ರಿ'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ಸಾವಿರ'
    },
    '10000': {
      'other': '00 ಸಾವಿರ'
    },
    '100000': {
      'other': '000 ಸಾವಿರ'
    },
    '1000000': {
      'other': '0 ಮಿಲಿಯನ್'
    },
    '10000000': {
      'other': '00 ಮಿಲಿಯನ್'
    },
    '100000000': {
      'other': '000 ಮಿಲಿಯನ್'
    },
    '1000000000': {
      'other': '0 ಬಿಲಿಯನ್'
    },
    '10000000000': {
      'other': '00 ಬಿಲಿಯನ್'
    },
    '100000000000': {
      'other': '000 ಬಿಲಿಯನ್'
    },
    '1000000000000': {
      'other': '0 ಟ್ರಿಲಿಯನ್‌'
    },
    '10000000000000': {
      'other': '00 ಟ್ರಿಲಿಯನ್‌'
    },
    '100000000000000': {
      'other': '000 ಟ್ರಿಲಿಯನ್‌'
    }
  }
};


/**
 * Compact number formatting symbols for locale ko.
 */
goog.i18n.CompactNumberFormatSymbols_ko = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0천'
    },
    '10000': {
      'other': '0만'
    },
    '100000': {
      'other': '00만'
    },
    '1000000': {
      'other': '000만'
    },
    '10000000': {
      'other': '0000만'
    },
    '100000000': {
      'other': '0억'
    },
    '1000000000': {
      'other': '00억'
    },
    '10000000000': {
      'other': '000억'
    },
    '100000000000': {
      'other': '0000억'
    },
    '1000000000000': {
      'other': '0조'
    },
    '10000000000000': {
      'other': '00조'
    },
    '100000000000000': {
      'other': '000조'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0천'
    },
    '10000': {
      'other': '0만'
    },
    '100000': {
      'other': '00만'
    },
    '1000000': {
      'other': '000만'
    },
    '10000000': {
      'other': '0000만'
    },
    '100000000': {
      'other': '0억'
    },
    '1000000000': {
      'other': '00억'
    },
    '10000000000': {
      'other': '000억'
    },
    '100000000000': {
      'other': '0000억'
    },
    '1000000000000': {
      'other': '0조'
    },
    '10000000000000': {
      'other': '00조'
    },
    '100000000000000': {
      'other': '000조'
    }
  }
};


/**
 * Compact number formatting symbols for locale ky.
 */
goog.i18n.CompactNumberFormatSymbols_ky = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 миң'
    },
    '10000': {
      'other': '00 миң'
    },
    '100000': {
      'other': '000 миң'
    },
    '1000000': {
      'other': '0 млн'
    },
    '10000000': {
      'other': '00 млн'
    },
    '100000000': {
      'other': '000 млн'
    },
    '1000000000': {
      'other': '0 млд'
    },
    '10000000000': {
      'other': '00 млд'
    },
    '100000000000': {
      'other': '000 млд'
    },
    '1000000000000': {
      'other': '0 трлн'
    },
    '10000000000000': {
      'other': '00 трлн'
    },
    '100000000000000': {
      'other': '000 трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 миң'
    },
    '10000': {
      'other': '00 миң'
    },
    '100000': {
      'other': '000 миң'
    },
    '1000000': {
      'other': '0 миллион'
    },
    '10000000': {
      'other': '00 миллион'
    },
    '100000000': {
      'other': '000 миллион'
    },
    '1000000000': {
      'other': '0 миллиард'
    },
    '10000000000': {
      'other': '00 миллиард'
    },
    '100000000000': {
      'other': '000 миллиард'
    },
    '1000000000000': {
      'other': '0 триллион'
    },
    '10000000000000': {
      'other': '00 триллион'
    },
    '100000000000000': {
      'other': '000 триллион'
    }
  }
};


/**
 * Compact number formatting symbols for locale ln.
 */
goog.i18n.CompactNumberFormatSymbols_ln = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale lo.
 */
goog.i18n.CompactNumberFormatSymbols_lo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 ພັນ'
    },
    '10000': {
      'other': '00 ພັນ'
    },
    '100000': {
      'other': '000 ກີບ'
    },
    '1000000': {
      'other': '0 ລ້ານ'
    },
    '10000000': {
      'other': '00 ລ້ານ'
    },
    '100000000': {
      'other': '000 ລ້ານ'
    },
    '1000000000': {
      'other': '0 ຕື້'
    },
    '10000000000': {
      'other': '00 ຕື້'
    },
    '100000000000': {
      'other': '000 ຕື້'
    },
    '1000000000000': {
      'other': '0 ລ້ານລ້ານ'
    },
    '10000000000000': {
      'other': '00ລລ'
    },
    '100000000000000': {
      'other': '000ລລ'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ພັນ'
    },
    '10000': {
      'other': '00 ພັນ'
    },
    '100000': {
      'other': '0 ແສນ'
    },
    '1000000': {
      'other': '0 ລ້ານ'
    },
    '10000000': {
      'other': '00 ລ້ານ'
    },
    '100000000': {
      'other': '000 ລ້ານ'
    },
    '1000000000': {
      'other': '0 ຕື້'
    },
    '10000000000': {
      'other': '00 ຕື້'
    },
    '100000000000': {
      'other': '000 ຕື້'
    },
    '1000000000000': {
      'other': '0 ລ້ານລ້ານ'
    },
    '10000000000000': {
      'other': '00 ລ້ານລ້ານ'
    },
    '100000000000000': {
      'other': '000 ລ້ານລ້ານ'
    }
  }
};


/**
 * Compact number formatting symbols for locale lt.
 */
goog.i18n.CompactNumberFormatSymbols_lt = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tūkst.'
    },
    '10000': {
      'other': '00 tūkst.'
    },
    '100000': {
      'other': '000 tūkst.'
    },
    '1000000': {
      'other': '0 mln.'
    },
    '10000000': {
      'other': '00 mln.'
    },
    '100000000': {
      'other': '000 mln.'
    },
    '1000000000': {
      'other': '0 mlrd.'
    },
    '10000000000': {
      'other': '00 mlrd.'
    },
    '100000000000': {
      'other': '000 mlrd.'
    },
    '1000000000000': {
      'other': '0 trln.'
    },
    '10000000000000': {
      'other': '00 trln.'
    },
    '100000000000000': {
      'other': '000 trln.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tūkstančių'
    },
    '10000': {
      'other': '00 tūkstančių'
    },
    '100000': {
      'other': '000 tūkstančių'
    },
    '1000000': {
      'other': '0 milijonų'
    },
    '10000000': {
      'other': '00 milijonų'
    },
    '100000000': {
      'other': '000 milijonų'
    },
    '1000000000': {
      'other': '0 milijardų'
    },
    '10000000000': {
      'other': '00 milijardų'
    },
    '100000000000': {
      'other': '000 milijardų'
    },
    '1000000000000': {
      'other': '0 trilijonų'
    },
    '10000000000000': {
      'other': '00 trilijonų'
    },
    '100000000000000': {
      'other': '000 trilijonų'
    }
  }
};


/**
 * Compact number formatting symbols for locale lv.
 */
goog.i18n.CompactNumberFormatSymbols_lv = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tūkst.'
    },
    '10000': {
      'other': '00 tūkst.'
    },
    '100000': {
      'other': '000 tūkst.'
    },
    '1000000': {
      'other': '0 milj.'
    },
    '10000000': {
      'other': '00 milj.'
    },
    '100000000': {
      'other': '000 milj.'
    },
    '1000000000': {
      'other': '0 mljrd.'
    },
    '10000000000': {
      'other': '00 mljrd.'
    },
    '100000000000': {
      'other': '000 mljrd.'
    },
    '1000000000000': {
      'other': '0 trilj.'
    },
    '10000000000000': {
      'other': '00 trilj.'
    },
    '100000000000000': {
      'other': '000 trilj.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tūkstoši'
    },
    '10000': {
      'other': '00 tūkstoši'
    },
    '100000': {
      'other': '000 tūkstoši'
    },
    '1000000': {
      'other': '0 miljoni'
    },
    '10000000': {
      'other': '00 miljoni'
    },
    '100000000': {
      'other': '000 miljoni'
    },
    '1000000000': {
      'other': '0 miljardi'
    },
    '10000000000': {
      'other': '00 miljardi'
    },
    '100000000000': {
      'other': '000 miljardi'
    },
    '1000000000000': {
      'other': '0 triljoni'
    },
    '10000000000000': {
      'other': '00 triljoni'
    },
    '100000000000000': {
      'other': '000 triljoni'
    }
  }
};


/**
 * Compact number formatting symbols for locale mk.
 */
goog.i18n.CompactNumberFormatSymbols_mk = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 илј.'
    },
    '10000': {
      'other': '00 илј.'
    },
    '100000': {
      'other': '000 илј.'
    },
    '1000000': {
      'other': '0 мил.'
    },
    '10000000': {
      'other': '00 мил.'
    },
    '100000000': {
      'other': '000 М'
    },
    '1000000000': {
      'other': '0 милј.'
    },
    '10000000000': {
      'other': '00 милј.'
    },
    '100000000000': {
      'other': '000 ми.'
    },
    '1000000000000': {
      'other': '0 бил.'
    },
    '10000000000000': {
      'other': '00 бил.'
    },
    '100000000000000': {
      'other': '000 бил.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 илјади'
    },
    '10000': {
      'other': '00 илјади'
    },
    '100000': {
      'other': '000 илјади'
    },
    '1000000': {
      'other': '0 милиони'
    },
    '10000000': {
      'other': '00 милиони'
    },
    '100000000': {
      'other': '000 милиони'
    },
    '1000000000': {
      'other': '0 милијарди'
    },
    '10000000000': {
      'other': '00 милијарди'
    },
    '100000000000': {
      'other': '000 милијарди'
    },
    '1000000000000': {
      'other': '0 билиони'
    },
    '10000000000000': {
      'other': '00 билиони'
    },
    '100000000000000': {
      'other': '000 билиони'
    }
  }
};


/**
 * Compact number formatting symbols for locale ml.
 */
goog.i18n.CompactNumberFormatSymbols_ml = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ആയിരം'
    },
    '10000': {
      'other': '00 ആയിരം'
    },
    '100000': {
      'other': '000 ആയിരം'
    },
    '1000000': {
      'other': '0 ദശലക്ഷം'
    },
    '10000000': {
      'other': '00 ദശലക്ഷം'
    },
    '100000000': {
      'other': '000 ദശലക്ഷം'
    },
    '1000000000': {
      'other': '0 ലക്ഷം കോടി'
    },
    '10000000000': {
      'other': '00 ലക്ഷം കോടി'
    },
    '100000000000': {
      'other': '000 ലക്ഷം കോടി'
    },
    '1000000000000': {
      'other': '0 ട്രില്യൺ'
    },
    '10000000000000': {
      'other': '00 ട്രില്യൺ'
    },
    '100000000000000': {
      'other': '000 ട്രില്യൺ'
    }
  }
};


/**
 * Compact number formatting symbols for locale mn.
 */
goog.i18n.CompactNumberFormatSymbols_mn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 мянга'
    },
    '10000': {
      'other': '00 мянга'
    },
    '100000': {
      'other': '000 мянга'
    },
    '1000000': {
      'other': '0 сая'
    },
    '10000000': {
      'other': '00 сая'
    },
    '100000000': {
      'other': '000 сая'
    },
    '1000000000': {
      'other': '0 тэрбум'
    },
    '10000000000': {
      'other': '00 тэрбум'
    },
    '100000000000': {
      'other': '000Т'
    },
    '1000000000000': {
      'other': '0ИН'
    },
    '10000000000000': {
      'other': '00ИН'
    },
    '100000000000000': {
      'other': '000ИН'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 мянга'
    },
    '10000': {
      'other': '00 мянга'
    },
    '100000': {
      'other': '000 мянга'
    },
    '1000000': {
      'other': '0 сая'
    },
    '10000000': {
      'other': '00 сая'
    },
    '100000000': {
      'other': '000 сая'
    },
    '1000000000': {
      'other': '0 тэрбум'
    },
    '10000000000': {
      'other': '00 тэрбум'
    },
    '100000000000': {
      'other': '000 тэрбум'
    },
    '1000000000000': {
      'other': '0 их наяд'
    },
    '10000000000000': {
      'other': '00 их наяд'
    },
    '100000000000000': {
      'other': '000 их наяд'
    }
  }
};


/**
 * Compact number formatting symbols for locale mo.
 */
goog.i18n.CompactNumberFormatSymbols_mo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 K'
    },
    '10000': {
      'other': '00 K'
    },
    '100000': {
      'other': '000 K'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mld.'
    },
    '10000000000': {
      'other': '00 mld.'
    },
    '100000000000': {
      'other': '000 mld.'
    },
    '1000000000000': {
      'other': '0 tril.'
    },
    '10000000000000': {
      'other': '00 tril.'
    },
    '100000000000000': {
      'other': '000 tril.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 de mii'
    },
    '10000': {
      'other': '00 de mii'
    },
    '100000': {
      'other': '000 de mii'
    },
    '1000000': {
      'other': '0 de milioane'
    },
    '10000000': {
      'other': '00 de milioane'
    },
    '100000000': {
      'other': '000 de milioane'
    },
    '1000000000': {
      'other': '0 de miliarde'
    },
    '10000000000': {
      'other': '00 de miliarde'
    },
    '100000000000': {
      'other': '000 de miliarde'
    },
    '1000000000000': {
      'other': '0 de trilioane'
    },
    '10000000000000': {
      'other': '00 de trilioane'
    },
    '100000000000000': {
      'other': '000 de trilioane'
    }
  }
};


/**
 * Compact number formatting symbols for locale mr.
 */
goog.i18n.CompactNumberFormatSymbols_mr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 ह'
    },
    '10000': {
      'other': '00 ह'
    },
    '100000': {
      'other': '0 लाख'
    },
    '1000000': {
      'other': '00 लाख'
    },
    '10000000': {
      'other': '0 कोटी'
    },
    '100000000': {
      'other': '00 कोटी'
    },
    '1000000000': {
      'other': '0 अब्ज'
    },
    '10000000000': {
      'other': '00 अब्ज'
    },
    '100000000000': {
      'other': '0 खर्व'
    },
    '1000000000000': {
      'other': '00 खर्व'
    },
    '10000000000000': {
      'other': '0 पद्म'
    },
    '100000000000000': {
      'other': '00 पद्म'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 हजार'
    },
    '10000': {
      'other': '00 हजार'
    },
    '100000': {
      'other': '0 लाख'
    },
    '1000000': {
      'other': '00 लाख'
    },
    '10000000': {
      'other': '0 कोटी'
    },
    '100000000': {
      'other': '00 कोटी'
    },
    '1000000000': {
      'other': '0 अब्ज'
    },
    '10000000000': {
      'other': '00 अब्ज'
    },
    '100000000000': {
      'other': '0 खर्व'
    },
    '1000000000000': {
      'other': '00 खर्व'
    },
    '10000000000000': {
      'other': '0 पद्म'
    },
    '100000000000000': {
      'other': '00 पद्म'
    }
  }
};


/**
 * Compact number formatting symbols for locale ms.
 */
goog.i18n.CompactNumberFormatSymbols_ms = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0J'
    },
    '10000000': {
      'other': '00J'
    },
    '100000000': {
      'other': '000J'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ribu'
    },
    '10000': {
      'other': '00 ribu'
    },
    '100000': {
      'other': '000 ribu'
    },
    '1000000': {
      'other': '0 juta'
    },
    '10000000': {
      'other': '00 juta'
    },
    '100000000': {
      'other': '000 juta'
    },
    '1000000000': {
      'other': '0 bilion'
    },
    '10000000000': {
      'other': '00 bilion'
    },
    '100000000000': {
      'other': '000 bilion'
    },
    '1000000000000': {
      'other': '0 trilion'
    },
    '10000000000000': {
      'other': '00 trilion'
    },
    '100000000000000': {
      'other': '000 trilion'
    }
  }
};


/**
 * Compact number formatting symbols for locale mt.
 */
goog.i18n.CompactNumberFormatSymbols_mt = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale my.
 */
goog.i18n.CompactNumberFormatSymbols_my = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0ထောင်'
    },
    '10000': {
      'other': '0သောင်း'
    },
    '100000': {
      'other': '0သိန်း'
    },
    '1000000': {
      'other': '0သန်း'
    },
    '10000000': {
      'other': '0ကုဋေ'
    },
    '100000000': {
      'other': '00ကုဋေ'
    },
    '1000000000': {
      'other': 'ကုဋေ000'
    },
    '10000000000': {
      'other': 'ကုဋေ0ထ'
    },
    '100000000000': {
      'other': 'ကုဋေ0သ'
    },
    '1000000000000': {
      'other': 'ဋေ0သိန်း'
    },
    '10000000000000': {
      'other': 'ဋေ0သန်း'
    },
    '100000000000000': {
      'other': '0ကောဋိ'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0ထောင်'
    },
    '10000': {
      'other': '0သောင်း'
    },
    '100000': {
      'other': '0သိန်း'
    },
    '1000000': {
      'other': '0သန်း'
    },
    '10000000': {
      'other': '0ကုဋေ'
    },
    '100000000': {
      'other': '00ကုဋေ'
    },
    '1000000000': {
      'other': 'ကုဋေ000'
    },
    '10000000000': {
      'other': 'ကုဋေ0000'
    },
    '100000000000': {
      'other': 'ကုဋေ0သောင်း'
    },
    '1000000000000': {
      'other': 'ကုဋေ0သိန်း'
    },
    '10000000000000': {
      'other': 'ကုဋေ0သန်း'
    },
    '100000000000000': {
      'other': '0ကောဋိ'
    }
  }
};


/**
 * Compact number formatting symbols for locale nb.
 */
goog.i18n.CompactNumberFormatSymbols_nb = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000': {
      'other': '0 mill.'
    },
    '10000000': {
      'other': '00 mill.'
    },
    '100000000': {
      'other': '000 mill.'
    },
    '1000000000': {
      'other': '0 mrd.'
    },
    '10000000000': {
      'other': '00 mrd.'
    },
    '100000000000': {
      'other': '000 mrd.'
    },
    '1000000000000': {
      'other': '0 bill.'
    },
    '10000000000000': {
      'other': '00 bill.'
    },
    '100000000000000': {
      'other': '000 bill.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tusen'
    },
    '10000': {
      'other': '00 tusen'
    },
    '100000': {
      'other': '000 tusen'
    },
    '1000000': {
      'other': '0 millioner'
    },
    '10000000': {
      'other': '00 millioner'
    },
    '100000000': {
      'other': '000 millioner'
    },
    '1000000000': {
      'other': '0 milliarder'
    },
    '10000000000': {
      'other': '00 milliarder'
    },
    '100000000000': {
      'other': '000 milliarder'
    },
    '1000000000000': {
      'other': '0 billioner'
    },
    '10000000000000': {
      'other': '00 billioner'
    },
    '100000000000000': {
      'other': '000 billioner'
    }
  }
};


/**
 * Compact number formatting symbols for locale ne.
 */
goog.i18n.CompactNumberFormatSymbols_ne = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 हजार'
    },
    '10000': {
      'other': '00 हजार'
    },
    '100000': {
      'other': '0 लाख'
    },
    '1000000': {
      'other': '00 लाख'
    },
    '10000000': {
      'other': '0 करोड'
    },
    '100000000': {
      'other': '00 करोड'
    },
    '1000000000': {
      'other': '0 अरब'
    },
    '10000000000': {
      'other': '00 अरब'
    },
    '100000000000': {
      'other': '0 खरब'
    },
    '1000000000000': {
      'other': '00 खरब'
    },
    '10000000000000': {
      'other': '0 शंख'
    },
    '100000000000000': {
      'other': '00 शंख'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 हजार'
    },
    '10000': {
      'other': '00 हजार'
    },
    '100000': {
      'other': '0 लाख'
    },
    '1000000': {
      'other': '0 करोड'
    },
    '10000000': {
      'other': '00 करोड'
    },
    '100000000': {
      'other': '000 करोड'
    },
    '1000000000': {
      'other': '0 अरब'
    },
    '10000000000': {
      'other': '00 अरब'
    },
    '100000000000': {
      'other': '000 अरब'
    },
    '1000000000000': {
      'other': '00 खरब'
    },
    '10000000000000': {
      'other': '0 शंख'
    },
    '100000000000000': {
      'other': '00 शंख'
    }
  }
};


/**
 * Compact number formatting symbols for locale nl.
 */
goog.i18n.CompactNumberFormatSymbols_nl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0 mln.'
    },
    '10000000': {
      'other': '00 mln.'
    },
    '100000000': {
      'other': '000 mln.'
    },
    '1000000000': {
      'other': '0 mld.'
    },
    '10000000000': {
      'other': '00 mld.'
    },
    '100000000000': {
      'other': '000 mld.'
    },
    '1000000000000': {
      'other': '0 bln.'
    },
    '10000000000000': {
      'other': '00 bln.'
    },
    '100000000000000': {
      'other': '000 bln.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 duizend'
    },
    '10000': {
      'other': '00 duizend'
    },
    '100000': {
      'other': '000 duizend'
    },
    '1000000': {
      'other': '0 miljoen'
    },
    '10000000': {
      'other': '00 miljoen'
    },
    '100000000': {
      'other': '000 miljoen'
    },
    '1000000000': {
      'other': '0 miljard'
    },
    '10000000000': {
      'other': '00 miljard'
    },
    '100000000000': {
      'other': '000 miljard'
    },
    '1000000000000': {
      'other': '0 biljoen'
    },
    '10000000000000': {
      'other': '00 biljoen'
    },
    '100000000000000': {
      'other': '000 biljoen'
    }
  }
};


/**
 * Compact number formatting symbols for locale no.
 */
goog.i18n.CompactNumberFormatSymbols_no = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000': {
      'other': '0 mill.'
    },
    '10000000': {
      'other': '00 mill.'
    },
    '100000000': {
      'other': '000 mill.'
    },
    '1000000000': {
      'other': '0 mrd.'
    },
    '10000000000': {
      'other': '00 mrd.'
    },
    '100000000000': {
      'other': '000 mrd.'
    },
    '1000000000000': {
      'other': '0 bill.'
    },
    '10000000000000': {
      'other': '00 bill.'
    },
    '100000000000000': {
      'other': '000 bill.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tusen'
    },
    '10000': {
      'other': '00 tusen'
    },
    '100000': {
      'other': '000 tusen'
    },
    '1000000': {
      'other': '0 millioner'
    },
    '10000000': {
      'other': '00 millioner'
    },
    '100000000': {
      'other': '000 millioner'
    },
    '1000000000': {
      'other': '0 milliarder'
    },
    '10000000000': {
      'other': '00 milliarder'
    },
    '100000000000': {
      'other': '000 milliarder'
    },
    '1000000000000': {
      'other': '0 billioner'
    },
    '10000000000000': {
      'other': '00 billioner'
    },
    '100000000000000': {
      'other': '000 billioner'
    }
  }
};


/**
 * Compact number formatting symbols for locale no_NO.
 */
goog.i18n.CompactNumberFormatSymbols_no_NO = goog.i18n.CompactNumberFormatSymbols_no;


/**
 * Compact number formatting symbols for locale or.
 */
goog.i18n.CompactNumberFormatSymbols_or = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0ହ'
    },
    '10000': {
      'other': '00ହ'
    },
    '100000': {
      'other': '000ହ'
    },
    '1000000': {
      'other': '0ନି'
    },
    '10000000': {
      'other': '00ନି'
    },
    '100000000': {
      'other': '000ନି'
    },
    '1000000000': {
      'other': '0ବି'
    },
    '10000000000': {
      'other': '00ବି'
    },
    '100000000000': {
      'other': '000ବି'
    },
    '1000000000000': {
      'other': '0ଟ୍ରି'
    },
    '10000000000000': {
      'other': '00ଟ୍ରି'
    },
    '100000000000000': {
      'other': '000ଟ୍ରି'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ହଜାର'
    },
    '10000': {
      'other': '00 ହଜାର'
    },
    '100000': {
      'other': '000 ହଜାର'
    },
    '1000000': {
      'other': '0 ନିୟୁତ'
    },
    '10000000': {
      'other': '00 ନିୟୁତ'
    },
    '100000000': {
      'other': '000 ନିୟୁତ'
    },
    '1000000000': {
      'other': '0 ଶହକୋଟି'
    },
    '10000000000': {
      'other': '00 ଶହକୋଟି'
    },
    '100000000000': {
      'other': '000 ଶହକୋଟି'
    },
    '1000000000000': {
      'other': '0 ଲକ୍ଷକୋଟି'
    },
    '10000000000000': {
      'other': '00 ଲକ୍ଷକୋଟି'
    },
    '100000000000000': {
      'other': '000 ଲକ୍ଷକୋଟି'
    }
  }
};


/**
 * Compact number formatting symbols for locale pa.
 */
goog.i18n.CompactNumberFormatSymbols_pa = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 ਹਜ਼ਾਰ'
    },
    '10000': {
      'other': '00 ਹਜ਼ਾਰ'
    },
    '100000': {
      'other': '0 ਲੱਖ'
    },
    '1000000': {
      'other': '00 ਲੱਖ'
    },
    '10000000': {
      'other': '0 ਕਰੋੜ'
    },
    '100000000': {
      'other': '00 ਕਰੋੜ'
    },
    '1000000000': {
      'other': '0 ਅਰਬ'
    },
    '10000000000': {
      'other': '00 ਅਰਬ'
    },
    '100000000000': {
      'other': '0 ਖਰਬ'
    },
    '1000000000000': {
      'other': '00 ਖਰਬ'
    },
    '10000000000000': {
      'other': '0 ਨੀਲ'
    },
    '100000000000000': {
      'other': '00 ਨੀਲ'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ਹਜ਼ਾਰ'
    },
    '10000': {
      'other': '00 ਹਜ਼ਾਰ'
    },
    '100000': {
      'other': '0 ਲੱਖ'
    },
    '1000000': {
      'other': '00 ਲੱਖ'
    },
    '10000000': {
      'other': '0 ਕਰੋੜ'
    },
    '100000000': {
      'other': '00 ਕਰੋੜ'
    },
    '1000000000': {
      'other': '0 ਅਰਬ'
    },
    '10000000000': {
      'other': '00 ਅਰਬ'
    },
    '100000000000': {
      'other': '0 ਖਰਬ'
    },
    '1000000000000': {
      'other': '00 ਖਰਬ'
    },
    '10000000000000': {
      'other': '0 ਨੀਲ'
    },
    '100000000000000': {
      'other': '00 ਨੀਲ'
    }
  }
};


/**
 * Compact number formatting symbols for locale pl.
 */
goog.i18n.CompactNumberFormatSymbols_pl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tys.'
    },
    '10000': {
      'other': '00 tys.'
    },
    '100000': {
      'other': '000 tys.'
    },
    '1000000': {
      'other': '0 mln'
    },
    '10000000': {
      'other': '00 mln'
    },
    '100000000': {
      'other': '000 mln'
    },
    '1000000000': {
      'other': '0 mld'
    },
    '10000000000': {
      'other': '00 mld'
    },
    '100000000000': {
      'other': '000 mld'
    },
    '1000000000000': {
      'other': '0 bln'
    },
    '10000000000000': {
      'other': '00 bln'
    },
    '100000000000000': {
      'other': '000 bln'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tysiąca'
    },
    '10000': {
      'other': '00 tysiąca'
    },
    '100000': {
      'other': '000 tysiąca'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 miliarda'
    },
    '10000000000': {
      'other': '00 miliarda'
    },
    '100000000000': {
      'other': '000 miliarda'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt.
 */
goog.i18n.CompactNumberFormatSymbols_pt = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 mi'
    },
    '10000000': {
      'other': '00 mi'
    },
    '100000000': {
      'other': '000 mi'
    },
    '1000000000': {
      'other': '0 bi'
    },
    '10000000000': {
      'other': '00 bi'
    },
    '100000000000': {
      'other': '000 bi'
    },
    '1000000000000': {
      'other': '0 tri'
    },
    '10000000000000': {
      'other': '00 tri'
    },
    '100000000000000': {
      'other': '000 tri'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 bilhões'
    },
    '10000000000': {
      'other': '00 bilhões'
    },
    '100000000000': {
      'other': '000 bilhões'
    },
    '1000000000000': {
      'other': '0 trilhões'
    },
    '10000000000000': {
      'other': '00 trilhões'
    },
    '100000000000000': {
      'other': '000 trilhões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_BR.
 */
goog.i18n.CompactNumberFormatSymbols_pt_BR = goog.i18n.CompactNumberFormatSymbols_pt;


/**
 * Compact number formatting symbols for locale pt_PT.
 */
goog.i18n.CompactNumberFormatSymbols_pt_PT = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale ro.
 */
goog.i18n.CompactNumberFormatSymbols_ro = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 K'
    },
    '10000': {
      'other': '00 K'
    },
    '100000': {
      'other': '000 K'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mld.'
    },
    '10000000000': {
      'other': '00 mld.'
    },
    '100000000000': {
      'other': '000 mld.'
    },
    '1000000000000': {
      'other': '0 tril.'
    },
    '10000000000000': {
      'other': '00 tril.'
    },
    '100000000000000': {
      'other': '000 tril.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 de mii'
    },
    '10000': {
      'other': '00 de mii'
    },
    '100000': {
      'other': '000 de mii'
    },
    '1000000': {
      'other': '0 de milioane'
    },
    '10000000': {
      'other': '00 de milioane'
    },
    '100000000': {
      'other': '000 de milioane'
    },
    '1000000000': {
      'other': '0 de miliarde'
    },
    '10000000000': {
      'other': '00 de miliarde'
    },
    '100000000000': {
      'other': '000 de miliarde'
    },
    '1000000000000': {
      'other': '0 de trilioane'
    },
    '10000000000000': {
      'other': '00 de trilioane'
    },
    '100000000000000': {
      'other': '000 de trilioane'
    }
  }
};


/**
 * Compact number formatting symbols for locale ru.
 */
goog.i18n.CompactNumberFormatSymbols_ru = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 тыс.'
    },
    '10000': {
      'other': '00 тыс.'
    },
    '100000': {
      'other': '000 тыс.'
    },
    '1000000': {
      'other': '0 млн'
    },
    '10000000': {
      'other': '00 млн'
    },
    '100000000': {
      'other': '000 млн'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 трлн'
    },
    '10000000000000': {
      'other': '00 трлн'
    },
    '100000000000000': {
      'other': '000 трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 тысячи'
    },
    '10000': {
      'other': '00 тысячи'
    },
    '100000': {
      'other': '000 тысячи'
    },
    '1000000': {
      'other': '0 миллиона'
    },
    '10000000': {
      'other': '00 миллиона'
    },
    '100000000': {
      'other': '000 миллиона'
    },
    '1000000000': {
      'other': '0 миллиарда'
    },
    '10000000000': {
      'other': '00 миллиарда'
    },
    '100000000000': {
      'other': '000 миллиарда'
    },
    '1000000000000': {
      'other': '0 триллиона'
    },
    '10000000000000': {
      'other': '00 триллиона'
    },
    '100000000000000': {
      'other': '000 триллиона'
    }
  }
};


/**
 * Compact number formatting symbols for locale sh.
 */
goog.i18n.CompactNumberFormatSymbols_sh = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 hilj.'
    },
    '10000': {
      'other': '00 hilj.'
    },
    '100000': {
      'other': '000 hilj.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mlrd.'
    },
    '10000000000': {
      'other': '00 mlrd.'
    },
    '100000000000': {
      'other': '000 mlrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 hiljada'
    },
    '10000': {
      'other': '00 hiljada'
    },
    '100000': {
      'other': '000 hiljada'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale si.
 */
goog.i18n.CompactNumberFormatSymbols_si = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': 'ද0'
    },
    '10000': {
      'other': 'ද00'
    },
    '100000': {
      'other': 'ද000'
    },
    '1000000': {
      'other': 'මි0'
    },
    '10000000': {
      'other': 'මි00'
    },
    '100000000': {
      'other': 'මි000'
    },
    '1000000000': {
      'other': 'බි0'
    },
    '10000000000': {
      'other': 'බි00'
    },
    '100000000000': {
      'other': 'බි000'
    },
    '1000000000000': {
      'other': 'ට්‍රි0'
    },
    '10000000000000': {
      'other': 'ට්‍රි00'
    },
    '100000000000000': {
      'other': 'ට්‍රි000'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': 'දහස 0'
    },
    '10000': {
      'other': 'දහස 00'
    },
    '100000': {
      'other': 'දහස 000'
    },
    '1000000': {
      'other': 'මිලියන 0'
    },
    '10000000': {
      'other': 'මිලියන 00'
    },
    '100000000': {
      'other': 'මිලියන 000'
    },
    '1000000000': {
      'other': 'බිලියන 0'
    },
    '10000000000': {
      'other': 'බිලියන 00'
    },
    '100000000000': {
      'other': 'බිලියන 000'
    },
    '1000000000000': {
      'other': 'ට්‍රිලියන 0'
    },
    '10000000000000': {
      'other': 'ට්‍රිලියන 00'
    },
    '100000000000000': {
      'other': 'ට්‍රිලියන 000'
    }
  }
};


/**
 * Compact number formatting symbols for locale sk.
 */
goog.i18n.CompactNumberFormatSymbols_sk = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tis.'
    },
    '10000': {
      'other': '00 tis.'
    },
    '100000': {
      'other': '000 tis.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mld.'
    },
    '10000000000': {
      'other': '00 mld.'
    },
    '100000000000': {
      'other': '000 mld.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tisíc'
    },
    '10000': {
      'other': '00 tisíc'
    },
    '100000': {
      'other': '000 tisíc'
    },
    '1000000': {
      'other': '0 miliónov'
    },
    '10000000': {
      'other': '00 miliónov'
    },
    '100000000': {
      'other': '000 miliónov'
    },
    '1000000000': {
      'other': '0 miliárd'
    },
    '10000000000': {
      'other': '00 miliárd'
    },
    '100000000000': {
      'other': '000 miliárd'
    },
    '1000000000000': {
      'other': '0 biliónov'
    },
    '10000000000000': {
      'other': '00 biliónov'
    },
    '100000000000000': {
      'other': '000 biliónov'
    }
  }
};


/**
 * Compact number formatting symbols for locale sl.
 */
goog.i18n.CompactNumberFormatSymbols_sl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tis.'
    },
    '10000': {
      'other': '00 tis.'
    },
    '100000': {
      'other': '000 tis.'
    },
    '1000000': {
      'other': '0 mio.'
    },
    '10000000': {
      'other': '00 mio.'
    },
    '100000000': {
      'other': '000 mio.'
    },
    '1000000000': {
      'other': '0 mrd.'
    },
    '10000000000': {
      'other': '00 mrd.'
    },
    '100000000000': {
      'other': '000 mrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tisoč'
    },
    '10000': {
      'other': '00 tisoč'
    },
    '100000': {
      'other': '000 tisoč'
    },
    '1000000': {
      'other': '0 milijonov'
    },
    '10000000': {
      'other': '00 milijonov'
    },
    '100000000': {
      'other': '000 milijonov'
    },
    '1000000000': {
      'other': '0 milijard'
    },
    '10000000000': {
      'other': '00 milijard'
    },
    '100000000000': {
      'other': '000 milijard'
    },
    '1000000000000': {
      'other': '0 bilijonov'
    },
    '10000000000000': {
      'other': '00 bilijonov'
    },
    '100000000000000': {
      'other': '000 bilijonov'
    }
  }
};


/**
 * Compact number formatting symbols for locale sq.
 */
goog.i18n.CompactNumberFormatSymbols_sq = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 mijë'
    },
    '10000': {
      'other': '00 mijë'
    },
    '100000': {
      'other': '000 mijë'
    },
    '1000000': {
      'other': '0 mln'
    },
    '10000000': {
      'other': '00 mln'
    },
    '100000000': {
      'other': '000 mln'
    },
    '1000000000': {
      'other': '0 mld'
    },
    '10000000000': {
      'other': '00 mld'
    },
    '100000000000': {
      'other': '000 mld'
    },
    '1000000000000': {
      'other': '0 bln'
    },
    '10000000000000': {
      'other': '00 bln'
    },
    '100000000000000': {
      'other': '000 bln'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mijë'
    },
    '10000': {
      'other': '00 mijë'
    },
    '100000': {
      'other': '000 mijë'
    },
    '1000000': {
      'other': '0 milion'
    },
    '10000000': {
      'other': '00 milion'
    },
    '100000000': {
      'other': '000 milion'
    },
    '1000000000': {
      'other': '0 miliard'
    },
    '10000000000': {
      'other': '00 miliard'
    },
    '100000000000': {
      'other': '000 miliard'
    },
    '1000000000000': {
      'other': '0 bilion'
    },
    '10000000000000': {
      'other': '00 bilion'
    },
    '100000000000000': {
      'other': '000 bilion'
    }
  }
};


/**
 * Compact number formatting symbols for locale sr.
 */
goog.i18n.CompactNumberFormatSymbols_sr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 хиљ.'
    },
    '10000': {
      'other': '00 хиљ.'
    },
    '100000': {
      'other': '000 хиљ.'
    },
    '1000000': {
      'other': '0 мил.'
    },
    '10000000': {
      'other': '00 мил.'
    },
    '100000000': {
      'other': '000 мил.'
    },
    '1000000000': {
      'other': '0 млрд.'
    },
    '10000000000': {
      'other': '00 млрд.'
    },
    '100000000000': {
      'other': '000 млрд.'
    },
    '1000000000000': {
      'other': '0 бил.'
    },
    '10000000000000': {
      'other': '00 бил.'
    },
    '100000000000000': {
      'other': '000 бил.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 хиљада'
    },
    '10000': {
      'other': '00 хиљада'
    },
    '100000': {
      'other': '000 хиљада'
    },
    '1000000': {
      'other': '0 милиона'
    },
    '10000000': {
      'other': '00 милиона'
    },
    '100000000': {
      'other': '000 милиона'
    },
    '1000000000': {
      'other': '0 милијарди'
    },
    '10000000000': {
      'other': '00 милијарди'
    },
    '100000000000': {
      'other': '000 милијарди'
    },
    '1000000000000': {
      'other': '0 билиона'
    },
    '10000000000000': {
      'other': '00 билиона'
    },
    '100000000000000': {
      'other': '000 билиона'
    }
  }
};


/**
 * Compact number formatting symbols for locale sr_Latn.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Latn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 hilj.'
    },
    '10000': {
      'other': '00 hilj.'
    },
    '100000': {
      'other': '000 hilj.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mlrd.'
    },
    '10000000000': {
      'other': '00 mlrd.'
    },
    '100000000000': {
      'other': '000 mlrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 hiljada'
    },
    '10000': {
      'other': '00 hiljada'
    },
    '100000': {
      'other': '000 hiljada'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale sv.
 */
goog.i18n.CompactNumberFormatSymbols_sv = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tn'
    },
    '10000': {
      'other': '00 tn'
    },
    '100000': {
      'other': '000 tn'
    },
    '1000000': {
      'other': '0 mn'
    },
    '10000000': {
      'other': '00 mn'
    },
    '100000000': {
      'other': '000 mn'
    },
    '1000000000': {
      'other': '0 md'
    },
    '10000000000': {
      'other': '00 md'
    },
    '100000000000': {
      'other': '000 md'
    },
    '1000000000000': {
      'other': '0 bn'
    },
    '10000000000000': {
      'other': '00 bn'
    },
    '100000000000000': {
      'other': '000 bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tusen'
    },
    '10000': {
      'other': '00 tusen'
    },
    '100000': {
      'other': '000 tusen'
    },
    '1000000': {
      'other': '0 miljoner'
    },
    '10000000': {
      'other': '00 miljoner'
    },
    '100000000': {
      'other': '000 miljoner'
    },
    '1000000000': {
      'other': '0 miljarder'
    },
    '10000000000': {
      'other': '00 miljarder'
    },
    '100000000000': {
      'other': '000 miljarder'
    },
    '1000000000000': {
      'other': '0 biljoner'
    },
    '10000000000000': {
      'other': '00 biljoner'
    },
    '100000000000000': {
      'other': '000 biljoner'
    }
  }
};


/**
 * Compact number formatting symbols for locale sw.
 */
goog.i18n.CompactNumberFormatSymbols_sw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': 'elfu 0;elfu -0'
    },
    '10000': {
      'other': 'elfu 00;elfu -00'
    },
    '100000': {
      'other': 'elfu 000;elfu -000'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B;-0B'
    },
    '10000000000': {
      'other': '00B;-00B'
    },
    '100000000000': {
      'other': '000B;-000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': 'elfu 0;elfu -0'
    },
    '10000': {
      'other': 'elfu 00;elfu -00'
    },
    '100000': {
      'other': 'elfu 000;elfu -000'
    },
    '1000000': {
      'other': 'milioni 0;milioni -0'
    },
    '10000000': {
      'other': 'milioni 00;milioni -00'
    },
    '100000000': {
      'other': 'milioni 000;milioni -000'
    },
    '1000000000': {
      'other': 'bilioni 0;bilioni -0'
    },
    '10000000000': {
      'other': 'bilioni 00;bilioni -00'
    },
    '100000000000': {
      'other': 'bilioni 000;bilioni -000'
    },
    '1000000000000': {
      'other': 'trilioni 0;trilioni -0'
    },
    '10000000000000': {
      'other': 'trilioni 00;trilioni -00'
    },
    '100000000000000': {
      'other': 'trilioni 000;trilioni -000'
    }
  }
};


/**
 * Compact number formatting symbols for locale ta.
 */
goog.i18n.CompactNumberFormatSymbols_ta = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0ஆ'
    },
    '10000': {
      'other': '00ஆ'
    },
    '100000': {
      'other': '000ஆ'
    },
    '1000000': {
      'other': '0மி'
    },
    '10000000': {
      'other': '00மி'
    },
    '100000000': {
      'other': '000மி'
    },
    '1000000000': {
      'other': '0பி'
    },
    '10000000000': {
      'other': '00பி'
    },
    '100000000000': {
      'other': '000பி'
    },
    '1000000000000': {
      'other': '0டி'
    },
    '10000000000000': {
      'other': '00டி'
    },
    '100000000000000': {
      'other': '000டி'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ஆயிரம்'
    },
    '10000': {
      'other': '00 ஆயிரம்'
    },
    '100000': {
      'other': '000 ஆயிரம்'
    },
    '1000000': {
      'other': '0 மில்லியன்'
    },
    '10000000': {
      'other': '00 மில்லியன்'
    },
    '100000000': {
      'other': '000 மில்லியன்'
    },
    '1000000000': {
      'other': '0 பில்லியன்'
    },
    '10000000000': {
      'other': '00 பில்லியன்'
    },
    '100000000000': {
      'other': '000 பில்லியன்'
    },
    '1000000000000': {
      'other': '0 டிரில்லியன்'
    },
    '10000000000000': {
      'other': '00 டிரில்லியன்'
    },
    '100000000000000': {
      'other': '000 டிரில்லியன்'
    }
  }
};


/**
 * Compact number formatting symbols for locale te.
 */
goog.i18n.CompactNumberFormatSymbols_te = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0వే'
    },
    '10000': {
      'other': '00వే'
    },
    '100000': {
      'other': '000వే'
    },
    '1000000': {
      'other': '0మి'
    },
    '10000000': {
      'other': '00మి'
    },
    '100000000': {
      'other': '000మి'
    },
    '1000000000': {
      'other': '0బి'
    },
    '10000000000': {
      'other': '00బి'
    },
    '100000000000': {
      'other': '000బి'
    },
    '1000000000000': {
      'other': '0ట్రి'
    },
    '10000000000000': {
      'other': '00ట్రి'
    },
    '100000000000000': {
      'other': '000ట్రి'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 వేలు'
    },
    '10000': {
      'other': '00 వేలు'
    },
    '100000': {
      'other': '000 వేలు'
    },
    '1000000': {
      'other': '0 మిలియన్లు'
    },
    '10000000': {
      'other': '00 మిలియన్లు'
    },
    '100000000': {
      'other': '000 మిలియన్లు'
    },
    '1000000000': {
      'other': '0 బిలియన్లు'
    },
    '10000000000': {
      'other': '00 బిలియన్లు'
    },
    '100000000000': {
      'other': '000 బిలియన్లు'
    },
    '1000000000000': {
      'other': '0 ట్రిలియన్లు'
    },
    '10000000000000': {
      'other': '00 ట్రిలియన్లు'
    },
    '100000000000000': {
      'other': '000 ట్రిలియన్లు'
    }
  }
};


/**
 * Compact number formatting symbols for locale th.
 */
goog.i18n.CompactNumberFormatSymbols_th = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 พัน'
    },
    '10000': {
      'other': '0 หมื่น'
    },
    '100000': {
      'other': '0 แสน'
    },
    '1000000': {
      'other': '0 ล้าน'
    },
    '10000000': {
      'other': '00 ล้าน'
    },
    '100000000': {
      'other': '000 ล้าน'
    },
    '1000000000': {
      'other': '0 พันล้าน'
    },
    '10000000000': {
      'other': '0 หมื่นล้าน'
    },
    '100000000000': {
      'other': '0 แสนล้าน'
    },
    '1000000000000': {
      'other': '0 ล้านล้าน'
    },
    '10000000000000': {
      'other': '00 ล้านล้าน'
    },
    '100000000000000': {
      'other': '000 ล้านล้าน'
    }
  }
};


/**
 * Compact number formatting symbols for locale tl.
 */
goog.i18n.CompactNumberFormatSymbols_tl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 na libo'
    },
    '10000': {
      'other': '00 na libo'
    },
    '100000': {
      'other': '000 na libo'
    },
    '1000000': {
      'other': '0 na milyon'
    },
    '10000000': {
      'other': '00 na milyon'
    },
    '100000000': {
      'other': '000 na milyon'
    },
    '1000000000': {
      'other': '0 na bilyon'
    },
    '10000000000': {
      'other': '00 na bilyon'
    },
    '100000000000': {
      'other': '000 na bilyon'
    },
    '1000000000000': {
      'other': '0 na trilyon'
    },
    '10000000000000': {
      'other': '00 na trilyon'
    },
    '100000000000000': {
      'other': '000 na trilyon'
    }
  }
};


/**
 * Compact number formatting symbols for locale tr.
 */
goog.i18n.CompactNumberFormatSymbols_tr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 B'
    },
    '10000': {
      'other': '00 B'
    },
    '100000': {
      'other': '000 B'
    },
    '1000000': {
      'other': '0 Mn'
    },
    '10000000': {
      'other': '00 Mn'
    },
    '100000000': {
      'other': '000 Mn'
    },
    '1000000000': {
      'other': '0 Mr'
    },
    '10000000000': {
      'other': '00 Mr'
    },
    '100000000000': {
      'other': '000 Mr'
    },
    '1000000000000': {
      'other': '0 Tn'
    },
    '10000000000000': {
      'other': '00 Tn'
    },
    '100000000000000': {
      'other': '000 Tn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 bin'
    },
    '10000': {
      'other': '00 bin'
    },
    '100000': {
      'other': '000 bin'
    },
    '1000000': {
      'other': '0 milyon'
    },
    '10000000': {
      'other': '00 milyon'
    },
    '100000000': {
      'other': '000 milyon'
    },
    '1000000000': {
      'other': '0 milyar'
    },
    '10000000000': {
      'other': '00 milyar'
    },
    '100000000000': {
      'other': '000 milyar'
    },
    '1000000000000': {
      'other': '0 trilyon'
    },
    '10000000000000': {
      'other': '00 trilyon'
    },
    '100000000000000': {
      'other': '000 trilyon'
    }
  }
};


/**
 * Compact number formatting symbols for locale uk.
 */
goog.i18n.CompactNumberFormatSymbols_uk = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 тис.'
    },
    '10000': {
      'other': '00 тис.'
    },
    '100000': {
      'other': '000 тис.'
    },
    '1000000': {
      'other': '0 млн'
    },
    '10000000': {
      'other': '00 млн'
    },
    '100000000': {
      'other': '000 млн'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 трлн'
    },
    '10000000000000': {
      'other': '00 трлн'
    },
    '100000000000000': {
      'other': '000 трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 тисячі'
    },
    '10000': {
      'other': '00 тисячі'
    },
    '100000': {
      'other': '000 тисячі'
    },
    '1000000': {
      'other': '0 мільйона'
    },
    '10000000': {
      'other': '00 мільйона'
    },
    '100000000': {
      'other': '000 мільйона'
    },
    '1000000000': {
      'other': '0 мільярда'
    },
    '10000000000': {
      'other': '00 мільярда'
    },
    '100000000000': {
      'other': '000 мільярда'
    },
    '1000000000000': {
      'other': '0 трильйона'
    },
    '10000000000000': {
      'other': '00 трильйона'
    },
    '100000000000000': {
      'other': '000 трильйона'
    }
  }
};


/**
 * Compact number formatting symbols for locale ur.
 */
goog.i18n.CompactNumberFormatSymbols_ur = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 ہزار'
    },
    '10000': {
      'other': '00 ہزار'
    },
    '100000': {
      'other': '0 لاکھ'
    },
    '1000000': {
      'other': '00 لاکھ'
    },
    '10000000': {
      'other': '0 کروڑ'
    },
    '100000000': {
      'other': '00 کروڑ'
    },
    '1000000000': {
      'other': '0 ارب'
    },
    '10000000000': {
      'other': '00 ارب'
    },
    '100000000000': {
      'other': '0 کھرب'
    },
    '1000000000000': {
      'other': '00 کھرب'
    },
    '10000000000000': {
      'other': '00 ٹریلین'
    },
    '100000000000000': {
      'other': '000 ٹریلین'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ہزار'
    },
    '10000': {
      'other': '00 ہزار'
    },
    '100000': {
      'other': '0 لاکھ'
    },
    '1000000': {
      'other': '00 لاکھ'
    },
    '10000000': {
      'other': '0 کروڑ'
    },
    '100000000': {
      'other': '00 کروڑ'
    },
    '1000000000': {
      'other': '0 ارب'
    },
    '10000000000': {
      'other': '00 ارب'
    },
    '100000000000': {
      'other': '0 کھرب'
    },
    '1000000000000': {
      'other': '00 کھرب'
    },
    '10000000000000': {
      'other': '00 ٹریلین'
    },
    '100000000000000': {
      'other': '000 ٹریلین'
    }
  }
};


/**
 * Compact number formatting symbols for locale uz.
 */
goog.i18n.CompactNumberFormatSymbols_uz = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 ming'
    },
    '10000': {
      'other': '00 ming'
    },
    '100000': {
      'other': '000 ming'
    },
    '1000000': {
      'other': '0 mln'
    },
    '10000000': {
      'other': '00 mln'
    },
    '100000000': {
      'other': '000 mln'
    },
    '1000000000': {
      'other': '0 mlrd'
    },
    '10000000000': {
      'other': '00 mlrd'
    },
    '100000000000': {
      'other': '000 mlrd'
    },
    '1000000000000': {
      'other': '0 trln'
    },
    '10000000000000': {
      'other': '00 trln'
    },
    '100000000000000': {
      'other': '000 trln'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ming'
    },
    '10000': {
      'other': '00 ming'
    },
    '100000': {
      'other': '000 ming'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 milliard'
    },
    '10000000000': {
      'other': '00 milliard'
    },
    '100000000000': {
      'other': '000 milliard'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale vi.
 */
goog.i18n.CompactNumberFormatSymbols_vi = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 N'
    },
    '10000': {
      'other': '00 N'
    },
    '100000': {
      'other': '000 N'
    },
    '1000000': {
      'other': '0 Tr'
    },
    '10000000': {
      'other': '00 Tr'
    },
    '100000000': {
      'other': '000 Tr'
    },
    '1000000000': {
      'other': '0 T'
    },
    '10000000000': {
      'other': '00 T'
    },
    '100000000000': {
      'other': '000 T'
    },
    '1000000000000': {
      'other': '0 NT'
    },
    '10000000000000': {
      'other': '00 NT'
    },
    '100000000000000': {
      'other': '000 NT'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 nghìn'
    },
    '10000': {
      'other': '00 nghìn'
    },
    '100000': {
      'other': '000 nghìn'
    },
    '1000000': {
      'other': '0 triệu'
    },
    '10000000': {
      'other': '00 triệu'
    },
    '100000000': {
      'other': '000 triệu'
    },
    '1000000000': {
      'other': '0 tỷ'
    },
    '10000000000': {
      'other': '00 tỷ'
    },
    '100000000000': {
      'other': '000 tỷ'
    },
    '1000000000000': {
      'other': '0 nghìn tỷ'
    },
    '10000000000000': {
      'other': '00 nghìn tỷ'
    },
    '100000000000000': {
      'other': '000 nghìn tỷ'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh.
 */
goog.i18n.CompactNumberFormatSymbols_zh = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0万'
    },
    '100000': {
      'other': '00万'
    },
    '1000000': {
      'other': '000万'
    },
    '10000000': {
      'other': '0000万'
    },
    '100000000': {
      'other': '0亿'
    },
    '1000000000': {
      'other': '00亿'
    },
    '10000000000': {
      'other': '000亿'
    },
    '100000000000': {
      'other': '0000亿'
    },
    '1000000000000': {
      'other': '0万亿'
    },
    '10000000000000': {
      'other': '00万亿'
    },
    '100000000000000': {
      'other': '000万亿'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0万'
    },
    '100000': {
      'other': '00万'
    },
    '1000000': {
      'other': '000万'
    },
    '10000000': {
      'other': '0000万'
    },
    '100000000': {
      'other': '0亿'
    },
    '1000000000': {
      'other': '00亿'
    },
    '10000000000': {
      'other': '000亿'
    },
    '100000000000': {
      'other': '0000亿'
    },
    '1000000000000': {
      'other': '0万亿'
    },
    '10000000000000': {
      'other': '00万亿'
    },
    '100000000000000': {
      'other': '000万亿'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh_CN.
 */
goog.i18n.CompactNumberFormatSymbols_zh_CN = goog.i18n.CompactNumberFormatSymbols_zh;


/**
 * Compact number formatting symbols for locale zh_HK.
 */
goog.i18n.CompactNumberFormatSymbols_zh_HK = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh_TW.
 */
goog.i18n.CompactNumberFormatSymbols_zh_TW = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  }
};


/**
 * Compact number formatting symbols for locale zu.
 */
goog.i18n.CompactNumberFormatSymbols_zu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 inkulungwane'
    },
    '10000': {
      'other': '00 inkulungwane'
    },
    '100000': {
      'other': '000 inkulungwane'
    },
    '1000000': {
      'other': '0 isigidi'
    },
    '10000000': {
      'other': '00 isigidi'
    },
    '100000000': {
      'other': '000 isigidi'
    },
    '1000000000': {
      'other': '0 isigidi sezigidi'
    },
    '10000000000': {
      'other': '00 isigidi sezigidi'
    },
    '100000000000': {
      'other': '000 isigidi sezigidi'
    },
    '1000000000000': {
      'other': '0 isigidintathu'
    },
    '10000000000000': {
      'other': '00 isigidintathu'
    },
    '100000000000000': {
      'other': '000 isigidintathu'
    }
  }
};


/**
 * Select compact number formatting symbols by locale.
 */
goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;

switch (goog.LOCALE) {
  case 'af':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_af;
    break;
  case 'am':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_am;
    break;
  case 'ar':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar;
    break;
  case 'ar_DZ':
  case 'ar-DZ':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_DZ;
    break;
  case 'ar_EG':
  case 'ar-EG':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_EG;
    break;
  case 'az':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_az;
    break;
  case 'be':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_be;
    break;
  case 'bg':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bg;
    break;
  case 'bn':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bn;
    break;
  case 'br':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_br;
    break;
  case 'bs':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bs;
    break;
  case 'ca':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca;
    break;
  case 'chr':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_chr;
    break;
  case 'cs':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cs;
    break;
  case 'cy':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cy;
    break;
  case 'da':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_da;
    break;
  case 'de':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de;
    break;
  case 'de_AT':
  case 'de-AT':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_AT;
    break;
  case 'de_CH':
  case 'de-CH':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_CH;
    break;
  case 'el':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_el;
    break;
  case 'en':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
    break;
  case 'en_AU':
  case 'en-AU':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_AU;
    break;
  case 'en_CA':
  case 'en-CA':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_CA;
    break;
  case 'en_GB':
  case 'en-GB':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GB;
    break;
  case 'en_IE':
  case 'en-IE':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_IE;
    break;
  case 'en_IN':
  case 'en-IN':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_IN;
    break;
  case 'en_SG':
  case 'en-SG':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SG;
    break;
  case 'en_US':
  case 'en-US':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_US;
    break;
  case 'en_ZA':
  case 'en-ZA':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_ZA;
    break;
  case 'es':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es;
    break;
  case 'es_419':
  case 'es-419':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_419;
    break;
  case 'es_ES':
  case 'es-ES':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_ES;
    break;
  case 'es_MX':
  case 'es-MX':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_MX;
    break;
  case 'es_US':
  case 'es-US':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_US;
    break;
  case 'et':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_et;
    break;
  case 'eu':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_eu;
    break;
  case 'fa':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fa;
    break;
  case 'fi':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fi;
    break;
  case 'fil':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fil;
    break;
  case 'fr':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
    break;
  case 'fr_CA':
  case 'fr-CA':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_CA;
    break;
  case 'ga':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ga;
    break;
  case 'gl':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gl;
    break;
  case 'gsw':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gsw;
    break;
  case 'gu':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gu;
    break;
  case 'haw':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_haw;
    break;
  case 'he':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_he;
    break;
  case 'hi':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hi;
    break;
  case 'hr':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hr;
    break;
  case 'hu':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hu;
    break;
  case 'hy':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hy;
    break;
  case 'id':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_id;
    break;
  case 'in':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_in;
    break;
  case 'is':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_is;
    break;
  case 'it':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_it;
    break;
  case 'iw':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_iw;
    break;
  case 'ja':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ja;
    break;
  case 'ka':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ka;
    break;
  case 'kk':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kk;
    break;
  case 'km':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_km;
    break;
  case 'kn':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kn;
    break;
  case 'ko':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ko;
    break;
  case 'ky':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ky;
    break;
  case 'ln':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ln;
    break;
  case 'lo':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lo;
    break;
  case 'lt':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lt;
    break;
  case 'lv':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lv;
    break;
  case 'mk':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mk;
    break;
  case 'ml':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ml;
    break;
  case 'mn':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mn;
    break;
  case 'mo':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mo;
    break;
  case 'mr':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mr;
    break;
  case 'ms':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ms;
    break;
  case 'mt':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mt;
    break;
  case 'my':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_my;
    break;
  case 'nb':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nb;
    break;
  case 'ne':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ne;
    break;
  case 'nl':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl;
    break;
  case 'no':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_no;
    break;
  case 'no_NO':
  case 'no-NO':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_no_NO;
    break;
  case 'or':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_or;
    break;
  case 'pa':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pa;
    break;
  case 'pl':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pl;
    break;
  case 'pt':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt;
    break;
  case 'pt_BR':
  case 'pt-BR':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_BR;
    break;
  case 'pt_PT':
  case 'pt-PT':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_PT;
    break;
  case 'ro':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ro;
    break;
  case 'ru':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru;
    break;
  case 'sh':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sh;
    break;
  case 'si':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_si;
    break;
  case 'sk':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sk;
    break;
  case 'sl':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sl;
    break;
  case 'sq':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sq;
    break;
  case 'sr':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr;
    break;
  case 'sr_Latn':
  case 'sr-Latn':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Latn;
    break;
  case 'sv':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sv;
    break;
  case 'sw':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sw;
    break;
  case 'ta':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ta;
    break;
  case 'te':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_te;
    break;
  case 'th':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_th;
    break;
  case 'tl':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tl;
    break;
  case 'tr':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tr;
    break;
  case 'uk':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uk;
    break;
  case 'ur':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ur;
    break;
  case 'uz':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uz;
    break;
  case 'vi':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vi;
    break;
  case 'zh':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh;
    break;
  case 'zh_CN':
  case 'zh-CN':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_CN;
    break;
  case 'zh_HK':
  case 'zh-HK':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_HK;
    break;
  case 'zh_TW':
  case 'zh-TW':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_TW;
    break;
  case 'zu':
    goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zu;
    break;
}
