/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */

// AUTOGENERATED. DO NOT EDIT.
// clang-format off

goog.provide('goog.html.htmlTestVectors');
goog.setTestOnly();

goog.html.htmlTestVectors.HTML_TEST_VECTORS = [
    {input: "<body onload=alert('xss')>",
     acceptable: [
         "",
     ],
     name: "body_onload"},
    {input: "<form><input name=\"children\"></form>",
     acceptable: [
         "",
         "<form><input></form>",
         "<form><input /></form>",
     ],
     name: "clobbering_children"},
    {input: "<form><input name=\"firstChild\"></form>",
     acceptable: [
         "",
         "<form><input></form>",
         "<form><input /></form>",
     ],
     name: "clobbering_firstchild"},
    {input: "<form><input name=\"__proto__\"></form>",
     acceptable: [
         "",
         "<form><input></form>",
         "<form><input /></form>",
     ],
     name: "clobbering_proto"},
    {input: "<form><input name=\"tagName\"></form>",
     acceptable: [
         "",
         "<form><input /></form>",
     ],
     name: "clobbering_tagname"},
    {input: "<details open ontoggle=\"alert('xss')\">",
     acceptable: [
         "",
         "<details></details>",
         "<details open></details>",
         "<details open=\"\"></details>",
         "<DETAILS open=\"\" />",
         "<DETAILS open=\"\"></DETAILS>",
     ],
     name: "details"},
    {input: "<iframe src=\"javascript:alert('xss')\">",
     acceptable: [
         "",
         "<iframe></iframe>",
         "<iframe />",
     ],
     name: "iframe_src"},
    {input: "<iframe srcdoc=\"&lt;img src&equals;x:x onerror&equals;alert&lpar;xss&rpar;&gt;\" />",
     acceptable: [
         "",
         "<iframe></iframe>",
         "<iframe />",
     ],
     name: "iframe_srcdoc"},
    {input: "<img src=\"javascript:alert('xss');\">",
     acceptable: [
         "<img src=\"javascript:void(0);\">",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"about:invalid#zCSafez\" />",
         "<img src=\"about:invalid#zCSafez\">",
         "<img>",
         "<img />",
         "<img src=\"unsafe:javascript:alert('xss');\">",
         "<img src=\"about:invalid#zTSz\" />",
         "<img src=\"about:invalid#zClosurez\" />",
     ],
     name: "img"},
    {input: "<!--<img src=\"--><img src=x onerror=alert('xss')//\">",
     acceptable: [
         "<img />",
         "<img src=x>",
         "<img src=\"x\">",
         "<img src=\"x\"/>",
         "<img src=\"x\" />",
         "<img src=\"javascript:void(0);\">",
     ],
     name: "img_comment"},
    {input: "<img \"\"\"><script>alert('xss')</script>\">",
     acceptable: [
         "<img/>&#34;&gt;",
         "<img>&quot;&gt;",
         "<img>\"&gt;",
         "<img />\"&gt;",
         "<img>&#34;&gt;",
     ],
     name: "img_malformed"},
    {input: "<img src=x onerror=\"alert('xxs')\">",
     acceptable: [
         "<img src=\"x\"/>",
         "<img src=\"x\" />",
         "<img src=\"x\">",
         "<img src=x>",
         "<img src=\"javascript:void(0);\">",
         "<img />",
     ],
     name: "img_onerror"},
    {input: "<img src=javascript:alert(&quot;XSS&quot;)>",
     acceptable: [
         "<img src=\"javascript:void(0);\">",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"about:invalid#zCSafez\">",
         "<img>",
         "<img />",
         "<img src=\"about:invalid#zCSafez\" />",
         "<img src=\"unsafe:javascript:alert(&#34;XSS&#34;)\">",
         "<img src=\"about:invalid#zTSz\" />",
         "<img src=\"about:invalid#zClosurez\" />",
     ],
     name: "img_quot"},
    {input: "<style><img src=\"</style><img src=x onerror=alert('xss')//\">",
     acceptable: [
         "",
         "<img />",
         "<img src=x>",
         "<img src=\"x\"/>",
         "<img src=\"x\" />",
         "<img src=\"x\">",
         "<img src=\"javascript:void(0);\">",
     ],
     name: "img_style"},
    {input: "<img src=\"jav&#x09;ascript:alert('xss');\">",
     acceptable: [
         "<img src=\"javascript:void(0);\">",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"about:invalid#zCSafez\">",
         "<img src=\"about:invalid#zCSafez\" />",
         "<img>",
         "<img />",
         "<img src=\"unsafe:jav&#9;ascript:alert('xss');\">",
         "<img src=\"about:invalid#zTSz\" />",
         "<img src=\"about:invalid#zClosurez\" />",
     ],
     name: "img_tab"},
    {input: "<input type=\"image\" src=\"javascript:alert('xss');\">",
     acceptable: [
         "",
         "<input type=\"image\">",
         "<input type=\"image\" />",
         "<input type=\"image\" src=\"about:invalid#zCSafez\">",
         "<input type=\"image\" src=\"about:invalid#zCSafez\" />",
         "<input src=\"about:invalid#zCSafez\" />",
     ],
     name: "input"},
    {input: "<a><a<a>a><a style=\"<a><a<a>a><a\"<a><a<a>a><a >",
     acceptable: [
         "<a>a&gt;<a>a&gt;<a></a></a></a>",
         "<a></a><a></a><a></a>",
         "<a><span>a&gt;</span></a><a><span>a&gt;</span></a><a></a>",
         "<a><span>a&gt;</span></a><a><span>a&gt;</span></a><a />",
         "<a>a&gt;</a><a>a&gt;</a><a></a>",
         "<a /><a /><a />",
     ],
     name: "mess_of_anchors"},
    {input: "\"><noscript><p title=\"</noscript><img src=x onerror=alert(1)>\">",
     acceptable: [
         "",
         "&quot;&gt;",
         "\"&gt;<noscript><p title=\"&lt;/noscript&gt;&lt;img src=x onerror=alert(1)&gt;\"></p></noscript>",
         "\"&gt;<noscript>&lt;p title=\"</noscript><img />\"&gt;",
         "\"&gt;<noscript><p title=\"&lt;/noscript&gt;&lt;img src=x onerror=alert(1)&gt;\" /></noscript>",
         "&#34;&gt;<img src=\"x\"/>&#34;&gt;",
         "\"&gt;<img src=\"x\" />\"&gt;",
         "\"&gt;<p title=\"&lt;/noscript&gt;&lt;img src=x onerror=alert(1)&gt;\">",
         "&quot;&gt;<p title=\"&lt;/noscript&gt;&lt;img src=x onerror=alert(1)&gt;\"></p>",
         "\"&gt;<noscript><p></p></noscript>",
         "\"&gt;",
         "&#34;&gt;<p title=\"&lt;/noscript&gt;&lt;img src=x onerror=alert(1)&gt;\"></p>",
     ],
     name: "mxss_noscript"},
    {input: "<a><a></a></a>",
     acceptable: [
         "<a><a></a></a>",
         "<a></a><a></a>",
         "<a /><a />",
     ],
     name: "nested_anchors"},
    {input: "<object data=\"data:text/html;base64,PHNjcmlwdD5hbGVydCgxKTwvc2NyaXB0Pg==\"></object>",
     acceptable: [
         "",
     ],
     name: "object"},
    {input: "javascript:/*--></title></style></textarea></script></xmp><svg/onload='+/\"/+/onmouseover=1/+/[*/[]/+alert(xss)//'>",
     acceptable: [
         "javascript:/*--&gt;",
     ],
     name: "polygot"},
    {input: "javascript:x//*/javascript:javascript:\"/*'/*`/*--></noscript></title></textarea></style></template></noembed></script><html \" onmouseover=/*&lt;svg/*/onload=xonload=x//><svg onload=x><svg onload=x>*/</style><script>x</script><style>",
     acceptable: [
         "javascript:x//*/javascript:javascript:&quot;/*&#39;/*`/*--&gt;",
         "javascript:x//*/javascript:javascript:&#34;/*&#39;/*`/*--&gt;",
         "javascript:x//*/javascript:javascript:&quot;/*&#39;/*`/*--&gt;*/",
         "javascript:x//*/javascript:javascript:\"/*'/*`/*--&gt;",
         "javascript:x//*/javascript:javascript:\"/*'/*`/*--&gt;*/",
         "javascript:x//*/javascript:javascript:&#34;/*'/*`/*--&gt;*/",
     ],
     name: "polygot_inquisition"},
    {input: "'\"",
     acceptable: [
         "'\"",
         "&#39;&quot;",
         "&#39;&#34;",
         "'&#34;",
     ],
     name: "quotes"},
    {input: "<LINK REL=\"stylesheet\" HREF=\"javascript:alert('xss')\">",
     acceptable: [
         "",
         "<link rel=\"stylesheet\"/>",
         "<link rel=stylesheet>",
         "<link rel=\"stylesheet\">",
         "<link rel=\"stylesheet\" />",
     ],
     name: "remote_stylesheet"},
    {input: "<STYLE>@import'javascript:alert('xss')';</STYLE>",
     acceptable: [
         "",
     ],
     name: "remote_stylesheet2"},
    {input: "<script>alert('xss')</script>",
     acceptable: [
         "",
     ],
     name: "script_alert"},
    {input: "<scrIpt>alert('xss')</scrIpt>",
     acceptable: [
         "",
     ],
     name: "script_case"},
    {input: "<<script>alert('xss');//<</script>",
     acceptable: [
         "&lt;",
     ],
     name: "script_extra"},
    {input: "<<s<script>script>alert()<</script>/script>",
     acceptable: [
         "&lt;",
         "&lt;script&gt;alert()&lt;/script&gt;",
         "&lt;<span>script&gt;alert()&lt;/script&gt;</span>",
     ],
     name: "script_inception"},
    {input: "<script/xss src=\"/xss.js\"><\\/script>",
     acceptable: [
         "",
     ],
     name: "script_nondigit"},
    {input: "<script src=\"/xss.js\"< b >",
     acceptable: [
         "",
     ],
     name: "script_open"},
    {input: "<script src=\"/xss.js\"></script>",
     acceptable: [
         "",
     ],
     name: "script_src"},
    {input: "</title><script>alert('xss');</script>",
     acceptable: [
         "",
     ],
     name: "script_title"},
    {input: "<svg onload=\"javascript:alert('xss')\" xmlns=\"http://www.google.com\"></svg>",
     acceptable: [
         "",
     ],
     name: "svg"},
    {input: "<img src=&#106;&#97;&#118;&#97;&#115;&#99;&#114;&#105;&#112;&#116;&#58;&#97;&#108;&#101;&#114;&#116;&#40;&#39;&#88;&#83;&#83;&#39;&#41;>",
     acceptable: [
         "<img src=\"javascript:void(0);\">",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"about:invalid#zCSafez\">",
         "<img>",
         "<img />",
         "<img src=\"about:invalid#zCSafez\" />",
         "<img src=\"unsafe:javascript:alert('XSS')\">",
         "<img src=\"about:invalid#zTSz\" />",
         "<img src=\"about:invalid#zClosurez\" />",
     ],
     name: "unicode"},
    {input: "<html></html>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_plain"},
    {input: "<html><script>alert()</script></html>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_scriptinside"},
    {input: "<html srcdoc=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_srcdoc"},
    {input: "<html formaction=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_formaction"},
    {input: "<html formmethod=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_formmethod"},
    {input: "<html pattern=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_pattern"},
    {input: "<html defer=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_defer"},
    {input: "<head></head>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_plain"},
    {input: "<head><script>alert()</script></head>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_scriptinside"},
    {input: "<head srcdoc=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_srcdoc"},
    {input: "<head formaction=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_formaction"},
    {input: "<head formmethod=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_formmethod"},
    {input: "<head pattern=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_pattern"},
    {input: "<head defer=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_defer"},
    {input: "<title srcdoc=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_srcdoc"},
    {input: "<title formaction=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_formaction"},
    {input: "<title formmethod=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_formmethod"},
    {input: "<title pattern=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_pattern"},
    {input: "<title defer=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_defer"},
    {input: "<base></base>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_plain"},
    {input: "<base><script>alert()</script></base>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_scriptinside"},
    {input: "<base srcdoc=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_srcdoc"},
    {input: "<base formaction=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_formaction"},
    {input: "<base formmethod=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_formmethod"},
    {input: "<base pattern=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_pattern"},
    {input: "<base defer=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_defer"},
    {input: "<meta></meta>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_plain"},
    {input: "<meta><script>alert()</script></meta>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_scriptinside"},
    {input: "<meta srcdoc=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_srcdoc"},
    {input: "<meta formaction=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_formaction"},
    {input: "<meta formmethod=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_formmethod"},
    {input: "<meta pattern=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_pattern"},
    {input: "<meta defer=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_defer"},
    {input: "<style></style>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_plain"},
    {input: "<style><script>alert()</script></style>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_scriptinside"},
    {input: "<style srcdoc=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_srcdoc"},
    {input: "<style formaction=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_formaction"},
    {input: "<style formmethod=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_formmethod"},
    {input: "<style pattern=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_pattern"},
    {input: "<style defer=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_defer"},
    {input: "<body></body>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_plain"},
    {input: "<body><script>alert()</script></body>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_scriptinside"},
    {input: "<body srcdoc=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_srcdoc"},
    {input: "<body formaction=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_formaction"},
    {input: "<body formmethod=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_formmethod"},
    {input: "<body pattern=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_pattern"},
    {input: "<body defer=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_defer"},
    {input: "<article></article>",
     acceptable: [
         "<article>",
         "<article />",
         "<article></article>",
         "<table><article></article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_plain"},
    {input: "<article><script>alert()</script></article>",
     acceptable: [
         "<article>",
         "<article />",
         "<article></article>",
         "<table><article></article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
         "<table><article><td></td></article></table>",
         "<table><article></article><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_article_scriptinside"},
    {input: "<article srcdoc=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_srcdoc"},
    {input: "<article formaction=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_formaction"},
    {input: "<article formmethod=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_formmethod"},
    {input: "<article pattern=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_pattern"},
    {input: "<article defer=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_defer"},
    {input: "<section></section>",
     acceptable: [
         "<section>",
         "<section />",
         "<section></section>",
         "<table><section></section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_plain"},
    {input: "<section><script>alert()</script></section>",
     acceptable: [
         "<section>",
         "<section />",
         "<section></section>",
         "<table><section></section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
         "<table><section><td></td></section></table>",
         "<table><section></section><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_section_scriptinside"},
    {input: "<section srcdoc=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_srcdoc"},
    {input: "<section formaction=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_formaction"},
    {input: "<section formmethod=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_formmethod"},
    {input: "<section pattern=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_pattern"},
    {input: "<section defer=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_defer"},
    {input: "<nav></nav>",
     acceptable: [
         "<nav>",
         "<nav />",
         "<nav></nav>",
         "<table><nav></nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_plain"},
    {input: "<nav><script>alert()</script></nav>",
     acceptable: [
         "<nav>",
         "<nav />",
         "<nav></nav>",
         "<table><nav></nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
         "<table><nav><td></td></nav></table>",
         "<table><nav></nav><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_nav_scriptinside"},
    {input: "<nav srcdoc=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_srcdoc"},
    {input: "<nav formaction=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_formaction"},
    {input: "<nav formmethod=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_formmethod"},
    {input: "<nav pattern=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_pattern"},
    {input: "<nav defer=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_defer"},
    {input: "<aside></aside>",
     acceptable: [
         "<aside>",
         "<aside />",
         "<aside></aside>",
         "<table><aside></aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_plain"},
    {input: "<aside><script>alert()</script></aside>",
     acceptable: [
         "<aside>",
         "<aside />",
         "<aside></aside>",
         "<table><aside></aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
         "<table><aside><td></td></aside></table>",
         "<table><aside></aside><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_aside_scriptinside"},
    {input: "<aside srcdoc=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_srcdoc"},
    {input: "<aside formaction=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_formaction"},
    {input: "<aside formmethod=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_formmethod"},
    {input: "<aside pattern=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_pattern"},
    {input: "<aside defer=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_defer"},
    {input: "<h1></h1>",
     acceptable: [
         "<h1>",
         "<h1 />",
         "<h1></h1>",
         "<table><h1></h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_plain"},
    {input: "<h1><script>alert()</script></h1>",
     acceptable: [
         "<h1>",
         "<h1 />",
         "<h1></h1>",
         "<table><h1></h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
         "<table><h1><td></td></h1></table>",
         "<table><h1></h1><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h1_scriptinside"},
    {input: "<h1 srcdoc=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_srcdoc"},
    {input: "<h1 formaction=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_formaction"},
    {input: "<h1 formmethod=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_formmethod"},
    {input: "<h1 pattern=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_pattern"},
    {input: "<h1 defer=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_defer"},
    {input: "<h2></h2>",
     acceptable: [
         "<h2>",
         "<h2 />",
         "<h2></h2>",
         "<table><h2></h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_plain"},
    {input: "<h2><script>alert()</script></h2>",
     acceptable: [
         "<h2>",
         "<h2 />",
         "<h2></h2>",
         "<table><h2></h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
         "<table><h2><td></td></h2></table>",
         "<table><h2></h2><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h2_scriptinside"},
    {input: "<h2 srcdoc=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_srcdoc"},
    {input: "<h2 formaction=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_formaction"},
    {input: "<h2 formmethod=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_formmethod"},
    {input: "<h2 pattern=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_pattern"},
    {input: "<h2 defer=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_defer"},
    {input: "<h3></h3>",
     acceptable: [
         "<h3>",
         "<h3 />",
         "<h3></h3>",
         "<table><h3></h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_plain"},
    {input: "<h3><script>alert()</script></h3>",
     acceptable: [
         "<h3>",
         "<h3 />",
         "<h3></h3>",
         "<table><h3></h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
         "<table><h3><td></td></h3></table>",
         "<table><h3></h3><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h3_scriptinside"},
    {input: "<h3 srcdoc=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_srcdoc"},
    {input: "<h3 formaction=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_formaction"},
    {input: "<h3 formmethod=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_formmethod"},
    {input: "<h3 pattern=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_pattern"},
    {input: "<h3 defer=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_defer"},
    {input: "<h4></h4>",
     acceptable: [
         "<h4>",
         "<h4 />",
         "<h4></h4>",
         "<table><h4></h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_plain"},
    {input: "<h4><script>alert()</script></h4>",
     acceptable: [
         "<h4>",
         "<h4 />",
         "<h4></h4>",
         "<table><h4></h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
         "<table><h4><td></td></h4></table>",
         "<table><h4></h4><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h4_scriptinside"},
    {input: "<h4 srcdoc=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_srcdoc"},
    {input: "<h4 formaction=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_formaction"},
    {input: "<h4 formmethod=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_formmethod"},
    {input: "<h4 pattern=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_pattern"},
    {input: "<h4 defer=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_defer"},
    {input: "<h5></h5>",
     acceptable: [
         "<h5>",
         "<h5 />",
         "<h5></h5>",
         "<table><h5></h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_plain"},
    {input: "<h5><script>alert()</script></h5>",
     acceptable: [
         "<h5>",
         "<h5 />",
         "<h5></h5>",
         "<table><h5></h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
         "<table><h5><td></td></h5></table>",
         "<table><h5></h5><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h5_scriptinside"},
    {input: "<h5 srcdoc=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_srcdoc"},
    {input: "<h5 formaction=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_formaction"},
    {input: "<h5 formmethod=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_formmethod"},
    {input: "<h5 pattern=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_pattern"},
    {input: "<h5 defer=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_defer"},
    {input: "<h6></h6>",
     acceptable: [
         "<h6>",
         "<h6 />",
         "<h6></h6>",
         "<table><h6></h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_plain"},
    {input: "<h6><script>alert()</script></h6>",
     acceptable: [
         "<h6>",
         "<h6 />",
         "<h6></h6>",
         "<table><h6></h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
         "<table><h6><td></td></h6></table>",
         "<table><h6></h6><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h6_scriptinside"},
    {input: "<h6 srcdoc=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_srcdoc"},
    {input: "<h6 formaction=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_formaction"},
    {input: "<h6 formmethod=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_formmethod"},
    {input: "<h6 pattern=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_pattern"},
    {input: "<h6 defer=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_defer"},
    {input: "<header></header>",
     acceptable: [
         "<header>",
         "<header />",
         "<header></header>",
         "<table><header></header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_plain"},
    {input: "<header><script>alert()</script></header>",
     acceptable: [
         "<header>",
         "<header />",
         "<header></header>",
         "<table><header></header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
         "<table><header><td></td></header></table>",
         "<table><header></header><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_header_scriptinside"},
    {input: "<header srcdoc=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_srcdoc"},
    {input: "<header formaction=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_formaction"},
    {input: "<header formmethod=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_formmethod"},
    {input: "<header pattern=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_pattern"},
    {input: "<header defer=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_defer"},
    {input: "<footer></footer>",
     acceptable: [
         "<footer>",
         "<footer />",
         "<footer></footer>",
         "<table><footer></footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_plain"},
    {input: "<footer><script>alert()</script></footer>",
     acceptable: [
         "<footer>",
         "<footer />",
         "<footer></footer>",
         "<table><footer></footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
         "<table><footer><td></td></footer></table>",
         "<table><footer></footer><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_footer_scriptinside"},
    {input: "<footer srcdoc=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_srcdoc"},
    {input: "<footer formaction=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_formaction"},
    {input: "<footer formmethod=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_formmethod"},
    {input: "<footer pattern=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_pattern"},
    {input: "<footer defer=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_defer"},
    {input: "<address></address>",
     acceptable: [
         "<address>",
         "<address />",
         "<address></address>",
         "<table><address></address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_plain"},
    {input: "<address><script>alert()</script></address>",
     acceptable: [
         "<address>",
         "<address />",
         "<address></address>",
         "<table><address></address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
         "<table><address><td></td></address></table>",
         "<table><address></address><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_address_scriptinside"},
    {input: "<address srcdoc=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_srcdoc"},
    {input: "<address formaction=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_formaction"},
    {input: "<address formmethod=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_formmethod"},
    {input: "<address pattern=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_pattern"},
    {input: "<address defer=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_defer"},
    {input: "<p></p>",
     acceptable: [
         "<p>",
         "<p />",
         "<p></p>",
         "<table><p></p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_plain"},
    {input: "<p><script>alert()</script></p>",
     acceptable: [
         "<p>",
         "<p />",
         "<p></p>",
         "<table><p></p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
         "<table><p><td></td></p></table>",
         "<table><p></p><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_p_scriptinside"},
    {input: "<p srcdoc=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_srcdoc"},
    {input: "<p formaction=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_formaction"},
    {input: "<p formmethod=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_formmethod"},
    {input: "<p pattern=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_pattern"},
    {input: "<p defer=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_defer"},
    {input: "<hr></hr>",
     acceptable: [
         "<hr>",
         "<hr />",
         "<hr/>",
         "<hr><hr>",
         "<hr/><hr/>",
         "<hr /><hr />",
         "<table><hr></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_plain"},
    {input: "<hr><script>alert()</script></hr>",
     acceptable: [
         "<hr>",
         "<hr />",
         "<hr/>",
         "<hr><hr>",
         "<hr/><hr/>",
         "<hr /><hr />",
         "<table><hr></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><hr><td></td></table>",
     ],
     name: "contract_hr_scriptinside"},
    {input: "<hr srcdoc=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_srcdoc"},
    {input: "<hr formaction=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_formaction"},
    {input: "<hr formmethod=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_formmethod"},
    {input: "<hr pattern=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_pattern"},
    {input: "<hr defer=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_defer"},
    {input: "<pre></pre>",
     acceptable: [
         "<pre>",
         "<pre />",
         "<pre></pre>",
         "<table><pre></pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_plain"},
    {input: "<pre><script>alert()</script></pre>",
     acceptable: [
         "<pre>",
         "<pre />",
         "<pre></pre>",
         "<table><pre></pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
         "<table><pre><td></td></pre></table>",
         "<table><pre></pre><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_pre_scriptinside"},
    {input: "<pre srcdoc=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_srcdoc"},
    {input: "<pre formaction=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_formaction"},
    {input: "<pre formmethod=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_formmethod"},
    {input: "<pre pattern=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_pattern"},
    {input: "<pre defer=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_defer"},
    {input: "<blockquote></blockquote>",
     acceptable: [
         "<blockquote>",
         "<blockquote />",
         "<blockquote></blockquote>",
         "<table><blockquote></blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_plain"},
    {input: "<blockquote><script>alert()</script></blockquote>",
     acceptable: [
         "<blockquote>",
         "<blockquote />",
         "<blockquote></blockquote>",
         "<table><blockquote></blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
         "<table><blockquote><td></td></blockquote></table>",
         "<table><blockquote></blockquote><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_blockquote_scriptinside"},
    {input: "<blockquote srcdoc=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_srcdoc"},
    {input: "<blockquote formaction=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_formaction"},
    {input: "<blockquote formmethod=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_formmethod"},
    {input: "<blockquote pattern=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_pattern"},
    {input: "<blockquote defer=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_defer"},
    {input: "<ol></ol>",
     acceptable: [
         "<ol>",
         "<ol />",
         "<ol></ol>",
         "<table><ol></ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_plain"},
    {input: "<ol><script>alert()</script></ol>",
     acceptable: [
         "<ol>",
         "<ol />",
         "<ol></ol>",
         "<table><ol></ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
         "<table><ol><td></td></ol></table>",
         "<table><ol></ol><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_ol_scriptinside"},
    {input: "<ol srcdoc=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_srcdoc"},
    {input: "<ol formaction=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_formaction"},
    {input: "<ol formmethod=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_formmethod"},
    {input: "<ol pattern=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_pattern"},
    {input: "<ol defer=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_defer"},
    {input: "<ul></ul>",
     acceptable: [
         "<ul>",
         "<ul />",
         "<ul></ul>",
         "<table><ul></ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_plain"},
    {input: "<ul><script>alert()</script></ul>",
     acceptable: [
         "<ul>",
         "<ul />",
         "<ul></ul>",
         "<table><ul></ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
         "<table><ul><td></td></ul></table>",
         "<table><ul></ul><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_ul_scriptinside"},
    {input: "<ul srcdoc=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_srcdoc"},
    {input: "<ul formaction=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_formaction"},
    {input: "<ul formmethod=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_formmethod"},
    {input: "<ul pattern=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_pattern"},
    {input: "<ul defer=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_defer"},
    {input: "<lh></lh>",
     acceptable: [
         "<lh>",
         "<lh />",
         "<lh></lh>",
         "<table><lh></lh></table>",
         "<LH />",
         "<LH></LH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_lh_plain"},
    {input: "<lh><script>alert()</script></lh>",
     acceptable: [
         "<lh>",
         "<lh />",
         "<lh></lh>",
         "<table><lh></lh></table>",
         "<LH />",
         "<LH></LH>",
         "<span></span>",
         "<span />",
         "",
         "<table><lh><td></td></lh></table>",
         "<table><lh></lh><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_lh_scriptinside"},
    {input: "<lh srcdoc=\"x\">",
     acceptable: [
         "<lh></lh>",
         "<lh>",
         "<lh/>",
         "<lh />",
         "<table><lh></lh></table>",
         "<table><lh></table>",
         "<LH />",
         "<LH></LH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_lh_srcdoc"},
    {input: "<lh formaction=\"x\">",
     acceptable: [
         "<lh></lh>",
         "<lh>",
         "<lh/>",
         "<lh />",
         "<table><lh></lh></table>",
         "<table><lh></table>",
         "<LH />",
         "<LH></LH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_lh_formaction"},
    {input: "<lh formmethod=\"x\">",
     acceptable: [
         "<lh></lh>",
         "<lh>",
         "<lh/>",
         "<lh />",
         "<table><lh></lh></table>",
         "<table><lh></table>",
         "<LH />",
         "<LH></LH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_lh_formmethod"},
    {input: "<lh pattern=\"x\">",
     acceptable: [
         "<lh></lh>",
         "<lh>",
         "<lh/>",
         "<lh />",
         "<table><lh></lh></table>",
         "<table><lh></table>",
         "<LH />",
         "<LH></LH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_lh_pattern"},
    {input: "<lh defer=\"x\">",
     acceptable: [
         "<lh></lh>",
         "<lh>",
         "<lh/>",
         "<lh />",
         "<table><lh></lh></table>",
         "<table><lh></table>",
         "<LH />",
         "<LH></LH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_lh_defer"},
    {input: "<li></li>",
     acceptable: [
         "<li>",
         "<li />",
         "<li></li>",
         "<table><li></li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_plain"},
    {input: "<li><script>alert()</script></li>",
     acceptable: [
         "<li>",
         "<li />",
         "<li></li>",
         "<table><li></li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
         "<table><li><td></td></li></table>",
         "<table><li></li><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_li_scriptinside"},
    {input: "<li srcdoc=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_srcdoc"},
    {input: "<li formaction=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_formaction"},
    {input: "<li formmethod=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_formmethod"},
    {input: "<li pattern=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_pattern"},
    {input: "<li defer=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_defer"},
    {input: "<dl></dl>",
     acceptable: [
         "<dl>",
         "<dl />",
         "<dl></dl>",
         "<table><dl></dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_plain"},
    {input: "<dl><script>alert()</script></dl>",
     acceptable: [
         "<dl>",
         "<dl />",
         "<dl></dl>",
         "<table><dl></dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
         "<table><dl><td></td></dl></table>",
         "<table><dl></dl><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dl_scriptinside"},
    {input: "<dl srcdoc=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_srcdoc"},
    {input: "<dl formaction=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_formaction"},
    {input: "<dl formmethod=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_formmethod"},
    {input: "<dl pattern=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_pattern"},
    {input: "<dl defer=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_defer"},
    {input: "<dt></dt>",
     acceptable: [
         "<dt>",
         "<dt />",
         "<dt></dt>",
         "<table><dt></dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_plain"},
    {input: "<dt><script>alert()</script></dt>",
     acceptable: [
         "<dt>",
         "<dt />",
         "<dt></dt>",
         "<table><dt></dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
         "<table><dt><td></td></dt></table>",
         "<table><dt></dt><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dt_scriptinside"},
    {input: "<dt srcdoc=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_srcdoc"},
    {input: "<dt formaction=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_formaction"},
    {input: "<dt formmethod=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_formmethod"},
    {input: "<dt pattern=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_pattern"},
    {input: "<dt defer=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_defer"},
    {input: "<dd></dd>",
     acceptable: [
         "<dd>",
         "<dd />",
         "<dd></dd>",
         "<table><dd></dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_plain"},
    {input: "<dd><script>alert()</script></dd>",
     acceptable: [
         "<dd>",
         "<dd />",
         "<dd></dd>",
         "<table><dd></dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
         "<table><dd><td></td></dd></table>",
         "<table><dd></dd><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dd_scriptinside"},
    {input: "<dd srcdoc=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_srcdoc"},
    {input: "<dd formaction=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_formaction"},
    {input: "<dd formmethod=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_formmethod"},
    {input: "<dd pattern=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_pattern"},
    {input: "<dd defer=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_defer"},
    {input: "<figure></figure>",
     acceptable: [
         "<figure>",
         "<figure />",
         "<figure></figure>",
         "<table><figure></figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_plain"},
    {input: "<figure><script>alert()</script></figure>",
     acceptable: [
         "<figure>",
         "<figure />",
         "<figure></figure>",
         "<table><figure></figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
         "<table><figure><td></td></figure></table>",
         "<table><figure></figure><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_figure_scriptinside"},
    {input: "<figure srcdoc=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_srcdoc"},
    {input: "<figure formaction=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_formaction"},
    {input: "<figure formmethod=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_formmethod"},
    {input: "<figure pattern=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_pattern"},
    {input: "<figure defer=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_defer"},
    {input: "<figcaption></figcaption>",
     acceptable: [
         "<figcaption>",
         "<figcaption />",
         "<figcaption></figcaption>",
         "<table><figcaption></figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_plain"},
    {input: "<figcaption><script>alert()</script></figcaption>",
     acceptable: [
         "<figcaption>",
         "<figcaption />",
         "<figcaption></figcaption>",
         "<table><figcaption></figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
         "<table><figcaption><td></td></figcaption></table>",
         "<table><figcaption></figcaption><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_figcaption_scriptinside"},
    {input: "<figcaption srcdoc=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_srcdoc"},
    {input: "<figcaption formaction=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_formaction"},
    {input: "<figcaption formmethod=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_formmethod"},
    {input: "<figcaption pattern=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_pattern"},
    {input: "<figcaption defer=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_defer"},
    {input: "<main></main>",
     acceptable: [
         "<main>",
         "<main />",
         "<main></main>",
         "<table><main></main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_plain"},
    {input: "<main><script>alert()</script></main>",
     acceptable: [
         "<main>",
         "<main />",
         "<main></main>",
         "<table><main></main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
         "<table><main><td></td></main></table>",
         "<table><main></main><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_main_scriptinside"},
    {input: "<main srcdoc=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_srcdoc"},
    {input: "<main formaction=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_formaction"},
    {input: "<main formmethod=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_formmethod"},
    {input: "<main pattern=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_pattern"},
    {input: "<main defer=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_defer"},
    {input: "<div></div>",
     acceptable: [
         "<div>",
         "<div />",
         "<div></div>",
         "<table><div></div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_plain"},
    {input: "<div><script>alert()</script></div>",
     acceptable: [
         "<div>",
         "<div />",
         "<div></div>",
         "<table><div></div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
         "<table><div><td></td></div></table>",
         "<table><div></div><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_div_scriptinside"},
    {input: "<div srcdoc=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_srcdoc"},
    {input: "<div formaction=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_formaction"},
    {input: "<div formmethod=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_formmethod"},
    {input: "<div pattern=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_pattern"},
    {input: "<div defer=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_defer"},
    {input: "<a></a>",
     acceptable: [
         "<a>",
         "<a />",
         "<a></a>",
         "<table><a></a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_plain"},
    {input: "<a><script>alert()</script></a>",
     acceptable: [
         "<a>",
         "<a />",
         "<a></a>",
         "<table><a></a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
         "<table><a><td></td></a></table>",
         "<table><a></a><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_a_scriptinside"},
    {input: "<a href=\"javascript:xss\">",
     acceptable: [
         "<a href=\"unsafe:javascript:xss\"></a>",
         "<a href=\"unsafe:javascript:xss\">",
         "<a href=\"unsafe:javascript:xss\"/>",
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_href"},
    {input: "<a srcdoc=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_srcdoc"},
    {input: "<a formaction=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_formaction"},
    {input: "<a formmethod=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_formmethod"},
    {input: "<a pattern=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_pattern"},
    {input: "<a defer=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_defer"},
    {input: "<area></area>",
     acceptable: [
         "<area>",
         "<area />",
         "<area/>",
         "<area><area>",
         "<area/><area/>",
         "<area /><area />",
         "<table><area></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_plain"},
    {input: "<area><script>alert()</script></area>",
     acceptable: [
         "<area>",
         "<area />",
         "<area/>",
         "<area><area>",
         "<area/><area/>",
         "<area /><area />",
         "<table><area></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><area><td></td></table>",
     ],
     name: "contract_area_scriptinside"},
    {input: "<area href=\"javascript:xss\">",
     acceptable: [
         "<area href=\"unsafe:javascript:xss\"></area>",
         "<area href=\"unsafe:javascript:xss\">",
         "<area href=\"unsafe:javascript:xss\"/>",
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_href"},
    {input: "<area srcdoc=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_srcdoc"},
    {input: "<area formaction=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_formaction"},
    {input: "<area formmethod=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_formmethod"},
    {input: "<area pattern=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_pattern"},
    {input: "<area defer=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_defer"},
    {input: "<em></em>",
     acceptable: [
         "<em>",
         "<em />",
         "<em></em>",
         "<table><em></em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_plain"},
    {input: "<em><script>alert()</script></em>",
     acceptable: [
         "<em>",
         "<em />",
         "<em></em>",
         "<table><em></em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
         "<table><em><td></td></em></table>",
         "<table><em></em><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_em_scriptinside"},
    {input: "<em srcdoc=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_srcdoc"},
    {input: "<em formaction=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_formaction"},
    {input: "<em formmethod=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_formmethod"},
    {input: "<em pattern=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_pattern"},
    {input: "<em defer=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_defer"},
    {input: "<strong></strong>",
     acceptable: [
         "<strong>",
         "<strong />",
         "<strong></strong>",
         "<table><strong></strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_plain"},
    {input: "<strong><script>alert()</script></strong>",
     acceptable: [
         "<strong>",
         "<strong />",
         "<strong></strong>",
         "<table><strong></strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
         "<table><strong><td></td></strong></table>",
         "<table><strong></strong><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_strong_scriptinside"},
    {input: "<strong srcdoc=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_srcdoc"},
    {input: "<strong formaction=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_formaction"},
    {input: "<strong formmethod=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_formmethod"},
    {input: "<strong pattern=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_pattern"},
    {input: "<strong defer=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_defer"},
    {input: "<small></small>",
     acceptable: [
         "<small>",
         "<small />",
         "<small></small>",
         "<table><small></small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_plain"},
    {input: "<small><script>alert()</script></small>",
     acceptable: [
         "<small>",
         "<small />",
         "<small></small>",
         "<table><small></small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
         "<table><small><td></td></small></table>",
         "<table><small></small><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_small_scriptinside"},
    {input: "<small srcdoc=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_srcdoc"},
    {input: "<small formaction=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_formaction"},
    {input: "<small formmethod=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_formmethod"},
    {input: "<small pattern=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_pattern"},
    {input: "<small defer=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_defer"},
    {input: "<s></s>",
     acceptable: [
         "<s>",
         "<s />",
         "<s></s>",
         "<table><s></s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_plain"},
    {input: "<s><script>alert()</script></s>",
     acceptable: [
         "<s>",
         "<s />",
         "<s></s>",
         "<table><s></s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
         "<table><s><td></td></s></table>",
         "<table><s></s><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_s_scriptinside"},
    {input: "<s srcdoc=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_srcdoc"},
    {input: "<s formaction=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_formaction"},
    {input: "<s formmethod=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_formmethod"},
    {input: "<s pattern=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_pattern"},
    {input: "<s defer=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_defer"},
    {input: "<cite></cite>",
     acceptable: [
         "<cite>",
         "<cite />",
         "<cite></cite>",
         "<table><cite></cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_plain"},
    {input: "<cite><script>alert()</script></cite>",
     acceptable: [
         "<cite>",
         "<cite />",
         "<cite></cite>",
         "<table><cite></cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
         "<table><cite><td></td></cite></table>",
         "<table><cite></cite><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_cite_scriptinside"},
    {input: "<cite srcdoc=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_srcdoc"},
    {input: "<cite formaction=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_formaction"},
    {input: "<cite formmethod=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_formmethod"},
    {input: "<cite pattern=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_pattern"},
    {input: "<cite defer=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_defer"},
    {input: "<q></q>",
     acceptable: [
         "<q>",
         "<q />",
         "<q></q>",
         "<table><q></q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_plain"},
    {input: "<q><script>alert()</script></q>",
     acceptable: [
         "<q>",
         "<q />",
         "<q></q>",
         "<table><q></q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
         "<table><q><td></td></q></table>",
         "<table><q></q><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_q_scriptinside"},
    {input: "<q srcdoc=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_srcdoc"},
    {input: "<q formaction=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_formaction"},
    {input: "<q formmethod=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_formmethod"},
    {input: "<q pattern=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_pattern"},
    {input: "<q defer=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_defer"},
    {input: "<dfn></dfn>",
     acceptable: [
         "<dfn>",
         "<dfn />",
         "<dfn></dfn>",
         "<table><dfn></dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_plain"},
    {input: "<dfn><script>alert()</script></dfn>",
     acceptable: [
         "<dfn>",
         "<dfn />",
         "<dfn></dfn>",
         "<table><dfn></dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
         "<table><dfn><td></td></dfn></table>",
         "<table><dfn></dfn><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dfn_scriptinside"},
    {input: "<dfn srcdoc=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_srcdoc"},
    {input: "<dfn formaction=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_formaction"},
    {input: "<dfn formmethod=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_formmethod"},
    {input: "<dfn pattern=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_pattern"},
    {input: "<dfn defer=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_defer"},
    {input: "<abbr></abbr>",
     acceptable: [
         "<abbr>",
         "<abbr />",
         "<abbr></abbr>",
         "<table><abbr></abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_plain"},
    {input: "<abbr><script>alert()</script></abbr>",
     acceptable: [
         "<abbr>",
         "<abbr />",
         "<abbr></abbr>",
         "<table><abbr></abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
         "<table><abbr><td></td></abbr></table>",
         "<table><abbr></abbr><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_abbr_scriptinside"},
    {input: "<abbr srcdoc=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_srcdoc"},
    {input: "<abbr formaction=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_formaction"},
    {input: "<abbr formmethod=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_formmethod"},
    {input: "<abbr pattern=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_pattern"},
    {input: "<abbr defer=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_defer"},
    {input: "<ruby></ruby>",
     acceptable: [
         "<ruby>",
         "<ruby />",
         "<ruby></ruby>",
         "<table><ruby></ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_plain"},
    {input: "<ruby><script>alert()</script></ruby>",
     acceptable: [
         "<ruby>",
         "<ruby />",
         "<ruby></ruby>",
         "<table><ruby></ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
         "<table><ruby><td></td></ruby></table>",
         "<table><ruby></ruby><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_ruby_scriptinside"},
    {input: "<ruby srcdoc=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_srcdoc"},
    {input: "<ruby formaction=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_formaction"},
    {input: "<ruby formmethod=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_formmethod"},
    {input: "<ruby pattern=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_pattern"},
    {input: "<ruby defer=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_defer"},
    {input: "<rb></rb>",
     acceptable: [
         "<rb>",
         "<rb />",
         "<rb></rb>",
         "<table><rb></rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_plain"},
    {input: "<rb><script>alert()</script></rb>",
     acceptable: [
         "<rb>",
         "<rb />",
         "<rb></rb>",
         "<table><rb></rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
         "<table><rb><td></td></rb></table>",
         "<table><rb></rb><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_rb_scriptinside"},
    {input: "<rb srcdoc=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_srcdoc"},
    {input: "<rb formaction=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_formaction"},
    {input: "<rb formmethod=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_formmethod"},
    {input: "<rb pattern=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_pattern"},
    {input: "<rb defer=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_defer"},
    {input: "<rt></rt>",
     acceptable: [
         "<rt>",
         "<rt />",
         "<rt></rt>",
         "<table><rt></rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_plain"},
    {input: "<rt><script>alert()</script></rt>",
     acceptable: [
         "<rt>",
         "<rt />",
         "<rt></rt>",
         "<table><rt></rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
         "<table><rt><td></td></rt></table>",
         "<table><rt></rt><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_rt_scriptinside"},
    {input: "<rt srcdoc=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_srcdoc"},
    {input: "<rt formaction=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_formaction"},
    {input: "<rt formmethod=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_formmethod"},
    {input: "<rt pattern=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_pattern"},
    {input: "<rt defer=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_defer"},
    {input: "<rtc></rtc>",
     acceptable: [
         "<rtc>",
         "<rtc />",
         "<rtc></rtc>",
         "<table><rtc></rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_plain"},
    {input: "<rtc><script>alert()</script></rtc>",
     acceptable: [
         "<rtc>",
         "<rtc />",
         "<rtc></rtc>",
         "<table><rtc></rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
         "<table><rtc><td></td></rtc></table>",
         "<table><rtc></rtc><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_rtc_scriptinside"},
    {input: "<rtc srcdoc=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_srcdoc"},
    {input: "<rtc formaction=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_formaction"},
    {input: "<rtc formmethod=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_formmethod"},
    {input: "<rtc pattern=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_pattern"},
    {input: "<rtc defer=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_defer"},
    {input: "<rp></rp>",
     acceptable: [
         "<rp>",
         "<rp />",
         "<rp></rp>",
         "<table><rp></rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_plain"},
    {input: "<rp><script>alert()</script></rp>",
     acceptable: [
         "<rp>",
         "<rp />",
         "<rp></rp>",
         "<table><rp></rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
         "<table><rp><td></td></rp></table>",
         "<table><rp></rp><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_rp_scriptinside"},
    {input: "<rp srcdoc=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_srcdoc"},
    {input: "<rp formaction=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_formaction"},
    {input: "<rp formmethod=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_formmethod"},
    {input: "<rp pattern=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_pattern"},
    {input: "<rp defer=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_defer"},
    {input: "<data></data>",
     acceptable: [
         "<data>",
         "<data />",
         "<data></data>",
         "<table><data></data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_plain"},
    {input: "<data><script>alert()</script></data>",
     acceptable: [
         "<data>",
         "<data />",
         "<data></data>",
         "<table><data></data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
         "<table><data><td></td></data></table>",
         "<table><data></data><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_data_scriptinside"},
    {input: "<data srcdoc=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_srcdoc"},
    {input: "<data formaction=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_formaction"},
    {input: "<data formmethod=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_formmethod"},
    {input: "<data pattern=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_pattern"},
    {input: "<data defer=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_defer"},
    {input: "<time></time>",
     acceptable: [
         "<time>",
         "<time />",
         "<time></time>",
         "<table><time></time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_plain"},
    {input: "<time><script>alert()</script></time>",
     acceptable: [
         "<time>",
         "<time />",
         "<time></time>",
         "<table><time></time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
         "<table><time><td></td></time></table>",
         "<table><time></time><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_time_scriptinside"},
    {input: "<time srcdoc=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_srcdoc"},
    {input: "<time formaction=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_formaction"},
    {input: "<time formmethod=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_formmethod"},
    {input: "<time pattern=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_pattern"},
    {input: "<time defer=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_defer"},
    {input: "<code></code>",
     acceptable: [
         "<code>",
         "<code />",
         "<code></code>",
         "<table><code></code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_plain"},
    {input: "<code><script>alert()</script></code>",
     acceptable: [
         "<code>",
         "<code />",
         "<code></code>",
         "<table><code></code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
         "<table><code><td></td></code></table>",
         "<table><code></code><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_code_scriptinside"},
    {input: "<code srcdoc=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_srcdoc"},
    {input: "<code formaction=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_formaction"},
    {input: "<code formmethod=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_formmethod"},
    {input: "<code pattern=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_pattern"},
    {input: "<code defer=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_defer"},
    {input: "<var></var>",
     acceptable: [
         "<var>",
         "<var />",
         "<var></var>",
         "<table><var></var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_plain"},
    {input: "<var><script>alert()</script></var>",
     acceptable: [
         "<var>",
         "<var />",
         "<var></var>",
         "<table><var></var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
         "<table><var><td></td></var></table>",
         "<table><var></var><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_var_scriptinside"},
    {input: "<var srcdoc=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_srcdoc"},
    {input: "<var formaction=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_formaction"},
    {input: "<var formmethod=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_formmethod"},
    {input: "<var pattern=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_pattern"},
    {input: "<var defer=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_defer"},
    {input: "<samp></samp>",
     acceptable: [
         "<samp>",
         "<samp />",
         "<samp></samp>",
         "<table><samp></samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_plain"},
    {input: "<samp><script>alert()</script></samp>",
     acceptable: [
         "<samp>",
         "<samp />",
         "<samp></samp>",
         "<table><samp></samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
         "<table><samp><td></td></samp></table>",
         "<table><samp></samp><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_samp_scriptinside"},
    {input: "<samp srcdoc=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_srcdoc"},
    {input: "<samp formaction=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_formaction"},
    {input: "<samp formmethod=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_formmethod"},
    {input: "<samp pattern=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_pattern"},
    {input: "<samp defer=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_defer"},
    {input: "<kbd></kbd>",
     acceptable: [
         "<kbd>",
         "<kbd />",
         "<kbd></kbd>",
         "<table><kbd></kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_plain"},
    {input: "<kbd><script>alert()</script></kbd>",
     acceptable: [
         "<kbd>",
         "<kbd />",
         "<kbd></kbd>",
         "<table><kbd></kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
         "<table><kbd><td></td></kbd></table>",
         "<table><kbd></kbd><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_kbd_scriptinside"},
    {input: "<kbd srcdoc=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_srcdoc"},
    {input: "<kbd formaction=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_formaction"},
    {input: "<kbd formmethod=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_formmethod"},
    {input: "<kbd pattern=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_pattern"},
    {input: "<kbd defer=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_defer"},
    {input: "<sub></sub>",
     acceptable: [
         "<sub>",
         "<sub />",
         "<sub></sub>",
         "<table><sub></sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_plain"},
    {input: "<sub><script>alert()</script></sub>",
     acceptable: [
         "<sub>",
         "<sub />",
         "<sub></sub>",
         "<table><sub></sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
         "<table><sub><td></td></sub></table>",
         "<table><sub></sub><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_sub_scriptinside"},
    {input: "<sub srcdoc=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_srcdoc"},
    {input: "<sub formaction=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_formaction"},
    {input: "<sub formmethod=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_formmethod"},
    {input: "<sub pattern=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_pattern"},
    {input: "<sub defer=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_defer"},
    {input: "<sup></sup>",
     acceptable: [
         "<sup>",
         "<sup />",
         "<sup></sup>",
         "<table><sup></sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_plain"},
    {input: "<sup><script>alert()</script></sup>",
     acceptable: [
         "<sup>",
         "<sup />",
         "<sup></sup>",
         "<table><sup></sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
         "<table><sup><td></td></sup></table>",
         "<table><sup></sup><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_sup_scriptinside"},
    {input: "<sup srcdoc=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_srcdoc"},
    {input: "<sup formaction=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_formaction"},
    {input: "<sup formmethod=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_formmethod"},
    {input: "<sup pattern=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_pattern"},
    {input: "<sup defer=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_defer"},
    {input: "<i></i>",
     acceptable: [
         "<i>",
         "<i />",
         "<i></i>",
         "<table><i></i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_plain"},
    {input: "<i><script>alert()</script></i>",
     acceptable: [
         "<i>",
         "<i />",
         "<i></i>",
         "<table><i></i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
         "<table><i><td></td></i></table>",
         "<table><i></i><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_i_scriptinside"},
    {input: "<i srcdoc=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_srcdoc"},
    {input: "<i formaction=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_formaction"},
    {input: "<i formmethod=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_formmethod"},
    {input: "<i pattern=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_pattern"},
    {input: "<i defer=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_defer"},
    {input: "<b></b>",
     acceptable: [
         "<b>",
         "<b />",
         "<b></b>",
         "<table><b></b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_plain"},
    {input: "<b><script>alert()</script></b>",
     acceptable: [
         "<b>",
         "<b />",
         "<b></b>",
         "<table><b></b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
         "<table><b><td></td></b></table>",
         "<table><b></b><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_b_scriptinside"},
    {input: "<b srcdoc=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_srcdoc"},
    {input: "<b formaction=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_formaction"},
    {input: "<b formmethod=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_formmethod"},
    {input: "<b pattern=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_pattern"},
    {input: "<b defer=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_defer"},
    {input: "<u></u>",
     acceptable: [
         "<u>",
         "<u />",
         "<u></u>",
         "<table><u></u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_plain"},
    {input: "<u><script>alert()</script></u>",
     acceptable: [
         "<u>",
         "<u />",
         "<u></u>",
         "<table><u></u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
         "<table><u><td></td></u></table>",
         "<table><u></u><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_u_scriptinside"},
    {input: "<u srcdoc=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_srcdoc"},
    {input: "<u formaction=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_formaction"},
    {input: "<u formmethod=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_formmethod"},
    {input: "<u pattern=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_pattern"},
    {input: "<u defer=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_defer"},
    {input: "<mark></mark>",
     acceptable: [
         "<mark>",
         "<mark />",
         "<mark></mark>",
         "<table><mark></mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_plain"},
    {input: "<mark><script>alert()</script></mark>",
     acceptable: [
         "<mark>",
         "<mark />",
         "<mark></mark>",
         "<table><mark></mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
         "<table><mark><td></td></mark></table>",
         "<table><mark></mark><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_mark_scriptinside"},
    {input: "<mark srcdoc=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_srcdoc"},
    {input: "<mark formaction=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_formaction"},
    {input: "<mark formmethod=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_formmethod"},
    {input: "<mark pattern=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_pattern"},
    {input: "<mark defer=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_defer"},
    {input: "<bdi></bdi>",
     acceptable: [
         "<bdi>",
         "<bdi />",
         "<bdi></bdi>",
         "<table><bdi></bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_plain"},
    {input: "<bdi><script>alert()</script></bdi>",
     acceptable: [
         "<bdi>",
         "<bdi />",
         "<bdi></bdi>",
         "<table><bdi></bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
         "<table><bdi><td></td></bdi></table>",
         "<table><bdi></bdi><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_bdi_scriptinside"},
    {input: "<bdi srcdoc=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_srcdoc"},
    {input: "<bdi formaction=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_formaction"},
    {input: "<bdi formmethod=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_formmethod"},
    {input: "<bdi pattern=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_pattern"},
    {input: "<bdi defer=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_defer"},
    {input: "<bdo></bdo>",
     acceptable: [
         "<bdo>",
         "<bdo />",
         "<bdo></bdo>",
         "<table><bdo></bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_plain"},
    {input: "<bdo><script>alert()</script></bdo>",
     acceptable: [
         "<bdo>",
         "<bdo />",
         "<bdo></bdo>",
         "<table><bdo></bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
         "<table><bdo><td></td></bdo></table>",
         "<table><bdo></bdo><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_bdo_scriptinside"},
    {input: "<bdo srcdoc=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_srcdoc"},
    {input: "<bdo formaction=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_formaction"},
    {input: "<bdo formmethod=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_formmethod"},
    {input: "<bdo pattern=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_pattern"},
    {input: "<bdo defer=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_defer"},
    {input: "<span></span>",
     acceptable: [
         "<span>",
         "<span />",
         "<span></span>",
         "<table><span></span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
     ],
     name: "contract_span_plain"},
    {input: "<span><script>alert()</script></span>",
     acceptable: [
         "<span>",
         "<span />",
         "<span></span>",
         "<table><span></span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
         "<table><span><td></td></span></table>",
         "<table><span></span><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_span_scriptinside"},
    {input: "<span srcdoc=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
     ],
     name: "contract_span_srcdoc"},
    {input: "<span formaction=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
     ],
     name: "contract_span_formaction"},
    {input: "<span formmethod=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
     ],
     name: "contract_span_formmethod"},
    {input: "<span pattern=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
     ],
     name: "contract_span_pattern"},
    {input: "<span defer=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
     ],
     name: "contract_span_defer"},
    {input: "<br></br>",
     acceptable: [
         "<br>",
         "<br />",
         "<br/>",
         "<br><br>",
         "<br/><br/>",
         "<br /><br />",
         "<table><br></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_plain"},
    {input: "<br><script>alert()</script></br>",
     acceptable: [
         "<br>",
         "<br />",
         "<br/>",
         "<br><br>",
         "<br/><br/>",
         "<br /><br />",
         "<table><br></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><br><td></td></table>",
     ],
     name: "contract_br_scriptinside"},
    {input: "<br srcdoc=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_srcdoc"},
    {input: "<br formaction=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_formaction"},
    {input: "<br formmethod=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_formmethod"},
    {input: "<br pattern=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_pattern"},
    {input: "<br defer=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_defer"},
    {input: "<wbr></wbr>",
     acceptable: [
         "<wbr>",
         "<wbr />",
         "<wbr/>",
         "<wbr><wbr>",
         "<wbr/><wbr/>",
         "<wbr /><wbr />",
         "<table><wbr></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_plain"},
    {input: "<wbr><script>alert()</script></wbr>",
     acceptable: [
         "<wbr>",
         "<wbr />",
         "<wbr/>",
         "<wbr><wbr>",
         "<wbr/><wbr/>",
         "<wbr /><wbr />",
         "<table><wbr></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><wbr><td></td></table>",
     ],
     name: "contract_wbr_scriptinside"},
    {input: "<wbr srcdoc=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_srcdoc"},
    {input: "<wbr formaction=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_formaction"},
    {input: "<wbr formmethod=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_formmethod"},
    {input: "<wbr pattern=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_pattern"},
    {input: "<wbr defer=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_defer"},
    {input: "<link></link>",
     acceptable: [
         "<link>",
         "<link />",
         "<link/>",
         "<link><link>",
         "<link/><link/>",
         "<link /><link />",
         "<table><link></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_plain"},
    {input: "<link><script>alert()</script></link>",
     acceptable: [
         "<link>",
         "<link />",
         "<link/>",
         "<link><link>",
         "<link/><link/>",
         "<link /><link />",
         "<table><link></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><link><td></td></table>",
     ],
     name: "contract_link_scriptinside"},
    {input: "<link rel=\"alternate\" href=\"x\">",
     acceptable: [
         "<link href=x rel=alternate>",
         "<link href=x rel=\"alternate\">",
         "<link href=\"x\" rel=\"alternate\" />",
         "<link rel=\"alternate\" href=\"x\">",
         "<link rel=\"alternate\" href=\"x\"/>",
         "<link rel=\"alternate\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_alternate"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_alternate_x"},
    {input: "<link rel=\"author\" href=\"x\">",
     acceptable: [
         "<link href=x rel=author>",
         "<link href=x rel=\"author\">",
         "<link href=\"x\" rel=\"author\" />",
         "<link rel=\"author\" href=\"x\">",
         "<link rel=\"author\" href=\"x\"/>",
         "<link rel=\"author\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_author"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_author_x"},
    {input: "<link rel=\"bookmark\" href=\"x\">",
     acceptable: [
         "<link href=x rel=bookmark>",
         "<link href=x rel=\"bookmark\">",
         "<link href=\"x\" rel=\"bookmark\" />",
         "<link rel=\"bookmark\" href=\"x\">",
         "<link rel=\"bookmark\" href=\"x\"/>",
         "<link rel=\"bookmark\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_bookmark"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_bookmark_x"},
    {input: "<link rel=\"canonical\" href=\"x\">",
     acceptable: [
         "<link href=x rel=canonical>",
         "<link href=x rel=\"canonical\">",
         "<link href=\"x\" rel=\"canonical\" />",
         "<link rel=\"canonical\" href=\"x\">",
         "<link rel=\"canonical\" href=\"x\"/>",
         "<link rel=\"canonical\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_canonical"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_canonical_x"},
    {input: "<link rel=\"cite\" href=\"x\">",
     acceptable: [
         "<link href=x rel=cite>",
         "<link href=x rel=\"cite\">",
         "<link href=\"x\" rel=\"cite\" />",
         "<link rel=\"cite\" href=\"x\">",
         "<link rel=\"cite\" href=\"x\"/>",
         "<link rel=\"cite\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_cite"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_cite_x"},
    {input: "<link rel=\"help\" href=\"x\">",
     acceptable: [
         "<link href=x rel=help>",
         "<link href=x rel=\"help\">",
         "<link href=\"x\" rel=\"help\" />",
         "<link rel=\"help\" href=\"x\">",
         "<link rel=\"help\" href=\"x\"/>",
         "<link rel=\"help\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_help"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_help_x"},
    {input: "<link rel=\"icon\" href=\"x\">",
     acceptable: [
         "<link href=x rel=icon>",
         "<link href=x rel=\"icon\">",
         "<link href=\"x\" rel=\"icon\" />",
         "<link rel=\"icon\" href=\"x\">",
         "<link rel=\"icon\" href=\"x\"/>",
         "<link rel=\"icon\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_icon"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_icon_x"},
    {input: "<link rel=\"license\" href=\"x\">",
     acceptable: [
         "<link href=x rel=license>",
         "<link href=x rel=\"license\">",
         "<link href=\"x\" rel=\"license\" />",
         "<link rel=\"license\" href=\"x\">",
         "<link rel=\"license\" href=\"x\"/>",
         "<link rel=\"license\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_license"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_license_x"},
    {input: "<link rel=\"next\" href=\"x\">",
     acceptable: [
         "<link href=x rel=next>",
         "<link href=x rel=\"next\">",
         "<link href=\"x\" rel=\"next\" />",
         "<link rel=\"next\" href=\"x\">",
         "<link rel=\"next\" href=\"x\"/>",
         "<link rel=\"next\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_next"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_next_x"},
    {input: "<link rel=\"prefetch\" href=\"x\">",
     acceptable: [
         "<link href=x rel=prefetch>",
         "<link href=x rel=\"prefetch\">",
         "<link href=\"x\" rel=\"prefetch\" />",
         "<link rel=\"prefetch\" href=\"x\">",
         "<link rel=\"prefetch\" href=\"x\"/>",
         "<link rel=\"prefetch\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_prefetch"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_prefetch_x"},
    {input: "<link rel=\"dns-prefetch\" href=\"x\">",
     acceptable: [
         "<link href=x rel=dns-prefetch>",
         "<link href=x rel=\"dns-prefetch\">",
         "<link href=\"x\" rel=\"dns-prefetch\" />",
         "<link rel=\"dns-prefetch\" href=\"x\">",
         "<link rel=\"dns-prefetch\" href=\"x\"/>",
         "<link rel=\"dns-prefetch\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_dns-prefetch"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_dns-prefetch_x"},
    {input: "<link rel=\"prerender\" href=\"x\">",
     acceptable: [
         "<link href=x rel=prerender>",
         "<link href=x rel=\"prerender\">",
         "<link href=\"x\" rel=\"prerender\" />",
         "<link rel=\"prerender\" href=\"x\">",
         "<link rel=\"prerender\" href=\"x\"/>",
         "<link rel=\"prerender\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_prerender"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_prerender_x"},
    {input: "<link rel=\"preconnect\" href=\"x\">",
     acceptable: [
         "<link href=x rel=preconnect>",
         "<link href=x rel=\"preconnect\">",
         "<link href=\"x\" rel=\"preconnect\" />",
         "<link rel=\"preconnect\" href=\"x\">",
         "<link rel=\"preconnect\" href=\"x\"/>",
         "<link rel=\"preconnect\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_preconnect"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_preconnect_x"},
    {input: "<link rel=\"preload\" href=\"x\">",
     acceptable: [
         "<link href=x rel=preload>",
         "<link href=x rel=\"preload\">",
         "<link href=\"x\" rel=\"preload\" />",
         "<link rel=\"preload\" href=\"x\">",
         "<link rel=\"preload\" href=\"x\"/>",
         "<link rel=\"preload\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_preload"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_preload_x"},
    {input: "<link rel=\"prev\" href=\"x\">",
     acceptable: [
         "<link href=x rel=prev>",
         "<link href=x rel=\"prev\">",
         "<link href=\"x\" rel=\"prev\" />",
         "<link rel=\"prev\" href=\"x\">",
         "<link rel=\"prev\" href=\"x\"/>",
         "<link rel=\"prev\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_prev"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_prev_x"},
    {input: "<link rel=\"search\" href=\"x\">",
     acceptable: [
         "<link href=x rel=search>",
         "<link href=x rel=\"search\">",
         "<link href=\"x\" rel=\"search\" />",
         "<link rel=\"search\" href=\"x\">",
         "<link rel=\"search\" href=\"x\"/>",
         "<link rel=\"search\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_search"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_search_x"},
    {input: "<link rel=\"subresource\" href=\"x\">",
     acceptable: [
         "<link href=x rel=subresource>",
         "<link href=x rel=\"subresource\">",
         "<link href=\"x\" rel=\"subresource\" />",
         "<link rel=\"subresource\" href=\"x\">",
         "<link rel=\"subresource\" href=\"x\"/>",
         "<link rel=\"subresource\" href=\"x\" />",
         "",
     ],
     name: "contract_link_rel_subresource"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "<link rel=\"x\" />",
         "",
     ],
     name: "link_subresource_x"},
    {input: "<link srcdoc=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_srcdoc"},
    {input: "<link formaction=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_formaction"},
    {input: "<link formmethod=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_formmethod"},
    {input: "<link pattern=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_pattern"},
    {input: "<link defer=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_defer"},
    {input: "<ins></ins>",
     acceptable: [
         "<ins>",
         "<ins />",
         "<ins></ins>",
         "<table><ins></ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_plain"},
    {input: "<ins><script>alert()</script></ins>",
     acceptable: [
         "<ins>",
         "<ins />",
         "<ins></ins>",
         "<table><ins></ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
         "<table><ins><td></td></ins></table>",
         "<table><ins></ins><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_ins_scriptinside"},
    {input: "<ins srcdoc=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_srcdoc"},
    {input: "<ins formaction=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_formaction"},
    {input: "<ins formmethod=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_formmethod"},
    {input: "<ins pattern=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_pattern"},
    {input: "<ins defer=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_defer"},
    {input: "<del></del>",
     acceptable: [
         "<del>",
         "<del />",
         "<del></del>",
         "<table><del></del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_plain"},
    {input: "<del><script>alert()</script></del>",
     acceptable: [
         "<del>",
         "<del />",
         "<del></del>",
         "<table><del></del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
         "<table><del><td></td></del></table>",
         "<table><del></del><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_del_scriptinside"},
    {input: "<del srcdoc=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_srcdoc"},
    {input: "<del formaction=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_formaction"},
    {input: "<del formmethod=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_formmethod"},
    {input: "<del pattern=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_pattern"},
    {input: "<del defer=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_defer"},
    {input: "<picture></picture>",
     acceptable: [
         "<picture>",
         "<picture />",
         "<picture></picture>",
         "<table><picture></picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_plain"},
    {input: "<picture><script>alert()</script></picture>",
     acceptable: [
         "<picture>",
         "<picture />",
         "<picture></picture>",
         "<table><picture></picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
         "<table><picture><td></td></picture></table>",
         "<table><picture></picture><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_picture_scriptinside"},
    {input: "<picture srcdoc=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_srcdoc"},
    {input: "<picture formaction=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_formaction"},
    {input: "<picture formmethod=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_formmethod"},
    {input: "<picture pattern=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_pattern"},
    {input: "<picture defer=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_defer"},
    {input: "<source></source>",
     acceptable: [
         "<source>",
         "<source />",
         "<source/>",
         "<source><source>",
         "<source/><source/>",
         "<source /><source />",
         "<table><source></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_plain"},
    {input: "<source><script>alert()</script></source>",
     acceptable: [
         "<source>",
         "<source />",
         "<source/>",
         "<source><source>",
         "<source/><source/>",
         "<source /><source />",
         "<table><source></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><source><td></td></table>",
     ],
     name: "contract_source_scriptinside"},
    {input: "<source src=\"javascript:xss\">",
     acceptable: [
         "<source src=\"unsafe:javascript:xss\"></source>",
         "<source src=\"unsafe:javascript:xss\">",
         "<source src=\"unsafe:javascript:xss\"/>",
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_src"},
    {input: "<source srcdoc=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_srcdoc"},
    {input: "<source formaction=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_formaction"},
    {input: "<source formmethod=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_formmethod"},
    {input: "<source pattern=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_pattern"},
    {input: "<source defer=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_defer"},
    {input: "<img></img>",
     acceptable: [
         "<img>",
         "<img />",
         "<img/>",
         "<img><img>",
         "<img/><img/>",
         "<img /><img />",
         "<table><img></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_plain"},
    {input: "<img><script>alert()</script></img>",
     acceptable: [
         "<img>",
         "<img />",
         "<img/>",
         "<img><img>",
         "<img/><img/>",
         "<img /><img />",
         "<table><img></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><img><td></td></table>",
     ],
     name: "contract_img_scriptinside"},
    {input: "<img src=\"javascript:xss\">",
     acceptable: [
         "<img src=\"unsafe:javascript:xss\"></img>",
         "<img src=\"unsafe:javascript:xss\">",
         "<img src=\"unsafe:javascript:xss\"/>",
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_src"},
    {input: "<img srcdoc=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_srcdoc"},
    {input: "<img formaction=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_formaction"},
    {input: "<img formmethod=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_formmethod"},
    {input: "<img pattern=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_pattern"},
    {input: "<img defer=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_defer"},
    {input: "<iframe></iframe>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_plain"},
    {input: "<iframe><script>alert()</script></iframe>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_scriptinside"},
    {input: "<iframe srcdoc=\"x\"></iframe>",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe />",
         "<iframe/>",
         "",
     ],
     name: "contract_iframe_srcdoc"},
    {input: "<iframe formaction=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_formaction"},
    {input: "<iframe formmethod=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_formmethod"},
    {input: "<iframe pattern=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_pattern"},
    {input: "<iframe defer=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_defer"},
    {input: "<embed></embed>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_plain"},
    {input: "<embed><script>alert()</script></embed>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_scriptinside"},
    {input: "<embed srcdoc=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_srcdoc"},
    {input: "<embed formaction=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_formaction"},
    {input: "<embed formmethod=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_formmethod"},
    {input: "<embed pattern=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_pattern"},
    {input: "<embed defer=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_defer"},
    {input: "<object></object>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_plain"},
    {input: "<object><script>alert()</script></object>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_scriptinside"},
    {input: "<object srcdoc=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_srcdoc"},
    {input: "<object formaction=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_formaction"},
    {input: "<object formmethod=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_formmethod"},
    {input: "<object pattern=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_pattern"},
    {input: "<object defer=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_defer"},
    {input: "<param></param>",
     acceptable: [
         "<param>",
         "<param />",
         "<param/>",
         "<param><param>",
         "<param/><param/>",
         "<param /><param />",
         "<table><param></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_plain"},
    {input: "<param><script>alert()</script></param>",
     acceptable: [
         "<param>",
         "<param />",
         "<param/>",
         "<param><param>",
         "<param/><param/>",
         "<param /><param />",
         "<table><param></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><param><td></td></table>",
     ],
     name: "contract_param_scriptinside"},
    {input: "<param srcdoc=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_srcdoc"},
    {input: "<param formaction=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_formaction"},
    {input: "<param formmethod=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_formmethod"},
    {input: "<param pattern=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_pattern"},
    {input: "<param defer=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_defer"},
    {input: "<video></video>",
     acceptable: [
         "<video>",
         "<video />",
         "<video></video>",
         "<table><video></video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_plain"},
    {input: "<video><script>alert()</script></video>",
     acceptable: [
         "<video>",
         "<video />",
         "<video></video>",
         "<table><video></video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
         "<table><video><td></td></video></table>",
         "<table><video></video><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_video_scriptinside"},
    {input: "<video src=\"javascript:xss\">",
     acceptable: [
         "<video src=\"unsafe:javascript:xss\"></video>",
         "<video src=\"unsafe:javascript:xss\">",
         "<video src=\"unsafe:javascript:xss\"/>",
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_src"},
    {input: "<video srcdoc=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_srcdoc"},
    {input: "<video formaction=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_formaction"},
    {input: "<video formmethod=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_formmethod"},
    {input: "<video pattern=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_pattern"},
    {input: "<video defer=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_defer"},
    {input: "<audio></audio>",
     acceptable: [
         "<audio>",
         "<audio />",
         "<audio></audio>",
         "<table><audio></audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_plain"},
    {input: "<audio><script>alert()</script></audio>",
     acceptable: [
         "<audio>",
         "<audio />",
         "<audio></audio>",
         "<table><audio></audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
         "<table><audio><td></td></audio></table>",
         "<table><audio></audio><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_audio_scriptinside"},
    {input: "<audio src=\"javascript:xss\">",
     acceptable: [
         "<audio src=\"unsafe:javascript:xss\"></audio>",
         "<audio src=\"unsafe:javascript:xss\">",
         "<audio src=\"unsafe:javascript:xss\"/>",
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_src"},
    {input: "<audio srcdoc=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_srcdoc"},
    {input: "<audio formaction=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_formaction"},
    {input: "<audio formmethod=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_formmethod"},
    {input: "<audio pattern=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_pattern"},
    {input: "<audio defer=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_defer"},
    {input: "<track></track>",
     acceptable: [
         "<track>",
         "<track />",
         "<track/>",
         "<track><track>",
         "<track/><track/>",
         "<track /><track />",
         "<table><track></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_plain"},
    {input: "<track><script>alert()</script></track>",
     acceptable: [
         "<track>",
         "<track />",
         "<track/>",
         "<track><track>",
         "<track/><track/>",
         "<track /><track />",
         "<table><track></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><track><td></td></table>",
     ],
     name: "contract_track_scriptinside"},
    {input: "<track srcdoc=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_srcdoc"},
    {input: "<track formaction=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_formaction"},
    {input: "<track formmethod=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_formmethod"},
    {input: "<track pattern=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_pattern"},
    {input: "<track defer=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_defer"},
    {input: "<map></map>",
     acceptable: [
         "<map>",
         "<map />",
         "<map></map>",
         "<table><map></map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_plain"},
    {input: "<map><script>alert()</script></map>",
     acceptable: [
         "<map>",
         "<map />",
         "<map></map>",
         "<table><map></map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
         "<table><map><td></td></map></table>",
         "<table><map></map><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_map_scriptinside"},
    {input: "<map srcdoc=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_srcdoc"},
    {input: "<map formaction=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_formaction"},
    {input: "<map formmethod=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_formmethod"},
    {input: "<map pattern=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_pattern"},
    {input: "<map defer=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_defer"},
    {input: "<table></table>",
     acceptable: [
         "<table>",
         "<table />",
         "<table></table>",
         "<table><table></table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_plain"},
    {input: "<table><script>alert()</script></table>",
     acceptable: [
         "<table>",
         "<table />",
         "<table></table>",
         "<table><table></table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
         "<table><table><td></td></table></table>",
         "<table><table></table><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_table_scriptinside"},
    {input: "<table srcdoc=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_srcdoc"},
    {input: "<table formaction=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_formaction"},
    {input: "<table formmethod=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_formmethod"},
    {input: "<table pattern=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_pattern"},
    {input: "<table defer=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_defer"},
    {input: "<caption></caption>",
     acceptable: [
         "<caption>",
         "<caption />",
         "<caption></caption>",
         "<table><caption></caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_plain"},
    {input: "<caption><script>alert()</script></caption>",
     acceptable: [
         "<caption>",
         "<caption />",
         "<caption></caption>",
         "<table><caption></caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
         "<table><caption><td></td></caption></table>",
         "<table><caption></caption><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_caption_scriptinside"},
    {input: "<caption srcdoc=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_srcdoc"},
    {input: "<caption formaction=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_formaction"},
    {input: "<caption formmethod=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_formmethod"},
    {input: "<caption pattern=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_pattern"},
    {input: "<caption defer=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_defer"},
    {input: "<colgroup></colgroup>",
     acceptable: [
         "<colgroup>",
         "<colgroup />",
         "<colgroup></colgroup>",
         "<table><colgroup></colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_plain"},
    {input: "<colgroup><script>alert()</script></colgroup>",
     acceptable: [
         "<colgroup>",
         "<colgroup />",
         "<colgroup></colgroup>",
         "<table><colgroup></colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
         "<table><colgroup><td></td></colgroup></table>",
         "<table><colgroup></colgroup><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_colgroup_scriptinside"},
    {input: "<colgroup srcdoc=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_srcdoc"},
    {input: "<colgroup formaction=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_formaction"},
    {input: "<colgroup formmethod=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_formmethod"},
    {input: "<colgroup pattern=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_pattern"},
    {input: "<colgroup defer=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_defer"},
    {input: "<col></col>",
     acceptable: [
         "<col>",
         "<col />",
         "<col/>",
         "<col><col>",
         "<col/><col/>",
         "<col /><col />",
         "<table><col></table>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_plain"},
    {input: "<col><script>alert()</script></col>",
     acceptable: [
         "<col>",
         "<col />",
         "<col/>",
         "<col><col>",
         "<col/><col/>",
         "<col /><col />",
         "<table><col></table>",
         "<span></span>",
         "<span />",
         "",
         "<table><col><td></td></table>",
     ],
     name: "contract_col_scriptinside"},
    {input: "<col srcdoc=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_srcdoc"},
    {input: "<col formaction=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_formaction"},
    {input: "<col formmethod=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_formmethod"},
    {input: "<col pattern=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_pattern"},
    {input: "<col defer=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_defer"},
    {input: "<tbody></tbody>",
     acceptable: [
         "<tbody>",
         "<tbody />",
         "<tbody></tbody>",
         "<table><tbody></tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_plain"},
    {input: "<tbody><script>alert()</script></tbody>",
     acceptable: [
         "<tbody>",
         "<tbody />",
         "<tbody></tbody>",
         "<table><tbody></tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
         "<table><tbody><td></td></tbody></table>",
         "<table><tbody></tbody><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_tbody_scriptinside"},
    {input: "<tbody srcdoc=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_srcdoc"},
    {input: "<tbody formaction=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_formaction"},
    {input: "<tbody formmethod=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_formmethod"},
    {input: "<tbody pattern=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_pattern"},
    {input: "<tbody defer=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_defer"},
    {input: "<thead></thead>",
     acceptable: [
         "<thead>",
         "<thead />",
         "<thead></thead>",
         "<table><thead></thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_plain"},
    {input: "<thead><script>alert()</script></thead>",
     acceptable: [
         "<thead>",
         "<thead />",
         "<thead></thead>",
         "<table><thead></thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
         "<table><thead><td></td></thead></table>",
         "<table><thead></thead><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_thead_scriptinside"},
    {input: "<thead srcdoc=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_srcdoc"},
    {input: "<thead formaction=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_formaction"},
    {input: "<thead formmethod=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_formmethod"},
    {input: "<thead pattern=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_pattern"},
    {input: "<thead defer=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_defer"},
    {input: "<tfoot></tfoot>",
     acceptable: [
         "<tfoot>",
         "<tfoot />",
         "<tfoot></tfoot>",
         "<table><tfoot></tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_plain"},
    {input: "<tfoot><script>alert()</script></tfoot>",
     acceptable: [
         "<tfoot>",
         "<tfoot />",
         "<tfoot></tfoot>",
         "<table><tfoot></tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
         "<table><tfoot><td></td></tfoot></table>",
         "<table><tfoot></tfoot><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_tfoot_scriptinside"},
    {input: "<tfoot srcdoc=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_srcdoc"},
    {input: "<tfoot formaction=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_formaction"},
    {input: "<tfoot formmethod=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_formmethod"},
    {input: "<tfoot pattern=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_pattern"},
    {input: "<tfoot defer=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_defer"},
    {input: "<tr></tr>",
     acceptable: [
         "<tr>",
         "<tr />",
         "<tr></tr>",
         "<table><tr></tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_plain"},
    {input: "<tr><script>alert()</script></tr>",
     acceptable: [
         "<tr>",
         "<tr />",
         "<tr></tr>",
         "<table><tr></tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
         "<table><tr><td></td></tr></table>",
         "<table><tr></tr><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_tr_scriptinside"},
    {input: "<tr srcdoc=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_srcdoc"},
    {input: "<tr formaction=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_formaction"},
    {input: "<tr formmethod=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_formmethod"},
    {input: "<tr pattern=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_pattern"},
    {input: "<tr defer=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_defer"},
    {input: "<td></td>",
     acceptable: [
         "<td>",
         "<td />",
         "<td></td>",
         "<table><td></td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_plain"},
    {input: "<td><script>alert()</script></td>",
     acceptable: [
         "<td>",
         "<td />",
         "<td></td>",
         "<table><td></td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
         "<table><td><td></td></td></table>",
         "<table><td></td><td></td></table>",
     ],
     name: "contract_td_scriptinside"},
    {input: "<td srcdoc=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_srcdoc"},
    {input: "<td formaction=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_formaction"},
    {input: "<td formmethod=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_formmethod"},
    {input: "<td pattern=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_pattern"},
    {input: "<td defer=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_defer"},
    {input: "<th></th>",
     acceptable: [
         "<th>",
         "<th />",
         "<th></th>",
         "<table><th></th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_plain"},
    {input: "<th><script>alert()</script></th>",
     acceptable: [
         "<th>",
         "<th />",
         "<th></th>",
         "<table><th></th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
         "<table><th><td></td></th></table>",
         "<table><th></th><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_th_scriptinside"},
    {input: "<th srcdoc=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_srcdoc"},
    {input: "<th formaction=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_formaction"},
    {input: "<th formmethod=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_formmethod"},
    {input: "<th pattern=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_pattern"},
    {input: "<th defer=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_defer"},
    {input: "<form></form>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_plain"},
    {input: "<form><script>alert()</script></form>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_scriptinside"},
    {input: "<form action=\"javascript:xss\">",
     acceptable: [
         "<form action=\"unsafe:javascript:xss\"></form>",
         "<form action=\"unsafe:javascript:xss\">",
         "<form action=\"unsafe:javascript:xss\"/>",
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_action"},
    {input: "<form srcdoc=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_srcdoc"},
    {input: "<form formaction=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_formaction"},
    {input: "<form formmethod=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_formmethod"},
    {input: "<form pattern=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_pattern"},
    {input: "<form defer=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_defer"},
    {input: "<label srcdoc=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_srcdoc"},
    {input: "<label formaction=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_formaction"},
    {input: "<label formmethod=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_formmethod"},
    {input: "<label pattern=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_pattern"},
    {input: "<label defer=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_defer"},
    {input: "<input formaction=\"javascript:xss\">",
     acceptable: [
         "<input formaction=\"unsafe:javascript:xss\"></input>",
         "<input formaction=\"unsafe:javascript:xss\">",
         "<input formaction=\"unsafe:javascript:xss\"/>",
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_formaction"},
    {input: "<input src=\"javascript:xss\">",
     acceptable: [
         "<input src=\"unsafe:javascript:xss\"></input>",
         "<input src=\"unsafe:javascript:xss\">",
         "<input src=\"unsafe:javascript:xss\"/>",
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_src"},
    {input: "<input srcdoc=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_srcdoc"},
    {input: "<input defer=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_defer"},
    {input: "<command></command>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_plain"},
    {input: "<command><script>alert()</script></command>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_scriptinside"},
    {input: "<command srcdoc=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_srcdoc"},
    {input: "<command formaction=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_formaction"},
    {input: "<command formmethod=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_formmethod"},
    {input: "<command pattern=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_pattern"},
    {input: "<command defer=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_defer"},
    {input: "<button formaction=\"javascript:xss\">",
     acceptable: [
         "<button formaction=\"unsafe:javascript:xss\"></button>",
         "<button formaction=\"unsafe:javascript:xss\">",
         "<button formaction=\"unsafe:javascript:xss\"/>",
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_formaction"},
    {input: "<button srcdoc=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_srcdoc"},
    {input: "<button pattern=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_pattern"},
    {input: "<button defer=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_defer"},
    {input: "<select></select>",
     acceptable: [
         "<select>",
         "<select />",
         "<select></select>",
         "<table><select></select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_plain"},
    {input: "<select><script>alert()</script></select>",
     acceptable: [
         "<select>",
         "<select />",
         "<select></select>",
         "<table><select></select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
         "<table><select><td></td></select></table>",
         "<table><select></select><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_select_scriptinside"},
    {input: "<select srcdoc=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_srcdoc"},
    {input: "<select formaction=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_formaction"},
    {input: "<select formmethod=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_formmethod"},
    {input: "<select pattern=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_pattern"},
    {input: "<select defer=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_defer"},
    {input: "<datalist></datalist>",
     acceptable: [
         "<datalist>",
         "<datalist />",
         "<datalist></datalist>",
         "<table><datalist></datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_plain"},
    {input: "<datalist><script>alert()</script></datalist>",
     acceptable: [
         "<datalist>",
         "<datalist />",
         "<datalist></datalist>",
         "<table><datalist></datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
         "<table><datalist><td></td></datalist></table>",
         "<table><datalist></datalist><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_datalist_scriptinside"},
    {input: "<datalist srcdoc=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_srcdoc"},
    {input: "<datalist formaction=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_formaction"},
    {input: "<datalist formmethod=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_formmethod"},
    {input: "<datalist pattern=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_pattern"},
    {input: "<datalist defer=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_defer"},
    {input: "<optgroup></optgroup>",
     acceptable: [
         "<optgroup>",
         "<optgroup />",
         "<optgroup></optgroup>",
         "<table><optgroup></optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_plain"},
    {input: "<optgroup><script>alert()</script></optgroup>",
     acceptable: [
         "<optgroup>",
         "<optgroup />",
         "<optgroup></optgroup>",
         "<table><optgroup></optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
         "<table><optgroup><td></td></optgroup></table>",
         "<table><optgroup></optgroup><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_optgroup_scriptinside"},
    {input: "<optgroup srcdoc=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_srcdoc"},
    {input: "<optgroup formaction=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_formaction"},
    {input: "<optgroup formmethod=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_formmethod"},
    {input: "<optgroup pattern=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_pattern"},
    {input: "<optgroup defer=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_defer"},
    {input: "<option></option>",
     acceptable: [
         "<option>",
         "<option />",
         "<option></option>",
         "<table><option></option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_plain"},
    {input: "<option><script>alert()</script></option>",
     acceptable: [
         "<option>",
         "<option />",
         "<option></option>",
         "<table><option></option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
         "<table><option><td></td></option></table>",
         "<table><option></option><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_option_scriptinside"},
    {input: "<option srcdoc=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_srcdoc"},
    {input: "<option formaction=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_formaction"},
    {input: "<option formmethod=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_formmethod"},
    {input: "<option pattern=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_pattern"},
    {input: "<option defer=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_defer"},
    {input: "<textarea srcdoc=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_srcdoc"},
    {input: "<textarea formaction=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_formaction"},
    {input: "<textarea formmethod=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_formmethod"},
    {input: "<textarea pattern=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_pattern"},
    {input: "<textarea defer=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_defer"},
    {input: "<output></output>",
     acceptable: [
         "<output>",
         "<output />",
         "<output></output>",
         "<table><output></output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_plain"},
    {input: "<output><script>alert()</script></output>",
     acceptable: [
         "<output>",
         "<output />",
         "<output></output>",
         "<table><output></output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
         "<table><output><td></td></output></table>",
         "<table><output></output><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_output_scriptinside"},
    {input: "<output srcdoc=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_srcdoc"},
    {input: "<output formaction=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_formaction"},
    {input: "<output formmethod=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_formmethod"},
    {input: "<output pattern=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_pattern"},
    {input: "<output defer=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_defer"},
    {input: "<progress></progress>",
     acceptable: [
         "<progress>",
         "<progress />",
         "<progress></progress>",
         "<table><progress></progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_plain"},
    {input: "<progress><script>alert()</script></progress>",
     acceptable: [
         "<progress>",
         "<progress />",
         "<progress></progress>",
         "<table><progress></progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
         "<table><progress><td></td></progress></table>",
         "<table><progress></progress><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_progress_scriptinside"},
    {input: "<progress srcdoc=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_srcdoc"},
    {input: "<progress formaction=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_formaction"},
    {input: "<progress formmethod=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_formmethod"},
    {input: "<progress pattern=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_pattern"},
    {input: "<progress defer=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_defer"},
    {input: "<meter></meter>",
     acceptable: [
         "<meter>",
         "<meter />",
         "<meter></meter>",
         "<table><meter></meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_plain"},
    {input: "<meter><script>alert()</script></meter>",
     acceptable: [
         "<meter>",
         "<meter />",
         "<meter></meter>",
         "<table><meter></meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
         "<table><meter><td></td></meter></table>",
         "<table><meter></meter><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_meter_scriptinside"},
    {input: "<meter srcdoc=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_srcdoc"},
    {input: "<meter formaction=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_formaction"},
    {input: "<meter formmethod=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_formmethod"},
    {input: "<meter pattern=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_pattern"},
    {input: "<meter defer=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_defer"},
    {input: "<fieldset></fieldset>",
     acceptable: [
         "<fieldset>",
         "<fieldset />",
         "<fieldset></fieldset>",
         "<table><fieldset></fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_plain"},
    {input: "<fieldset><script>alert()</script></fieldset>",
     acceptable: [
         "<fieldset>",
         "<fieldset />",
         "<fieldset></fieldset>",
         "<table><fieldset></fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
         "<table><fieldset><td></td></fieldset></table>",
         "<table><fieldset></fieldset><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_fieldset_scriptinside"},
    {input: "<fieldset srcdoc=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_srcdoc"},
    {input: "<fieldset formaction=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_formaction"},
    {input: "<fieldset formmethod=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_formmethod"},
    {input: "<fieldset pattern=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_pattern"},
    {input: "<fieldset defer=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_defer"},
    {input: "<legend></legend>",
     acceptable: [
         "<legend>",
         "<legend />",
         "<legend></legend>",
         "<table><legend></legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_plain"},
    {input: "<legend><script>alert()</script></legend>",
     acceptable: [
         "<legend>",
         "<legend />",
         "<legend></legend>",
         "<table><legend></legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
         "<table><legend><td></td></legend></table>",
         "<table><legend></legend><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_legend_scriptinside"},
    {input: "<legend srcdoc=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_srcdoc"},
    {input: "<legend formaction=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_formaction"},
    {input: "<legend formmethod=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_formmethod"},
    {input: "<legend pattern=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_pattern"},
    {input: "<legend defer=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_defer"},
    {input: "<details></details>",
     acceptable: [
         "<details>",
         "<details />",
         "<details></details>",
         "<table><details></details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_plain"},
    {input: "<details><script>alert()</script></details>",
     acceptable: [
         "<details>",
         "<details />",
         "<details></details>",
         "<table><details></details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
         "<table><details><td></td></details></table>",
         "<table><details></details><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_details_scriptinside"},
    {input: "<details srcdoc=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_srcdoc"},
    {input: "<details formaction=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_formaction"},
    {input: "<details formmethod=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_formmethod"},
    {input: "<details pattern=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_pattern"},
    {input: "<details defer=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_defer"},
    {input: "<summary></summary>",
     acceptable: [
         "<summary>",
         "<summary />",
         "<summary></summary>",
         "<table><summary></summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_plain"},
    {input: "<summary><script>alert()</script></summary>",
     acceptable: [
         "<summary>",
         "<summary />",
         "<summary></summary>",
         "<table><summary></summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
         "<table><summary><td></td></summary></table>",
         "<table><summary></summary><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_summary_scriptinside"},
    {input: "<summary srcdoc=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_srcdoc"},
    {input: "<summary formaction=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_formaction"},
    {input: "<summary formmethod=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_formmethod"},
    {input: "<summary pattern=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_pattern"},
    {input: "<summary defer=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_defer"},
    {input: "<menu></menu>",
     acceptable: [
         "<menu>",
         "<menu />",
         "<menu></menu>",
         "<table><menu></menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_plain"},
    {input: "<menu><script>alert()</script></menu>",
     acceptable: [
         "<menu>",
         "<menu />",
         "<menu></menu>",
         "<table><menu></menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
         "<table><menu><td></td></menu></table>",
         "<table><menu></menu><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_menu_scriptinside"},
    {input: "<menu srcdoc=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_srcdoc"},
    {input: "<menu formaction=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_formaction"},
    {input: "<menu formmethod=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_formmethod"},
    {input: "<menu pattern=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_pattern"},
    {input: "<menu defer=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_defer"},
    {input: "<dialog></dialog>",
     acceptable: [
         "<dialog>",
         "<dialog />",
         "<dialog></dialog>",
         "<table><dialog></dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_plain"},
    {input: "<dialog><script>alert()</script></dialog>",
     acceptable: [
         "<dialog>",
         "<dialog />",
         "<dialog></dialog>",
         "<table><dialog></dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
         "<table><dialog><td></td></dialog></table>",
         "<table><dialog></dialog><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dialog_scriptinside"},
    {input: "<dialog srcdoc=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_srcdoc"},
    {input: "<dialog formaction=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_formaction"},
    {input: "<dialog formmethod=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_formmethod"},
    {input: "<dialog pattern=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_pattern"},
    {input: "<dialog defer=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_defer"},
    {input: "<script></script>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_plain"},
    {input: "<script><script>alert()</script></script>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_scriptinside"},
    {input: "<script srcdoc=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_srcdoc"},
    {input: "<script formaction=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_formaction"},
    {input: "<script formmethod=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_formmethod"},
    {input: "<script pattern=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_pattern"},
    {input: "<noscript srcdoc=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_srcdoc"},
    {input: "<noscript formaction=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_formaction"},
    {input: "<noscript formmethod=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_formmethod"},
    {input: "<noscript pattern=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_pattern"},
    {input: "<noscript defer=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_defer"},
    {input: "<template></template>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_plain"},
    {input: "<template><script>alert()</script></template>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_scriptinside"},
    {input: "<template srcdoc=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_srcdoc"},
    {input: "<template formaction=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_formaction"},
    {input: "<template formmethod=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_formmethod"},
    {input: "<template pattern=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_pattern"},
    {input: "<template defer=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_defer"},
    {input: "<slot></slot>",
     acceptable: [
         "<slot>",
         "<slot />",
         "<slot></slot>",
         "<table><slot></slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_plain"},
    {input: "<slot><script>alert()</script></slot>",
     acceptable: [
         "<slot>",
         "<slot />",
         "<slot></slot>",
         "<table><slot></slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
         "<table><slot><td></td></slot></table>",
         "<table><slot></slot><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_slot_scriptinside"},
    {input: "<slot srcdoc=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_srcdoc"},
    {input: "<slot formaction=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_formaction"},
    {input: "<slot formmethod=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_formmethod"},
    {input: "<slot pattern=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_pattern"},
    {input: "<slot defer=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_defer"},
    {input: "<canvas></canvas>",
     acceptable: [
         "<canvas>",
         "<canvas />",
         "<canvas></canvas>",
         "<table><canvas></canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_plain"},
    {input: "<canvas><script>alert()</script></canvas>",
     acceptable: [
         "<canvas>",
         "<canvas />",
         "<canvas></canvas>",
         "<table><canvas></canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
         "<table><canvas><td></td></canvas></table>",
         "<table><canvas></canvas><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_canvas_scriptinside"},
    {input: "<canvas srcdoc=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_srcdoc"},
    {input: "<canvas formaction=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_formaction"},
    {input: "<canvas formmethod=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_formmethod"},
    {input: "<canvas pattern=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_pattern"},
    {input: "<canvas defer=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_defer"},
    {input: "<applet></applet>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_plain"},
    {input: "<applet><script>alert()</script></applet>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_scriptinside"},
    {input: "<applet srcdoc=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_srcdoc"},
    {input: "<applet formaction=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_formaction"},
    {input: "<applet formmethod=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_formmethod"},
    {input: "<applet pattern=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_pattern"},
    {input: "<applet defer=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_defer"},
    {input: "<math></math>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_plain"},
    {input: "<math><script>alert()</script></math>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_scriptinside"},
    {input: "<math srcdoc=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_srcdoc"},
    {input: "<math formaction=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_formaction"},
    {input: "<math formmethod=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_formmethod"},
    {input: "<math pattern=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_pattern"},
    {input: "<math defer=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_defer"},
    {input: "<svg></svg>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_plain"},
    {input: "<svg><script>alert()</script></svg>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_scriptinside"},
    {input: "<svg srcdoc=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_srcdoc"},
    {input: "<svg formaction=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_formaction"},
    {input: "<svg formmethod=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_formmethod"},
    {input: "<svg pattern=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_pattern"},
    {input: "<svg defer=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_defer"},
    {input: "<frameset></frameset>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_plain"},
    {input: "<frameset><script>alert()</script></frameset>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_scriptinside"},
    {input: "<frameset srcdoc=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_srcdoc"},
    {input: "<frameset formaction=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_formaction"},
    {input: "<frameset formmethod=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_formmethod"},
    {input: "<frameset pattern=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_pattern"},
    {input: "<frameset defer=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_defer"},
    {input: "<frame></frame>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_plain"},
    {input: "<frame><script>alert()</script></frame>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_scriptinside"},
    {input: "<frame srcdoc=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_srcdoc"},
    {input: "<frame formaction=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_formaction"},
    {input: "<frame formmethod=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_formmethod"},
    {input: "<frame pattern=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_pattern"},
    {input: "<frame defer=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_defer"},
    {input: "<font></font>",
     acceptable: [
         "<font>",
         "<font />",
         "<font></font>",
         "<table><font></font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_plain"},
    {input: "<font><script>alert()</script></font>",
     acceptable: [
         "<font>",
         "<font />",
         "<font></font>",
         "<table><font></font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
         "<table><font><td></td></font></table>",
         "<table><font></font><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_font_scriptinside"},
    {input: "<font srcdoc=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_srcdoc"},
    {input: "<font formaction=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_formaction"},
    {input: "<font formmethod=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_formmethod"},
    {input: "<font pattern=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_pattern"},
    {input: "<font defer=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_defer"},
    {input: "<center></center>",
     acceptable: [
         "<center>",
         "<center />",
         "<center></center>",
         "<table><center></center></table>",
         "<CENTER />",
         "<CENTER></CENTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_center_plain"},
    {input: "<center><script>alert()</script></center>",
     acceptable: [
         "<center>",
         "<center />",
         "<center></center>",
         "<table><center></center></table>",
         "<CENTER />",
         "<CENTER></CENTER>",
         "<span></span>",
         "<span />",
         "",
         "<table><center><td></td></center></table>",
         "<table><center></center><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_center_scriptinside"},
    {input: "<center srcdoc=\"x\">",
     acceptable: [
         "<center></center>",
         "<center>",
         "<center/>",
         "<center />",
         "<table><center></center></table>",
         "<table><center></table>",
         "<CENTER />",
         "<CENTER></CENTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_center_srcdoc"},
    {input: "<center formaction=\"x\">",
     acceptable: [
         "<center></center>",
         "<center>",
         "<center/>",
         "<center />",
         "<table><center></center></table>",
         "<table><center></table>",
         "<CENTER />",
         "<CENTER></CENTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_center_formaction"},
    {input: "<center formmethod=\"x\">",
     acceptable: [
         "<center></center>",
         "<center>",
         "<center/>",
         "<center />",
         "<table><center></center></table>",
         "<table><center></table>",
         "<CENTER />",
         "<CENTER></CENTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_center_formmethod"},
    {input: "<center pattern=\"x\">",
     acceptable: [
         "<center></center>",
         "<center>",
         "<center/>",
         "<center />",
         "<table><center></center></table>",
         "<table><center></table>",
         "<CENTER />",
         "<CENTER></CENTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_center_pattern"},
    {input: "<center defer=\"x\">",
     acceptable: [
         "<center></center>",
         "<center>",
         "<center/>",
         "<center />",
         "<table><center></center></table>",
         "<table><center></table>",
         "<CENTER />",
         "<CENTER></CENTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_center_defer"},
    {input: "<p style=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_style"},
    {input: "<p aria-activedescendant=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_aria-activedescendant"},
    {input: "<p aria-owns=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_aria-owns"},
    {input: "<p async=\"x\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_async"},
    {input: "<p async=\"async\"></p>",
     acceptable: [
         "<p async=\"async\"></p>",
         "<p async=\"async\" />",
         "<p async=async></p>",
         "<p></p>",
         "<p />",
     ],
     name: "contract_async_async"},
    {input: "<p for=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_for"},
    {input: "<p id=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_id"},
    {input: "<p list=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_list"},
    {input: "<p loading=\"x\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_loading"},
    {input: "<p loading=\"eager\"></p>",
     acceptable: [
         "<p loading=\"eager\"></p>",
         "<p loading=\"eager\" />",
         "<p loading=eager></p>",
         "<p></p>",
         "<p />",
     ],
     name: "contract_loading_eager"},
    {input: "<p loading=\"lazy\"></p>",
     acceptable: [
         "<p loading=\"lazy\"></p>",
         "<p loading=\"lazy\" />",
         "<p loading=lazy></p>",
         "<p></p>",
         "<p />",
     ],
     name: "contract_loading_lazy"},
    {input: "<p name=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_name"},
    {input: "<p poster=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_poster"},
    {input: "<p srcset=\"javascript:xss\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_srcset"},
    {input: "<p src=\"x\"></p>",
     acceptable: [
         "<p src=\"javascript:void(0);\"></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_src"},
    {input: "<p target=\"x\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_target"},
    {input: "<p target=\"_self\"></p>",
     acceptable: [
         "<p target=\"_self\"></p>",
         "<p target=\"_self\" />",
         "<p target=_self></p>",
         "<p></p>",
         "<p />",
     ],
     name: "contract_target__self"},
    {input: "<p target=\"_blank\"></p>",
     acceptable: [
         "<p target=\"_blank\"></p>",
         "<p target=\"_blank\" />",
         "<p target=_blank></p>",
         "<p></p>",
         "<p />",
     ],
     name: "contract_target__blank"},
];
