
/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @fileoverview Duration formatting symbols.
 *
 * File generated from CLDR ver. 42
 *
 * This file covers those locales that are not covered in
 * "DurationSymbols.js".
 */
// clang-format off
goog.module('goog.i18n.DurationSymbolsExt');
const DurationSymbolTypes = goog.require('goog.i18n.DurationSymbolTypes');
const DurationSymbols = goog.require('goog.i18n.DurationSymbols');

/** @type {!DurationSymbolTypes.DurationSymbols} */
let defaultSymbols;
/** @const {!DurationSymbolTypes.DurationSymbols} */
exports.DurationSymbols_af_NA = DurationSymbols.DurationSymbols_af;
/** @const {!DurationSymbolTypes.DurationSymbols} */
exports.DurationSymbols_af_ZA = DurationSymbols.DurationSymbols_af;
/** @const {!DurationSymbolTypes.DurationSymbols} */
exports.DurationSymbols_agq =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_agq_CM = exports.DurationSymbols_agq;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ak =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ak_GH = exports.DurationSymbols_ak;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_am_ET = DurationSymbols.DurationSymbols_am;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_001 = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_AE = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_BH = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_DJ = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_EH = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_ER = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_IL = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_IQ = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_JO = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_KM = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_KW = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_LB = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_LY = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_MA = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_MR = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_OM = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_PS = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_QA = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_SA =  {
  DAY: {
    LONG: "zero{# يوم}one{يوم}two{يومان}few{# أيام}many{# يومًا}other{# يوم}",
    SHORT: "zero{# يوم}one{يوم}two{يومان}few{# أيام}many{# يومًا}other{# يوم}",
    NARROW: "zero{# ي}one{# ي}two{# ي}few{# ي}many{# ي}other{# ي}",
  },
  HOUR: {
    LONG: "zero{# ساعة}one{ساعة}two{ساعتان}few{# ساعات}many{# ساعة}other{# ساعة}",
    SHORT: "zero{# س}one{# س}two{# س}few{# س}many{# س}other{# س}",
    NARROW: "zero{# س}one{# س}two{# س}few{# س}many{# س}other{# س}",
  },
  MINUTE: {
    LONG: "zero{# دقيقة}one{دقيقة}two{دقيقتان}few{# دقائق}many{# دقيقة}other{# دقيقة}",
    SHORT: "zero{# د}one{# د}two{# د}few{# د}many{# د}other{# د}",
    NARROW: "zero{# د}one{# د}two{# د}few{# د}many{# د}other{# د}",
  },
  MONTH: {
    LONG: "zero{# شهر}one{شهر}two{شهران}few{# أشهر}many{# شهرًا}other{# شهر}",
    SHORT: "zero{# شهر}one{شهر}two{شهران}few{# أشهر}many{# شهرًا}other{# شهر}",
    NARROW: "zero{# شهر}one{شهر}two{شهران}few{# أشهر}many{# شهرًا}other{# شهر}",
  },
  SECOND: {
    LONG: "zero{# ثانية}one{ثانية}two{ثانيتان}few{# ثوانٍ}many{# ثانية}other{# ثانية}",
    SHORT: "zero{# ث}one{# ث}two{# ث}few{# ث}many{# ث}other{# ث}",
    NARROW: "zero{# ث}one{# ث}two{# ث}few{# ث}many{# ث}other{# ث}",
  },
  WEEK: {
    LONG: "zero{# أسبوع}one{أسبوع}two{أسبوعان}few{# أسابيع}many{# أسبوعًا}other{# أسبوع}",
    SHORT: "zero{# أسبوع}one{أسبوع}two{أسبوعان}few{# أسابيع}many{# أسبوعًا}other{# أسبوع}",
    NARROW: "zero{# أ}one{# أ}two{# أ}few{# أ}many{# أ}other{# أ}",
  },
  YEAR: {
    LONG: "zero{# سنة}one{سنة}two{سنتان}few{# سنوات}many{# سنة}other{# سنة}",
    SHORT: "zero{# سنة}one{سنة}two{سنتان}few{# سنوات}many{# سنة}other{# سنة}",
    NARROW: "zero{# سنة}one{سنة}two{سنتان}few{# سنوات}many{# سنة}other{# سنة}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_SD = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_SO = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_SS = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_SY = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_TD = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_TN = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_XB =  {
  DAY: {
    LONG: "zero{# يوم}one{# ؜‮day‬؜}two{يومان}few{# أيام}many{# يومًا}other{# ؜‮days‬؜}",
    SHORT: "zero{# يوم}one{# ؜‮day‬؜}two{يومان}few{# أيام}many{# يومًا}other{# ؜‮days‬؜}",
    NARROW: "zero{# ي}one{# ي}two{# ي}few{# ي}many{# ي}other{# ي}",
  },
  HOUR: {
    LONG: "zero{# ساعة}one{# ؜‮hour‬؜}two{ساعتان}few{# ساعات}many{# ساعة}other{# ؜‮hours‬؜}",
    SHORT: "zero{# س}one{# ؜‮hr‬؜}two{# س}few{# س}many{# س}other{# ؜‮hr‬؜}",
    NARROW: "zero{# س}one{# س}two{# س}few{# س}many{# س}other{# س}",
  },
  MINUTE: {
    LONG: "zero{# دقيقة}one{# ؜‮minute‬؜}two{دقيقتان}few{# دقائق}many{# دقيقة}other{# ؜‮minutes‬؜}",
    SHORT: "zero{# د}one{# ؜‮min‬؜}two{# د}few{# د}many{# د}other{# ؜‮min‬؜}",
    NARROW: "zero{# د}one{# د}two{# د}few{# د}many{# د}other{# د}",
  },
  MONTH: {
    LONG: "zero{# شهر}one{# ؜‮month‬؜}two{شهران}few{# أشهر}many{# شهرًا}other{# ؜‮months‬؜}",
    SHORT: "zero{# شهر}one{# ؜‮mth‬؜}two{شهران}few{# أشهر}many{# شهرًا}other{# ؜‮mths‬؜}",
    NARROW: "zero{# شهر}one{شهر}two{شهران}few{# أشهر}many{# شهرًا}other{# شهر}",
  },
  SECOND: {
    LONG: "zero{# ثانية}one{# ؜‮second‬؜}two{ثانيتان}few{# ثوان}many{# ثانية}other{# ؜‮seconds‬؜}",
    SHORT: "zero{# ث}one{# ؜‮sec‬؜}two{# ث}few{# ث}many{# ث}other{# ؜‮sec‬؜}",
    NARROW: "zero{# ث}one{# ث}two{# ث}few{# ث}many{# ث}other{# ث}",
  },
  WEEK: {
    LONG: "zero{# أسبوع}one{# ؜‮week‬؜}two{أسبوعان}few{# أسابيع}many{# أسبوعًا}other{# ؜‮weeks‬؜}",
    SHORT: "zero{# أسبوع}one{# ؜‮wk‬؜}two{أسبوعان}few{# أسابيع}many{# أسبوعًا}other{# ؜‮wks‬؜}",
    NARROW: "zero{# أ}one{# أ}two{# أ}few{# أ}many{# أ}other{# أ}",
  },
  YEAR: {
    LONG: "zero{# سنة}one{# ؜‮year‬؜}two{سنتان}few{# سنوات}many{# سنة}other{# ؜‮years‬؜}",
    SHORT: "zero{# سنة}one{# ؜‮yr‬؜}two{سنتان}few{# سنوات}many{# سنة}other{# ؜‮yrs‬؜}",
    NARROW: "zero{# سنة}one{# سنة}two{# سنة}few{# سنة}many{# سنة}other{# سنة}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ar_YE = DurationSymbols.DurationSymbols_ar;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_as =  {
  DAY: {
    LONG: "one{# দিন}other{# দিন}",
    SHORT: "one{# দিন}other{# দিন}",
    NARROW: "one{# দিন}other{# দিন}",
  },
  HOUR: {
    LONG: "one{# ঘণ্টা}other{# ঘণ্টা}",
    SHORT: "one{# ঘণ্টা}other{# ঘণ্টা}",
    NARROW: "one{# ঘণ্টা}other{# ঘণ্টা}",
  },
  MINUTE: {
    LONG: "one{# মিনিট}other{# মিনিট}",
    SHORT: "one{# মিনিট}other{# মিনিট}",
    NARROW: "one{# মিনিট}other{# মিনিট}",
  },
  MONTH: {
    LONG: "one{# মাহ}other{# মাহ}",
    SHORT: "one{# মাহ}other{# মাহ}",
    NARROW: "one{# মাহ}other{# মাহ}",
  },
  SECOND: {
    LONG: "one{# ছেকেণ্ড}other{# ছেকেণ্ড}",
    SHORT: "one{# ছেকেণ্ড}other{# ছেকেণ্ড}",
    NARROW: "one{# ছেকেণ্ড}other{# ছেকেণ্ড}",
  },
  WEEK: {
    LONG: "one{# সপ্তাহ}other{# সপ্তাহ}",
    SHORT: "one{# সপ্তাহ}other{# সপ্তাহ}",
    NARROW: "one{# সপ্তাহ}other{# সপ্তাহ}",
  },
  YEAR: {
    LONG: "one{# বছৰ}other{# বছৰ}",
    SHORT: "one{# বছৰ}other{# বছৰ}",
    NARROW: "one{# বছৰ}other{# বছৰ}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_as_IN = exports.DurationSymbols_as;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_asa =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_asa_TZ = exports.DurationSymbols_asa;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ast =  {
  DAY: {
    LONG: "one{# día}other{# díes}",
    SHORT: "one{# día}other{# díes}",
    NARROW: "one{#día}other{#díes}",
  },
  HOUR: {
    LONG: "one{# hora}other{# hores}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#hr}other{#hrs}",
  },
  MINUTE: {
    LONG: "one{# minutu}other{# minutos}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#min}other{#mins}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# mes}other{# meses}",
    NARROW: "one{#mes}other{#meses}",
  },
  SECOND: {
    LONG: "one{# segundu}other{# segundos}",
    SHORT: "one{# seg}other{# segs}",
    NARROW: "one{#seg}other{#segs}",
  },
  WEEK: {
    LONG: "one{# selmana}other{# selmanes}",
    SHORT: "one{# sel}other{# sels}",
    NARROW: "one{#sel}other{#sels}",
  },
  YEAR: {
    LONG: "one{# añu}other{# años}",
    SHORT: "one{# añ}other{# añs}",
    NARROW: "one{#añ}other{#añs}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ast_ES = exports.DurationSymbols_ast;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_az_Cyrl =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_az_Cyrl_AZ =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_az_Latn = DurationSymbols.DurationSymbols_az;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_az_Latn_AZ = DurationSymbols.DurationSymbols_az;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bas =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bas_CM = exports.DurationSymbols_bas;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_be_BY = DurationSymbols.DurationSymbols_be;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bem =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bem_ZM = exports.DurationSymbols_bem;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bez =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bez_TZ = exports.DurationSymbols_bez;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bg_BG = DurationSymbols.DurationSymbols_bg;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bm =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bm_ML = exports.DurationSymbols_bm;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bn_BD = DurationSymbols.DurationSymbols_bn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bn_IN = DurationSymbols.DurationSymbols_bn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bo =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bo_CN = exports.DurationSymbols_bo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bo_IN = exports.DurationSymbols_bo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_br_FR = DurationSymbols.DurationSymbols_br;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_brx =  {
  DAY: {
    LONG: "one{# सान}other{# सान}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "one{# रिंगा}other{# घंटे}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "one{# मिन.}other{# मिन.}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{# महीना}other{# महीने}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "one{# सेकं.}other{# सेकं.}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "one{# सप्ताह}other{# सप्ताह}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "one{# साल}other{# साल}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_brx_IN = exports.DurationSymbols_brx;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bs_Cyrl =  {
  DAY: {
    LONG: "one{# дан}few{# дана}other{# дана}",
    SHORT: "one{# дан}few{# дана}other{# дан}",
    NARROW: "one{# дан}few{# дана}other{# дан}",
  },
  HOUR: {
    LONG: "one{# сат}few{# сата}other{# сати}",
    SHORT: "one{# сат}few{# сата}other{# сати}",
    NARROW: "one{# сат}few{# сата}other{# сати}",
  },
  MINUTE: {
    LONG: "one{# минут}few{# минута}other{# минута}",
    SHORT: "one{# мин.}few{# мин.}other{# мин.}",
    NARROW: "one{# мин.}few{# мин.}other{# мин.}",
  },
  MONTH: {
    LONG: "one{# мјесец}few{# мјесеца}other{# мјесеци}",
    SHORT: "one{# мјес.}few{# мјес.}other{# мјес.}",
    NARROW: "one{# мјес.}few{# мјес.}other{# мјес.}",
  },
  SECOND: {
    LONG: "one{# секунда}few{# секунде}other{# секунди}",
    SHORT: "one{# сек.}few{# сек.}other{# сек.}",
    NARROW: "one{# сек.}few{# сек.}other{# сек.}",
  },
  WEEK: {
    LONG: "one{# седмица}few{# седмице}other{# седмица}",
    SHORT: "one{# сед.}few{# сед.}other{# сед.}",
    NARROW: "one{# сед.}few{# сед.}other{# сед.}",
  },
  YEAR: {
    LONG: "one{# година}few{# године}other{# година}",
    SHORT: "one{# год}few{# год}other{# год}",
    NARROW: "one{# год}few{# год}other{# год}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bs_Cyrl_BA =  {
  DAY: {
    LONG: "one{# дан}few{# дана}other{# дана}",
    SHORT: "one{# дан}few{# дана}other{# дан}",
    NARROW: "one{# дан}few{# дана}other{# дан}",
  },
  HOUR: {
    LONG: "one{# сат}few{# сата}other{# сати}",
    SHORT: "one{# сат}few{# сата}other{# сати}",
    NARROW: "one{# сат}few{# сата}other{# сати}",
  },
  MINUTE: {
    LONG: "one{# минут}few{# минута}other{# минута}",
    SHORT: "one{# мин.}few{# мин.}other{# мин.}",
    NARROW: "one{# мин.}few{# мин.}other{# мин.}",
  },
  MONTH: {
    LONG: "one{# мјесец}few{# мјесеца}other{# мјесеци}",
    SHORT: "one{# мјес.}few{# мјес.}other{# мјес.}",
    NARROW: "one{# мјес.}few{# мјес.}other{# мјес.}",
  },
  SECOND: {
    LONG: "one{# секунда}few{# секунде}other{# секунди}",
    SHORT: "one{# сек.}few{# сек.}other{# сек.}",
    NARROW: "one{# сек.}few{# сек.}other{# сек.}",
  },
  WEEK: {
    LONG: "one{# седмица}few{# седмице}other{# седмица}",
    SHORT: "one{# сед.}few{# сед.}other{# сед.}",
    NARROW: "one{# сед.}few{# сед.}other{# сед.}",
  },
  YEAR: {
    LONG: "one{# година}few{# године}other{# година}",
    SHORT: "one{# год}few{# год}other{# год}",
    NARROW: "one{# год}few{# год}other{# год}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bs_Latn = DurationSymbols.DurationSymbols_bs;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_bs_Latn_BA = DurationSymbols.DurationSymbols_bs;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ca_AD = DurationSymbols.DurationSymbols_ca;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ca_ES = DurationSymbols.DurationSymbols_ca;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ca_FR = DurationSymbols.DurationSymbols_ca;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ca_IT = DurationSymbols.DurationSymbols_ca;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ccp =  {
  DAY: {
    LONG: "one{# 𑄘𑄨𑄚𑄴}other{# 𑄘𑄨𑄚𑄴}",
    SHORT: "one{# 𑄘𑄨𑄚𑄴}other{# 𑄘𑄨𑄚𑄴}",
    NARROW: "one{# 𑄘𑄨𑄚𑄴}other{# 𑄘𑄨𑄚𑄴}",
  },
  HOUR: {
    LONG: "one{# 𑄊𑄧𑄚𑄴𑄘}other{# 𑄊𑄧𑄚𑄴𑄘}",
    SHORT: "one{# 𑄊𑄧𑄚𑄴𑄑}other{# 𑄊𑄧𑄚𑄴𑄑}",
    NARROW: "one{# 𑄊𑄂}other{# 𑄊𑄂}",
  },
  MINUTE: {
    LONG: "one{# 𑄟𑄨𑄚𑄨𑄖𑄴}other{# 𑄟𑄨𑄚𑄨𑄖𑄴}",
    SHORT: "one{# 𑄟𑄨𑄚𑄨𑄖𑄴}other{# 𑄟𑄨𑄚𑄨𑄖𑄴}",
    NARROW: "one{# 𑄟𑄨𑄂}other{# 𑄟𑄨𑄂}",
  },
  MONTH: {
    LONG: "one{# 𑄟𑄌𑄴}other{# 𑄟𑄌𑄴}",
    SHORT: "one{# 𑄟𑄌𑄴}other{# 𑄟𑄌𑄴}",
    NARROW: "one{# 𑄟𑄌𑄴}other{# 𑄟𑄌𑄴}",
  },
  SECOND: {
    LONG: "one{# 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴}other{# 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴}",
    SHORT: "one{# 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴}other{# 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴}",
    NARROW: "one{# 𑄥𑄬𑄂}other{# 𑄥𑄬𑄂}",
  },
  WEEK: {
    LONG: "one{# 𑄥𑄛𑄴𑄖}other{# 𑄥𑄛𑄴𑄖}",
    SHORT: "one{# 𑄥𑄛𑄴𑄖}other{# 𑄥𑄛𑄴𑄖}",
    NARROW: "one{# 𑄥𑄛𑄴𑄖}other{# 𑄥𑄛𑄴𑄖}",
  },
  YEAR: {
    LONG: "one{# 𑄝𑄧𑄏𑄧𑄢𑄴}other{# 𑄝𑄧𑄏𑄧𑄢𑄴}",
    SHORT: "one{# 𑄝𑄧𑄏𑄧𑄢𑄴}other{# 𑄝𑄧𑄏𑄧𑄢𑄴}",
    NARROW: "one{# 𑄝𑄧𑄏𑄧𑄢𑄴}other{# 𑄝𑄧𑄏𑄧𑄢𑄴}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ccp_BD = exports.DurationSymbols_ccp;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ccp_IN = exports.DurationSymbols_ccp;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ce =  {
  DAY: {
    LONG: "one{# де}other{# де}",
    SHORT: "one{д.}other{# д.}",
    NARROW: "one{# д.}other{# д.}",
  },
  HOUR: {
    LONG: "one{# сахьт}other{# сахьт}",
    SHORT: "one{# сахь.}other{# сахь.}",
    NARROW: "one{# сахь.}other{# сахь.}",
  },
  MINUTE: {
    LONG: "one{# минот}other{# минот}",
    SHORT: "one{# мин}other{# мин}",
    NARROW: "one{# мин}other{# мин}",
  },
  MONTH: {
    LONG: "one{# бутт}other{# бутт}",
    SHORT: "one{# бут.}other{# бут.}",
    NARROW: "one{# б.}other{# б.}",
  },
  SECOND: {
    LONG: "one{# секунд}other{# секунд}",
    SHORT: "one{# сек}other{# сек}",
    NARROW: "one{# с}other{# с}",
  },
  WEEK: {
    LONG: "one{# кӀира}other{# кӀира}",
    SHORT: "one{# кӀир.}other{# кӀир.}",
    NARROW: "one{# кӀ.}other{# кӀ.}",
  },
  YEAR: {
    LONG: "one{# шо}other{# шо}",
    SHORT: "one{# ш.}other{# ш.}",
    NARROW: "one{# ш.}other{# ш.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ce_RU = exports.DurationSymbols_ce;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ceb =  {
  DAY: {
    LONG: "one{# ka adlaw}other{# ka mga adlaw}",
    SHORT: "one{# ka adlaw}other{# ka adlaw}",
    NARROW: "one{# adlaw}other{# adlaw}",
  },
  HOUR: {
    LONG: "one{# ka oras}other{# ka mga oras}",
    SHORT: "one{# ka oras}other{# ka oras}",
    NARROW: "one{# ka oras}other{# ka oras}",
  },
  MINUTE: {
    LONG: "one{# ka minuto}other{# ka mga minuto}",
    SHORT: "one{# ka minuto}other{# ka minuto}",
    NARROW: "one{# minuto}other{# minuto}",
  },
  MONTH: {
    LONG: "one{# ka buwan}other{# ka mga buwan}",
    SHORT: "one{# ka buwan}other{# ka buwan}",
    NARROW: "one{# buwan}other{# buwan}",
  },
  SECOND: {
    LONG: "one{# ka segundo}other{# ka mga segundo}",
    SHORT: "one{#segundo}other{#segundo}",
    NARROW: "one{#segundo}other{#segundo}",
  },
  WEEK: {
    LONG: "one{# ka semana}other{# ka mga semana}",
    SHORT: "one{# ka semana}other{# ka semana}",
    NARROW: "one{# semana}other{#w}",
  },
  YEAR: {
    LONG: "one{# ka tuig}other{# ka mga tuig}",
    SHORT: "one{# ka tuig}other{# ka tuig}",
    NARROW: "one{# ka tuig}other{# ka tuig}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ceb_PH = exports.DurationSymbols_ceb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_cgg =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_cgg_UG = exports.DurationSymbols_cgg;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_chr_US = DurationSymbols.DurationSymbols_chr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ckb =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ckb_Arab = exports.DurationSymbols_ckb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ckb_Arab_IQ = exports.DurationSymbols_ckb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ckb_Arab_IR = exports.DurationSymbols_ckb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ckb_IQ = exports.DurationSymbols_ckb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ckb_IR = exports.DurationSymbols_ckb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_cs_CZ = DurationSymbols.DurationSymbols_cs;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_cy_GB = DurationSymbols.DurationSymbols_cy;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_da_DK = DurationSymbols.DurationSymbols_da;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_da_GL = DurationSymbols.DurationSymbols_da;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dav =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dav_KE = exports.DurationSymbols_dav;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_de_BE = DurationSymbols.DurationSymbols_de;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_de_DE = DurationSymbols.DurationSymbols_de;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_de_IT = DurationSymbols.DurationSymbols_de;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_de_LI = DurationSymbols.DurationSymbols_de;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_de_LU = DurationSymbols.DurationSymbols_de;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dje =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dje_NE = exports.DurationSymbols_dje;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_doi =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_doi_IN = exports.DurationSymbols_doi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dsb =  {
  DAY: {
    LONG: "one{# źeń}two{# dnja}few{# dny}other{# dnjow}",
    SHORT: "one{# ź.}two{# dn.}few{# dn.}other{# dn.}",
    NARROW: "one{# ź}two{# d}few{# d}other{# d}",
  },
  HOUR: {
    LONG: "one{# góźina}two{# góźinje}few{# góźiny}other{# góźinow}",
    SHORT: "one{# góź.}two{# góź.}few{# góź.}other{# góź.}",
    NARROW: "one{# g}two{# g}few{# g}other{# g}",
  },
  MINUTE: {
    LONG: "one{# minuta}two{# minuśe}few{# minuty}other{# minutow}",
    SHORT: "one{# min.}two{# min.}few{# min.}other{# min.}",
    NARROW: "one{# min}two{# min}few{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mjasec}two{# mjaseca}few{# mjasecy}other{# mjasecow}",
    SHORT: "one{# mjas.}two{# mjas.}few{# mjas.}other{# mjas.}",
    NARROW: "one{# mjas.}two{# mjas.}few{# mjas.}other{# mjas.}",
  },
  SECOND: {
    LONG: "one{# sekunda}two{# sekunźe}few{# sekundy}other{# sekundow}",
    SHORT: "one{# sek.}two{# sek.}few{# sek.}other{# sek.}",
    NARROW: "one{# s}two{# s}few{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# tyźeń}two{# tyźenja}few{# tyźenje}other{# tyźenjow}",
    SHORT: "one{# tyź.}two{# tyź.}few{# tyź.}other{# tyź.}",
    NARROW: "one{# tyź.}two{# tyź.}few{# tyź.}other{# tyź.}",
  },
  YEAR: {
    LONG: "one{# lěto}two{# lěśe}few{# lěta}other{# lět}",
    SHORT: "one{# l.}two{# l.}few{# l.}other{# l.}",
    NARROW: "one{# l.}two{# l.}few{# l.}other{# l.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dsb_DE = exports.DurationSymbols_dsb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dua =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dua_CM = exports.DurationSymbols_dua;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dyo =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dyo_SN = exports.DurationSymbols_dyo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dz =  {
  DAY: {
    LONG: "other{ཉིན་ཞག་ #}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{ཆུ་ཚོད་ #}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{སྐར་མ་ #}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{ཟླཝ་ #}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{སྐར་ཆ་ #}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{བངུན་ཕྲག་ #}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{ལོ་འཁོར་ #}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_dz_BT = exports.DurationSymbols_dz;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ebu =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ebu_KE = exports.DurationSymbols_ebu;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ee =  {
  DAY: {
    LONG: "one{ŋkeke #}other{ŋkeke #}",
    SHORT: "one{ŋkeke #}other{ŋkeke #}",
    NARROW: "one{ŋkeke #}other{ŋkeke #}",
  },
  HOUR: {
    LONG: "one{gaƒoƒo #}other{gaƒoƒo #}",
    SHORT: "one{gaƒoƒo #}other{gaƒoƒo #}",
    NARROW: "one{gaƒoƒo #}other{gaƒoƒo #}",
  },
  MINUTE: {
    LONG: "one{aɖabaƒoƒo #}other{aɖabaƒoƒo #}",
    SHORT: "one{a #}other{a #}",
    NARROW: "one{a #}other{a #}",
  },
  MONTH: {
    LONG: "one{ɣleti #}other{ɣleti #}",
    SHORT: "one{ɣleti #}other{ɣleti #}",
    NARROW: "one{ɣleti #}other{ɣleti #}",
  },
  SECOND: {
    LONG: "one{sekend # wo}other{sekend # wo}",
    SHORT: "one{sekend #}other{sekend #}",
    NARROW: "one{s #}other{s #}",
  },
  WEEK: {
    LONG: "one{kɔsiɖa #}other{kɔsiɖa #}",
    SHORT: "one{kɔsiɖa #}other{kɔsiɖa #}",
    NARROW: "one{kɔsiɖa #}other{kɔsiɖa #}",
  },
  YEAR: {
    LONG: "one{ƒe #}other{ƒe #}",
    SHORT: "one{ƒe #}other{ƒe #}",
    NARROW: "one{ƒe #}other{ƒe #}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ee_GH = exports.DurationSymbols_ee;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ee_TG = exports.DurationSymbols_ee;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_el_CY = DurationSymbols.DurationSymbols_el;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_el_GR = DurationSymbols.DurationSymbols_el;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_001 =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_150 =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_AE = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_AG =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_AI =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_AS = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_AT =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_BB =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_BE =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_BI = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_BM =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_BS =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_BW =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_BZ =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_CC =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_CH =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_CK =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_CM =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_CX =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_CY =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_DE =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_DG =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_DK =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_DM =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_ER =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_FI =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_FJ =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_FK =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_FM =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_GD =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_GG =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_GH =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_GI =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_GM =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_GU = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_GY =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_HK =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_IL =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_IM =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_IO =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_JE =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_JM =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_KE =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_KI =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_KN =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_KY =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_LC =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_LR =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_LS =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MG =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MH = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MO =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MP = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MS =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MT =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MU =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MV =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MW =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_MY =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_NA =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_NF =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_NG =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_NL =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_NR =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_NU =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_NZ =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_PG =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_PH = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_PK =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_PN =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_PR = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_PW =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_RW =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SB =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SC =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SD =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SE =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SH =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SI =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SL =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SS =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SX =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_SZ =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_TC =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_TK =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_TO =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_TT =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_TV =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_TZ =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_UG =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_UM = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_US_POSIX = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_VC =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_VG =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_VI = DurationSymbols.DurationSymbols_en;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_VU =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_WS =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_XA =  {
  DAY: {
    LONG: "one{[# ðåý one two]}other{[# ðåýš one two]}",
    SHORT: "one{[# ðåý one two]}other{[# ðåýš one two]}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{[# ĥöûŕ one two]}other{[# ĥöûŕš one two]}",
    SHORT: "one{[# ĥŕ one]}other{[# ĥŕ one]}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{[# ɱîñûţé one two]}other{[# ɱîñûţéš one two]}",
    SHORT: "one{[# ɱîñ one two]}other{[# ɱîñ one two]}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{[# ɱöñţĥ one two]}other{[# ɱöñţĥš one two]}",
    SHORT: "one{[# ɱţĥ one two]}other{[# ɱţĥš one two]}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{[# šéçöñð one two]}other{[# šéçöñðš one two]}",
    SHORT: "one{[# šéç one two]}other{[# šéç one two]}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{[# ŵééķ one two]}other{[# ŵééķš one two]}",
    SHORT: "one{[# ŵķ one]}other{[# ŵķš one two]}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{[# ýéåŕ one two]}other{[# ýéåŕš one two]}",
    SHORT: "one{[# ýŕ one]}other{[# ýŕš one two]}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_ZM =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_en_ZW =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_eo =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{# mon.}other{# mon.}",
    SHORT: "one{# mon.}other{# mon.}",
    NARROW: "one{# mon.}other{# mon.}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_eo_001 = exports.DurationSymbols_eo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_AR =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# seg.}other{# seg.}",
    NARROW: "one{#seg.}other{#seg.}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# año}other{# años}",
    NARROW: "one{#a.}other{#a.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_BO =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_BR =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_BZ =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_CL =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_CO =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# día}other{# días}",
    NARROW: "one{# día}other{# días}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# mes}other{# meses}",
    NARROW: "one{# mes}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{# sem.}other{# sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# a.}",
    NARROW: "one{# a.}other{# a.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_CR =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_CU =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_DO =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#d.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#m.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# seg.}other{# seg.}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_EA = DurationSymbols.DurationSymbols_es;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_EC =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_GQ = DurationSymbols.DurationSymbols_es;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_GT =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_HN =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_IC = DurationSymbols.DurationSymbols_es;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_NI =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_PA =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_PE =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_PH = DurationSymbols.DurationSymbols_es;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_PR =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_PY =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# día}other{# días}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# mes}other{# meses}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# seg.}other{# seg.}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# año}other{# años}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_SV =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_UY =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_es_VE =  {
  DAY: {
    LONG: "one{# día}other{# días}",
    SHORT: "one{# d.}other{# dd.}",
    NARROW: "one{#d.}other{#dd.}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mes}other{# meses}",
    SHORT: "one{# m.}other{# mm.}",
    NARROW: "one{#m.}other{#mm.}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sems.}",
    NARROW: "one{#sem.}other{#sems.}",
  },
  YEAR: {
    LONG: "one{# año}other{# años}",
    SHORT: "one{# a.}other{# aa.}",
    NARROW: "one{#a.}other{#aa.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_et_EE = DurationSymbols.DurationSymbols_et;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_eu_ES = DurationSymbols.DurationSymbols_eu;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ewo =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ewo_CM = exports.DurationSymbols_ewo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fa_AF = DurationSymbols.DurationSymbols_fa;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fa_IR = DurationSymbols.DurationSymbols_fa;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_BF =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_CM =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_GH =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_GM =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_GN =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_GW =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_LR =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_MR =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_NE =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_NG =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_SL =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Adlm_SN =  {
  DAY: {
    LONG: "one{# 𞤻𞤢𞤤𞥆𞤢𞤤}other{# 𞤻𞤢𞤤𞥆𞤫}",
    SHORT: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
    NARROW: "one{# 𞤻𞤢𞤤.}other{# 𞤻𞤢𞤤.}",
  },
  HOUR: {
    LONG: "one{# 𞤲𞤶𞤢𞤥𞤲𞤣𞤭}other{# 𞤲𞤶𞤢𞤥𞤤𞤭}",
    SHORT: "one{# 𞤶𞤢}other{# 𞤶𞤢}",
    NARROW: "one{#𞤶}other{#𞤶}",
  },
  MINUTE: {
    LONG: "one{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫}other{# 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫}",
    SHORT: "one{# 𞤸𞤮𞤶}other{# 𞤸𞤮𞤶}",
    NARROW: "one{#𞤸𞤮𞤶}other{#𞤸𞤮𞤶}",
  },
  MONTH: {
    LONG: "one{# 𞤤𞤫𞤱𞤪𞤵}other{# 𞤤𞤫𞤦𞥆𞤭}",
    SHORT: "one{#/𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
    NARROW: "one{# 𞤤𞤫𞤱}other{# 𞤤𞤫𞤦}",
  },
  SECOND: {
    LONG: "one{# 𞤳𞤭𞤲𞤰𞤮}other{# 𞤳𞤭𞤲𞤰𞤫}",
    SHORT: "one{# 𞤳𞤭𞤲}other{# 𞤳𞤭𞤲}",
    NARROW: "one{#𞤳𞤭𞤲}other{#𞤳𞤭𞤲}",
  },
  WEEK: {
    LONG: "one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{# 𞤶𞤮𞤲𞤼𞤫}",
    SHORT: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
    NARROW: "one{# 𞤴𞤼}other{# 𞤶𞤼}",
  },
  YEAR: {
    LONG: "one{# 𞤸𞤭𞤼𞤢𞥄𞤲𞥋𞤣𞤫}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫}",
    SHORT: "one{# 𞤸𞤭𞤼}other{# 𞤳𞤭𞤼}",
    NARROW: "one{# 𞤳𞤭𞤼}other{#/𞤳𞤭𞤼}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_BF = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_CM = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_GH = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_GM = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_GN = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_GW = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_LR = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_MR = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_NE = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_NG = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_SL = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ff_Latn_SN = exports.DurationSymbols_ff;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fi_FI = DurationSymbols.DurationSymbols_fi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fil_PH = DurationSymbols.DurationSymbols_fil;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fo =  {
  DAY: {
    LONG: "one{# dagur}other{# dagar}",
    SHORT: "one{# d.}other{# d.}",
    NARROW: "one{#d.}other{#d.}",
  },
  HOUR: {
    LONG: "one{# tími}other{# tímar}",
    SHORT: "one{# t.}other{# t.}",
    NARROW: "one{#t.}other{#t.}",
  },
  MINUTE: {
    LONG: "one{# minuttur}other{# minuttir}",
    SHORT: "one{# min.}other{# min.}",
    NARROW: "one{#m.}other{#m.}",
  },
  MONTH: {
    LONG: "one{# mánaður}other{# mánaðir}",
    SHORT: "one{# mnð.}other{# mnð.}",
    NARROW: "one{#m.}other{#m.}",
  },
  SECOND: {
    LONG: "one{# sekund}other{# sekundir}",
    SHORT: "one{# sek.}other{# sek.}",
    NARROW: "one{#s.}other{#s.}",
  },
  WEEK: {
    LONG: "one{# vika}other{# vikur}",
    SHORT: "one{# vi.}other{# vi.}",
    NARROW: "one{#v.}other{#v.}",
  },
  YEAR: {
    LONG: "one{# ár}other{# ár}",
    SHORT: "one{# ár}other{# ár}",
    NARROW: "one{#ár}other{#ár}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fo_DK = exports.DurationSymbols_fo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fo_FO = exports.DurationSymbols_fo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_BE = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_BF = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_BI = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_BJ = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_BL = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_CD = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_CF = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_CG = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_CH = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_CI = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_CM = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_DJ = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_DZ = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_FR = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_GA = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_GF = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_GN = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_GP = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_GQ = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_HT = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_KM = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_LU = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_MA = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_MC = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_MF = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_MG = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_ML = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_MQ = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_MR = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_MU = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_NC = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_NE = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_PF = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_PM = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_RE = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_RW = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_SC = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_SN = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_SY = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_TD = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_TG = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_TN = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_VU = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_WF = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fr_YT = DurationSymbols.DurationSymbols_fr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fur =  {
  DAY: {
    LONG: "one{# zornade}other{# zornadis}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "one{# ore}other{# oris}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "one{# minût}other{# minûts}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# mês}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "one{# secont}other{# seconts}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "one{# setemane}other{# setemanis}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "one{# an}other{# agns}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fur_IT = exports.DurationSymbols_fur;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fy =  {
  DAY: {
    LONG: "one{# dei}other{# deien}",
    SHORT: "one{# dei}other{# deien}",
    NARROW: "one{# d}other{# d}",
  },
  HOUR: {
    LONG: "one{# oere}other{# oere}",
    SHORT: "one{# oere}other{# oere}",
    NARROW: "one{# u}other{# u}",
  },
  MINUTE: {
    LONG: "one{# minút}other{# minuten}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# m}other{# m}",
  },
  MONTH: {
    LONG: "one{# moanne}other{# moanneen}",
    SHORT: "one{# mn}other{# mn}",
    NARROW: "one{# m}other{# m}",
  },
  SECOND: {
    LONG: "one{# sekonde}other{# sekonden}",
    SHORT: "one{# sek.}other{# sek.}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# wike}other{# wiken}",
    SHORT: "one{# wk}other{# wkn}",
    NARROW: "one{# w}other{# w}",
  },
  YEAR: {
    LONG: "one{# jier}other{# jier}",
    SHORT: "one{# jr}other{# jr}",
    NARROW: "one{# jr}other{# jr}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_fy_NL = exports.DurationSymbols_fy;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ga_GB = DurationSymbols.DurationSymbols_ga;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ga_IE = DurationSymbols.DurationSymbols_ga;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gd =  {
  DAY: {
    LONG: "one{# latha}two{# latha}few{# làithean}other{# latha}",
    SHORT: "one{# là}two{# là}few{# là}other{# là}",
    NARROW: "one{#là}two{#là}few{#là}other{#là}",
  },
  HOUR: {
    LONG: "one{# uair a thìde}two{# uair a thìde}few{# uairean a thìde}other{# uair a thìde}",
    SHORT: "one{# uair}two{# uair}few{# uair}other{# uair}",
    NARROW: "one{#u}two{#u}few{#u}other{#u}",
  },
  MINUTE: {
    LONG: "one{# mhionaid}two{# mhionaid}few{# mionaidean}other{# mionaid}",
    SHORT: "one{# mhion}two{# mhion}few{# mion}other{# mion}",
    NARROW: "one{#m}two{#m}few{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mhìos}two{# mhìos}few{# mìosan}other{# mìos}",
    SHORT: "one{# mhìos}two{# mhìos}few{# mìos}other{# mìos}",
    NARROW: "one{#m}two{#m}few{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# diog}two{# dhiog}few{# diogan}other{# diog}",
    SHORT: "one{# diog}two{# dhiog}few{# diog}other{# diog}",
    NARROW: "one{#d}two{#d}few{#d}other{#d}",
  },
  WEEK: {
    LONG: "one{# seachdain}two{# sheachdain}few{# seachdainean}other{# seachdain}",
    SHORT: "one{# shn}two{# shn}few{# sn}other{# sn}",
    NARROW: "one{#s}two{#s}few{#s}other{#s}",
  },
  YEAR: {
    LONG: "one{# bhliadhna}two{# bhliadhna}few{# bliadhnaichean}other{# bliadhna}",
    SHORT: "one{# bhlia}two{# bhlia}few{# blia}other{# blia}",
    NARROW: "one{#bl}two{#bl}few{#bl}other{#bl}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gd_GB = exports.DurationSymbols_gd;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gl_ES = DurationSymbols.DurationSymbols_gl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gsw_CH = DurationSymbols.DurationSymbols_gsw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gsw_FR = DurationSymbols.DurationSymbols_gsw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gsw_LI = DurationSymbols.DurationSymbols_gsw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gu_IN = DurationSymbols.DurationSymbols_gu;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_guz =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_guz_KE = exports.DurationSymbols_guz;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gv =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_gv_IM = exports.DurationSymbols_gv;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ha =  {
  DAY: {
    LONG: "one{rana #}other{ranaku #}",
    SHORT: "one{rana #}other{ranaku #}",
    NARROW: "one{r#}other{r#}",
  },
  HOUR: {
    LONG: "one{sa'a #}other{sa'o'i #}",
    SHORT: "one{s #}other{s #}",
    NARROW: "one{s#}other{s#}",
  },
  MINUTE: {
    LONG: "one{minti #}other{mintoci #}",
    SHORT: "one{mnt #}other{mnt #}",
    NARROW: "one{minti#}other{minti #}",
  },
  MONTH: {
    LONG: "one{wata #}other{watanni #}",
    SHORT: "one{wat #}other{wtnn #}",
    NARROW: "one{w#}other{w#}",
  },
  SECOND: {
    LONG: "one{daƙiƙa #}other{daƙiƙoƙi #}",
    SHORT: "one{d #}other{d #}",
    NARROW: "one{d #}other{d #}",
  },
  WEEK: {
    LONG: "one{mako #}other{makonni #}",
    SHORT: "one{mk #}other{mkn #}",
    NARROW: "one{m#}other{m#}",
  },
  YEAR: {
    LONG: "one{shekara #}other{shekaru #}",
    SHORT: "one{shkr #}other{shkru #}",
    NARROW: "one{shkr #}other{s#}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ha_GH = exports.DurationSymbols_ha;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ha_NE = exports.DurationSymbols_ha;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ha_NG = exports.DurationSymbols_ha;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_haw_US = DurationSymbols.DurationSymbols_haw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_he_IL = DurationSymbols.DurationSymbols_he;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hi_IN = DurationSymbols.DurationSymbols_hi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hi_Latn =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hi_Latn_IN =  {
  DAY: {
    LONG: "one{# day}other{# days}",
    SHORT: "one{# day}other{# days}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hour}other{# hours}",
    SHORT: "one{# hr}other{# hrs}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minute}other{# minutes}",
    SHORT: "one{# min}other{# mins}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# month}other{# months}",
    SHORT: "one{# mth}other{# mths}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# second}other{# seconds}",
    SHORT: "one{# sec}other{# secs}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# week}other{# weeks}",
    SHORT: "one{# wk}other{# wks}",
    NARROW: "one{#w}other{#w}",
  },
  YEAR: {
    LONG: "one{# year}other{# years}",
    SHORT: "one{# yr}other{# yrs}",
    NARROW: "one{#y}other{#y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hr_BA = DurationSymbols.DurationSymbols_hr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hr_HR = DurationSymbols.DurationSymbols_hr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hsb =  {
  DAY: {
    LONG: "one{# dźeń}two{# dnjej}few{# dny}other{# dnjow}",
    SHORT: "one{# dź.}two{# dn.}few{# dn.}other{# dn.}",
    NARROW: "one{# d}two{# d}few{# d}other{# d}",
  },
  HOUR: {
    LONG: "one{# hodźina}two{# hodźinje}few{# hodźiny}other{# hodźinow}",
    SHORT: "one{# hodź.}two{# hodź.}few{# hodź.}other{# hodź.}",
    NARROW: "one{# h}two{# h}few{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuta}two{# minuće}few{# minuty}other{# minutow}",
    SHORT: "one{# min.}two{# min.}few{# min.}other{# min.}",
    NARROW: "one{# min}two{# min}few{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# měsac}two{# měsacaj}few{# měsacy}other{# měsacow}",
    SHORT: "one{# měs.}two{# měs.}few{# měs.}other{# měs.}",
    NARROW: "one{# měs.}two{# měs.}few{# měs.}other{# měs.}",
  },
  SECOND: {
    LONG: "one{# sekunda}two{# sekundźe}few{# sekundy}other{# sekundow}",
    SHORT: "one{# sek.}two{# sek.}few{# sek.}other{# sek.}",
    NARROW: "one{# s}two{# s}few{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# tydźeń}two{# tydźenjej}few{# tydźenje}other{# tydźenjow}",
    SHORT: "one{# tydź.}two{# tydź.}few{# tydź.}other{# tydź.}",
    NARROW: "one{# t.}two{# t.}few{# t.}other{# t.}",
  },
  YEAR: {
    LONG: "one{# lěto}two{# lěće}few{# lěta}other{# lět}",
    SHORT: "one{# l.}two{# l.}few{# l.}other{# l.}",
    NARROW: "one{# l.}two{# l.}few{# l.}other{# l.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hsb_DE = exports.DurationSymbols_hsb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hu_HU = DurationSymbols.DurationSymbols_hu;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_hy_AM = DurationSymbols.DurationSymbols_hy;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ia =  {
  DAY: {
    LONG: "one{# die}other{# dies}",
    SHORT: "one{# die}other{# dies}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# hr}other{# hr}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuta}other{# minutas}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mense}other{# menses}",
    SHORT: "one{# mense}other{# menses}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# secunda}other{# secundas}",
    SHORT: "one{# sec}other{# sec}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# septimana}other{# septimanas}",
    SHORT: "one{# sept}other{# sept}",
    NARROW: "one{#sept}other{#sept}",
  },
  YEAR: {
    LONG: "one{# anno}other{# annos}",
    SHORT: "one{# an}other{# an}",
    NARROW: "one{#an}other{#an}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ia_001 = exports.DurationSymbols_ia;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_id_ID = DurationSymbols.DurationSymbols_id;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ig =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ig_NG = exports.DurationSymbols_ig;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ii =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ii_CN = exports.DurationSymbols_ii;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_is_IS = DurationSymbols.DurationSymbols_is;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_it_CH = DurationSymbols.DurationSymbols_it;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_it_IT = DurationSymbols.DurationSymbols_it;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_it_SM = DurationSymbols.DurationSymbols_it;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_it_VA = DurationSymbols.DurationSymbols_it;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ja_JP = DurationSymbols.DurationSymbols_ja;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_jgo =  {
  DAY: {
    LONG: "one{# lɛ́Ꞌ}other{# lɛ́Ꞌ}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "one{# háwa}other{# háwa}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "one{# minút}other{# minút}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{pɛsaŋ #}other{pɛsaŋ #}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "one{ŋguꞋ #}other{ŋguꞋ #}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_jgo_CM = exports.DurationSymbols_jgo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_jmc =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_jmc_TZ = exports.DurationSymbols_jmc;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_jv =  {
  DAY: {
    LONG: "other{# dina}",
    SHORT: "other{# dina}",
    NARROW: "other{#d}",
  },
  HOUR: {
    LONG: "other{# jam}",
    SHORT: "other{# jam}",
    NARROW: "other{#j}",
  },
  MINUTE: {
    LONG: "other{# menit}",
    SHORT: "other{# mnt}",
    NARROW: "other{# mnt}",
  },
  MONTH: {
    LONG: "other{# sasi}",
    SHORT: "other{# sasi}",
    NARROW: "other{# sasi}",
  },
  SECOND: {
    LONG: "other{# detik}",
    SHORT: "other{# dtk}",
    NARROW: "other{# dtk}",
  },
  WEEK: {
    LONG: "other{# peken}",
    SHORT: "other{# peken}",
    NARROW: "other{# peken}",
  },
  YEAR: {
    LONG: "other{# taun}",
    SHORT: "other{# taun}",
    NARROW: "other{# taun}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_jv_ID = exports.DurationSymbols_jv;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ka_GE = DurationSymbols.DurationSymbols_ka;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kab =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kab_DZ = exports.DurationSymbols_kab;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kam =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kam_KE = exports.DurationSymbols_kam;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kde =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kde_TZ = exports.DurationSymbols_kde;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kea =  {
  DAY: {
    LONG: "other{# dia}",
    SHORT: "other{# dia}",
    NARROW: "other{# dia}",
  },
  HOUR: {
    LONG: "other{# ora}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# minutu}",
    SHORT: "other{# min.}",
    NARROW: "other{# min.}",
  },
  MONTH: {
    LONG: "other{# mes}",
    SHORT: "other{# mes}",
    NARROW: "other{# mes}",
  },
  SECOND: {
    LONG: "other{# sigundu}",
    SHORT: "other{# sig.}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# simana}",
    SHORT: "other{# sim.}",
    NARROW: "other{# sim.}",
  },
  YEAR: {
    LONG: "other{# anu}",
    SHORT: "other{# anu}",
    NARROW: "other{# anu}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kea_CV = exports.DurationSymbols_kea;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kgp =  {
  DAY: {
    LONG: "one{kurã #}other{kurã #}",
    SHORT: "one{# kurã}other{# kurã ag}",
    NARROW: "one{# kurã}other{# kurã ag}",
  },
  HOUR: {
    LONG: "one{óra #}other{óra ag #}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "one{mĩnũtu #}other{mĩnũtu #}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{kysã #}other{kysã ag #}",
    SHORT: "one{# kysã}other{# kysã ag}",
    NARROW: "one{# kysã}other{# kysã ag}",
  },
  SECOND: {
    LONG: "one{sigũnu #}other{sigũnu #}",
    SHORT: "one{# sig}other{# sig}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# simỹnỹ}other{# simỹnỹ ag}",
    SHORT: "one{# sim.}other{# sim.}",
    NARROW: "one{# sim.}other{# sim. Ag}",
  },
  YEAR: {
    LONG: "one{# prỹg}other{# prỹg ag}",
    SHORT: "one{# prỹg}other{# prỹg ag}",
    NARROW: "one{# prỹg}other{# prỹg ag}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kgp_BR = exports.DurationSymbols_kgp;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_khq =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_khq_ML = exports.DurationSymbols_khq;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ki =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ki_KE = exports.DurationSymbols_ki;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kk_KZ = DurationSymbols.DurationSymbols_kk;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kkj =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kkj_CM = exports.DurationSymbols_kkj;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kl =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kl_GL = exports.DurationSymbols_kl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kln =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kln_KE = exports.DurationSymbols_kln;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_km_KH = DurationSymbols.DurationSymbols_km;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kn_IN = DurationSymbols.DurationSymbols_kn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ko_KP = DurationSymbols.DurationSymbols_ko;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ko_KR = DurationSymbols.DurationSymbols_ko;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kok =  {
  DAY: {
    LONG: "other{# दीस}",
    SHORT: "other{# दीस}",
    NARROW: "other{#दी}",
  },
  HOUR: {
    LONG: "other{# वरां}",
    SHORT: "other{# वर}",
    NARROW: "other{#व}",
  },
  MINUTE: {
    LONG: "other{# मिण्टां}",
    SHORT: "other{# मिनीट}",
    NARROW: "other{# मि}",
  },
  MONTH: {
    LONG: "other{# म्हयने}",
    SHORT: "other{# म्हयने}",
    NARROW: "other{#म्ह}",
  },
  SECOND: {
    LONG: "other{# सेकंदांनी}",
    SHORT: "other{# सेकंद}",
    NARROW: "other{#से}",
  },
  WEEK: {
    LONG: "other{# सप्तक}",
    SHORT: "other{# सप्तक}",
    NARROW: "other{#स}",
  },
  YEAR: {
    LONG: "other{# वर्सां}",
    SHORT: "other{# वर्सां}",
    NARROW: "other{#व}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kok_IN = exports.DurationSymbols_kok;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ks =  {
  DAY: {
    LONG: "one{# دۄہ}other{# دۄہ}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "one{# گَنٹہٕ}other{# گٲنٹہٕ}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "one{# مِنَٹ}other{# مِنَٹ}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{# ریتھ}other{# ریتھ}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "one{# سیکَنڈ}other{# سیکَنڈ}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "one{# ہَفتہٕ}other{# ہَفتہٕ}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "one{# ؤری}other{# ؤری}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ks_Arab = exports.DurationSymbols_ks;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ks_Arab_IN = exports.DurationSymbols_ks;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ks_Deva =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ks_Deva_IN =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ksb =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ksb_TZ = exports.DurationSymbols_ksb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ksf =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ksf_CM = exports.DurationSymbols_ksf;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ksh =  {
  DAY: {
    LONG: "zero{# Dääsch}one{# Dääsch}other{# Dääsch}",
    SHORT: "zero{# d}one{# d}other{# d}",
    NARROW: "zero{#d}one{#d}other{#d}",
  },
  HOUR: {
    LONG: "zero{# Schtunde}one{# Schtunde}other{# Schtunde}",
    SHORT: "zero{# h}one{# h}other{# h}",
    NARROW: "zero{#h}one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "zero{# Menutte}one{# Menutte}other{# Menutte}",
    SHORT: "zero{# min}one{# min}other{# min}",
    NARROW: "zero{#m}one{#m}other{#m}",
  },
  MONTH: {
    LONG: "zero{# Mohnde}one{# Mohnde}other{# Mohnde}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "zero{# Sekunde}one{# Sekunde}other{# Sekunde}",
    SHORT: "zero{# s}one{# s}other{# s}",
    NARROW: "zero{#s}one{#s}other{#s}",
  },
  WEEK: {
    LONG: "zero{# Woche}one{# Woche}other{# Woche}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "zero{# Johre}one{# Johre}other{# Johre}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ksh_DE = exports.DurationSymbols_ksh;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ku =  {
  DAY: {
    LONG: "one{# roj}other{# roj}",
    SHORT: "one{# roj}other{# roj}",
    NARROW: "one{#r}other{#r}",
  },
  HOUR: {
    LONG: "one{# saet}other{# saet}",
    SHORT: "one{# st}other{# st}",
    NARROW: "one{#st}other{#st}",
  },
  MINUTE: {
    LONG: "one{# deqîqe}other{# deqîqe}",
    SHORT: "one{# d}other{# d}",
    NARROW: "one{#d}other{#d}",
  },
  MONTH: {
    LONG: "one{# meh}other{# meh}",
    SHORT: "one{# m}other{# m}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# saniye}other{# saniye}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# hefte}other{# hefte}",
    SHORT: "one{# hf}other{# hf}",
    NARROW: "one{#hf}other{#hf}",
  },
  YEAR: {
    LONG: "one{# sal}other{# sal}",
    SHORT: "one{# sal}other{# sal}",
    NARROW: "one{#sl}other{#sl}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ku_TR = exports.DurationSymbols_ku;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kw =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_kw_GB = exports.DurationSymbols_kw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ky_KG = DurationSymbols.DurationSymbols_ky;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lag =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lag_TZ = exports.DurationSymbols_lag;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lb =  {
  DAY: {
    LONG: "one{# Dag}other{# Deeg}",
    SHORT: "one{# D}other{# D}",
    NARROW: "one{# D}other{# D}",
  },
  HOUR: {
    LONG: "one{# Stonn}other{# Stonnen}",
    SHORT: "one{# St.}other{# St.}",
    NARROW: "one{# st}other{# st}",
  },
  MINUTE: {
    LONG: "one{# Minutt}other{# Minutten}",
    SHORT: "one{# Min.}other{# Min.}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# Mount}other{# Méint}",
    SHORT: "one{# Mnt}other{# Mnt}",
    NARROW: "one{# M}other{# M}",
  },
  SECOND: {
    LONG: "one{# Sekonn}other{# Sekonnen}",
    SHORT: "one{# Sek.}other{# Sek.}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# Woch}other{# Wochen}",
    SHORT: "one{# W}other{# W}",
    NARROW: "one{# W}other{# W}",
  },
  YEAR: {
    LONG: "one{# Joer}other{# Joer}",
    SHORT: "one{# J}other{# J}",
    NARROW: "one{# J}other{# J}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lb_LU = exports.DurationSymbols_lb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lg =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lg_UG = exports.DurationSymbols_lg;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lkt =  {
  DAY: {
    LONG: "other{#-čháŋ}",
    SHORT: "other{#-čháŋ}",
    NARROW: "other{#-čháŋ}",
  },
  HOUR: {
    LONG: "other{Owápȟe #}",
    SHORT: "other{Owápȟe #}",
    NARROW: "other{Owápȟe #}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{Wíyawapi #}",
    SHORT: "other{Wíyawapi #}",
    NARROW: "other{Wí #}",
  },
  SECOND: {
    LONG: "other{Okpí #}",
    SHORT: "other{Okpí #}",
    NARROW: "other{Okpí #}",
  },
  WEEK: {
    LONG: "other{okó #}",
    SHORT: "other{okó #}",
    NARROW: "other{okó #}",
  },
  YEAR: {
    LONG: "other{ómakȟa #}",
    SHORT: "other{ómakȟa #}",
    NARROW: "other{ómakȟa #}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lkt_US = exports.DurationSymbols_lkt;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ln_AO = DurationSymbols.DurationSymbols_ln;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ln_CD = DurationSymbols.DurationSymbols_ln;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ln_CF = DurationSymbols.DurationSymbols_ln;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ln_CG = DurationSymbols.DurationSymbols_ln;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lo_LA = DurationSymbols.DurationSymbols_lo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lrc =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lrc_IQ = exports.DurationSymbols_lrc;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lrc_IR = exports.DurationSymbols_lrc;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lt_LT = DurationSymbols.DurationSymbols_lt;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lu =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lu_CD = exports.DurationSymbols_lu;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_luo =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_luo_KE = exports.DurationSymbols_luo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_luy =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_luy_KE = exports.DurationSymbols_luy;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_lv_LV = DurationSymbols.DurationSymbols_lv;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mai =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mai_IN = exports.DurationSymbols_mai;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mas =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mas_KE = exports.DurationSymbols_mas;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mas_TZ = exports.DurationSymbols_mas;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mer =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mer_KE = exports.DurationSymbols_mer;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mfe =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mfe_MU = exports.DurationSymbols_mfe;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mg =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mg_MG = exports.DurationSymbols_mg;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mgh =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mgh_MZ = exports.DurationSymbols_mgh;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mgo =  {
  DAY: {
    LONG: "one{# d}other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "one{# h}other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "one{# min}other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{# m}other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "one{# s}other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mgo_CM = exports.DurationSymbols_mgo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mi =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mi_NZ = exports.DurationSymbols_mi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mk_MK = DurationSymbols.DurationSymbols_mk;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ml_IN = DurationSymbols.DurationSymbols_ml;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mn_MN = DurationSymbols.DurationSymbols_mn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mni =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mni_Beng = exports.DurationSymbols_mni;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mni_Beng_IN = exports.DurationSymbols_mni;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mr_IN = DurationSymbols.DurationSymbols_mr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ms_BN = DurationSymbols.DurationSymbols_ms;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ms_ID = DurationSymbols.DurationSymbols_ms;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ms_MY = DurationSymbols.DurationSymbols_ms;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ms_SG = DurationSymbols.DurationSymbols_ms;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mt_MT = DurationSymbols.DurationSymbols_mt;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mua =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mua_CM = exports.DurationSymbols_mua;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_my_MM = DurationSymbols.DurationSymbols_my;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mzn =  {
  DAY: {
    LONG: "other{# روز}",
    SHORT: "other{# روز}",
    NARROW: "other{# روز}",
  },
  HOUR: {
    LONG: "other{# ساعِت}",
    SHORT: "other{# h}",
    NARROW: "other{# ساعِت}",
  },
  MINUTE: {
    LONG: "other{# دقیقه}",
    SHORT: "other{# دَقه}",
    NARROW: "other{# دَقه}",
  },
  MONTH: {
    LONG: "other{# ماه}",
    SHORT: "other{# ماه}",
    NARROW: "other{# ماه}",
  },
  SECOND: {
    LONG: "other{# ثانیه}",
    SHORT: "other{# ثانیه}",
    NARROW: "other{# ثانیه}",
  },
  WEEK: {
    LONG: "other{# هفته}",
    SHORT: "other{# هفته}",
    NARROW: "other{# هفته}",
  },
  YEAR: {
    LONG: "other{# سال}",
    SHORT: "other{# سال}",
    NARROW: "other{# سال}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_mzn_IR = exports.DurationSymbols_mzn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_naq =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_naq_NA = exports.DurationSymbols_naq;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nb_NO = DurationSymbols.DurationSymbols_nb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nb_SJ = DurationSymbols.DurationSymbols_nb;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nd =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nd_ZW = exports.DurationSymbols_nd;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ne_IN = DurationSymbols.DurationSymbols_ne;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ne_NP = DurationSymbols.DurationSymbols_ne;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nl_AW = DurationSymbols.DurationSymbols_nl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nl_BE = DurationSymbols.DurationSymbols_nl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nl_BQ = DurationSymbols.DurationSymbols_nl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nl_CW = DurationSymbols.DurationSymbols_nl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nl_NL = DurationSymbols.DurationSymbols_nl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nl_SR = DurationSymbols.DurationSymbols_nl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nl_SX = DurationSymbols.DurationSymbols_nl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nmg =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nmg_CM = exports.DurationSymbols_nmg;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nn =  {
  DAY: {
    LONG: "one{# døgn}other{# døgn}",
    SHORT: "one{# d}other{# d}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# time}other{# timar}",
    SHORT: "one{# t}other{# t}",
    NARROW: "one{#t}other{#t}",
  },
  MINUTE: {
    LONG: "one{# minutt}other{# minutt}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# månad}other{# månadar}",
    SHORT: "one{# md.}other{# md.}",
    NARROW: "one{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# sekund}other{# sekund}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# veke}other{# veker}",
    SHORT: "one{# v}other{# v}",
    NARROW: "one{#v}other{#v}",
  },
  YEAR: {
    LONG: "one{# år}other{# år}",
    SHORT: "one{# år}other{# år}",
    NARROW: "one{#å}other{#å}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nn_NO = exports.DurationSymbols_nn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nnh =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nnh_CM = exports.DurationSymbols_nnh;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nus =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nus_SS = exports.DurationSymbols_nus;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nyn =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_nyn_UG = exports.DurationSymbols_nyn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_om =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_om_ET = exports.DurationSymbols_om;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_om_KE = exports.DurationSymbols_om;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_or_IN = DurationSymbols.DurationSymbols_or;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_os =  {
  DAY: {
    LONG: "one{# бон}other{# боны}",
    SHORT: "one{# бон}other{# боны}",
    NARROW: "one{# бон}other{# боны}",
  },
  HOUR: {
    LONG: "one{# сахат}other{# сахаты}",
    SHORT: "one{# с.}other{# с.}",
    NARROW: "one{# с.}other{# с.}",
  },
  MINUTE: {
    LONG: "one{# минут}other{# минуты}",
    SHORT: "one{# мин.}other{# мин.}",
    NARROW: "one{# мин.}other{# мин.}",
  },
  MONTH: {
    LONG: "one{# мӕй}other{# мӕйы}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "one{# секунд}other{# секунды}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "one{# къуыри}other{# къуырийы}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "one{# аз}other{# азы}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_os_GE = exports.DurationSymbols_os;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_os_RU = exports.DurationSymbols_os;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pa_Arab =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pa_Arab_PK =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pa_Guru = DurationSymbols.DurationSymbols_pa;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pa_Guru_IN = DurationSymbols.DurationSymbols_pa;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pcm =  {
  DAY: {
    LONG: "one{# Dè}other{# Dè}",
    SHORT: "one{# dè}other{# dez}",
    NARROW: "one{#Dè}other{#Dè}",
  },
  HOUR: {
    LONG: "one{# Áwa}other{# Áwa}",
    SHORT: "one{# Áwa}other{# Áwa}",
    NARROW: "one{#Áwa}other{#Áwa}",
  },
  MINUTE: {
    LONG: "one{# Mínit}other{# Mínit}",
    SHORT: "one{# Mínit}other{# Mínit}",
    NARROW: "one{#Mínit}other{#Mínit}",
  },
  MONTH: {
    LONG: "one{# Mọnt}other{# Mọnt}",
    SHORT: "one{# Mọnt}other{# Mọnt}",
    NARROW: "one{#Mọnt}other{#Mọnt}",
  },
  SECOND: {
    LONG: "one{# Sẹ́kọn}other{# Sẹ́kọn}",
    SHORT: "one{# Sẹ́kọn}other{# Sẹ́kọn}",
    NARROW: "one{#Sẹ́kọn}other{#Sẹ́kọn}",
  },
  WEEK: {
    LONG: "one{# Wik}other{# Wik}",
    SHORT: "one{# Wik}other{Wik #}",
    NARROW: "one{#Wik}other{#Wik}",
  },
  YEAR: {
    LONG: "one{# Yiẹ}other{# Yiẹ}",
    SHORT: "one{# Yiẹ}other{# Yiẹ}",
    NARROW: "one{#Yiẹ}other{#Yiẹ}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pcm_NG = exports.DurationSymbols_pcm;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pl_PL = DurationSymbols.DurationSymbols_pl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ps =  {
  DAY: {
    LONG: "one{# ورځ}other{# ورځې}",
    SHORT: "one{# ورځ}other{# ورځې}",
    NARROW: "one{# ورځ}other{#d}",
  },
  HOUR: {
    LONG: "one{# h}other{# h}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# min}other{# min}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{#m}",
  },
  MONTH: {
    LONG: "one{# مياشت}other{# مياشتې}",
    SHORT: "one{# m}other{# mths}",
    NARROW: "one{# m}other{# m}",
  },
  SECOND: {
    LONG: "one{# s}other{# s}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{اونۍ}other{# اونۍ}",
    SHORT: "one{# w}other{# wks}",
    NARROW: "one{# w}other{# w}",
  },
  YEAR: {
    LONG: "one{# کال}other{# کالونه}",
    SHORT: "one{# y}other{# y}",
    NARROW: "one{# y}other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ps_AF = exports.DurationSymbols_ps;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ps_PK =  {
  DAY: {
    LONG: "one{# ورځ}other{# ورځے}",
    SHORT: "one{# ورځ}other{# ورځے}",
    NARROW: "one{# ورځ}other{#d}",
  },
  HOUR: {
    LONG: "one{# h}other{# h}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# min}other{# min}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{#m}",
  },
  MONTH: {
    LONG: "one{# مياشت}other{# مياشتے}",
    SHORT: "one{# m}other{# mths}",
    NARROW: "one{# m}other{# m}",
  },
  SECOND: {
    LONG: "one{# s}other{# s}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{اونۍ}other{# اونۍ}",
    SHORT: "one{# w}other{# wks}",
    NARROW: "one{# w}other{# w}",
  },
  YEAR: {
    LONG: "one{# کال}other{# کالونه}",
    SHORT: "one{# y}other{# y}",
    NARROW: "one{# y}other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_AO =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_CH =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_CV =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_GQ =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_GW =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_LU =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_MO =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_MZ =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_ST =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_pt_TL =  {
  DAY: {
    LONG: "one{# dia}other{# dias}",
    SHORT: "one{# dia}other{# dias}",
    NARROW: "one{# dia}other{# dias}",
  },
  HOUR: {
    LONG: "one{# hora}other{# horas}",
    SHORT: "one{# h}other{# h}",
    NARROW: "one{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minuto}other{# minutos}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{# min}other{# min}",
  },
  MONTH: {
    LONG: "one{# mês}other{# meses}",
    SHORT: "one{# mês}other{# meses}",
    NARROW: "one{# mês}other{# meses}",
  },
  SECOND: {
    LONG: "one{# segundo}other{# segundos}",
    SHORT: "one{# s}other{# s}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# semana}other{# semanas}",
    SHORT: "one{# sem.}other{# sem.}",
    NARROW: "one{# sem.}other{# sem.}",
  },
  YEAR: {
    LONG: "one{# ano}other{# anos}",
    SHORT: "one{# ano}other{# anos}",
    NARROW: "one{# ano}other{# anos}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_qu =  {
  DAY: {
    LONG: "other{# punchaw}",
    SHORT: "other{# d}",
    NARROW: "other{# p}",
  },
  HOUR: {
    LONG: "other{# hora}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# minuto}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# killa}",
    SHORT: "other{# m}",
    NARROW: "other{# k}",
  },
  SECOND: {
    LONG: "other{# segundo}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# semana}",
    SHORT: "other{# w}",
    NARROW: "other{# s}",
  },
  YEAR: {
    LONG: "other{# wata}",
    SHORT: "other{# y}",
    NARROW: "other{# w}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_qu_BO = exports.DurationSymbols_qu;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_qu_EC = exports.DurationSymbols_qu;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_qu_PE = exports.DurationSymbols_qu;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rm =  {
  DAY: {
    LONG: "one{# di}other{# dis}",
    SHORT: "one{# di}other{# dis}",
    NARROW: "one{# dis}other{# dis}",
  },
  HOUR: {
    LONG: "one{# ura}other{# uras}",
    SHORT: "one{# ura}other{# uras}",
    NARROW: "one{# uras}other{# uras}",
  },
  MINUTE: {
    LONG: "one{# minuta}other{# minutas}",
    SHORT: "one{# min.}other{# mins.}",
    NARROW: "one{# mins.}other{# mins.}",
  },
  MONTH: {
    LONG: "one{# mais}other{# mais}",
    SHORT: "one{# mais}other{# mais}",
    NARROW: "one{# mais}other{# mais}",
  },
  SECOND: {
    LONG: "one{# secunda}other{# secundas}",
    SHORT: "one{# sec.}other{# secs.}",
    NARROW: "one{# secs.}other{# secs.}",
  },
  WEEK: {
    LONG: "one{# emna}other{# emnas}",
    SHORT: "one{# emna}other{# emnas}",
    NARROW: "one{# emnas}other{# emnas}",
  },
  YEAR: {
    LONG: "one{# onn}other{# onns}",
    SHORT: "one{# onn}other{# onns}",
    NARROW: "one{# onns}other{# onns}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rm_CH = exports.DurationSymbols_rm;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rn =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rn_BI = exports.DurationSymbols_rn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ro_MD =  {
  DAY: {
    LONG: "one{# zi}few{# zile}other{# de zile}",
    SHORT: "one{# zi}few{# zile}other{# zile}",
    NARROW: "one{# zi}few{# zile}other{# zile}",
  },
  HOUR: {
    LONG: "one{# oră}few{# ore}other{# de ore}",
    SHORT: "one{# oră}few{# ore}other{# ore}",
    NARROW: "one{# h}few{# h}other{# h}",
  },
  MINUTE: {
    LONG: "one{# minut}few{# minute}other{# de minute}",
    SHORT: "one{# min.}few{# min.}other{# min.}",
    NARROW: "one{# min.}few{# min.}other{# min.}",
  },
  MONTH: {
    LONG: "one{# lună}few{# luni}other{# de luni}",
    SHORT: "one{# lună}few{# luni}other{# luni}",
    NARROW: "one{# lună}few{# luni}other{# luni}",
  },
  SECOND: {
    LONG: "one{# secundă}few{# secunde}other{# de secunde}",
    SHORT: "one{# s}few{# s}other{# s}",
    NARROW: "one{# s}few{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# săptămână}few{# săptămâni}other{# de săptămâni}",
    SHORT: "one{# săpt.}few{# săpt.}other{# săpt.}",
    NARROW: "one{# săpt.}few{# săpt.}other{# săpt.}",
  },
  YEAR: {
    LONG: "one{# an}few{# ani}other{# de ani}",
    SHORT: "one{# an}few{# ani}other{# ani}",
    NARROW: "one{# an}few{# ani}other{# ani}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ro_RO = DurationSymbols.DurationSymbols_ro;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rof =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rof_TZ = exports.DurationSymbols_rof;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ru_BY = DurationSymbols.DurationSymbols_ru;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ru_KG = DurationSymbols.DurationSymbols_ru;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ru_KZ = DurationSymbols.DurationSymbols_ru;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ru_MD = DurationSymbols.DurationSymbols_ru;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ru_RU = DurationSymbols.DurationSymbols_ru;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ru_UA = DurationSymbols.DurationSymbols_ru;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rw =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rw_RW = exports.DurationSymbols_rw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rwk =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_rwk_TZ = exports.DurationSymbols_rwk;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sa =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sa_IN = exports.DurationSymbols_sa;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sah =  {
  DAY: {
    LONG: "other{# күн}",
    SHORT: "other{# күн}",
    NARROW: "other{# к.}",
  },
  HOUR: {
    LONG: "other{# чаас}",
    SHORT: "other{# ч}",
    NARROW: "other{# ч}",
  },
  MINUTE: {
    LONG: "other{# мүнүүтэ}",
    SHORT: "other{# мүн}",
    NARROW: "other{# мүн}",
  },
  MONTH: {
    LONG: "other{# ый}",
    SHORT: "other{# ый}",
    NARROW: "other{# ый}",
  },
  SECOND: {
    LONG: "other{# сөкүүндэ}",
    SHORT: "other{# сөк}",
    NARROW: "other{# с}",
  },
  WEEK: {
    LONG: "other{# нэдиэлэ}",
    SHORT: "other{# нэд.}",
    NARROW: "other{# н.}",
  },
  YEAR: {
    LONG: "other{# сыл}",
    SHORT: "other{# с.}",
    NARROW: "other{# с.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sah_RU = exports.DurationSymbols_sah;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_saq =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_saq_KE = exports.DurationSymbols_saq;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sat =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sat_Olck = exports.DurationSymbols_sat;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sat_Olck_IN = exports.DurationSymbols_sat;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sbp =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sbp_TZ = exports.DurationSymbols_sbp;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sc =  {
  DAY: {
    LONG: "one{# die}other{# dies}",
    SHORT: "one{# die}other{# dies}",
    NARROW: "one{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# ora}other{# oras}",
    SHORT: "one{# ora}other{# oras}",
    NARROW: "one{#o}other{#o}",
  },
  MINUTE: {
    LONG: "one{# minutu}other{# minutos}",
    SHORT: "other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mese}other{# meses}",
    SHORT: "one{# mese}other{# meses}",
    NARROW: "one{#me.}other{#me.}",
  },
  SECOND: {
    LONG: "one{# segundu}other{# segundos}",
    SHORT: "one{# seg}other{# seg}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# chida}other{# chidas}",
    SHORT: "one{# chida}other{# chida}",
    NARROW: "one{#ch.}other{#ch.}",
  },
  YEAR: {
    LONG: "one{# annu}other{# annos}",
    SHORT: "one{# annu}other{# annos}",
    NARROW: "one{#an.}other{#an.}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sc_IT = exports.DurationSymbols_sc;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sd =  {
  DAY: {
    LONG: "one{# ڏينهن}other{# ڏينهن}",
    SHORT: "one{# ڏينهن}other{# ڏينهن}",
    NARROW: "one{# ڏينهن}other{# ڏينهن}",
  },
  HOUR: {
    LONG: "one{# ڪلاڪ}other{# ڪلاڪ}",
    SHORT: "one{# ڪلاڪ}other{# ڪلاڪ}",
    NARROW: "one{# ڪلاڪ}other{# ڪلاڪ}",
  },
  MINUTE: {
    LONG: "one{# منٽ}other{# منٽ}",
    SHORT: "one{# منٽ}other{# منٽ}",
    NARROW: "one{# منٽ}other{# منٽ}",
  },
  MONTH: {
    LONG: "one{# مهينا}other{# مهينا}",
    SHORT: "one{# مهينا}other{# مهينا}",
    NARROW: "one{# مهينا}other{# مهينا}",
  },
  SECOND: {
    LONG: "one{# في سيڪنڊ}other{# سيڪنڊ}",
    SHORT: "one{# سيڪنڊ}other{# سيڪنڊ}",
    NARROW: "one{# s}other{# سيڪنڊ}",
  },
  WEEK: {
    LONG: "one{# هفتا}other{# هفتا}",
    SHORT: "one{# هفتا}other{# هفتا}",
    NARROW: "one{# هفتا}other{# هفتي}",
  },
  YEAR: {
    LONG: "one{# سال}other{# سال}",
    SHORT: "one{# سال}other{# سال}",
    NARROW: "one{# سال}other{# سال}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sd_Arab = exports.DurationSymbols_sd;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sd_Arab_PK = exports.DurationSymbols_sd;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sd_Deva =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sd_Deva_IN =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_se =  {
  DAY: {
    LONG: "one{# jándor}two{# jándora}other{# jándora}",
    SHORT: "one{# d}two{# d}other{# d}",
    NARROW: "one{#d}two{#d}other{#d}",
  },
  HOUR: {
    LONG: "one{# diibmu}two{# diimmur}other{# diibmur}",
    SHORT: "one{# h}two{# h}other{# h}",
    NARROW: "one{#h}two{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# minuhta}two{# minuhtta}other{# minuhtta}",
    SHORT: "one{# min}two{# min}other{# min}",
    NARROW: "one{#m}two{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# mánotbadji}two{# mánotbaji}other{# mánotbadji}",
    SHORT: "one{# mán}two{# mán}other{# mán}",
    NARROW: "one{#m}two{#m}other{#m}",
  },
  SECOND: {
    LONG: "one{# sekunda}two{# sekundda}other{# sekundda}",
    SHORT: "one{# s}two{# s}other{# s}",
    NARROW: "one{#s}two{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# váhku}two{# váhkku}other{# váhkku}",
    SHORT: "one{# v}two{# v}other{# v}",
    NARROW: "one{#v}two{#v}other{#v}",
  },
  YEAR: {
    LONG: "one{# jahki}two{# jahkki}other{# jahkki}",
    SHORT: "one{# jah}two{# jah}other{# jah}",
    NARROW: "one{#j}two{#j}other{#j}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_se_FI = exports.DurationSymbols_se;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_se_NO = exports.DurationSymbols_se;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_se_SE = exports.DurationSymbols_se;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_seh =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_seh_MZ = exports.DurationSymbols_seh;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ses =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ses_ML = exports.DurationSymbols_ses;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sg =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sg_CF = exports.DurationSymbols_sg;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_shi =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_shi_Latn = exports.DurationSymbols_shi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_shi_Latn_MA = exports.DurationSymbols_shi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_shi_Tfng = exports.DurationSymbols_shi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_shi_Tfng_MA = exports.DurationSymbols_shi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_si_LK = DurationSymbols.DurationSymbols_si;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sk_SK = DurationSymbols.DurationSymbols_sk;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sl_SI = DurationSymbols.DurationSymbols_sl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_smn =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_smn_FI = exports.DurationSymbols_smn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sn =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sn_ZW = exports.DurationSymbols_sn;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_so =  {
  DAY: {
    LONG: "one{# maalin}other{# maalmood}",
    SHORT: "one{# mln}other{# mln}",
    NARROW: "one{#m}other{#m}",
  },
  HOUR: {
    LONG: "one{# saacad}other{# saacadood}",
    SHORT: "one{# scd}other{# scd}",
    NARROW: "one{# scd}other{# s}",
  },
  MINUTE: {
    LONG: "one{# daqiiqad}other{# daqiiqo}",
    SHORT: "one{# dqqd}other{# daqiiqo}",
    NARROW: "one{#d}other{#d}",
  },
  MONTH: {
    LONG: "one{# bil}other{# bilood}",
    SHORT: "one{# bil}other{# bil}",
    NARROW: "one{#b}other{#b}",
  },
  SECOND: {
    LONG: "one{# ilbiriqsi}other{# ilbiriqsi}",
    SHORT: "one{# ilbrqsi}other{# ilbrqsi}",
    NARROW: "one{#il}other{#il}",
  },
  WEEK: {
    LONG: "one{# toddobaad}other{# toddobaadyo}",
    SHORT: "one{# tdbd}other{# tdbd}",
    NARROW: "one{#t}other{#t}",
  },
  YEAR: {
    LONG: "one{# Sannad}other{# Sannado}",
    SHORT: "one{snd}other{# snd}",
    NARROW: "one{#s}other{#s}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_so_DJ = exports.DurationSymbols_so;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_so_ET = exports.DurationSymbols_so;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_so_KE = exports.DurationSymbols_so;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_so_SO = exports.DurationSymbols_so;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sq_AL = DurationSymbols.DurationSymbols_sq;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sq_MK = DurationSymbols.DurationSymbols_sq;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sq_XK = DurationSymbols.DurationSymbols_sq;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Cyrl = DurationSymbols.DurationSymbols_sr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Cyrl_BA =  {
  DAY: {
    LONG: "one{# дан}few{# дана}other{# дана}",
    SHORT: "one{# дан}few{# дана}other{# дана}",
    NARROW: "one{# д}few{# д}other{# д}",
  },
  HOUR: {
    LONG: "one{# сат}few{# сата}other{# сати}",
    SHORT: "one{# сат}few{# сата}other{# сати}",
    NARROW: "one{# ч}few{# ч}other{# ч}",
  },
  MINUTE: {
    LONG: "one{# минут}few{# минута}other{# минута}",
    SHORT: "one{# мин}few{# мин}other{# мин}",
    NARROW: "one{# м}few{# м}other{# м}",
  },
  MONTH: {
    LONG: "one{# мјесец}few{# мјесеца}other{# мјесеци}",
    SHORT: "one{# мјес.}few{# мјес.}other{# мјес.}",
    NARROW: "one{# м}few{# м}other{# м}",
  },
  SECOND: {
    LONG: "one{# секунда}few{# секунде}other{# секунди}",
    SHORT: "one{# сек}few{# сек}other{# сек}",
    NARROW: "one{# с}few{# с}other{# с}",
  },
  WEEK: {
    LONG: "one{# недјеља}few{# недјеље}other{# недјеља}",
    SHORT: "one{# нед.}few{# нед.}other{# нед.}",
    NARROW: "one{# н}few{# н}other{# н}",
  },
  YEAR: {
    LONG: "one{# година}few{# године}other{# година}",
    SHORT: "one{# год}few{# год.}other{# год.}",
    NARROW: "one{# г}few{# г}other{# г}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Cyrl_ME = DurationSymbols.DurationSymbols_sr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Cyrl_RS = DurationSymbols.DurationSymbols_sr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Cyrl_XK = DurationSymbols.DurationSymbols_sr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Latn_BA =  {
  DAY: {
    LONG: "one{# dan}few{# dana}other{# dana}",
    SHORT: "one{# dan}few{# dana}other{# dana}",
    NARROW: "one{# d}few{# d}other{# d}",
  },
  HOUR: {
    LONG: "one{# sat}few{# sata}other{# sati}",
    SHORT: "one{# sat}few{# sata}other{# sati}",
    NARROW: "one{# č}few{# č}other{# č}",
  },
  MINUTE: {
    LONG: "one{# minut}few{# minuta}other{# minuta}",
    SHORT: "one{# min}few{# min}other{# min}",
    NARROW: "one{# m}few{# m}other{# m}",
  },
  MONTH: {
    LONG: "one{# mjesec}few{# mjeseca}other{# mjeseci}",
    SHORT: "one{# mjes.}few{# mjes.}other{# mjes.}",
    NARROW: "one{# m}few{# m}other{# m}",
  },
  SECOND: {
    LONG: "one{# sekunda}few{# sekunde}other{# sekundi}",
    SHORT: "one{# sek}few{# sek}other{# sek}",
    NARROW: "one{# s}few{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# nedjelja}few{# nedjelje}other{# nedjelja}",
    SHORT: "one{# ned.}few{# ned.}other{# ned.}",
    NARROW: "one{# n}few{# n}other{# n}",
  },
  YEAR: {
    LONG: "one{# godina}few{# godine}other{# godina}",
    SHORT: "one{# god}few{# god.}other{# god.}",
    NARROW: "one{# g}few{# g}other{# g}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Latn_ME =  {
  DAY: {
    LONG: "one{# dan}few{# dana}other{# dana}",
    SHORT: "one{# dan}few{# dana}other{# dana}",
    NARROW: "one{# d}few{# d}other{# d}",
  },
  HOUR: {
    LONG: "one{# sat}few{# sata}other{# sati}",
    SHORT: "one{# sat}few{# sata}other{# sati}",
    NARROW: "one{# č}few{# č}other{# č}",
  },
  MINUTE: {
    LONG: "one{# minut}few{# minuta}other{# minuta}",
    SHORT: "one{# min}few{# min}other{# min}",
    NARROW: "one{# m}few{# m}other{# m}",
  },
  MONTH: {
    LONG: "one{# mesec}few{# meseca}other{# meseci}",
    SHORT: "one{# mes.}few{# mes.}other{# mes.}",
    NARROW: "one{# m}few{# m}other{# m}",
  },
  SECOND: {
    LONG: "one{# sekunda}few{# sekunde}other{# sekundi}",
    SHORT: "one{# sek}few{# sek}other{# sek}",
    NARROW: "one{# s}few{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# nedelja}few{# nedelje}other{# nedelja}",
    SHORT: "one{# ned.}few{# ned.}other{# ned.}",
    NARROW: "one{# n}few{# n}other{# n}",
  },
  YEAR: {
    LONG: "one{# godina}few{# godine}other{# godina}",
    SHORT: "one{# god}few{# god.}other{# god.}",
    NARROW: "one{# g}few{# g}other{# g}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Latn_RS =  {
  DAY: {
    LONG: "one{# dan}few{# dana}other{# dana}",
    SHORT: "one{# dan}few{# dana}other{# dana}",
    NARROW: "one{# d}few{# d}other{# d}",
  },
  HOUR: {
    LONG: "one{# sat}few{# sata}other{# sati}",
    SHORT: "one{# sat}few{# sata}other{# sati}",
    NARROW: "one{# č}few{# č}other{# č}",
  },
  MINUTE: {
    LONG: "one{# minut}few{# minuta}other{# minuta}",
    SHORT: "one{# min}few{# min}other{# min}",
    NARROW: "one{# m}few{# m}other{# m}",
  },
  MONTH: {
    LONG: "one{# mesec}few{# meseca}other{# meseci}",
    SHORT: "one{# mes.}few{# mes.}other{# mes.}",
    NARROW: "one{# m}few{# m}other{# m}",
  },
  SECOND: {
    LONG: "one{# sekunda}few{# sekunde}other{# sekundi}",
    SHORT: "one{# sek}few{# sek}other{# sek}",
    NARROW: "one{# s}few{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# nedelja}few{# nedelje}other{# nedelja}",
    SHORT: "one{# ned.}few{# ned.}other{# ned.}",
    NARROW: "one{# n}few{# n}other{# n}",
  },
  YEAR: {
    LONG: "one{# godina}few{# godine}other{# godina}",
    SHORT: "one{# god}few{# god.}other{# god.}",
    NARROW: "one{# g}few{# g}other{# g}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sr_Latn_XK =  {
  DAY: {
    LONG: "one{# dan}few{# dana}other{# dana}",
    SHORT: "one{# dan}few{# dana}other{# dana}",
    NARROW: "one{# d}few{# d}other{# d}",
  },
  HOUR: {
    LONG: "one{# sat}few{# sata}other{# sati}",
    SHORT: "one{# sat}few{# sata}other{# sati}",
    NARROW: "one{# č}few{# č}other{# č}",
  },
  MINUTE: {
    LONG: "one{# minut}few{# minuta}other{# minuta}",
    SHORT: "one{# min}few{# min}other{# min}",
    NARROW: "one{# m}few{# m}other{# m}",
  },
  MONTH: {
    LONG: "one{# mesec}few{# meseca}other{# meseci}",
    SHORT: "one{# mes.}few{# mes.}other{# mes.}",
    NARROW: "one{# m}few{# m}other{# m}",
  },
  SECOND: {
    LONG: "one{# sekunda}few{# sekunde}other{# sekundi}",
    SHORT: "one{# sek}few{# sek}other{# sek}",
    NARROW: "one{# s}few{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# nedelja}few{# nedelje}other{# nedelja}",
    SHORT: "one{# ned.}few{# ned.}other{# ned.}",
    NARROW: "one{# n}few{# n}other{# n}",
  },
  YEAR: {
    LONG: "one{# godina}few{# godine}other{# godina}",
    SHORT: "one{# god}few{# god.}other{# god.}",
    NARROW: "one{# g}few{# g}other{# g}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_su =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_su_Latn = exports.DurationSymbols_su;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_su_Latn_ID = exports.DurationSymbols_su;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sv_AX = DurationSymbols.DurationSymbols_sv;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sv_FI = DurationSymbols.DurationSymbols_sv;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sv_SE = DurationSymbols.DurationSymbols_sv;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sw_CD = DurationSymbols.DurationSymbols_sw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sw_KE = DurationSymbols.DurationSymbols_sw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sw_TZ = DurationSymbols.DurationSymbols_sw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_sw_UG = DurationSymbols.DurationSymbols_sw;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ta_IN = DurationSymbols.DurationSymbols_ta;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ta_LK = DurationSymbols.DurationSymbols_ta;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ta_MY = DurationSymbols.DurationSymbols_ta;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ta_SG = DurationSymbols.DurationSymbols_ta;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_te_IN = DurationSymbols.DurationSymbols_te;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_teo =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_teo_KE = exports.DurationSymbols_teo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_teo_UG = exports.DurationSymbols_teo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tg =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tg_TJ = exports.DurationSymbols_tg;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_th_TH = DurationSymbols.DurationSymbols_th;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ti =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ti_ER = exports.DurationSymbols_ti;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ti_ET = exports.DurationSymbols_ti;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tk =  {
  DAY: {
    LONG: "one{# gün}other{# gün}",
    SHORT: "one{# gün}other{# gün}",
    NARROW: "one{#g}other{#g}",
  },
  HOUR: {
    LONG: "one{# sagat}other{# sagat}",
    SHORT: "one{# sag}other{# sag}",
    NARROW: "one{#sg}other{#sg}",
  },
  MINUTE: {
    LONG: "one{# minut}other{# minut}",
    SHORT: "one{# min}other{# min}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# aý}other{# aý}",
    SHORT: "one{# a}other{# a}",
    NARROW: "one{#a}other{#a}",
  },
  SECOND: {
    LONG: "one{# sekunt}other{# sekunt}",
    SHORT: "one{# sek}other{# sek}",
    NARROW: "one{#se}other{#se}",
  },
  WEEK: {
    LONG: "one{# hepde}other{# hepde}",
    SHORT: "one{# hep}other{# hep}",
    NARROW: "one{#h}other{#h}",
  },
  YEAR: {
    LONG: "one{# ýyl}other{# ýyl}",
    SHORT: "one{# ý.}other{# ý.}",
    NARROW: "one{#ý}other{#ý}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tk_TM = exports.DurationSymbols_tk;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_to =  {
  DAY: {
    LONG: "other{ʻaho ʻe #}",
    SHORT: "other{ʻa ʻe #}",
    NARROW: "other{# ʻa}",
  },
  HOUR: {
    LONG: "other{houa ʻe #}",
    SHORT: "other{h ʻe #}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{miniti ʻe #}",
    SHORT: "other{m ʻe #}",
    NARROW: "other{# m}",
  },
  MONTH: {
    LONG: "other{māhina ʻe #}",
    SHORT: "other{mā ʻe #}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{sekoni ʻe #}",
    SHORT: "other{s ʻe #}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{uike ʻe #}",
    SHORT: "other{u ʻe #}",
    NARROW: "other{# u}",
  },
  YEAR: {
    LONG: "other{taʻu ʻe #}",
    SHORT: "other{taʻu ʻe #}",
    NARROW: "other{# t}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_to_TO = exports.DurationSymbols_to;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tr_CY = DurationSymbols.DurationSymbols_tr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tr_TR = DurationSymbols.DurationSymbols_tr;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tt =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tt_RU = exports.DurationSymbols_tt;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_twq =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_twq_NE = exports.DurationSymbols_twq;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tzm =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_tzm_MA = exports.DurationSymbols_tzm;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ug =  {
  DAY: {
    LONG: "one{# كۈن}other{# كۈن}",
    SHORT: "one{# كۈن}other{# كۈن}",
    NARROW: "one{# كۈن}other{# كۈن}",
  },
  HOUR: {
    LONG: "one{# سائەت}other{# سائەت}",
    SHORT: "one{# سائەت}other{# سائەت}",
    NARROW: "one{#h}other{#h}",
  },
  MINUTE: {
    LONG: "one{# مىنۇت}other{# مىنۇت}",
    SHORT: "one{# مىنۇت}other{# مىنۇت}",
    NARROW: "one{#m}other{#m}",
  },
  MONTH: {
    LONG: "one{# ئاي}other{# ئاي}",
    SHORT: "one{# ئاي}other{# ئاي}",
    NARROW: "one{# ئاي}other{# ئاي}",
  },
  SECOND: {
    LONG: "one{# سېكۇنت}other{# سېكۇنت}",
    SHORT: "one{# سېكۇنت}other{# سېكۇنت}",
    NARROW: "one{#s}other{#s}",
  },
  WEEK: {
    LONG: "one{# ھەپتە}other{# ھەپتە}",
    SHORT: "one{# ھەپتە}other{# ھەپتە}",
    NARROW: "one{# ھەپتە}other{# ھەپتە}",
  },
  YEAR: {
    LONG: "one{# يىل}other{# يىل}",
    SHORT: "one{# يىل}other{# يىل}",
    NARROW: "one{# يىل}other{# يىل}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ug_CN = exports.DurationSymbols_ug;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_uk_UA = DurationSymbols.DurationSymbols_uk;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ur_IN = DurationSymbols.DurationSymbols_ur;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_ur_PK = DurationSymbols.DurationSymbols_ur;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_uz_Arab =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_uz_Arab_AF =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_uz_Cyrl =  {
  DAY: {
    LONG: "one{# кун}other{# кун}",
    SHORT: "one{# кун}other{# кун}",
    NARROW: "one{# к}other{# к}",
  },
  HOUR: {
    LONG: "one{# соат}other{# соат}",
    SHORT: "one{# соат}other{# соат}",
    NARROW: "one{# с}other{# с}",
  },
  MINUTE: {
    LONG: "one{# дақиқа}other{# дақиқа}",
    SHORT: "one{# дақ}other{# дақ}",
    NARROW: "one{# дақ}other{# дақ}",
  },
  MONTH: {
    LONG: "one{# ой}other{# ой}",
    SHORT: "one{# ой}other{# ой}",
    NARROW: "one{# ой}other{# ой}",
  },
  SECOND: {
    LONG: "one{# сония}other{# сония}",
    SHORT: "one{# сония}other{# сония}",
    NARROW: "one{# сон}other{# сон}",
  },
  WEEK: {
    LONG: "one{# ҳафта}other{# ҳафта}",
    SHORT: "one{# ҳафт}other{# ҳафт}",
    NARROW: "one{# ҳафт}other{# ҳафт}",
  },
  YEAR: {
    LONG: "one{# йил}other{# йил}",
    SHORT: "one{# й}other{# й}",
    NARROW: "one{# й}other{# й}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_uz_Cyrl_UZ =  {
  DAY: {
    LONG: "one{# кун}other{# кун}",
    SHORT: "one{# кун}other{# кун}",
    NARROW: "one{# к}other{# к}",
  },
  HOUR: {
    LONG: "one{# соат}other{# соат}",
    SHORT: "one{# соат}other{# соат}",
    NARROW: "one{# с}other{# с}",
  },
  MINUTE: {
    LONG: "one{# дақиқа}other{# дақиқа}",
    SHORT: "one{# дақ}other{# дақ}",
    NARROW: "one{# дақ}other{# дақ}",
  },
  MONTH: {
    LONG: "one{# ой}other{# ой}",
    SHORT: "one{# ой}other{# ой}",
    NARROW: "one{# ой}other{# ой}",
  },
  SECOND: {
    LONG: "one{# сония}other{# сония}",
    SHORT: "one{# сония}other{# сония}",
    NARROW: "one{# сон}other{# сон}",
  },
  WEEK: {
    LONG: "one{# ҳафта}other{# ҳафта}",
    SHORT: "one{# ҳафт}other{# ҳафт}",
    NARROW: "one{# ҳафт}other{# ҳафт}",
  },
  YEAR: {
    LONG: "one{# йил}other{# йил}",
    SHORT: "one{# й}other{# й}",
    NARROW: "one{# й}other{# й}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_uz_Latn = DurationSymbols.DurationSymbols_uz;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_uz_Latn_UZ = DurationSymbols.DurationSymbols_uz;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_vai =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_vai_Latn = exports.DurationSymbols_vai;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_vai_Latn_LR = exports.DurationSymbols_vai;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_vai_Vaii = exports.DurationSymbols_vai;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_vai_Vaii_LR = exports.DurationSymbols_vai;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_vi_VN = DurationSymbols.DurationSymbols_vi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_vun =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_vun_TZ = exports.DurationSymbols_vun;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_wae =  {
  DAY: {
    LONG: "one{# täg}other{# täg}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "one{# stund}other{# stunde}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "one{# minüta}other{# minüte}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{# mánet}other{# mánet}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "one{# sekund}other{# sekunde}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "one{# wuča}other{# wučä}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "one{# jár}other{# jár}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_wae_CH = exports.DurationSymbols_wae;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_wo =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_wo_SN = exports.DurationSymbols_wo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_xh =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_xh_ZA = exports.DurationSymbols_xh;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_xog =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_xog_UG = exports.DurationSymbols_xog;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yav =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yav_CM = exports.DurationSymbols_yav;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yi =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yi_001 = exports.DurationSymbols_yi;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yo =  {
  DAY: {
    LONG: "other{ọj #}",
    SHORT: "other{# ọj}",
    NARROW: "other{ọj #}",
  },
  HOUR: {
    LONG: "other{# wkt}",
    SHORT: "other{# wkt}",
    NARROW: "other{# wkt}",
  },
  MINUTE: {
    LONG: "other{# ìṣ}",
    SHORT: "other{# ìṣ}",
    NARROW: "other{#/ìṣ}",
  },
  MONTH: {
    LONG: "other{# oṣù}",
    SHORT: "other{# oṣù}",
    NARROW: "other{# oṣù}",
  },
  SECOND: {
    LONG: "other{#ìṣ àáy}",
    SHORT: "other{# ìṣ àáy}",
    NARROW: "other{# ìṣ àáy}",
  },
  WEEK: {
    LONG: "other{# ọṣ}",
    SHORT: "other{# ọṣ}",
    NARROW: "other{# ọṣ}",
  },
  YEAR: {
    LONG: "other{# ọd}",
    SHORT: "other{# ọd}",
    NARROW: "other{# ọd}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yo_BJ =  {
  DAY: {
    LONG: "other{ɔj #}",
    SHORT: "other{# ɔj}",
    NARROW: "other{ɔj #}",
  },
  HOUR: {
    LONG: "other{# wkt}",
    SHORT: "other{# wkt}",
    NARROW: "other{# wkt}",
  },
  MINUTE: {
    LONG: "other{# ìsh}",
    SHORT: "other{# ìsh}",
    NARROW: "other{#/ìsh}",
  },
  MONTH: {
    LONG: "other{# oshù}",
    SHORT: "other{# oshù}",
    NARROW: "other{# oshù}",
  },
  SECOND: {
    LONG: "other{#ìsh àáy}",
    SHORT: "other{# ìsh àáy}",
    NARROW: "other{# ìsh àáy}",
  },
  WEEK: {
    LONG: "other{# ɔsh}",
    SHORT: "other{# ɔsh}",
    NARROW: "other{# ɔsh}",
  },
  YEAR: {
    LONG: "other{# ɔd}",
    SHORT: "other{# ɔd}",
    NARROW: "other{# ɔd}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yo_NG = exports.DurationSymbols_yo;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yrl =  {
  DAY: {
    LONG: "one{# ara}other{# ara-ita}",
    SHORT: "one{# ara}other{# ara}",
    NARROW: "one{# ara}other{# ara}",
  },
  HOUR: {
    LONG: "one{# hura}other{# hura-ita}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "one{# minutu}other{# minutu-ita}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "one{# yasí}other{# yasí-ita}",
    SHORT: "one{# yasí}other{# yasí}",
    NARROW: "one{# yasí}other{# yasí}",
  },
  SECOND: {
    LONG: "one{# segũdu}other{# segũdu-ita}",
    SHORT: "one{# seg}other{# seg}",
    NARROW: "one{# s}other{# s}",
  },
  WEEK: {
    LONG: "one{# sẽmãna}other{# sẽmãna-ita}",
    SHORT: "one{# sem.}other{# sem}",
    NARROW: "one{# sem.}other{# sem}",
  },
  YEAR: {
    LONG: "one{# akayú}other{# akayú-ita}",
    SHORT: "one{# akayú}other{# akayú}",
    NARROW: "one{# akayú}other{# akayú}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yrl_BR = exports.DurationSymbols_yrl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yrl_CO = exports.DurationSymbols_yrl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yrl_VE = exports.DurationSymbols_yrl;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yue =  {
  DAY: {
    LONG: "other{# 天}",
    SHORT: "other{# 天}",
    NARROW: "other{# 天}",
  },
  HOUR: {
    LONG: "other{# 小時}",
    SHORT: "other{# 小時}",
    NARROW: "other{# 小時}",
  },
  MINUTE: {
    LONG: "other{# 分鐘}",
    SHORT: "other{# 分鐘}",
    NARROW: "other{# 分鐘}",
  },
  MONTH: {
    LONG: "other{# 個月}",
    SHORT: "other{# 個月}",
    NARROW: "other{# 個月}",
  },
  SECOND: {
    LONG: "other{# 秒}",
    SHORT: "other{# 秒}",
    NARROW: "other{# 秒}",
  },
  WEEK: {
    LONG: "other{# 週}",
    SHORT: "other{# 週}",
    NARROW: "other{# 週}",
  },
  YEAR: {
    LONG: "other{# 年}",
    SHORT: "other{# 年}",
    NARROW: "other{# 年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yue_Hans =  {
  DAY: {
    LONG: "other{# 天}",
    SHORT: "other{# 天}",
    NARROW: "other{# 天}",
  },
  HOUR: {
    LONG: "other{# 小时}",
    SHORT: "other{# 小时}",
    NARROW: "other{# 小时}",
  },
  MINUTE: {
    LONG: "other{# 分钟}",
    SHORT: "other{# 分钟}",
    NARROW: "other{# 分钟}",
  },
  MONTH: {
    LONG: "other{# 个月}",
    SHORT: "other{# 个月}",
    NARROW: "other{# 个月}",
  },
  SECOND: {
    LONG: "other{# 秒}",
    SHORT: "other{# 秒}",
    NARROW: "other{# 秒}",
  },
  WEEK: {
    LONG: "other{# 周}",
    SHORT: "other{# 周}",
    NARROW: "other{# 周}",
  },
  YEAR: {
    LONG: "other{# 年}",
    SHORT: "other{# 年}",
    NARROW: "other{# 年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yue_Hans_CN =  {
  DAY: {
    LONG: "other{# 天}",
    SHORT: "other{# 天}",
    NARROW: "other{# 天}",
  },
  HOUR: {
    LONG: "other{# 小时}",
    SHORT: "other{# 小时}",
    NARROW: "other{# 小时}",
  },
  MINUTE: {
    LONG: "other{# 分钟}",
    SHORT: "other{# 分钟}",
    NARROW: "other{# 分钟}",
  },
  MONTH: {
    LONG: "other{# 个月}",
    SHORT: "other{# 个月}",
    NARROW: "other{# 个月}",
  },
  SECOND: {
    LONG: "other{# 秒}",
    SHORT: "other{# 秒}",
    NARROW: "other{# 秒}",
  },
  WEEK: {
    LONG: "other{# 周}",
    SHORT: "other{# 周}",
    NARROW: "other{# 周}",
  },
  YEAR: {
    LONG: "other{# 年}",
    SHORT: "other{# 年}",
    NARROW: "other{# 年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yue_Hant = exports.DurationSymbols_yue;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_yue_Hant_HK = exports.DurationSymbols_yue;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zgh =  {
  DAY: {
    LONG: "other{# d}",
    SHORT: "other{# d}",
    NARROW: "other{# d}",
  },
  HOUR: {
    LONG: "other{# h}",
    SHORT: "other{# h}",
    NARROW: "other{# h}",
  },
  MINUTE: {
    LONG: "other{# min}",
    SHORT: "other{# min}",
    NARROW: "other{# min}",
  },
  MONTH: {
    LONG: "other{# m}",
    SHORT: "other{# m}",
    NARROW: "other{# m}",
  },
  SECOND: {
    LONG: "other{# s}",
    SHORT: "other{# s}",
    NARROW: "other{# s}",
  },
  WEEK: {
    LONG: "other{# w}",
    SHORT: "other{# w}",
    NARROW: "other{# w}",
  },
  YEAR: {
    LONG: "other{# y}",
    SHORT: "other{# y}",
    NARROW: "other{# y}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zgh_MA = exports.DurationSymbols_zgh;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hans = DurationSymbols.DurationSymbols_zh;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hans_CN = DurationSymbols.DurationSymbols_zh;
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hans_HK =  {
  DAY: {
    LONG: "other{#天}",
    SHORT: "other{#天}",
    NARROW: "other{#天}",
  },
  HOUR: {
    LONG: "other{#小时}",
    SHORT: "other{#小时}",
    NARROW: "other{#小时}",
  },
  MINUTE: {
    LONG: "other{#分钟}",
    SHORT: "other{#分钟}",
    NARROW: "other{#分钟}",
  },
  MONTH: {
    LONG: "other{#个月}",
    SHORT: "other{#个月}",
    NARROW: "other{#个月}",
  },
  SECOND: {
    LONG: "other{#秒}",
    SHORT: "other{#秒}",
    NARROW: "other{#秒}",
  },
  WEEK: {
    LONG: "other{#周}",
    SHORT: "other{#周}",
    NARROW: "other{#周}",
  },
  YEAR: {
    LONG: "other{#年}",
    SHORT: "other{#年}",
    NARROW: "other{#年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hans_MO =  {
  DAY: {
    LONG: "other{#天}",
    SHORT: "other{#天}",
    NARROW: "other{#天}",
  },
  HOUR: {
    LONG: "other{#小时}",
    SHORT: "other{#小时}",
    NARROW: "other{#小时}",
  },
  MINUTE: {
    LONG: "other{#分钟}",
    SHORT: "other{#分钟}",
    NARROW: "other{#分钟}",
  },
  MONTH: {
    LONG: "other{#个月}",
    SHORT: "other{#个月}",
    NARROW: "other{#个月}",
  },
  SECOND: {
    LONG: "other{#秒}",
    SHORT: "other{#秒}",
    NARROW: "other{#秒}",
  },
  WEEK: {
    LONG: "other{#周}",
    SHORT: "other{#周}",
    NARROW: "other{#周}",
  },
  YEAR: {
    LONG: "other{#年}",
    SHORT: "other{#年}",
    NARROW: "other{#年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hans_SG =  {
  DAY: {
    LONG: "other{#天}",
    SHORT: "other{#天}",
    NARROW: "other{#天}",
  },
  HOUR: {
    LONG: "other{#小时}",
    SHORT: "other{#小时}",
    NARROW: "other{#小时}",
  },
  MINUTE: {
    LONG: "other{#分钟}",
    SHORT: "other{#分钟}",
    NARROW: "other{#分钟}",
  },
  MONTH: {
    LONG: "other{#个月}",
    SHORT: "other{#个月}",
    NARROW: "other{#个月}",
  },
  SECOND: {
    LONG: "other{#秒}",
    SHORT: "other{#秒}",
    NARROW: "other{#秒}",
  },
  WEEK: {
    LONG: "other{#周}",
    SHORT: "other{#周}",
    NARROW: "other{#周}",
  },
  YEAR: {
    LONG: "other{#年}",
    SHORT: "other{#年}",
    NARROW: "other{#年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hant =  {
  DAY: {
    LONG: "other{# 天}",
    SHORT: "other{# 天}",
    NARROW: "other{# 天}",
  },
  HOUR: {
    LONG: "other{# 小時}",
    SHORT: "other{# 小時}",
    NARROW: "other{# 小時}",
  },
  MINUTE: {
    LONG: "other{# 分鐘}",
    SHORT: "other{# 分鐘}",
    NARROW: "other{# 分鐘}",
  },
  MONTH: {
    LONG: "other{# 個月}",
    SHORT: "other{# 個月}",
    NARROW: "other{# 個月}",
  },
  SECOND: {
    LONG: "other{# 秒}",
    SHORT: "other{# 秒}",
    NARROW: "other{# 秒}",
  },
  WEEK: {
    LONG: "other{# 週}",
    SHORT: "other{# 週}",
    NARROW: "other{# 週}",
  },
  YEAR: {
    LONG: "other{# 年}",
    SHORT: "other{# 年}",
    NARROW: "other{# 年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hant_HK =  {
  DAY: {
    LONG: "other{# 日}",
    SHORT: "other{# 日}",
    NARROW: "other{#日}",
  },
  HOUR: {
    LONG: "other{# 小時}",
    SHORT: "other{# 小時}",
    NARROW: "other{#小時}",
  },
  MINUTE: {
    LONG: "other{# 分鐘}",
    SHORT: "other{# 分鐘}",
    NARROW: "other{#分}",
  },
  MONTH: {
    LONG: "other{# 個月}",
    SHORT: "other{# 個月}",
    NARROW: "other{#個月}",
  },
  SECOND: {
    LONG: "other{# 秒}",
    SHORT: "other{# 秒}",
    NARROW: "other{#秒}",
  },
  WEEK: {
    LONG: "other{# 星期}",
    SHORT: "other{# 星期}",
    NARROW: "other{#週}",
  },
  YEAR: {
    LONG: "other{# 年}",
    SHORT: "other{# 年}",
    NARROW: "other{#年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hant_MO =  {
  DAY: {
    LONG: "other{# 日}",
    SHORT: "other{# 日}",
    NARROW: "other{#日}",
  },
  HOUR: {
    LONG: "other{# 小時}",
    SHORT: "other{# 小時}",
    NARROW: "other{#小時}",
  },
  MINUTE: {
    LONG: "other{# 分鐘}",
    SHORT: "other{# 分鐘}",
    NARROW: "other{#分}",
  },
  MONTH: {
    LONG: "other{# 個月}",
    SHORT: "other{# 個月}",
    NARROW: "other{#個月}",
  },
  SECOND: {
    LONG: "other{# 秒}",
    SHORT: "other{# 秒}",
    NARROW: "other{#秒}",
  },
  WEEK: {
    LONG: "other{# 星期}",
    SHORT: "other{# 星期}",
    NARROW: "other{#週}",
  },
  YEAR: {
    LONG: "other{# 年}",
    SHORT: "other{# 年}",
    NARROW: "other{#年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zh_Hant_TW =  {
  DAY: {
    LONG: "other{# 天}",
    SHORT: "other{# 天}",
    NARROW: "other{# 天}",
  },
  HOUR: {
    LONG: "other{# 小時}",
    SHORT: "other{# 小時}",
    NARROW: "other{# 小時}",
  },
  MINUTE: {
    LONG: "other{# 分鐘}",
    SHORT: "other{# 分鐘}",
    NARROW: "other{# 分鐘}",
  },
  MONTH: {
    LONG: "other{# 個月}",
    SHORT: "other{# 個月}",
    NARROW: "other{# 個月}",
  },
  SECOND: {
    LONG: "other{# 秒}",
    SHORT: "other{# 秒}",
    NARROW: "other{# 秒}",
  },
  WEEK: {
    LONG: "other{# 週}",
    SHORT: "other{# 週}",
    NARROW: "other{# 週}",
  },
  YEAR: {
    LONG: "other{# 年}",
    SHORT: "other{# 年}",
    NARROW: "other{# 年}",
  },
};
/**  @const {!DurationSymbolTypes.DurationSymbols}  */
exports.DurationSymbols_zu_ZA = DurationSymbols.DurationSymbols_zu;
switch (goog.LOCALE) {
  case 'af_NA':
  case 'af-NA':
    defaultSymbols = exports.DurationSymbols_af_NA;
    break;
  case 'af_ZA':
  case 'af-ZA':
    defaultSymbols = exports.DurationSymbols_af_ZA;
    break;
  case 'agq':
    defaultSymbols = exports.DurationSymbols_agq;
    break;
  case 'agq_CM':
  case 'agq-CM':
    defaultSymbols = exports.DurationSymbols_agq_CM;
    break;
  case 'ak':
    defaultSymbols = exports.DurationSymbols_ak;
    break;
  case 'ak_GH':
  case 'ak-GH':
    defaultSymbols = exports.DurationSymbols_ak_GH;
    break;
  case 'am_ET':
  case 'am-ET':
    defaultSymbols = exports.DurationSymbols_am_ET;
    break;
  case 'ar_001':
  case 'ar-001':
    defaultSymbols = exports.DurationSymbols_ar_001;
    break;
  case 'ar_AE':
  case 'ar-AE':
    defaultSymbols = exports.DurationSymbols_ar_AE;
    break;
  case 'ar_BH':
  case 'ar-BH':
    defaultSymbols = exports.DurationSymbols_ar_BH;
    break;
  case 'ar_DJ':
  case 'ar-DJ':
    defaultSymbols = exports.DurationSymbols_ar_DJ;
    break;
  case 'ar_EH':
  case 'ar-EH':
    defaultSymbols = exports.DurationSymbols_ar_EH;
    break;
  case 'ar_ER':
  case 'ar-ER':
    defaultSymbols = exports.DurationSymbols_ar_ER;
    break;
  case 'ar_IL':
  case 'ar-IL':
    defaultSymbols = exports.DurationSymbols_ar_IL;
    break;
  case 'ar_IQ':
  case 'ar-IQ':
    defaultSymbols = exports.DurationSymbols_ar_IQ;
    break;
  case 'ar_JO':
  case 'ar-JO':
    defaultSymbols = exports.DurationSymbols_ar_JO;
    break;
  case 'ar_KM':
  case 'ar-KM':
    defaultSymbols = exports.DurationSymbols_ar_KM;
    break;
  case 'ar_KW':
  case 'ar-KW':
    defaultSymbols = exports.DurationSymbols_ar_KW;
    break;
  case 'ar_LB':
  case 'ar-LB':
    defaultSymbols = exports.DurationSymbols_ar_LB;
    break;
  case 'ar_LY':
  case 'ar-LY':
    defaultSymbols = exports.DurationSymbols_ar_LY;
    break;
  case 'ar_MA':
  case 'ar-MA':
    defaultSymbols = exports.DurationSymbols_ar_MA;
    break;
  case 'ar_MR':
  case 'ar-MR':
    defaultSymbols = exports.DurationSymbols_ar_MR;
    break;
  case 'ar_OM':
  case 'ar-OM':
    defaultSymbols = exports.DurationSymbols_ar_OM;
    break;
  case 'ar_PS':
  case 'ar-PS':
    defaultSymbols = exports.DurationSymbols_ar_PS;
    break;
  case 'ar_QA':
  case 'ar-QA':
    defaultSymbols = exports.DurationSymbols_ar_QA;
    break;
  case 'ar_SA':
  case 'ar-SA':
    defaultSymbols = exports.DurationSymbols_ar_SA;
    break;
  case 'ar_SD':
  case 'ar-SD':
    defaultSymbols = exports.DurationSymbols_ar_SD;
    break;
  case 'ar_SO':
  case 'ar-SO':
    defaultSymbols = exports.DurationSymbols_ar_SO;
    break;
  case 'ar_SS':
  case 'ar-SS':
    defaultSymbols = exports.DurationSymbols_ar_SS;
    break;
  case 'ar_SY':
  case 'ar-SY':
    defaultSymbols = exports.DurationSymbols_ar_SY;
    break;
  case 'ar_TD':
  case 'ar-TD':
    defaultSymbols = exports.DurationSymbols_ar_TD;
    break;
  case 'ar_TN':
  case 'ar-TN':
    defaultSymbols = exports.DurationSymbols_ar_TN;
    break;
  case 'ar_XB':
  case 'ar-XB':
    defaultSymbols = exports.DurationSymbols_ar_XB;
    break;
  case 'ar_YE':
  case 'ar-YE':
    defaultSymbols = exports.DurationSymbols_ar_YE;
    break;
  case 'as':
    defaultSymbols = exports.DurationSymbols_as;
    break;
  case 'as_IN':
  case 'as-IN':
    defaultSymbols = exports.DurationSymbols_as_IN;
    break;
  case 'asa':
    defaultSymbols = exports.DurationSymbols_asa;
    break;
  case 'asa_TZ':
  case 'asa-TZ':
    defaultSymbols = exports.DurationSymbols_asa_TZ;
    break;
  case 'ast':
    defaultSymbols = exports.DurationSymbols_ast;
    break;
  case 'ast_ES':
  case 'ast-ES':
    defaultSymbols = exports.DurationSymbols_ast_ES;
    break;
  case 'az_Cyrl':
  case 'az-Cyrl':
    defaultSymbols = exports.DurationSymbols_az_Cyrl;
    break;
  case 'az_Cyrl_AZ':
  case 'az-Cyrl-AZ':
    defaultSymbols = exports.DurationSymbols_az_Cyrl_AZ;
    break;
  case 'az_Latn':
  case 'az-Latn':
    defaultSymbols = exports.DurationSymbols_az_Latn;
    break;
  case 'az_Latn_AZ':
  case 'az-Latn-AZ':
    defaultSymbols = exports.DurationSymbols_az_Latn_AZ;
    break;
  case 'bas':
    defaultSymbols = exports.DurationSymbols_bas;
    break;
  case 'bas_CM':
  case 'bas-CM':
    defaultSymbols = exports.DurationSymbols_bas_CM;
    break;
  case 'be_BY':
  case 'be-BY':
    defaultSymbols = exports.DurationSymbols_be_BY;
    break;
  case 'bem':
    defaultSymbols = exports.DurationSymbols_bem;
    break;
  case 'bem_ZM':
  case 'bem-ZM':
    defaultSymbols = exports.DurationSymbols_bem_ZM;
    break;
  case 'bez':
    defaultSymbols = exports.DurationSymbols_bez;
    break;
  case 'bez_TZ':
  case 'bez-TZ':
    defaultSymbols = exports.DurationSymbols_bez_TZ;
    break;
  case 'bg_BG':
  case 'bg-BG':
    defaultSymbols = exports.DurationSymbols_bg_BG;
    break;
  case 'bm':
    defaultSymbols = exports.DurationSymbols_bm;
    break;
  case 'bm_ML':
  case 'bm-ML':
    defaultSymbols = exports.DurationSymbols_bm_ML;
    break;
  case 'bn_BD':
  case 'bn-BD':
    defaultSymbols = exports.DurationSymbols_bn_BD;
    break;
  case 'bn_IN':
  case 'bn-IN':
    defaultSymbols = exports.DurationSymbols_bn_IN;
    break;
  case 'bo':
    defaultSymbols = exports.DurationSymbols_bo;
    break;
  case 'bo_CN':
  case 'bo-CN':
    defaultSymbols = exports.DurationSymbols_bo_CN;
    break;
  case 'bo_IN':
  case 'bo-IN':
    defaultSymbols = exports.DurationSymbols_bo_IN;
    break;
  case 'br_FR':
  case 'br-FR':
    defaultSymbols = exports.DurationSymbols_br_FR;
    break;
  case 'brx':
    defaultSymbols = exports.DurationSymbols_brx;
    break;
  case 'brx_IN':
  case 'brx-IN':
    defaultSymbols = exports.DurationSymbols_brx_IN;
    break;
  case 'bs_Cyrl':
  case 'bs-Cyrl':
    defaultSymbols = exports.DurationSymbols_bs_Cyrl;
    break;
  case 'bs_Cyrl_BA':
  case 'bs-Cyrl-BA':
    defaultSymbols = exports.DurationSymbols_bs_Cyrl_BA;
    break;
  case 'bs_Latn':
  case 'bs-Latn':
    defaultSymbols = exports.DurationSymbols_bs_Latn;
    break;
  case 'bs_Latn_BA':
  case 'bs-Latn-BA':
    defaultSymbols = exports.DurationSymbols_bs_Latn_BA;
    break;
  case 'ca_AD':
  case 'ca-AD':
    defaultSymbols = exports.DurationSymbols_ca_AD;
    break;
  case 'ca_ES':
  case 'ca-ES':
    defaultSymbols = exports.DurationSymbols_ca_ES;
    break;
  case 'ca_FR':
  case 'ca-FR':
    defaultSymbols = exports.DurationSymbols_ca_FR;
    break;
  case 'ca_IT':
  case 'ca-IT':
    defaultSymbols = exports.DurationSymbols_ca_IT;
    break;
  case 'ccp':
    defaultSymbols = exports.DurationSymbols_ccp;
    break;
  case 'ccp_BD':
  case 'ccp-BD':
    defaultSymbols = exports.DurationSymbols_ccp_BD;
    break;
  case 'ccp_IN':
  case 'ccp-IN':
    defaultSymbols = exports.DurationSymbols_ccp_IN;
    break;
  case 'ce':
    defaultSymbols = exports.DurationSymbols_ce;
    break;
  case 'ce_RU':
  case 'ce-RU':
    defaultSymbols = exports.DurationSymbols_ce_RU;
    break;
  case 'ceb':
    defaultSymbols = exports.DurationSymbols_ceb;
    break;
  case 'ceb_PH':
  case 'ceb-PH':
    defaultSymbols = exports.DurationSymbols_ceb_PH;
    break;
  case 'cgg':
    defaultSymbols = exports.DurationSymbols_cgg;
    break;
  case 'cgg_UG':
  case 'cgg-UG':
    defaultSymbols = exports.DurationSymbols_cgg_UG;
    break;
  case 'chr_US':
  case 'chr-US':
    defaultSymbols = exports.DurationSymbols_chr_US;
    break;
  case 'ckb':
    defaultSymbols = exports.DurationSymbols_ckb;
    break;
  case 'ckb_Arab':
  case 'ckb-Arab':
    defaultSymbols = exports.DurationSymbols_ckb_Arab;
    break;
  case 'ckb_Arab_IQ':
  case 'ckb-Arab-IQ':
    defaultSymbols = exports.DurationSymbols_ckb_Arab_IQ;
    break;
  case 'ckb_Arab_IR':
  case 'ckb-Arab-IR':
    defaultSymbols = exports.DurationSymbols_ckb_Arab_IR;
    break;
  case 'ckb_IQ':
  case 'ckb-IQ':
    defaultSymbols = exports.DurationSymbols_ckb_IQ;
    break;
  case 'ckb_IR':
  case 'ckb-IR':
    defaultSymbols = exports.DurationSymbols_ckb_IR;
    break;
  case 'cs_CZ':
  case 'cs-CZ':
    defaultSymbols = exports.DurationSymbols_cs_CZ;
    break;
  case 'cy_GB':
  case 'cy-GB':
    defaultSymbols = exports.DurationSymbols_cy_GB;
    break;
  case 'da_DK':
  case 'da-DK':
    defaultSymbols = exports.DurationSymbols_da_DK;
    break;
  case 'da_GL':
  case 'da-GL':
    defaultSymbols = exports.DurationSymbols_da_GL;
    break;
  case 'dav':
    defaultSymbols = exports.DurationSymbols_dav;
    break;
  case 'dav_KE':
  case 'dav-KE':
    defaultSymbols = exports.DurationSymbols_dav_KE;
    break;
  case 'de_BE':
  case 'de-BE':
    defaultSymbols = exports.DurationSymbols_de_BE;
    break;
  case 'de_DE':
  case 'de-DE':
    defaultSymbols = exports.DurationSymbols_de_DE;
    break;
  case 'de_IT':
  case 'de-IT':
    defaultSymbols = exports.DurationSymbols_de_IT;
    break;
  case 'de_LI':
  case 'de-LI':
    defaultSymbols = exports.DurationSymbols_de_LI;
    break;
  case 'de_LU':
  case 'de-LU':
    defaultSymbols = exports.DurationSymbols_de_LU;
    break;
  case 'dje':
    defaultSymbols = exports.DurationSymbols_dje;
    break;
  case 'dje_NE':
  case 'dje-NE':
    defaultSymbols = exports.DurationSymbols_dje_NE;
    break;
  case 'doi':
    defaultSymbols = exports.DurationSymbols_doi;
    break;
  case 'doi_IN':
  case 'doi-IN':
    defaultSymbols = exports.DurationSymbols_doi_IN;
    break;
  case 'dsb':
    defaultSymbols = exports.DurationSymbols_dsb;
    break;
  case 'dsb_DE':
  case 'dsb-DE':
    defaultSymbols = exports.DurationSymbols_dsb_DE;
    break;
  case 'dua':
    defaultSymbols = exports.DurationSymbols_dua;
    break;
  case 'dua_CM':
  case 'dua-CM':
    defaultSymbols = exports.DurationSymbols_dua_CM;
    break;
  case 'dyo':
    defaultSymbols = exports.DurationSymbols_dyo;
    break;
  case 'dyo_SN':
  case 'dyo-SN':
    defaultSymbols = exports.DurationSymbols_dyo_SN;
    break;
  case 'dz':
    defaultSymbols = exports.DurationSymbols_dz;
    break;
  case 'dz_BT':
  case 'dz-BT':
    defaultSymbols = exports.DurationSymbols_dz_BT;
    break;
  case 'ebu':
    defaultSymbols = exports.DurationSymbols_ebu;
    break;
  case 'ebu_KE':
  case 'ebu-KE':
    defaultSymbols = exports.DurationSymbols_ebu_KE;
    break;
  case 'ee':
    defaultSymbols = exports.DurationSymbols_ee;
    break;
  case 'ee_GH':
  case 'ee-GH':
    defaultSymbols = exports.DurationSymbols_ee_GH;
    break;
  case 'ee_TG':
  case 'ee-TG':
    defaultSymbols = exports.DurationSymbols_ee_TG;
    break;
  case 'el_CY':
  case 'el-CY':
    defaultSymbols = exports.DurationSymbols_el_CY;
    break;
  case 'el_GR':
  case 'el-GR':
    defaultSymbols = exports.DurationSymbols_el_GR;
    break;
  case 'en_001':
  case 'en-001':
    defaultSymbols = exports.DurationSymbols_en_001;
    break;
  case 'en_150':
  case 'en-150':
    defaultSymbols = exports.DurationSymbols_en_150;
    break;
  case 'en_AE':
  case 'en-AE':
    defaultSymbols = exports.DurationSymbols_en_AE;
    break;
  case 'en_AG':
  case 'en-AG':
    defaultSymbols = exports.DurationSymbols_en_AG;
    break;
  case 'en_AI':
  case 'en-AI':
    defaultSymbols = exports.DurationSymbols_en_AI;
    break;
  case 'en_AS':
  case 'en-AS':
    defaultSymbols = exports.DurationSymbols_en_AS;
    break;
  case 'en_AT':
  case 'en-AT':
    defaultSymbols = exports.DurationSymbols_en_AT;
    break;
  case 'en_BB':
  case 'en-BB':
    defaultSymbols = exports.DurationSymbols_en_BB;
    break;
  case 'en_BE':
  case 'en-BE':
    defaultSymbols = exports.DurationSymbols_en_BE;
    break;
  case 'en_BI':
  case 'en-BI':
    defaultSymbols = exports.DurationSymbols_en_BI;
    break;
  case 'en_BM':
  case 'en-BM':
    defaultSymbols = exports.DurationSymbols_en_BM;
    break;
  case 'en_BS':
  case 'en-BS':
    defaultSymbols = exports.DurationSymbols_en_BS;
    break;
  case 'en_BW':
  case 'en-BW':
    defaultSymbols = exports.DurationSymbols_en_BW;
    break;
  case 'en_BZ':
  case 'en-BZ':
    defaultSymbols = exports.DurationSymbols_en_BZ;
    break;
  case 'en_CC':
  case 'en-CC':
    defaultSymbols = exports.DurationSymbols_en_CC;
    break;
  case 'en_CH':
  case 'en-CH':
    defaultSymbols = exports.DurationSymbols_en_CH;
    break;
  case 'en_CK':
  case 'en-CK':
    defaultSymbols = exports.DurationSymbols_en_CK;
    break;
  case 'en_CM':
  case 'en-CM':
    defaultSymbols = exports.DurationSymbols_en_CM;
    break;
  case 'en_CX':
  case 'en-CX':
    defaultSymbols = exports.DurationSymbols_en_CX;
    break;
  case 'en_CY':
  case 'en-CY':
    defaultSymbols = exports.DurationSymbols_en_CY;
    break;
  case 'en_DE':
  case 'en-DE':
    defaultSymbols = exports.DurationSymbols_en_DE;
    break;
  case 'en_DG':
  case 'en-DG':
    defaultSymbols = exports.DurationSymbols_en_DG;
    break;
  case 'en_DK':
  case 'en-DK':
    defaultSymbols = exports.DurationSymbols_en_DK;
    break;
  case 'en_DM':
  case 'en-DM':
    defaultSymbols = exports.DurationSymbols_en_DM;
    break;
  case 'en_ER':
  case 'en-ER':
    defaultSymbols = exports.DurationSymbols_en_ER;
    break;
  case 'en_FI':
  case 'en-FI':
    defaultSymbols = exports.DurationSymbols_en_FI;
    break;
  case 'en_FJ':
  case 'en-FJ':
    defaultSymbols = exports.DurationSymbols_en_FJ;
    break;
  case 'en_FK':
  case 'en-FK':
    defaultSymbols = exports.DurationSymbols_en_FK;
    break;
  case 'en_FM':
  case 'en-FM':
    defaultSymbols = exports.DurationSymbols_en_FM;
    break;
  case 'en_GD':
  case 'en-GD':
    defaultSymbols = exports.DurationSymbols_en_GD;
    break;
  case 'en_GG':
  case 'en-GG':
    defaultSymbols = exports.DurationSymbols_en_GG;
    break;
  case 'en_GH':
  case 'en-GH':
    defaultSymbols = exports.DurationSymbols_en_GH;
    break;
  case 'en_GI':
  case 'en-GI':
    defaultSymbols = exports.DurationSymbols_en_GI;
    break;
  case 'en_GM':
  case 'en-GM':
    defaultSymbols = exports.DurationSymbols_en_GM;
    break;
  case 'en_GU':
  case 'en-GU':
    defaultSymbols = exports.DurationSymbols_en_GU;
    break;
  case 'en_GY':
  case 'en-GY':
    defaultSymbols = exports.DurationSymbols_en_GY;
    break;
  case 'en_HK':
  case 'en-HK':
    defaultSymbols = exports.DurationSymbols_en_HK;
    break;
  case 'en_IL':
  case 'en-IL':
    defaultSymbols = exports.DurationSymbols_en_IL;
    break;
  case 'en_IM':
  case 'en-IM':
    defaultSymbols = exports.DurationSymbols_en_IM;
    break;
  case 'en_IO':
  case 'en-IO':
    defaultSymbols = exports.DurationSymbols_en_IO;
    break;
  case 'en_JE':
  case 'en-JE':
    defaultSymbols = exports.DurationSymbols_en_JE;
    break;
  case 'en_JM':
  case 'en-JM':
    defaultSymbols = exports.DurationSymbols_en_JM;
    break;
  case 'en_KE':
  case 'en-KE':
    defaultSymbols = exports.DurationSymbols_en_KE;
    break;
  case 'en_KI':
  case 'en-KI':
    defaultSymbols = exports.DurationSymbols_en_KI;
    break;
  case 'en_KN':
  case 'en-KN':
    defaultSymbols = exports.DurationSymbols_en_KN;
    break;
  case 'en_KY':
  case 'en-KY':
    defaultSymbols = exports.DurationSymbols_en_KY;
    break;
  case 'en_LC':
  case 'en-LC':
    defaultSymbols = exports.DurationSymbols_en_LC;
    break;
  case 'en_LR':
  case 'en-LR':
    defaultSymbols = exports.DurationSymbols_en_LR;
    break;
  case 'en_LS':
  case 'en-LS':
    defaultSymbols = exports.DurationSymbols_en_LS;
    break;
  case 'en_MG':
  case 'en-MG':
    defaultSymbols = exports.DurationSymbols_en_MG;
    break;
  case 'en_MH':
  case 'en-MH':
    defaultSymbols = exports.DurationSymbols_en_MH;
    break;
  case 'en_MO':
  case 'en-MO':
    defaultSymbols = exports.DurationSymbols_en_MO;
    break;
  case 'en_MP':
  case 'en-MP':
    defaultSymbols = exports.DurationSymbols_en_MP;
    break;
  case 'en_MS':
  case 'en-MS':
    defaultSymbols = exports.DurationSymbols_en_MS;
    break;
  case 'en_MT':
  case 'en-MT':
    defaultSymbols = exports.DurationSymbols_en_MT;
    break;
  case 'en_MU':
  case 'en-MU':
    defaultSymbols = exports.DurationSymbols_en_MU;
    break;
  case 'en_MV':
  case 'en-MV':
    defaultSymbols = exports.DurationSymbols_en_MV;
    break;
  case 'en_MW':
  case 'en-MW':
    defaultSymbols = exports.DurationSymbols_en_MW;
    break;
  case 'en_MY':
  case 'en-MY':
    defaultSymbols = exports.DurationSymbols_en_MY;
    break;
  case 'en_NA':
  case 'en-NA':
    defaultSymbols = exports.DurationSymbols_en_NA;
    break;
  case 'en_NF':
  case 'en-NF':
    defaultSymbols = exports.DurationSymbols_en_NF;
    break;
  case 'en_NG':
  case 'en-NG':
    defaultSymbols = exports.DurationSymbols_en_NG;
    break;
  case 'en_NL':
  case 'en-NL':
    defaultSymbols = exports.DurationSymbols_en_NL;
    break;
  case 'en_NR':
  case 'en-NR':
    defaultSymbols = exports.DurationSymbols_en_NR;
    break;
  case 'en_NU':
  case 'en-NU':
    defaultSymbols = exports.DurationSymbols_en_NU;
    break;
  case 'en_NZ':
  case 'en-NZ':
    defaultSymbols = exports.DurationSymbols_en_NZ;
    break;
  case 'en_PG':
  case 'en-PG':
    defaultSymbols = exports.DurationSymbols_en_PG;
    break;
  case 'en_PH':
  case 'en-PH':
    defaultSymbols = exports.DurationSymbols_en_PH;
    break;
  case 'en_PK':
  case 'en-PK':
    defaultSymbols = exports.DurationSymbols_en_PK;
    break;
  case 'en_PN':
  case 'en-PN':
    defaultSymbols = exports.DurationSymbols_en_PN;
    break;
  case 'en_PR':
  case 'en-PR':
    defaultSymbols = exports.DurationSymbols_en_PR;
    break;
  case 'en_PW':
  case 'en-PW':
    defaultSymbols = exports.DurationSymbols_en_PW;
    break;
  case 'en_RW':
  case 'en-RW':
    defaultSymbols = exports.DurationSymbols_en_RW;
    break;
  case 'en_SB':
  case 'en-SB':
    defaultSymbols = exports.DurationSymbols_en_SB;
    break;
  case 'en_SC':
  case 'en-SC':
    defaultSymbols = exports.DurationSymbols_en_SC;
    break;
  case 'en_SD':
  case 'en-SD':
    defaultSymbols = exports.DurationSymbols_en_SD;
    break;
  case 'en_SE':
  case 'en-SE':
    defaultSymbols = exports.DurationSymbols_en_SE;
    break;
  case 'en_SH':
  case 'en-SH':
    defaultSymbols = exports.DurationSymbols_en_SH;
    break;
  case 'en_SI':
  case 'en-SI':
    defaultSymbols = exports.DurationSymbols_en_SI;
    break;
  case 'en_SL':
  case 'en-SL':
    defaultSymbols = exports.DurationSymbols_en_SL;
    break;
  case 'en_SS':
  case 'en-SS':
    defaultSymbols = exports.DurationSymbols_en_SS;
    break;
  case 'en_SX':
  case 'en-SX':
    defaultSymbols = exports.DurationSymbols_en_SX;
    break;
  case 'en_SZ':
  case 'en-SZ':
    defaultSymbols = exports.DurationSymbols_en_SZ;
    break;
  case 'en_TC':
  case 'en-TC':
    defaultSymbols = exports.DurationSymbols_en_TC;
    break;
  case 'en_TK':
  case 'en-TK':
    defaultSymbols = exports.DurationSymbols_en_TK;
    break;
  case 'en_TO':
  case 'en-TO':
    defaultSymbols = exports.DurationSymbols_en_TO;
    break;
  case 'en_TT':
  case 'en-TT':
    defaultSymbols = exports.DurationSymbols_en_TT;
    break;
  case 'en_TV':
  case 'en-TV':
    defaultSymbols = exports.DurationSymbols_en_TV;
    break;
  case 'en_TZ':
  case 'en-TZ':
    defaultSymbols = exports.DurationSymbols_en_TZ;
    break;
  case 'en_UG':
  case 'en-UG':
    defaultSymbols = exports.DurationSymbols_en_UG;
    break;
  case 'en_UM':
  case 'en-UM':
    defaultSymbols = exports.DurationSymbols_en_UM;
    break;
  case 'en_US_POSIX':
  case 'en-US-POSIX':
    defaultSymbols = exports.DurationSymbols_en_US_POSIX;
    break;
  case 'en_VC':
  case 'en-VC':
    defaultSymbols = exports.DurationSymbols_en_VC;
    break;
  case 'en_VG':
  case 'en-VG':
    defaultSymbols = exports.DurationSymbols_en_VG;
    break;
  case 'en_VI':
  case 'en-VI':
    defaultSymbols = exports.DurationSymbols_en_VI;
    break;
  case 'en_VU':
  case 'en-VU':
    defaultSymbols = exports.DurationSymbols_en_VU;
    break;
  case 'en_WS':
  case 'en-WS':
    defaultSymbols = exports.DurationSymbols_en_WS;
    break;
  case 'en_XA':
  case 'en-XA':
    defaultSymbols = exports.DurationSymbols_en_XA;
    break;
  case 'en_ZM':
  case 'en-ZM':
    defaultSymbols = exports.DurationSymbols_en_ZM;
    break;
  case 'en_ZW':
  case 'en-ZW':
    defaultSymbols = exports.DurationSymbols_en_ZW;
    break;
  case 'eo':
    defaultSymbols = exports.DurationSymbols_eo;
    break;
  case 'eo_001':
  case 'eo-001':
    defaultSymbols = exports.DurationSymbols_eo_001;
    break;
  case 'es_AR':
  case 'es-AR':
    defaultSymbols = exports.DurationSymbols_es_AR;
    break;
  case 'es_BO':
  case 'es-BO':
    defaultSymbols = exports.DurationSymbols_es_BO;
    break;
  case 'es_BR':
  case 'es-BR':
    defaultSymbols = exports.DurationSymbols_es_BR;
    break;
  case 'es_BZ':
  case 'es-BZ':
    defaultSymbols = exports.DurationSymbols_es_BZ;
    break;
  case 'es_CL':
  case 'es-CL':
    defaultSymbols = exports.DurationSymbols_es_CL;
    break;
  case 'es_CO':
  case 'es-CO':
    defaultSymbols = exports.DurationSymbols_es_CO;
    break;
  case 'es_CR':
  case 'es-CR':
    defaultSymbols = exports.DurationSymbols_es_CR;
    break;
  case 'es_CU':
  case 'es-CU':
    defaultSymbols = exports.DurationSymbols_es_CU;
    break;
  case 'es_DO':
  case 'es-DO':
    defaultSymbols = exports.DurationSymbols_es_DO;
    break;
  case 'es_EA':
  case 'es-EA':
    defaultSymbols = exports.DurationSymbols_es_EA;
    break;
  case 'es_EC':
  case 'es-EC':
    defaultSymbols = exports.DurationSymbols_es_EC;
    break;
  case 'es_GQ':
  case 'es-GQ':
    defaultSymbols = exports.DurationSymbols_es_GQ;
    break;
  case 'es_GT':
  case 'es-GT':
    defaultSymbols = exports.DurationSymbols_es_GT;
    break;
  case 'es_HN':
  case 'es-HN':
    defaultSymbols = exports.DurationSymbols_es_HN;
    break;
  case 'es_IC':
  case 'es-IC':
    defaultSymbols = exports.DurationSymbols_es_IC;
    break;
  case 'es_NI':
  case 'es-NI':
    defaultSymbols = exports.DurationSymbols_es_NI;
    break;
  case 'es_PA':
  case 'es-PA':
    defaultSymbols = exports.DurationSymbols_es_PA;
    break;
  case 'es_PE':
  case 'es-PE':
    defaultSymbols = exports.DurationSymbols_es_PE;
    break;
  case 'es_PH':
  case 'es-PH':
    defaultSymbols = exports.DurationSymbols_es_PH;
    break;
  case 'es_PR':
  case 'es-PR':
    defaultSymbols = exports.DurationSymbols_es_PR;
    break;
  case 'es_PY':
  case 'es-PY':
    defaultSymbols = exports.DurationSymbols_es_PY;
    break;
  case 'es_SV':
  case 'es-SV':
    defaultSymbols = exports.DurationSymbols_es_SV;
    break;
  case 'es_UY':
  case 'es-UY':
    defaultSymbols = exports.DurationSymbols_es_UY;
    break;
  case 'es_VE':
  case 'es-VE':
    defaultSymbols = exports.DurationSymbols_es_VE;
    break;
  case 'et_EE':
  case 'et-EE':
    defaultSymbols = exports.DurationSymbols_et_EE;
    break;
  case 'eu_ES':
  case 'eu-ES':
    defaultSymbols = exports.DurationSymbols_eu_ES;
    break;
  case 'ewo':
    defaultSymbols = exports.DurationSymbols_ewo;
    break;
  case 'ewo_CM':
  case 'ewo-CM':
    defaultSymbols = exports.DurationSymbols_ewo_CM;
    break;
  case 'fa_AF':
  case 'fa-AF':
    defaultSymbols = exports.DurationSymbols_fa_AF;
    break;
  case 'fa_IR':
  case 'fa-IR':
    defaultSymbols = exports.DurationSymbols_fa_IR;
    break;
  case 'ff':
    defaultSymbols = exports.DurationSymbols_ff;
    break;
  case 'ff_Adlm':
  case 'ff-Adlm':
    defaultSymbols = exports.DurationSymbols_ff_Adlm;
    break;
  case 'ff_Adlm_BF':
  case 'ff-Adlm-BF':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_BF;
    break;
  case 'ff_Adlm_CM':
  case 'ff-Adlm-CM':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_CM;
    break;
  case 'ff_Adlm_GH':
  case 'ff-Adlm-GH':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_GH;
    break;
  case 'ff_Adlm_GM':
  case 'ff-Adlm-GM':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_GM;
    break;
  case 'ff_Adlm_GN':
  case 'ff-Adlm-GN':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_GN;
    break;
  case 'ff_Adlm_GW':
  case 'ff-Adlm-GW':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_GW;
    break;
  case 'ff_Adlm_LR':
  case 'ff-Adlm-LR':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_LR;
    break;
  case 'ff_Adlm_MR':
  case 'ff-Adlm-MR':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_MR;
    break;
  case 'ff_Adlm_NE':
  case 'ff-Adlm-NE':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_NE;
    break;
  case 'ff_Adlm_NG':
  case 'ff-Adlm-NG':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_NG;
    break;
  case 'ff_Adlm_SL':
  case 'ff-Adlm-SL':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_SL;
    break;
  case 'ff_Adlm_SN':
  case 'ff-Adlm-SN':
    defaultSymbols = exports.DurationSymbols_ff_Adlm_SN;
    break;
  case 'ff_Latn':
  case 'ff-Latn':
    defaultSymbols = exports.DurationSymbols_ff_Latn;
    break;
  case 'ff_Latn_BF':
  case 'ff-Latn-BF':
    defaultSymbols = exports.DurationSymbols_ff_Latn_BF;
    break;
  case 'ff_Latn_CM':
  case 'ff-Latn-CM':
    defaultSymbols = exports.DurationSymbols_ff_Latn_CM;
    break;
  case 'ff_Latn_GH':
  case 'ff-Latn-GH':
    defaultSymbols = exports.DurationSymbols_ff_Latn_GH;
    break;
  case 'ff_Latn_GM':
  case 'ff-Latn-GM':
    defaultSymbols = exports.DurationSymbols_ff_Latn_GM;
    break;
  case 'ff_Latn_GN':
  case 'ff-Latn-GN':
    defaultSymbols = exports.DurationSymbols_ff_Latn_GN;
    break;
  case 'ff_Latn_GW':
  case 'ff-Latn-GW':
    defaultSymbols = exports.DurationSymbols_ff_Latn_GW;
    break;
  case 'ff_Latn_LR':
  case 'ff-Latn-LR':
    defaultSymbols = exports.DurationSymbols_ff_Latn_LR;
    break;
  case 'ff_Latn_MR':
  case 'ff-Latn-MR':
    defaultSymbols = exports.DurationSymbols_ff_Latn_MR;
    break;
  case 'ff_Latn_NE':
  case 'ff-Latn-NE':
    defaultSymbols = exports.DurationSymbols_ff_Latn_NE;
    break;
  case 'ff_Latn_NG':
  case 'ff-Latn-NG':
    defaultSymbols = exports.DurationSymbols_ff_Latn_NG;
    break;
  case 'ff_Latn_SL':
  case 'ff-Latn-SL':
    defaultSymbols = exports.DurationSymbols_ff_Latn_SL;
    break;
  case 'ff_Latn_SN':
  case 'ff-Latn-SN':
    defaultSymbols = exports.DurationSymbols_ff_Latn_SN;
    break;
  case 'fi_FI':
  case 'fi-FI':
    defaultSymbols = exports.DurationSymbols_fi_FI;
    break;
  case 'fil_PH':
  case 'fil-PH':
    defaultSymbols = exports.DurationSymbols_fil_PH;
    break;
  case 'fo':
    defaultSymbols = exports.DurationSymbols_fo;
    break;
  case 'fo_DK':
  case 'fo-DK':
    defaultSymbols = exports.DurationSymbols_fo_DK;
    break;
  case 'fo_FO':
  case 'fo-FO':
    defaultSymbols = exports.DurationSymbols_fo_FO;
    break;
  case 'fr_BE':
  case 'fr-BE':
    defaultSymbols = exports.DurationSymbols_fr_BE;
    break;
  case 'fr_BF':
  case 'fr-BF':
    defaultSymbols = exports.DurationSymbols_fr_BF;
    break;
  case 'fr_BI':
  case 'fr-BI':
    defaultSymbols = exports.DurationSymbols_fr_BI;
    break;
  case 'fr_BJ':
  case 'fr-BJ':
    defaultSymbols = exports.DurationSymbols_fr_BJ;
    break;
  case 'fr_BL':
  case 'fr-BL':
    defaultSymbols = exports.DurationSymbols_fr_BL;
    break;
  case 'fr_CD':
  case 'fr-CD':
    defaultSymbols = exports.DurationSymbols_fr_CD;
    break;
  case 'fr_CF':
  case 'fr-CF':
    defaultSymbols = exports.DurationSymbols_fr_CF;
    break;
  case 'fr_CG':
  case 'fr-CG':
    defaultSymbols = exports.DurationSymbols_fr_CG;
    break;
  case 'fr_CH':
  case 'fr-CH':
    defaultSymbols = exports.DurationSymbols_fr_CH;
    break;
  case 'fr_CI':
  case 'fr-CI':
    defaultSymbols = exports.DurationSymbols_fr_CI;
    break;
  case 'fr_CM':
  case 'fr-CM':
    defaultSymbols = exports.DurationSymbols_fr_CM;
    break;
  case 'fr_DJ':
  case 'fr-DJ':
    defaultSymbols = exports.DurationSymbols_fr_DJ;
    break;
  case 'fr_DZ':
  case 'fr-DZ':
    defaultSymbols = exports.DurationSymbols_fr_DZ;
    break;
  case 'fr_FR':
  case 'fr-FR':
    defaultSymbols = exports.DurationSymbols_fr_FR;
    break;
  case 'fr_GA':
  case 'fr-GA':
    defaultSymbols = exports.DurationSymbols_fr_GA;
    break;
  case 'fr_GF':
  case 'fr-GF':
    defaultSymbols = exports.DurationSymbols_fr_GF;
    break;
  case 'fr_GN':
  case 'fr-GN':
    defaultSymbols = exports.DurationSymbols_fr_GN;
    break;
  case 'fr_GP':
  case 'fr-GP':
    defaultSymbols = exports.DurationSymbols_fr_GP;
    break;
  case 'fr_GQ':
  case 'fr-GQ':
    defaultSymbols = exports.DurationSymbols_fr_GQ;
    break;
  case 'fr_HT':
  case 'fr-HT':
    defaultSymbols = exports.DurationSymbols_fr_HT;
    break;
  case 'fr_KM':
  case 'fr-KM':
    defaultSymbols = exports.DurationSymbols_fr_KM;
    break;
  case 'fr_LU':
  case 'fr-LU':
    defaultSymbols = exports.DurationSymbols_fr_LU;
    break;
  case 'fr_MA':
  case 'fr-MA':
    defaultSymbols = exports.DurationSymbols_fr_MA;
    break;
  case 'fr_MC':
  case 'fr-MC':
    defaultSymbols = exports.DurationSymbols_fr_MC;
    break;
  case 'fr_MF':
  case 'fr-MF':
    defaultSymbols = exports.DurationSymbols_fr_MF;
    break;
  case 'fr_MG':
  case 'fr-MG':
    defaultSymbols = exports.DurationSymbols_fr_MG;
    break;
  case 'fr_ML':
  case 'fr-ML':
    defaultSymbols = exports.DurationSymbols_fr_ML;
    break;
  case 'fr_MQ':
  case 'fr-MQ':
    defaultSymbols = exports.DurationSymbols_fr_MQ;
    break;
  case 'fr_MR':
  case 'fr-MR':
    defaultSymbols = exports.DurationSymbols_fr_MR;
    break;
  case 'fr_MU':
  case 'fr-MU':
    defaultSymbols = exports.DurationSymbols_fr_MU;
    break;
  case 'fr_NC':
  case 'fr-NC':
    defaultSymbols = exports.DurationSymbols_fr_NC;
    break;
  case 'fr_NE':
  case 'fr-NE':
    defaultSymbols = exports.DurationSymbols_fr_NE;
    break;
  case 'fr_PF':
  case 'fr-PF':
    defaultSymbols = exports.DurationSymbols_fr_PF;
    break;
  case 'fr_PM':
  case 'fr-PM':
    defaultSymbols = exports.DurationSymbols_fr_PM;
    break;
  case 'fr_RE':
  case 'fr-RE':
    defaultSymbols = exports.DurationSymbols_fr_RE;
    break;
  case 'fr_RW':
  case 'fr-RW':
    defaultSymbols = exports.DurationSymbols_fr_RW;
    break;
  case 'fr_SC':
  case 'fr-SC':
    defaultSymbols = exports.DurationSymbols_fr_SC;
    break;
  case 'fr_SN':
  case 'fr-SN':
    defaultSymbols = exports.DurationSymbols_fr_SN;
    break;
  case 'fr_SY':
  case 'fr-SY':
    defaultSymbols = exports.DurationSymbols_fr_SY;
    break;
  case 'fr_TD':
  case 'fr-TD':
    defaultSymbols = exports.DurationSymbols_fr_TD;
    break;
  case 'fr_TG':
  case 'fr-TG':
    defaultSymbols = exports.DurationSymbols_fr_TG;
    break;
  case 'fr_TN':
  case 'fr-TN':
    defaultSymbols = exports.DurationSymbols_fr_TN;
    break;
  case 'fr_VU':
  case 'fr-VU':
    defaultSymbols = exports.DurationSymbols_fr_VU;
    break;
  case 'fr_WF':
  case 'fr-WF':
    defaultSymbols = exports.DurationSymbols_fr_WF;
    break;
  case 'fr_YT':
  case 'fr-YT':
    defaultSymbols = exports.DurationSymbols_fr_YT;
    break;
  case 'fur':
    defaultSymbols = exports.DurationSymbols_fur;
    break;
  case 'fur_IT':
  case 'fur-IT':
    defaultSymbols = exports.DurationSymbols_fur_IT;
    break;
  case 'fy':
    defaultSymbols = exports.DurationSymbols_fy;
    break;
  case 'fy_NL':
  case 'fy-NL':
    defaultSymbols = exports.DurationSymbols_fy_NL;
    break;
  case 'ga_GB':
  case 'ga-GB':
    defaultSymbols = exports.DurationSymbols_ga_GB;
    break;
  case 'ga_IE':
  case 'ga-IE':
    defaultSymbols = exports.DurationSymbols_ga_IE;
    break;
  case 'gd':
    defaultSymbols = exports.DurationSymbols_gd;
    break;
  case 'gd_GB':
  case 'gd-GB':
    defaultSymbols = exports.DurationSymbols_gd_GB;
    break;
  case 'gl_ES':
  case 'gl-ES':
    defaultSymbols = exports.DurationSymbols_gl_ES;
    break;
  case 'gsw_CH':
  case 'gsw-CH':
    defaultSymbols = exports.DurationSymbols_gsw_CH;
    break;
  case 'gsw_FR':
  case 'gsw-FR':
    defaultSymbols = exports.DurationSymbols_gsw_FR;
    break;
  case 'gsw_LI':
  case 'gsw-LI':
    defaultSymbols = exports.DurationSymbols_gsw_LI;
    break;
  case 'gu_IN':
  case 'gu-IN':
    defaultSymbols = exports.DurationSymbols_gu_IN;
    break;
  case 'guz':
    defaultSymbols = exports.DurationSymbols_guz;
    break;
  case 'guz_KE':
  case 'guz-KE':
    defaultSymbols = exports.DurationSymbols_guz_KE;
    break;
  case 'gv':
    defaultSymbols = exports.DurationSymbols_gv;
    break;
  case 'gv_IM':
  case 'gv-IM':
    defaultSymbols = exports.DurationSymbols_gv_IM;
    break;
  case 'ha':
    defaultSymbols = exports.DurationSymbols_ha;
    break;
  case 'ha_GH':
  case 'ha-GH':
    defaultSymbols = exports.DurationSymbols_ha_GH;
    break;
  case 'ha_NE':
  case 'ha-NE':
    defaultSymbols = exports.DurationSymbols_ha_NE;
    break;
  case 'ha_NG':
  case 'ha-NG':
    defaultSymbols = exports.DurationSymbols_ha_NG;
    break;
  case 'haw_US':
  case 'haw-US':
    defaultSymbols = exports.DurationSymbols_haw_US;
    break;
  case 'he_IL':
  case 'he-IL':
    defaultSymbols = exports.DurationSymbols_he_IL;
    break;
  case 'hi_IN':
  case 'hi-IN':
    defaultSymbols = exports.DurationSymbols_hi_IN;
    break;
  case 'hi_Latn':
  case 'hi-Latn':
    defaultSymbols = exports.DurationSymbols_hi_Latn;
    break;
  case 'hi_Latn_IN':
  case 'hi-Latn-IN':
    defaultSymbols = exports.DurationSymbols_hi_Latn_IN;
    break;
  case 'hr_BA':
  case 'hr-BA':
    defaultSymbols = exports.DurationSymbols_hr_BA;
    break;
  case 'hr_HR':
  case 'hr-HR':
    defaultSymbols = exports.DurationSymbols_hr_HR;
    break;
  case 'hsb':
    defaultSymbols = exports.DurationSymbols_hsb;
    break;
  case 'hsb_DE':
  case 'hsb-DE':
    defaultSymbols = exports.DurationSymbols_hsb_DE;
    break;
  case 'hu_HU':
  case 'hu-HU':
    defaultSymbols = exports.DurationSymbols_hu_HU;
    break;
  case 'hy_AM':
  case 'hy-AM':
    defaultSymbols = exports.DurationSymbols_hy_AM;
    break;
  case 'ia':
    defaultSymbols = exports.DurationSymbols_ia;
    break;
  case 'ia_001':
  case 'ia-001':
    defaultSymbols = exports.DurationSymbols_ia_001;
    break;
  case 'id_ID':
  case 'id-ID':
    defaultSymbols = exports.DurationSymbols_id_ID;
    break;
  case 'ig':
    defaultSymbols = exports.DurationSymbols_ig;
    break;
  case 'ig_NG':
  case 'ig-NG':
    defaultSymbols = exports.DurationSymbols_ig_NG;
    break;
  case 'ii':
    defaultSymbols = exports.DurationSymbols_ii;
    break;
  case 'ii_CN':
  case 'ii-CN':
    defaultSymbols = exports.DurationSymbols_ii_CN;
    break;
  case 'is_IS':
  case 'is-IS':
    defaultSymbols = exports.DurationSymbols_is_IS;
    break;
  case 'it_CH':
  case 'it-CH':
    defaultSymbols = exports.DurationSymbols_it_CH;
    break;
  case 'it_IT':
  case 'it-IT':
    defaultSymbols = exports.DurationSymbols_it_IT;
    break;
  case 'it_SM':
  case 'it-SM':
    defaultSymbols = exports.DurationSymbols_it_SM;
    break;
  case 'it_VA':
  case 'it-VA':
    defaultSymbols = exports.DurationSymbols_it_VA;
    break;
  case 'ja_JP':
  case 'ja-JP':
    defaultSymbols = exports.DurationSymbols_ja_JP;
    break;
  case 'jgo':
    defaultSymbols = exports.DurationSymbols_jgo;
    break;
  case 'jgo_CM':
  case 'jgo-CM':
    defaultSymbols = exports.DurationSymbols_jgo_CM;
    break;
  case 'jmc':
    defaultSymbols = exports.DurationSymbols_jmc;
    break;
  case 'jmc_TZ':
  case 'jmc-TZ':
    defaultSymbols = exports.DurationSymbols_jmc_TZ;
    break;
  case 'jv':
    defaultSymbols = exports.DurationSymbols_jv;
    break;
  case 'jv_ID':
  case 'jv-ID':
    defaultSymbols = exports.DurationSymbols_jv_ID;
    break;
  case 'ka_GE':
  case 'ka-GE':
    defaultSymbols = exports.DurationSymbols_ka_GE;
    break;
  case 'kab':
    defaultSymbols = exports.DurationSymbols_kab;
    break;
  case 'kab_DZ':
  case 'kab-DZ':
    defaultSymbols = exports.DurationSymbols_kab_DZ;
    break;
  case 'kam':
    defaultSymbols = exports.DurationSymbols_kam;
    break;
  case 'kam_KE':
  case 'kam-KE':
    defaultSymbols = exports.DurationSymbols_kam_KE;
    break;
  case 'kde':
    defaultSymbols = exports.DurationSymbols_kde;
    break;
  case 'kde_TZ':
  case 'kde-TZ':
    defaultSymbols = exports.DurationSymbols_kde_TZ;
    break;
  case 'kea':
    defaultSymbols = exports.DurationSymbols_kea;
    break;
  case 'kea_CV':
  case 'kea-CV':
    defaultSymbols = exports.DurationSymbols_kea_CV;
    break;
  case 'kgp':
    defaultSymbols = exports.DurationSymbols_kgp;
    break;
  case 'kgp_BR':
  case 'kgp-BR':
    defaultSymbols = exports.DurationSymbols_kgp_BR;
    break;
  case 'khq':
    defaultSymbols = exports.DurationSymbols_khq;
    break;
  case 'khq_ML':
  case 'khq-ML':
    defaultSymbols = exports.DurationSymbols_khq_ML;
    break;
  case 'ki':
    defaultSymbols = exports.DurationSymbols_ki;
    break;
  case 'ki_KE':
  case 'ki-KE':
    defaultSymbols = exports.DurationSymbols_ki_KE;
    break;
  case 'kk_KZ':
  case 'kk-KZ':
    defaultSymbols = exports.DurationSymbols_kk_KZ;
    break;
  case 'kkj':
    defaultSymbols = exports.DurationSymbols_kkj;
    break;
  case 'kkj_CM':
  case 'kkj-CM':
    defaultSymbols = exports.DurationSymbols_kkj_CM;
    break;
  case 'kl':
    defaultSymbols = exports.DurationSymbols_kl;
    break;
  case 'kl_GL':
  case 'kl-GL':
    defaultSymbols = exports.DurationSymbols_kl_GL;
    break;
  case 'kln':
    defaultSymbols = exports.DurationSymbols_kln;
    break;
  case 'kln_KE':
  case 'kln-KE':
    defaultSymbols = exports.DurationSymbols_kln_KE;
    break;
  case 'km_KH':
  case 'km-KH':
    defaultSymbols = exports.DurationSymbols_km_KH;
    break;
  case 'kn_IN':
  case 'kn-IN':
    defaultSymbols = exports.DurationSymbols_kn_IN;
    break;
  case 'ko_KP':
  case 'ko-KP':
    defaultSymbols = exports.DurationSymbols_ko_KP;
    break;
  case 'ko_KR':
  case 'ko-KR':
    defaultSymbols = exports.DurationSymbols_ko_KR;
    break;
  case 'kok':
    defaultSymbols = exports.DurationSymbols_kok;
    break;
  case 'kok_IN':
  case 'kok-IN':
    defaultSymbols = exports.DurationSymbols_kok_IN;
    break;
  case 'ks':
    defaultSymbols = exports.DurationSymbols_ks;
    break;
  case 'ks_Arab':
  case 'ks-Arab':
    defaultSymbols = exports.DurationSymbols_ks_Arab;
    break;
  case 'ks_Arab_IN':
  case 'ks-Arab-IN':
    defaultSymbols = exports.DurationSymbols_ks_Arab_IN;
    break;
  case 'ks_Deva':
  case 'ks-Deva':
    defaultSymbols = exports.DurationSymbols_ks_Deva;
    break;
  case 'ks_Deva_IN':
  case 'ks-Deva-IN':
    defaultSymbols = exports.DurationSymbols_ks_Deva_IN;
    break;
  case 'ksb':
    defaultSymbols = exports.DurationSymbols_ksb;
    break;
  case 'ksb_TZ':
  case 'ksb-TZ':
    defaultSymbols = exports.DurationSymbols_ksb_TZ;
    break;
  case 'ksf':
    defaultSymbols = exports.DurationSymbols_ksf;
    break;
  case 'ksf_CM':
  case 'ksf-CM':
    defaultSymbols = exports.DurationSymbols_ksf_CM;
    break;
  case 'ksh':
    defaultSymbols = exports.DurationSymbols_ksh;
    break;
  case 'ksh_DE':
  case 'ksh-DE':
    defaultSymbols = exports.DurationSymbols_ksh_DE;
    break;
  case 'ku':
    defaultSymbols = exports.DurationSymbols_ku;
    break;
  case 'ku_TR':
  case 'ku-TR':
    defaultSymbols = exports.DurationSymbols_ku_TR;
    break;
  case 'kw':
    defaultSymbols = exports.DurationSymbols_kw;
    break;
  case 'kw_GB':
  case 'kw-GB':
    defaultSymbols = exports.DurationSymbols_kw_GB;
    break;
  case 'ky_KG':
  case 'ky-KG':
    defaultSymbols = exports.DurationSymbols_ky_KG;
    break;
  case 'lag':
    defaultSymbols = exports.DurationSymbols_lag;
    break;
  case 'lag_TZ':
  case 'lag-TZ':
    defaultSymbols = exports.DurationSymbols_lag_TZ;
    break;
  case 'lb':
    defaultSymbols = exports.DurationSymbols_lb;
    break;
  case 'lb_LU':
  case 'lb-LU':
    defaultSymbols = exports.DurationSymbols_lb_LU;
    break;
  case 'lg':
    defaultSymbols = exports.DurationSymbols_lg;
    break;
  case 'lg_UG':
  case 'lg-UG':
    defaultSymbols = exports.DurationSymbols_lg_UG;
    break;
  case 'lkt':
    defaultSymbols = exports.DurationSymbols_lkt;
    break;
  case 'lkt_US':
  case 'lkt-US':
    defaultSymbols = exports.DurationSymbols_lkt_US;
    break;
  case 'ln_AO':
  case 'ln-AO':
    defaultSymbols = exports.DurationSymbols_ln_AO;
    break;
  case 'ln_CD':
  case 'ln-CD':
    defaultSymbols = exports.DurationSymbols_ln_CD;
    break;
  case 'ln_CF':
  case 'ln-CF':
    defaultSymbols = exports.DurationSymbols_ln_CF;
    break;
  case 'ln_CG':
  case 'ln-CG':
    defaultSymbols = exports.DurationSymbols_ln_CG;
    break;
  case 'lo_LA':
  case 'lo-LA':
    defaultSymbols = exports.DurationSymbols_lo_LA;
    break;
  case 'lrc':
    defaultSymbols = exports.DurationSymbols_lrc;
    break;
  case 'lrc_IQ':
  case 'lrc-IQ':
    defaultSymbols = exports.DurationSymbols_lrc_IQ;
    break;
  case 'lrc_IR':
  case 'lrc-IR':
    defaultSymbols = exports.DurationSymbols_lrc_IR;
    break;
  case 'lt_LT':
  case 'lt-LT':
    defaultSymbols = exports.DurationSymbols_lt_LT;
    break;
  case 'lu':
    defaultSymbols = exports.DurationSymbols_lu;
    break;
  case 'lu_CD':
  case 'lu-CD':
    defaultSymbols = exports.DurationSymbols_lu_CD;
    break;
  case 'luo':
    defaultSymbols = exports.DurationSymbols_luo;
    break;
  case 'luo_KE':
  case 'luo-KE':
    defaultSymbols = exports.DurationSymbols_luo_KE;
    break;
  case 'luy':
    defaultSymbols = exports.DurationSymbols_luy;
    break;
  case 'luy_KE':
  case 'luy-KE':
    defaultSymbols = exports.DurationSymbols_luy_KE;
    break;
  case 'lv_LV':
  case 'lv-LV':
    defaultSymbols = exports.DurationSymbols_lv_LV;
    break;
  case 'mai':
    defaultSymbols = exports.DurationSymbols_mai;
    break;
  case 'mai_IN':
  case 'mai-IN':
    defaultSymbols = exports.DurationSymbols_mai_IN;
    break;
  case 'mas':
    defaultSymbols = exports.DurationSymbols_mas;
    break;
  case 'mas_KE':
  case 'mas-KE':
    defaultSymbols = exports.DurationSymbols_mas_KE;
    break;
  case 'mas_TZ':
  case 'mas-TZ':
    defaultSymbols = exports.DurationSymbols_mas_TZ;
    break;
  case 'mer':
    defaultSymbols = exports.DurationSymbols_mer;
    break;
  case 'mer_KE':
  case 'mer-KE':
    defaultSymbols = exports.DurationSymbols_mer_KE;
    break;
  case 'mfe':
    defaultSymbols = exports.DurationSymbols_mfe;
    break;
  case 'mfe_MU':
  case 'mfe-MU':
    defaultSymbols = exports.DurationSymbols_mfe_MU;
    break;
  case 'mg':
    defaultSymbols = exports.DurationSymbols_mg;
    break;
  case 'mg_MG':
  case 'mg-MG':
    defaultSymbols = exports.DurationSymbols_mg_MG;
    break;
  case 'mgh':
    defaultSymbols = exports.DurationSymbols_mgh;
    break;
  case 'mgh_MZ':
  case 'mgh-MZ':
    defaultSymbols = exports.DurationSymbols_mgh_MZ;
    break;
  case 'mgo':
    defaultSymbols = exports.DurationSymbols_mgo;
    break;
  case 'mgo_CM':
  case 'mgo-CM':
    defaultSymbols = exports.DurationSymbols_mgo_CM;
    break;
  case 'mi':
    defaultSymbols = exports.DurationSymbols_mi;
    break;
  case 'mi_NZ':
  case 'mi-NZ':
    defaultSymbols = exports.DurationSymbols_mi_NZ;
    break;
  case 'mk_MK':
  case 'mk-MK':
    defaultSymbols = exports.DurationSymbols_mk_MK;
    break;
  case 'ml_IN':
  case 'ml-IN':
    defaultSymbols = exports.DurationSymbols_ml_IN;
    break;
  case 'mn_MN':
  case 'mn-MN':
    defaultSymbols = exports.DurationSymbols_mn_MN;
    break;
  case 'mni':
    defaultSymbols = exports.DurationSymbols_mni;
    break;
  case 'mni_Beng':
  case 'mni-Beng':
    defaultSymbols = exports.DurationSymbols_mni_Beng;
    break;
  case 'mni_Beng_IN':
  case 'mni-Beng-IN':
    defaultSymbols = exports.DurationSymbols_mni_Beng_IN;
    break;
  case 'mr_IN':
  case 'mr-IN':
    defaultSymbols = exports.DurationSymbols_mr_IN;
    break;
  case 'ms_BN':
  case 'ms-BN':
    defaultSymbols = exports.DurationSymbols_ms_BN;
    break;
  case 'ms_ID':
  case 'ms-ID':
    defaultSymbols = exports.DurationSymbols_ms_ID;
    break;
  case 'ms_MY':
  case 'ms-MY':
    defaultSymbols = exports.DurationSymbols_ms_MY;
    break;
  case 'ms_SG':
  case 'ms-SG':
    defaultSymbols = exports.DurationSymbols_ms_SG;
    break;
  case 'mt_MT':
  case 'mt-MT':
    defaultSymbols = exports.DurationSymbols_mt_MT;
    break;
  case 'mua':
    defaultSymbols = exports.DurationSymbols_mua;
    break;
  case 'mua_CM':
  case 'mua-CM':
    defaultSymbols = exports.DurationSymbols_mua_CM;
    break;
  case 'my_MM':
  case 'my-MM':
    defaultSymbols = exports.DurationSymbols_my_MM;
    break;
  case 'mzn':
    defaultSymbols = exports.DurationSymbols_mzn;
    break;
  case 'mzn_IR':
  case 'mzn-IR':
    defaultSymbols = exports.DurationSymbols_mzn_IR;
    break;
  case 'naq':
    defaultSymbols = exports.DurationSymbols_naq;
    break;
  case 'naq_NA':
  case 'naq-NA':
    defaultSymbols = exports.DurationSymbols_naq_NA;
    break;
  case 'nb_NO':
  case 'nb-NO':
    defaultSymbols = exports.DurationSymbols_nb_NO;
    break;
  case 'nb_SJ':
  case 'nb-SJ':
    defaultSymbols = exports.DurationSymbols_nb_SJ;
    break;
  case 'nd':
    defaultSymbols = exports.DurationSymbols_nd;
    break;
  case 'nd_ZW':
  case 'nd-ZW':
    defaultSymbols = exports.DurationSymbols_nd_ZW;
    break;
  case 'ne_IN':
  case 'ne-IN':
    defaultSymbols = exports.DurationSymbols_ne_IN;
    break;
  case 'ne_NP':
  case 'ne-NP':
    defaultSymbols = exports.DurationSymbols_ne_NP;
    break;
  case 'nl_AW':
  case 'nl-AW':
    defaultSymbols = exports.DurationSymbols_nl_AW;
    break;
  case 'nl_BE':
  case 'nl-BE':
    defaultSymbols = exports.DurationSymbols_nl_BE;
    break;
  case 'nl_BQ':
  case 'nl-BQ':
    defaultSymbols = exports.DurationSymbols_nl_BQ;
    break;
  case 'nl_CW':
  case 'nl-CW':
    defaultSymbols = exports.DurationSymbols_nl_CW;
    break;
  case 'nl_NL':
  case 'nl-NL':
    defaultSymbols = exports.DurationSymbols_nl_NL;
    break;
  case 'nl_SR':
  case 'nl-SR':
    defaultSymbols = exports.DurationSymbols_nl_SR;
    break;
  case 'nl_SX':
  case 'nl-SX':
    defaultSymbols = exports.DurationSymbols_nl_SX;
    break;
  case 'nmg':
    defaultSymbols = exports.DurationSymbols_nmg;
    break;
  case 'nmg_CM':
  case 'nmg-CM':
    defaultSymbols = exports.DurationSymbols_nmg_CM;
    break;
  case 'nn':
    defaultSymbols = exports.DurationSymbols_nn;
    break;
  case 'nn_NO':
  case 'nn-NO':
    defaultSymbols = exports.DurationSymbols_nn_NO;
    break;
  case 'nnh':
    defaultSymbols = exports.DurationSymbols_nnh;
    break;
  case 'nnh_CM':
  case 'nnh-CM':
    defaultSymbols = exports.DurationSymbols_nnh_CM;
    break;
  case 'nus':
    defaultSymbols = exports.DurationSymbols_nus;
    break;
  case 'nus_SS':
  case 'nus-SS':
    defaultSymbols = exports.DurationSymbols_nus_SS;
    break;
  case 'nyn':
    defaultSymbols = exports.DurationSymbols_nyn;
    break;
  case 'nyn_UG':
  case 'nyn-UG':
    defaultSymbols = exports.DurationSymbols_nyn_UG;
    break;
  case 'om':
    defaultSymbols = exports.DurationSymbols_om;
    break;
  case 'om_ET':
  case 'om-ET':
    defaultSymbols = exports.DurationSymbols_om_ET;
    break;
  case 'om_KE':
  case 'om-KE':
    defaultSymbols = exports.DurationSymbols_om_KE;
    break;
  case 'or_IN':
  case 'or-IN':
    defaultSymbols = exports.DurationSymbols_or_IN;
    break;
  case 'os':
    defaultSymbols = exports.DurationSymbols_os;
    break;
  case 'os_GE':
  case 'os-GE':
    defaultSymbols = exports.DurationSymbols_os_GE;
    break;
  case 'os_RU':
  case 'os-RU':
    defaultSymbols = exports.DurationSymbols_os_RU;
    break;
  case 'pa_Arab':
  case 'pa-Arab':
    defaultSymbols = exports.DurationSymbols_pa_Arab;
    break;
  case 'pa_Arab_PK':
  case 'pa-Arab-PK':
    defaultSymbols = exports.DurationSymbols_pa_Arab_PK;
    break;
  case 'pa_Guru':
  case 'pa-Guru':
    defaultSymbols = exports.DurationSymbols_pa_Guru;
    break;
  case 'pa_Guru_IN':
  case 'pa-Guru-IN':
    defaultSymbols = exports.DurationSymbols_pa_Guru_IN;
    break;
  case 'pcm':
    defaultSymbols = exports.DurationSymbols_pcm;
    break;
  case 'pcm_NG':
  case 'pcm-NG':
    defaultSymbols = exports.DurationSymbols_pcm_NG;
    break;
  case 'pl_PL':
  case 'pl-PL':
    defaultSymbols = exports.DurationSymbols_pl_PL;
    break;
  case 'ps':
    defaultSymbols = exports.DurationSymbols_ps;
    break;
  case 'ps_AF':
  case 'ps-AF':
    defaultSymbols = exports.DurationSymbols_ps_AF;
    break;
  case 'ps_PK':
  case 'ps-PK':
    defaultSymbols = exports.DurationSymbols_ps_PK;
    break;
  case 'pt_AO':
  case 'pt-AO':
    defaultSymbols = exports.DurationSymbols_pt_AO;
    break;
  case 'pt_CH':
  case 'pt-CH':
    defaultSymbols = exports.DurationSymbols_pt_CH;
    break;
  case 'pt_CV':
  case 'pt-CV':
    defaultSymbols = exports.DurationSymbols_pt_CV;
    break;
  case 'pt_GQ':
  case 'pt-GQ':
    defaultSymbols = exports.DurationSymbols_pt_GQ;
    break;
  case 'pt_GW':
  case 'pt-GW':
    defaultSymbols = exports.DurationSymbols_pt_GW;
    break;
  case 'pt_LU':
  case 'pt-LU':
    defaultSymbols = exports.DurationSymbols_pt_LU;
    break;
  case 'pt_MO':
  case 'pt-MO':
    defaultSymbols = exports.DurationSymbols_pt_MO;
    break;
  case 'pt_MZ':
  case 'pt-MZ':
    defaultSymbols = exports.DurationSymbols_pt_MZ;
    break;
  case 'pt_ST':
  case 'pt-ST':
    defaultSymbols = exports.DurationSymbols_pt_ST;
    break;
  case 'pt_TL':
  case 'pt-TL':
    defaultSymbols = exports.DurationSymbols_pt_TL;
    break;
  case 'qu':
    defaultSymbols = exports.DurationSymbols_qu;
    break;
  case 'qu_BO':
  case 'qu-BO':
    defaultSymbols = exports.DurationSymbols_qu_BO;
    break;
  case 'qu_EC':
  case 'qu-EC':
    defaultSymbols = exports.DurationSymbols_qu_EC;
    break;
  case 'qu_PE':
  case 'qu-PE':
    defaultSymbols = exports.DurationSymbols_qu_PE;
    break;
  case 'rm':
    defaultSymbols = exports.DurationSymbols_rm;
    break;
  case 'rm_CH':
  case 'rm-CH':
    defaultSymbols = exports.DurationSymbols_rm_CH;
    break;
  case 'rn':
    defaultSymbols = exports.DurationSymbols_rn;
    break;
  case 'rn_BI':
  case 'rn-BI':
    defaultSymbols = exports.DurationSymbols_rn_BI;
    break;
  case 'ro_MD':
  case 'ro-MD':
    defaultSymbols = exports.DurationSymbols_ro_MD;
    break;
  case 'ro_RO':
  case 'ro-RO':
    defaultSymbols = exports.DurationSymbols_ro_RO;
    break;
  case 'rof':
    defaultSymbols = exports.DurationSymbols_rof;
    break;
  case 'rof_TZ':
  case 'rof-TZ':
    defaultSymbols = exports.DurationSymbols_rof_TZ;
    break;
  case 'ru_BY':
  case 'ru-BY':
    defaultSymbols = exports.DurationSymbols_ru_BY;
    break;
  case 'ru_KG':
  case 'ru-KG':
    defaultSymbols = exports.DurationSymbols_ru_KG;
    break;
  case 'ru_KZ':
  case 'ru-KZ':
    defaultSymbols = exports.DurationSymbols_ru_KZ;
    break;
  case 'ru_MD':
  case 'ru-MD':
    defaultSymbols = exports.DurationSymbols_ru_MD;
    break;
  case 'ru_RU':
  case 'ru-RU':
    defaultSymbols = exports.DurationSymbols_ru_RU;
    break;
  case 'ru_UA':
  case 'ru-UA':
    defaultSymbols = exports.DurationSymbols_ru_UA;
    break;
  case 'rw':
    defaultSymbols = exports.DurationSymbols_rw;
    break;
  case 'rw_RW':
  case 'rw-RW':
    defaultSymbols = exports.DurationSymbols_rw_RW;
    break;
  case 'rwk':
    defaultSymbols = exports.DurationSymbols_rwk;
    break;
  case 'rwk_TZ':
  case 'rwk-TZ':
    defaultSymbols = exports.DurationSymbols_rwk_TZ;
    break;
  case 'sa':
    defaultSymbols = exports.DurationSymbols_sa;
    break;
  case 'sa_IN':
  case 'sa-IN':
    defaultSymbols = exports.DurationSymbols_sa_IN;
    break;
  case 'sah':
    defaultSymbols = exports.DurationSymbols_sah;
    break;
  case 'sah_RU':
  case 'sah-RU':
    defaultSymbols = exports.DurationSymbols_sah_RU;
    break;
  case 'saq':
    defaultSymbols = exports.DurationSymbols_saq;
    break;
  case 'saq_KE':
  case 'saq-KE':
    defaultSymbols = exports.DurationSymbols_saq_KE;
    break;
  case 'sat':
    defaultSymbols = exports.DurationSymbols_sat;
    break;
  case 'sat_Olck':
  case 'sat-Olck':
    defaultSymbols = exports.DurationSymbols_sat_Olck;
    break;
  case 'sat_Olck_IN':
  case 'sat-Olck-IN':
    defaultSymbols = exports.DurationSymbols_sat_Olck_IN;
    break;
  case 'sbp':
    defaultSymbols = exports.DurationSymbols_sbp;
    break;
  case 'sbp_TZ':
  case 'sbp-TZ':
    defaultSymbols = exports.DurationSymbols_sbp_TZ;
    break;
  case 'sc':
    defaultSymbols = exports.DurationSymbols_sc;
    break;
  case 'sc_IT':
  case 'sc-IT':
    defaultSymbols = exports.DurationSymbols_sc_IT;
    break;
  case 'sd':
    defaultSymbols = exports.DurationSymbols_sd;
    break;
  case 'sd_Arab':
  case 'sd-Arab':
    defaultSymbols = exports.DurationSymbols_sd_Arab;
    break;
  case 'sd_Arab_PK':
  case 'sd-Arab-PK':
    defaultSymbols = exports.DurationSymbols_sd_Arab_PK;
    break;
  case 'sd_Deva':
  case 'sd-Deva':
    defaultSymbols = exports.DurationSymbols_sd_Deva;
    break;
  case 'sd_Deva_IN':
  case 'sd-Deva-IN':
    defaultSymbols = exports.DurationSymbols_sd_Deva_IN;
    break;
  case 'se':
    defaultSymbols = exports.DurationSymbols_se;
    break;
  case 'se_FI':
  case 'se-FI':
    defaultSymbols = exports.DurationSymbols_se_FI;
    break;
  case 'se_NO':
  case 'se-NO':
    defaultSymbols = exports.DurationSymbols_se_NO;
    break;
  case 'se_SE':
  case 'se-SE':
    defaultSymbols = exports.DurationSymbols_se_SE;
    break;
  case 'seh':
    defaultSymbols = exports.DurationSymbols_seh;
    break;
  case 'seh_MZ':
  case 'seh-MZ':
    defaultSymbols = exports.DurationSymbols_seh_MZ;
    break;
  case 'ses':
    defaultSymbols = exports.DurationSymbols_ses;
    break;
  case 'ses_ML':
  case 'ses-ML':
    defaultSymbols = exports.DurationSymbols_ses_ML;
    break;
  case 'sg':
    defaultSymbols = exports.DurationSymbols_sg;
    break;
  case 'sg_CF':
  case 'sg-CF':
    defaultSymbols = exports.DurationSymbols_sg_CF;
    break;
  case 'shi':
    defaultSymbols = exports.DurationSymbols_shi;
    break;
  case 'shi_Latn':
  case 'shi-Latn':
    defaultSymbols = exports.DurationSymbols_shi_Latn;
    break;
  case 'shi_Latn_MA':
  case 'shi-Latn-MA':
    defaultSymbols = exports.DurationSymbols_shi_Latn_MA;
    break;
  case 'shi_Tfng':
  case 'shi-Tfng':
    defaultSymbols = exports.DurationSymbols_shi_Tfng;
    break;
  case 'shi_Tfng_MA':
  case 'shi-Tfng-MA':
    defaultSymbols = exports.DurationSymbols_shi_Tfng_MA;
    break;
  case 'si_LK':
  case 'si-LK':
    defaultSymbols = exports.DurationSymbols_si_LK;
    break;
  case 'sk_SK':
  case 'sk-SK':
    defaultSymbols = exports.DurationSymbols_sk_SK;
    break;
  case 'sl_SI':
  case 'sl-SI':
    defaultSymbols = exports.DurationSymbols_sl_SI;
    break;
  case 'smn':
    defaultSymbols = exports.DurationSymbols_smn;
    break;
  case 'smn_FI':
  case 'smn-FI':
    defaultSymbols = exports.DurationSymbols_smn_FI;
    break;
  case 'sn':
    defaultSymbols = exports.DurationSymbols_sn;
    break;
  case 'sn_ZW':
  case 'sn-ZW':
    defaultSymbols = exports.DurationSymbols_sn_ZW;
    break;
  case 'so':
    defaultSymbols = exports.DurationSymbols_so;
    break;
  case 'so_DJ':
  case 'so-DJ':
    defaultSymbols = exports.DurationSymbols_so_DJ;
    break;
  case 'so_ET':
  case 'so-ET':
    defaultSymbols = exports.DurationSymbols_so_ET;
    break;
  case 'so_KE':
  case 'so-KE':
    defaultSymbols = exports.DurationSymbols_so_KE;
    break;
  case 'so_SO':
  case 'so-SO':
    defaultSymbols = exports.DurationSymbols_so_SO;
    break;
  case 'sq_AL':
  case 'sq-AL':
    defaultSymbols = exports.DurationSymbols_sq_AL;
    break;
  case 'sq_MK':
  case 'sq-MK':
    defaultSymbols = exports.DurationSymbols_sq_MK;
    break;
  case 'sq_XK':
  case 'sq-XK':
    defaultSymbols = exports.DurationSymbols_sq_XK;
    break;
  case 'sr_Cyrl':
  case 'sr-Cyrl':
    defaultSymbols = exports.DurationSymbols_sr_Cyrl;
    break;
  case 'sr_Cyrl_BA':
  case 'sr-Cyrl-BA':
    defaultSymbols = exports.DurationSymbols_sr_Cyrl_BA;
    break;
  case 'sr_Cyrl_ME':
  case 'sr-Cyrl-ME':
    defaultSymbols = exports.DurationSymbols_sr_Cyrl_ME;
    break;
  case 'sr_Cyrl_RS':
  case 'sr-Cyrl-RS':
    defaultSymbols = exports.DurationSymbols_sr_Cyrl_RS;
    break;
  case 'sr_Cyrl_XK':
  case 'sr-Cyrl-XK':
    defaultSymbols = exports.DurationSymbols_sr_Cyrl_XK;
    break;
  case 'sr_Latn_BA':
  case 'sr-Latn-BA':
    defaultSymbols = exports.DurationSymbols_sr_Latn_BA;
    break;
  case 'sr_Latn_ME':
  case 'sr-Latn-ME':
    defaultSymbols = exports.DurationSymbols_sr_Latn_ME;
    break;
  case 'sr_Latn_RS':
  case 'sr-Latn-RS':
    defaultSymbols = exports.DurationSymbols_sr_Latn_RS;
    break;
  case 'sr_Latn_XK':
  case 'sr-Latn-XK':
    defaultSymbols = exports.DurationSymbols_sr_Latn_XK;
    break;
  case 'su':
    defaultSymbols = exports.DurationSymbols_su;
    break;
  case 'su_Latn':
  case 'su-Latn':
    defaultSymbols = exports.DurationSymbols_su_Latn;
    break;
  case 'su_Latn_ID':
  case 'su-Latn-ID':
    defaultSymbols = exports.DurationSymbols_su_Latn_ID;
    break;
  case 'sv_AX':
  case 'sv-AX':
    defaultSymbols = exports.DurationSymbols_sv_AX;
    break;
  case 'sv_FI':
  case 'sv-FI':
    defaultSymbols = exports.DurationSymbols_sv_FI;
    break;
  case 'sv_SE':
  case 'sv-SE':
    defaultSymbols = exports.DurationSymbols_sv_SE;
    break;
  case 'sw_CD':
  case 'sw-CD':
    defaultSymbols = exports.DurationSymbols_sw_CD;
    break;
  case 'sw_KE':
  case 'sw-KE':
    defaultSymbols = exports.DurationSymbols_sw_KE;
    break;
  case 'sw_TZ':
  case 'sw-TZ':
    defaultSymbols = exports.DurationSymbols_sw_TZ;
    break;
  case 'sw_UG':
  case 'sw-UG':
    defaultSymbols = exports.DurationSymbols_sw_UG;
    break;
  case 'ta_IN':
  case 'ta-IN':
    defaultSymbols = exports.DurationSymbols_ta_IN;
    break;
  case 'ta_LK':
  case 'ta-LK':
    defaultSymbols = exports.DurationSymbols_ta_LK;
    break;
  case 'ta_MY':
  case 'ta-MY':
    defaultSymbols = exports.DurationSymbols_ta_MY;
    break;
  case 'ta_SG':
  case 'ta-SG':
    defaultSymbols = exports.DurationSymbols_ta_SG;
    break;
  case 'te_IN':
  case 'te-IN':
    defaultSymbols = exports.DurationSymbols_te_IN;
    break;
  case 'teo':
    defaultSymbols = exports.DurationSymbols_teo;
    break;
  case 'teo_KE':
  case 'teo-KE':
    defaultSymbols = exports.DurationSymbols_teo_KE;
    break;
  case 'teo_UG':
  case 'teo-UG':
    defaultSymbols = exports.DurationSymbols_teo_UG;
    break;
  case 'tg':
    defaultSymbols = exports.DurationSymbols_tg;
    break;
  case 'tg_TJ':
  case 'tg-TJ':
    defaultSymbols = exports.DurationSymbols_tg_TJ;
    break;
  case 'th_TH':
  case 'th-TH':
    defaultSymbols = exports.DurationSymbols_th_TH;
    break;
  case 'ti':
    defaultSymbols = exports.DurationSymbols_ti;
    break;
  case 'ti_ER':
  case 'ti-ER':
    defaultSymbols = exports.DurationSymbols_ti_ER;
    break;
  case 'ti_ET':
  case 'ti-ET':
    defaultSymbols = exports.DurationSymbols_ti_ET;
    break;
  case 'tk':
    defaultSymbols = exports.DurationSymbols_tk;
    break;
  case 'tk_TM':
  case 'tk-TM':
    defaultSymbols = exports.DurationSymbols_tk_TM;
    break;
  case 'to':
    defaultSymbols = exports.DurationSymbols_to;
    break;
  case 'to_TO':
  case 'to-TO':
    defaultSymbols = exports.DurationSymbols_to_TO;
    break;
  case 'tr_CY':
  case 'tr-CY':
    defaultSymbols = exports.DurationSymbols_tr_CY;
    break;
  case 'tr_TR':
  case 'tr-TR':
    defaultSymbols = exports.DurationSymbols_tr_TR;
    break;
  case 'tt':
    defaultSymbols = exports.DurationSymbols_tt;
    break;
  case 'tt_RU':
  case 'tt-RU':
    defaultSymbols = exports.DurationSymbols_tt_RU;
    break;
  case 'twq':
    defaultSymbols = exports.DurationSymbols_twq;
    break;
  case 'twq_NE':
  case 'twq-NE':
    defaultSymbols = exports.DurationSymbols_twq_NE;
    break;
  case 'tzm':
    defaultSymbols = exports.DurationSymbols_tzm;
    break;
  case 'tzm_MA':
  case 'tzm-MA':
    defaultSymbols = exports.DurationSymbols_tzm_MA;
    break;
  case 'ug':
    defaultSymbols = exports.DurationSymbols_ug;
    break;
  case 'ug_CN':
  case 'ug-CN':
    defaultSymbols = exports.DurationSymbols_ug_CN;
    break;
  case 'uk_UA':
  case 'uk-UA':
    defaultSymbols = exports.DurationSymbols_uk_UA;
    break;
  case 'ur_IN':
  case 'ur-IN':
    defaultSymbols = exports.DurationSymbols_ur_IN;
    break;
  case 'ur_PK':
  case 'ur-PK':
    defaultSymbols = exports.DurationSymbols_ur_PK;
    break;
  case 'uz_Arab':
  case 'uz-Arab':
    defaultSymbols = exports.DurationSymbols_uz_Arab;
    break;
  case 'uz_Arab_AF':
  case 'uz-Arab-AF':
    defaultSymbols = exports.DurationSymbols_uz_Arab_AF;
    break;
  case 'uz_Cyrl':
  case 'uz-Cyrl':
    defaultSymbols = exports.DurationSymbols_uz_Cyrl;
    break;
  case 'uz_Cyrl_UZ':
  case 'uz-Cyrl-UZ':
    defaultSymbols = exports.DurationSymbols_uz_Cyrl_UZ;
    break;
  case 'uz_Latn':
  case 'uz-Latn':
    defaultSymbols = exports.DurationSymbols_uz_Latn;
    break;
  case 'uz_Latn_UZ':
  case 'uz-Latn-UZ':
    defaultSymbols = exports.DurationSymbols_uz_Latn_UZ;
    break;
  case 'vai':
    defaultSymbols = exports.DurationSymbols_vai;
    break;
  case 'vai_Latn':
  case 'vai-Latn':
    defaultSymbols = exports.DurationSymbols_vai_Latn;
    break;
  case 'vai_Latn_LR':
  case 'vai-Latn-LR':
    defaultSymbols = exports.DurationSymbols_vai_Latn_LR;
    break;
  case 'vai_Vaii':
  case 'vai-Vaii':
    defaultSymbols = exports.DurationSymbols_vai_Vaii;
    break;
  case 'vai_Vaii_LR':
  case 'vai-Vaii-LR':
    defaultSymbols = exports.DurationSymbols_vai_Vaii_LR;
    break;
  case 'vi_VN':
  case 'vi-VN':
    defaultSymbols = exports.DurationSymbols_vi_VN;
    break;
  case 'vun':
    defaultSymbols = exports.DurationSymbols_vun;
    break;
  case 'vun_TZ':
  case 'vun-TZ':
    defaultSymbols = exports.DurationSymbols_vun_TZ;
    break;
  case 'wae':
    defaultSymbols = exports.DurationSymbols_wae;
    break;
  case 'wae_CH':
  case 'wae-CH':
    defaultSymbols = exports.DurationSymbols_wae_CH;
    break;
  case 'wo':
    defaultSymbols = exports.DurationSymbols_wo;
    break;
  case 'wo_SN':
  case 'wo-SN':
    defaultSymbols = exports.DurationSymbols_wo_SN;
    break;
  case 'xh':
    defaultSymbols = exports.DurationSymbols_xh;
    break;
  case 'xh_ZA':
  case 'xh-ZA':
    defaultSymbols = exports.DurationSymbols_xh_ZA;
    break;
  case 'xog':
    defaultSymbols = exports.DurationSymbols_xog;
    break;
  case 'xog_UG':
  case 'xog-UG':
    defaultSymbols = exports.DurationSymbols_xog_UG;
    break;
  case 'yav':
    defaultSymbols = exports.DurationSymbols_yav;
    break;
  case 'yav_CM':
  case 'yav-CM':
    defaultSymbols = exports.DurationSymbols_yav_CM;
    break;
  case 'yi':
    defaultSymbols = exports.DurationSymbols_yi;
    break;
  case 'yi_001':
  case 'yi-001':
    defaultSymbols = exports.DurationSymbols_yi_001;
    break;
  case 'yo':
    defaultSymbols = exports.DurationSymbols_yo;
    break;
  case 'yo_BJ':
  case 'yo-BJ':
    defaultSymbols = exports.DurationSymbols_yo_BJ;
    break;
  case 'yo_NG':
  case 'yo-NG':
    defaultSymbols = exports.DurationSymbols_yo_NG;
    break;
  case 'yrl':
    defaultSymbols = exports.DurationSymbols_yrl;
    break;
  case 'yrl_BR':
  case 'yrl-BR':
    defaultSymbols = exports.DurationSymbols_yrl_BR;
    break;
  case 'yrl_CO':
  case 'yrl-CO':
    defaultSymbols = exports.DurationSymbols_yrl_CO;
    break;
  case 'yrl_VE':
  case 'yrl-VE':
    defaultSymbols = exports.DurationSymbols_yrl_VE;
    break;
  case 'yue':
    defaultSymbols = exports.DurationSymbols_yue;
    break;
  case 'yue_Hans':
  case 'yue-Hans':
    defaultSymbols = exports.DurationSymbols_yue_Hans;
    break;
  case 'yue_Hans_CN':
  case 'yue-Hans-CN':
    defaultSymbols = exports.DurationSymbols_yue_Hans_CN;
    break;
  case 'yue_Hant':
  case 'yue-Hant':
    defaultSymbols = exports.DurationSymbols_yue_Hant;
    break;
  case 'yue_Hant_HK':
  case 'yue-Hant-HK':
    defaultSymbols = exports.DurationSymbols_yue_Hant_HK;
    break;
  case 'zgh':
    defaultSymbols = exports.DurationSymbols_zgh;
    break;
  case 'zgh_MA':
  case 'zgh-MA':
    defaultSymbols = exports.DurationSymbols_zgh_MA;
    break;
  case 'zh_Hans':
  case 'zh-Hans':
    defaultSymbols = exports.DurationSymbols_zh_Hans;
    break;
  case 'zh_Hans_CN':
  case 'zh-Hans-CN':
    defaultSymbols = exports.DurationSymbols_zh_Hans_CN;
    break;
  case 'zh_Hans_HK':
  case 'zh-Hans-HK':
    defaultSymbols = exports.DurationSymbols_zh_Hans_HK;
    break;
  case 'zh_Hans_MO':
  case 'zh-Hans-MO':
    defaultSymbols = exports.DurationSymbols_zh_Hans_MO;
    break;
  case 'zh_Hans_SG':
  case 'zh-Hans-SG':
    defaultSymbols = exports.DurationSymbols_zh_Hans_SG;
    break;
  case 'zh_Hant':
  case 'zh-Hant':
    defaultSymbols = exports.DurationSymbols_zh_Hant;
    break;
  case 'zh_Hant_HK':
  case 'zh-Hant-HK':
    defaultSymbols = exports.DurationSymbols_zh_Hant_HK;
    break;
  case 'zh_Hant_MO':
  case 'zh-Hant-MO':
    defaultSymbols = exports.DurationSymbols_zh_Hant_MO;
    break;
  case 'zh_Hant_TW':
  case 'zh-Hant-TW':
    defaultSymbols = exports.DurationSymbols_zh_Hant_TW;
    break;
  case 'zu_ZA':
  case 'zu-ZA':
    defaultSymbols = exports.DurationSymbols_zu_ZA;
    break;
}
if (defaultSymbols != null) {
  DurationSymbols.setDurationSymbolsFromExt(defaultSymbols);
}
