/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @fileoverview Relative date time formatting symbols.
 *
 * File generated from CLDR ver. 42
 *
 * This file covers those locales that are not covered in
 * "relativedatetimesymbols.js".
 */

// clang-format off

goog.module('goog.i18n.relativeDateTimeSymbolsExt');

const relativeDateTimeSymbols = goog.require('goog.i18n.relativeDateTimeSymbols');
/** @type {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
let defaultSymbols;


/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_af_NA = relativeDateTimeSymbols.RelativeDateTimeSymbols_af;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_af_ZA = relativeDateTimeSymbols.RelativeDateTimeSymbols_af;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_agq =  {
  DAY: {
    LONG:{
      R:{'-1':'ā zūɛɛ','0':'nɛ','1':'tsʉtsʉ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_agq_CM = exports.RelativeDateTimeSymbols_agq;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ak =  {
  DAY: {
    LONG:{
      R:{'-1':'Ndeda','0':'Ndɛ','1':'Ɔkyena'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ak_GH = exports.RelativeDateTimeSymbols_ak;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_am_ET = relativeDateTimeSymbols.RelativeDateTimeSymbols_am;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_001 = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_AE =  {
  DAY: {
    LONG:{
      R:{'-1':'أمس','-2':'أول أمس','0':'اليوم','1':'غدًا','2':'بعد الغد'},
      P:'few{قبل # أيام}many{قبل # يومًا}one{قبل يوم واحد}other{قبل # يوم}two{قبل يومين}zero{قبل # يوم}',
      F:'few{خلال # أيام}many{خلال # يومًا}one{خلال يوم واحد}other{خلال # يوم}two{خلال يومين}zero{خلال # يوم}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'الساعة الحالية'},
      P:'few{قبل # ساعات}many{قبل # ساعة}one{قبل ساعة واحدة}other{قبل # ساعة}two{قبل ساعتين}zero{قبل # ساعة}',
      F:'few{خلال # ساعات}many{خلال # ساعة}one{خلال ساعة واحدة}other{خلال # ساعة}two{خلال ساعتين}zero{خلال # ساعة}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'هذه الدقيقة'},
      P:'few{قبل # دقائق}many{قبل # دقيقة}one{قبل دقيقة واحدة}other{قبل # دقيقة}two{قبل دقيقتين}zero{قبل # دقيقة}',
      F:'few{خلال # دقائق}many{خلال # دقيقة}one{خلال دقيقة واحدة}other{خلال # دقيقة}two{خلال دقيقتين}zero{خلال # دقيقة}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'الشهر الماضي','0':'هذا الشهر','1':'الشهر القادم'},
      P:'few{قبل # أشهر}many{قبل # شهرًا}one{قبل شهر واحد}other{قبل # شهر}two{قبل شهرين}zero{قبل # شهر}',
      F:'few{خلال # أشهر}many{خلال # شهرًا}one{خلال شهر واحد}other{خلال # شهر}two{خلال شهرين}zero{خلال # شهر}',
    },
    SHORT:{
      R:{'-1':'الشهر الماضي','0':'هذا الشهر','1':'الشهر القادم'},
      P:'few{خلال # أشهر}many{قبل # شهرًا}one{قبل شهر واحد}other{قبل # شهر}two{قبل شهرين}zero{قبل # شهر}',
      F:'few{خلال # أشهر}many{خلال # شهرًا}one{خلال شهر واحد}other{خلال # شهر}two{خلال شهرين}zero{خلال # شهر}',
    },
    NARROW:{
      R:{'-1':'الشهر الماضي','0':'هذا الشهر','1':'الشهر القادم'},
      P:'few{قبل # أشهر}many{قبل # شهرًا}one{قبل شهر واحد}other{قبل # شهر}two{قبل شهرين}zero{قبل # شهر}',
      F:'few{خلال # أشهر}many{خلال # شهرًا}one{خلال شهر واحد}other{خلال # شهر}two{خلال شهرين}zero{خلال # شهر}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'الربع الأخير','0':'هذا الربع','1':'الربع القادم'},
      P:'few{قبل # أرباع سنة}many{قبل # ربع سنة}one{قبل ربع سنة واحد}other{قبل # ربع سنة}two{قبل ربعي سنة}zero{قبل # ربع سنة}',
      F:'few{خلال # أرباع سنة}many{خلال # ربع سنة}one{خلال ربع سنة واحد}other{خلال # ربع سنة}two{خلال ربعي سنة}zero{خلال # ربع سنة}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'الآن'},
      P:'few{قبل # ثوانِ}many{قبل # ثانية}one{قبل ثانية واحدة}other{قبل # ثانية}two{قبل ثانيتين}zero{قبل # ثانية}',
      F:'few{خلال # ثوانٍ}many{خلال # ثانية}one{خلال ثانية واحدة}other{خلال # ثانية}two{خلال ثانيتين}zero{خلال # ثانية}',
    },
    SHORT:{
      R:{'0':'الآن'},
      P:'few{قبل # ثوانٍ}many{قبل # ثانية}one{قبل ثانية واحدة}other{قبل # ثانية}two{قبل ثانيتين}zero{قبل # ثانية}',
      F:'few{خلال # ثوانٍ}many{خلال # ثانية}one{خلال ثانية واحدة}other{خلال # ثانية}two{خلال ثانيتين}zero{خلال # ثانية}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'الأسبوع الماضي','0':'هذا الأسبوع','1':'الأسبوع القادم'},
      P:'few{قبل # أسابيع}many{قبل # أسبوعًا}one{قبل أسبوع واحد}other{قبل # أسبوع}two{قبل أسبوعين}zero{قبل # أسبوع}',
      F:'few{خلال # أسابيع}many{خلال # أسبوعًا}one{خلال أسبوع واحد}other{خلال # أسبوع}two{خلال أسبوعين}zero{خلال # أسبوع}',
    },
    SHORT:{
      R:{'-1':'الأسبوع الماضي','0':'هذا الأسبوع','1':'الأسبوع القادم'},
      P:'few{قبل # أسابيع}many{قبل # أسبوعًا}one{قبل أسبوع واحد}other{قبل # أسبوع}two{قبل أسبوعين}zero{قبل # أسبوع}',
      F:'few{خلال # أسابيع}many{خلال # أسبوعًا}one{خلال أسبوع واحد}other{خلال # أسبوع}two{خلال # أسبوعين}zero{خلال # أسبوع}',
    },
    NARROW:{
      R:{'-1':'الأسبوع الماضي','0':'هذا الأسبوع','1':'الأسبوع القادم'},
      P:'few{قبل # أسابيع}many{قبل # أسبوعًا}one{قبل أسبوع واحد}other{قبل # أسبوع}two{قبل أسبوعين}zero{قبل # أسبوع}',
      F:'few{خلال # أسابيع}many{خلال # أسبوعًا}one{خلال أسبوع واحد}other{خلال # أسبوع}two{خلال أسبوعين}zero{خلال # أسبوع}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'السنة الماضية','0':'هذه السنة','1':'السنة التالية'},
      P:'few{قبل # سنوات}many{قبل # سنة}one{قبل سنة واحدة}other{قبل # سنة}two{قبل سنتين}zero{قبل # سنة}',
      F:'few{خلال # سنوات}many{خلال # سنة}one{خلال سنة واحدة}other{خلال # سنة}two{خلال سنتين}zero{خلال # سنة}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_BH = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_DJ = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_EH = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_ER = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_IL = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_IQ = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_JO = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_KM = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_KW = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_LB = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_LY = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_MA = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_MR = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_OM = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_PS = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_QA = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_SA = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_SD = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_SO = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_SS = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_SY = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_TD = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_TN = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_XB =  {
  DAY: {
    LONG:{
      R:{'-1':'؜‮yesterday‬؜','0':'؜‮today‬؜','1':'؜‮tomorrow‬؜'},
      P:'one{# ؜‮day‬؜ ؜‮ago‬؜}other{# ؜‮days‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮day‬؜}other{؜‮in‬؜ # ؜‮days‬؜}',
    },
    SHORT:{
      R:{'-1':'أمس','-2':'أول أمس','0':'اليوم','1':'غدًا','2':'بعد الغد'},
      P:'one{# ؜‮day‬؜ ؜‮ago‬؜}other{# ؜‮days‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮day‬؜}other{؜‮in‬؜ # ؜‮days‬؜}',
    },
    NARROW:{
      R:{'-1':'أمس','-2':'أول أمس','0':'اليوم','1':'غدًا','2':'بعد الغد'},
      P:'few{قبل # أيام}many{قبل # يومًا}one{قبل يوم واحد}other{قبل # يوم}two{قبل يومين}zero{قبل # يوم}',
      F:'few{خلال # أيام}many{خلال # يومًا}one{خلال يوم واحد}other{خلال # يوم}two{خلال يومين}zero{خلال # يوم}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'؜‮this‬؜ ؜‮hour‬؜'},
      P:'one{# ؜‮hour‬؜ ؜‮ago‬؜}other{# ؜‮hours‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮hour‬؜}other{؜‮in‬؜ # ؜‮hours‬؜}',
    },
    SHORT:{
      R:{'0':'؜‮this‬؜ ؜‮hour‬؜'},
      P:'one{# ؜‮hr‬؜. ؜‮ago‬؜}other{# ؜‮hr‬؜. ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮hr‬؜.}other{؜‮in‬؜ # ؜‮hr‬؜.}',
    },
    NARROW:{
      R:{'0':'؜‮this‬؜ ؜‮hour‬؜'},
      P:'few{قبل # ساعات}many{قبل # ساعة}one{قبل ساعة واحدة}other{قبل # ساعة}two{قبل ساعتين}zero{قبل # ساعة}',
      F:'few{خلال # ساعات}many{خلال # ساعة}one{خلال ساعة واحدة}other{خلال # ساعة}two{خلال ساعتين}zero{خلال # ساعة}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'؜‮this‬؜ ؜‮minute‬؜'},
      P:'one{# ؜‮minute‬؜ ؜‮ago‬؜}other{# ؜‮minutes‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮minute‬؜}other{؜‮in‬؜ # ؜‮minutes‬؜}',
    },
    SHORT:{
      R:{'0':'؜‮this‬؜ ؜‮minute‬؜'},
      P:'one{# ؜‮min‬؜. ؜‮ago‬؜}other{# ؜‮min‬؜. ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮min‬؜.}other{؜‮in‬؜ # ؜‮min‬؜.}',
    },
    NARROW:{
      R:{'0':'؜‮this‬؜ ؜‮minute‬؜'},
      P:'few{قبل # دقائق}many{قبل # دقيقة}one{قبل دقيقة واحدة}other{قبل # دقيقة}two{قبل دقيقتين}zero{قبل # دقيقة}',
      F:'few{خلال # دقائق}many{خلال # دقيقة}one{خلال دقيقة واحدة}other{خلال # دقيقة}two{خلال دقيقتين}zero{خلال # دقيقة}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'؜‮last‬؜ ؜‮month‬؜','0':'؜‮this‬؜ ؜‮month‬؜','1':'؜‮next‬؜ ؜‮month‬؜'},
      P:'one{# ؜‮month‬؜ ؜‮ago‬؜}other{# ؜‮months‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮month‬؜}other{؜‮in‬؜ # ؜‮months‬؜}',
    },
    SHORT:{
      R:{'-1':'؜‮last‬؜ ؜‮mo‬؜.','0':'؜‮this‬؜ ؜‮mo‬؜.','1':'؜‮next‬؜ ؜‮mo‬؜.'},
      P:'one{# ؜‮mo‬؜. ؜‮ago‬؜}other{# ؜‮mo‬؜. ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮mo‬؜.}other{؜‮in‬؜ # ؜‮mo‬؜.}',
    },
    NARROW:{
      R:{'-1':'؜‮last‬؜ ؜‮mo‬؜.','0':'؜‮this‬؜ ؜‮mo‬؜.','1':'؜‮next‬؜ ؜‮mo‬؜.'},
      P:'few{قبل # أشهر}many{قبل # شهرًا}one{قبل شهر واحد}other{قبل # شهر}two{قبل شهرين}zero{قبل # شهر}',
      F:'few{خلال # أشهر}many{خلال # شهرًا}one{خلال شهر واحد}other{خلال # شهر}two{خلال شهرين}zero{خلال # شهر}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'؜‮last‬؜ ؜‮quarter‬؜','0':'؜‮this‬؜ ؜‮quarter‬؜','1':'؜‮next‬؜ ؜‮quarter‬؜'},
      P:'one{# ؜‮quarter‬؜ ؜‮ago‬؜}other{# ؜‮quarters‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮quarter‬؜}other{؜‮in‬؜ # ؜‮quarters‬؜}',
    },
    SHORT:{
      R:{'-1':'؜‮last‬؜ ؜‮qtr‬؜.','0':'؜‮this‬؜ ؜‮qtr‬؜.','1':'؜‮next‬؜ ؜‮qtr‬؜.'},
      P:'one{# ؜‮qtr‬؜. ؜‮ago‬؜}other{# ؜‮qtrs‬؜. ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮qtr‬؜.}other{؜‮in‬؜ # ؜‮qtrs‬؜.}',
    },
    NARROW:{
      R:{'-1':'الربع الأخير','0':'هذا الربع','1':'الربع القادم'},
      P:'few{قبل # أرباع سنة}many{قبل # ربع سنة}one{قبل ربع سنة واحد}other{قبل # ربع سنة}two{قبل ربعي سنة}zero{قبل # ربع سنة}',
      F:'few{خلال # أرباع سنة}many{خلال # ربع سنة}one{خلال ربع سنة واحد}other{خلال # ربع سنة}two{خلال ربعي سنة}zero{خلال # ربع سنة}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'؜‮now‬؜'},
      P:'one{# ؜‮second‬؜ ؜‮ago‬؜}other{# ؜‮seconds‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮second‬؜}other{؜‮in‬؜ # ؜‮seconds‬؜}',
    },
    SHORT:{
      R:{'0':'؜‮now‬؜'},
      P:'one{# ؜‮sec‬؜. ؜‮ago‬؜}other{# ؜‮sec‬؜. ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮sec‬؜.}other{؜‮in‬؜ # ؜‮sec‬؜.}',
    },
    NARROW:{
      R:{'0':'؜‮now‬؜'},
      P:'few{قبل # ثوانٍ}many{قبل # ثانية}one{قبل ثانية واحدة}other{قبل # ثانية}two{قبل ثانيتين}zero{قبل # ثانية}',
      F:'few{خلال # ثوانٍ}many{خلال # ثانية}one{خلال ثانية واحدة}other{خلال # ثانية}two{خلال ثانيتين}zero{خلال # ثانية}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'؜‮last‬؜ ؜‮week‬؜','0':'؜‮this‬؜ ؜‮week‬؜','1':'؜‮next‬؜ ؜‮week‬؜'},
      P:'one{# ؜‮week‬؜ ؜‮ago‬؜}other{# ؜‮weeks‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮week‬؜}other{؜‮in‬؜ # ؜‮weeks‬؜}',
    },
    SHORT:{
      R:{'-1':'؜‮last‬؜ ؜‮wk‬؜.','0':'؜‮this‬؜ ؜‮wk‬؜.','1':'؜‮next‬؜ ؜‮wk‬؜.'},
      P:'one{# ؜‮wk‬؜. ؜‮ago‬؜}other{# ؜‮wk‬؜. ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮wk‬؜.}other{؜‮in‬؜ # ؜‮wk‬؜.}',
    },
    NARROW:{
      R:{'-1':'؜‮last‬؜ ؜‮wk‬؜.','0':'؜‮this‬؜ ؜‮wk‬؜.','1':'؜‮next‬؜ ؜‮wk‬؜.'},
      P:'few{قبل # أسابيع}many{قبل # أسبوعًا}one{قبل أسبوع واحد}other{قبل # أسبوع}two{قبل أسبوعين}zero{قبل # أسبوع}',
      F:'few{خلال # أسابيع}many{خلال # أسبوعًا}one{خلال أسبوع واحد}other{خلال # أسبوع}two{خلال أسبوعين}zero{خلال # أسبوع}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'؜‮last‬؜ ؜‮year‬؜','0':'؜‮this‬؜ ؜‮year‬؜','1':'؜‮next‬؜ ؜‮year‬؜'},
      P:'one{# ؜‮year‬؜ ؜‮ago‬؜}other{# ؜‮years‬؜ ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮year‬؜}other{؜‮in‬؜ # ؜‮years‬؜}',
    },
    SHORT:{
      R:{'-1':'؜‮last‬؜ ؜‮yr‬؜.','0':'؜‮this‬؜ ؜‮yr‬؜.','1':'؜‮next‬؜ ؜‮yr‬؜.'},
      P:'one{# ؜‮yr‬؜. ؜‮ago‬؜}other{# ؜‮yr‬؜. ؜‮ago‬؜}',
      F:'one{؜‮in‬؜ # ؜‮yr‬؜.}other{؜‮in‬؜ # ؜‮yr‬؜.}',
    },
    NARROW:{
      R:{'-1':'؜‮last‬؜ ؜‮yr‬؜.','0':'؜‮this‬؜ ؜‮yr‬؜.','1':'؜‮next‬؜ ؜‮yr‬؜.'},
      P:'few{قبل # سنوات}many{قبل # سنة}one{قبل سنة واحدة}other{قبل # سنة}two{قبل سنتين}zero{قبل # سنة}',
      F:'few{خلال # سنوات}many{خلال # سنة}one{خلال سنة واحدة}other{خلال # سنة}two{خلال سنتين}zero{خلال # سنة}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ar_YE = relativeDateTimeSymbols.RelativeDateTimeSymbols_ar;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_as =  {
  DAY: {
    LONG:{
      R:{'-1':'কালি','-2':'পৰহি','0':'আজি','1':'কাইলৈ','2':'পৰহিলৈ'},
      P:'one{# দিন পূৰ্বে}other{# দিন পূৰ্বে}',
      F:'one{# দিনত}other{# দিনত}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'এইটো ঘণ্টাত'},
      P:'one{# ঘণ্টা পূৰ্বে}other{# ঘণ্টা পূৰ্বে}',
      F:'one{# ঘণ্টাত}other{# ঘণ্টাত}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'এইটো মিনিটত'},
      P:'one{# মিনিট পূৰ্বে}other{# মিনিট পূৰ্বে}',
      F:'one{# মিনিটত}other{# মিনিটত}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'যোৱা মাহ','0':'এই মাহ','1':'অহা মাহ'},
      P:'one{# মাহ পূৰ্বে}other{# মাহ পূৰ্বে}',
      F:'one{# মাহত}other{# মাহত}',
    },
    NARROW:{
      R:{'-1':'যোৱা মা.','0':'এই মা.','1':'অহা মাহ'},
      P:'one{# মাহ পূৰ্বে}other{# মাহ পূৰ্বে}',
      F:'one{# মাহত}other{# মাহত}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'যোৱা তিনি মাহ','0':'এই তিনি মাহ','1':'অহা তিনি মাহ'},
      P:'one{# তিনি মাহ পূৰ্বে}other{# তিনি মাহ পূৰ্বে}',
      F:'one{# তিনি মাহত}other{# তিনি মাহত}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'এতিয়া'},
      P:'one{# ছেকেণ্ড পূৰ্বে}other{# ছেকেণ্ড পূৰ্বে}',
      F:'one{# ছেকেণ্ডত}other{# ছেকেণ্ডত}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'যোৱা সপ্তাহ','0':'এই সপ্তাহ','1':'অহা সপ্তাহ'},
      P:'one{# সপ্তাহ পূৰ্বে}other{# সপ্তাহ পূৰ্বে}',
      F:'one{# সপ্তাহত}other{# সপ্তাহত}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'যোৱা বছৰ','0':'এই বছৰ','1':'অহা বছৰ'},
      P:'one{# বছৰৰ পূৰ্বে}other{# বছৰৰ পূৰ্বে}',
      F:'one{# বছৰত}other{# বছৰত}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_as_IN = exports.RelativeDateTimeSymbols_as;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_asa =  {
  DAY: {
    LONG:{
      R:{'-1':'Ighuo','0':'Iyoo','1':'Yavo'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_asa_TZ = exports.RelativeDateTimeSymbols_asa;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ast =  {
  DAY: {
    LONG:{
      R:{'-1':'ayeri','-2':'antayeri','0':'güei','1':'mañana','2':'pasao mañana'},
      P:'one{hai # día}other{hai # díes}',
      F:'one{en # día}other{en # díes}',
    },
    NARROW:{
      R:{'-1':'ayeri','-2':'antay.','0':'güei','1':'mañ.','2':'p. mañ.'},
      P:'one{hai # d.}other{hai # d.}',
      F:'one{en # d.}other{en # d.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hai # hora}other{hai # hores}',
      F:'one{en # hora}other{en # hores}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hai # h.}other{hai # h.}',
      F:'one{en # h.}other{en # h.}',
    },
    NARROW:{
      R:{'0':'esta h.'},
      P:'one{hai # h.}other{hai # h.}',
      F:'one{en # h.}other{en # h.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'esti minutu'},
      P:'one{hai # minutu}other{hai # minutos}',
      F:'one{en # minutu}other{en # minutos}',
    },
    SHORT:{
      R:{'0':'esti min.'},
      P:'one{hai # min.}other{hai # min.}',
      F:'one{en # min.}other{en # min.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasáu','0':'esti mes','1':'el mes viniente'},
      P:'one{hai # mes}other{hai # meses}',
      F:'one{en # mes}other{en # meses}',
    },
    SHORT:{
      R:{'-1':'mes pas.','0':'esti mes','1':'mes vin.'},
      P:'one{hai # mes}other{hai # meses}',
      F:'one{en # mes}other{en # meses}',
    },
    NARROW:{
      R:{'-1':'mes pas.','0':'esti mes','1':'mes vin.'},
      P:'one{hai # m.}other{hai # m.}',
      F:'one{en # m.}other{en # m.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre anterior','0':'esti trimestre','1':'trimestre viniente'},
      P:'one{hai # trimestre}other{hai # trimestres}',
      F:'one{en # trimestre}other{en # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. ant.','0':'esti trim.','1':'trim. vin.'},
      P:'one{hai # trim.}other{hai # trim.}',
      F:'one{en # trim.}other{en # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. ant.','0':'esti trim.','1':'trim. vin.'},
      P:'one{hai # tr.}other{hai # tr.}',
      F:'one{en # tr.}other{en # tr.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{hai # segundu}other{hai # segundos}',
      F:'one{en # segundu}other{en # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{hai # seg.}other{hai # seg.}',
      F:'one{en # seg.}other{en # seg.}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{hai # s.}other{hai # s.}',
      F:'one{en # s.}other{en # s.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la selmana pasada','0':'esta selmana','1':'la selmana viniente'},
      P:'one{hai # selmana}other{hai # selmanes}',
      F:'one{en # selmana}other{en # selmanes}',
    },
    SHORT:{
      R:{'-1':'selm. pasada','0':'esta selm.','1':'selm. viniente'},
      P:'one{hai # selm.}other{hai # selm.}',
      F:'one{en # selm.}other{en # selm.}',
    },
    NARROW:{
      R:{'-1':'selm. pas.','0':'esta selm.','1':'selm. vin.'},
      P:'one{hai # se.}other{hai # se.}',
      F:'one{en # se.}other{en # se.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'l’añu pasáu','0':'esti añu','1':'l’añu viniente'},
      P:'one{hai # añu}other{hai # años}',
      F:'one{en # añu}other{en # años}',
    },
    SHORT:{
      R:{'-1':'l’añu pas.','0':'esti añu','1':'l’añu vin.'},
      P:'one{hai # añu}other{hai # años}',
      F:'one{en # añu}other{en # años}',
    },
    NARROW:{
      R:{'-1':'añu pas.','0':'esti añu','1':'añu vin.'},
      P:'one{hai # a.}other{hai # a.}',
      F:'one{en # a.}other{en # a.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ast_ES = exports.RelativeDateTimeSymbols_ast;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_az_Cyrl =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_az_Cyrl_AZ =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_az_Latn = relativeDateTimeSymbols.RelativeDateTimeSymbols_az;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_az_Latn_AZ = relativeDateTimeSymbols.RelativeDateTimeSymbols_az;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bas =  {
  DAY: {
    LONG:{
      R:{'-1':'yààni','0':'lɛ̀n','1':'yàni'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bas_CM = exports.RelativeDateTimeSymbols_bas;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_be_BY = relativeDateTimeSymbols.RelativeDateTimeSymbols_be;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bem =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'Lelo','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bem_ZM = exports.RelativeDateTimeSymbols_bem;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bez =  {
  DAY: {
    LONG:{
      R:{'-1':'Igolo','0':'Neng’u ni','1':'Hilawu'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bez_TZ = exports.RelativeDateTimeSymbols_bez;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bg_BG = relativeDateTimeSymbols.RelativeDateTimeSymbols_bg;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bgc =  {
  DAY: {
    LONG:{
      R:{'-1':'काह्ल (बित्या होड)','0':'आज','1':'काह्ल (आण आला)'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'पिछला मिह्ना','0':'इस मिह्ने','1':'अगला मिह्ना'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'पिछला हफ़्ता','0':'इस हफ़्ते','1':'अगला हफ़्ता'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'पिछला साल','0':'इस साल','1':'अगला साल'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bgc_IN = exports.RelativeDateTimeSymbols_bgc;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bho =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bho_IN = exports.RelativeDateTimeSymbols_bho;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bm =  {
  DAY: {
    LONG:{
      R:{'-1':'kunu','0':'bi','1':'sini'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bm_ML = exports.RelativeDateTimeSymbols_bm;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bn_BD = relativeDateTimeSymbols.RelativeDateTimeSymbols_bn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bn_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_bn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bo =  {
  DAY: {
    LONG:{
      R:{'-1':'ཁས་ས་','-2':'ཁས་ཉིན་','0':'དེ་རིང་','1':'སང་ཉིན་','2':'གནངས་ཉིན་'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bo_CN = exports.RelativeDateTimeSymbols_bo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bo_IN = exports.RelativeDateTimeSymbols_bo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_br_FR = relativeDateTimeSymbols.RelativeDateTimeSymbols_br;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_brx =  {
  DAY: {
    LONG:{
      R:{'-1':'मैया','0':'दिनै','1':'गाबोन'},
      P:'one{# सान सिगां}other{# सान सिगां}',
      F:'one{# सानाव}other{# सानाव}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'बे घन्टा'},
      P:'one{# घन्टा सिगां}other{# घन्टा सिगां}',
      F:'one{# घन्टायाव}other{# घन्टायाव}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'बे मिनिट'},
      P:'one{# मिनिट सिगां}other{# मिनिट सिगां}',
      F:'one{# मिनिटआव}other{# मिनिटआव}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'थांनाय दान','0':'बे दान','1':'फैगौ दान'},
      P:'one{# दान सिगां}other{# दान सिगां}',
      F:'one{# दानाव}other{# दानाव}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'थांनाय खोन्दोसे','0':'बे खोन्दोसे','1':'फैगौ खोन्दोसे'},
      P:'one{# खोन्दोसे सिगां}other{# खोन्दोसे सिगां}',
      F:'one{# खोन्दोसेआव}other{# खोन्दोसेआव}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'दा'},
      P:'one{# सेकेण्ड सिगां}other{# सेकेण्ड सिगां}',
      F:'one{# सेकेण्डआव}other{# सेकेण्डआव}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'थांनाय सप्थाह','0':'बे सप्थाह','1':'फैगौ सप्थाह'},
      P:'one{# सप्थाह सिगां}other{# सप्थाह सिगां}',
      F:'one{# सप्थाहयाव}other{# सप्थाहयाव}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'थांनाय बोसोर','0':'बे बोसोर','1':'फैगौ बोसोर'},
      P:'one{# बोसोर सिगां}other{# बोसोर सिगां}',
      F:'one{# बोसोरआव}other{# बोसोरआव}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_brx_IN = exports.RelativeDateTimeSymbols_brx;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bs_Cyrl =  {
  DAY: {
    LONG:{
      R:{'-1':'јуче','-2':'прекјуче','0':'данас','1':'сутра','2':'прекосутра'},
      P:'few{прије # дана}one{прије # дан}other{прије # дана}',
      F:'few{за # дана}one{за # дан}other{за # дана}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'овог сата'},
      P:'few{прије # сата}one{прије # сат}other{прије # сати}',
      F:'few{за # сата}one{за # сат}other{за # сати}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'овог минута'},
      P:'few{прије # минута}one{прије # минут}other{прије # минута}',
      F:'few{за # минута}one{за # минут}other{за # минута}',
    },
    NARROW:{
      R:{'0':'овог минута'},
      P:'few{прије # мин.}one{прије # мин.}other{прије # мин.}',
      F:'few{за # минута}one{за # минут}other{за # минута}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'прошлог мјесеца','0':'овог мјесеца','1':'сљедећег мјесеца'},
      P:'few{прије # мјесеца}one{прије # мјесец}other{прије # мјесеци}',
      F:'few{за # мјесеца}one{за # мјесец}other{за # мјесеци}',
    },
    SHORT:{
      R:{'-1':'прош. мјесеца','0':'овог мјес.','1':'сљед. мјесеца'},
      P:'few{прије # мјесеца}one{прије # мјесец}other{прије # мјесеци}',
      F:'few{за # мјесеца}one{за # мјесец}other{за # мјесеци}',
    },
    NARROW:{
      R:{'-1':'прош. мјес.','0':'ов. мјес.','1':'сљ. мјес.'},
      P:'few{прије # мјес.}one{прије # мјес.}other{прије # мјес.}',
      F:'few{за # мјес.}one{за # мјес.}other{за # мјес.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'прошло тромјесечје','0':'ово тромјесечје','1':'сљедеће тромјесечје'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'сада'},
      P:'few{прије # секунде}one{прије # секунд}other{прије # секунди}',
      F:'few{за # секунде}one{за # секунд}other{за # секунди}',
    },
    SHORT:{
      R:{'0':'сада'},
      P:'few{прије # сек.}one{прије # сек.}other{прије # сек.}',
      F:'few{за # секунде}one{за # сек.}other{за # секунди}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'прошле седмице','0':'ове седмице','1':'сљедеће седмице'},
      P:'few{прије # седмице}one{прије # седмицу}other{прије # седмица}',
      F:'few{за # седмице}one{за # седмицу}other{за # седмица}',
    },
    SHORT:{
      R:{'-1':'прош. седм.','0':'ове седм.','1':'сљ. седм.'},
      P:'few{прије # седм.}one{прије # седм.}other{прије # седм.}',
      F:'few{за # седм.}one{за # седм.}other{за # седм.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'прошле године','0':'ове године','1':'сљедеће године'},
      P:'few{прије # године}one{прије # годину}other{прије # година}',
      F:'few{за # године}one{за # годину}other{за # година}',
    },
    SHORT:{
      R:{'-1':'прош. године','0':'ове год.','1':'сљед. године'},
      P:'few{прије # године}one{прије # годину}other{прије # година}',
      F:'few{за # године}one{за # годину}other{за # година}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bs_Cyrl_BA =  {
  DAY: {
    LONG:{
      R:{'-1':'јуче','-2':'прекјуче','0':'данас','1':'сутра','2':'прекосутра'},
      P:'few{прије # дана}one{прије # дан}other{прије # дана}',
      F:'few{за # дана}one{за # дан}other{за # дана}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'овог сата'},
      P:'few{прије # сата}one{прије # сат}other{прије # сати}',
      F:'few{за # сата}one{за # сат}other{за # сати}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'овог минута'},
      P:'few{прије # минута}one{прије # минут}other{прије # минута}',
      F:'few{за # минута}one{за # минут}other{за # минута}',
    },
    NARROW:{
      R:{'0':'овог минута'},
      P:'few{прије # мин.}one{прије # мин.}other{прије # мин.}',
      F:'few{за # минута}one{за # минут}other{за # минута}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'прошлог мјесеца','0':'овог мјесеца','1':'сљедећег мјесеца'},
      P:'few{прије # мјесеца}one{прије # мјесец}other{прије # мјесеци}',
      F:'few{за # мјесеца}one{за # мјесец}other{за # мјесеци}',
    },
    SHORT:{
      R:{'-1':'прош. мјесеца','0':'овог мјес.','1':'сљед. мјесеца'},
      P:'few{прије # мјесеца}one{прије # мјесец}other{прије # мјесеци}',
      F:'few{за # мјесеца}one{за # мјесец}other{за # мјесеци}',
    },
    NARROW:{
      R:{'-1':'прош. мјес.','0':'ов. мјес.','1':'сљ. мјес.'},
      P:'few{прије # мјес.}one{прије # мјес.}other{прије # мјес.}',
      F:'few{за # мјес.}one{за # мјес.}other{за # мјес.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'прошло тромјесечје','0':'ово тромјесечје','1':'сљедеће тромјесечје'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'сада'},
      P:'few{прије # секунде}one{прије # секунд}other{прије # секунди}',
      F:'few{за # секунде}one{за # секунд}other{за # секунди}',
    },
    SHORT:{
      R:{'0':'сада'},
      P:'few{прије # сек.}one{прије # сек.}other{прије # сек.}',
      F:'few{за # секунде}one{за # сек.}other{за # секунди}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'прошле седмице','0':'ове седмице','1':'сљедеће седмице'},
      P:'few{прије # седмице}one{прије # седмицу}other{прије # седмица}',
      F:'few{за # седмице}one{за # седмицу}other{за # седмица}',
    },
    SHORT:{
      R:{'-1':'прош. седм.','0':'ове седм.','1':'сљ. седм.'},
      P:'few{прије # седм.}one{прије # седм.}other{прије # седм.}',
      F:'few{за # седм.}one{за # седм.}other{за # седм.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'прошле године','0':'ове године','1':'сљедеће године'},
      P:'few{прије # године}one{прије # годину}other{прије # година}',
      F:'few{за # године}one{за # годину}other{за # година}',
    },
    SHORT:{
      R:{'-1':'прош. године','0':'ове год.','1':'сљед. године'},
      P:'few{прије # године}one{прије # годину}other{прије # година}',
      F:'few{за # године}one{за # годину}other{за # година}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bs_Latn = relativeDateTimeSymbols.RelativeDateTimeSymbols_bs;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_bs_Latn_BA = relativeDateTimeSymbols.RelativeDateTimeSymbols_bs;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ca_AD = relativeDateTimeSymbols.RelativeDateTimeSymbols_ca;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ca_ES = relativeDateTimeSymbols.RelativeDateTimeSymbols_ca;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ca_FR = relativeDateTimeSymbols.RelativeDateTimeSymbols_ca;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ca_IT = relativeDateTimeSymbols.RelativeDateTimeSymbols_ca;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ccp =  {
  DAY: {
    LONG:{
      R:{'-1':'𑄉𑄬𑄣𑄴𑄣𑄳𑄠𑄇𑄬𑄣𑄳𑄠𑄬','-2':'𑄉𑄬𑄣𑄧𑄘𑄬 𑄛𑄧𑄢𑄴𑄥𑄪','0':'𑄃𑄬𑄌𑄴𑄥𑄳𑄠','1':'𑄃𑄬𑄎𑄬𑄖𑄴𑄖𑄳𑄠𑄇𑄬𑄣𑄳𑄠𑄬','2':'𑄃𑄬𑄎𑄬𑄖𑄴𑄖𑄳𑄠𑄬 𑄛𑄧𑄢𑄴𑄥𑄪'},
      P:'one{# 𑄘𑄨𑄚𑄴 𑄃𑄉𑄬}other{# 𑄘𑄨𑄚𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄘𑄨𑄚𑄮 𑄟𑄧𑄖𑄴𑄙𑄳𑄠}other{# 𑄘𑄨𑄚𑄮 𑄟𑄧𑄖𑄴𑄙𑄳𑄠}',
    },
    SHORT:{
      R:{'-1':'𑄉𑄬𑄣𑄴𑄣𑄳𑄠𑄇𑄬𑄣𑄴𑄣𑄳𑄠𑄬','-2':'𑄉𑄬𑄣𑄧𑄘𑄬 𑄛𑄧𑄢𑄴𑄥𑄪','0':'𑄃𑄬𑄌𑄴𑄥𑄳𑄠𑄬','1':'𑄃𑄬𑄎𑄬𑄖𑄴𑄖𑄳𑄠𑄇𑄬𑄣𑄴𑄣𑄳𑄠𑄬','2':'𑄃𑄬𑄎𑄬𑄖𑄴𑄖𑄳𑄠𑄇𑄬𑄣𑄴𑄣𑄳𑄠𑄬 𑄛𑄧𑄢𑄴𑄥𑄪'},
      P:'one{# 𑄘𑄨𑄚𑄴 𑄃𑄉𑄬}other{# 𑄘𑄨𑄚𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄘𑄨𑄚𑄮 𑄟𑄧𑄖𑄴𑄙𑄳𑄠}other{# 𑄘𑄨𑄚𑄮 𑄟𑄧𑄖𑄴𑄙𑄳𑄠}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𑄃𑄳𑄆𑄬 𑄊𑄮𑄚𑄴𑄓𑄠𑄴'},
      P:'one{# 𑄊𑄮𑄚𑄴𑄓 𑄃𑄉𑄬}other{# 𑄊𑄮𑄚𑄴𑄓 𑄃𑄉𑄬}',
      F:'one{# 𑄊𑄮𑄚𑄴𑄓𑄠𑄴}other{# 𑄊𑄮𑄚𑄴𑄓𑄠𑄴}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𑄃𑄳𑄆𑄬 𑄟𑄨𑄚𑄨𑄖𑄴'},
      P:'one{# 𑄟𑄨𑄚𑄨𑄖𑄴 𑄃𑄉𑄬}other{# 𑄟𑄨𑄚𑄨𑄖𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄟𑄨𑄚𑄨𑄘𑄬}other{# 𑄟𑄨𑄚𑄨𑄘𑄬}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𑄉𑄬𑄣𑄧𑄘𑄬 𑄟𑄏𑄴','0':'𑄃𑄳𑄆𑄬 𑄟𑄏𑄴','1':'𑄛𑄧𑄢𑄬 𑄟𑄏𑄴'},
      P:'one{# 𑄟𑄏𑄧 𑄃𑄉𑄬}other{# 𑄟𑄏𑄧 𑄃𑄉𑄬}',
      F:'one{# 𑄟𑄏𑄬}other{# 𑄟𑄏𑄬}',
    },
    SHORT:{
      R:{'-1':'𑄉𑄬𑄣𑄧𑄉𑄬 𑄟𑄏𑄴','0':'𑄃𑄳𑄆𑄬 𑄟𑄏𑄴','1':'𑄛𑄧𑄢𑄬 𑄟𑄏𑄴'},
      P:'one{# 𑄇𑄏𑄧 𑄃𑄉𑄬}other{# 𑄟𑄏𑄧 𑄃𑄉𑄬}',
      F:'one{# 𑄟𑄏𑄬}other{# 𑄟𑄏𑄬}',
    },
    NARROW:{
      R:{'-1':'𑄉𑄬𑄣𑄧𑄘𑄬 𑄟𑄏𑄴','0':'𑄃𑄳𑄆𑄬 𑄟𑄏𑄴','1':'𑄛𑄧𑄢𑄬 𑄟𑄏𑄴'},
      P:'one{# 𑄟𑄏𑄧 𑄃𑄉𑄬}other{# 𑄟𑄏𑄧 𑄃𑄉𑄬}',
      F:'one{# 𑄟𑄏𑄬}other{# 𑄟𑄏𑄬}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𑄉𑄬𑄣𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴','0':'𑄃𑄳𑄆𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴','1':'𑄛𑄧𑄢𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴'},
      P:'one{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}other{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄬}other{# 𑄖𑄨𑄚𑄟𑄏𑄬}',
    },
    SHORT:{
      R:{'-1':'𑄉𑄬𑄣𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴','0':'𑄃𑄳𑄆𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴','1':'𑄛𑄧𑄢𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴'},
      P:'one{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}other{#𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄬}other{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄬}',
    },
    NARROW:{
      R:{'-1':'𑄉𑄬𑄣𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴','0':'𑄃𑄳𑄆𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴','1':'𑄛𑄧𑄢𑄬 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴'},
      P:'one{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}other{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄧𑄢𑄴 𑄃𑄬𑄉}',
      F:'one{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄬}other{# 𑄖𑄨𑄚𑄴𑄟𑄏𑄬}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𑄃𑄨𑄇𑄴𑄅𑄚𑄪'},
      P:'one{# 𑄥𑄬𑄉𑄬𑄚𑄴 𑄃𑄉𑄬}other{# 𑄥𑄬𑄉𑄬𑄚𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄥𑄬𑄉𑄬𑄚𑄴𑄘𑄬}other{# 𑄥𑄬𑄉𑄬𑄚𑄴𑄘𑄬}',
    },
    NARROW:{
      R:{'0':'𑄃𑄨𑄇𑄴𑄅𑄚𑄪'},
      P:'one{# 𑄥𑄬𑄉𑄬𑄚𑄴 𑄃𑄉𑄬}other{# 𑄥𑄬𑄉𑄬𑄚𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄥𑄬𑄉𑄬𑄚𑄴}other{# 𑄥𑄬𑄉𑄬𑄚𑄴𑄘𑄬}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𑄉𑄬𑄣𑄧𑄘𑄬 𑄥𑄛𑄴𑄖','0':'𑄃𑄳𑄆𑄬 𑄥𑄛𑄴𑄖','1':'𑄛𑄧𑄢𑄬 𑄥𑄛𑄴𑄖'},
      P:'one{# 𑄥𑄛𑄴𑄖 𑄃𑄉𑄬}other{# 𑄥𑄛𑄴𑄖 𑄃𑄉𑄬}',
      F:'one{# 𑄥𑄛𑄴𑄖𑄠𑄴}other{# 𑄥𑄛𑄴𑄖𑄠𑄴}',
    },
    NARROW:{
      R:{'-1':'𑄉𑄬𑄣𑄧𑄘𑄬 𑄥𑄛𑄴𑄖','0':'𑄃𑄳𑄆𑄬 𑄥𑄛𑄴𑄖','1':'𑄛𑄧𑄢𑄬 𑄥𑄛𑄴𑄖'},
      P:'one{# 𑄥𑄛𑄴𑄖𑄢𑄴 𑄃𑄉𑄬}other{# 𑄥𑄛𑄴𑄖𑄢𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄥𑄛𑄴𑄖𑄠𑄴}other{# 𑄥𑄛𑄴𑄖𑄠𑄴}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𑄉𑄬𑄣𑄳𑄠𑄬 𑄝𑄧𑄏𑄧𑄢𑄴','0':'𑄃𑄬 𑄝𑄧𑄏𑄧𑄢𑄴','1':'𑄎𑄬𑄢𑄧 𑄝𑄧𑄏𑄧𑄢𑄴'},
      P:'one{# 𑄝𑄧𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}other{# 𑄝𑄧𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄝𑄧𑄏𑄧𑄢𑄬}other{# 𑄝𑄧𑄏𑄧𑄢𑄬}',
    },
    SHORT:{
      R:{'-1':'𑄉𑄬𑄣𑄳𑄠𑄬 𑄝𑄧𑄏𑄧𑄢𑄴','0':'𑄃𑄳𑄆𑄬 𑄝𑄧𑄏𑄧𑄢𑄴','1':'𑄛𑄧𑄢𑄬 𑄝𑄧𑄏𑄧𑄢𑄴'},
      P:'one{# 𑄝𑄧𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}other{# 𑄝𑄧𑄏𑄧𑄢𑄴 𑄃𑄉𑄬}',
      F:'one{# 𑄝𑄧𑄏𑄧𑄢𑄬}other{# 𑄝𑄧𑄏𑄧𑄢𑄬}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ccp_BD = exports.RelativeDateTimeSymbols_ccp;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ccp_IN = exports.RelativeDateTimeSymbols_ccp;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ce =  {
  DAY: {
    LONG:{
      R:{'-1':'селхана','0':'тахана','1':'кхана'},
      P:'one{# де хьалха}other{# де хьалха}',
      F:'one{# де даьлча}other{# де даьлча}',
    },
    SHORT:{
      R:{'-1':'селхана','0':'тахана','1':'кхана'},
      P:'one{# д. хьалха}other{# де хьалха}',
      F:'one{# д. даьлча}other{# д. даьлча}',
    },
    NARROW:{
      R:{'-1':'селхана','0':'тахана','1':'кхана'},
      P:'one{де хьалха}other{# де хьалха}',
      F:'one{# д. даьлча}other{# д. даьлча}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'хӀокху сахьтехь'},
      P:'one{# сахьт хьалха}other{# сахьт хьалха}',
      F:'one{# сахьт даьлча}other{# сахьт даьлча}',
    },
    SHORT:{
      R:{'0':'хӀокху сахьтехь'},
      P:'one{# сахь. хьалха}other{# сахь. хьалха}',
      F:'one{# сахь. даьлча}other{# сахь. даьлча}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'хӀокху минотехь'},
      P:'one{# минот хьалха}other{# минот хьалха}',
      F:'one{# минот яьлча}other{# минот яьлча}',
    },
    SHORT:{
      R:{'0':'хӀокху минотехь'},
      P:'one{# мин. хьалха}other{# мин. хьалха}',
      F:'one{# мин. яьлча}other{# мин. яьлча}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'баханчу баттахь','0':'карарчу баттахь','1':'рогӀерчу баттахь'},
      P:'one{# бутт хьалха}other{# бутт хьалха}',
      F:'one{# бутт баьлча}other{# бутт баьлча}',
    },
    SHORT:{
      R:{'-1':'баханчу баттахь','0':'карарчу баттахь','1':'рогӀерчу баттахь'},
      P:'one{# б. хьалха}other{# б. хьалха}',
      F:'one{# б. баьлча}other{# б. баьлча}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# квартал хьалха}other{# квартал хьалха}',
      F:'one{# квартал яьлча}other{# квартал яьлча}',
    },
    SHORT:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# кв. хьалха}other{# кв. хьалха}',
      F:'one{# кв. яьлча}other{# кв. яьлча}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'хӀинца'},
      P:'one{# секунд хьалха}other{# секунд хьалха}',
      F:'one{# секунд яьлча}other{# секунд яьлча}',
    },
    SHORT:{
      R:{'0':'хӀинца'},
      P:'one{# сек. хьалха}other{# сек. хьалха}',
      F:'one{# сек. яьлча}other{# сек. яьлча}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'даханчу кӀирнахь','0':'карарчу кӀирнахь','1':'рогӀерчу кӀирнахь'},
      P:'one{# кӀира хьалха}other{# кӀира хьалха}',
      F:'one{# кӀира даьлча}other{# кӀира даьлча}',
    },
    SHORT:{
      R:{'-1':'даханчу кӀирнахь','0':'карарчу кӀирнахь','1':'рогӀерчу кӀирнахь'},
      P:'one{# кӀир. хьалха}other{# кӀир. хьалха}',
      F:'one{# кӀир. даьлча}other{# кӀир. даьлча}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'даханчу шарахь','0':'карарчу шарахь','1':'рогӀерчу шарахь'},
      P:'one{# шо хьалха}other{# шо хьалха}',
      F:'one{# шо даьлча}other{# шо даьлча}',
    },
    SHORT:{
      R:{'-1':'даханчу шарахь','0':'карарчу шарахь','1':'рогӀерчу шарахь'},
      P:'one{# ш. хьалха}other{# ш. хьалха}',
      F:'one{# ш. даьлча}other{# ш. даьлча}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ce_RU = exports.RelativeDateTimeSymbols_ce;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ceb =  {
  DAY: {
    LONG:{
      R:{'-1':'gahapon','0':'karong adlawa','1':'ugma'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'miaging buwan','0':'karong buwana','1':'sunod nga buwan'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'miaging semana','0':'karong semanaha','1':'sunod nga semana'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'miaging tuig','0':'karong tuiga','1':'sunod nga tuig'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ceb_PH = exports.RelativeDateTimeSymbols_ceb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_cgg =  {
  DAY: {
    LONG:{
      R:{'-1':'Nyomwabazyo','0':'Erizooba','1':'Nyenkyakare'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_cgg_UG = exports.RelativeDateTimeSymbols_cgg;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_chr_US = relativeDateTimeSymbols.RelativeDateTimeSymbols_chr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ckb =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ckb_Arab = exports.RelativeDateTimeSymbols_ckb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ckb_Arab_IQ = exports.RelativeDateTimeSymbols_ckb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ckb_Arab_IR = exports.RelativeDateTimeSymbols_ckb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ckb_IQ = exports.RelativeDateTimeSymbols_ckb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ckb_IR = exports.RelativeDateTimeSymbols_ckb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_cs_CZ = relativeDateTimeSymbols.RelativeDateTimeSymbols_cs;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_cv =  {
  DAY: {
    LONG:{
      R:{'-1':'ӗнер','0':'паян','1':'ыран'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'иртнӗ уйӑхра','0':'ку уйӑхра','1':'ҫитес уйӑхра'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
    SHORT:{
      R:{'-1':'иртнӗ уй.','0':'ку уй.','1':'ҫитес уй.'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'иртнӗ эрнере','0':'ҫак эрнере','1':'ҫитес эрнере'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
    SHORT:{
      R:{'-1':'иртнӗ эр.','0':'ҫак эр.','1':'ҫитес эр.'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'пӗлтӗр','0':'кӑҫал','1':'ҫитес ҫул'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
    SHORT:{
      R:{'-1':'пӗлтӗр','0':'кӑҫал','1':'ҫитес ҫ.'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_cv_RU = exports.RelativeDateTimeSymbols_cv;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_cy_GB = relativeDateTimeSymbols.RelativeDateTimeSymbols_cy;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_da_DK = relativeDateTimeSymbols.RelativeDateTimeSymbols_da;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_da_GL = relativeDateTimeSymbols.RelativeDateTimeSymbols_da;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dav =  {
  DAY: {
    LONG:{
      R:{'-1':'Iguo','0':'Idime','1':'Kesho'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dav_KE = exports.RelativeDateTimeSymbols_dav;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_de_BE = relativeDateTimeSymbols.RelativeDateTimeSymbols_de;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_de_DE = relativeDateTimeSymbols.RelativeDateTimeSymbols_de;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_de_IT = relativeDateTimeSymbols.RelativeDateTimeSymbols_de;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_de_LI = relativeDateTimeSymbols.RelativeDateTimeSymbols_de;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_de_LU = relativeDateTimeSymbols.RelativeDateTimeSymbols_de;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dje =  {
  DAY: {
    LONG:{
      R:{'-1':'Bi','0':'Hõo','1':'Suba'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dje_NE = exports.RelativeDateTimeSymbols_dje;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_doi =  {
  DAY: {
    LONG:{
      R:{'-1':'जंदा कल','0':'अज्ज','1':'औंदे कल'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_doi_IN = exports.RelativeDateTimeSymbols_doi;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dsb =  {
  DAY: {
    LONG:{
      R:{'-1':'cora','0':'źinsa','1':'witśe'},
      P:'few{pśed # dnjami}one{pśed # dnjom}other{pśed # dnjami}two{pśed # dnjoma}',
      F:'few{za # dny}one{za # źeń}other{za # dnjow}two{za # dnja}',
    },
    SHORT:{
      R:{'-1':'cra.','0':'źins.','1':'witś.'},
      P:'few{pśed # dnj.}one{pśed # dnj.}other{pśed # dnj.}two{pśed # dnj.}',
      F:'few{za # dny}one{za # źeń}other{za # dnj.}two{za # dnj.}',
    },
    NARROW:{
      R:{'-1':'cr.','0':'źis.','1':'wit.'},
      P:'few{pśed # d}one{pśed # d}other{pśed # d}two{pśed # d}',
      F:'few{za # ź}one{za # ź}other{za # ź}two{za # ź}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'w toś tej góźinje'},
      P:'few{pśed # góźinami}one{pśed # góźinu}other{pśed # góźinami}two{pśed # góźinoma}',
      F:'few{za # góźiny}one{za # góźinu}other{za # góźin}two{za # góźinje}',
    },
    SHORT:{
      R:{'0':'w toś tej góźinje'},
      P:'few{pśed # góź.}one{pśed # góź.}other{pśed # góź.}two{pśed # góź.}',
      F:'few{za # góź.}one{za # góź.}other{za # góź.}two{za # góź.}',
    },
    NARROW:{
      R:{'0':'w toś tej góźinje'},
      P:'few{pśed # g}one{pśed # g}other{pśed # g}two{pśed # g}',
      F:'few{za # g}one{za # g}other{za # g}two{za # g}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'w toś tej minuśe'},
      P:'few{pśed # minutami}one{pśed # minutu}other{pśed # minutami}two{pśed # minutoma}',
      F:'few{za # minuty}one{za # minutu}other{za # minutow}two{za # minuśe}',
    },
    SHORT:{
      R:{'0':'w toś tej minuśe'},
      P:'few{pśed # min.}one{pśed # min.}other{pśed # min.}two{pśed # min.}',
      F:'few{za # min.}one{za # min.}other{za # min.}two{za # min.}',
    },
    NARROW:{
      R:{'0':'w toś tej minuśe'},
      P:'few{pśed # m}one{pśed # m}other{pśed # m}two{pśed # m}',
      F:'few{za # m}one{za # m}other{za # m}two{za # m}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'zajźony mjasec','0':'ten mjasec','1':'pśiducy mjasec'},
      P:'few{pśed # mjasecami}one{pśed # mjasecom}other{pśed # mjasecami}two{pśed # mjasecoma}',
      F:'few{za # mjasecy}one{za # mjasec}other{za # mjasecow}two{za # mjaseca}',
    },
    SHORT:{
      R:{'-1':'zajź. mjasec','0':'tot. mjasec','1':'pśiduc. mjasec'},
      P:'few{pśed # mjas.}one{pśed # mjas.}other{pśed # mjas.}two{pśed # mjas.}',
      F:'few{za # mjas.}one{za # mjas.}other{za # mjas.}two{za # mjas.}',
    },
    NARROW:{
      R:{'-1':'zajź. mjasec','0':'te. mjasec','1':'pśid. mjasec'},
      P:'few{pśed # mjas.}one{pśed # mjas.}other{pśed # mjas.}two{pśed # mjas.}',
      F:'few{za # mjas.}one{za # mjas.}other{za # mjas.}two{za # mjas.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'zajźony kwartal','0':'toś ten kwartal','1':'pśiducy kwartal'},
      P:'few{pśed # kwartalami}one{pśed # kwartalom}other{pśed # kwartalami}two{pśed # kwartaloma}',
      F:'few{za # kwartale}one{za # kwartal}other{za # kwartalow}two{za # kwartala}',
    },
    SHORT:{
      R:{'-1':'zajźony kwartal','0':'toś ten kwartal','1':'pśiducy kwartal'},
      P:'few{pśed # kwart.}one{pśed # kwart.}other{pśed # kwart.}two{pśed # kwart.}',
      F:'few{za # kwart.}one{za # kwart.}other{za # kwart.}two{za # kwart.}',
    },
    NARROW:{
      R:{'-1':'zajźony kwartal','0':'toś ten kwartal','1':'pśiducy kwartal'},
      P:'few{pśed # kw.}one{pśed # kw.}other{pśed # kw.}two{pśed # kw.}',
      F:'few{za # kw.}one{za # kw.}other{za # kw.}two{za # kw.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'něnto'},
      P:'few{pśed # sekundami}one{pśed # sekundu}other{pśed # sekundami}two{pśed # sekundoma}',
      F:'few{za # sekundy}one{za # sekundu}other{za # sekundow}two{za # sekunźe}',
    },
    SHORT:{
      R:{'0':'něnto'},
      P:'few{pśed # sek.}one{pśed # sek.}other{pśed # sek.}two{pśed # sek.}',
      F:'few{za # sek.}one{za # sek.}other{za # sek.}two{za # sek.}',
    },
    NARROW:{
      R:{'0':'něnto'},
      P:'few{pśed # s}one{pśed # s}other{pśed # s}two{pśed # s}',
      F:'few{za # s}one{za # s}other{za # s}two{za # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'zajźony tyźeń','0':'ten tyźeń','1':'pśiducy tyźeń'},
      P:'few{pśed # tyźenjami}one{pśed # tyźenjom}other{pśed # tyźenjami}two{pśed # tyźenjoma}',
      F:'few{za # tyźenje}one{za # tyźeń}other{za # tyźenjow}two{za # tyźenja}',
    },
    SHORT:{
      R:{'-1':'zajź. tyźeń','0':'tot. tyźeń','1':'pśiduc. tyźeń'},
      P:'few{pśed # tyź.}one{pśed # tyź.}other{pśed # tyź.}two{pśed # tyź.}',
      F:'few{za # tyź.}one{za # tyź.}other{za # tyź.}two{za # tyź.}',
    },
    NARROW:{
      R:{'-1':'zajź. tyźeń','0':'te. tyźeń','1':'pśid. tyźeń'},
      P:'few{pśed # tyź.}one{pśed # tyź.}other{pśed # tyź.}two{pśed # tyź.}',
      F:'few{za # tyź.}one{za # tyź.}other{za # tyź.}two{za # tyź.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'łoni','0':'lětosa','1':'znowa'},
      P:'few{pśed # lětami}one{pśed # lětom}other{pśed # lětami}two{pśed # lětoma}',
      F:'few{za # lěta}one{za # lěto}other{za # lět}two{za # lěśe}',
    },
    SHORT:{
      R:{'-1':'łon.','0':'lěts.','1':'znow.'},
      P:'few{pśed # l.}one{pśed # l.}other{pśed # l.}two{pśed # l.}',
      F:'few{za # l.}one{za # l.}other{za # l.}two{za # l.}',
    },
    NARROW:{
      R:{'-1':'ło.','0':'lět.','1':'zno.'},
      P:'few{pśed # l.}one{pśed # l.}other{pśed # l.}two{pśed # l.}',
      F:'few{za # l.}one{za # l.}other{za # l.}two{za # l.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dsb_DE = exports.RelativeDateTimeSymbols_dsb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dua =  {
  DAY: {
    LONG:{
      R:{'-1':'kíɛlɛ nítómb́í','0':'wɛ́ŋgɛ̄','1':'kíɛlɛ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dua_CM = exports.RelativeDateTimeSymbols_dua;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dyo =  {
  DAY: {
    LONG:{
      R:{'-1':'Fucen','0':'Jaat','1':'Kajom'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dyo_SN = exports.RelativeDateTimeSymbols_dyo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dz =  {
  DAY: {
    LONG:{
      R:{'-1':'ཁ་ཙ་','-2':'ཁ་ཉིམ','0':'ད་རིས་','1':'ནངས་པ་','2':'གནངས་ཚེ'},
      P:'other{ཉིནམ་ # ཧེ་མ་}',
      F:'other{ཉིནམ་ # ནང་}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{ཆུ་ཚོད་ # ཧེ་མ་}',
      F:'other{ཆུ་ཚོད་ # ནང་}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{སྐར་མ་ # ཧེ་མ་}',
      F:'other{སྐར་མ་ # ནང་}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{ཟླཝ་ # ཧེ་མ་}',
      F:'other{ཟླཝ་ # ནང་}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{སྐར་ཆ་ # ཧེ་མ་}',
      F:'other{སྐར་ཆ་ # ནང་}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{བངུན་ཕྲག་ # ཧེ་མ་}',
      F:'other{བངུན་ཕྲག་ # ནང་}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{ལོ་འཁོར་ # ཧེ་མ་}',
      F:'other{ལོ་འཁོར་ # ནང་}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_dz_BT = exports.RelativeDateTimeSymbols_dz;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ebu =  {
  DAY: {
    LONG:{
      R:{'-1':'Ĩgoro','0':'Ũmũnthĩ','1':'Rũciũ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ebu_KE = exports.RelativeDateTimeSymbols_ebu;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ee =  {
  DAY: {
    LONG:{
      R:{'-1':'etsɔ si va yi','-2':'nyitsɔ si va yi','0':'egbe','1':'etsɔ si gbɔna','2':'nyitsɔ si gbɔna'},
      P:'one{ŋkeke # si va yi}other{ŋkeke # si wo va yi}',
      F:'one{le ŋkeke # me}other{le ŋkeke # wo me}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{gaƒoƒo # si va yi}other{gaƒoƒo # si wo va yi}',
      F:'one{le gaƒoƒo # me}other{le gaƒoƒo # wo me}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{aɖabaƒoƒo # si va yi}other{aɖabaƒoƒo # si wo va yi}',
      F:'one{le aɖabaƒoƒo # me}other{le aɖabaƒoƒo # wo me}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'ɣleti si va yi','0':'ɣleti sia','1':'ɣleti si gbɔ na'},
      P:'one{ɣleti # si va yi}other{ɣleti # si wo va yi}',
      F:'one{le ɣleti # me}other{le ɣleti # wo me}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{kɔta # si va yi me}other{kɔta # si va yi me}',
      F:'one{le kɔta # si gbɔ na me}other{le kɔta # si gbɔ na me}',
    },
    NARROW:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{kɔta # si va yi me}other{kɔta # si va yi me}',
      F:'one{le kɔta # si gbɔna me}other{le kɔta # si gbɔ na me}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'fifi'},
      P:'one{sekend # si va yi}other{sekend # si wo va yi}',
      F:'one{le sekend # me}other{le sekend # wo me}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'kɔsiɖa si va yi','0':'kɔsiɖa sia','1':'kɔsiɖa si gbɔ na'},
      P:'one{kɔsiɖa # si va yi}other{kɔsiɖa # si wo va yi}',
      F:'one{le kɔsiɖa # me}other{le kɔsiɖa # wo me}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ƒe si va yi','0':'ƒe sia','1':'ƒe si gbɔ na'},
      P:'one{ƒe # si va yi}other{ƒe # si wo va yi}',
      F:'one{le ƒe # me}other{le ƒe # me}',
    },
    SHORT:{
      R:{'-1':'ƒe si va yi','0':'ƒe sia','1':'ƒe si gbɔ na'},
      P:'one{le ƒe # si va yi me}other{le ƒe # si va yi me}',
      F:'one{le ƒe # me}other{le ƒe # me}',
    },
    NARROW:{
      R:{'-1':'ƒe si va yi','0':'ƒe sia','1':'ƒe si gbɔ na'},
      P:'one{ƒe # si va yi me}other{ƒe # si va yi me}',
      F:'one{le ƒe # si gbɔna me}other{le ƒe # si gbɔna me}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ee_GH = exports.RelativeDateTimeSymbols_ee;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ee_TG = exports.RelativeDateTimeSymbols_ee;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_el_CY = relativeDateTimeSymbols.RelativeDateTimeSymbols_el;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_el_GR = relativeDateTimeSymbols.RelativeDateTimeSymbols_el;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_001 =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_150 =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_AE = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_AG =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_AI =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_AS = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_AT =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_BB =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_BE =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_BI = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_BM =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_BS =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_BW =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_BZ =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_CC =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_CH =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_CK =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_CM =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_CX =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_CY =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_DE =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_DG =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_DK =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_DM =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_ER =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_FI =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_FJ =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_FK =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_FM =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_GD =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_GG =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_GH =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_GI =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_GM =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_GU = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_GY =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_HK =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_IL =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_IM =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_IO =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_JE =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_JM =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_KE =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_KI =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_KN =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_KY =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_LC =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_LR =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_LS =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MG =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MH = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MO =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MP = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MS =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MT =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MU =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MV =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MW =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_MY =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_NA =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_NF =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_NG =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_NL =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_NR =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_NU =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_NZ =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_PG =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_PH = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_PK =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_PN =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_PR = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_PW =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_RW =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SB =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SC =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SD =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SE =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SH =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SI =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SL =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SS =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SX =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_SZ =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_TC =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_TK =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_TO =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_TT =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_TV =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_TZ =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_UG =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_UM = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_US_POSIX = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_VC =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_VG =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_VI = relativeDateTimeSymbols.RelativeDateTimeSymbols_en;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_VU =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_WS =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_XA =  {
  DAY: {
    LONG:{
      R:{'-1':'[ýéšţéŕðåý one two]','0':'[ţöðåý one]','1':'[ţöɱöŕŕöŵ one two]'},
      P:'one{[# ðåý åĝö one two]}other{[# ðåýš åĝö one two]}',
      F:'one{[îñ # ðåý one two]}other{[îñ # ðåýš one two]}',
    },
    NARROW:{
      R:{'-1':'[ýéšţéŕðåý one two]','0':'[ţöðåý one]','1':'[ţöɱöŕŕöŵ one two]'},
      P:'one{#d ago}other{#d ago}',
      F:'one{in #d}other{in #d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'[ţĥîš ĥöûŕ one two]'},
      P:'one{[# ĥöûŕ åĝö one two]}other{[# ĥöûŕš åĝö one two]}',
      F:'one{[îñ # ĥöûŕ one two]}other{[îñ # ĥöûŕš one two]}',
    },
    SHORT:{
      R:{'0':'[ţĥîš ĥöûŕ one two]'},
      P:'one{[# ĥŕ· åĝö one two]}other{[# ĥŕ· åĝö one two]}',
      F:'one{[îñ # ĥŕ· one two]}other{[îñ # ĥŕ· one two]}',
    },
    NARROW:{
      R:{'0':'[ţĥîš ĥöûŕ one two]'},
      P:'one{#h ago}other{#h ago}',
      F:'one{in #h}other{in #h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'[ţĥîš ɱîñûţé one two]'},
      P:'one{[# ɱîñûţé åĝö one two]}other{[# ɱîñûţéš åĝö one two three]}',
      F:'one{[îñ # ɱîñûţé one two]}other{[îñ # ɱîñûţéš one two]}',
    },
    SHORT:{
      R:{'0':'[ţĥîš ɱîñûţé one two]'},
      P:'one{[# ɱîñ· åĝö one two]}other{[# ɱîñ· åĝö one two]}',
      F:'one{[îñ # ɱîñ· one two]}other{[îñ # ɱîñ· one two]}',
    },
    NARROW:{
      R:{'0':'[ţĥîš ɱîñûţé one two]'},
      P:'one{#m ago}other{#m ago}',
      F:'one{in #m}other{in #m}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'[ļåšţ ɱöñţĥ one two]','0':'[ţĥîš ɱöñţĥ one two]','1':'[ñéẋţ ɱöñţĥ one two]'},
      P:'one{[# ɱöñţĥ åĝö one two]}other{[# ɱöñţĥš åĝö one two]}',
      F:'one{[îñ # ɱöñţĥ one two]}other{[îñ # ɱöñţĥš one two]}',
    },
    SHORT:{
      R:{'-1':'[ļåšţ ɱö· one two]','0':'[ţĥîš ɱö· one two]','1':'[ñéẋţ ɱö· one two]'},
      P:'one{[# ɱö· åĝö one two]}other{[# ɱö· åĝö one two]}',
      F:'one{[îñ # ɱö· one two]}other{[îñ # ɱö· one two]}',
    },
    NARROW:{
      R:{'-1':'[ļåšţ ɱö· one two]','0':'[ţĥîš ɱö· one two]','1':'[ñéẋţ ɱö· one two]'},
      P:'one{#mo ago}other{#mo ago}',
      F:'one{in #mo}other{in #mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'[ļåšţ ǫûåŕţéŕ one two]','0':'[ţĥîš ǫûåŕţéŕ one two]','1':'[ñéẋţ ǫûåŕţéŕ one two]'},
      P:'one{[# ǫûåŕţéŕ åĝö one two three]}other{[# ǫûåŕţéŕš åĝö one two three]}',
      F:'one{[îñ # ǫûåŕţéŕ one two]}other{[îñ # ǫûåŕţéŕš one two three]}',
    },
    SHORT:{
      R:{'-1':'[ļåšţ ǫţŕ· one two]','0':'[ţĥîš ǫţŕ· one two]','1':'[ñéẋţ ǫţŕ· one two]'},
      P:'one{[# ǫţŕ· åĝö one two]}other{[# ǫţŕš· åĝö one two]}',
      F:'one{[îñ # ǫţŕ· one two]}other{[îñ # ǫţŕš· one two]}',
    },
    NARROW:{
      R:{'-1':'[ļåšţ ǫţŕ· one two]','0':'[ţĥîš ǫţŕ· one two]','1':'[ñéẋţ ǫţŕ· one two]'},
      P:'one{#q ago}other{#q ago}',
      F:'one{in #q}other{in #q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'[ñöŵ one]'},
      P:'one{[# šéçöñð åĝö one two]}other{[# šéçöñðš åĝö one two three]}',
      F:'one{[îñ # šéçöñð one two]}other{[îñ # šéçöñðš one two]}',
    },
    SHORT:{
      R:{'0':'[ñöŵ one]'},
      P:'one{[# šéç· åĝö one two]}other{[# šéç· åĝö one two]}',
      F:'one{[îñ # šéç· one two]}other{[îñ # šéç· one two]}',
    },
    NARROW:{
      R:{'0':'[ñöŵ one]'},
      P:'one{#s ago}other{#s ago}',
      F:'one{in #s}other{in #s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'[ļåšţ ŵééķ one two]','0':'[ţĥîš ŵééķ one two]','1':'[ñéẋţ ŵééķ one two]'},
      P:'one{[# ŵééķ åĝö one two]}other{[# ŵééķš åĝö one two]}',
      F:'one{[îñ # ŵééķ one two]}other{[îñ # ŵééķš one two]}',
    },
    SHORT:{
      R:{'-1':'[ļåšţ ŵķ· one two]','0':'[ţĥîš ŵķ· one two]','1':'[ñéẋţ ŵķ· one two]'},
      P:'one{[# ŵķ· åĝö one two]}other{[# ŵķ· åĝö one two]}',
      F:'one{[îñ # ŵķ· one two]}other{[îñ # ŵķ· one two]}',
    },
    NARROW:{
      R:{'-1':'[ļåšţ ŵķ· one two]','0':'[ţĥîš ŵķ· one two]','1':'[ñéẋţ ŵķ· one two]'},
      P:'one{#w ago}other{#w ago}',
      F:'one{in #w}other{in #w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'[ļåšţ ýéåŕ one two]','0':'[ţĥîš ýéåŕ one two]','1':'[ñéẋţ ýéåŕ one two]'},
      P:'one{[# ýéåŕ åĝö one two]}other{[# ýéåŕš åĝö one two]}',
      F:'one{[îñ # ýéåŕ one two]}other{[îñ # ýéåŕš one two]}',
    },
    SHORT:{
      R:{'-1':'[ļåšţ ýŕ· one two]','0':'[ţĥîš ýŕ· one two]','1':'[ñéẋţ ýŕ· one two]'},
      P:'one{[# ýŕ· åĝö one two]}other{[# ýŕ· åĝö one two]}',
      F:'one{[îñ # ýŕ· one two]}other{[îñ # ýŕ· one two]}',
    },
    NARROW:{
      R:{'-1':'[ļåšţ ýŕ· one two]','0':'[ţĥîš ýŕ· one two]','1':'[ñéẋţ ýŕ· one two]'},
      P:'one{#y ago}other{#y ago}',
      F:'one{in #y}other{in #y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_ZM =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_en_ZW =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{# day ago}other{# days ago}',
      F:'one{in # day}other{in # days}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# hour ago}other{# hours ago}',
      F:'one{in # hour}other{in # hours}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{# hr ago}other{# hr ago}',
      F:'one{in # hr}other{in # hr}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minute ago}other{# minutes ago}',
      F:'one{in # minute}other{in # minutes}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{# min ago}other{# min ago}',
      F:'one{in # min}other{in # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# month ago}other{# months ago}',
      F:'one{in # month}other{in # months}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'this mo','1':'next mo'},
      P:'one{# mo ago}other{# mo ago}',
      F:'one{in # mo}other{in # mo}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{# quarter ago}other{# quarters ago}',
      F:'one{in # quarter}other{in # quarters}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr ago}other{# qtr ago}',
      F:'one{in # qtr}other{in # qtr}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# second ago}other{# seconds ago}',
      F:'one{in # second}other{in # seconds}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec ago}other{# sec ago}',
      F:'one{in # sec}other{in # sec}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# week ago}other{# weeks ago}',
      F:'one{in # week}other{in # weeks}',
    },
    SHORT:{
      R:{'-1':'last wk','0':'this wk','1':'next wk'},
      P:'one{# wk ago}other{# wk ago}',
      F:'one{in # wk}other{in # wk}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# year ago}other{# years ago}',
      F:'one{in # year}other{in # years}',
    },
    SHORT:{
      R:{'-1':'last yr','0':'this yr','1':'next yr'},
      P:'one{# yr ago}other{# yr ago}',
      F:'one{in # yr}other{in # yr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_eo =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_eo_001 = exports.RelativeDateTimeSymbols_eo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_AR =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
    SHORT:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # días}other{hace # días}',
      F:'one{dentro de # días}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # seg.}other{hace # seg.}',
      F:'one{dentro de # seg.}other{dentro de # seg.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_BO =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_BR =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_BZ =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_CL =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_CO =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_CR =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_CU =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_DO =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_EA = relativeDateTimeSymbols.RelativeDateTimeSymbols_es;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_EC =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_GQ = relativeDateTimeSymbols.RelativeDateTimeSymbols_es;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_GT =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_HN =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_IC = relativeDateTimeSymbols.RelativeDateTimeSymbols_es;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_NI =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_PA =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_PE =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_PH = relativeDateTimeSymbols.RelativeDateTimeSymbols_es;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_PR =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_PY =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # seg.}other{hace # seg.}',
      F:'one{dentro de # seg.}other{dentro de # seg.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_SV =  {
  DAY: {
    LONG:{
      R:{'-2':'antier'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
    SHORT:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_UY =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_es_VE =  {
  DAY: {
    LONG:{
      R:{'-1':'ayer','-2':'anteayer','0':'hoy','1':'mañana','2':'pasado mañana'},
      P:'one{hace # día}other{hace # días}',
      F:'one{dentro de # día}other{dentro de # días}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{hace # hora}other{hace # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{hace # h}other{hace # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{hace # minuto}other{hace # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{hace # min}other{hace # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # mes}other{hace # meses}',
      F:'one{dentro de # mes}other{dentro de # meses}',
    },
    SHORT:{
      R:{'-1':'el mes pasado','0':'este mes','1':'el próximo mes'},
      P:'one{hace # m}other{hace # m}',
      F:'one{dentro de # m}other{dentro de # m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trimestre}other{hace # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'el trimestre pasado','0':'este trimestre','1':'el próximo trimestre'},
      P:'one{hace # trim.}other{hace # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ahora'},
      P:'one{hace # segundo}other{hace # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'ahora'},
      P:'one{hace # s}other{hace # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'la semana pasada','0':'esta semana','1':'la próxima semana'},
      P:'one{hace # semana}other{hace # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'sem. pas.','0':'esta sem.','1':'próx. sem.'},
      P:'one{hace # sem.}other{hace # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # año}other{hace # años}',
      F:'one{dentro de # año}other{dentro de # años}',
    },
    SHORT:{
      R:{'-1':'el año pasado','0':'este año','1':'el próximo año'},
      P:'one{hace # a}other{hace # a}',
      F:'one{dentro de # a}other{dentro de # a}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_et_EE = relativeDateTimeSymbols.RelativeDateTimeSymbols_et;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_eu_ES = relativeDateTimeSymbols.RelativeDateTimeSymbols_eu;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ewo =  {
  DAY: {
    LONG:{
      R:{'-1':'Angogé','0':'Aná','1':'Okírí'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ewo_CM = exports.RelativeDateTimeSymbols_ewo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fa_AF = relativeDateTimeSymbols.RelativeDateTimeSymbols_fa;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fa_IR = relativeDateTimeSymbols.RelativeDateTimeSymbols_fa;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff =  {
  DAY: {
    LONG:{
      R:{'-1':'Haŋki','0':'Hannde','1':'Jaŋngo'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_BF =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_CM =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_GH =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_GM =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_GN =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_GW =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_LR =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_MR =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_NE =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_NG =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_SL =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Adlm_SN =  {
  DAY: {
    LONG:{
      R:{'-1':'𞤸𞤢𞤲𞤳𞤭','0':'𞤸𞤢𞤲𞤣𞤫','1':'𞤶𞤢𞤲𞤺𞤮'},
      P:'one{# 𞤻𞤢𞤤𞥆𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤻𞤢𞤤𞥆𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤻𞤢𞤤𞥆𞤫}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤭𞥅 𞤯𞤮𞤮 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭'},
      P:'one{# 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤲𞥋𞤶𞤢𞤥𞤤𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤲𞥋𞤣𞤭}other{𞤲𞥋𞤣𞤫𞤪 # 𞤲𞥋𞤶𞤢𞤥𞤤𞤭}',
    },
    SHORT:{
      R:{'0':'𞤐𞤣𞤭𞥅 𞤲𞤶𞤢𞤥𞤲𞤣𞤭'},
      P:'one{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤭}other{# 𞤶𞤢. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤢.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'𞤲𞥋𞤣𞤫𞥅 𞤯𞤮𞤮 𞤸𞤮𞤶𞤮𞤥𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶𞤮𞤥𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶𞤮𞤥𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶𞤮𞤥𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤮𞤶𞤮𞤥𞤶𞤫}',
    },
    SHORT:{
      R:{'0':'𞤲𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤳𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
    NARROW:{
      R:{'0':'𞤐𞤣𞤫𞥅 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫'},
      P:'one{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤸𞤮𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤸𞤮𞤶.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'𞤤𞤫𞤱𞤪𞤵 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞥋𞤣𞤵𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱𞤪𞤵','1':'𞤤𞤫𞤱𞤪𞤵 𞤢𞤪𞤢𞤴𞤲𞥋𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱𞤪𞤵 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦𞥆𞤭 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱𞤪𞤵}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦𞥆𞤭}',
    },
    SHORT:{
      R:{'-1':'𞤤𞤫𞤱. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤵','0':'𞤲𞤣𞤮𞥅 𞤯𞤮𞤮 𞤤𞤫𞤱.','1':'𞤤𞤫𞤱. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤵'},
      P:'one{# 𞤤𞤫𞤱. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤵}other{# 𞤤𞤫𞤦. 𞤱𞤵𞤤𞤭𞥅𞤯𞤭}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤱.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤤𞤫𞤦.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫','1':'𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{# 𞤲𞤢𞤴𞤢𞤩𞤭𞥅𞤶𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤪𞤫 #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴𞤩𞤭𞥅𞤶𞤫 #}',
    },
    SHORT:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤲𞤢𞤴. #}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
    NARROW:{
      R:{'-1':'𞤲𞤢𞤴. 𞤬𞤫𞤰.','0':'𞤲𞤣𞤫𞥅 𞤲𞤢𞤴.','1':'𞤲𞤢𞤴. 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤲𞤢𞤴. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤲𞤢𞤴𞤶. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}',
      F:'one{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}other{𞤲𞤣𞤫𞤪 𞤲𞤢𞤴. #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲𞤰𞤢𞤤 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲𞤰𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤢𞤤}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲𞤰𞤫}',
    },
    SHORT:{
      R:{'0':'𞤶𞤮𞥅𞤲𞤭'},
      P:'one{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤺𞤢𞤤}other{# 𞤳𞤭𞤲. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤳𞤭𞤲.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤮𞤲𞤼𞤫𞤪𞤫','1':'𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤢𞤪𞤢𞤴𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤮𞤲𞤼𞤫𞤪𞤫 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤮𞤲𞤼𞤫 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤮𞤲𞤼𞤫𞤪𞤫}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤮𞤲𞤼𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤴𞤼. 𞤬𞤫𞤰𞥆𞤵𞤲𞥋𞤣𞤫','0':'𞤲𞤣𞤫𞥅 𞤯𞤮𞤮 𞤴𞤼.','1':'𞤴𞤼. 𞤸𞤭𞤳𞥆𞤭𞥅𞤲𞤣𞤫'},
      P:'one{# 𞤴𞤼. 𞤱𞤵𞤤𞤭𞥅𞤲𞥋𞤣𞤫}other{# 𞤶𞤼. 𞤱𞤵𞤤𞤭𞥅𞤯𞤫}',
      F:'one{𞤲𞥋𞤣𞤫𞤪 # 𞤴𞤼.}other{𞤲𞥋𞤣𞤫𞤪 # 𞤶𞤼.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{𞤱𞤢𞤯𞤭𞥅 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 #}other{# 𞤳𞤭𞤼𞤢𞥄𞤯𞤫 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 # 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫}other{𞤲𞤣𞤫𞤪 # 𞤳𞤭𞤼𞤢𞥄𞤤𞤫}',
    },
    SHORT:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
    NARROW:{
      R:{'-1':'𞤪𞤮𞤱𞤢𞤲𞤭','0':'𞤸𞤭𞤳𞥆𞤢','1':'𞤸𞤭𞤼 𞤢𞤪𞤮𞥅𞤪𞤫'},
      P:'one{# 𞤸𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}other{# 𞤳𞤭𞤼. 𞤪𞤫𞤱𞤢𞤲𞤭}',
      F:'one{𞤲𞤣𞤫𞤪 𞤸𞤭𞤼. #}other{𞤲𞤣𞤫𞤪 𞤳𞤭𞤼. #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_BF = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_CM = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_GH = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_GM = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_GN = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_GW = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_LR = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_MR = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_NE = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_NG = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_SL = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ff_Latn_SN = exports.RelativeDateTimeSymbols_ff;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fi_FI = relativeDateTimeSymbols.RelativeDateTimeSymbols_fi;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fil_PH = relativeDateTimeSymbols.RelativeDateTimeSymbols_fil;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fo =  {
  DAY: {
    LONG:{
      R:{'-1':'í gjár','-2':'fyrradagin','0':'í dag','1':'í morgin','2':'í ovurmorgin'},
      P:'one{# dagur síðan}other{# dagar síðan}',
      F:'one{um # dag}other{um # dagar}',
    },
    SHORT:{
      R:{'-1':'í gjár','-2':'fyrradagin','0':'í dag','1':'í morgin','2':'í ovurmorgin'},
      P:'one{# da. síðan}other{# da. síðan}',
      F:'one{um # da.}other{um # da.}',
    },
    NARROW:{
      R:{'-1':'í gjár','-2':'fyrradagin','0':'í dag','1':'í morgin','2':'í ovurmorgin'},
      P:'one{# d. síðan}other{# d. síðan}',
      F:'one{um # d.}other{um # d.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'hendan tíman'},
      P:'one{# tími síðan}other{# tímar síðan}',
      F:'one{um # tíma}other{um # tímar}',
    },
    SHORT:{
      R:{'0':'hendan tíman'},
      P:'one{# t. síðan}other{# t. síðan}',
      F:'one{um # t.}other{um # t.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'hendan minuttin'},
      P:'one{# minutt síðan}other{# minuttir síðan}',
      F:'one{um # minutt}other{um # minuttir}',
    },
    SHORT:{
      R:{'0':'hendan minuttin'},
      P:'one{# min. síðan}other{# min. síðan}',
      F:'one{um # min.}other{um # min.}',
    },
    NARROW:{
      R:{'0':'hendan minuttin'},
      P:'one{# m. síðan}other{# m. síðan}',
      F:'one{um # m.}other{um # m.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'seinasta mánað','0':'henda mánaðin','1':'næsta mánað'},
      P:'one{# mánað síðan}other{# mánaðir síðan}',
      F:'one{um # mánað}other{um # mánaðir}',
    },
    SHORT:{
      R:{'-1':'seinasta mnð.','0':'henda mnð.','1':'næsta mnð.'},
      P:'one{# mnð. síðan}other{# mnð. síðan}',
      F:'one{um # mnð.}other{um # mnð.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'seinasta ársfjórðing','0':'hendan ársfjórðingin','1':'næsta ársfjórðing'},
      P:'one{# ársfjórðing síðan}other{# ársfjórðingar síðan}',
      F:'one{um # ársfjórðing}other{um # ársfjórðingar}',
    },
    SHORT:{
      R:{'-1':'seinasta ársfjórðing','0':'hendan ársfjórðingin','1':'næsta ársfjórðing'},
      P:'one{# ársfj. síðan}other{# ársfj. síðan}',
      F:'one{um # ársfj.}other{um # ársfj.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'nú'},
      P:'one{# sekund síðan}other{# sekund síðan}',
      F:'one{um # sekund}other{um # sekund}',
    },
    SHORT:{
      R:{'0':'nú'},
      P:'one{# sek. síðan}other{# sek. síðan}',
      F:'one{um # sek.}other{um # sek.}',
    },
    NARROW:{
      R:{'0':'nú'},
      P:'one{# s. síðan}other{# s. síðan}',
      F:'one{um # s.}other{um # s.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'seinastu viku','0':'hesu viku','1':'næstu viku'},
      P:'one{# vika síðan}other{# vikur síðan}',
      F:'one{um # viku}other{um # vikur}',
    },
    SHORT:{
      R:{'-1':'seinastu vi.','0':'hesu vi.','1':'næstu vi.'},
      P:'one{# vi. síðan}other{# vi. síðan}',
      F:'one{um # vi.}other{um # vi.}',
    },
    NARROW:{
      R:{'-1':'seinastu v.','0':'hesu v.','1':'næstu v.'},
      P:'one{# v. síðan}other{# v. síðan}',
      F:'one{um # v.}other{um # v.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'í fjør','0':'í ár','1':'næsta ár'},
      P:'one{# ár síðan}other{# ár síðan}',
      F:'one{um # ár}other{um # ár}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fo_DK = exports.RelativeDateTimeSymbols_fo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fo_FO = exports.RelativeDateTimeSymbols_fo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_BE = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_BF = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_BI = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_BJ = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_BL = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_CD = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_CF = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_CG = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_CH = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_CI = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_CM = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_DJ = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_DZ = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_FR = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_GA = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_GF = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_GN = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_GP = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_GQ = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_HT = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_KM = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_LU = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_MA = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_MC = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_MF = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_MG = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_ML = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_MQ = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_MR = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_MU = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_NC = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_NE = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_PF = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_PM = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_RE = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_RW = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_SC = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_SN = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_SY = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_TD = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_TG = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_TN = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_VU = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_WF = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fr_YT = relativeDateTimeSymbols.RelativeDateTimeSymbols_fr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fur =  {
  DAY: {
    LONG:{
      R:{'-1':'îr','-2':'îr l’altri','0':'vuê','1':'doman','2':'passantdoman'},
      P:'one{# zornade indaûr}other{# zornadis indaûr}',
      F:'one{ca di # zornade}other{ca di # zornadis}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# ore indaûr}other{# oris indaûr}',
      F:'one{ca di # ore}other{ca di # oris}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minût indaûr}other{# minûts indaûr}',
      F:'one{ca di # minût}other{ca di # minûts}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# mês indaûr}other{# mês indaûr}',
      F:'one{ca di # mês}other{ca di # mês}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# secont indaûr}other{# seconts indaûr}',
      F:'one{ca di # secont}other{ca di # seconts}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# setemane indaûr}other{# setemanis indaûr}',
      F:'one{ca di # setemane}other{ca di # setemanis}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# an indaûr}other{# agns indaûr}',
      F:'one{ca di # an}other{ca di # agns}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fur_IT = exports.RelativeDateTimeSymbols_fur;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fy =  {
  DAY: {
    LONG:{
      R:{'-1':'gisteren','-2':'eergisteren','0':'vandaag','1':'morgen','2':'Oermorgen'},
      P:'one{# dei lyn}other{# deien lyn}',
      F:'one{Oer # dei}other{Oer # deien}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# oere lyn}other{# oere lyn}',
      F:'one{Oer # oere}other{Oer # oere}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minút lyn}other{# minuten lyn}',
      F:'one{Oer # minút}other{Oer # minuten}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'foarige moanne','0':'dizze moanne','1':'folgjende moanne'},
      P:'one{# moanne lyn}other{# moannen lyn}',
      F:'one{Oer # moanne}other{Oer # moannen}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'nu'},
      P:'one{# sekonde lyn}other{# sekonden lyn}',
      F:'one{Oer # sekonde}other{Oer # sekonden}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'foarige wike','0':'dizze wike','1':'folgjende wike'},
      P:'one{# wike lyn}other{# wiken lyn}',
      F:'one{Oer # wike}other{Oer # wiken}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'foarich jier','0':'dit jier','1':'folgjend jier'},
      P:'one{# jier lyn}other{# jier lyn}',
      F:'one{Oer # jier}other{Oer # jier}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_fy_NL = exports.RelativeDateTimeSymbols_fy;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ga_GB = relativeDateTimeSymbols.RelativeDateTimeSymbols_ga;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ga_IE = relativeDateTimeSymbols.RelativeDateTimeSymbols_ga;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gd =  {
  DAY: {
    LONG:{
      R:{'-1':'an-dè','-2':'a-bhòin-dè','0':'an-diugh','1':'a-màireach','2':'an-earar','3':'an-eararais'},
      P:'few{# làithean air ais}one{# latha air ais}other{# latha air ais}two{# latha air ais}',
      F:'few{an ceann # làithean}one{an ceann # latha}other{an ceann # latha}two{an ceann # latha}',
    },
    SHORT:{
      R:{'-1':'an-dè','-2':'a-bhòin-dè','0':'an-diugh','1':'a-màireach','2':'an-earar','3':'an-eararais'},
      P:'few{o # là.}one{o # là}other{o # là}two{o # là}',
      F:'few{an # là.}one{an # là}other{an # là}two{an # là}',
    },
    NARROW:{
      R:{'-1':'an-dè','-2':'a-bhòin-dè','0':'an-diugh','1':'a-màireach','2':'an-earar','3':'an-eararais'},
      P:'few{-# là}one{-# là}other{-# là}two{-# là}',
      F:'few{+# là}one{+# là}other{+# là}two{+# là}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'am broinn uair a thìde'},
      P:'few{# uairean a thìde air ais}one{# uair a thìde air ais}other{# uair a thìde air ais}two{# uair a thìde air ais}',
      F:'few{an ceann # uairean a thìde}one{an ceann # uair a thìde}other{an ceann # uair a thìde}two{an ceann # uair a thìde}',
    },
    SHORT:{
      R:{'0':'am broinn uair'},
      P:'few{o # uair.}one{o # uair}other{o # uair}two{o # uair}',
      F:'few{an # uair.}one{an # uair}other{an # uair}two{an # uair}',
    },
    NARROW:{
      R:{'0':'san uair'},
      P:'few{-# u.}one{-# u.}other{-# u.}two{-# u.}',
      F:'few{+# u.}one{+# u.}other{+# u.}two{+# u.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'am broinn mionaid'},
      P:'few{# mionaidean air ais}one{# mhionaid air ais}other{# mionaid air ais}two{# mhionaid air ais}',
      F:'few{an ceann # mionaidean}one{an ceann # mhionaid}other{an ceann # mionaid}two{an ceann # mhionaid}',
    },
    SHORT:{
      R:{'0':'am broinn mion.'},
      P:'few{o # mion.}one{o # mhion.}other{o # mion.}two{o # mhion.}',
      F:'few{an # mion.}one{an # mhion.}other{an # mion.}two{an # mhion.}',
    },
    NARROW:{
      R:{'0':'sa mhion.'},
      P:'few{-# m}one{-# m}other{-# m}two{-# m}',
      F:'few{+# m}one{+# m}other{+# m}two{+# m}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'am mìos seo chaidh','0':'am mìos seo','1':'an ath-mhìos'},
      P:'few{# mìosan air ais}one{# mhìos air ais}other{# mìos air ais}two{# mhìos air ais}',
      F:'few{an ceann # mìosan}one{an ceann # mhìosa}other{an ceann # mìosa}two{an ceann # mhìosa}',
    },
    SHORT:{
      R:{'-1':'am mìos sa chaidh','0':'am mìos seo','1':'an ath-mhìos'},
      P:'few{o # mìos.}one{o # mhìos.}other{o # mìos.}two{o # mhìos.}',
      F:'few{an # mìos.}one{an # mhìos.}other{an # mìos.}two{an # mhìos.}',
    },
    NARROW:{
      R:{'-1':'mì. ch.','0':'am mì. seo','1':'ath-mhì.'},
      P:'few{-# mì.}one{-# mhì.}other{-# mì.}two{-# mhì.}',
      F:'few{+# mì.}one{+# mhì.}other{+# mì.}two{+# mhì.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'an cairteal seo chaidh','0':'an cairteal seo','1':'an ath-chairteal'},
      P:'few{# cairtealan air ais}one{# chairteal air ais}other{# cairteal air ais}two{# chairteal air ais}',
      F:'few{an ceann # cairtealan}one{an ceann # chairteil}other{an ceann # cairteil}two{an ceann # chairteil}',
    },
    SHORT:{
      R:{'-1':'an cairt. sa chaidh','0':'an cairt. seo','1':'an ath-chairt.'},
      P:'few{o # cairt.}one{o # chairt.}other{o # cairt.}two{o # chairt.}',
      F:'few{an # cairt.}one{an # chairt.}other{an # cairt.}two{an # chairt.}',
    },
    NARROW:{
      R:{'-1':'c. ch.','0':'an c. seo','1':'ath-ch.'},
      P:'few{-# c.}one{-# c.}other{-# c.}two{-# c.}',
      F:'few{+# c.}one{+# c.}other{+# c.}two{+# c.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'an-dràsta'},
      P:'few{# diogan air ais}one{# diog air ais}other{# diog air ais}two{# dhiog air ais}',
      F:'few{an ceann # diogan}one{an ceann # diog}other{an ceann # diog}two{an ceann # dhiog}',
    },
    SHORT:{
      R:{'0':'an-dràsta'},
      P:'few{o # diog.}one{o # diog}other{o # diog}two{o # dhiog}',
      F:'few{an # diog.}one{an # diog}other{an # diog}two{an # dhiog}',
    },
    NARROW:{
      R:{'0':'an-dràsta'},
      P:'few{-# d}one{-# d}other{-# d}two{-# d}',
      F:'few{+# d}one{+# d}other{+# d}two{+# d}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'an t-seachdain seo chaidh','0':'an t-seachdain seo','1':'an ath-sheachdain'},
      P:'few{# seachdainean air ais}one{# seachdain air ais}other{# seachdain air ais}two{# sheachdain air ais}',
      F:'few{an ceann # seachdainean}one{an ceann # seachdain}other{an ceann # seachdain}two{an ceann # sheachdain}',
    },
    SHORT:{
      R:{'-1':'seachd. sa chaidh','0':'an t-seachd. seo','1':'an ath-sheachd.'},
      P:'few{o # seachd.}one{o # sheachd.}other{o # seachd.}two{o # sheachd.}',
      F:'few{an # seachd.}one{an # sheachd.}other{an # seachd.}two{an # sheachd.}',
    },
    NARROW:{
      R:{'-1':'sn. ch.','0':'an t-sn. seo','1':'ath-shn.'},
      P:'few{-# sn.}one{-# sn.}other{-# sn.}two{-# sn.}',
      F:'few{+# sn.}one{+# sn.}other{+# sn.}two{+# sn.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'an-uiridh','-2':'a-bhòn-uiridh','0':'am bliadhna','1':'an ath-bhliadhna'},
      P:'few{# bhliadhnaichean air ais}one{# bhliadhna air ais}other{# bliadhna air ais}two{# bhliadhna air ais}',
      F:'few{an ceann # bliadhnaichean}one{an ceann # bhliadhna}other{an ceann # bliadhna}two{an ceann # bhliadhna}',
    },
    SHORT:{
      R:{'-1':'an-uiridh','-2':'a-bhòn-uiridh','0':'am bliadhna','1':'an ath-bhliadhna'},
      P:'few{o # blia.}one{o # bhlia.}other{o # blia.}two{o # bhlia.}',
      F:'few{an # blia.}one{an # bhlia.}other{an # blia.}two{an # bhlia.}',
    },
    NARROW:{
      R:{'-1':'an-uir.','-2':'a-bh-uir.','0':'am bl.','1':'an ath-bhl.'},
      P:'few{-# bl.}one{-# bhl.}other{-# bl.}two{-# bhl.}',
      F:'few{+# bl.}one{+# bhl.}other{+# bl.}two{+# bhl.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gd_GB = exports.RelativeDateTimeSymbols_gd;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gl_ES = relativeDateTimeSymbols.RelativeDateTimeSymbols_gl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gsw_CH = relativeDateTimeSymbols.RelativeDateTimeSymbols_gsw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gsw_FR = relativeDateTimeSymbols.RelativeDateTimeSymbols_gsw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gsw_LI = relativeDateTimeSymbols.RelativeDateTimeSymbols_gsw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gu_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_gu;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_guz =  {
  DAY: {
    LONG:{
      R:{'-1':'Igoro','0':'Rero','1':'Mambia'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_guz_KE = exports.RelativeDateTimeSymbols_guz;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gv =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_gv_IM = exports.RelativeDateTimeSymbols_gv;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ha =  {
  DAY: {
    LONG:{
      R:{'-1':'jiya','0':'yau','1':'gobe'},
      P:'one{rana da ya gabata #}other{kwanaki da suka gabata #}',
      F:'one{a cikin rana #}other{a cikin kwanaki #}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'wannan awa'},
      P:'one{# awa da ya gabata}other{# awa da ya gabata}',
      F:'one{cikin # awa}other{cikin # awa}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'wannan mintin'},
      P:'one{# minti da ya gabata}other{# minti da ya gabata}',
      F:'one{cikin # minti}other{cikin # minti}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'watan da ya gabata','0':'wannan watan','1':'wata na gaba'},
      P:'one{watan da ya gabata}other{watanni da suka gabata #}}',
      F:'one{a cikin watan #}other{a cikin watanni #}',
    },
    SHORT:{
      R:{'-1':'watan da ya gabata','0':'wannan watan','1':'wata na gaba'},
      P:'one{watan da ya gabata}other{watan da ya gabata #}',
      F:'one{a cikin watan #}other{a cikin watan #}',
    },
    NARROW:{
      R:{'-1':'watan da ya gabata','0':'wannan watan','1':'wata na gaba'},
      P:'one{watan da ya gabata #}other{watan da ya gabata #}',
      F:'one{a cikin watan #}other{a cikin watan #}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'kwatan karshe','0':'wannan kwatan','1':'kwata na gaba'},
      P:'one{kwata da suka gabata #}other{kwatas da suka gabata #}',
      F:'one{a cikin kwata #}other{a cikin kwatas #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'yanzu'},
      P:'one{# dakika da ya gabata}other{# dakika da ya gabata}',
      F:'one{cikin # dakika}other{cikin # dakika}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'satin da ya gabata','0':'wannan satin','1':'sati na gaba'},
      P:'one{mako da ya gabata #}other{makonni da suka gabata #}',
      F:'one{a cikin mako #}other{a cikin makonni #}',
    },
    SHORT:{
      R:{'-1':'satin da ya gabata','0':'wannan satin','1':'sati na gaba'},
      P:'one{mako da ya gabata #}other{mako da ya gabata #}',
      F:'one{a cikin mako #}other{a cikin mako #}',
    },
    NARROW:{
      R:{'-1':'satin da ya gabata','0':'wannan satin','1':'sati na gaba'},
      P:'one{mako da suka gabata #}other{mako da ya gabata #}',
      F:'one{a cikin mako #}other{a cikin mako #}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'bara','0':'bana','1':'badi'},
      P:'one{shekara da suka gabata #}other{shekara da suka gabata #}',
      F:'one{a shekarar #}other{a shekaru #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ha_GH = exports.RelativeDateTimeSymbols_ha;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ha_NE = exports.RelativeDateTimeSymbols_ha;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ha_NG = exports.RelativeDateTimeSymbols_ha;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_haw_US = relativeDateTimeSymbols.RelativeDateTimeSymbols_haw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_he_IL = relativeDateTimeSymbols.RelativeDateTimeSymbols_he;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hi_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_hi;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hi_Latn =  {
  DAY: {
    LONG:{
      R:{'-1':'kal','-2':'parson','0':'aaj','1':'aane wala kal','2':'aane wala parson'},
      P:'one{# din pehle}other{# din pehle}',
      F:'one{# din mein}other{# din mein}',
    },
    SHORT:{
      R:{'-1':'kal','-2':'parson','0':'aaj','1':'aane wala kal','2':'aane wala parson'},
      P:'one{# din pahle}other{# din pahle}',
      F:'one{# din mein}other{# din mein}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'yah ghanta'},
      P:'one{# ghante pahle}other{# ghante pahle}',
      F:'one{# ghante mein}other{# ghante mein}',
    },
    SHORT:{
      R:{'0':'yah ghanta'},
      P:'one{# hr pahle}other{# hr mein}',
      F:'one{# hr mein}other{# hr mein}',
    },
    NARROW:{
      R:{'0':'yah ghanta'},
      P:'one{#hr pahle}other{#hr pahle}',
      F:'one{#hr mein}other{#hr mein}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'yah minute'},
      P:'one{# minute pahle}other{# minute pahle}',
      F:'one{# minute mein}other{# minute mein}',
    },
    SHORT:{
      R:{'0':'yah minute'},
      P:'one{# min. pahle}other{# min. pahle}',
      F:'one{# min. mein}other{# min. mein}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'pichhla maheena','0':'yah maheena','1':'agla maheena'},
      P:'one{# maheene pahle}other{# maheene pahle}',
      F:'one{# maheene mein}other{# maheene mein}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'is mo','1':'next mo'},
      P:'one{# mo. pahle}other{# mo. pahle}',
      F:'one{# mo. mein}other{# mo. mein}',
    },
    NARROW:{
      R:{'-1':'last mo.','0':'is mo.','1':'next mo.'},
      P:'one{#mo pahle}other{#mo pahle}',
      F:'one{#mo mein}other{#mo mein}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'is quarter','1':'next quarter'},
      P:'one{# quarter pahle}other{# quarters pahle}',
      F:'one{# quarter mein}other{# quarters mein}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr. pahle}other{# qtrs. pahle}',
      F:'one{# qtr. mein}other{# qtrs. mein}',
    },
    NARROW:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{#q pahle}other{#q pahle}',
      F:'one{#q mein}other{#q mein}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'abhi'},
      P:'one{# second pahle}other{# second pahle}',
      F:'one{# second mein}other{# second mein}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec. pahle}other{# sec. pahle}',
      F:'one{# sec. mein}other{# sec. mein}',
    },
    NARROW:{
      R:{'0':'now'},
      P:'one{#s pahle}other{#s pahle}',
      F:'one{#s mein}other{#s mein}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'pichhla hafta','0':'is hafte','1':'agla hafta'},
      P:'one{# hafte pehle}other{# hafte pehle}',
      F:'one{# hafte mein}other{# hafte mein}',
    },
    SHORT:{
      R:{'-1':'last wk.','0':'is wk.','1':'next wk.'},
      P:'one{# wk. pahle}other{# wk. pahle}',
      F:'one{# wk. mein}other{# wk. mein}',
    },
    NARROW:{
      R:{'-1':'last wk','0':'is wk','1':'next wk'},
      P:'one{#w pahle}other{#w pahle}',
      F:'one{#w mein}other{#w mein}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'pichhla saal','0':'is saal','1':'agla saal'},
      P:'one{# saal pahle}other{# saal pahle}',
      F:'one{# saal mein}other{# saal mein}',
    },
    SHORT:{
      R:{'-1':'last yr.','0':'is yr.','1':'next yr.'},
      P:'one{# yr. pahle}other{# yr. pahle}',
      F:'one{# yr. mein}other{# yr. mein}',
    },
    NARROW:{
      R:{'-1':'last yr.','0':'is yr.','1':'next yr.'},
      P:'one{#y pahle}other{#y pahle}',
      F:'one{#y mein}other{#y mein}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hi_Latn_IN =  {
  DAY: {
    LONG:{
      R:{'-1':'kal','-2':'parson','0':'aaj','1':'aane wala kal','2':'aane wala parson'},
      P:'one{# din pehle}other{# din pehle}',
      F:'one{# din mein}other{# din mein}',
    },
    SHORT:{
      R:{'-1':'kal','-2':'parson','0':'aaj','1':'aane wala kal','2':'aane wala parson'},
      P:'one{# din pahle}other{# din pahle}',
      F:'one{# din mein}other{# din mein}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'yah ghanta'},
      P:'one{# ghante pahle}other{# ghante pahle}',
      F:'one{# ghante mein}other{# ghante mein}',
    },
    SHORT:{
      R:{'0':'yah ghanta'},
      P:'one{# hr pahle}other{# hr mein}',
      F:'one{# hr mein}other{# hr mein}',
    },
    NARROW:{
      R:{'0':'yah ghanta'},
      P:'one{#hr pahle}other{#hr pahle}',
      F:'one{#hr mein}other{#hr mein}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'yah minute'},
      P:'one{# minute pahle}other{# minute pahle}',
      F:'one{# minute mein}other{# minute mein}',
    },
    SHORT:{
      R:{'0':'yah minute'},
      P:'one{# min. pahle}other{# min. pahle}',
      F:'one{# min. mein}other{# min. mein}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'pichhla maheena','0':'yah maheena','1':'agla maheena'},
      P:'one{# maheene pahle}other{# maheene pahle}',
      F:'one{# maheene mein}other{# maheene mein}',
    },
    SHORT:{
      R:{'-1':'last mo','0':'is mo','1':'next mo'},
      P:'one{# mo. pahle}other{# mo. pahle}',
      F:'one{# mo. mein}other{# mo. mein}',
    },
    NARROW:{
      R:{'-1':'last mo.','0':'is mo.','1':'next mo.'},
      P:'one{#mo pahle}other{#mo pahle}',
      F:'one{#mo mein}other{#mo mein}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'is quarter','1':'next quarter'},
      P:'one{# quarter pahle}other{# quarters pahle}',
      F:'one{# quarter mein}other{# quarters mein}',
    },
    SHORT:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{# qtr. pahle}other{# qtrs. pahle}',
      F:'one{# qtr. mein}other{# qtrs. mein}',
    },
    NARROW:{
      R:{'-1':'last qtr.','0':'this qtr.','1':'next qtr.'},
      P:'one{#q pahle}other{#q pahle}',
      F:'one{#q mein}other{#q mein}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'abhi'},
      P:'one{# second pahle}other{# second pahle}',
      F:'one{# second mein}other{# second mein}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{# sec. pahle}other{# sec. pahle}',
      F:'one{# sec. mein}other{# sec. mein}',
    },
    NARROW:{
      R:{'0':'now'},
      P:'one{#s pahle}other{#s pahle}',
      F:'one{#s mein}other{#s mein}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'pichhla hafta','0':'is hafte','1':'agla hafta'},
      P:'one{# hafte pehle}other{# hafte pehle}',
      F:'one{# hafte mein}other{# hafte mein}',
    },
    SHORT:{
      R:{'-1':'last wk.','0':'is wk.','1':'next wk.'},
      P:'one{# wk. pahle}other{# wk. pahle}',
      F:'one{# wk. mein}other{# wk. mein}',
    },
    NARROW:{
      R:{'-1':'last wk','0':'is wk','1':'next wk'},
      P:'one{#w pahle}other{#w pahle}',
      F:'one{#w mein}other{#w mein}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'pichhla saal','0':'is saal','1':'agla saal'},
      P:'one{# saal pahle}other{# saal pahle}',
      F:'one{# saal mein}other{# saal mein}',
    },
    SHORT:{
      R:{'-1':'last yr.','0':'is yr.','1':'next yr.'},
      P:'one{# yr. pahle}other{# yr. pahle}',
      F:'one{# yr. mein}other{# yr. mein}',
    },
    NARROW:{
      R:{'-1':'last yr.','0':'is yr.','1':'next yr.'},
      P:'one{#y pahle}other{#y pahle}',
      F:'one{#y mein}other{#y mein}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hr_BA = relativeDateTimeSymbols.RelativeDateTimeSymbols_hr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hr_HR = relativeDateTimeSymbols.RelativeDateTimeSymbols_hr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hsb =  {
  DAY: {
    LONG:{
      R:{'-1':'wčera','0':'dźensa','1':'jutře'},
      P:'few{před # dnjemi}one{před # dnjom}other{před # dnjemi}two{před # dnjomaj}',
      F:'few{za # dny}one{za # dźeń}other{za # dnjow}two{za # dnjej}',
    },
    SHORT:{
      R:{'-1':'wčer.','0':'dźens.','1':'jutř.'},
      P:'few{před # dnj.}one{před # dnj.}other{před # dnj.}two{před # dnj.}',
      F:'few{za # dny}one{za # dźeń}other{za # dnj.}two{za # dnj.}',
    },
    NARROW:{
      R:{'-1':'wč.','0':'dźe.','1':'jut.'},
      P:'few{před # d}one{před # d}other{před # d}two{před # d}',
      F:'few{za # d}one{za # d}other{za # d}two{za # d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'w tutej hodźinje'},
      P:'few{před # hodźinami}one{před # hodźinu}other{před # hodźinami}two{před # hodźinomaj}',
      F:'few{za # hodźiny}one{za # hodźinu}other{za # hodźin}two{za # hodźinje}',
    },
    SHORT:{
      R:{'0':'w tutej hodźinje'},
      P:'few{před # hodź.}one{před # hodź.}other{před # hodź.}two{před # hodź.}',
      F:'few{za # hodź.}one{za # hodź.}other{za # hodź.}two{za # hodź.}',
    },
    NARROW:{
      R:{'0':'w tutej hodźinje'},
      P:'few{před # h}one{před # h}other{před # h}two{před # h}',
      F:'few{za # h}one{za # h}other{za # h}two{za # h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'w tutej mjeńšinje'},
      P:'few{před # minutami}one{před # minutu}other{před # minutami}two{před # minutomaj}',
      F:'few{za # minuty}one{za # minutu}other{za # minutow}two{za # minuće}',
    },
    SHORT:{
      R:{'0':'w tutej mjeńšinje'},
      P:'few{před # min.}one{před # min.}other{před # min.}two{před # min.}',
      F:'few{za # min.}one{za # min.}other{za # min.}two{za # min.}',
    },
    NARROW:{
      R:{'0':'w tutej mjeńšinje'},
      P:'few{před # m}one{před # m}other{před # m}two{před # m}',
      F:'few{za # m}one{za # m}other{za # m}two{za # m}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'zašły měsac','0':'tutón měsac','1':'přichodny měsac'},
      P:'few{před # měsacami}one{před # měsacom}other{před # měsacami}two{před # měsacomaj}',
      F:'few{za # měsacy}one{za # měsac}other{za # měsacow}two{za # měsacaj}',
    },
    SHORT:{
      R:{'-1':'zašł. měsac','0':'tut. měsac','1':'přichodn. měsac'},
      P:'few{před # měs.}one{před # měs.}other{před # měs.}two{před # měs.}',
      F:'few{za # měs.}one{za # měs.}other{za # měs.}two{za # měs.}',
    },
    NARROW:{
      R:{'-1':'zaš. měsac','0':'tu. měsac','1':'přich. měsac'},
      P:'few{před # měs.}one{před # měs.}other{před # měs.}two{před # měs.}',
      F:'few{za # měs.}one{za # měs.}other{za # měs.}two{za # měs.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'zašły kwartal','0':'tutón kwartal','1':'přichodny kwartal'},
      P:'few{před # kwartalemi}one{před # kwartalom}other{před # kwartalemi}two{před # kwartalomaj}',
      F:'few{za # kwartale}one{za # kwartal}other{za # kwartalow}two{za # kwartalej}',
    },
    SHORT:{
      R:{'-1':'zašły kwartal','0':'tutón kwartal','1':'přichodny kwartal'},
      P:'few{před # kwart.}one{před # kwart.}other{před # kwart.}two{před # kwart.}',
      F:'few{za # kwart.}one{za # kwart.}other{za # kwart.}two{za # kwart.}',
    },
    NARROW:{
      R:{'-1':'zašły kwartal','0':'tutón kwartal','1':'přichodny kwartal'},
      P:'few{před # kw.}one{před # kw.}other{před # kw.}two{před # kw.}',
      F:'few{za # kw.}one{za # kw.}other{za # kw.}two{za # kw.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'nětko'},
      P:'few{před # sekundami}one{před # sekundu}other{před # sekundami}two{před # sekundomaj}',
      F:'few{za # sekundy}one{za # sekundu}other{za # sekundow}two{za # sekundźe}',
    },
    SHORT:{
      R:{'0':'nětko'},
      P:'few{před # sek.}one{před # sek.}other{před # sek.}two{před # sek.}',
      F:'few{za # sek.}one{za # sek.}other{za # sek.}two{za # sek.}',
    },
    NARROW:{
      R:{'0':'nětko'},
      P:'few{před # s}one{před # s}other{před # s}two{před # s}',
      F:'few{za # s}one{za # s}other{za # s}two{za # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'zašły tydźeń','0':'tutón tydźeń','1':'přichodny tydźeń'},
      P:'few{před # tydźenjemi}one{před # tydźenjom}other{před # tydźenjemi}two{před # tydźenjomaj}',
      F:'few{za # tydźenje}one{za # tydźeń}other{za # tydźenjow}two{za # tydźenjej}',
    },
    SHORT:{
      R:{'-1':'zašł. tydźeń','0':'tut. tydźeń','1':'přichodn. tydźeń'},
      P:'few{před # tydź.}one{před # tydź.}other{před # tydź.}two{před # tydź.}',
      F:'few{za # tydź.}one{za # tydź.}other{za # tydź.}two{za # tydź.}',
    },
    NARROW:{
      R:{'-1':'zaš. tydźeń','0':'tu. tydźeń','1':'přich. tydźeń'},
      P:'few{před # tydź.}one{před # tydź.}other{před # tydź.}two{před # tydź.}',
      F:'few{za # tydź.}one{za # tydź.}other{za # tydź.}two{za # tydź.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'loni','0':'lětsa','1':'klětu'},
      P:'few{před # lětami}one{před # lětom}other{před # lětami}two{před # lětomaj}',
      F:'few{za # lěta}one{za # lěto}other{za # lět}two{za # lěće}',
    },
    SHORT:{
      R:{'-1':'lon.','0':'lěts.','1':'klět.'},
      P:'few{před # l.}one{před # l.}other{před # l.}two{před # l.}',
      F:'few{za # l.}one{za # l.}other{za # l.}two{za # l.}',
    },
    NARROW:{
      R:{'-1':'lo.','0':'lět.','1':'klě.'},
      P:'few{před # l.}one{před # l.}other{před # l.}two{před # l.}',
      F:'few{za # l.}one{za # l.}other{za # l.}two{za # l.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hsb_DE = exports.RelativeDateTimeSymbols_hsb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hu_HU = relativeDateTimeSymbols.RelativeDateTimeSymbols_hu;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_hy_AM = relativeDateTimeSymbols.RelativeDateTimeSymbols_hy;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ia =  {
  DAY: {
    LONG:{
      R:{'-1':'heri','0':'hodie','1':'deman'},
      P:'one{# die retro}other{# dies retro}',
      F:'one{in # die}other{in # dies}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'iste hora'},
      P:'one{# hora retro}other{# horas retro}',
      F:'one{in # hora}other{in # horas}',
    },
    SHORT:{
      R:{'0':'iste hora'},
      P:'one{# hr. retro}other{# hr. retro}',
      F:'one{in # hr.}other{in # hr.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'iste minuta'},
      P:'one{# minuta retro}other{# minutas retro}',
      F:'one{in # minuta}other{in # minutas}',
    },
    SHORT:{
      R:{'0':'iste minuta'},
      P:'one{# min. retro}other{# min. retro}',
      F:'one{in # min.}other{in # min.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'le mense passate','0':'iste mense','1':'le mense proxime'},
      P:'one{# mense retro}other{# menses retro}',
      F:'one{in # mense}other{in # menses}',
    },
    SHORT:{
      R:{'-1':'mns. pass.','0':'iste mns.','1':'mns. prox.'},
      P:'one{# mns. retro}other{# mns. retro}',
      F:'one{in # mns.}other{in # mns.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'le trimestre passate','0':'iste trimestre','1':'le trimestre proxime'},
      P:'one{# trimestre retro}other{# trimestres retro}',
      F:'one{in # trimestre}other{in # trimestres}',
    },
    SHORT:{
      R:{'-1':'le trimestre passate','0':'iste trimestre','1':'le trimestre proxime'},
      P:'one{# trim. retro}other{# trim. retro}',
      F:'one{in # trim.}other{in # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ora'},
      P:'one{# secunda retro}other{# secundas retro}',
      F:'one{in # secunda}other{in # secundas}',
    },
    SHORT:{
      R:{'0':'ora'},
      P:'one{# sec. retro}other{# sec. retro}',
      F:'one{in # sec.}other{in # sec.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'le septimana passate','0':'iste septimana','1':'le septimana proxime'},
      P:'one{# septimana retro}other{# septimanas retro}',
      F:'one{in # septimana}other{in # septimanas}',
    },
    SHORT:{
      R:{'-1':'sept. pass.','0':'iste sept.','1':'sept. prox.'},
      P:'one{# sept. retro}other{# sept. retro}',
      F:'one{in # sept.}other{in # sept.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'le anno passate','0':'iste anno','1':'le anno proxime'},
      P:'one{# anno retro}other{# annos retro}',
      F:'one{in # anno}other{in # annos}',
    },
    SHORT:{
      R:{'-1':'an. pass.','0':'iste an.','1':'an. prox.'},
      P:'one{# an. retro}other{# an. retro}',
      F:'one{in # an.}other{in # an.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ia_001 = exports.RelativeDateTimeSymbols_ia;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_id_ID = relativeDateTimeSymbols.RelativeDateTimeSymbols_id;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ig =  {
  DAY: {
    LONG:{
      R:{'-1':'Ụnyaahụ','0':'Taa','1':'Echi'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
    SHORT:{
      R:{'-1':'Ụnyaahụ','0':'Taata','1':'Echi'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'elekere a'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'nkejị a'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'Ọnwa gara aga','0':'Ọnwa a','1':'Ọnwa ọzọ'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'Nkejị keanọ gara aga','0':'nkejị keanọ a','1':'nkejị keanọ na abịa'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ụgbụa'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'Izu gara aga','0':'Izu a','1':'Izu na-esote'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'Afọ gara aga','0':'Afọ a','1':'Afọ ọzọ'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ig_NG = exports.RelativeDateTimeSymbols_ig;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ii =  {
  DAY: {
    LONG:{
      R:{'-1':'ꀋꅔꉈ','-2':'ꎴꂿꋍꑍ','0':'ꀃꑍ','1':'ꃆꏂꑍ','2':'ꌕꀿꑍ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ii_CN = exports.RelativeDateTimeSymbols_ii;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_is_IS = relativeDateTimeSymbols.RelativeDateTimeSymbols_is;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_it_CH = relativeDateTimeSymbols.RelativeDateTimeSymbols_it;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_it_IT = relativeDateTimeSymbols.RelativeDateTimeSymbols_it;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_it_SM = relativeDateTimeSymbols.RelativeDateTimeSymbols_it;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_it_VA = relativeDateTimeSymbols.RelativeDateTimeSymbols_it;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ja_JP = relativeDateTimeSymbols.RelativeDateTimeSymbols_ja;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_jgo =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'lɔꞋɔ','1':'tomorrow'},
      P:'one{Ɛ́ gɛ́ mɔ́ lɛ́Ꞌ #}other{Ɛ́ gɛ́ mɔ́ lɛ́Ꞌ #}',
      F:'one{Nǔu lɛ́Ꞌ #}other{Nǔu lɛ́Ꞌ #}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{ɛ́ gɛ mɔ́ # háwa}other{ɛ́ gɛ mɔ́ # háwa}',
      F:'one{nǔu háwa #}other{nǔu háwa #}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{ɛ́ gɛ́ mɔ́ minút #}other{ɛ́ gɛ́ mɔ́ minút #}',
      F:'one{nǔu # minút}other{nǔu # minút}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{ɛ́ gɛ́ mɔ́ pɛsaŋ #}other{ɛ́ gɛ́ mɔ́ pɛsaŋ #}',
      F:'one{Nǔu # saŋ}other{Nǔu # saŋ}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{Ɛ́ gɛ́ mɔ # ŋgap-mbi}other{Ɛ́ gɛ́ mɔ # ŋgap-mbi}',
      F:'one{Nǔu ŋgap-mbi #}other{Nǔu ŋgap-mbi #}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{Ɛ́gɛ́ mɔ́ ŋguꞋ #}other{Ɛ́gɛ́ mɔ́ ŋguꞋ #}',
      F:'one{Nǔu ŋguꞋ #}other{Nǔu ŋguꞋ #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_jgo_CM = exports.RelativeDateTimeSymbols_jgo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_jmc =  {
  DAY: {
    LONG:{
      R:{'-1':'Ukou','0':'Inu','1':'Ngama'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_jmc_TZ = exports.RelativeDateTimeSymbols_jmc;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_jv =  {
  DAY: {
    LONG:{
      R:{'-1':'wingi','0':'dino iki','1':'sesuk'},
      P:'other{# dina kepungkur}',
      F:'other{ing # dina}',
    },
    NARROW:{
      R:{'-1':'wingi','0':'dino iki','1':'sesuk'},
      P:'other{# dino kepungkur}',
      F:'other{ing # dina}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'jam iki'},
      P:'other{# jam kepungkur}',
      F:'other{ing # jam}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'menit iki'},
      P:'other{# menit kepungkur}',
      F:'other{ing # menit}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'sasi wingi','0':'sasi iki','1':'sasi ngarep'},
      P:'other{# sasi kepungkur}',
      F:'other{ing # sasi}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'triwulan wingi','0':'triwulan iki','1':'triwulan ngarep'},
      P:'other{# triwulan kepungkur}',
      F:'other{ing # triwulan}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'saiki'},
      P:'other{# detik kepungkur}',
      F:'other{ing # detik}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'pekan wingi','0':'pekan iki','1':'pekan ngarep'},
      P:'other{# pekan kepungkur}',
      F:'other{ing # pekan}',
    },
    SHORT:{
      R:{'-1':'pkn wingi','0':'pkn iki','1':'pkn ngarep'},
      P:'other{# pekan kepungkur}',
      F:'other{ing # pekan}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'taun wingi','0':'taun iki','1':'taun ngarep'},
      P:'other{# taun kepungkur}',
      F:'other{ing # taun}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_jv_ID = exports.RelativeDateTimeSymbols_jv;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ka_GE = relativeDateTimeSymbols.RelativeDateTimeSymbols_ka;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kab =  {
  DAY: {
    LONG:{
      R:{'-1':'Iḍelli','0':'Ass-a','1':'Azekka'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kab_DZ = exports.RelativeDateTimeSymbols_kab;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kam =  {
  DAY: {
    LONG:{
      R:{'-1':'Ĩyoo','0':'Ũmũnthĩ','1':'Ũnĩ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kam_KE = exports.RelativeDateTimeSymbols_kam;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kde =  {
  DAY: {
    LONG:{
      R:{'-1':'Lido','0':'Nelo','1':'Nundu'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kde_TZ = exports.RelativeDateTimeSymbols_kde;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kea =  {
  DAY: {
    LONG:{
      R:{'-1':'onti','0':'oji','1':'manhan'},
      P:'other{a ten # dia}',
      F:'other{di li # dia}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'es ora li'},
      P:'other{a ten # ora}',
      F:'other{di li # ora}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'es minutu li'},
      P:'other{a ten # minutu}',
      F:'other{di li # minutu}',
    },
    SHORT:{
      R:{'0':'es minutu li'},
      P:'other{a ten # min}',
      F:'other{di li # min}',
    },
    NARROW:{
      R:{'0':'es minutu li'},
      P:'other{a ten # m}',
      F:'other{di li # m}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mes pasadu','0':'es mes li','1':'prósimu mes'},
      P:'other{a ten # mes}',
      F:'other{di li # mes}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestri pasadu','0':'es trimestri li','1':'prósimu trimestri'},
      P:'other{a ten # trimestri}',
      F:'other{di li # trimestri}',
    },
    SHORT:{
      R:{'-1':'trimestri pasadu','0':'es trimestri li','1':'prósimu trimestri'},
      P:'other{a ten # trim.}',
      F:'other{di li # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'other{a ten # sigundu}',
      F:'other{di li # sigundu}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'other{a ten # sig}',
      F:'other{di li # sig}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'other{a ten # s}',
      F:'other{di li # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'simana pasadu','0':'es simana li','1':'prósimu simana'},
      P:'other{a ten # simana}',
      F:'other{di li # simana}',
    },
    SHORT:{
      R:{'-1':'simana pasadu','0':'es simana li','1':'prósimu simana'},
      P:'other{a ten # sim.}',
      F:'other{di li # sim.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'anu pasadu','0':'es anu li','1':'prósimu anu'},
      P:'other{a ten # anu}',
      F:'other{di li # anu}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kea_CV = exports.RelativeDateTimeSymbols_kea;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kgp =  {
  DAY: {
    LONG:{
      R:{'-1':'rãketá','-2':'rãké ũn tá','0':'uri','1':'vajkỹ','2':'vaj ũn ka'},
      P:'one{kurã # si ser}other{kurã # si ser}',
      F:'one{kurã # kar kỹ}other{kurã # kar kỹ}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'óra tag kã'},
      P:'one{óra # si ser}other{óra # si ser}',
      F:'one{óra # kar kỹ}other{óra # kar kỹ}',
    },
    SHORT:{
      R:{'0':'óra tag kã'},
      P:'one{# h si ser}other{# h si ser}',
      F:'one{# h kar kỹ}other{# h kar kỹ}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'mĩnũtu tag'},
      P:'one{mĩnũtu # si ser}other{mĩnũtu # si ser}',
      F:'one{mĩnũtu # kar kỹ}other{mĩnũtu # kar kỹ}',
    },
    SHORT:{
      R:{'0':'mĩnũtu tag'},
      P:'one{mĩn. # si ser}other{mĩn. # si ser}',
      F:'one{mĩn. # kar kỹ}other{mĩn. # kar kỹ}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'kysã tĩ mũn kã','0':'kysã tag kã','1':'kysã ũn kã'},
      P:'one{kysã # si ser}other{kysã # si ser}',
      F:'one{kysã # kar kỹ}other{kysã # kar kỹ}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'kysã tẽgtũ ẽg no','0':'kysã tẽgtũ tag','1':'kysã tẽgtũ ũn kã'},
      P:'one{kysã-tẽgtũ # si ser}other{kysã-tẽgtũ # si ser}',
      F:'one{kysã-tẽgtũ # kar kỹ}other{kysã-tẽgtũ # kar kỹ}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ha'},
      P:'one{segũno # si ser}other{segũno # si ser}',
      F:'one{segũno # kar kỹ}other{segũno # kar kỹ}',
    },
    SHORT:{
      R:{'0':'ha'},
      P:'one{seg. # si ser}other{seg. # si ser}',
      F:'one{seg. # kar kỹ}other{seg. # kar kỹ}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'simỹnỹ tĩ mũn kã','0':'simỹnỹ tag kã','1':'simỹnỹ ũn kã'},
      P:'one{simỹnỹ # si ser}other{simỹnỹ # si ser}',
      F:'one{simỹnỹ # kar kỹ}other{simỹnỹ # kar kỹ}',
    },
    SHORT:{
      R:{'-1':'simỹnỹ tĩ mũn kã','0':'simỹnỹ tag kã','1':'simỹnỹ ũn kã'},
      P:'one{sim. # si ser}other{sim. # si ser}',
      F:'one{sim. # kar kỹ}other{sim. # kar kỹ}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'prỹg tĩ mũnh kã','0':'prỹg tag kã','1':'prỹg ũ kã'},
      P:'one{prỹg # si ser}other{prỹg # si ser}',
      F:'one{prỹg # kar kỹ}other{prỹg # kar kỹ}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kgp_BR = exports.RelativeDateTimeSymbols_kgp;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_khq =  {
  DAY: {
    LONG:{
      R:{'-1':'Bi','0':'Hõo','1':'Suba'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_khq_ML = exports.RelativeDateTimeSymbols_khq;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ki =  {
  DAY: {
    LONG:{
      R:{'-1':'Ira','0':'Ũmũthĩ','1':'Rũciũ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ki_KE = exports.RelativeDateTimeSymbols_ki;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kk_KZ = relativeDateTimeSymbols.RelativeDateTimeSymbols_kk;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kkj =  {
  DAY: {
    LONG:{
      R:{'-1':'kwey','0':'muka','1':'nɛmɛnɔ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kkj_CM = exports.RelativeDateTimeSymbols_kkj;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kl =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'one{for # ulloq unnuarlu siden}other{for # ulloq unnuarlu siden}',
      F:'one{om # ulloq unnuarlu}other{om # ulloq unnuarlu}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{for # nalunaaquttap-akunnera siden}other{for # nalunaaquttap-akunnera siden}',
      F:'one{om # nalunaaquttap-akunnera}other{om # nalunaaquttap-akunnera}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{for # minutsi siden}other{for # minutsi siden}',
      F:'one{om # minutsi}other{om # minutsi}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{for # qaammat siden}other{for # qaammat siden}',
      F:'one{om # qaammat}other{om # qaammat}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{for # sekundi siden}other{for # sekundi siden}',
      F:'one{om # sekundi}other{om # sekundi}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{for # sapaatip-akunnera siden}other{for # sapaatip-akunnera siden}',
      F:'one{om # sapaatip-akunnera}other{om # sapaatip-akunnera}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{for # ukioq siden}other{for # ukioq siden}',
      F:'one{om # ukioq}other{om # ukioq}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kl_GL = exports.RelativeDateTimeSymbols_kl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kln =  {
  DAY: {
    LONG:{
      R:{'-1':'Amut','0':'Raini','1':'Mutai'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kln_KE = exports.RelativeDateTimeSymbols_kln;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_km_KH = relativeDateTimeSymbols.RelativeDateTimeSymbols_km;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kn_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_kn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ko_KP = relativeDateTimeSymbols.RelativeDateTimeSymbols_ko;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ko_KR = relativeDateTimeSymbols.RelativeDateTimeSymbols_ko;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kok =  {
  DAY: {
    LONG:{
      R:{'-1':'काल','0':'आयज','1':'फाल्यां'},
      P:'other{# दीस आदीं}',
      F:'other{# दिसानीं}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'हें वर'},
      P:'other{# वरा आदीं}',
      F:'other{# वरांनीं}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'हें मिनीट'},
      P:'other{# मिन्टां आदीं}',
      F:'other{# मिन्टां}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'फाटलो म्हयनो','0':'हो म्हयनो','1':'फुडलो म्हयनो'},
      P:'other{# म्हयन्यां आदीं}',
      F:'other{# म्हयन्यानीं}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'फाटलो त्रैमासीक','0':'हो त्रैमासीक','1':'फुडलो त्रैमासीक'},
      P:'other{# त्रैमासीकां आदीं}',
      F:'other{# त्रैमासीकांत}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'आतां'},
      P:'other{# सेकंद आदीं}',
      F:'other{# सेकंदानीं}',
    },
    SHORT:{
      R:{'0':'आतां'},
      P:'other{# से. आदीं}',
      F:'other{# सेकंदानीं}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'निमाणो सप्तक','0':'हो सप्तक','1':'फुडलो सप्तक'},
      P:'other{# सप्तकां आदीं}',
      F:'other{# सप्तकांनीं}',
    },
    NARROW:{
      R:{'-1':'निमाणो सप्तक','0':'हो सप्तक','1':'फुडलो सप्तक'},
      P:'other{# सप्त. आदीं}',
      F:'other{# सप्तकांनीं}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'फाटलें वर्स','0':'हें वर्स','1':'फुडलें वर्स'},
      P:'other{# वर्सां आदीं}',
      F:'other{# वर्सांनीं}',
    },
    SHORT:{
      R:{'-1':'फाटलें वर्स','0':'हें वर्स','1':'फुडलें वर्स'},
      P:'other{# वर्स आदीं}',
      F:'other{# वर्सांनीं}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kok_IN = exports.RelativeDateTimeSymbols_kok;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ks =  {
  DAY: {
    LONG:{
      R:{'-1':'راتھ','0':'اَز','1':'پگاہ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'پٔتِم ریتھۍ','0':'یٕہ ریتھۍ','1':'نو ریتھۍ'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'پٔتِم ہفتہ','0':'یٕہ ہفتہ','1':'نو ہفتہ'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'پٔتِم ؤری','0':'یٕہ ؤری','1':'نو ؤری'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ks_Arab = exports.RelativeDateTimeSymbols_ks;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ks_Arab_IN = exports.RelativeDateTimeSymbols_ks;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ks_Deva =  {
  DAY: {
    LONG:{
      R:{'-1':'राथ','0':'अज़','1':'पगाह'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ks_Deva_IN =  {
  DAY: {
    LONG:{
      R:{'-1':'राथ','0':'अज़','1':'पगाह'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ksb =  {
  DAY: {
    LONG:{
      R:{'-1':'Ghuo','0':'Evi eo','1':'Keloi'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ksb_TZ = exports.RelativeDateTimeSymbols_ksb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ksf =  {
  DAY: {
    LONG:{
      R:{'-1':'Rinkɔɔ́','0':'Gɛ́ɛnǝ','1':'Ridúrǝ́'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ksf_CM = exports.RelativeDateTimeSymbols_ksf;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ksh =  {
  DAY: {
    LONG:{
      R:{'-1':'jestere','-2':'vörjestere','0':'hück','1':'morje','2':'övvermorje'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'lätzde Mohnd','0':'diese Mohnd','1':'nächste Mohnd'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'läz Woch','0':'di Woch','1':'nächste Woche'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'läz Johr','0':'diß Johr','1':'näx Johr'},
      P:'one{vör # Johr}other{vör # Johre}zero{vör keijnem Johr}',
      F:'one{en # Johr}other{en # Johre}zero{en keinem Johr}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ksh_DE = exports.RelativeDateTimeSymbols_ksh;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ku =  {
  DAY: {
    LONG:{
      R:{'-1':'duh','0':'îro','1':'sibe'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'meha borî','0':'vê mehê','1':'meha were'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
    SHORT:{
      R:{'-1':'meha br.','0':'vê mehê','1':'meha bê'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'hefteya borî','0':'vê hefteyê','1':'hefteya were'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
    SHORT:{
      R:{'-1':'hft. borî','0':'vê hft.','1':'hft. bê'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'par','0':'îsal','1':'sala piştî'},
      P:'one{berî # salê}other{berî # salan}',
      F:'one{di salekê de}other{di # salan de}',
    },
    SHORT:{
      R:{'-1':'par','0':'îsal','1':'sala bê'},
      P:'one{berî salekê}other{berî # salan}',
      F:'one{piştî salekê}other{piştî # salan}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ku_TR = exports.RelativeDateTimeSymbols_ku;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kw =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_kw_GB = exports.RelativeDateTimeSymbols_kw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ky_KG = relativeDateTimeSymbols.RelativeDateTimeSymbols_ky;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lag =  {
  DAY: {
    LONG:{
      R:{'-1':'Niijo','0':'Isikʉ','1':'Lamʉtoondo'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lag_TZ = exports.RelativeDateTimeSymbols_lag;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lb =  {
  DAY: {
    LONG:{
      R:{'-1':'gëschter','0':'haut','1':'muer'},
      P:'one{virun # Dag}other{viru(n) # Deeg}',
      F:'one{an # Dag}other{a(n) # Deeg}',
    },
    SHORT:{
      R:{'-1':'gëschter','0':'haut','1':'muer'},
      P:'one{virun # D.}other{viru(n) # D.}',
      F:'one{an # D.}other{a(n) # D.}',
    },
    NARROW:{
      R:{'-1':'gëschter','0':'haut','1':'muer'},
      P:'one{-# D.}other{-# D.}',
      F:'one{+# D.}other{+# D.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{virun # Stonn}other{viru(n) # Stonnen}',
      F:'one{an # Stonn}other{a(n) # Stonnen}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'one{virun # St.}other{viru(n) # St.}',
      F:'one{an # St.}other{a(n) # St.}',
    },
    NARROW:{
      R:{'0':'this hour'},
      P:'one{-# St.}other{-# St.}',
      F:'one{+# St.}other{+# St.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{virun # Minutt}other{viru(n) # Minutten}',
      F:'one{an # Minutt}other{a(n) # Minutten}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'one{virun # Min.}other{viru(n) # Min.}',
      F:'one{an # Min.}other{a(n) # Min.}',
    },
    NARROW:{
      R:{'0':'this minute'},
      P:'one{-# Min.}other{-# Min.}',
      F:'one{+# Min.}other{+# Min.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'leschte Mount','0':'dëse Mount','1':'nächste Mount'},
      P:'one{virun # Mount}other{viru(n) # Méint}',
      F:'one{an # Mount}other{a(n) # Méint}',
    },
    SHORT:{
      R:{'-1':'leschte Mount','0':'dëse Mount','1':'nächste Mount'},
      P:'one{virun # M.}other{viru(n) # M.}',
      F:'one{an # M.}other{a(n) # M.}',
    },
    NARROW:{
      R:{'-1':'leschte Mount','0':'dëse Mount','1':'nächste Mount'},
      P:'one{-# M.}other{-# M.}',
      F:'one{+# M.}other{+# M.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{virun # Quartal}other{viru(n) # Quartaler}',
      F:'one{an # Quartal}other{a(n) # Quartaler}',
    },
    SHORT:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{virun # Q.}other{viru(n) # Q.}',
      F:'one{an # Q.}other{a(n) # Q.}',
    },
    NARROW:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'one{-# Q.}other{-# Q.}',
      F:'one{+# Q.}other{+# Q.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{virun # Sekonn}other{viru(n) # Sekonnen}',
      F:'one{an # Sekonn}other{a(n) # Sekonnen}',
    },
    SHORT:{
      R:{'0':'now'},
      P:'one{virun # Sek.}other{viru(n) # Sek.}',
      F:'one{an # Sek.}other{a(n) # Sek.}',
    },
    NARROW:{
      R:{'0':'now'},
      P:'one{-# Sek.}other{-# Sek.}',
      F:'one{+# Sek.}other{+# Sek.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'lescht Woch','0':'dës Woch','1':'nächst Woch'},
      P:'one{virun # Woch}other{viru(n) # Wochen}',
      F:'one{an # Woch}other{a(n) # Wochen}',
    },
    SHORT:{
      R:{'-1':'lescht Woch','0':'dës Woch','1':'nächst Woch'},
      P:'one{virun # W.}other{viru(n) # W.}',
      F:'one{an # W.}other{a(n) # W.}',
    },
    NARROW:{
      R:{'-1':'lescht Woch','0':'dës Woch','1':'nächst Woch'},
      P:'one{-# W.}other{-# W.}',
      F:'one{+# W.}other{+# W.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'lescht Joer','0':'dëst Joer','1':'nächst Joer'},
      P:'one{virun # Joer}other{viru(n) # Joer}',
      F:'one{an # Joer}other{a(n) # Joer}',
    },
    SHORT:{
      R:{'-1':'lescht Joer','0':'dëst Joer','1':'nächst Joer'},
      P:'one{virun # J.}other{viru(n) # J.}',
      F:'one{an # J.}other{a(n) # J.}',
    },
    NARROW:{
      R:{'-1':'lescht Joer','0':'dëst Joer','1':'nächst Joer'},
      P:'one{-# J.}other{-# J.}',
      F:'one{+# J.}other{+# J.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lb_LU = exports.RelativeDateTimeSymbols_lb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lg =  {
  DAY: {
    LONG:{
      R:{'-1':'Ggulo','0':'Lwaleero','1':'Nkya'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lg_UG = exports.RelativeDateTimeSymbols_lg;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lkt =  {
  DAY: {
    LONG:{
      R:{'-1':'Ȟtálehaŋ','0':'Lé aŋpétu kiŋ','1':'Híŋhaŋni kiŋháŋ'},
      P:'other{Hékta #-čháŋ k’uŋ héhaŋ}',
      F:'other{Letáŋhaŋ #-čháŋ kiŋháŋ}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{Hékta owápȟe # kʼuŋ héhaŋ}',
      F:'other{Letáŋhaŋ owápȟe # kiŋháŋ}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{Hékta oȟ’áŋkȟo # k’uŋ héhaŋ}',
      F:'other{Letáŋhaŋ oȟ’áŋkȟo # kiŋháŋ}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'Wí kʼuŋ héhaŋ','0':'Lé wí kiŋ','1':'Tȟokáta wí kiŋháŋ'},
      P:'other{Hékta wíyawapi # kʼuŋ héhaŋ}',
      F:'other{Letáŋhaŋ wíyawapi # kiŋháŋ}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{Hékta okpí # k’uŋ héhaŋ}',
      F:'other{Letáŋhaŋ okpí # kiŋháŋ}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'Okó kʼuŋ héhaŋ','0':'Lé okó kiŋ','1':'Tȟokáta okó kiŋháŋ'},
      P:'other{Hékta okó # kʼuŋ héhaŋ}',
      F:'other{Letáŋhaŋ okó # kiŋháŋ}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'Ómakȟa kʼuŋ héhaŋ','0':'Lé ómakȟa kiŋ','1':'Tȟokáta ómakȟa kiŋháŋ'},
      P:'other{Hékta ómakȟa # kʼuŋ héhaŋ}',
      F:'other{Letáŋhaŋ ómakȟa # kiŋháŋ}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lkt_US = exports.RelativeDateTimeSymbols_lkt;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ln_AO = relativeDateTimeSymbols.RelativeDateTimeSymbols_ln;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ln_CD = relativeDateTimeSymbols.RelativeDateTimeSymbols_ln;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ln_CF = relativeDateTimeSymbols.RelativeDateTimeSymbols_ln;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ln_CG = relativeDateTimeSymbols.RelativeDateTimeSymbols_ln;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lo_LA = relativeDateTimeSymbols.RelativeDateTimeSymbols_lo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lrc =  {
  DAY: {
    LONG:{
      R:{'-1':'دیروٙز','0':'أمروٙ','1':'شوٙصوٙ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lrc_IQ = exports.RelativeDateTimeSymbols_lrc;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lrc_IR = exports.RelativeDateTimeSymbols_lrc;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lt_LT = relativeDateTimeSymbols.RelativeDateTimeSymbols_lt;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lu =  {
  DAY: {
    LONG:{
      R:{'-1':'Makelela','0':'Lelu','1':'Malaba'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lu_CD = exports.RelativeDateTimeSymbols_lu;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_luo =  {
  DAY: {
    LONG:{
      R:{'-1':'nyoro','0':'kawuono','1':'kiny'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_luo_KE = exports.RelativeDateTimeSymbols_luo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_luy =  {
  DAY: {
    LONG:{
      R:{'-1':'Mgorova','0':'Lero','1':'Mgamba'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_luy_KE = exports.RelativeDateTimeSymbols_luy;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_lv_LV = relativeDateTimeSymbols.RelativeDateTimeSymbols_lv;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mai =  {
  DAY: {
    LONG:{
      R:{'-1':'काल्हिक दिन','0':'आजुक दिन','1':'काल्हिक दिन'},
      P:'other{# दिन मे}',
      F:'other{# दिन मे}',
    },
    SHORT:{
      R:{'-1':'बीतल काल्हि','0':'आजुक दिन','1':'आबय वला काल्हि'},
      P:'other{#दिन पहिले}',
      F:'other{# दिन मे}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'एहि घंटा'},
      P:'other{# घंटा पहिले}',
      F:'other{# घंटा मे}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'एहि मिनट'},
      P:'other{# मिनट पहिले}',
      F:'other{# मिनट मे}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'बीतल माह','0':'एहि माह','1':'अगिला माह'},
      P:'other{# माह पहिले}',
      F:'other{# माह मे}',
    },
    NARROW:{
      R:{'-1':'बीतल माह','0':'एहि माह','1':'अगिला माह'},
      P:'other{#माह पहिले}',
      F:'other{#माह मे}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'बीतल तिमाही','0':'एहि तिमाही','1':'अगिला तिमाही'},
      P:'other{# तिमाही पहिले}',
      F:'other{# तिमाही मे}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'एहि समय'},
      P:'other{# सेकेंड पहिले}',
      F:'other{# सेकेंड मे}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'बीतल सप्ताह','0':'एहि सप्ताह','1':'अगिला सप्ताह'},
      P:'other{# सप्ताह पहिले}',
      F:'other{# सप्ताह मे}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'बीतल बरख','0':'एहि बरख','1':'अगिला बरख'},
      P:'other{# बरख पहिले}',
      F:'other{# बरख मे}',
    },
    NARROW:{
      R:{'-1':'बीतल बरख','0':'एहि बरख','1':'अगिला बरख'},
      P:'other{#बरख पहिले}',
      F:'other{#बरख मे}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mai_IN = exports.RelativeDateTimeSymbols_mai;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mas =  {
  DAY: {
    LONG:{
      R:{'-1':'Ŋolé','0':'Táatá','1':'Tááisérè'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mas_KE = exports.RelativeDateTimeSymbols_mas;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mas_TZ = exports.RelativeDateTimeSymbols_mas;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mer =  {
  DAY: {
    LONG:{
      R:{'-1':'Ĩgoro','0':'Narua','1':'Rũjũ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mer_KE = exports.RelativeDateTimeSymbols_mer;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mfe =  {
  DAY: {
    LONG:{
      R:{'-1':'Yer','0':'Zordi','1':'Demin'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mfe_MU = exports.RelativeDateTimeSymbols_mfe;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mg =  {
  DAY: {
    LONG:{
      R:{'-1':'Omaly','0':'Anio','1':'Rahampitso'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mg_MG = exports.RelativeDateTimeSymbols_mg;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mgh =  {
  DAY: {
    LONG:{
      R:{'-1':'n’chana','0':'lel’lo','1':'me’llo'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mgh_MZ = exports.RelativeDateTimeSymbols_mgh;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mgo =  {
  DAY: {
    LONG:{
      R:{'-1':'ikwiri','0':'tèchɔ̀ŋ','1':'isu','2':'isu ywi'},
      P:'one{-# d}other{-# d}',
      F:'one{+# d}other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{-# m}other{-# m}',
      F:'one{+# m}other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mgo_CM = exports.RelativeDateTimeSymbols_mgo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mi =  {
  DAY: {
    LONG:{
      R:{'-1':'inanahi','0':'i tēnei rā','1':'āpōpō'},
      P:'other{-# r.}',
      F:'other{+# r.}',
    },
    SHORT:{
      R:{'-1':'inanahi','0':'i tēnei rā','1':'āpōpō'},
      P:'other{-# r.}',
      F:'other{+# r}',
    },
    NARROW:{
      R:{'-1':'inanahi','0':'i tēnei rā','1':'āpōpō'},
      P:'other{-# r}',
      F:'other{+# r}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'i tēnei hāora'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
    SHORT:{
      R:{'0':'i tēnei hāora'},
      P:'other{-# h.}',
      F:'other{+# h.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'i tēnei meneti'},
      P:'other{-# men}',
      F:'other{+# men}',
    },
    SHORT:{
      R:{'0':'i tēnei meneti'},
      P:'other{-# men.}',
      F:'other{+# men.}',
    },
    NARROW:{
      R:{'0':'i tēnei meneti'},
      P:'other{-# men}',
      F:'other{+# men}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'i tērā marama','0':'i tēnei marama','1':'ā tērā marama'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
    SHORT:{
      R:{'-1':'i tērā m.','0':'i tēnei m.','1':'ā tērā m.'},
      P:'other{-# m.}',
      F:'other{+# m.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'hauwhā whakamutunga','0':'tēnei hauwhā','1':'tērā hauwhā'},
      P:'other{-# hwh}',
      F:'other{+# hwh}',
    },
    NARROW:{
      R:{'-1':'hauwhā whakamutunga','0':'tēnei hauwhā','1':'tērā hauwhā'},
      P:'other{-# hwh}',
      F:'other{+# Hwh}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ināianei'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
    SHORT:{
      R:{'0':'ināianei'},
      P:'other{-# h.}',
      F:'other{+# h.}',
    },
    NARROW:{
      R:{'0':'ināianei'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'i tērā wiki','0':'i tēnei wiki','1':'ā tērā wiki'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
    SHORT:{
      R:{'-1':'i tērā w.','0':'i tēnei w.','1':'ā tērā w.'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'i tērā tau','0':'i tēnei tau','1':'ā tērā tau'},
      P:'other{i te # tau}',
      F:'other{ā te # tau}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mi_NZ = exports.RelativeDateTimeSymbols_mi;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mk_MK = relativeDateTimeSymbols.RelativeDateTimeSymbols_mk;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ml_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_ml;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mn_MN = relativeDateTimeSymbols.RelativeDateTimeSymbols_mn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mni =  {
  DAY: {
    LONG:{
      R:{'-1':'ঙরাং','0':'ঙসি','1':'হয়েং'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'হাকুম/ মমাংগী চহি','0':'কুমশি','1':'মথং চহি'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mni_Beng = exports.RelativeDateTimeSymbols_mni;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mni_Beng_IN = exports.RelativeDateTimeSymbols_mni;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mr_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_mr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ms_BN = relativeDateTimeSymbols.RelativeDateTimeSymbols_ms;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ms_ID = relativeDateTimeSymbols.RelativeDateTimeSymbols_ms;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ms_MY = relativeDateTimeSymbols.RelativeDateTimeSymbols_ms;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ms_SG = relativeDateTimeSymbols.RelativeDateTimeSymbols_ms;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mt_MT = relativeDateTimeSymbols.RelativeDateTimeSymbols_mt;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mua =  {
  DAY: {
    LONG:{
      R:{'-1':'Tǝsoo','0':'Tǝ’nahko','1':'Tǝ’nane'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mua_CM = exports.RelativeDateTimeSymbols_mua;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_my_MM = relativeDateTimeSymbols.RelativeDateTimeSymbols_my;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mzn =  {
  DAY: {
    LONG:{
      R:{'-1':'دیروز','0':'اَمروز','1':'فِردا'},
      P:'other{# روز پیش}',
      F:'other{# روز دله}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{# ساعِت پیش}',
      F:'other{# ساعِت دله}',
    },
    SHORT:{
      R:{'0':'this hour'},
      P:'other{# ساعت پیش}',
      F:'other{# ساعت دله}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{# دَقه پیش}',
      F:'other{# دقیقه دله}',
    },
    SHORT:{
      R:{'0':'this minute'},
      P:'other{# دَقه پیش}',
      F:'other{# دَقه دله}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'ماه قبل','0':'این ماه','1':'ماه ِبعد'},
      P:'other{# ماه پیش}',
      F:'other{# ماه دله}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{# ربع پیش}',
      F:'other{# ربع دله}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{# ثانیه پیش}',
      F:'other{# ثانیه دله}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'قبلی هفته','0':'این هفته','1':'بعدی هفته'},
      P:'other{# هفته پیش}',
      F:'other{# هفته دله}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'پارسال','0':'امسال','1':'سال دیگه'},
      P:'other{# سال پیش}',
      F:'other{# سال دله}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_mzn_IR = exports.RelativeDateTimeSymbols_mzn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_naq =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'Neetsee','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_naq_NA = exports.RelativeDateTimeSymbols_naq;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nb_NO = relativeDateTimeSymbols.RelativeDateTimeSymbols_nb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nb_SJ = relativeDateTimeSymbols.RelativeDateTimeSymbols_nb;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nd =  {
  DAY: {
    LONG:{
      R:{'-1':'Izolo','0':'Lamuhla','1':'Kusasa'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nd_ZW = exports.RelativeDateTimeSymbols_nd;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ne_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_ne;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ne_NP = relativeDateTimeSymbols.RelativeDateTimeSymbols_ne;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nl_AW = relativeDateTimeSymbols.RelativeDateTimeSymbols_nl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nl_BE = relativeDateTimeSymbols.RelativeDateTimeSymbols_nl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nl_BQ = relativeDateTimeSymbols.RelativeDateTimeSymbols_nl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nl_CW = relativeDateTimeSymbols.RelativeDateTimeSymbols_nl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nl_NL = relativeDateTimeSymbols.RelativeDateTimeSymbols_nl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nl_SR = relativeDateTimeSymbols.RelativeDateTimeSymbols_nl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nl_SX = relativeDateTimeSymbols.RelativeDateTimeSymbols_nl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nmg =  {
  DAY: {
    LONG:{
      R:{'-1':'Nakugú','0':'Dɔl','1':'Namáná'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nmg_CM = exports.RelativeDateTimeSymbols_nmg;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nn =  {
  DAY: {
    LONG:{
      R:{'-1':'i går','-2':'i førgår','0':'i dag','1':'i morgon','2':'i overmorgon'},
      P:'one{for # døgn sidan}other{for # døgn sidan}',
      F:'one{om # døgn}other{om # døgn}',
    },
    SHORT:{
      R:{'-1':'i går','0':'i dag','1':'i morgon'},
      P:'one{for # d. sidan}other{for # d. sidan}',
      F:'one{om # d.}other{om # d.}',
    },
    NARROW:{
      R:{'-1':'i går','0':'i dag','1':'i morgon'},
      P:'one{–# d.}other{–# d.}',
      F:'one{+# d.}other{+# d.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'denne timen'},
      P:'one{for # time sidan}other{for # timar sidan}',
      F:'one{om # time}other{om # timar}',
    },
    SHORT:{
      R:{'0':'denne timen'},
      P:'one{for # t sidan}other{for # t sidan}',
      F:'one{om # t}other{om # t}',
    },
    NARROW:{
      R:{'0':'denne timen'},
      P:'one{–# t}other{–# t}',
      F:'one{+# t}other{+# t}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'dette minuttet'},
      P:'one{for # minutt sidan}other{for # minutt sidan}',
      F:'one{om # minutt}other{om # minutt}',
    },
    SHORT:{
      R:{'0':'dette minuttet'},
      P:'one{for # min sidan}other{for # min sidan}',
      F:'one{om # min}other{om # min}',
    },
    NARROW:{
      R:{'0':'dette minuttet'},
      P:'one{–# min}other{–# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'førre månad','0':'denne månaden','1':'neste månad'},
      P:'one{for # månad sidan}other{for # månadar sidan}',
      F:'one{om # månad}other{om # månadar}',
    },
    SHORT:{
      R:{'-1':'førre md.','0':'denne md.','1':'neste md.'},
      P:'one{for # md. sidan}other{for # md. sidan}',
      F:'one{om # md.}other{om # md.}',
    },
    NARROW:{
      R:{'-1':'førre md.','0':'denne md.','1':'neste md.'},
      P:'one{–# md.}other{–# md.}',
      F:'one{+# md.}other{+# md.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'førre kvartal','0':'dette kvartalet','1':'neste kvartal'},
      P:'one{for # kvartal sidan}other{for # kvartal sidan}',
      F:'one{om # kvartal}other{om # kvartal}',
    },
    SHORT:{
      R:{'-1':'forrige kv.','0':'dette kv.','1':'neste kv.'},
      P:'one{for # kv. sidan}other{for # kv. sidan}',
      F:'one{om # kv.}other{om # kv.}',
    },
    NARROW:{
      R:{'-1':'forrige kv.','0':'dette kv.','1':'neste kv.'},
      P:'one{–# kv.}other{–# kv.}',
      F:'one{+# kv.}other{+# kv.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'no'},
      P:'one{for # sekund sidan}other{for # sekund sidan}',
      F:'one{om # sekund}other{om # sekund}',
    },
    SHORT:{
      R:{'0':'nå'},
      P:'one{for # sek sidan}other{for # sek sidan}',
      F:'one{om # sek}other{om # sek}',
    },
    NARROW:{
      R:{'0':'nå'},
      P:'one{–# s}other{–# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'førre veke','0':'denne veka','1':'neste veke'},
      P:'one{for # veke sidan}other{for # veker sidan}',
      F:'one{om # veke}other{om # veker}',
    },
    SHORT:{
      R:{'-1':'førre veke','0':'denne veka','1':'neste veke'},
      P:'one{for # v. sidan}other{for # v. sidan}',
      F:'one{om # v.}other{om # v.}',
    },
    NARROW:{
      R:{'-1':'førre veke','0':'denne veka','1':'neste veke'},
      P:'one{–# v.}other{–# v.}',
      F:'one{+# v.}other{+# v.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'i fjor','0':'i år','1':'neste år'},
      P:'one{for # år sidan}other{for # år sidan}',
      F:'one{om # år}other{om # år}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nn_NO = exports.RelativeDateTimeSymbols_nn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nnh =  {
  DAY: {
    LONG:{
      R:{'-1':'jǔɔ gẅie à ka tɔ̌g','0':'lyɛ̌ʼɔɔn','1':'jǔɔ gẅie à ne ntóo'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nnh_CM = exports.RelativeDateTimeSymbols_nnh;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nus =  {
  DAY: {
    LONG:{
      R:{'-1':'Pan','0':'Walɛ','1':'Ruun'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nus_SS = exports.RelativeDateTimeSymbols_nus;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nyn =  {
  DAY: {
    LONG:{
      R:{'-1':'Nyomwabazyo','0':'Erizooba','1':'Nyenkyakare'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_nyn_UG = exports.RelativeDateTimeSymbols_nyn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_om =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_om_ET = exports.RelativeDateTimeSymbols_om;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_om_KE = exports.RelativeDateTimeSymbols_om;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_or_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_or;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_os =  {
  DAY: {
    LONG:{
      R:{'-1':'Знон','-2':'Ӕндӕрӕбон','0':'Абон','1':'Сом','2':'Иннӕбон'},
      P:'one{# бон раздӕр}other{# боны размӕ}',
      F:'one{# боны фӕстӕ}other{# боны фӕстӕ}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# сахаты размӕ}other{# сахаты размӕ}',
      F:'one{# сахаты фӕстӕ}other{# сахаты фӕстӕ}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_os_GE = exports.RelativeDateTimeSymbols_os;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_os_RU = exports.RelativeDateTimeSymbols_os;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pa_Arab =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pa_Arab_PK =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pa_Guru = relativeDateTimeSymbols.RelativeDateTimeSymbols_pa;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pa_Guru_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_pa;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pcm =  {
  DAY: {
    LONG:{
      R:{'-1':'Yẹ́stadè','0':'Todè','1':'Tumọ́ro'},
      P:'one{# dè wé dọ́n pas}other{# dè wé dọ́n pas}',
      F:'one{Fọ #dè wé de kọm}other{Fọ #dè wé de kọm}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'Dís áwa'},
      P:'one{# áwa wé dọ́n pas}other{# áwa wé dọ́n pas}',
      F:'one{Fọ # áwa wé de kọm}other{Fọ # áwa wé de kọm}',
    },
    NARROW:{
      R:{'0':'Dís áwa'},
      P:'one{Fọ # áwa wé de kọm}other{Fọ # áwa wé de kọm}',
      F:'one{Fọ # áwa wé de kọm}other{Fọ # áwa wé de kọm}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'Dís mínit'},
      P:'one{# mínit wé dọ́n pas}other{# mínit wé dọ́n pas}',
      F:'one{Fọ # mínit wé de kọm}other{Fọ # mínit wé de kọm}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'Lást mọnt','0':'Dís mọnt','1':'Nẹ́st mọnt'},
      P:'one{# mọnt wé dọ́n pas}other{# mọnt wé dọ́n pas}',
      F:'one{Fọ #mọnt wé de kọm}other{Fọ #mọnt wé de kọm}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'Lást kwọ́ta','0':'Dís kwọ́ta','1':'Nẹ́st kwọ́ta'},
      P:'one{# kwọ́ta wé dọ́n pas}other{# kwọ́ta wé dọ́n pas}',
      F:'one{fọ # kwọ́ta wé de kọm}other{fọ # kwọ́ta wé de kọm}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'nau'},
      P:'one{# sẹ́kọn wé dọ́n pas}other{# sẹ́kọn wé dọ́n pas}',
      F:'one{Fọ # Sẹ́kọn}other{Fọ # Sẹ́kọn}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'Lást wik','0':'Dís wik','1':'Nẹ́st wik'},
      P:'one{# wik wé dọ́n pas}other{# wik wé dọ́n pas}',
      F:'one{Fọ #wik wé de kọm}other{Fọ #wik wé de kọm}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'Lást yiẹ','0':'Dís yiẹ','1':'Nẹ́st yiẹ'},
      P:'one{# yiẹ wé dọ́n pas}other{# yiẹ wé dọ́n pas}',
      F:'one{fọ # yiẹ wé de kọm}other{fọ # yiẹ wé de kọm}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pcm_NG = exports.RelativeDateTimeSymbols_pcm;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pl_PL = relativeDateTimeSymbols.RelativeDateTimeSymbols_pl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ps =  {
  DAY: {
    LONG:{
      R:{'-1':'پرون','0':'نن','1':'سبا'},
      P:'one{# ورځ مخکې}other{# ورځې مخکې}',
      F:'one{په # ورځ کې}other{په # ورځو کې}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'دا ساعت'},
      P:'one{# ساعت مخکې}other{# ساعتونه مخکې}',
      F:'one{په # ساعت کې}other{په # ساعتو کې}',
    },
    SHORT:{
      R:{'0':'دا ساعت'},
      P:'one{# ساعت مخکې}other{# ساعت مخکې}',
      F:'one{په # ساعت کې}other{په # ساعت کې}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'دا دقيقه'},
      P:'one{# دقيقه مخکې}other{# دقيقې مخکې}',
      F:'one{په # دقيقه کې}other{په # دقيقو کې}',
    },
    SHORT:{
      R:{'0':'دا دقيقه'},
      P:'one{# دقيقه مخکې}other{# دقيقه مخکې}',
      F:'one{په # دقيقه کې}other{په # دقيقه کې}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'تېره مياشت','0':'دا مياشت','1':'راتلونکې مياشت'},
      P:'one{# مياشت مخکې}other{# مياشتې مخکې}',
      F:'one{په # مياشت کې}other{په # مياشتو کې}',
    },
    SHORT:{
      R:{'-1':'تېره مياشت','0':'دا مياشت','1':'راتلونکې مياشت'},
      P:'one{# مياشت مخکې}other{# مياشت مخکې}',
      F:'one{په # مياشت کې}other{په # مياشت کې}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'ورستۍ ربع','0':'دا ربع','1':'راتلونکې ربع'},
      P:'one{# ربع مخکې}other{# ربعې مخکې}',
      F:'one{په # ربع کې}other{په # ربعو کې}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'اوس'},
      P:'one{# ثانيه مخکې}other{# ثانيې مخکې}',
      F:'one{په # ثانيه کې}other{په # ثانيو کې}',
    },
    SHORT:{
      R:{'0':'اوس'},
      P:'one{# ثانيه مخکې}other{# ثانيه مخکې}',
      F:'one{په # ثانيه کې}other{په # ثانيه کې}',
    },
    NARROW:{
      R:{'0':'اوس'},
      P:'one{# ثانيه کې}other{# ثانيه کې}',
      F:'one{په # ثانيه کې}other{په # ثانيه کې}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'تيره اونۍ','0':'دا اونۍ','1':'راتلونکې اونۍ'},
      P:'one{# اونۍ مخکې}other{# اونۍ مخکې}',
      F:'one{په # اونۍ کې}other{په # اونيو کې}',
    },
    SHORT:{
      R:{'-1':'تېره اونۍ','0':'دا اونۍ','1':'راتلونکې اونۍ'},
      P:'one{# اونۍ مخکې}other{# اونۍ مخکې}',
      F:'one{په # اونۍ کې}other{په # اونۍ کې}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'پروسږکال','0':'سږکال','1':'راتلونکی کال'},
      P:'one{# کال مخکې}other{# کاله مخکې}',
      F:'one{په # کال کې}other{په # کالونو کې}',
    },
    SHORT:{
      R:{'-1':'تېر کال','0':'سږ کال','1':'روتلونکی کال'},
      P:'one{# کال مخکې}other{# کاله مخکې}',
      F:'one{په # کال کې}other{په # کالونو کې}',
    },
    NARROW:{
      R:{'-1':'تير کال','0':'سږ کال','1':'راتلونکی کال'},
      P:'one{# کال مخکې}other{# کاله مخکې}',
      F:'one{په # کال کې}other{په # کالونو کې}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ps_AF = exports.RelativeDateTimeSymbols_ps;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ps_PK =  {
  DAY: {
    LONG:{
      R:{'-1':'پرون','0':'نن','1':'سبا'},
      P:'one{# ورځ مخکې}other{# ورځې مخکې}',
      F:'one{په # ورځ کې}other{په # ورځو کې}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'دا ساعت'},
      P:'one{# ساعت مخکې}other{# ساعتونه مخکې}',
      F:'one{په # ساعت کې}other{په # ساعتو کې}',
    },
    SHORT:{
      R:{'0':'دا ساعت'},
      P:'one{# ساعت مخکې}other{# ساعت مخکې}',
      F:'one{په # ساعت کې}other{په # ساعت کې}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'دا دقيقه'},
      P:'one{# دقيقه مخکې}other{# دقيقې مخکې}',
      F:'one{په # دقيقه کې}other{په # دقيقو کې}',
    },
    SHORT:{
      R:{'0':'دا دقيقه'},
      P:'one{# دقيقه مخکې}other{# دقيقه مخکې}',
      F:'one{په # دقيقه کې}other{په # دقيقه کې}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'تېره مياشت','0':'دا مياشت','1':'راتلونکې مياشت'},
      P:'one{# مياشت مخکې}other{# مياشتې مخکې}',
      F:'one{په # مياشت کې}other{په # مياشتو کې}',
    },
    SHORT:{
      R:{'-1':'تېره مياشت','0':'دا مياشت','1':'راتلونکې مياشت'},
      P:'one{# مياشت مخکې}other{# مياشت مخکې}',
      F:'one{په # مياشت کې}other{په # مياشت کې}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'ورستۍ ربع','0':'دا ربع','1':'راتلونکې ربع'},
      P:'one{# ربع مخکې}other{# ربعې مخکې}',
      F:'one{په # ربع کې}other{په # ربعو کې}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'اوس'},
      P:'one{# ثانيه مخکې}other{# ثانيې مخکې}',
      F:'one{په # ثانيه کې}other{په # ثانيو کې}',
    },
    SHORT:{
      R:{'0':'اوس'},
      P:'one{# ثانيه مخکې}other{# ثانيه مخکې}',
      F:'one{په # ثانيه کې}other{په # ثانيه کې}',
    },
    NARROW:{
      R:{'0':'اوس'},
      P:'one{# ثانيه کې}other{# ثانيه کې}',
      F:'one{په # ثانيه کې}other{په # ثانيه کې}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'تيره اونۍ','0':'دا اونۍ','1':'راتلونکې اونۍ'},
      P:'one{# اونۍ مخکې}other{# اونۍ مخکې}',
      F:'one{په # اونۍ کې}other{په # اونيو کې}',
    },
    SHORT:{
      R:{'-1':'تېره اونۍ','0':'دا اونۍ','1':'راتلونکې اونۍ'},
      P:'one{# اونۍ مخکې}other{# اونۍ مخکې}',
      F:'one{په # اونۍ کې}other{په # اونۍ کې}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'پروسږکال','0':'سږکال','1':'راتلونکی کال'},
      P:'one{# کال مخکے}other{# کاله مخکے}',
      F:'one{په # کال کے}other{په # کالونو کے}',
    },
    SHORT:{
      R:{'-1':'تېر کال','0':'سږ کال','1':'روتلونکی کال'},
      P:'one{# کال مخکے}other{# کاله مخکے}',
      F:'one{په # کال کے}other{په # کالونو کے}',
    },
    NARROW:{
      R:{'-1':'تير کال','0':'سږ کال','1':'راتلونکی کال'},
      P:'one{# کال مخکے}other{# کاله مخکے}',
      F:'one{په # کال کے}other{په # کالونو کے}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_AO =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_CH =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_CV =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_GQ =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_GW =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_LU =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_MO =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_MZ =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_ST =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_pt_TL =  {
  DAY: {
    LONG:{
      R:{'-1':'ontem','-2':'anteontem','0':'hoje','1':'amanhã','2':'depois de amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    SHORT:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{há # dia}other{há # dias}',
      F:'one{dentro de # dia}other{dentro de # dias}',
    },
    NARROW:{
      R:{'-1':'ontem','0':'hoje','1':'amanhã'},
      P:'one{-# dia}other{-# dias}',
      F:'one{+# dia}other{+# dias}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'esta hora'},
      P:'one{há # hora}other{há # horas}',
      F:'one{dentro de # hora}other{dentro de # horas}',
    },
    SHORT:{
      R:{'0':'esta hora'},
      P:'one{há # h}other{há # h}',
      F:'one{dentro de # h}other{dentro de # h}',
    },
    NARROW:{
      R:{'0':'esta hora'},
      P:'one{-# h}other{-# h}',
      F:'one{+# h}other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'este minuto'},
      P:'one{há # minuto}other{há # minutos}',
      F:'one{dentro de # minuto}other{dentro de # minutos}',
    },
    SHORT:{
      R:{'0':'este minuto'},
      P:'one{há # min}other{há # min}',
      F:'one{dentro de # min}other{dentro de # min}',
    },
    NARROW:{
      R:{'0':'este minuto'},
      P:'one{-# min}other{-# min}',
      F:'one{+# min}other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{há # mês}other{há # meses}',
      F:'one{dentro de # mês}other{dentro de # meses}',
    },
    NARROW:{
      R:{'-1':'mês passado','0':'este mês','1':'próximo mês'},
      P:'one{-# mês}other{-# meses}',
      F:'one{+# mês}other{+# meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre passado','0':'este trimestre','1':'próximo trimestre'},
      P:'one{há # trimestre}other{há # trimestres}',
      F:'one{dentro de # trimestre}other{dentro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{há # trim.}other{há # trim.}',
      F:'one{dentro de # trim.}other{dentro de # trim.}',
    },
    NARROW:{
      R:{'-1':'trim. passado','0':'este trim.','1':'próximo trim.'},
      P:'one{-# trim.}other{-# trim.}',
      F:'one{+# trim.}other{+# trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'agora'},
      P:'one{há # segundo}other{há # segundos}',
      F:'one{dentro de # segundo}other{dentro de # segundos}',
    },
    SHORT:{
      R:{'0':'agora'},
      P:'one{há # s}other{há # s}',
      F:'one{dentro de # s}other{dentro de # s}',
    },
    NARROW:{
      R:{'0':'agora'},
      P:'one{-# s}other{-# s}',
      F:'one{+# s}other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # semana}other{há # semanas}',
      F:'one{dentro de # semana}other{dentro de # semanas}',
    },
    SHORT:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{há # sem.}other{há # sem.}',
      F:'one{dentro de # sem.}other{dentro de # sem.}',
    },
    NARROW:{
      R:{'-1':'semana passada','0':'esta semana','1':'próxima semana'},
      P:'one{-# sem.}other{-# sem.}',
      F:'one{+# sem.}other{+# sem.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{há # ano}other{há # anos}',
      F:'one{dentro de # ano}other{dentro de # anos}',
    },
    NARROW:{
      R:{'-1':'ano passado','0':'este ano','1':'próximo ano'},
      P:'one{-# ano}other{-# anos}',
      F:'one{+# ano}other{+# anos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_qu =  {
  DAY: {
    LONG:{
      R:{'-1':'qayna punchaw','0':'kunan punchaw','1':'paqarin'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'kay hora'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'kay minuto'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'qayna killa','0':'kunan killa','1':'hamuq killa'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'qayna kimsa killa','0':'kunan kimsa killa','1':'hamuq kimsa killa'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'qayna semana','0':'kunan semana','1':'hamuq semana'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'qayna wata','0':'kunan wata','1':'hamuq wata'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_qu_BO = exports.RelativeDateTimeSymbols_qu;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_qu_EC = exports.RelativeDateTimeSymbols_qu;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_qu_PE = exports.RelativeDateTimeSymbols_qu;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_raj =  {
  DAY: {
    LONG:{
      R:{'-1':'काल','0':'आज','1':'काल'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'पाछलो मीनो','0':'यों मीनो','1':'आग्लो मीनो'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'पाछलां सप्ताह','0':'ई सप्ताह','1':'आग्ल सप्ताह'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'गत बरस','0':'ई बरस','1':'आग्ल बरस'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_raj_IN = exports.RelativeDateTimeSymbols_raj;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rm =  {
  DAY: {
    LONG:{
      R:{'-1':'ier','-2':'stersas','0':'oz','1':'damaun','2':'puschmaun'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'l’onn passà','0':'quest onn','1':'l’onn proxim'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rm_CH = exports.RelativeDateTimeSymbols_rm;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rn =  {
  DAY: {
    LONG:{
      R:{'-1':'Ejo (haheze)','0':'Uyu musi','1':'Ejo (hazoza)'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rn_BI = exports.RelativeDateTimeSymbols_rn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ro_MD = relativeDateTimeSymbols.RelativeDateTimeSymbols_ro;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ro_RO = relativeDateTimeSymbols.RelativeDateTimeSymbols_ro;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rof =  {
  DAY: {
    LONG:{
      R:{'-1':'Hiyo','0':'Linu','1':'Ng’ama'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rof_TZ = exports.RelativeDateTimeSymbols_rof;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ru_BY = relativeDateTimeSymbols.RelativeDateTimeSymbols_ru;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ru_KG = relativeDateTimeSymbols.RelativeDateTimeSymbols_ru;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ru_KZ = relativeDateTimeSymbols.RelativeDateTimeSymbols_ru;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ru_MD = relativeDateTimeSymbols.RelativeDateTimeSymbols_ru;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ru_RU = relativeDateTimeSymbols.RelativeDateTimeSymbols_ru;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ru_UA = relativeDateTimeSymbols.RelativeDateTimeSymbols_ru;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rw =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rw_RW = exports.RelativeDateTimeSymbols_rw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rwk =  {
  DAY: {
    LONG:{
      R:{'-1':'Ukou','0':'Inu','1':'Ngama'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_rwk_TZ = exports.RelativeDateTimeSymbols_rwk;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sa =  {
  DAY: {
    LONG:{
      R:{'-1':'गतदिनम्','0':'अद्य','1':'श्वः'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
    SHORT:{
      R:{'-1':'ह्यः','0':'अद्य','1':'श्वः'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sa_IN = exports.RelativeDateTimeSymbols_sa;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sah =  {
  DAY: {
    LONG:{
      R:{'-1':'Бэҕэһээ','-2':'Иллэрээ күн','0':'Бүгүн','1':'Сарсын','2':'Өйүүн'},
      P:'other{# күн ынараа өттүгэр}',
      F:'other{# күнүнэн}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{# чаас ынараа өттүгэр}',
      F:'other{# чааһынан}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{# мүнүүтэ ынараа өттүгэр}',
      F:'other{# мүнүүтэннэн}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'ааспыт ый','0':'бу ый','1':'аныгыскы ый'},
      P:'other{# ый ынараа өттүгэр}',
      F:'other{# ыйынан}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'ааспыт кыбаартал','0':'бу кыбаартал','1':'кэлэр кыбаартал'},
      P:'other{# кыбаартал анараа өттүгэр}',
      F:'other{# кыбаарталынан}',
    },
    SHORT:{
      R:{'-1':'ааспыт кыбаартал','0':'бу кыбаартал','1':'кэлэр кыбаартал'},
      P:'other{# кыб. анараа өттүгэр}',
      F:'other{# кыбаарталынан}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'билигин'},
      P:'other{# сөкүүндэ ынараа өттүгэр}',
      F:'other{# сөкүүндэннэн}',
    },
    SHORT:{
      R:{'0':'билигин'},
      P:'other{# сөк. анараа өттүгэр}',
      F:'other{# сөкүүндэннэн}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ааспыт нэдиэлэ','0':'бу нэдиэлэ','1':'кэлэр нэдиэлэ'},
      P:'other{# нэдиэлэ анараа өттүгэр}',
      F:'other{# нэдиэлэннэн}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'Былырыын','0':'быйыл','1':'эһиил'},
      P:'other{# сыл ынараа өттүгэр}',
      F:'other{# сылынан}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sah_RU = exports.RelativeDateTimeSymbols_sah;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_saq =  {
  DAY: {
    LONG:{
      R:{'-1':'Ng’ole','0':'Duo','1':'Taisere'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_saq_KE = exports.RelativeDateTimeSymbols_saq;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sat =  {
  DAY: {
    LONG:{
      R:{'-1':'ᱦᱚᱞᱟ','0':'ᱛᱮᱦᱮᱧ','1':'ᱜᱟᱯᱟ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sat_Olck = exports.RelativeDateTimeSymbols_sat;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sat_Olck_IN = exports.RelativeDateTimeSymbols_sat;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sbp =  {
  DAY: {
    LONG:{
      R:{'-1':'Imehe','0':'Ineng’uni','1':'Pamulaawu'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sbp_TZ = exports.RelativeDateTimeSymbols_sbp;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sc =  {
  DAY: {
    LONG:{
      R:{'-1':'eris','0':'oe','1':'cras'},
      P:'one{# die a como}other{# dies a como}',
      F:'one{intro de # die}other{intro de # dies}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'cust’ora'},
      P:'one{# ora a como}other{# oras a como}',
      F:'one{intro de # ora}other{intro de # oras}',
    },
    NARROW:{
      R:{'0':'cust’ora'},
      P:'one{# o a como}other{# o a como}',
      F:'one{intro de # o}other{intro de # o}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'custu minutu'},
      P:'one{# minutu a como}other{# minutos a como}',
      F:'one{intro de # minutu}other{intro de # minutos}',
    },
    SHORT:{
      R:{'0':'custu minutu'},
      P:'one{# min. a como}other{# min. a como}',
      F:'one{intro de # min.}other{intro de # min.}',
    },
    NARROW:{
      R:{'0':'custu minutu'},
      P:'one{# m a como}other{# m a como}',
      F:'one{intro de # m}other{intro de # m}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'su mese coladu','0':'custu mese','1':'su mese chi intrat'},
      P:'one{# mese a como}other{# meses a como}',
      F:'one{intro de # mese}other{intro de # meses}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'su trimestre coladu','0':'custu trimestre','1':'su trimestre chi intrat'},
      P:'one{# trimestre a como}other{# trimestres a como}',
      F:'one{intro de # trimestre}other{intro de # trimestres}',
    },
    SHORT:{
      R:{'-1':'su trim. coladu','0':'custu trim.','1':'su trim. chi intrat'},
      P:'one{# trim. a como}other{# trim. a como}',
      F:'one{intro de # trim.}other{intro de # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'como'},
      P:'one{# segundu a como}other{# segundos a como}',
      F:'one{intro de # segundu}other{intro de # segundos}',
    },
    SHORT:{
      R:{'0':'como'},
      P:'one{# seg. a como}other{# seg. a como}',
      F:'one{intro de # seg.}other{intro de # seg.}',
    },
    NARROW:{
      R:{'0':'como'},
      P:'one{# s a como}other{# s a como}',
      F:'one{intro de # s}other{intro de # s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'sa chida colada','0':'custa chida','1':'sa chida chi intrat'},
      P:'one{# chida a como}other{# chidas a como}',
      F:'one{intro de # chida}other{intro de # chidas}',
    },
    SHORT:{
      R:{'-1':'sa chida colada','0':'custa chida','1':'sa chida chi intrat'},
      P:'one{# ch. a como}other{# ch. a como}',
      F:'one{intro de # ch.}other{intro de # ch.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ocannu coladu','0':'ocannu','1':'ocannu chi benit'},
      P:'one{# annu a como}other{# annos a como}',
      F:'one{intro de # annu}other{intro de # annos}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sc_IT = exports.RelativeDateTimeSymbols_sc;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sd =  {
  DAY: {
    LONG:{
      R:{'-1':'ڪل','0':'اڄ','1':'سڀاڻي'},
      P:'one{# ڏينهن پهرين}other{# ڏينهن پهرين}',
      F:'one{# ڏينهن ۾}other{# ڏينهن ۾}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'هن ڪلڪ'},
      P:'one{# ڪلاڪ پهرين}other{# ڪلاڪ پهرين}',
      F:'one{# ڪلاڪ ۾}other{# ڪلاڪ ۾}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'هن منٽ'},
      P:'one{# منٽ پهرين}other{# منٽ پهرين}',
      F:'one{# منٽن ۾}other{+# min}',
    },
    SHORT:{
      R:{'0':'هن منٽ'},
      P:'one{# منٽ پهرين}other{# منٽ پهرين}',
      F:'one{# منٽن ۾}other{# منٽن ۾}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'پوئين مهيني','0':'هن مهيني','1':'اڳين مهيني'},
      P:'one{# مهينا پهرين}other{# مهينا پهرين}',
      F:'one{# مهينن ۾}other{# مهينن ۾}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'پوئين ٽي ماهي','0':'هن ٽي ماهي','1':'اڳين ٽي ماهي'},
      P:'one{# ٽي ماهي پهرين}other{# ٽي ماهي پهرين}',
      F:'one{# ٽي ماهي ۾}other{# ٽي ماهي ۾}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'هاڻي'},
      P:'one{# سيڪنڊ پهرين}other{# سيڪنڊ پهرين}',
      F:'one{# سيڪنڊن ۾}other{# سيڪنڊن ۾}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'پوئين هفتي','0':'هن هفتي','1':'اڳين هفتي'},
      P:'one{# هفتا پهرين}other{# هفتا پهرين}',
      F:'one{# هفتن ۾}other{# هفتن ۾}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'پويون سال','0':'پويون سال','1':'پويون سال'},
      P:'one{# سال پهرين}other{# سال پهرين}',
      F:'one{# سالن ۾}other{# سالن ۾}',
    },
    SHORT:{
      R:{'-1':'پوئين سال','0':'هن سال','1':'اڳين سال'},
      P:'one{# سال پهرين}other{# سال پهرين}',
      F:'one{# سالن ۾}other{# سالن ۾}',
    },
    NARROW:{
      R:{'-1':'پوئين سال','0':'هن سال','1':'اڳيئن سال'},
      P:'one{# سال پهرين}other{# سال پهرين}',
      F:'one{# سالن ۾}other{# سالن ۾}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sd_Arab = exports.RelativeDateTimeSymbols_sd;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sd_Arab_PK = exports.RelativeDateTimeSymbols_sd;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sd_Deva =  {
  DAY: {
    LONG:{
      R:{'-1':'कल','0':'अॼु','1':'सुभाणे'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sd_Deva_IN =  {
  DAY: {
    LONG:{
      R:{'-1':'कल','0':'अॼु','1':'सुभाणे'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_se =  {
  DAY: {
    LONG:{
      R:{'-1':'ikte','-2':'oovdebpeivvi','0':'odne','1':'ihttin','2':'paijeelittáá'},
      P:'one{# jándor árat}other{# jándora árat}two{# jándora árat}',
      F:'one{# jándor maŋŋilit}other{# jándora maŋŋilit}two{# jándor amaŋŋilit}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# diibmu árat}other{# diibmur árat}two{# diibmur árat}',
      F:'one{# diibmu maŋŋilit}other{# diibmur maŋŋilit}two{# diibmur maŋŋilit}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# minuhta árat}other{# minuhtta árat}two{# minuhtta árat}',
      F:'one{# minuhta maŋŋilit}other{# minuhtta maŋŋilit}two{# minuhtta maŋŋilit}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{# mánotbadji árat}other{# mánotbadji árat}two{# mánotbadji árat}',
      F:'one{# mánotbadji maŋŋilit}other{# mánotbadji maŋŋilit}two{# mánotbadji maŋŋilit}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# sekunda árat}other{# sekundda árat}two{# sekundda árat}',
      F:'one{# sekunda maŋŋilit}other{# sekundda maŋŋilit}two{# sekundda maŋŋilit}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{# vahku árat}other{# vahkku árat}two{# vahkku árat}',
      F:'one{# vahku maŋŋilit}other{# vahkku maŋŋilit}two{# vahkku maŋŋilit}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{# jahki árat}other{# jahkki árat}two{# jahkki árat}',
      F:'one{# jahki maŋŋilit}other{# jahkki maŋŋilit}two{# jahkki maŋŋilit}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_se_FI =  {
  DAY: {
    LONG:{
      R:{'-2':'ovddet beaivvi','2':'don beaivve'},
      P:'one{ikte}other{# beaivve dás ovdal}two{ovddet beaivve}',
      F:'one{# beaivve siste}other{# beaivve siste}two{# beaivve siste}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'dán diimmu'},
      P:'one{# diibmu áigi}other{# diimmu áigi}two{# diimmu áigi}',
      F:'one{# diimmu siste}other{# diimmu siste}two{# diimmu siste}',
    },
    SHORT:{
      R:{'0':'dán diimmu'},
      P:'one{# dmu áigi}other{# dmu áigi}two{# diimmu áigi}',
      F:'one{# dmu siste}other{# dmu siste}two{# diimmu siste}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'dán minuhta'},
      P:'one{# minuhtta áigi}other{# minuhta áigi}two{# minuhta áigi}',
      F:'one{# minuhta siste}other{# minuhta siste}two{# minuhta siste}',
    },
    SHORT:{
      R:{'0':'dán minuhta'},
      P:'one{# min. áigi}other{# min. áigi}two{# minuhta áigi}',
      F:'one{# min. siste}other{# min. siste}two{# minuhta siste}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'mannan mánu','0':'dán mánu','1':'boahtte mánu'},
      P:'one{# mánnu dás ovdal}other{# mánu dás ovdal}two{# mánu dás ovdal}',
      F:'one{# mánu siste}other{# mánu siste}two{# mánu siste}',
    },
    NARROW:{
      R:{'-1':'mannan mánu','0':'dán mánu','1':'boahtte mánu'},
      P:'one{# mánnu dás ovdal}other{# mánu dás ovdal}two{# mánu dás ovdal}',
      F:'one{# mánu geahčen}other{# mánu geahčen}two{# mánu geahčen}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'mannan njealjádasjagi','0':'dán njealjádasjagi','1':'boahtte njealjádasjagi'},
      P:'one{-# njealjádasjagi dás ovdal}other{-# njealjádasjagi dás ovdal}two{-# njealjádasjagi dás ovdal}',
      F:'one{čuovvovaš # njealjádasjagi}other{čuovvovaš # njealjádasjagi}two{čuovvovaš # njealjádasjagi}',
    },
    SHORT:{
      R:{'-1':'mannan njealjádasjagi','0':'dán njealjádasjagi','1':'boahtte njealjádasjagi'},
      P:'one{# njealj.j. dás ovdal}other{# njealj.j. dás ovdal}two{# njealjádasjagi dás ovdal}',
      F:'one{boahtte # njealj.j.}other{boahtte # njealj.j.}two{boahtte # njealjádasjagi}',
    },
    NARROW:{
      R:{'-1':'mannan njealjádasjagi','0':'dán njealjádasjagi','1':'boahtte njealjádasjagi'},
      P:'one{# njealj.j. dás ovdal}other{# njealj.j. dás ovdal}two{-# njealjádasjagi dás ovdal}',
      F:'one{boahtte # njealj.j.}other{boahtte # njealj.j.}two{boahtte # njealjádasjagi}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'dál'},
      P:'one{# sekunda áigi}other{# sekundda áigi}two{# sekundda áigi}',
      F:'one{# sekundda siste}other{# sekundda siste}two{# sekundda siste}',
    },
    SHORT:{
      R:{'0':'dál'},
      P:'one{# sek. áigi}other{# sek. áigi}two{# sekundda áigi}',
      F:'one{# sek. siste}other{# sek. siste}two{# sekundda siste}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'mannan vahku','0':'dán vahku','1':'boahtte vahku'},
      P:'one{# vahkku dás ovdal}other{# vahku dás ovdal}two{# vahku dás ovdal}',
      F:'one{# vahku geahčen}other{# vahku geahčen}two{# vahku geahčen}',
    },
    SHORT:{
      R:{'-1':'mannan vahku','0':'dán vahku','1':'boahtte vahku'},
      P:'one{# v(k) dás ovdal}other{# v(k) dás ovdal}two{# vahku dás ovdal}',
      F:'one{# v(k) siste}other{# v(k) siste}two{# vahku siste}',
    },
    NARROW:{
      R:{'-1':'mannan vahku','0':'dán vahku','1':'boahtte vahku'},
      P:'one{# vahkku dás ovdal}other{# v(k) dás ovdal}two{# vahku dás ovdal}',
      F:'one{# v(k) geahčen}other{# v(k) geahčen}two{# v(k) geahčen}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'diibmá','0':'dán jagi','1':'boahtte jagi'},
      P:'one{diibmá}other{# jagi dás ovdal}two{ovddet jagi}',
      F:'one{# jagi siste}other{# jagi siste}two{# jagi siste}',
    },
    SHORT:{
      R:{'0':'dán jagi','1':'boahtte jagi'},
      P:'one{diibmá}other{# j. dás ovdal}two{ovddet jagi}',
      F:'one{# j. siste}other{# j. siste}two{# jagi siste}',
    },
    NARROW:{
      R:{'0':'dán jagi','1':'boahtte jagi'},
      P:'one{# j. dás ovdal}other{# j. dás ovdal}two{# jagi dás ovdal}',
      F:'one{# jagi siste}other{# jagi siste}two{# jagi siste}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_se_NO = exports.RelativeDateTimeSymbols_se;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_se_SE = exports.RelativeDateTimeSymbols_se;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_seh =  {
  DAY: {
    LONG:{
      R:{'-1':'Zuro','0':'Lero','1':'Manguana'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_seh_MZ = exports.RelativeDateTimeSymbols_seh;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ses =  {
  DAY: {
    LONG:{
      R:{'-1':'Bi','0':'Hõo','1':'Suba'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ses_ML = exports.RelativeDateTimeSymbols_ses;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sg =  {
  DAY: {
    LONG:{
      R:{'-1':'Bîrï','0':'Lâsô','1':'Kêkerêke'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sg_CF = exports.RelativeDateTimeSymbols_sg;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_shi =  {
  DAY: {
    LONG:{
      R:{'-1':'ⵉⴹⵍⵍⵉ','0':'ⴰⵙⵙⴰ','1':'ⴰⵙⴽⴽⴰ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_shi_Latn =  {
  DAY: {
    LONG:{
      R:{'-1':'iḍlli','0':'assa','1':'askka'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_shi_Latn_MA =  {
  DAY: {
    LONG:{
      R:{'-1':'iḍlli','0':'assa','1':'askka'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_shi_Tfng = exports.RelativeDateTimeSymbols_shi;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_shi_Tfng_MA = exports.RelativeDateTimeSymbols_shi;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_si_LK = relativeDateTimeSymbols.RelativeDateTimeSymbols_si;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sk_SK = relativeDateTimeSymbols.RelativeDateTimeSymbols_sk;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sl_SI = relativeDateTimeSymbols.RelativeDateTimeSymbols_sl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_smn =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_smn_FI = exports.RelativeDateTimeSymbols_smn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sn =  {
  DAY: {
    LONG:{
      R:{'-1':'Nezuro','0':'Nhasi','1':'Mangwana'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sn_ZW = exports.RelativeDateTimeSymbols_sn;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_so =  {
  DAY: {
    LONG:{
      R:{'-1':'Shalay','0':'Maanta','1':'Berri'},
      P:'one{# maalin kahor}other{# maalmood kahor}',
      F:'one{# maalin}other{# maalmood}',
    },
    SHORT:{
      R:{'-1':'Shalay','0':'Maanta','1':'Berri'},
      P:'one{# mln khr}other{# mlmd khr}',
      F:'one{# mln}other{# mlmd}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'Saacadan'},
      P:'one{# saacad kahor}other{# saacadood kahor}',
      F:'one{# saacad}other{# saacadood}',
    },
    SHORT:{
      R:{'0':'Saacadan'},
      P:'one{# scd khr}other{# scd khr}',
      F:'one{# scd}other{# scd}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'Daqiiqadan'},
      P:'one{# daqiiqad kahor}other{# daqiiqadood kahor}',
      F:'one{# daqiiqad}other{# daqiidadood}',
    },
    SHORT:{
      R:{'0':'Daqiiqadan'},
      P:'one{# dqqd khr}other{# daqiiqadood kahor}',
      F:'one{# dqqd}other{# dqqd}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'Bishii hore','0':'Bishan','1':'Bisha danbe'},
      P:'one{# bil kahor}other{# bilood kahor}',
      F:'one{# bil}other{# bilood}',
    },
    SHORT:{
      R:{'-1':'Bishii hore','0':'Bishan','1':'Bisha danbe'},
      P:'one{# bil khr}other{# bil khr}',
      F:'one{# bil}other{# bil}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'Rubucii hore','0':'Rubucan','1':'Rubuca danbe'},
      P:'one{# rubuc kahor}other{# rubuc kahor}',
      F:'one{# rubuc}other{# rubuc}',
    },
    SHORT:{
      R:{'-1':'Rubucii ugu dambeeyay','0':'Rubucan','1':'Rubuca xiga'},
      P:'one{# rbc khr}other{# rbc khr}',
      F:'one{# rbc}other{# rbc}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'Imika'},
      P:'one{# ilbiriqsi kahor}other{# ilbiriqsi kahor}',
      F:'one{# ilbiriqsi}other{# ilbiriqsi}',
    },
    SHORT:{
      R:{'0':'Iminka'},
      P:'one{# ilbrqsi khr}other{# ilbrqsi khr}',
      F:'one{# ilbrqsi}other{# ilbrqsi}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'Toddobaadkii hore','0':'Usbuucan','1':'Toddobaadka danbe'},
      P:'one{# toddobaad kahor}other{# toddobaad kahor}',
      F:'one{# toddobaad}other{# toddobaad}',
    },
    SHORT:{
      R:{'-1':'Toddobaadkii hore','0':'Usbuucan','1':'Toddobaadka danbe'},
      P:'one{# tdbd khr}other{# tdbd khr}',
      F:'one{# tdbd}other{# tdbd}',
    },
    NARROW:{
      R:{'-1':'Toddobaadkii hore','0':'Toddobaadkan','1':'Toddobaadka danbe'},
      P:'one{# tdbd khr}other{# tdbd khr}',
      F:'one{# tdbd}other{# tdbd}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'Sannadkii hore','0':'Sannadkan','1':'Sannadka danbe'},
      P:'one{# sannad kahor}other{# sannadood kahor}',
      F:'one{# sannad}other{# sannadood}',
    },
    SHORT:{
      R:{'-1':'Sannadkii hore','0':'Sannadkan','1':'Sannadka danbe'},
      P:'one{# snd khr}other{# Snd khr}',
      F:'one{# snd}other{# snd}',
    },
    NARROW:{
      R:{'-1':'Sannadkii la soo dhaafay','0':'Sannadkan','1':'Sannadka xiga'},
      P:'one{# snd khr}other{# Snd khr}',
      F:'one{# snd}other{# snd}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_so_DJ = exports.RelativeDateTimeSymbols_so;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_so_ET = exports.RelativeDateTimeSymbols_so;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_so_KE = exports.RelativeDateTimeSymbols_so;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_so_SO = exports.RelativeDateTimeSymbols_so;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sq_AL = relativeDateTimeSymbols.RelativeDateTimeSymbols_sq;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sq_MK = relativeDateTimeSymbols.RelativeDateTimeSymbols_sq;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sq_XK = relativeDateTimeSymbols.RelativeDateTimeSymbols_sq;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Cyrl = relativeDateTimeSymbols.RelativeDateTimeSymbols_sr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Cyrl_BA =  {
  DAY: {
    LONG:{
      R:{'-1':'јуче','-2':'прекјуче','0':'данас','1':'сутра','2':'прекосутра'},
      P:'few{прије # дана}one{прије # дана}other{прије # дана}',
      F:'few{за # дана}one{за # дан}other{за # дана}',
    },
    SHORT:{
      R:{'-1':'јуче','-2':'прекјуче','0':'данас','1':'сутра','2':'прекосутра'},
      P:'few{прије # д.}one{прије # д.}other{прије # д.}',
      F:'few{за # д.}one{за # д.}other{за # д.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'овог сата'},
      P:'few{прије # сата}one{прије # сата}other{прије # сати}',
      F:'few{за # сата}one{за # сат}other{за # сати}',
    },
    SHORT:{
      R:{'0':'овог сата'},
      P:'few{прије # ч.}one{прије # ч.}other{прије # ч.}',
      F:'few{за # ч.}one{за # ч.}other{за # ч.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'овог минута'},
      P:'few{прије # минута}one{прије # минута}other{прије # минута}',
      F:'few{за # минута}one{за # минут}other{за # минута}',
    },
    SHORT:{
      R:{'0':'овог минута'},
      P:'few{прије # мин.}one{прије # мин.}other{прије # мин.}',
      F:'few{за # мин.}one{за # мин.}other{за # мин.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'прошлог мјесеца','0':'овог мјесеца','1':'сљедећег мјесеца'},
      P:'few{прије # мјесеца}one{прије # мјесеца}other{прије # мјесеци}',
      F:'few{за # мјесеца}one{за # мјесец}other{за # мјесеци}',
    },
    SHORT:{
      R:{'-1':'прошлог мјес.','0':'овог мјес.','1':'сљедећег мјес.'},
      P:'few{прије # мјес.}one{прије # мјес.}other{прије # мјес.}',
      F:'few{за # мјес.}one{за # мјес.}other{за # мјес.}',
    },
    NARROW:{
      R:{'-1':'прошлог мјес.','0':'овог мјес.','1':'сљедећег м.'},
      P:'few{прије # м.}one{прије # м.}other{прије # м.}',
      F:'few{за # м.}one{за # м.}other{за # м.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'прошлог квартала','0':'овог квартала','1':'сљедећег квартала'},
      P:'few{прије # квартала}one{прије # квартала}other{прије # квартала}',
      F:'few{за # квартала}one{за # квартал}other{за # квартала}',
    },
    SHORT:{
      R:{'-1':'прошлог квартала','0':'овог квартала','1':'следећег квартала'},
      P:'few{прије # кв.}one{прије # кв.}other{прије # кв.}',
      F:'few{за # кв.}one{за # кв.}other{за # кв.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'сада'},
      P:'few{прије # секунде}one{прије # секунде}other{прије # секунди}',
      F:'few{за # секунде}one{за # секунду}other{за # секунди}',
    },
    SHORT:{
      R:{'0':'сада'},
      P:'few{прије # сек.}one{прије # сек.}other{прије # сек.}',
      F:'few{за # сек.}one{за # сек.}other{за # сек.}',
    },
    NARROW:{
      R:{'0':'сада'},
      P:'few{прије # с.}one{прије # с.}other{прије # с.}',
      F:'few{за # с.}one{за # с.}other{за # с.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'прошле седмице','0':'ове седмице','1':'сљедеће седмице'},
      P:'few{прије # седмице}one{прије # седмице}other{прије # седмица}',
      F:'few{за # седмице}one{за # седмицу}other{за # седмица}',
    },
    SHORT:{
      R:{'-1':'прошле седм.','0':'ове седм.','1':'сљедеће седм.'},
      P:'few{прије # седм.}one{прије # седм.}other{прије # седм.}',
      F:'few{за # седм.}one{за # седм.}other{за # седм.}',
    },
    NARROW:{
      R:{'-1':'прошле с.','0':'ове с.','1':'сљедеће с.'},
      P:'few{прије # с.}one{прије # с.}other{прије # с.}',
      F:'few{за # с.}one{за # с.}other{за # с.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'прошле године','0':'ове године','1':'сљедеће године'},
      P:'few{прије # године}one{прије # године}other{прије # година}',
      F:'few{за # године}one{за # годину}other{за # година}',
    },
    SHORT:{
      R:{'-1':'прошле год.','0':'ове год.','1':'сљедеће год.'},
      P:'few{прије # год.}one{прије # год.}other{прије # год.}',
      F:'few{за # год.}one{за # год.}other{за # год.}',
    },
    NARROW:{
      R:{'-1':'прошле г.','0':'ове г.','1':'сљедеће г.'},
      P:'few{прије # г.}one{прије # г.}other{прије # г.}',
      F:'few{за # г.}one{за # г.}other{за # г.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Cyrl_ME = relativeDateTimeSymbols.RelativeDateTimeSymbols_sr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Cyrl_RS = relativeDateTimeSymbols.RelativeDateTimeSymbols_sr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Cyrl_XK = relativeDateTimeSymbols.RelativeDateTimeSymbols_sr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Latn_BA =  {
  DAY: {
    LONG:{
      R:{'-1':'juče','-2':'prekjuče','0':'danas','1':'sutra','2':'prekosutra'},
      P:'few{prije # dana}one{prije # dana}other{prije # dana}',
      F:'few{za # dana}one{za # dan}other{za # dana}',
    },
    SHORT:{
      R:{'-1':'juče','-2':'prekjuče','0':'danas','1':'sutra','2':'prekosutra'},
      P:'few{prije # d.}one{prije # d.}other{prije # d.}',
      F:'few{za # d.}one{za # d.}other{za # d.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'ovog sata'},
      P:'few{prije # sata}one{prije # sata}other{prije # sati}',
      F:'few{za # sata}one{za # sat}other{za # sati}',
    },
    SHORT:{
      R:{'0':'ovog sata'},
      P:'few{prije # č.}one{prije # č.}other{prije # č.}',
      F:'few{za # č.}one{za # č.}other{za # č.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'ovog minuta'},
      P:'few{prije # minuta}one{prije # minuta}other{prije # minuta}',
      F:'few{za # minuta}one{za # minut}other{za # minuta}',
    },
    SHORT:{
      R:{'0':'ovog minuta'},
      P:'few{prije # min.}one{prije # min.}other{prije # min.}',
      F:'few{za # min.}one{za # min.}other{za # min.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'prošlog mjeseca','0':'ovog mjeseca','1':'sljedećeg mjeseca'},
      P:'few{prije # mjeseca}one{prije # mjeseca}other{prije # mjeseci}',
      F:'few{za # mjeseca}one{za # mjesec}other{za # mjeseci}',
    },
    SHORT:{
      R:{'-1':'prošlog mjes.','0':'ovog mjes.','1':'sljedećeg mjes.'},
      P:'few{prije # mjes.}one{prije # mjes.}other{prije # mjes.}',
      F:'few{za # mjes.}one{za # mjes.}other{za # mjes.}',
    },
    NARROW:{
      R:{'-1':'prošlog mjes.','0':'ovog mjes.','1':'sljedećeg m.'},
      P:'few{prije # m.}one{prije # m.}other{prije # m.}',
      F:'few{za # m.}one{za # m.}other{za # m.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'prošlog kvartala','0':'ovog kvartala','1':'sljedećeg kvartala'},
      P:'few{prije # kvartala}one{prije # kvartala}other{prije # kvartala}',
      F:'few{za # kvartala}one{za # kvartal}other{za # kvartala}',
    },
    SHORT:{
      R:{'-1':'prošlog kvartala','0':'ovog kvartala','1':'sledećeg kvartala'},
      P:'few{prije # kv.}one{prije # kv.}other{prije # kv.}',
      F:'few{za # kv.}one{za # kv.}other{za # kv.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'sada'},
      P:'few{prije # sekunde}one{prije # sekunde}other{prije # sekundi}',
      F:'few{za # sekunde}one{za # sekundu}other{za # sekundi}',
    },
    SHORT:{
      R:{'0':'sada'},
      P:'few{prije # sek.}one{prije # sek.}other{prije # sek.}',
      F:'few{za # sek.}one{za # sek.}other{za # sek.}',
    },
    NARROW:{
      R:{'0':'sada'},
      P:'few{prije # s.}one{prije # s.}other{prije # s.}',
      F:'few{za # s.}one{za # s.}other{za # s.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'prošle sedmice','0':'ove sedmice','1':'sljedeće sedmice'},
      P:'few{prije # sedmice}one{prije # sedmice}other{prije # sedmica}',
      F:'few{za # sedmice}one{za # sedmicu}other{za # sedmica}',
    },
    SHORT:{
      R:{'-1':'prošle sedm.','0':'ove sedm.','1':'sljedeće sedm.'},
      P:'few{prije # sedm.}one{prije # sedm.}other{prije # sedm.}',
      F:'few{za # sedm.}one{za # sedm.}other{za # sedm.}',
    },
    NARROW:{
      R:{'-1':'prošle s.','0':'ove s.','1':'sljedeće s.'},
      P:'few{prije # s.}one{prije # s.}other{prije # s.}',
      F:'few{za # s.}one{za # s.}other{za # s.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'prošle godine','0':'ove godine','1':'sljedeće godine'},
      P:'few{prije # godine}one{prije # godine}other{prije # godina}',
      F:'few{za # godine}one{za # godinu}other{za # godina}',
    },
    SHORT:{
      R:{'-1':'prošle god.','0':'ove god.','1':'sljedeće god.'},
      P:'few{prije # god.}one{prije # god.}other{prije # god.}',
      F:'few{za # god.}one{za # god.}other{za # god.}',
    },
    NARROW:{
      R:{'-1':'prošle g.','0':'ove g.','1':'sljedeće g.'},
      P:'few{prije # g.}one{prije # g.}other{prije # g.}',
      F:'few{za # g.}one{za # g.}other{za # g.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Latn_ME =  {
  DAY: {
    LONG:{
      R:{'-1':'juče','-2':'prekjuče','0':'danas','1':'sutra','2':'prekosutra'},
      P:'few{pre # dana}one{pre # dana}other{pre # dana}',
      F:'few{za # dana}one{za # dan}other{za # dana}',
    },
    SHORT:{
      R:{'-1':'juče','-2':'prekjuče','0':'danas','1':'sutra','2':'prekosutra'},
      P:'few{pre # d.}one{pre # d.}other{pre # d.}',
      F:'few{za # d.}one{za # d.}other{za # d.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'ovog sata'},
      P:'few{pre # sata}one{pre # sata}other{pre # sati}',
      F:'few{za # sata}one{za # sat}other{za # sati}',
    },
    SHORT:{
      R:{'0':'ovog sata'},
      P:'few{pre # č.}one{pre # č.}other{pre # č.}',
      F:'few{za # č.}one{za # č.}other{za # č.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'ovog minuta'},
      P:'few{pre # minuta}one{pre # minuta}other{pre # minuta}',
      F:'few{za # minuta}one{za # minut}other{za # minuta}',
    },
    SHORT:{
      R:{'0':'ovog minuta'},
      P:'few{pre # min.}one{pre # min.}other{pre # min.}',
      F:'few{za # min.}one{za # min.}other{za # min.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'prošlog meseca','0':'ovog meseca','1':'sledećeg meseca'},
      P:'few{pre # meseca}one{pre # meseca}other{pre # meseci}',
      F:'few{za # meseca}one{za # mesec}other{za # meseci}',
    },
    SHORT:{
      R:{'-1':'prošlog mes.','0':'ovog mes.','1':'sledećeg mes.'},
      P:'few{pre # mes.}one{pre # mes.}other{pre # mes.}',
      F:'few{za # mes.}one{za # mes.}other{za # mes.}',
    },
    NARROW:{
      R:{'-1':'prošlog mes.','0':'ovog mes.','1':'sledećeg mes.'},
      P:'few{pre # m.}one{pre # m.}other{pre # m.}',
      F:'few{za # m.}one{za # m.}other{za # m.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'prošlog kvartala','0':'ovog kvartala','1':'sledećeg kvartala'},
      P:'few{pre # kvartala}one{pre # kvartala}other{pre # kvartala}',
      F:'few{za # kvartala}one{za # kvartal}other{za # kvartala}',
    },
    SHORT:{
      R:{'-1':'prošlog kvartala','0':'ovog kvartala','1':'sledećeg kvartala'},
      P:'few{pre # kv.}one{pre # kv.}other{pre # kv.}',
      F:'few{za # kv.}one{za # kv.}other{za # kv.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'sada'},
      P:'few{pre # sekunde}one{pre # sekunde}other{pre # sekundi}',
      F:'few{za # sekunde}one{za # sekundu}other{za # sekundi}',
    },
    SHORT:{
      R:{'0':'sada'},
      P:'few{pre # sek.}one{pre # sek.}other{pre # sek.}',
      F:'few{za # sek.}one{za # sek.}other{za # sek.}',
    },
    NARROW:{
      R:{'0':'sada'},
      P:'few{pre # s.}one{pre # s.}other{pre # s.}',
      F:'few{za # s.}one{za # s.}other{za # s.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'prošle nedelje','0':'ove nedelje','1':'sledeće nedelje'},
      P:'few{pre # nedelje}one{pre # nedelje}other{pre # nedelja}',
      F:'few{za # nedelje}one{za # nedelju}other{za # nedelja}',
    },
    SHORT:{
      R:{'-1':'prošle ned.','0':'ove ned.','1':'sledeće ned.'},
      P:'few{pre # ned.}one{pre # ned.}other{pre # ned.}',
      F:'few{za # ned.}one{za # ned.}other{za # ned.}',
    },
    NARROW:{
      R:{'-1':'prošle n.','0':'ove n.','1':'sledeće n.'},
      P:'few{pre # n.}one{pre # n.}other{pre # n.}',
      F:'few{za # n.}one{za # n.}other{za # n.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'prošle godine','0':'ove godine','1':'sledeće godine'},
      P:'few{pre # godine}one{pre # godine}other{pre # godina}',
      F:'few{za # godine}one{za # godinu}other{za # godina}',
    },
    SHORT:{
      R:{'-1':'prošle god.','0':'ove god.','1':'sledeće god.'},
      P:'few{pre # god.}one{pre # god.}other{pre # god.}',
      F:'few{za # god.}one{za # god.}other{za # god.}',
    },
    NARROW:{
      R:{'-1':'prošle g.','0':'ove g.','1':'sledeće g.'},
      P:'few{pre # g.}one{pre # g.}other{pre # g.}',
      F:'few{za # g.}one{za # g.}other{za # g.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Latn_RS =  {
  DAY: {
    LONG:{
      R:{'-1':'juče','-2':'prekjuče','0':'danas','1':'sutra','2':'prekosutra'},
      P:'few{pre # dana}one{pre # dana}other{pre # dana}',
      F:'few{za # dana}one{za # dan}other{za # dana}',
    },
    SHORT:{
      R:{'-1':'juče','-2':'prekjuče','0':'danas','1':'sutra','2':'prekosutra'},
      P:'few{pre # d.}one{pre # d.}other{pre # d.}',
      F:'few{za # d.}one{za # d.}other{za # d.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'ovog sata'},
      P:'few{pre # sata}one{pre # sata}other{pre # sati}',
      F:'few{za # sata}one{za # sat}other{za # sati}',
    },
    SHORT:{
      R:{'0':'ovog sata'},
      P:'few{pre # č.}one{pre # č.}other{pre # č.}',
      F:'few{za # č.}one{za # č.}other{za # č.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'ovog minuta'},
      P:'few{pre # minuta}one{pre # minuta}other{pre # minuta}',
      F:'few{za # minuta}one{za # minut}other{za # minuta}',
    },
    SHORT:{
      R:{'0':'ovog minuta'},
      P:'few{pre # min.}one{pre # min.}other{pre # min.}',
      F:'few{za # min.}one{za # min.}other{za # min.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'prošlog meseca','0':'ovog meseca','1':'sledećeg meseca'},
      P:'few{pre # meseca}one{pre # meseca}other{pre # meseci}',
      F:'few{za # meseca}one{za # mesec}other{za # meseci}',
    },
    SHORT:{
      R:{'-1':'prošlog mes.','0':'ovog mes.','1':'sledećeg mes.'},
      P:'few{pre # mes.}one{pre # mes.}other{pre # mes.}',
      F:'few{za # mes.}one{za # mes.}other{za # mes.}',
    },
    NARROW:{
      R:{'-1':'prošlog mes.','0':'ovog mes.','1':'sledećeg mes.'},
      P:'few{pre # m.}one{pre # m.}other{pre # m.}',
      F:'few{za # m.}one{za # m.}other{za # m.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'prošlog kvartala','0':'ovog kvartala','1':'sledećeg kvartala'},
      P:'few{pre # kvartala}one{pre # kvartala}other{pre # kvartala}',
      F:'few{za # kvartala}one{za # kvartal}other{za # kvartala}',
    },
    SHORT:{
      R:{'-1':'prošlog kvartala','0':'ovog kvartala','1':'sledećeg kvartala'},
      P:'few{pre # kv.}one{pre # kv.}other{pre # kv.}',
      F:'few{za # kv.}one{za # kv.}other{za # kv.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'sada'},
      P:'few{pre # sekunde}one{pre # sekunde}other{pre # sekundi}',
      F:'few{za # sekunde}one{za # sekundu}other{za # sekundi}',
    },
    SHORT:{
      R:{'0':'sada'},
      P:'few{pre # sek.}one{pre # sek.}other{pre # sek.}',
      F:'few{za # sek.}one{za # sek.}other{za # sek.}',
    },
    NARROW:{
      R:{'0':'sada'},
      P:'few{pre # s.}one{pre # s.}other{pre # s.}',
      F:'few{za # s.}one{za # s.}other{za # s.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'prošle nedelje','0':'ove nedelje','1':'sledeće nedelje'},
      P:'few{pre # nedelje}one{pre # nedelje}other{pre # nedelja}',
      F:'few{za # nedelje}one{za # nedelju}other{za # nedelja}',
    },
    SHORT:{
      R:{'-1':'prošle ned.','0':'ove ned.','1':'sledeće ned.'},
      P:'few{pre # ned.}one{pre # ned.}other{pre # ned.}',
      F:'few{za # ned.}one{za # ned.}other{za # ned.}',
    },
    NARROW:{
      R:{'-1':'prošle n.','0':'ove n.','1':'sledeće n.'},
      P:'few{pre # n.}one{pre # n.}other{pre # n.}',
      F:'few{za # n.}one{za # n.}other{za # n.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'prošle godine','0':'ove godine','1':'sledeće godine'},
      P:'few{pre # godine}one{pre # godine}other{pre # godina}',
      F:'few{za # godine}one{za # godinu}other{za # godina}',
    },
    SHORT:{
      R:{'-1':'prošle god.','0':'ove god.','1':'sledeće god.'},
      P:'few{pre # god.}one{pre # god.}other{pre # god.}',
      F:'few{za # god.}one{za # god.}other{za # god.}',
    },
    NARROW:{
      R:{'-1':'prošle g.','0':'ove g.','1':'sledeće g.'},
      P:'few{pre # g.}one{pre # g.}other{pre # g.}',
      F:'few{za # g.}one{za # g.}other{za # g.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sr_Latn_XK =  {
  DAY: {
    LONG:{
      R:{'-1':'juče','-2':'prekjuče','0':'danas','1':'sutra','2':'prekosutra'},
      P:'few{pre # dana}one{pre # dana}other{pre # dana}',
      F:'few{za # dana}one{za # dan}other{za # dana}',
    },
    SHORT:{
      R:{'-1':'juče','-2':'prekjuče','0':'danas','1':'sutra','2':'prekosutra'},
      P:'few{pre # d.}one{pre # d.}other{pre # d.}',
      F:'few{za # d.}one{za # d.}other{za # d.}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'ovog sata'},
      P:'few{pre # sata}one{pre # sata}other{pre # sati}',
      F:'few{za # sata}one{za # sat}other{za # sati}',
    },
    SHORT:{
      R:{'0':'ovog sata'},
      P:'few{pre # č.}one{pre # č.}other{pre # č.}',
      F:'few{za # č.}one{za # č.}other{za # č.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'ovog minuta'},
      P:'few{pre # minuta}one{pre # minuta}other{pre # minuta}',
      F:'few{za # minuta}one{za # minut}other{za # minuta}',
    },
    SHORT:{
      R:{'0':'ovog minuta'},
      P:'few{pre # min.}one{pre # min.}other{pre # min.}',
      F:'few{za # min.}one{za # min.}other{za # min.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'prošlog meseca','0':'ovog meseca','1':'sledećeg meseca'},
      P:'few{pre # meseca}one{pre # meseca}other{pre # meseci}',
      F:'few{za # meseca}one{za # mesec}other{za # meseci}',
    },
    SHORT:{
      R:{'-1':'prošlog mes.','0':'ovog mes.','1':'sledećeg mes.'},
      P:'few{pre # mes.}one{pre # mes.}other{pre # mes.}',
      F:'few{za # mes.}one{za # mes.}other{za # mes.}',
    },
    NARROW:{
      R:{'-1':'prošlog mes.','0':'ovog mes.','1':'sledećeg mes.'},
      P:'few{pre # m.}one{pre # m.}other{pre # m.}',
      F:'few{za # m.}one{za # m.}other{za # m.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'prošlog kvartala','0':'ovog kvartala','1':'sledećeg kvartala'},
      P:'few{pre # kvartala}one{pre # kvartala}other{pre # kvartala}',
      F:'few{za # kvartala}one{za # kvartal}other{za # kvartala}',
    },
    SHORT:{
      R:{'-1':'prošlog kvartala','0':'ovog kvartala','1':'sledećeg kvartala'},
      P:'few{pre # kv.}one{pre # kv.}other{pre # kv.}',
      F:'few{za # kv.}one{za # kv.}other{za # kv.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'sada'},
      P:'few{pre # sekunde}one{pre # sekunde}other{pre # sekundi}',
      F:'few{za # sekunde}one{za # sekundu}other{za # sekundi}',
    },
    SHORT:{
      R:{'0':'sada'},
      P:'few{pre # sek.}one{pre # sek.}other{pre # sek.}',
      F:'few{za # sek.}one{za # sek.}other{za # sek.}',
    },
    NARROW:{
      R:{'0':'sada'},
      P:'few{pre # s.}one{pre # s.}other{pre # s.}',
      F:'few{za # s.}one{za # s.}other{za # s.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'prošle nedelje','0':'ove nedelje','1':'sledeće nedelje'},
      P:'few{pre # nedelje}one{pre # nedelje}other{pre # nedelja}',
      F:'few{za # nedelje}one{za # nedelju}other{za # nedelja}',
    },
    SHORT:{
      R:{'-1':'prošle ned.','0':'ove ned.','1':'sledeće ned.'},
      P:'few{pre # ned.}one{pre # ned.}other{pre # ned.}',
      F:'few{za # ned.}one{za # ned.}other{za # ned.}',
    },
    NARROW:{
      R:{'-1':'prošle n.','0':'ove n.','1':'sledeće n.'},
      P:'few{pre # n.}one{pre # n.}other{pre # n.}',
      F:'few{za # n.}one{za # n.}other{za # n.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'prošle godine','0':'ove godine','1':'sledeće godine'},
      P:'few{pre # godine}one{pre # godine}other{pre # godina}',
      F:'few{za # godine}one{za # godinu}other{za # godina}',
    },
    SHORT:{
      R:{'-1':'prošle god.','0':'ove god.','1':'sledeće god.'},
      P:'few{pre # god.}one{pre # god.}other{pre # god.}',
      F:'few{za # god.}one{za # god.}other{za # god.}',
    },
    NARROW:{
      R:{'-1':'prošle g.','0':'ove g.','1':'sledeće g.'},
      P:'few{pre # g.}one{pre # g.}other{pre # g.}',
      F:'few{za # g.}one{za # g.}other{za # g.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_su =  {
  DAY: {
    LONG:{
      R:{'-1':'kamari','0':'dinten ieu','1':'énjing'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'taun kamari','0':'taun ieu','1':'taun payun'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_su_Latn = exports.RelativeDateTimeSymbols_su;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_su_Latn_ID = exports.RelativeDateTimeSymbols_su;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sv_AX = relativeDateTimeSymbols.RelativeDateTimeSymbols_sv;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sv_FI = relativeDateTimeSymbols.RelativeDateTimeSymbols_sv;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sv_SE = relativeDateTimeSymbols.RelativeDateTimeSymbols_sv;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sw_CD = relativeDateTimeSymbols.RelativeDateTimeSymbols_sw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sw_KE = relativeDateTimeSymbols.RelativeDateTimeSymbols_sw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sw_TZ = relativeDateTimeSymbols.RelativeDateTimeSymbols_sw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_sw_UG = relativeDateTimeSymbols.RelativeDateTimeSymbols_sw;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ta_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_ta;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ta_LK = relativeDateTimeSymbols.RelativeDateTimeSymbols_ta;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ta_MY = relativeDateTimeSymbols.RelativeDateTimeSymbols_ta;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ta_SG = relativeDateTimeSymbols.RelativeDateTimeSymbols_ta;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_te_IN = relativeDateTimeSymbols.RelativeDateTimeSymbols_te;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_teo =  {
  DAY: {
    LONG:{
      R:{'-1':'Jaan','0':'Lolo','1':'Moi'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_teo_KE = exports.RelativeDateTimeSymbols_teo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_teo_UG = exports.RelativeDateTimeSymbols_teo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tg =  {
  DAY: {
    LONG:{
      R:{'-1':'дирӯз','0':'имрӯз','1':'фардо'},
      P:'other{# рӯз пеш}',
      F:'other{пас аз # рӯз}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'соати ҷорӣ'},
      P:'other{# соат пеш}',
      F:'other{пас аз # соат}',
    },
    SHORT:{
      R:{'0':'соати ҷорӣ'},
      P:'other{# ст. пеш}',
      F:'other{пас аз # ст.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'дақиқаи ҷорӣ'},
      P:'other{# дақиқа пеш}',
      F:'other{пас аз # дақиқа}',
    },
    SHORT:{
      R:{'0':'дақиқаи ҷорӣ'},
      P:'other{# дақ. пеш}',
      F:'other{пас аз # дақ.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'моҳи гузашта','0':'моҳи ҷорӣ','1':'моҳи оянда'},
      P:'other{# моҳ пеш}',
      F:'other{пас аз # моҳ}',
    },
    SHORT:{
      R:{'-1':'моҳи г.','0':'моҳи ҷ.','1':'моҳи о.'},
      P:'other{# м. пеш}',
      F:'other{пас аз # м.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'чоряки гузашта','0':'чоряки ҷорӣ','1':'чоряки оянда'},
      P:'other{# чоряк пеш}',
      F:'other{пас аз # чоряк}',
    },
    SHORT:{
      R:{'-1':'чоряки гузашта','0':'чоряки ҷорӣ','1':'чоряки оянда'},
      P:'other{# чр. пеш}',
      F:'other{пас аз # чр.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ҳозир'},
      P:'other{# сония пеш}',
      F:'other{пас аз # сония}',
    },
    SHORT:{
      R:{'0':'ҳозир'},
      P:'other{# сон. пеш}',
      F:'other{пас аз # сон.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ҳафтаи гузашта','0':'ҳафтаи ҷорӣ','1':'ҳафтаи оянда'},
      P:'other{# ҳафта пеш}',
      F:'other{пас аз # ҳафта}',
    },
    SHORT:{
      R:{'-1':'ҳафтаи г.','0':'ҳафтаи ҷ.','1':'ҳафтаи о.'},
      P:'other{# ҳ. пеш}',
      F:'other{пас аз # ҳ.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'соли гузашта','0':'соли ҷорӣ','1':'соли оянда'},
      P:'other{# сол пеш}',
      F:'other{пас аз # сол}',
    },
    SHORT:{
      R:{'-1':'соли г.','0':'соли ҷ.','1':'соли о.'},
      P:'other{# с. пеш}',
      F:'other{пас аз # с.}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tg_TJ = exports.RelativeDateTimeSymbols_tg;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_th_TH = relativeDateTimeSymbols.RelativeDateTimeSymbols_th;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ti =  {
  DAY: {
    LONG:{
      R:{'-1':'ትማሊ','0':'ሎሚ','1':'ጽባሕ'},
      P:'one{ቅድሚ # መዓልቲ}other{ኣብ # መዓልቲ}',
      F:'one{ኣብ # መዓልቲ}other{ኣብ # መዓልቲ}',
    },
    SHORT:{
      R:{'-1':'ትማሊ','0':'ሎሚ','1':'ጽባሕ'},
      P:'one{ቅድሚ # መዓልቲ}other{ቅድሚ # መዓልቲ}',
      F:'one{ኣብ # መዓልቲ}other{ኣብ # መዓልቲ}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'ኣብዚ ሰዓት'},
      P:'one{ቅድሚ # ሰዓት}other{ቅድሚ # ሰዓት}',
      F:'one{ኣብ # ሰዓት}other{ኣብ # ሰዓት}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'ኣብዚ ደቒቕ'},
      P:'one{ቅድሚ # ደቒቕ}other{ቅድሚ # ደቒቕ}',
      F:'one{ኣብ # ደቒቕ}other{ኣብ # ደቒቕ}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'ዝሓለፈ ወርሒ','0':'ህሉው ወርሒ','1':'ዝመጽእ ወርሒ'},
      P:'one{ቅድሚ # ወርሒ}other{ቅድሚ # ወርሒ}',
      F:'one{ኣብ # ወርሒ}other{ኣብ # ወርሒ}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'ዝሓለፈ ርብዒ','0':'ህሉው ርብዒ','1':'ዝመጽእ ርብዒ'},
      P:'one{ቅድሚ # ርብዒ}other{ቅድሚ # ርብዒ}',
      F:'one{ኣብ # ርብዒ}other{ኣብ # ርብዒ}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ሕጂ'},
      P:'one{ቅድሚ # ካልኢት}other{ቅድሚ # ካልኢት}',
      F:'one{ኣብ # ካልኢት}other{ኣብ # ካልኢት}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ዝሓለፈ ሰሙን','0':'ህሉው ሰሙን','1':'ዝመጽእ ሰሙን'},
      P:'one{ቅድሚ # ሰሙን}other{ቅድሚ # ሰሙን}',
      F:'one{ኣብ # ሰሙን}other{ኣብ # ሰሙን}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ዓሚ','0':'ሎሚ ዓመት','1':'ንዓመታ'},
      P:'one{ቅድሚ # ዓ}other{ቅድሚ # ዓ}',
      F:'one{ኣብ # ዓ}other{ኣብ # ዓ}',
    },
    SHORT:{
      R:{'-1':'ዓሚ','0':'ሎሚ ዓመት','1':'ንዓመታ'},
      P:'one{ቅድሚ -# ዓ}other{ቅድሚ # ዓ}',
      F:'one{ኣብ # ዓ}other{ኣብ # ዓ}',
    },
    NARROW:{
      R:{'-1':'ዓሚ','0':'ሎሚ ዓመት','1':'ንዓመታ'},
      P:'one{ቅድሚ # ዓ}other{ቅድሚ # ዓ}',
      F:'one{ኣብ # ዓ}other{ኣብ # ዓ}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ti_ER = exports.RelativeDateTimeSymbols_ti;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ti_ET = exports.RelativeDateTimeSymbols_ti;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tk =  {
  DAY: {
    LONG:{
      R:{'-1':'düýn','0':'şu gün','1':'ertir'},
      P:'one{# gün öň}other{# gün öň}',
      F:'one{# günden}other{# günden}',
    },
    SHORT:{
      R:{'-1':'düýn','0':'şu gün','1':'ertir'},
      P:'one{# g. öň}other{# g. öň}',
      F:'one{# g-den}other{# g-den}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'şu sagat'},
      P:'one{# sagat öň}other{# sagat öň}',
      F:'one{# sagatdan}other{# sagatdan}',
    },
    SHORT:{
      R:{'0':'şu sagat'},
      P:'one{# sag. öň}other{# sag. öň}',
      F:'one{# sag-dan}other{# sag-dan}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'şu minut'},
      P:'one{# minut öň}other{# minut öň}',
      F:'one{# minutdan}other{# minutdan}',
    },
    SHORT:{
      R:{'0':'şu minut'},
      P:'one{# min. öň}other{# min. öň}',
      F:'one{# min-dan}other{# min-dan}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'geçen aý','0':'şu aý','1':'indiki aý'},
      P:'one{# aý öň}other{# aý öň}',
      F:'one{# aýdan}other{# aýdan}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'geçen çärýek','0':'şu çärýek','1':'indiki çärýek'},
      P:'one{# çärýek öň}other{# çärýek öň}',
      F:'one{# çärýekden}other{# çärýekden}',
    },
    SHORT:{
      R:{'-1':'geçen çärýek','0':'şu çärýek','1':'indiki çärýek'},
      P:'one{# çär. öň}other{# çär. öň}',
      F:'one{# çär-den}other{# çär-den}',
    },
    NARROW:{
      R:{'-1':'geçen çärýek','0':'şu çärýek','1':'indiki çärýek'},
      P:'one{# ç. öň}other{# ç. öň}',
      F:'one{# ç-den}other{# ç-den}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'häzir'},
      P:'one{# sekunt öň}other{# sekunt öň}',
      F:'one{# sekuntdan}other{# sekuntdan}',
    },
    SHORT:{
      R:{'0':'häzir'},
      P:'one{# sek. öň}other{# sek. öň}',
      F:'one{# sek-dan}other{# sek-dan}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'geçen hepde','0':'şu hepde','1':'indiki hepde'},
      P:'one{# hepde öň}other{# hepde öň}',
      F:'one{# hepdeden}other{# hepdeden}',
    },
    SHORT:{
      R:{'-1':'geçen hepde','0':'şu hepde','1':'indiki hepde'},
      P:'one{# hep. öň}other{# hep. öň}',
      F:'one{# hep-den}other{# hep-den}',
    },
    NARROW:{
      R:{'-1':'geçen hepde','0':'şu hepde','1':'indiki hepde'},
      P:'one{# h. öň}other{# h. öň}',
      F:'one{# h-den}other{# h-den}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'geçen ýyl','0':'şu ýyl','1':'indiki ýyl'},
      P:'one{# ýyl öň}other{# ýyl öň}',
      F:'one{# ýyldan}other{# ýyldan}',
    },
    SHORT:{
      R:{'-1':'geçen ýyl','0':'şu ýyl','1':'indiki ýyl'},
      P:'one{# ý. öň}other{# ý. öň}',
      F:'one{# ý-dan}other{# ý-dan}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tk_TM = exports.RelativeDateTimeSymbols_tk;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_to =  {
  DAY: {
    LONG:{
      R:{'-1':'ʻaneafi','-2':'ʻaneheafi','0':'ʻahó ni','1':'ʻapongipongi','2':'ʻahepongipongi'},
      P:'other{ʻaho ʻe # kuoʻosi}',
      F:'other{ʻi he ʻaho ʻe #}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'ko e houa ʻeni'},
      P:'other{houa ʻe # kuoʻosi}',
      F:'other{ʻi he houa ʻe #}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'ko e miniti ʻeni'},
      P:'other{miniti ʻe # kuoʻosi}',
      F:'other{ʻi he miniti ʻe #}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'māhina kuoʻosi','0':'māhiná ni','1':'māhina kahaʻu'},
      P:'other{māhina ʻe # kuoʻosi}',
      F:'other{ʻi he māhina ʻe #}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'kuata kuoʻosi','0':'kuata koʻeni','1':'kuata hoko'},
      P:'other{kuata ʻe # kuoʻosi}',
      F:'other{ʻi he kuata ʻe #}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'taimí ni'},
      P:'other{sekoni ʻe # kuoʻosi}',
      F:'other{ʻi he sekoni ʻe #}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'uike kuoʻosi','0':'uiké ni','1':'uike kahaʻu'},
      P:'other{uike ʻe # kuoʻosi}',
      F:'other{ʻi he uike ʻe #}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'taʻu kuoʻosi','0':'taʻú ni','1':'taʻu kahaʻu'},
      P:'other{taʻu ʻe # kuoʻosi}',
      F:'other{ʻi he taʻu ʻe #}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_to_TO = exports.RelativeDateTimeSymbols_to;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tr_CY = relativeDateTimeSymbols.RelativeDateTimeSymbols_tr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tr_TR = relativeDateTimeSymbols.RelativeDateTimeSymbols_tr;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tt =  {
  DAY: {
    LONG:{
      R:{'-1':'кичә','0':'бүген','1':'иртәгә'},
      P:'other{# көн элек}',
      F:'other{# көннән}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'бу сәгатьтә'},
      P:'other{# сәгать элек}',
      F:'other{# сәгатьтән}',
    },
    SHORT:{
      R:{'0':'бу сәгатьтә'},
      P:'other{# сәг. элек}',
      F:'other{# сәг.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'бу минутта'},
      P:'other{# минут элек}',
      F:'other{# минуттан}',
    },
    SHORT:{
      R:{'0':'бу минутта'},
      P:'other{# мин. элек}',
      F:'other{# мин.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'узган айда','0':'бу айда','1':'киләсе айда'},
      P:'other{# ай элек}',
      F:'other{# айдан}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'узган кварталда','0':'бу кварталда','1':'киләсе кварталда'},
      P:'other{# квартал элек}',
      F:'other{# кварталдан}',
    },
    SHORT:{
      R:{'-1':'узган кварталда','0':'бу кварталда','1':'киләсе кварталда'},
      P:'other{# кв. элек}',
      F:'other{# кв.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'хәзер'},
      P:'other{# секунд элек}',
      F:'other{# секундтан}',
    },
    SHORT:{
      R:{'0':'хәзер'},
      P:'other{# с. элек}',
      F:'other{# с.}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'узган атнада','0':'бу атнада','1':'киләсе атнада'},
      P:'other{# атна элек}',
      F:'other{# атнадан}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'узган ел','0':'быел','1':'киләсе елда'},
      P:'other{# ел элек}',
      F:'other{# елдан}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tt_RU = exports.RelativeDateTimeSymbols_tt;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_twq =  {
  DAY: {
    LONG:{
      R:{'-1':'Bi','0':'Hõo','1':'Suba'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_twq_NE = exports.RelativeDateTimeSymbols_twq;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tzm =  {
  DAY: {
    LONG:{
      R:{'-1':'Assenaṭ','0':'Assa','1':'Asekka'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_tzm_MA = exports.RelativeDateTimeSymbols_tzm;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ug =  {
  DAY: {
    LONG:{
      R:{'-1':'تۈنۈگۈن','0':'بۈگۈن','1':'ئەتە'},
      P:'one{# كۈن ئىلگىرى}other{# كۈن ئىلگىرى}',
      F:'one{# كۈندىن كېيىن}other{# كۈندىن كېيىن}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# سائەت ئىلگىرى}other{# سائەت ئىلگىرى}',
      F:'one{# سائەتتىن كېيىن}other{# سائەتتىن كېيىن}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# مىنۇت ئىلگىرى}other{# مىنۇت ئىلگىرى}',
      F:'one{# مىنۇتتىن كېيىن}other{# مىنۇتتىن كېيىن}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'ئۆتكەن ئاي','0':'بۇ ئاي','1':'كېلەر ئاي'},
      P:'one{# ئاي ئىلگىرى}other{# ئاي ئىلگىرى}',
      F:'one{# ئايدىن كېيىن}other{# ئايدىن كېيىن}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{# سېكۇنت ئىلگىرى}other{# سېكۇنت ئىلگىرى}',
      F:'one{# سېكۇنتتىن كېيىن}other{# سېكۇنتتىن كېيىن}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ئۆتكەن ھەپتە','0':'بۇ ھەپتە','1':'كېلەر ھەپتە'},
      P:'one{# ھەپتە ئىلگىرى}other{# ھەپتە ئىلگىرى}',
      F:'one{# ھەپتىدىن كېيىن}other{# ھەپتىدىن كېيىن}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ئۆتكەن يىل','0':'بۇ يىل','1':'كېلەر يىل'},
      P:'one{# يىل ئىلگىرى}other{# يىل ئىلگىرى}',
      F:'one{# يىلدىن كېيىن}other{# يىلدىن كېيىن}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ug_CN = exports.RelativeDateTimeSymbols_ug;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_uk_UA = relativeDateTimeSymbols.RelativeDateTimeSymbols_uk;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ur_IN =  {
  DAY: {
    LONG:{
      R:{'-1':'گزشتہ کل','-2':'گزشتہ پرسوں','0':'آج','1':'آئندہ کل','2':'آنے والا پرسوں'},
      P:'one{# دن پہلے}other{# دنوں پہلے}',
      F:'one{# دن میں}other{# دنوں میں}',
    },
    SHORT:{
      R:{'-1':'گزشتہ کل','-2':'گزشتہ پرسوں','0':'آج','1':'آئندہ کل','2':'آنے والا پرسوں'},
      P:'one{# دن پہلے}other{# دن پہلے}',
      F:'one{# دنوں میں}other{# دنوں میں}',
    },
    NARROW:{
      R:{'-1':'گزشتہ کل','-2':'گزشتہ پرسوں','0':'آج','1':'آئندہ کل','2':'آنے والا پرسوں'},
      P:'one{# دن قبل}other{# دن قبل}',
      F:'one{# دن میں}other{# دنوں میں}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'اس گھنٹے'},
      P:'one{# گھنٹہ پہلے}other{# گھنٹے پہلے}',
      F:'one{# گھنٹے میں}other{# گھنٹے میں}',
    },
    SHORT:{
      R:{'0':'اس گھنٹے'},
      P:'one{# گھنٹے قبل}other{# گھنٹے قبل}',
      F:'one{# گھنٹے میں}other{# گھنٹے میں}',
    },
    NARROW:{
      R:{'0':'اس گھنٹے'},
      P:'one{# گھنٹہ قبل}other{# گھنٹے قبل}',
      F:'one{# گھنٹے میں}other{# گھنٹوں میں}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'اس منٹ'},
      P:'one{# منٹ قبل}other{# منٹ قبل}',
      F:'one{# منٹ میں}other{# منٹ میں}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'گزشتہ ماہ','0':'اس ماہ','1':'اگلے ماہ'},
      P:'one{# ماہ قبل}other{# ماہ قبل}',
      F:'one{# ماہ میں}other{# ماہ میں}',
    },
    SHORT:{
      R:{'-1':'پچھلے مہینہ','0':'اس مہینہ','1':'اگلے مہینہ'},
      P:'one{# ماہ قبل}other{# ماہ قبل}',
      F:'one{# ماہ میں}other{# ماہ میں}',
    },
    NARROW:{
      R:{'-1':'گزشتہ ماہ','0':'اس ماہ','1':'اگلے ماہ'},
      P:'one{# ماہ قبل}other{# ماہ قبل}',
      F:'one{# ماہ میں}other{# ماہ میں}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'گزشتہ سہ ماہی','0':'اس سہ ماہی','1':'اگلے سہ ماہی'},
      P:'one{# سہ ماہی پہلے}other{# سہ ماہی پہلے}',
      F:'one{# سہ ماہی میں}other{# سہ ماہی میں}',
    },
    SHORT:{
      R:{'-1':'گزشتہ سہ ماہی','0':'اس سہ ماہی','1':'اگلے سہ ماہی'},
      P:'one{# سہ ماہی قبل}other{# سہ ماہی قبل}',
      F:'one{# سہ ماہی میں}other{# سہ ماہی میں}',
    },
    NARROW:{
      R:{'-1':'گزشتہ سہ ماہی','0':'اس سہ ماہی','1':'اگلے سہ ماہی'},
      P:'one{# سہ ماہی پہلے}other{# سہ ماہی پہلے}',
      F:'one{# سہ ماہی میں}other{# سہ ماہی میں}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'اب'},
      P:'one{# سیکنڈ قبل}other{# سیکنڈ قبل}',
      F:'one{# سیکنڈ میں}other{# سیکنڈ میں}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'گزشتہ ہفتہ','0':'اس ہفتہ','1':'اگلے ہفتہ'},
      P:'one{# ہفتہ قبل}other{# ہفتے قبل}',
      F:'one{# ہفتہ میں}other{# ہفتوں میں}',
    },
    SHORT:{
      R:{'-1':'پچھلے ہفتہ','0':'اس ہفتہ','1':'اگلے ہفتہ'},
      P:'one{# ہفتے قبل}other{# ہفتے قبل}',
      F:'one{# ہفتے میں}other{# ہفتے میں}',
    },
    NARROW:{
      R:{'-1':'پچھلے ہفتہ','0':'اس ہفتہ','1':'اگلے ہفتہ'},
      P:'one{# ہفتہ قبل}other{# ہفتے قبل}',
      F:'one{# ہفتہ میں}other{# ہفتے میں}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'گزشتہ سال','0':'اس سال','1':'اگلے سال'},
      P:'one{# سال پہلے}other{# سال پہلے}',
      F:'one{# سال میں}other{# سالوں میں}',
    },
    SHORT:{
      R:{'-1':'گزشتہ سال','0':'اس سال','1':'اگلے سال'},
      P:'one{# سال پہلے}other{# سالوں پہلے}',
      F:'one{# سال میں}other{# سالوں میں}',
    },
    NARROW:{
      R:{'-1':'گزشتہ سال','0':'اس سال','1':'اگلے سال'},
      P:'one{# سال پہلے}other{# سال پہلے}',
      F:'one{# سال میں}other{# سال میں}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_ur_PK = relativeDateTimeSymbols.RelativeDateTimeSymbols_ur;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_uz_Arab =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_uz_Arab_AF =  {
  DAY: {
    LONG:{
      R:{'-1':'yesterday','0':'today','1':'tomorrow'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_uz_Cyrl =  {
  DAY: {
    LONG:{
      R:{'-1':'кеча','0':'бугун','1':'эртага'},
      P:'one{# кун олдин}other{# кун олдин}',
      F:'one{# кундан сўнг}other{# кундан сўнг}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# соат олдин}other{# соат олдин}',
      F:'one{# соатдан сўнг}other{# соатдан сўнг}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# дақиқа олдин}other{# дақиқа олдин}',
      F:'one{# дақиқадан сўнг}other{# дақиқадан сўнг}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'ўтган ой','0':'бу ой','1':'кейинги ой'},
      P:'one{# ой аввал}other{# ой аввал}',
      F:'one{# ойдан сўнг}other{# ойдан сўнг}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ҳозир'},
      P:'one{# сония олдин}other{# сония олдин}',
      F:'one{# сониядан сўнг}other{# сониядан сўнг}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ўтган ҳафта','0':'бу ҳафта','1':'кейинги ҳафта'},
      P:'one{# ҳафта олдин}other{# ҳафта олдин}',
      F:'one{# ҳафтадан сўнг}other{# ҳафтадан сўнг}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ўтган йил','0':'бу йил','1':'кейинги йил'},
      P:'one{# йил аввал}other{# йил аввал}',
      F:'one{# йилдан сўнг}other{# йилдан сўнг}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_uz_Cyrl_UZ =  {
  DAY: {
    LONG:{
      R:{'-1':'кеча','0':'бугун','1':'эртага'},
      P:'one{# кун олдин}other{# кун олдин}',
      F:'one{# кундан сўнг}other{# кундан сўнг}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{# соат олдин}other{# соат олдин}',
      F:'one{# соатдан сўнг}other{# соатдан сўнг}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{# дақиқа олдин}other{# дақиқа олдин}',
      F:'one{# дақиқадан сўнг}other{# дақиқадан сўнг}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'ўтган ой','0':'бу ой','1':'кейинги ой'},
      P:'one{# ой аввал}other{# ой аввал}',
      F:'one{# ойдан сўнг}other{# ойдан сўнг}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'ҳозир'},
      P:'one{# сония олдин}other{# сония олдин}',
      F:'one{# сониядан сўнг}other{# сониядан сўнг}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ўтган ҳафта','0':'бу ҳафта','1':'кейинги ҳафта'},
      P:'one{# ҳафта олдин}other{# ҳафта олдин}',
      F:'one{# ҳафтадан сўнг}other{# ҳафтадан сўнг}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'ўтган йил','0':'бу йил','1':'кейинги йил'},
      P:'one{# йил аввал}other{# йил аввал}',
      F:'one{# йилдан сўнг}other{# йилдан сўнг}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_uz_Latn = relativeDateTimeSymbols.RelativeDateTimeSymbols_uz;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_uz_Latn_UZ = relativeDateTimeSymbols.RelativeDateTimeSymbols_uz;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_vai =  {
  DAY: {
    LONG:{
      R:{'-1':'ꖴꖸ','0':'ꗦꗷ','1':'ꔻꕯ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_vai_Latn =  {
  DAY: {
    LONG:{
      R:{'-1':'kunu','0':'wɛlɛ','1':'sina'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_vai_Latn_LR =  {
  DAY: {
    LONG:{
      R:{'-1':'kunu','0':'wɛlɛ','1':'sina'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_vai_Vaii = exports.RelativeDateTimeSymbols_vai;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_vai_Vaii_LR = exports.RelativeDateTimeSymbols_vai;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_vi_VN = relativeDateTimeSymbols.RelativeDateTimeSymbols_vi;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_vun =  {
  DAY: {
    LONG:{
      R:{'-1':'Ukou','0':'Inu','1':'Ngama'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_vun_TZ = exports.RelativeDateTimeSymbols_vun;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_wae =  {
  DAY: {
    LONG:{
      R:{'-1':'Gešter','-2':'Vorgešter','0':'Hitte','1':'Móre','2':'Ubermóre'},
      P:'one{vor # tag}other{vor # täg}',
      F:'one{i # tag}other{i # täg}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'one{vor # stund}other{vor # stunde}',
      F:'one{i # stund}other{i # stunde}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'one{vor # minüta}other{vor # minüte}',
      F:'one{i # minüta}other{i # minüte}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'one{vor # mánet}other{vor # mánet}',
      F:'one{I # mánet}other{I # mánet}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'one{vor # sekund}other{vor # sekunde}',
      F:'one{i # sekund}other{i # sekunde}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'one{vor # wuča}other{cor # wučä}',
      F:'one{i # wuča}other{i # wučä}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'one{vor # jár}other{cor # jár}',
      F:'one{I # jár}other{I # jár}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_wae_CH = exports.RelativeDateTimeSymbols_wae;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_wo =  {
  DAY: {
    LONG:{
      R:{'-1':'démb','0':'tay','1':'suba'},
      P:'other{# fan ci ginaaw}',
      F:'other{fileek # fan}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'ci waxtu wii'},
      P:'other{# waxtu ci ginaaw}',
      F:'other{fileek # waxtu}',
    },
    SHORT:{
      R:{'0':'ci waxtu wii'},
      P:'other{# wax. ci ginaaw}',
      F:'other{fileek # wax.}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'ci simili bii'},
      P:'other{# simili ci ginaaw}',
      F:'other{fileek # simili}',
    },
    SHORT:{
      R:{'0':'ci simili bii'},
      P:'other{# sim. ci ginaaw}',
      F:'other{fileek # sim.}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'weer wi weesu','0':'weer wii','1':'weer wiy ñëw'},
      P:'other{# weer ci ginaaw}',
      F:'other{fileek # weer}',
    },
    SHORT:{
      R:{'-1':'we. wi wees','0':'we. wii','1':'we. wiy ñëw'},
      P:'other{# we. ci ginaaw}',
      F:'other{fileek # we.}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'trimestre bi weesu','0':'trimestre bii','1':'trimestre biy ñëw'},
      P:'other{# trimestre ci ginaaw}',
      F:'other{fileek # trimestre}',
    },
    SHORT:{
      R:{'-1':'trimestre bi weesu','0':'trimestre bii','1':'trimestre biy ñëw'},
      P:'other{# trim. ci ginaaw}',
      F:'other{fileek # trim.}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'leegi'},
      P:'other{# saa ci ginaaw}',
      F:'other{fileek # saa}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ayu-bis bi weesu','0':'ayu-bis bii','1':'ayu-bis biy ñëw'},
      P:'other{# ayi-bis ci ginaaw}',
      F:'other{fileek # ayi-bis}',
    },
    SHORT:{
      R:{'-1':'ayu-b bi wees','0':'ayu-b bii','1':'ayu-b. ñëw'},
      P:'other{# ayi-b. ci ginaaw}',
      F:'other{fileek # ayi-b.}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'daaw','0':'ren','1':'dewen'},
      P:'other{# at ci ginaaw}',
      F:'other{fileek # at}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_wo_SN = exports.RelativeDateTimeSymbols_wo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_xh =  {
  DAY: {
    LONG:{
      R:{'-1':'izolo','0':'namhlanje','1':'ngomso'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'inyanga ephelileyo','0':'kule nyanga','1':'kwinyanga ezayo'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
    SHORT:{
      R:{'-1':'inyanga ephel.','0':'kule nya.','1':'kwinyanga eza.'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
    NARROW:{
      R:{'-1':'inya ephel.','0':'kule nya.','1':'kwinya eza.'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'kwiveki ephelileyo','0':'ku;e veki','1':'kwiveki ezayo'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
    SHORT:{
      R:{'-1':'vek ephel.','0':'kule vek.','1':'vek eza.'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
    NARROW:{
      R:{'-1':'veki ephel.','0':'kule vek.','1':'veki eza.'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'unyaka ophelileyo','0':'kulo nyaka','1':'kunyaka ozayo'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
    SHORT:{
      R:{'-1':'unyaka ophel.','0':'kulo nyak.','1':'kunyak oza.'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
    NARROW:{
      R:{'-1':'unyaka ophel.','0':'kulo nyak.','1':'unyak oza.'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_xh_ZA = exports.RelativeDateTimeSymbols_xh;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_xog =  {
  DAY: {
    LONG:{
      R:{'-1':'Edho','0':'Olwaleelo (leelo)','1':'Enkyo'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_xog_UG = exports.RelativeDateTimeSymbols_xog;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yav =  {
  DAY: {
    LONG:{
      R:{'-1':'púyoó','0':'ínaan','1':'nakinyám'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yav_CM = exports.RelativeDateTimeSymbols_yav;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yi =  {
  DAY: {
    LONG:{
      R:{'-1':'נעכטן','0':'היינט','1':'מארגן'},
      P:'other{-# d}',
      F:'one{אין # טאָג אַרום}other{אין # טעג אַרום}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'פֿאַרגאנגענעם חודש','0':'דעם חודש','1':'קומענדיקן חודש'},
      P:'one{פֿאַר # חודש}other{פֿאַר # חדשים}',
      F:'one{איבער # חודש}other{איבער # חדשים}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'איבער אַכט טאָג'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'פֿאַראַיאָר','0':'הײַ יאָר','1':'איבער א יאָר'},
      P:'one{פֿאַר # יאָר}other{פֿאַר # יאָר}',
      F:'one{איבער # יאָר}other{איבער # יאָר}',
    },
    SHORT:{
      R:{'-1':'פֿאַראַיאָר','0':'הײַ יאָר','1':'איבער א יאָר'},
      P:'one{פֿאַר # יאָר}other{פֿאַר # יאָר}',
      F:'one{איבער א יאָר}other{איבער # יאָר}',
    },
    NARROW:{
      R:{'-1':'פֿאַראַיאָר','0':'הײַ יאָר','1':'איבער א יאָר'},
      P:'one{פֿאַר # יאָר}other{פֿאַר # יאָר}',
      F:'one{איבער # יאָר}other{איבער # יאָר}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yi_001 = exports.RelativeDateTimeSymbols_yi;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yo =  {
  DAY: {
    LONG:{
      R:{'-1':'Àná','-2':'íjẹta','0':'Òní','1':'Ọ̀la','2':'òtúùnla'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'óṣù tó kọjá','0':'oṣù yìí','1':'óṣù tó ń bọ̀,'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ọ̀sẹ̀ tó kọjá','0':'ọ̀sẹ̀ yìí','1':'ọ́sẹ̀ tó ń bọ̀'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'Èṣín','0':'Ọdúnǹí','1':'Àmọ́dún'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
    SHORT:{
      R:{'-1':'Ọdún tó kọjá','0':'Ọdún yìí','1':'Ọdún tó ńbọ̀'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yo_BJ =  {
  DAY: {
    LONG:{
      R:{'-1':'Àná','-2':'íjɛta','0':'Òní','1':'Ɔ̀la'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'óshù tó kɔjá','0':'oshù yìí','1':'óshù tó ń bɔ̀,'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'ɔ̀sɛ̀ tó kɔjá','0':'ɔ̀sɛ̀ yìí','1':'ɔ́sɛ̀ tó ń bɔ̀'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'Èshín','0':'Ɔdúnǹí','1':'Àmɔ́dún'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
    SHORT:{
      R:{'-1':'Ɔdún tó kɔjá','0':'Ɔdún yìí','1':'Ɔdún tó ńbɔ̀'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yo_NG = exports.RelativeDateTimeSymbols_yo;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yrl =  {
  DAY: {
    LONG:{
      R:{'-1':'kuesê','-2':'amũ kuesê','0':'wií','1':'wirãdé','2':'wirãdé ariré'},
      P:'one{aikué # ara}other{aikué # ara itá}',
      F:'one{# ara resê}other{# ara itá resê}',
    },
    SHORT:{
      R:{'-2':'amũ kuesê','2':'wirãdé ariré'},
      P:'one{aikué # ara}other{aikué # ara itá}',
      F:'one{# ara resê}other{# ara itá resê}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'kuá hura'},
      P:'one{aikué # hura}other{aikué # hura itá}',
      F:'one{# hura resê}other{# hura resê itá}',
    },
    SHORT:{
      R:{'0':'kuá hura'},
      P:'one{aikué # h}other{aikué # h itá}',
      F:'one{# h resê}other{# h resê itá}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'kuá minutu'},
      P:'one{aikué # minutu}other{aikué # minutu itá}',
      F:'one{# minutu resê}other{# minutu resê itá}',
    },
    SHORT:{
      R:{'0':'kuá minutu'},
      P:'one{aikué # min.}other{aikué # min. itá}',
      F:'one{# min. resê}other{# min. resê itá}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'yasí kuera','0':'kuá yasí','1':'amũ yasí'},
      P:'one{aikué # yasí}other{aikué # yasí itá}',
      F:'one{# yasí resê}other{# yasí itá resê}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'kasakiriwara musapíri-yasí','0':'kuá musapíri-yasí','1':'amũ musapíri-yasí'},
      P:'one{aikué # musapíri-yasí}other{aikué # musapíri-yasí itá}',
      F:'one{# musapíri-yasí resê}other{# musapíri-yasí itá resê}',
    },
    SHORT:{
      R:{'-1':'kasakiriwara musapíri-yasí','0':'kuá musapíri-yasí','1':'amũ musapíri-yasí'},
      P:'one{aikué # mu-y.}other{aikué # mu-y. itá}',
      F:'one{# mu-y. resê}other{# mu-y. itá resê}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'kuíri'},
      P:'one{aikué # segũdu}other{aikué # segũdu itá}',
      F:'one{# segũdu resê}other{# segũdu resê itá}',
    },
    SHORT:{
      R:{'0':'kuíri'},
      P:'one{aikué # seg.}other{aikué # seg. itá}',
      F:'one{# seg. resê}other{# seg. resê itá}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'sẽmãna kuera','0':'kuá sẽmãna','1':'amũ sẽmãna'},
      P:'one{aikué # sẽmãna}other{aikué # sẽmãna itá}',
      F:'one{# sẽmãna resê}other{# sẽmãna itá resê}',
    },
    SHORT:{
      R:{'-1':'sẽmãna kuera','0':'kuá sẽmãna','1':'amũ sẽmãna'},
      P:'one{aikué # sẽm.}other{aikué # sẽm. itá}',
      F:'one{# sẽm. resê}other{# sẽm. itá resê}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'akayú kuera','0':'kuá akayú','1':'amũ akayú'},
      P:'one{aikué # akayú}other{aikué # akayú itá}',
      F:'one{# akayú resê}other{# akayú itá resê}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yrl_BR = exports.RelativeDateTimeSymbols_yrl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yrl_CO = exports.RelativeDateTimeSymbols_yrl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yrl_VE = exports.RelativeDateTimeSymbols_yrl;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yue =  {
  DAY: {
    LONG:{
      R:{'-1':'尋日','-2':'前天','0':'今日','1':'聽日','2':'後天'},
      P:'other{# 日前}',
      F:'other{# 日後}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'呢個小時'},
      P:'other{# 小時前}',
      F:'other{# 小時後}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'呢分鐘'},
      P:'other{# 分鐘前}',
      F:'other{# 分鐘後}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上個月','0':'今個月','1':'下個月'},
      P:'other{# 個月前}',
      F:'other{# 個月後}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上一季','0':'今季','1':'下一季'},
      P:'other{# 季前}',
      F:'other{# 季後}',
    },
    SHORT:{
      R:{'-1':'上季','0':'今季','1':'下季'},
      P:'other{# 季前}',
      F:'other{# 季後}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'宜家'},
      P:'other{# 秒前}',
      F:'other{# 秒後}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上星期','0':'今個星期','1':'下星期'},
      P:'other{# 個星期前}',
      F:'other{# 個星期後}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'舊年','0':'今年','1':'下年'},
      P:'other{# 年前}',
      F:'other{# 年後}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yue_Hans =  {
  DAY: {
    LONG:{
      R:{'-1':'寻日','-2':'前天','0':'今日','1':'听日','2':'后天'},
      P:'other{# 日前}',
      F:'other{# 日后}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'呢个小时'},
      P:'other{# 小时前}',
      F:'other{# 小时后}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'呢分钟'},
      P:'other{# 分钟前}',
      F:'other{# 分钟后}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上个月','0':'今个月','1':'下个月'},
      P:'other{# 个月前}',
      F:'other{# 个月后}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上一季','0':'今季','1':'下一季'},
      P:'other{# 季前}',
      F:'other{# 季后}',
    },
    SHORT:{
      R:{'-1':'上季','0':'今季','1':'下季'},
      P:'other{# 季前}',
      F:'other{# 季后}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'宜家'},
      P:'other{# 秒前}',
      F:'other{# 秒后}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上星期','0':'今个星期','1':'下星期'},
      P:'other{# 个星期前}',
      F:'other{# 个星期后}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'旧年','0':'今年','1':'下年'},
      P:'other{# 年前}',
      F:'other{# 年后}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yue_Hans_CN =  {
  DAY: {
    LONG:{
      R:{'-1':'寻日','-2':'前天','0':'今日','1':'听日','2':'后天'},
      P:'other{# 日前}',
      F:'other{# 日后}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'呢个小时'},
      P:'other{# 小时前}',
      F:'other{# 小时后}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'呢分钟'},
      P:'other{# 分钟前}',
      F:'other{# 分钟后}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上个月','0':'今个月','1':'下个月'},
      P:'other{# 个月前}',
      F:'other{# 个月后}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上一季','0':'今季','1':'下一季'},
      P:'other{# 季前}',
      F:'other{# 季后}',
    },
    SHORT:{
      R:{'-1':'上季','0':'今季','1':'下季'},
      P:'other{# 季前}',
      F:'other{# 季后}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'宜家'},
      P:'other{# 秒前}',
      F:'other{# 秒后}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上星期','0':'今个星期','1':'下星期'},
      P:'other{# 个星期前}',
      F:'other{# 个星期后}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'旧年','0':'今年','1':'下年'},
      P:'other{# 年前}',
      F:'other{# 年后}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yue_Hant = exports.RelativeDateTimeSymbols_yue;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_yue_Hant_HK = exports.RelativeDateTimeSymbols_yue;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zgh =  {
  DAY: {
    LONG:{
      R:{'-1':'ⵉⴹⵍⵍⵉ','0':'ⴰⵙⵙⴰ','1':'ⴰⵙⴽⴽⴰ'},
      P:'other{-# d}',
      F:'other{+# d}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'this hour'},
      P:'other{-# h}',
      F:'other{+# h}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'this minute'},
      P:'other{-# min}',
      F:'other{+# min}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'last month','0':'this month','1':'next month'},
      P:'other{-# m}',
      F:'other{+# m}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'last quarter','0':'this quarter','1':'next quarter'},
      P:'other{-# Q}',
      F:'other{+# Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'now'},
      P:'other{-# s}',
      F:'other{+# s}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'last week','0':'this week','1':'next week'},
      P:'other{-# w}',
      F:'other{+# w}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'last year','0':'this year','1':'next year'},
      P:'other{-# y}',
      F:'other{+# y}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zgh_MA = exports.RelativeDateTimeSymbols_zgh;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hans = relativeDateTimeSymbols.RelativeDateTimeSymbols_zh;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hans_CN = relativeDateTimeSymbols.RelativeDateTimeSymbols_zh;

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hans_HK =  {
  DAY: {
    LONG:{
      R:{'-1':'昨天','-2':'前天','0':'今天','1':'明天','2':'后天'},
      P:'other{#天前}',
      F:'other{#天后}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'这一时间 / 此时'},
      P:'other{#小时前}',
      F:'other{#小时后}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'此刻'},
      P:'other{#分钟前}',
      F:'other{#分钟后}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上个月','0':'本月','1':'下个月'},
      P:'other{#个月前}',
      F:'other{#个月后}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上季度','0':'本季度','1':'下季度'},
      P:'other{#个季度前}',
      F:'other{#个季度后}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'现在'},
      P:'other{#秒前}',
      F:'other{#秒后}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上周','0':'本周','1':'下周'},
      P:'other{#周前}',
      F:'other{#周后}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'去年','0':'今年','1':'明年'},
      P:'other{#年前}',
      F:'other{#年后}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hans_MO =  {
  DAY: {
    LONG:{
      R:{'-1':'昨天','-2':'前天','0':'今天','1':'明天','2':'后天'},
      P:'other{#天前}',
      F:'other{#天后}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'这一时间 / 此时'},
      P:'other{#小时前}',
      F:'other{#小时后}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'此刻'},
      P:'other{#分钟前}',
      F:'other{#分钟后}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上个月','0':'本月','1':'下个月'},
      P:'other{#个月前}',
      F:'other{#个月后}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上季度','0':'本季度','1':'下季度'},
      P:'other{#个季度前}',
      F:'other{#个季度后}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'现在'},
      P:'other{#秒前}',
      F:'other{#秒后}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上周','0':'本周','1':'下周'},
      P:'other{#周前}',
      F:'other{#周后}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'去年','0':'今年','1':'明年'},
      P:'other{#年前}',
      F:'other{#年后}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hans_SG =  {
  DAY: {
    LONG:{
      R:{'-1':'昨天','-2':'前天','0':'今天','1':'明天','2':'后天'},
      P:'other{#天前}',
      F:'other{#天后}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'这一时间 / 此时'},
      P:'other{#小时前}',
      F:'other{#小时后}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'此刻'},
      P:'other{#分钟前}',
      F:'other{#分钟后}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上个月','0':'本月','1':'下个月'},
      P:'other{#个月前}',
      F:'other{#个月后}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上季度','0':'本季度','1':'下季度'},
      P:'other{#个季度前}',
      F:'other{#个季度后}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'现在'},
      P:'other{#秒前}',
      F:'other{#秒后}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上周','0':'本周','1':'下周'},
      P:'other{#周前}',
      F:'other{#周后}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'去年','0':'今年','1':'明年'},
      P:'other{#年前}',
      F:'other{#年后}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hant =  {
  DAY: {
    LONG:{
      R:{'-1':'昨天','-2':'前天','0':'今天','1':'明天','2':'後天'},
      P:'other{# 天前}',
      F:'other{# 天後}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'這一小時'},
      P:'other{# 小時前}',
      F:'other{# 小時後}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'這一分鐘'},
      P:'other{# 分鐘前}',
      F:'other{# 分鐘後}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上個月','0':'本月','1':'下個月'},
      P:'other{# 個月前}',
      F:'other{# 個月後}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上一季','0':'這一季','1':'下一季'},
      P:'other{# 季前}',
      F:'other{# 季後}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'現在'},
      P:'other{# 秒前}',
      F:'other{# 秒後}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上週','0':'本週','1':'下週'},
      P:'other{# 週前}',
      F:'other{# 週後}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'去年','0':'今年','1':'明年'},
      P:'other{# 年前}',
      F:'other{# 年後}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hant_HK =  {
  DAY: {
    LONG:{
      R:{'-1':'昨日','-2':'前日','0':'今日','1':'明日','2':'後日'},
      P:'other{# 日前}',
      F:'other{# 日後}',
    },
    NARROW:{
      R:{'-1':'昨日','-2':'前日','0':'今日','1':'明日','2':'後日'},
      P:'other{#日前}',
      F:'other{#日後}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'這個小時'},
      P:'other{# 小時前}',
      F:'other{# 小時後}',
    },
    NARROW:{
      R:{'0':'這個小時'},
      P:'other{#小時前}',
      F:'other{#小時後}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'這分鐘'},
      P:'other{# 分鐘前}',
      F:'other{# 分鐘後}',
    },
    NARROW:{
      R:{'0':'這分鐘'},
      P:'other{#分前}',
      F:'other{#分後}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上個月','0':'本月','1':'下個月'},
      P:'other{# 個月前}',
      F:'other{# 個月後}',
    },
    NARROW:{
      R:{'-1':'上個月','0':'本月','1':'下個月'},
      P:'other{#個月前}',
      F:'other{#個月後}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上一季','0':'今季','1':'下一季'},
      P:'other{# 季前}',
      F:'other{# 季後}',
    },
    SHORT:{
      R:{'-1':'上季','0':'今季','1':'下季'},
      P:'other{# 季前}',
      F:'other{# 季後}',
    },
    NARROW:{
      R:{'-1':'上季','0':'今季','1':'下季'},
      P:'other{-#Q}',
      F:'other{+#Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'現在'},
      P:'other{# 秒前}',
      F:'other{# 秒後}',
    },
    NARROW:{
      R:{'0':'現在'},
      P:'other{#秒前}',
      F:'other{#秒後}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上星期','0':'本星期','1':'下星期'},
      P:'other{# 星期前}',
      F:'other{# 星期後}',
    },
    NARROW:{
      R:{'-1':'上星期','0':'本星期','1':'下星期'},
      P:'other{#星期前}',
      F:'other{#星期後}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'上年','0':'今年','1':'下年'},
      P:'other{# 年前}',
      F:'other{# 年後}',
    },
    NARROW:{
      R:{'-1':'上年','0':'今年','1':'下年'},
      P:'other{#年前}',
      F:'other{#年後}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hant_MO =  {
  DAY: {
    LONG:{
      R:{'-1':'昨日','-2':'前日','0':'今日','1':'明日','2':'後日'},
      P:'other{# 日前}',
      F:'other{# 日後}',
    },
    NARROW:{
      R:{'-1':'昨日','-2':'前日','0':'今日','1':'明日','2':'後日'},
      P:'other{#日前}',
      F:'other{#日後}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'這個小時'},
      P:'other{# 小時前}',
      F:'other{# 小時後}',
    },
    NARROW:{
      R:{'0':'這個小時'},
      P:'other{#小時前}',
      F:'other{#小時後}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'這分鐘'},
      P:'other{# 分鐘前}',
      F:'other{# 分鐘後}',
    },
    NARROW:{
      R:{'0':'這分鐘'},
      P:'other{#分前}',
      F:'other{#分後}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上個月','0':'本月','1':'下個月'},
      P:'other{# 個月前}',
      F:'other{# 個月後}',
    },
    NARROW:{
      R:{'-1':'上個月','0':'本月','1':'下個月'},
      P:'other{#個月前}',
      F:'other{#個月後}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上一季','0':'今季','1':'下一季'},
      P:'other{# 季前}',
      F:'other{# 季後}',
    },
    SHORT:{
      R:{'-1':'上季','0':'今季','1':'下季'},
      P:'other{# 季前}',
      F:'other{# 季後}',
    },
    NARROW:{
      R:{'-1':'上季','0':'今季','1':'下季'},
      P:'other{-#Q}',
      F:'other{+#Q}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'現在'},
      P:'other{# 秒前}',
      F:'other{# 秒後}',
    },
    NARROW:{
      R:{'0':'現在'},
      P:'other{#秒前}',
      F:'other{#秒後}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上星期','0':'本星期','1':'下星期'},
      P:'other{# 星期前}',
      F:'other{# 星期後}',
    },
    NARROW:{
      R:{'-1':'上星期','0':'本星期','1':'下星期'},
      P:'other{#星期前}',
      F:'other{#星期後}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'上年','0':'今年','1':'下年'},
      P:'other{# 年前}',
      F:'other{# 年後}',
    },
    NARROW:{
      R:{'-1':'上年','0':'今年','1':'下年'},
      P:'other{#年前}',
      F:'other{#年後}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zh_Hant_TW =  {
  DAY: {
    LONG:{
      R:{'-1':'昨天','-2':'前天','0':'今天','1':'明天','2':'後天'},
      P:'other{# 天前}',
      F:'other{# 天後}',
    },
  },
  HOUR: {
    LONG:{
      R:{'0':'這一小時'},
      P:'other{# 小時前}',
      F:'other{# 小時後}',
    },
  },
  MINUTE: {
    LONG:{
      R:{'0':'這一分鐘'},
      P:'other{# 分鐘前}',
      F:'other{# 分鐘後}',
    },
  },
  MONTH: {
    LONG:{
      R:{'-1':'上個月','0':'本月','1':'下個月'},
      P:'other{# 個月前}',
      F:'other{# 個月後}',
    },
  },
  QUARTER: {
    LONG:{
      R:{'-1':'上一季','0':'這一季','1':'下一季'},
      P:'other{# 季前}',
      F:'other{# 季後}',
    },
  },
  SECOND: {
    LONG:{
      R:{'0':'現在'},
      P:'other{# 秒前}',
      F:'other{# 秒後}',
    },
  },
  WEEK: {
    LONG:{
      R:{'-1':'上週','0':'本週','1':'下週'},
      P:'other{# 週前}',
      F:'other{# 週後}',
    },
  },
  YEAR: {
    LONG:{
      R:{'-1':'去年','0':'今年','1':'明年'},
      P:'other{# 年前}',
      F:'other{# 年後}',
    },
  },
};

/** @const {!relativeDateTimeSymbols.RelativeDateTimeSymbols} */
exports.RelativeDateTimeSymbols_zu_ZA = relativeDateTimeSymbols.RelativeDateTimeSymbols_zu;

switch (goog.LOCALE) {
  case 'af_NA':
  case 'af-NA':
    defaultSymbols = exports.RelativeDateTimeSymbols_af_NA;
    break;
  case 'af_ZA':
  case 'af-ZA':
    defaultSymbols = exports.RelativeDateTimeSymbols_af_ZA;
    break;
  case 'agq':
    defaultSymbols = exports.RelativeDateTimeSymbols_agq;
    break;
  case 'agq_CM':
  case 'agq-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_agq_CM;
    break;
  case 'ak':
    defaultSymbols = exports.RelativeDateTimeSymbols_ak;
    break;
  case 'ak_GH':
  case 'ak-GH':
    defaultSymbols = exports.RelativeDateTimeSymbols_ak_GH;
    break;
  case 'am_ET':
  case 'am-ET':
    defaultSymbols = exports.RelativeDateTimeSymbols_am_ET;
    break;
  case 'ar_001':
  case 'ar-001':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_001;
    break;
  case 'ar_AE':
  case 'ar-AE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_AE;
    break;
  case 'ar_BH':
  case 'ar-BH':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_BH;
    break;
  case 'ar_DJ':
  case 'ar-DJ':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_DJ;
    break;
  case 'ar_EH':
  case 'ar-EH':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_EH;
    break;
  case 'ar_ER':
  case 'ar-ER':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_ER;
    break;
  case 'ar_IL':
  case 'ar-IL':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_IL;
    break;
  case 'ar_IQ':
  case 'ar-IQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_IQ;
    break;
  case 'ar_JO':
  case 'ar-JO':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_JO;
    break;
  case 'ar_KM':
  case 'ar-KM':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_KM;
    break;
  case 'ar_KW':
  case 'ar-KW':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_KW;
    break;
  case 'ar_LB':
  case 'ar-LB':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_LB;
    break;
  case 'ar_LY':
  case 'ar-LY':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_LY;
    break;
  case 'ar_MA':
  case 'ar-MA':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_MA;
    break;
  case 'ar_MR':
  case 'ar-MR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_MR;
    break;
  case 'ar_OM':
  case 'ar-OM':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_OM;
    break;
  case 'ar_PS':
  case 'ar-PS':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_PS;
    break;
  case 'ar_QA':
  case 'ar-QA':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_QA;
    break;
  case 'ar_SA':
  case 'ar-SA':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_SA;
    break;
  case 'ar_SD':
  case 'ar-SD':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_SD;
    break;
  case 'ar_SO':
  case 'ar-SO':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_SO;
    break;
  case 'ar_SS':
  case 'ar-SS':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_SS;
    break;
  case 'ar_SY':
  case 'ar-SY':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_SY;
    break;
  case 'ar_TD':
  case 'ar-TD':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_TD;
    break;
  case 'ar_TN':
  case 'ar-TN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_TN;
    break;
  case 'ar_XB':
  case 'ar-XB':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_XB;
    break;
  case 'ar_YE':
  case 'ar-YE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ar_YE;
    break;
  case 'as':
    defaultSymbols = exports.RelativeDateTimeSymbols_as;
    break;
  case 'as_IN':
  case 'as-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_as_IN;
    break;
  case 'asa':
    defaultSymbols = exports.RelativeDateTimeSymbols_asa;
    break;
  case 'asa_TZ':
  case 'asa-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_asa_TZ;
    break;
  case 'ast':
    defaultSymbols = exports.RelativeDateTimeSymbols_ast;
    break;
  case 'ast_ES':
  case 'ast-ES':
    defaultSymbols = exports.RelativeDateTimeSymbols_ast_ES;
    break;
  case 'az_Cyrl':
  case 'az-Cyrl':
    defaultSymbols = exports.RelativeDateTimeSymbols_az_Cyrl;
    break;
  case 'az_Cyrl_AZ':
  case 'az-Cyrl-AZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_az_Cyrl_AZ;
    break;
  case 'az_Latn':
  case 'az-Latn':
    defaultSymbols = exports.RelativeDateTimeSymbols_az_Latn;
    break;
  case 'az_Latn_AZ':
  case 'az-Latn-AZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_az_Latn_AZ;
    break;
  case 'bas':
    defaultSymbols = exports.RelativeDateTimeSymbols_bas;
    break;
  case 'bas_CM':
  case 'bas-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_bas_CM;
    break;
  case 'be_BY':
  case 'be-BY':
    defaultSymbols = exports.RelativeDateTimeSymbols_be_BY;
    break;
  case 'bem':
    defaultSymbols = exports.RelativeDateTimeSymbols_bem;
    break;
  case 'bem_ZM':
  case 'bem-ZM':
    defaultSymbols = exports.RelativeDateTimeSymbols_bem_ZM;
    break;
  case 'bez':
    defaultSymbols = exports.RelativeDateTimeSymbols_bez;
    break;
  case 'bez_TZ':
  case 'bez-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_bez_TZ;
    break;
  case 'bg_BG':
  case 'bg-BG':
    defaultSymbols = exports.RelativeDateTimeSymbols_bg_BG;
    break;
  case 'bgc':
    defaultSymbols = exports.RelativeDateTimeSymbols_bgc;
    break;
  case 'bgc_IN':
  case 'bgc-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_bgc_IN;
    break;
  case 'bho':
    defaultSymbols = exports.RelativeDateTimeSymbols_bho;
    break;
  case 'bho_IN':
  case 'bho-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_bho_IN;
    break;
  case 'bm':
    defaultSymbols = exports.RelativeDateTimeSymbols_bm;
    break;
  case 'bm_ML':
  case 'bm-ML':
    defaultSymbols = exports.RelativeDateTimeSymbols_bm_ML;
    break;
  case 'bn_BD':
  case 'bn-BD':
    defaultSymbols = exports.RelativeDateTimeSymbols_bn_BD;
    break;
  case 'bn_IN':
  case 'bn-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_bn_IN;
    break;
  case 'bo':
    defaultSymbols = exports.RelativeDateTimeSymbols_bo;
    break;
  case 'bo_CN':
  case 'bo-CN':
    defaultSymbols = exports.RelativeDateTimeSymbols_bo_CN;
    break;
  case 'bo_IN':
  case 'bo-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_bo_IN;
    break;
  case 'br_FR':
  case 'br-FR':
    defaultSymbols = exports.RelativeDateTimeSymbols_br_FR;
    break;
  case 'brx':
    defaultSymbols = exports.RelativeDateTimeSymbols_brx;
    break;
  case 'brx_IN':
  case 'brx-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_brx_IN;
    break;
  case 'bs_Cyrl':
  case 'bs-Cyrl':
    defaultSymbols = exports.RelativeDateTimeSymbols_bs_Cyrl;
    break;
  case 'bs_Cyrl_BA':
  case 'bs-Cyrl-BA':
    defaultSymbols = exports.RelativeDateTimeSymbols_bs_Cyrl_BA;
    break;
  case 'bs_Latn':
  case 'bs-Latn':
    defaultSymbols = exports.RelativeDateTimeSymbols_bs_Latn;
    break;
  case 'bs_Latn_BA':
  case 'bs-Latn-BA':
    defaultSymbols = exports.RelativeDateTimeSymbols_bs_Latn_BA;
    break;
  case 'ca_AD':
  case 'ca-AD':
    defaultSymbols = exports.RelativeDateTimeSymbols_ca_AD;
    break;
  case 'ca_ES':
  case 'ca-ES':
    defaultSymbols = exports.RelativeDateTimeSymbols_ca_ES;
    break;
  case 'ca_FR':
  case 'ca-FR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ca_FR;
    break;
  case 'ca_IT':
  case 'ca-IT':
    defaultSymbols = exports.RelativeDateTimeSymbols_ca_IT;
    break;
  case 'ccp':
    defaultSymbols = exports.RelativeDateTimeSymbols_ccp;
    break;
  case 'ccp_BD':
  case 'ccp-BD':
    defaultSymbols = exports.RelativeDateTimeSymbols_ccp_BD;
    break;
  case 'ccp_IN':
  case 'ccp-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ccp_IN;
    break;
  case 'ce':
    defaultSymbols = exports.RelativeDateTimeSymbols_ce;
    break;
  case 'ce_RU':
  case 'ce-RU':
    defaultSymbols = exports.RelativeDateTimeSymbols_ce_RU;
    break;
  case 'ceb':
    defaultSymbols = exports.RelativeDateTimeSymbols_ceb;
    break;
  case 'ceb_PH':
  case 'ceb-PH':
    defaultSymbols = exports.RelativeDateTimeSymbols_ceb_PH;
    break;
  case 'cgg':
    defaultSymbols = exports.RelativeDateTimeSymbols_cgg;
    break;
  case 'cgg_UG':
  case 'cgg-UG':
    defaultSymbols = exports.RelativeDateTimeSymbols_cgg_UG;
    break;
  case 'chr_US':
  case 'chr-US':
    defaultSymbols = exports.RelativeDateTimeSymbols_chr_US;
    break;
  case 'ckb':
    defaultSymbols = exports.RelativeDateTimeSymbols_ckb;
    break;
  case 'ckb_Arab':
  case 'ckb-Arab':
    defaultSymbols = exports.RelativeDateTimeSymbols_ckb_Arab;
    break;
  case 'ckb_Arab_IQ':
  case 'ckb-Arab-IQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_ckb_Arab_IQ;
    break;
  case 'ckb_Arab_IR':
  case 'ckb-Arab-IR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ckb_Arab_IR;
    break;
  case 'ckb_IQ':
  case 'ckb-IQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_ckb_IQ;
    break;
  case 'ckb_IR':
  case 'ckb-IR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ckb_IR;
    break;
  case 'cs_CZ':
  case 'cs-CZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_cs_CZ;
    break;
  case 'cv':
    defaultSymbols = exports.RelativeDateTimeSymbols_cv;
    break;
  case 'cv_RU':
  case 'cv-RU':
    defaultSymbols = exports.RelativeDateTimeSymbols_cv_RU;
    break;
  case 'cy_GB':
  case 'cy-GB':
    defaultSymbols = exports.RelativeDateTimeSymbols_cy_GB;
    break;
  case 'da_DK':
  case 'da-DK':
    defaultSymbols = exports.RelativeDateTimeSymbols_da_DK;
    break;
  case 'da_GL':
  case 'da-GL':
    defaultSymbols = exports.RelativeDateTimeSymbols_da_GL;
    break;
  case 'dav':
    defaultSymbols = exports.RelativeDateTimeSymbols_dav;
    break;
  case 'dav_KE':
  case 'dav-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_dav_KE;
    break;
  case 'de_BE':
  case 'de-BE':
    defaultSymbols = exports.RelativeDateTimeSymbols_de_BE;
    break;
  case 'de_DE':
  case 'de-DE':
    defaultSymbols = exports.RelativeDateTimeSymbols_de_DE;
    break;
  case 'de_IT':
  case 'de-IT':
    defaultSymbols = exports.RelativeDateTimeSymbols_de_IT;
    break;
  case 'de_LI':
  case 'de-LI':
    defaultSymbols = exports.RelativeDateTimeSymbols_de_LI;
    break;
  case 'de_LU':
  case 'de-LU':
    defaultSymbols = exports.RelativeDateTimeSymbols_de_LU;
    break;
  case 'dje':
    defaultSymbols = exports.RelativeDateTimeSymbols_dje;
    break;
  case 'dje_NE':
  case 'dje-NE':
    defaultSymbols = exports.RelativeDateTimeSymbols_dje_NE;
    break;
  case 'doi':
    defaultSymbols = exports.RelativeDateTimeSymbols_doi;
    break;
  case 'doi_IN':
  case 'doi-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_doi_IN;
    break;
  case 'dsb':
    defaultSymbols = exports.RelativeDateTimeSymbols_dsb;
    break;
  case 'dsb_DE':
  case 'dsb-DE':
    defaultSymbols = exports.RelativeDateTimeSymbols_dsb_DE;
    break;
  case 'dua':
    defaultSymbols = exports.RelativeDateTimeSymbols_dua;
    break;
  case 'dua_CM':
  case 'dua-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_dua_CM;
    break;
  case 'dyo':
    defaultSymbols = exports.RelativeDateTimeSymbols_dyo;
    break;
  case 'dyo_SN':
  case 'dyo-SN':
    defaultSymbols = exports.RelativeDateTimeSymbols_dyo_SN;
    break;
  case 'dz':
    defaultSymbols = exports.RelativeDateTimeSymbols_dz;
    break;
  case 'dz_BT':
  case 'dz-BT':
    defaultSymbols = exports.RelativeDateTimeSymbols_dz_BT;
    break;
  case 'ebu':
    defaultSymbols = exports.RelativeDateTimeSymbols_ebu;
    break;
  case 'ebu_KE':
  case 'ebu-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ebu_KE;
    break;
  case 'ee':
    defaultSymbols = exports.RelativeDateTimeSymbols_ee;
    break;
  case 'ee_GH':
  case 'ee-GH':
    defaultSymbols = exports.RelativeDateTimeSymbols_ee_GH;
    break;
  case 'ee_TG':
  case 'ee-TG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ee_TG;
    break;
  case 'el_CY':
  case 'el-CY':
    defaultSymbols = exports.RelativeDateTimeSymbols_el_CY;
    break;
  case 'el_GR':
  case 'el-GR':
    defaultSymbols = exports.RelativeDateTimeSymbols_el_GR;
    break;
  case 'en_001':
  case 'en-001':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_001;
    break;
  case 'en_150':
  case 'en-150':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_150;
    break;
  case 'en_AE':
  case 'en-AE':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_AE;
    break;
  case 'en_AG':
  case 'en-AG':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_AG;
    break;
  case 'en_AI':
  case 'en-AI':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_AI;
    break;
  case 'en_AS':
  case 'en-AS':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_AS;
    break;
  case 'en_AT':
  case 'en-AT':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_AT;
    break;
  case 'en_BB':
  case 'en-BB':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_BB;
    break;
  case 'en_BE':
  case 'en-BE':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_BE;
    break;
  case 'en_BI':
  case 'en-BI':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_BI;
    break;
  case 'en_BM':
  case 'en-BM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_BM;
    break;
  case 'en_BS':
  case 'en-BS':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_BS;
    break;
  case 'en_BW':
  case 'en-BW':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_BW;
    break;
  case 'en_BZ':
  case 'en-BZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_BZ;
    break;
  case 'en_CC':
  case 'en-CC':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_CC;
    break;
  case 'en_CH':
  case 'en-CH':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_CH;
    break;
  case 'en_CK':
  case 'en-CK':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_CK;
    break;
  case 'en_CM':
  case 'en-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_CM;
    break;
  case 'en_CX':
  case 'en-CX':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_CX;
    break;
  case 'en_CY':
  case 'en-CY':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_CY;
    break;
  case 'en_DE':
  case 'en-DE':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_DE;
    break;
  case 'en_DG':
  case 'en-DG':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_DG;
    break;
  case 'en_DK':
  case 'en-DK':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_DK;
    break;
  case 'en_DM':
  case 'en-DM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_DM;
    break;
  case 'en_ER':
  case 'en-ER':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_ER;
    break;
  case 'en_FI':
  case 'en-FI':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_FI;
    break;
  case 'en_FJ':
  case 'en-FJ':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_FJ;
    break;
  case 'en_FK':
  case 'en-FK':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_FK;
    break;
  case 'en_FM':
  case 'en-FM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_FM;
    break;
  case 'en_GD':
  case 'en-GD':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_GD;
    break;
  case 'en_GG':
  case 'en-GG':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_GG;
    break;
  case 'en_GH':
  case 'en-GH':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_GH;
    break;
  case 'en_GI':
  case 'en-GI':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_GI;
    break;
  case 'en_GM':
  case 'en-GM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_GM;
    break;
  case 'en_GU':
  case 'en-GU':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_GU;
    break;
  case 'en_GY':
  case 'en-GY':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_GY;
    break;
  case 'en_HK':
  case 'en-HK':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_HK;
    break;
  case 'en_IL':
  case 'en-IL':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_IL;
    break;
  case 'en_IM':
  case 'en-IM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_IM;
    break;
  case 'en_IO':
  case 'en-IO':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_IO;
    break;
  case 'en_JE':
  case 'en-JE':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_JE;
    break;
  case 'en_JM':
  case 'en-JM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_JM;
    break;
  case 'en_KE':
  case 'en-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_KE;
    break;
  case 'en_KI':
  case 'en-KI':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_KI;
    break;
  case 'en_KN':
  case 'en-KN':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_KN;
    break;
  case 'en_KY':
  case 'en-KY':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_KY;
    break;
  case 'en_LC':
  case 'en-LC':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_LC;
    break;
  case 'en_LR':
  case 'en-LR':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_LR;
    break;
  case 'en_LS':
  case 'en-LS':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_LS;
    break;
  case 'en_MG':
  case 'en-MG':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MG;
    break;
  case 'en_MH':
  case 'en-MH':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MH;
    break;
  case 'en_MO':
  case 'en-MO':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MO;
    break;
  case 'en_MP':
  case 'en-MP':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MP;
    break;
  case 'en_MS':
  case 'en-MS':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MS;
    break;
  case 'en_MT':
  case 'en-MT':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MT;
    break;
  case 'en_MU':
  case 'en-MU':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MU;
    break;
  case 'en_MV':
  case 'en-MV':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MV;
    break;
  case 'en_MW':
  case 'en-MW':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MW;
    break;
  case 'en_MY':
  case 'en-MY':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_MY;
    break;
  case 'en_NA':
  case 'en-NA':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_NA;
    break;
  case 'en_NF':
  case 'en-NF':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_NF;
    break;
  case 'en_NG':
  case 'en-NG':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_NG;
    break;
  case 'en_NL':
  case 'en-NL':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_NL;
    break;
  case 'en_NR':
  case 'en-NR':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_NR;
    break;
  case 'en_NU':
  case 'en-NU':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_NU;
    break;
  case 'en_NZ':
  case 'en-NZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_NZ;
    break;
  case 'en_PG':
  case 'en-PG':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_PG;
    break;
  case 'en_PH':
  case 'en-PH':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_PH;
    break;
  case 'en_PK':
  case 'en-PK':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_PK;
    break;
  case 'en_PN':
  case 'en-PN':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_PN;
    break;
  case 'en_PR':
  case 'en-PR':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_PR;
    break;
  case 'en_PW':
  case 'en-PW':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_PW;
    break;
  case 'en_RW':
  case 'en-RW':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_RW;
    break;
  case 'en_SB':
  case 'en-SB':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SB;
    break;
  case 'en_SC':
  case 'en-SC':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SC;
    break;
  case 'en_SD':
  case 'en-SD':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SD;
    break;
  case 'en_SE':
  case 'en-SE':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SE;
    break;
  case 'en_SH':
  case 'en-SH':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SH;
    break;
  case 'en_SI':
  case 'en-SI':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SI;
    break;
  case 'en_SL':
  case 'en-SL':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SL;
    break;
  case 'en_SS':
  case 'en-SS':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SS;
    break;
  case 'en_SX':
  case 'en-SX':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SX;
    break;
  case 'en_SZ':
  case 'en-SZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_SZ;
    break;
  case 'en_TC':
  case 'en-TC':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_TC;
    break;
  case 'en_TK':
  case 'en-TK':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_TK;
    break;
  case 'en_TO':
  case 'en-TO':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_TO;
    break;
  case 'en_TT':
  case 'en-TT':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_TT;
    break;
  case 'en_TV':
  case 'en-TV':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_TV;
    break;
  case 'en_TZ':
  case 'en-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_TZ;
    break;
  case 'en_UG':
  case 'en-UG':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_UG;
    break;
  case 'en_UM':
  case 'en-UM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_UM;
    break;
  case 'en_US_POSIX':
  case 'en-US-POSIX':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_US_POSIX;
    break;
  case 'en_VC':
  case 'en-VC':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_VC;
    break;
  case 'en_VG':
  case 'en-VG':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_VG;
    break;
  case 'en_VI':
  case 'en-VI':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_VI;
    break;
  case 'en_VU':
  case 'en-VU':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_VU;
    break;
  case 'en_WS':
  case 'en-WS':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_WS;
    break;
  case 'en_XA':
  case 'en-XA':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_XA;
    break;
  case 'en_ZM':
  case 'en-ZM':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_ZM;
    break;
  case 'en_ZW':
  case 'en-ZW':
    defaultSymbols = exports.RelativeDateTimeSymbols_en_ZW;
    break;
  case 'eo':
    defaultSymbols = exports.RelativeDateTimeSymbols_eo;
    break;
  case 'eo_001':
  case 'eo-001':
    defaultSymbols = exports.RelativeDateTimeSymbols_eo_001;
    break;
  case 'es_AR':
  case 'es-AR':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_AR;
    break;
  case 'es_BO':
  case 'es-BO':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_BO;
    break;
  case 'es_BR':
  case 'es-BR':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_BR;
    break;
  case 'es_BZ':
  case 'es-BZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_BZ;
    break;
  case 'es_CL':
  case 'es-CL':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_CL;
    break;
  case 'es_CO':
  case 'es-CO':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_CO;
    break;
  case 'es_CR':
  case 'es-CR':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_CR;
    break;
  case 'es_CU':
  case 'es-CU':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_CU;
    break;
  case 'es_DO':
  case 'es-DO':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_DO;
    break;
  case 'es_EA':
  case 'es-EA':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_EA;
    break;
  case 'es_EC':
  case 'es-EC':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_EC;
    break;
  case 'es_GQ':
  case 'es-GQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_GQ;
    break;
  case 'es_GT':
  case 'es-GT':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_GT;
    break;
  case 'es_HN':
  case 'es-HN':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_HN;
    break;
  case 'es_IC':
  case 'es-IC':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_IC;
    break;
  case 'es_NI':
  case 'es-NI':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_NI;
    break;
  case 'es_PA':
  case 'es-PA':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_PA;
    break;
  case 'es_PE':
  case 'es-PE':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_PE;
    break;
  case 'es_PH':
  case 'es-PH':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_PH;
    break;
  case 'es_PR':
  case 'es-PR':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_PR;
    break;
  case 'es_PY':
  case 'es-PY':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_PY;
    break;
  case 'es_SV':
  case 'es-SV':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_SV;
    break;
  case 'es_UY':
  case 'es-UY':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_UY;
    break;
  case 'es_VE':
  case 'es-VE':
    defaultSymbols = exports.RelativeDateTimeSymbols_es_VE;
    break;
  case 'et_EE':
  case 'et-EE':
    defaultSymbols = exports.RelativeDateTimeSymbols_et_EE;
    break;
  case 'eu_ES':
  case 'eu-ES':
    defaultSymbols = exports.RelativeDateTimeSymbols_eu_ES;
    break;
  case 'ewo':
    defaultSymbols = exports.RelativeDateTimeSymbols_ewo;
    break;
  case 'ewo_CM':
  case 'ewo-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_ewo_CM;
    break;
  case 'fa_AF':
  case 'fa-AF':
    defaultSymbols = exports.RelativeDateTimeSymbols_fa_AF;
    break;
  case 'fa_IR':
  case 'fa-IR':
    defaultSymbols = exports.RelativeDateTimeSymbols_fa_IR;
    break;
  case 'ff':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff;
    break;
  case 'ff_Adlm':
  case 'ff-Adlm':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm;
    break;
  case 'ff_Adlm_BF':
  case 'ff-Adlm-BF':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_BF;
    break;
  case 'ff_Adlm_CM':
  case 'ff-Adlm-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_CM;
    break;
  case 'ff_Adlm_GH':
  case 'ff-Adlm-GH':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_GH;
    break;
  case 'ff_Adlm_GM':
  case 'ff-Adlm-GM':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_GM;
    break;
  case 'ff_Adlm_GN':
  case 'ff-Adlm-GN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_GN;
    break;
  case 'ff_Adlm_GW':
  case 'ff-Adlm-GW':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_GW;
    break;
  case 'ff_Adlm_LR':
  case 'ff-Adlm-LR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_LR;
    break;
  case 'ff_Adlm_MR':
  case 'ff-Adlm-MR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_MR;
    break;
  case 'ff_Adlm_NE':
  case 'ff-Adlm-NE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_NE;
    break;
  case 'ff_Adlm_NG':
  case 'ff-Adlm-NG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_NG;
    break;
  case 'ff_Adlm_SL':
  case 'ff-Adlm-SL':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_SL;
    break;
  case 'ff_Adlm_SN':
  case 'ff-Adlm-SN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Adlm_SN;
    break;
  case 'ff_Latn':
  case 'ff-Latn':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn;
    break;
  case 'ff_Latn_BF':
  case 'ff-Latn-BF':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_BF;
    break;
  case 'ff_Latn_CM':
  case 'ff-Latn-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_CM;
    break;
  case 'ff_Latn_GH':
  case 'ff-Latn-GH':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_GH;
    break;
  case 'ff_Latn_GM':
  case 'ff-Latn-GM':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_GM;
    break;
  case 'ff_Latn_GN':
  case 'ff-Latn-GN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_GN;
    break;
  case 'ff_Latn_GW':
  case 'ff-Latn-GW':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_GW;
    break;
  case 'ff_Latn_LR':
  case 'ff-Latn-LR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_LR;
    break;
  case 'ff_Latn_MR':
  case 'ff-Latn-MR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_MR;
    break;
  case 'ff_Latn_NE':
  case 'ff-Latn-NE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_NE;
    break;
  case 'ff_Latn_NG':
  case 'ff-Latn-NG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_NG;
    break;
  case 'ff_Latn_SL':
  case 'ff-Latn-SL':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_SL;
    break;
  case 'ff_Latn_SN':
  case 'ff-Latn-SN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ff_Latn_SN;
    break;
  case 'fi_FI':
  case 'fi-FI':
    defaultSymbols = exports.RelativeDateTimeSymbols_fi_FI;
    break;
  case 'fil_PH':
  case 'fil-PH':
    defaultSymbols = exports.RelativeDateTimeSymbols_fil_PH;
    break;
  case 'fo':
    defaultSymbols = exports.RelativeDateTimeSymbols_fo;
    break;
  case 'fo_DK':
  case 'fo-DK':
    defaultSymbols = exports.RelativeDateTimeSymbols_fo_DK;
    break;
  case 'fo_FO':
  case 'fo-FO':
    defaultSymbols = exports.RelativeDateTimeSymbols_fo_FO;
    break;
  case 'fr_BE':
  case 'fr-BE':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_BE;
    break;
  case 'fr_BF':
  case 'fr-BF':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_BF;
    break;
  case 'fr_BI':
  case 'fr-BI':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_BI;
    break;
  case 'fr_BJ':
  case 'fr-BJ':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_BJ;
    break;
  case 'fr_BL':
  case 'fr-BL':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_BL;
    break;
  case 'fr_CD':
  case 'fr-CD':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_CD;
    break;
  case 'fr_CF':
  case 'fr-CF':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_CF;
    break;
  case 'fr_CG':
  case 'fr-CG':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_CG;
    break;
  case 'fr_CH':
  case 'fr-CH':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_CH;
    break;
  case 'fr_CI':
  case 'fr-CI':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_CI;
    break;
  case 'fr_CM':
  case 'fr-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_CM;
    break;
  case 'fr_DJ':
  case 'fr-DJ':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_DJ;
    break;
  case 'fr_DZ':
  case 'fr-DZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_DZ;
    break;
  case 'fr_FR':
  case 'fr-FR':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_FR;
    break;
  case 'fr_GA':
  case 'fr-GA':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_GA;
    break;
  case 'fr_GF':
  case 'fr-GF':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_GF;
    break;
  case 'fr_GN':
  case 'fr-GN':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_GN;
    break;
  case 'fr_GP':
  case 'fr-GP':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_GP;
    break;
  case 'fr_GQ':
  case 'fr-GQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_GQ;
    break;
  case 'fr_HT':
  case 'fr-HT':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_HT;
    break;
  case 'fr_KM':
  case 'fr-KM':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_KM;
    break;
  case 'fr_LU':
  case 'fr-LU':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_LU;
    break;
  case 'fr_MA':
  case 'fr-MA':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_MA;
    break;
  case 'fr_MC':
  case 'fr-MC':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_MC;
    break;
  case 'fr_MF':
  case 'fr-MF':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_MF;
    break;
  case 'fr_MG':
  case 'fr-MG':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_MG;
    break;
  case 'fr_ML':
  case 'fr-ML':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_ML;
    break;
  case 'fr_MQ':
  case 'fr-MQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_MQ;
    break;
  case 'fr_MR':
  case 'fr-MR':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_MR;
    break;
  case 'fr_MU':
  case 'fr-MU':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_MU;
    break;
  case 'fr_NC':
  case 'fr-NC':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_NC;
    break;
  case 'fr_NE':
  case 'fr-NE':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_NE;
    break;
  case 'fr_PF':
  case 'fr-PF':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_PF;
    break;
  case 'fr_PM':
  case 'fr-PM':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_PM;
    break;
  case 'fr_RE':
  case 'fr-RE':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_RE;
    break;
  case 'fr_RW':
  case 'fr-RW':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_RW;
    break;
  case 'fr_SC':
  case 'fr-SC':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_SC;
    break;
  case 'fr_SN':
  case 'fr-SN':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_SN;
    break;
  case 'fr_SY':
  case 'fr-SY':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_SY;
    break;
  case 'fr_TD':
  case 'fr-TD':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_TD;
    break;
  case 'fr_TG':
  case 'fr-TG':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_TG;
    break;
  case 'fr_TN':
  case 'fr-TN':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_TN;
    break;
  case 'fr_VU':
  case 'fr-VU':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_VU;
    break;
  case 'fr_WF':
  case 'fr-WF':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_WF;
    break;
  case 'fr_YT':
  case 'fr-YT':
    defaultSymbols = exports.RelativeDateTimeSymbols_fr_YT;
    break;
  case 'fur':
    defaultSymbols = exports.RelativeDateTimeSymbols_fur;
    break;
  case 'fur_IT':
  case 'fur-IT':
    defaultSymbols = exports.RelativeDateTimeSymbols_fur_IT;
    break;
  case 'fy':
    defaultSymbols = exports.RelativeDateTimeSymbols_fy;
    break;
  case 'fy_NL':
  case 'fy-NL':
    defaultSymbols = exports.RelativeDateTimeSymbols_fy_NL;
    break;
  case 'ga_GB':
  case 'ga-GB':
    defaultSymbols = exports.RelativeDateTimeSymbols_ga_GB;
    break;
  case 'ga_IE':
  case 'ga-IE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ga_IE;
    break;
  case 'gd':
    defaultSymbols = exports.RelativeDateTimeSymbols_gd;
    break;
  case 'gd_GB':
  case 'gd-GB':
    defaultSymbols = exports.RelativeDateTimeSymbols_gd_GB;
    break;
  case 'gl_ES':
  case 'gl-ES':
    defaultSymbols = exports.RelativeDateTimeSymbols_gl_ES;
    break;
  case 'gsw_CH':
  case 'gsw-CH':
    defaultSymbols = exports.RelativeDateTimeSymbols_gsw_CH;
    break;
  case 'gsw_FR':
  case 'gsw-FR':
    defaultSymbols = exports.RelativeDateTimeSymbols_gsw_FR;
    break;
  case 'gsw_LI':
  case 'gsw-LI':
    defaultSymbols = exports.RelativeDateTimeSymbols_gsw_LI;
    break;
  case 'gu_IN':
  case 'gu-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_gu_IN;
    break;
  case 'guz':
    defaultSymbols = exports.RelativeDateTimeSymbols_guz;
    break;
  case 'guz_KE':
  case 'guz-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_guz_KE;
    break;
  case 'gv':
    defaultSymbols = exports.RelativeDateTimeSymbols_gv;
    break;
  case 'gv_IM':
  case 'gv-IM':
    defaultSymbols = exports.RelativeDateTimeSymbols_gv_IM;
    break;
  case 'ha':
    defaultSymbols = exports.RelativeDateTimeSymbols_ha;
    break;
  case 'ha_GH':
  case 'ha-GH':
    defaultSymbols = exports.RelativeDateTimeSymbols_ha_GH;
    break;
  case 'ha_NE':
  case 'ha-NE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ha_NE;
    break;
  case 'ha_NG':
  case 'ha-NG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ha_NG;
    break;
  case 'haw_US':
  case 'haw-US':
    defaultSymbols = exports.RelativeDateTimeSymbols_haw_US;
    break;
  case 'he_IL':
  case 'he-IL':
    defaultSymbols = exports.RelativeDateTimeSymbols_he_IL;
    break;
  case 'hi_IN':
  case 'hi-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_hi_IN;
    break;
  case 'hi_Latn':
  case 'hi-Latn':
    defaultSymbols = exports.RelativeDateTimeSymbols_hi_Latn;
    break;
  case 'hi_Latn_IN':
  case 'hi-Latn-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_hi_Latn_IN;
    break;
  case 'hr_BA':
  case 'hr-BA':
    defaultSymbols = exports.RelativeDateTimeSymbols_hr_BA;
    break;
  case 'hr_HR':
  case 'hr-HR':
    defaultSymbols = exports.RelativeDateTimeSymbols_hr_HR;
    break;
  case 'hsb':
    defaultSymbols = exports.RelativeDateTimeSymbols_hsb;
    break;
  case 'hsb_DE':
  case 'hsb-DE':
    defaultSymbols = exports.RelativeDateTimeSymbols_hsb_DE;
    break;
  case 'hu_HU':
  case 'hu-HU':
    defaultSymbols = exports.RelativeDateTimeSymbols_hu_HU;
    break;
  case 'hy_AM':
  case 'hy-AM':
    defaultSymbols = exports.RelativeDateTimeSymbols_hy_AM;
    break;
  case 'ia':
    defaultSymbols = exports.RelativeDateTimeSymbols_ia;
    break;
  case 'ia_001':
  case 'ia-001':
    defaultSymbols = exports.RelativeDateTimeSymbols_ia_001;
    break;
  case 'id_ID':
  case 'id-ID':
    defaultSymbols = exports.RelativeDateTimeSymbols_id_ID;
    break;
  case 'ig':
    defaultSymbols = exports.RelativeDateTimeSymbols_ig;
    break;
  case 'ig_NG':
  case 'ig-NG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ig_NG;
    break;
  case 'ii':
    defaultSymbols = exports.RelativeDateTimeSymbols_ii;
    break;
  case 'ii_CN':
  case 'ii-CN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ii_CN;
    break;
  case 'is_IS':
  case 'is-IS':
    defaultSymbols = exports.RelativeDateTimeSymbols_is_IS;
    break;
  case 'it_CH':
  case 'it-CH':
    defaultSymbols = exports.RelativeDateTimeSymbols_it_CH;
    break;
  case 'it_IT':
  case 'it-IT':
    defaultSymbols = exports.RelativeDateTimeSymbols_it_IT;
    break;
  case 'it_SM':
  case 'it-SM':
    defaultSymbols = exports.RelativeDateTimeSymbols_it_SM;
    break;
  case 'it_VA':
  case 'it-VA':
    defaultSymbols = exports.RelativeDateTimeSymbols_it_VA;
    break;
  case 'ja_JP':
  case 'ja-JP':
    defaultSymbols = exports.RelativeDateTimeSymbols_ja_JP;
    break;
  case 'jgo':
    defaultSymbols = exports.RelativeDateTimeSymbols_jgo;
    break;
  case 'jgo_CM':
  case 'jgo-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_jgo_CM;
    break;
  case 'jmc':
    defaultSymbols = exports.RelativeDateTimeSymbols_jmc;
    break;
  case 'jmc_TZ':
  case 'jmc-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_jmc_TZ;
    break;
  case 'jv':
    defaultSymbols = exports.RelativeDateTimeSymbols_jv;
    break;
  case 'jv_ID':
  case 'jv-ID':
    defaultSymbols = exports.RelativeDateTimeSymbols_jv_ID;
    break;
  case 'ka_GE':
  case 'ka-GE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ka_GE;
    break;
  case 'kab':
    defaultSymbols = exports.RelativeDateTimeSymbols_kab;
    break;
  case 'kab_DZ':
  case 'kab-DZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_kab_DZ;
    break;
  case 'kam':
    defaultSymbols = exports.RelativeDateTimeSymbols_kam;
    break;
  case 'kam_KE':
  case 'kam-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_kam_KE;
    break;
  case 'kde':
    defaultSymbols = exports.RelativeDateTimeSymbols_kde;
    break;
  case 'kde_TZ':
  case 'kde-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_kde_TZ;
    break;
  case 'kea':
    defaultSymbols = exports.RelativeDateTimeSymbols_kea;
    break;
  case 'kea_CV':
  case 'kea-CV':
    defaultSymbols = exports.RelativeDateTimeSymbols_kea_CV;
    break;
  case 'kgp':
    defaultSymbols = exports.RelativeDateTimeSymbols_kgp;
    break;
  case 'kgp_BR':
  case 'kgp-BR':
    defaultSymbols = exports.RelativeDateTimeSymbols_kgp_BR;
    break;
  case 'khq':
    defaultSymbols = exports.RelativeDateTimeSymbols_khq;
    break;
  case 'khq_ML':
  case 'khq-ML':
    defaultSymbols = exports.RelativeDateTimeSymbols_khq_ML;
    break;
  case 'ki':
    defaultSymbols = exports.RelativeDateTimeSymbols_ki;
    break;
  case 'ki_KE':
  case 'ki-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ki_KE;
    break;
  case 'kk_KZ':
  case 'kk-KZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_kk_KZ;
    break;
  case 'kkj':
    defaultSymbols = exports.RelativeDateTimeSymbols_kkj;
    break;
  case 'kkj_CM':
  case 'kkj-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_kkj_CM;
    break;
  case 'kl':
    defaultSymbols = exports.RelativeDateTimeSymbols_kl;
    break;
  case 'kl_GL':
  case 'kl-GL':
    defaultSymbols = exports.RelativeDateTimeSymbols_kl_GL;
    break;
  case 'kln':
    defaultSymbols = exports.RelativeDateTimeSymbols_kln;
    break;
  case 'kln_KE':
  case 'kln-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_kln_KE;
    break;
  case 'km_KH':
  case 'km-KH':
    defaultSymbols = exports.RelativeDateTimeSymbols_km_KH;
    break;
  case 'kn_IN':
  case 'kn-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_kn_IN;
    break;
  case 'ko_KP':
  case 'ko-KP':
    defaultSymbols = exports.RelativeDateTimeSymbols_ko_KP;
    break;
  case 'ko_KR':
  case 'ko-KR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ko_KR;
    break;
  case 'kok':
    defaultSymbols = exports.RelativeDateTimeSymbols_kok;
    break;
  case 'kok_IN':
  case 'kok-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_kok_IN;
    break;
  case 'ks':
    defaultSymbols = exports.RelativeDateTimeSymbols_ks;
    break;
  case 'ks_Arab':
  case 'ks-Arab':
    defaultSymbols = exports.RelativeDateTimeSymbols_ks_Arab;
    break;
  case 'ks_Arab_IN':
  case 'ks-Arab-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ks_Arab_IN;
    break;
  case 'ks_Deva':
  case 'ks-Deva':
    defaultSymbols = exports.RelativeDateTimeSymbols_ks_Deva;
    break;
  case 'ks_Deva_IN':
  case 'ks-Deva-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ks_Deva_IN;
    break;
  case 'ksb':
    defaultSymbols = exports.RelativeDateTimeSymbols_ksb;
    break;
  case 'ksb_TZ':
  case 'ksb-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_ksb_TZ;
    break;
  case 'ksf':
    defaultSymbols = exports.RelativeDateTimeSymbols_ksf;
    break;
  case 'ksf_CM':
  case 'ksf-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_ksf_CM;
    break;
  case 'ksh':
    defaultSymbols = exports.RelativeDateTimeSymbols_ksh;
    break;
  case 'ksh_DE':
  case 'ksh-DE':
    defaultSymbols = exports.RelativeDateTimeSymbols_ksh_DE;
    break;
  case 'ku':
    defaultSymbols = exports.RelativeDateTimeSymbols_ku;
    break;
  case 'ku_TR':
  case 'ku-TR':
    defaultSymbols = exports.RelativeDateTimeSymbols_ku_TR;
    break;
  case 'kw':
    defaultSymbols = exports.RelativeDateTimeSymbols_kw;
    break;
  case 'kw_GB':
  case 'kw-GB':
    defaultSymbols = exports.RelativeDateTimeSymbols_kw_GB;
    break;
  case 'ky_KG':
  case 'ky-KG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ky_KG;
    break;
  case 'lag':
    defaultSymbols = exports.RelativeDateTimeSymbols_lag;
    break;
  case 'lag_TZ':
  case 'lag-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_lag_TZ;
    break;
  case 'lb':
    defaultSymbols = exports.RelativeDateTimeSymbols_lb;
    break;
  case 'lb_LU':
  case 'lb-LU':
    defaultSymbols = exports.RelativeDateTimeSymbols_lb_LU;
    break;
  case 'lg':
    defaultSymbols = exports.RelativeDateTimeSymbols_lg;
    break;
  case 'lg_UG':
  case 'lg-UG':
    defaultSymbols = exports.RelativeDateTimeSymbols_lg_UG;
    break;
  case 'lkt':
    defaultSymbols = exports.RelativeDateTimeSymbols_lkt;
    break;
  case 'lkt_US':
  case 'lkt-US':
    defaultSymbols = exports.RelativeDateTimeSymbols_lkt_US;
    break;
  case 'ln_AO':
  case 'ln-AO':
    defaultSymbols = exports.RelativeDateTimeSymbols_ln_AO;
    break;
  case 'ln_CD':
  case 'ln-CD':
    defaultSymbols = exports.RelativeDateTimeSymbols_ln_CD;
    break;
  case 'ln_CF':
  case 'ln-CF':
    defaultSymbols = exports.RelativeDateTimeSymbols_ln_CF;
    break;
  case 'ln_CG':
  case 'ln-CG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ln_CG;
    break;
  case 'lo_LA':
  case 'lo-LA':
    defaultSymbols = exports.RelativeDateTimeSymbols_lo_LA;
    break;
  case 'lrc':
    defaultSymbols = exports.RelativeDateTimeSymbols_lrc;
    break;
  case 'lrc_IQ':
  case 'lrc-IQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_lrc_IQ;
    break;
  case 'lrc_IR':
  case 'lrc-IR':
    defaultSymbols = exports.RelativeDateTimeSymbols_lrc_IR;
    break;
  case 'lt_LT':
  case 'lt-LT':
    defaultSymbols = exports.RelativeDateTimeSymbols_lt_LT;
    break;
  case 'lu':
    defaultSymbols = exports.RelativeDateTimeSymbols_lu;
    break;
  case 'lu_CD':
  case 'lu-CD':
    defaultSymbols = exports.RelativeDateTimeSymbols_lu_CD;
    break;
  case 'luo':
    defaultSymbols = exports.RelativeDateTimeSymbols_luo;
    break;
  case 'luo_KE':
  case 'luo-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_luo_KE;
    break;
  case 'luy':
    defaultSymbols = exports.RelativeDateTimeSymbols_luy;
    break;
  case 'luy_KE':
  case 'luy-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_luy_KE;
    break;
  case 'lv_LV':
  case 'lv-LV':
    defaultSymbols = exports.RelativeDateTimeSymbols_lv_LV;
    break;
  case 'mai':
    defaultSymbols = exports.RelativeDateTimeSymbols_mai;
    break;
  case 'mai_IN':
  case 'mai-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_mai_IN;
    break;
  case 'mas':
    defaultSymbols = exports.RelativeDateTimeSymbols_mas;
    break;
  case 'mas_KE':
  case 'mas-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_mas_KE;
    break;
  case 'mas_TZ':
  case 'mas-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_mas_TZ;
    break;
  case 'mer':
    defaultSymbols = exports.RelativeDateTimeSymbols_mer;
    break;
  case 'mer_KE':
  case 'mer-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_mer_KE;
    break;
  case 'mfe':
    defaultSymbols = exports.RelativeDateTimeSymbols_mfe;
    break;
  case 'mfe_MU':
  case 'mfe-MU':
    defaultSymbols = exports.RelativeDateTimeSymbols_mfe_MU;
    break;
  case 'mg':
    defaultSymbols = exports.RelativeDateTimeSymbols_mg;
    break;
  case 'mg_MG':
  case 'mg-MG':
    defaultSymbols = exports.RelativeDateTimeSymbols_mg_MG;
    break;
  case 'mgh':
    defaultSymbols = exports.RelativeDateTimeSymbols_mgh;
    break;
  case 'mgh_MZ':
  case 'mgh-MZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_mgh_MZ;
    break;
  case 'mgo':
    defaultSymbols = exports.RelativeDateTimeSymbols_mgo;
    break;
  case 'mgo_CM':
  case 'mgo-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_mgo_CM;
    break;
  case 'mi':
    defaultSymbols = exports.RelativeDateTimeSymbols_mi;
    break;
  case 'mi_NZ':
  case 'mi-NZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_mi_NZ;
    break;
  case 'mk_MK':
  case 'mk-MK':
    defaultSymbols = exports.RelativeDateTimeSymbols_mk_MK;
    break;
  case 'ml_IN':
  case 'ml-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ml_IN;
    break;
  case 'mn_MN':
  case 'mn-MN':
    defaultSymbols = exports.RelativeDateTimeSymbols_mn_MN;
    break;
  case 'mni':
    defaultSymbols = exports.RelativeDateTimeSymbols_mni;
    break;
  case 'mni_Beng':
  case 'mni-Beng':
    defaultSymbols = exports.RelativeDateTimeSymbols_mni_Beng;
    break;
  case 'mni_Beng_IN':
  case 'mni-Beng-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_mni_Beng_IN;
    break;
  case 'mr_IN':
  case 'mr-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_mr_IN;
    break;
  case 'ms_BN':
  case 'ms-BN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ms_BN;
    break;
  case 'ms_ID':
  case 'ms-ID':
    defaultSymbols = exports.RelativeDateTimeSymbols_ms_ID;
    break;
  case 'ms_MY':
  case 'ms-MY':
    defaultSymbols = exports.RelativeDateTimeSymbols_ms_MY;
    break;
  case 'ms_SG':
  case 'ms-SG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ms_SG;
    break;
  case 'mt_MT':
  case 'mt-MT':
    defaultSymbols = exports.RelativeDateTimeSymbols_mt_MT;
    break;
  case 'mua':
    defaultSymbols = exports.RelativeDateTimeSymbols_mua;
    break;
  case 'mua_CM':
  case 'mua-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_mua_CM;
    break;
  case 'my_MM':
  case 'my-MM':
    defaultSymbols = exports.RelativeDateTimeSymbols_my_MM;
    break;
  case 'mzn':
    defaultSymbols = exports.RelativeDateTimeSymbols_mzn;
    break;
  case 'mzn_IR':
  case 'mzn-IR':
    defaultSymbols = exports.RelativeDateTimeSymbols_mzn_IR;
    break;
  case 'naq':
    defaultSymbols = exports.RelativeDateTimeSymbols_naq;
    break;
  case 'naq_NA':
  case 'naq-NA':
    defaultSymbols = exports.RelativeDateTimeSymbols_naq_NA;
    break;
  case 'nb_NO':
  case 'nb-NO':
    defaultSymbols = exports.RelativeDateTimeSymbols_nb_NO;
    break;
  case 'nb_SJ':
  case 'nb-SJ':
    defaultSymbols = exports.RelativeDateTimeSymbols_nb_SJ;
    break;
  case 'nd':
    defaultSymbols = exports.RelativeDateTimeSymbols_nd;
    break;
  case 'nd_ZW':
  case 'nd-ZW':
    defaultSymbols = exports.RelativeDateTimeSymbols_nd_ZW;
    break;
  case 'ne_IN':
  case 'ne-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ne_IN;
    break;
  case 'ne_NP':
  case 'ne-NP':
    defaultSymbols = exports.RelativeDateTimeSymbols_ne_NP;
    break;
  case 'nl_AW':
  case 'nl-AW':
    defaultSymbols = exports.RelativeDateTimeSymbols_nl_AW;
    break;
  case 'nl_BE':
  case 'nl-BE':
    defaultSymbols = exports.RelativeDateTimeSymbols_nl_BE;
    break;
  case 'nl_BQ':
  case 'nl-BQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_nl_BQ;
    break;
  case 'nl_CW':
  case 'nl-CW':
    defaultSymbols = exports.RelativeDateTimeSymbols_nl_CW;
    break;
  case 'nl_NL':
  case 'nl-NL':
    defaultSymbols = exports.RelativeDateTimeSymbols_nl_NL;
    break;
  case 'nl_SR':
  case 'nl-SR':
    defaultSymbols = exports.RelativeDateTimeSymbols_nl_SR;
    break;
  case 'nl_SX':
  case 'nl-SX':
    defaultSymbols = exports.RelativeDateTimeSymbols_nl_SX;
    break;
  case 'nmg':
    defaultSymbols = exports.RelativeDateTimeSymbols_nmg;
    break;
  case 'nmg_CM':
  case 'nmg-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_nmg_CM;
    break;
  case 'nn':
    defaultSymbols = exports.RelativeDateTimeSymbols_nn;
    break;
  case 'nn_NO':
  case 'nn-NO':
    defaultSymbols = exports.RelativeDateTimeSymbols_nn_NO;
    break;
  case 'nnh':
    defaultSymbols = exports.RelativeDateTimeSymbols_nnh;
    break;
  case 'nnh_CM':
  case 'nnh-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_nnh_CM;
    break;
  case 'nus':
    defaultSymbols = exports.RelativeDateTimeSymbols_nus;
    break;
  case 'nus_SS':
  case 'nus-SS':
    defaultSymbols = exports.RelativeDateTimeSymbols_nus_SS;
    break;
  case 'nyn':
    defaultSymbols = exports.RelativeDateTimeSymbols_nyn;
    break;
  case 'nyn_UG':
  case 'nyn-UG':
    defaultSymbols = exports.RelativeDateTimeSymbols_nyn_UG;
    break;
  case 'om':
    defaultSymbols = exports.RelativeDateTimeSymbols_om;
    break;
  case 'om_ET':
  case 'om-ET':
    defaultSymbols = exports.RelativeDateTimeSymbols_om_ET;
    break;
  case 'om_KE':
  case 'om-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_om_KE;
    break;
  case 'or_IN':
  case 'or-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_or_IN;
    break;
  case 'os':
    defaultSymbols = exports.RelativeDateTimeSymbols_os;
    break;
  case 'os_GE':
  case 'os-GE':
    defaultSymbols = exports.RelativeDateTimeSymbols_os_GE;
    break;
  case 'os_RU':
  case 'os-RU':
    defaultSymbols = exports.RelativeDateTimeSymbols_os_RU;
    break;
  case 'pa_Arab':
  case 'pa-Arab':
    defaultSymbols = exports.RelativeDateTimeSymbols_pa_Arab;
    break;
  case 'pa_Arab_PK':
  case 'pa-Arab-PK':
    defaultSymbols = exports.RelativeDateTimeSymbols_pa_Arab_PK;
    break;
  case 'pa_Guru':
  case 'pa-Guru':
    defaultSymbols = exports.RelativeDateTimeSymbols_pa_Guru;
    break;
  case 'pa_Guru_IN':
  case 'pa-Guru-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_pa_Guru_IN;
    break;
  case 'pcm':
    defaultSymbols = exports.RelativeDateTimeSymbols_pcm;
    break;
  case 'pcm_NG':
  case 'pcm-NG':
    defaultSymbols = exports.RelativeDateTimeSymbols_pcm_NG;
    break;
  case 'pl_PL':
  case 'pl-PL':
    defaultSymbols = exports.RelativeDateTimeSymbols_pl_PL;
    break;
  case 'ps':
    defaultSymbols = exports.RelativeDateTimeSymbols_ps;
    break;
  case 'ps_AF':
  case 'ps-AF':
    defaultSymbols = exports.RelativeDateTimeSymbols_ps_AF;
    break;
  case 'ps_PK':
  case 'ps-PK':
    defaultSymbols = exports.RelativeDateTimeSymbols_ps_PK;
    break;
  case 'pt_AO':
  case 'pt-AO':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_AO;
    break;
  case 'pt_CH':
  case 'pt-CH':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_CH;
    break;
  case 'pt_CV':
  case 'pt-CV':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_CV;
    break;
  case 'pt_GQ':
  case 'pt-GQ':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_GQ;
    break;
  case 'pt_GW':
  case 'pt-GW':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_GW;
    break;
  case 'pt_LU':
  case 'pt-LU':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_LU;
    break;
  case 'pt_MO':
  case 'pt-MO':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_MO;
    break;
  case 'pt_MZ':
  case 'pt-MZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_MZ;
    break;
  case 'pt_ST':
  case 'pt-ST':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_ST;
    break;
  case 'pt_TL':
  case 'pt-TL':
    defaultSymbols = exports.RelativeDateTimeSymbols_pt_TL;
    break;
  case 'qu':
    defaultSymbols = exports.RelativeDateTimeSymbols_qu;
    break;
  case 'qu_BO':
  case 'qu-BO':
    defaultSymbols = exports.RelativeDateTimeSymbols_qu_BO;
    break;
  case 'qu_EC':
  case 'qu-EC':
    defaultSymbols = exports.RelativeDateTimeSymbols_qu_EC;
    break;
  case 'qu_PE':
  case 'qu-PE':
    defaultSymbols = exports.RelativeDateTimeSymbols_qu_PE;
    break;
  case 'raj':
    defaultSymbols = exports.RelativeDateTimeSymbols_raj;
    break;
  case 'raj_IN':
  case 'raj-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_raj_IN;
    break;
  case 'rm':
    defaultSymbols = exports.RelativeDateTimeSymbols_rm;
    break;
  case 'rm_CH':
  case 'rm-CH':
    defaultSymbols = exports.RelativeDateTimeSymbols_rm_CH;
    break;
  case 'rn':
    defaultSymbols = exports.RelativeDateTimeSymbols_rn;
    break;
  case 'rn_BI':
  case 'rn-BI':
    defaultSymbols = exports.RelativeDateTimeSymbols_rn_BI;
    break;
  case 'ro_MD':
  case 'ro-MD':
    defaultSymbols = exports.RelativeDateTimeSymbols_ro_MD;
    break;
  case 'ro_RO':
  case 'ro-RO':
    defaultSymbols = exports.RelativeDateTimeSymbols_ro_RO;
    break;
  case 'rof':
    defaultSymbols = exports.RelativeDateTimeSymbols_rof;
    break;
  case 'rof_TZ':
  case 'rof-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_rof_TZ;
    break;
  case 'ru_BY':
  case 'ru-BY':
    defaultSymbols = exports.RelativeDateTimeSymbols_ru_BY;
    break;
  case 'ru_KG':
  case 'ru-KG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ru_KG;
    break;
  case 'ru_KZ':
  case 'ru-KZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_ru_KZ;
    break;
  case 'ru_MD':
  case 'ru-MD':
    defaultSymbols = exports.RelativeDateTimeSymbols_ru_MD;
    break;
  case 'ru_RU':
  case 'ru-RU':
    defaultSymbols = exports.RelativeDateTimeSymbols_ru_RU;
    break;
  case 'ru_UA':
  case 'ru-UA':
    defaultSymbols = exports.RelativeDateTimeSymbols_ru_UA;
    break;
  case 'rw':
    defaultSymbols = exports.RelativeDateTimeSymbols_rw;
    break;
  case 'rw_RW':
  case 'rw-RW':
    defaultSymbols = exports.RelativeDateTimeSymbols_rw_RW;
    break;
  case 'rwk':
    defaultSymbols = exports.RelativeDateTimeSymbols_rwk;
    break;
  case 'rwk_TZ':
  case 'rwk-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_rwk_TZ;
    break;
  case 'sa':
    defaultSymbols = exports.RelativeDateTimeSymbols_sa;
    break;
  case 'sa_IN':
  case 'sa-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_sa_IN;
    break;
  case 'sah':
    defaultSymbols = exports.RelativeDateTimeSymbols_sah;
    break;
  case 'sah_RU':
  case 'sah-RU':
    defaultSymbols = exports.RelativeDateTimeSymbols_sah_RU;
    break;
  case 'saq':
    defaultSymbols = exports.RelativeDateTimeSymbols_saq;
    break;
  case 'saq_KE':
  case 'saq-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_saq_KE;
    break;
  case 'sat':
    defaultSymbols = exports.RelativeDateTimeSymbols_sat;
    break;
  case 'sat_Olck':
  case 'sat-Olck':
    defaultSymbols = exports.RelativeDateTimeSymbols_sat_Olck;
    break;
  case 'sat_Olck_IN':
  case 'sat-Olck-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_sat_Olck_IN;
    break;
  case 'sbp':
    defaultSymbols = exports.RelativeDateTimeSymbols_sbp;
    break;
  case 'sbp_TZ':
  case 'sbp-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_sbp_TZ;
    break;
  case 'sc':
    defaultSymbols = exports.RelativeDateTimeSymbols_sc;
    break;
  case 'sc_IT':
  case 'sc-IT':
    defaultSymbols = exports.RelativeDateTimeSymbols_sc_IT;
    break;
  case 'sd':
    defaultSymbols = exports.RelativeDateTimeSymbols_sd;
    break;
  case 'sd_Arab':
  case 'sd-Arab':
    defaultSymbols = exports.RelativeDateTimeSymbols_sd_Arab;
    break;
  case 'sd_Arab_PK':
  case 'sd-Arab-PK':
    defaultSymbols = exports.RelativeDateTimeSymbols_sd_Arab_PK;
    break;
  case 'sd_Deva':
  case 'sd-Deva':
    defaultSymbols = exports.RelativeDateTimeSymbols_sd_Deva;
    break;
  case 'sd_Deva_IN':
  case 'sd-Deva-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_sd_Deva_IN;
    break;
  case 'se':
    defaultSymbols = exports.RelativeDateTimeSymbols_se;
    break;
  case 'se_FI':
  case 'se-FI':
    defaultSymbols = exports.RelativeDateTimeSymbols_se_FI;
    break;
  case 'se_NO':
  case 'se-NO':
    defaultSymbols = exports.RelativeDateTimeSymbols_se_NO;
    break;
  case 'se_SE':
  case 'se-SE':
    defaultSymbols = exports.RelativeDateTimeSymbols_se_SE;
    break;
  case 'seh':
    defaultSymbols = exports.RelativeDateTimeSymbols_seh;
    break;
  case 'seh_MZ':
  case 'seh-MZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_seh_MZ;
    break;
  case 'ses':
    defaultSymbols = exports.RelativeDateTimeSymbols_ses;
    break;
  case 'ses_ML':
  case 'ses-ML':
    defaultSymbols = exports.RelativeDateTimeSymbols_ses_ML;
    break;
  case 'sg':
    defaultSymbols = exports.RelativeDateTimeSymbols_sg;
    break;
  case 'sg_CF':
  case 'sg-CF':
    defaultSymbols = exports.RelativeDateTimeSymbols_sg_CF;
    break;
  case 'shi':
    defaultSymbols = exports.RelativeDateTimeSymbols_shi;
    break;
  case 'shi_Latn':
  case 'shi-Latn':
    defaultSymbols = exports.RelativeDateTimeSymbols_shi_Latn;
    break;
  case 'shi_Latn_MA':
  case 'shi-Latn-MA':
    defaultSymbols = exports.RelativeDateTimeSymbols_shi_Latn_MA;
    break;
  case 'shi_Tfng':
  case 'shi-Tfng':
    defaultSymbols = exports.RelativeDateTimeSymbols_shi_Tfng;
    break;
  case 'shi_Tfng_MA':
  case 'shi-Tfng-MA':
    defaultSymbols = exports.RelativeDateTimeSymbols_shi_Tfng_MA;
    break;
  case 'si_LK':
  case 'si-LK':
    defaultSymbols = exports.RelativeDateTimeSymbols_si_LK;
    break;
  case 'sk_SK':
  case 'sk-SK':
    defaultSymbols = exports.RelativeDateTimeSymbols_sk_SK;
    break;
  case 'sl_SI':
  case 'sl-SI':
    defaultSymbols = exports.RelativeDateTimeSymbols_sl_SI;
    break;
  case 'smn':
    defaultSymbols = exports.RelativeDateTimeSymbols_smn;
    break;
  case 'smn_FI':
  case 'smn-FI':
    defaultSymbols = exports.RelativeDateTimeSymbols_smn_FI;
    break;
  case 'sn':
    defaultSymbols = exports.RelativeDateTimeSymbols_sn;
    break;
  case 'sn_ZW':
  case 'sn-ZW':
    defaultSymbols = exports.RelativeDateTimeSymbols_sn_ZW;
    break;
  case 'so':
    defaultSymbols = exports.RelativeDateTimeSymbols_so;
    break;
  case 'so_DJ':
  case 'so-DJ':
    defaultSymbols = exports.RelativeDateTimeSymbols_so_DJ;
    break;
  case 'so_ET':
  case 'so-ET':
    defaultSymbols = exports.RelativeDateTimeSymbols_so_ET;
    break;
  case 'so_KE':
  case 'so-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_so_KE;
    break;
  case 'so_SO':
  case 'so-SO':
    defaultSymbols = exports.RelativeDateTimeSymbols_so_SO;
    break;
  case 'sq_AL':
  case 'sq-AL':
    defaultSymbols = exports.RelativeDateTimeSymbols_sq_AL;
    break;
  case 'sq_MK':
  case 'sq-MK':
    defaultSymbols = exports.RelativeDateTimeSymbols_sq_MK;
    break;
  case 'sq_XK':
  case 'sq-XK':
    defaultSymbols = exports.RelativeDateTimeSymbols_sq_XK;
    break;
  case 'sr_Cyrl':
  case 'sr-Cyrl':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Cyrl;
    break;
  case 'sr_Cyrl_BA':
  case 'sr-Cyrl-BA':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Cyrl_BA;
    break;
  case 'sr_Cyrl_ME':
  case 'sr-Cyrl-ME':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Cyrl_ME;
    break;
  case 'sr_Cyrl_RS':
  case 'sr-Cyrl-RS':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Cyrl_RS;
    break;
  case 'sr_Cyrl_XK':
  case 'sr-Cyrl-XK':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Cyrl_XK;
    break;
  case 'sr_Latn_BA':
  case 'sr-Latn-BA':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Latn_BA;
    break;
  case 'sr_Latn_ME':
  case 'sr-Latn-ME':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Latn_ME;
    break;
  case 'sr_Latn_RS':
  case 'sr-Latn-RS':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Latn_RS;
    break;
  case 'sr_Latn_XK':
  case 'sr-Latn-XK':
    defaultSymbols = exports.RelativeDateTimeSymbols_sr_Latn_XK;
    break;
  case 'su':
    defaultSymbols = exports.RelativeDateTimeSymbols_su;
    break;
  case 'su_Latn':
  case 'su-Latn':
    defaultSymbols = exports.RelativeDateTimeSymbols_su_Latn;
    break;
  case 'su_Latn_ID':
  case 'su-Latn-ID':
    defaultSymbols = exports.RelativeDateTimeSymbols_su_Latn_ID;
    break;
  case 'sv_AX':
  case 'sv-AX':
    defaultSymbols = exports.RelativeDateTimeSymbols_sv_AX;
    break;
  case 'sv_FI':
  case 'sv-FI':
    defaultSymbols = exports.RelativeDateTimeSymbols_sv_FI;
    break;
  case 'sv_SE':
  case 'sv-SE':
    defaultSymbols = exports.RelativeDateTimeSymbols_sv_SE;
    break;
  case 'sw_CD':
  case 'sw-CD':
    defaultSymbols = exports.RelativeDateTimeSymbols_sw_CD;
    break;
  case 'sw_KE':
  case 'sw-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_sw_KE;
    break;
  case 'sw_TZ':
  case 'sw-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_sw_TZ;
    break;
  case 'sw_UG':
  case 'sw-UG':
    defaultSymbols = exports.RelativeDateTimeSymbols_sw_UG;
    break;
  case 'ta_IN':
  case 'ta-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ta_IN;
    break;
  case 'ta_LK':
  case 'ta-LK':
    defaultSymbols = exports.RelativeDateTimeSymbols_ta_LK;
    break;
  case 'ta_MY':
  case 'ta-MY':
    defaultSymbols = exports.RelativeDateTimeSymbols_ta_MY;
    break;
  case 'ta_SG':
  case 'ta-SG':
    defaultSymbols = exports.RelativeDateTimeSymbols_ta_SG;
    break;
  case 'te_IN':
  case 'te-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_te_IN;
    break;
  case 'teo':
    defaultSymbols = exports.RelativeDateTimeSymbols_teo;
    break;
  case 'teo_KE':
  case 'teo-KE':
    defaultSymbols = exports.RelativeDateTimeSymbols_teo_KE;
    break;
  case 'teo_UG':
  case 'teo-UG':
    defaultSymbols = exports.RelativeDateTimeSymbols_teo_UG;
    break;
  case 'tg':
    defaultSymbols = exports.RelativeDateTimeSymbols_tg;
    break;
  case 'tg_TJ':
  case 'tg-TJ':
    defaultSymbols = exports.RelativeDateTimeSymbols_tg_TJ;
    break;
  case 'th_TH':
  case 'th-TH':
    defaultSymbols = exports.RelativeDateTimeSymbols_th_TH;
    break;
  case 'ti':
    defaultSymbols = exports.RelativeDateTimeSymbols_ti;
    break;
  case 'ti_ER':
  case 'ti-ER':
    defaultSymbols = exports.RelativeDateTimeSymbols_ti_ER;
    break;
  case 'ti_ET':
  case 'ti-ET':
    defaultSymbols = exports.RelativeDateTimeSymbols_ti_ET;
    break;
  case 'tk':
    defaultSymbols = exports.RelativeDateTimeSymbols_tk;
    break;
  case 'tk_TM':
  case 'tk-TM':
    defaultSymbols = exports.RelativeDateTimeSymbols_tk_TM;
    break;
  case 'to':
    defaultSymbols = exports.RelativeDateTimeSymbols_to;
    break;
  case 'to_TO':
  case 'to-TO':
    defaultSymbols = exports.RelativeDateTimeSymbols_to_TO;
    break;
  case 'tr_CY':
  case 'tr-CY':
    defaultSymbols = exports.RelativeDateTimeSymbols_tr_CY;
    break;
  case 'tr_TR':
  case 'tr-TR':
    defaultSymbols = exports.RelativeDateTimeSymbols_tr_TR;
    break;
  case 'tt':
    defaultSymbols = exports.RelativeDateTimeSymbols_tt;
    break;
  case 'tt_RU':
  case 'tt-RU':
    defaultSymbols = exports.RelativeDateTimeSymbols_tt_RU;
    break;
  case 'twq':
    defaultSymbols = exports.RelativeDateTimeSymbols_twq;
    break;
  case 'twq_NE':
  case 'twq-NE':
    defaultSymbols = exports.RelativeDateTimeSymbols_twq_NE;
    break;
  case 'tzm':
    defaultSymbols = exports.RelativeDateTimeSymbols_tzm;
    break;
  case 'tzm_MA':
  case 'tzm-MA':
    defaultSymbols = exports.RelativeDateTimeSymbols_tzm_MA;
    break;
  case 'ug':
    defaultSymbols = exports.RelativeDateTimeSymbols_ug;
    break;
  case 'ug_CN':
  case 'ug-CN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ug_CN;
    break;
  case 'uk_UA':
  case 'uk-UA':
    defaultSymbols = exports.RelativeDateTimeSymbols_uk_UA;
    break;
  case 'ur_IN':
  case 'ur-IN':
    defaultSymbols = exports.RelativeDateTimeSymbols_ur_IN;
    break;
  case 'ur_PK':
  case 'ur-PK':
    defaultSymbols = exports.RelativeDateTimeSymbols_ur_PK;
    break;
  case 'uz_Arab':
  case 'uz-Arab':
    defaultSymbols = exports.RelativeDateTimeSymbols_uz_Arab;
    break;
  case 'uz_Arab_AF':
  case 'uz-Arab-AF':
    defaultSymbols = exports.RelativeDateTimeSymbols_uz_Arab_AF;
    break;
  case 'uz_Cyrl':
  case 'uz-Cyrl':
    defaultSymbols = exports.RelativeDateTimeSymbols_uz_Cyrl;
    break;
  case 'uz_Cyrl_UZ':
  case 'uz-Cyrl-UZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_uz_Cyrl_UZ;
    break;
  case 'uz_Latn':
  case 'uz-Latn':
    defaultSymbols = exports.RelativeDateTimeSymbols_uz_Latn;
    break;
  case 'uz_Latn_UZ':
  case 'uz-Latn-UZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_uz_Latn_UZ;
    break;
  case 'vai':
    defaultSymbols = exports.RelativeDateTimeSymbols_vai;
    break;
  case 'vai_Latn':
  case 'vai-Latn':
    defaultSymbols = exports.RelativeDateTimeSymbols_vai_Latn;
    break;
  case 'vai_Latn_LR':
  case 'vai-Latn-LR':
    defaultSymbols = exports.RelativeDateTimeSymbols_vai_Latn_LR;
    break;
  case 'vai_Vaii':
  case 'vai-Vaii':
    defaultSymbols = exports.RelativeDateTimeSymbols_vai_Vaii;
    break;
  case 'vai_Vaii_LR':
  case 'vai-Vaii-LR':
    defaultSymbols = exports.RelativeDateTimeSymbols_vai_Vaii_LR;
    break;
  case 'vi_VN':
  case 'vi-VN':
    defaultSymbols = exports.RelativeDateTimeSymbols_vi_VN;
    break;
  case 'vun':
    defaultSymbols = exports.RelativeDateTimeSymbols_vun;
    break;
  case 'vun_TZ':
  case 'vun-TZ':
    defaultSymbols = exports.RelativeDateTimeSymbols_vun_TZ;
    break;
  case 'wae':
    defaultSymbols = exports.RelativeDateTimeSymbols_wae;
    break;
  case 'wae_CH':
  case 'wae-CH':
    defaultSymbols = exports.RelativeDateTimeSymbols_wae_CH;
    break;
  case 'wo':
    defaultSymbols = exports.RelativeDateTimeSymbols_wo;
    break;
  case 'wo_SN':
  case 'wo-SN':
    defaultSymbols = exports.RelativeDateTimeSymbols_wo_SN;
    break;
  case 'xh':
    defaultSymbols = exports.RelativeDateTimeSymbols_xh;
    break;
  case 'xh_ZA':
  case 'xh-ZA':
    defaultSymbols = exports.RelativeDateTimeSymbols_xh_ZA;
    break;
  case 'xog':
    defaultSymbols = exports.RelativeDateTimeSymbols_xog;
    break;
  case 'xog_UG':
  case 'xog-UG':
    defaultSymbols = exports.RelativeDateTimeSymbols_xog_UG;
    break;
  case 'yav':
    defaultSymbols = exports.RelativeDateTimeSymbols_yav;
    break;
  case 'yav_CM':
  case 'yav-CM':
    defaultSymbols = exports.RelativeDateTimeSymbols_yav_CM;
    break;
  case 'yi':
    defaultSymbols = exports.RelativeDateTimeSymbols_yi;
    break;
  case 'yi_001':
  case 'yi-001':
    defaultSymbols = exports.RelativeDateTimeSymbols_yi_001;
    break;
  case 'yo':
    defaultSymbols = exports.RelativeDateTimeSymbols_yo;
    break;
  case 'yo_BJ':
  case 'yo-BJ':
    defaultSymbols = exports.RelativeDateTimeSymbols_yo_BJ;
    break;
  case 'yo_NG':
  case 'yo-NG':
    defaultSymbols = exports.RelativeDateTimeSymbols_yo_NG;
    break;
  case 'yrl':
    defaultSymbols = exports.RelativeDateTimeSymbols_yrl;
    break;
  case 'yrl_BR':
  case 'yrl-BR':
    defaultSymbols = exports.RelativeDateTimeSymbols_yrl_BR;
    break;
  case 'yrl_CO':
  case 'yrl-CO':
    defaultSymbols = exports.RelativeDateTimeSymbols_yrl_CO;
    break;
  case 'yrl_VE':
  case 'yrl-VE':
    defaultSymbols = exports.RelativeDateTimeSymbols_yrl_VE;
    break;
  case 'yue':
    defaultSymbols = exports.RelativeDateTimeSymbols_yue;
    break;
  case 'yue_Hans':
  case 'yue-Hans':
    defaultSymbols = exports.RelativeDateTimeSymbols_yue_Hans;
    break;
  case 'yue_Hans_CN':
  case 'yue-Hans-CN':
    defaultSymbols = exports.RelativeDateTimeSymbols_yue_Hans_CN;
    break;
  case 'yue_Hant':
  case 'yue-Hant':
    defaultSymbols = exports.RelativeDateTimeSymbols_yue_Hant;
    break;
  case 'yue_Hant_HK':
  case 'yue-Hant-HK':
    defaultSymbols = exports.RelativeDateTimeSymbols_yue_Hant_HK;
    break;
  case 'zgh':
    defaultSymbols = exports.RelativeDateTimeSymbols_zgh;
    break;
  case 'zgh_MA':
  case 'zgh-MA':
    defaultSymbols = exports.RelativeDateTimeSymbols_zgh_MA;
    break;
  case 'zh_Hans':
  case 'zh-Hans':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hans;
    break;
  case 'zh_Hans_CN':
  case 'zh-Hans-CN':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hans_CN;
    break;
  case 'zh_Hans_HK':
  case 'zh-Hans-HK':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hans_HK;
    break;
  case 'zh_Hans_MO':
  case 'zh-Hans-MO':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hans_MO;
    break;
  case 'zh_Hans_SG':
  case 'zh-Hans-SG':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hans_SG;
    break;
  case 'zh_Hant':
  case 'zh-Hant':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hant;
    break;
  case 'zh_Hant_HK':
  case 'zh-Hant-HK':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hant_HK;
    break;
  case 'zh_Hant_MO':
  case 'zh-Hant-MO':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hant_MO;
    break;
  case 'zh_Hant_TW':
  case 'zh-Hant-TW':
    defaultSymbols = exports.RelativeDateTimeSymbols_zh_Hant_TW;
    break;
  case 'zu_ZA':
  case 'zu-ZA':
    defaultSymbols = exports.RelativeDateTimeSymbols_zu_ZA;
    break;
}

if (defaultSymbols != null) {
  relativeDateTimeSymbols.setRelativeDateTimeSymbols(defaultSymbols);
}
