/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.foundation.text.l10n

import androidx.compose.foundation.text.ContextMenuStrings
import androidx.compose.foundation.text.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ml() = mapOf(
    ContextMenuStrings.SelectAll to "എല്ലാം തിരഞ്ഞെടുക്കുക",
    ContextMenuStrings.Cut to "മുറിക്കുക",
    ContextMenuStrings.Copy to "പകര്‍ത്തുക",
    ContextMenuStrings.Paste to "ഒട്ടിക്കുക",
    ContextMenuStrings.Autofill to "സ്വയമേവ പൂരിപ്പിക്കൽ",
)
