/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.foundation.text.l10n

import androidx.compose.foundation.text.ContextMenuStrings
import androidx.compose.foundation.text.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhCN() = mapOf(
    ContextMenuStrings.SelectAll to "全选",
    ContextMenuStrings.Cut to "剪切",
    ContextMenuStrings.Copy to "复制",
    ContextMenuStrings.Paste to "粘贴",
    ContextMenuStrings.Autofill to "自动填充",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhHK() = mapOf(
    ContextMenuStrings.SelectAll to "全部選取",
    ContextMenuStrings.Cut to "剪下",
    ContextMenuStrings.Copy to "複製",
    ContextMenuStrings.Paste to "貼上",
    ContextMenuStrings.Autofill to "自動填入",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhTW() = mapOf(
    ContextMenuStrings.SelectAll to "全部選取",
    ContextMenuStrings.Cut to "剪下",
    ContextMenuStrings.Copy to "複製",
    ContextMenuStrings.Paste to "貼上",
    ContextMenuStrings.Autofill to "自動填入",
)
