/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.az() = mapOf(
    Strings.NavigationMenu to "Naviqasiya menyusu",
    Strings.ExposedDropdownMenu to "Aşağı açılan menyu",
    Strings.CloseDrawer to "Naviqasiya menyusunu bağlayın",
    Strings.CloseSheet to "Səhifəni bağlayın",
    Strings.DefaultErrorMessage to "Yanlış daxiletmə",
    Strings.SliderRangeStart to "Sıranın başlanğıcı",
    Strings.SliderRangeEnd to "Sıranın sonu",
    Strings.ButtonGroupMoreOptions to "Digər seçimlər",
    Strings.Dialog to "Dialoq",
    Strings.MenuExpanded to "Genişləndirilb",
    Strings.MenuCollapsed to "Yığcamlaşdırılıb",
    Strings.ToggleDropdownMenu to "Aşağı açılan menyunu aktiv/deaktiv edin",
    Strings.SnackbarDismiss to "Rədd edin",
    Strings.SnackbarPaneTitle to "Xəbərdarlıq",
    Strings.SearchBarSearch to "Axtarış",
    Strings.SuggestionsAvailable to "Təkliflər aşağıdadır",
    Strings.DatePickerTitle to "Tarix seçin",
    Strings.DatePickerHeadline to "Seçilmiş tarix",
    Strings.DatePickerSwitchToYearSelection to "İl seçiminə keçin",
    Strings.DatePickerSwitchToDaySelection to "İl seçmək üçün sürüşdürün. Gün seçiminə qayıtmaq üçün toxunun",
    Strings.DatePickerSwitchToNextMonth to "Növbəti aya dəyişin",
    Strings.DatePickerSwitchToPreviousMonth to "Əvvəlki aya dəyişin",
    Strings.DatePickerNavigateToYearDescription to "Bu ilə keçin: %1\$s",
    Strings.DatePickerHeadlineDescription to "Cari seçim: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Yoxdur",
    Strings.DatePickerTodayDescription to "Bu gün",
    Strings.DatePickerYearPickerPaneTitle to "İl seçicisi görünür",
    Strings.DateInputTitle to "Tarix seçin",
    Strings.DateInputHeadline to "Daxil edilmiş tarix",
    Strings.DateInputLabel to "Tarix",
    Strings.DateInputHeadlineDescription to "Daxil edilmiş tarix: %1\$s",
    Strings.DateInputNoInputDescription to "Yoxdur",
    Strings.DateInputInvalidNotAllowed to "Tarixə icazə verilmir: %1\$s",
    Strings.DateInputInvalidForPattern to "Tarix gözlənilən modelə uyğun gəlmir: %1\$s",
    Strings.DateInputInvalidYearRange to "Tarix gözlənilən il aralığından kənardır: %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Təqvim daxiletmə rejiminə keçin",
    Strings.DatePickerSwitchToInputMode to "Mətn daxiletmə rejiminə keçin",
    Strings.DatePickerScrollToShowLaterYears to "Sonrakı illəri göstərmək üçün sürüşdürün",
    Strings.DatePickerScrollToShowEarlierYears to "Əvvəlki illəri göstərmək üçün sürüşdürün",
    Strings.DateRangePickerTitle to "Tarixlər seçin",
    Strings.DateRangePickerStartHeadline to "Başlama tarixi",
    Strings.DateRangePickerEndHeadline to "Bitmə tarixi",
    Strings.DateRangePickerScrollToShowNextMonth to "Növbəti ayı göstərmək üçün sürüşdürün",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Əvvəlki ayı göstərmək üçün sürüşdürün",
    Strings.DateRangePickerDayInRange to "Bu aralıqda",
    Strings.DateRangeInputTitle to "Tarixlər daxil edin",
    Strings.DateRangeInputInvalidRangeInput to "Yanlış tarix aralığı daxiletməsi",
    Strings.BottomSheetPaneTitle to "Aşağıdakı vərəq",
    Strings.BottomSheetDragHandleDescription to "Dəstəyi çəkin",
    Strings.BottomSheetPartialExpandDescription to "Aşağıdakı vərəqi yığcamlaşdırın",
    Strings.BottomSheetDismissDescription to "Aşağıdakı vərəqi rədd edin",
    Strings.BottomSheetExpandDescription to "Aşağıdakı vərəqi genişləndirin",
    Strings.FloatingToolbarCollapse to "Alətlər panelini yığcamlaşdırın",
    Strings.FloatingToolbarExpand to "Alətlər panelini genişləndirin",
    Strings.FloatingToolbarMoreOptions to "Digər seçimlər",
    Strings.TooltipPaneDescription to "Alət izahı",
    Strings.TooltipLongPressLabel to "Alət izahını göstərin",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM və ya PM seçin",
    Strings.TimePickerHourSelection to "Saat seçin",
    Strings.TimePickerMinuteSelection to "Dəqiqə seçin",
    Strings.TimePickerHourSuffix to "Saat: %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d saat",
    Strings.TimePickerMinuteSuffix to "%1\$d dəqiqə",
    Strings.TimePickerMinute to "Dəqiqə",
    Strings.TimePickerHour to "Saat",
    Strings.TimePickerMinuteTextField to "dəqiqəlik",
    Strings.TimePickerHourTextField to "saatlıq",
    Strings.TimePickerToggleKeyboard to "Mətn daxiletmə rejiminə keçin",
    Strings.TimePickerToggleTouch to "Saat rejiminə keçin",
    Strings.TimePickerDialogTitle to "Vaxt seçin",
    Strings.TimeInputDialogTitle to "Vaxt daxil edin",
    Strings.TimePickerMinuteError to "Dəqiqə 0-59 aralığında olmalıdır",
    Strings.TimePickerHourError to "Saat 1-12 aralığında olmalıdır",
    Strings.TimePicker24HourError to "Saat 0-23 aralığında olmalıdır",
    Strings.CloseRail to "Relsi bağlayın",
    Strings.WideNavigationRailPaneTitle to "Naviqasiya relsi",
)
