/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.de() = mapOf(
    Strings.NavigationMenu to "Navigationsmenü",
    Strings.ExposedDropdownMenu to "Drop-down-Menü",
    Strings.CloseDrawer to "Navigationsmenü schließen",
    Strings.CloseSheet to "Tabelle schließen",
    Strings.DefaultErrorMessage to "Ungültige Eingabe",
    Strings.SliderRangeStart to "Bereichsstart",
    Strings.SliderRangeEnd to "Bereichsende",
    Strings.ButtonGroupMoreOptions to "Weitere Optionen",
    Strings.Dialog to "Dialogfeld",
    Strings.MenuExpanded to "Maximiert",
    Strings.MenuCollapsed to "Minimiert",
    Strings.ToggleDropdownMenu to "Drop-down-Menü maximieren/minimieren",
    Strings.SnackbarDismiss to "Schließen",
    Strings.SnackbarPaneTitle to "Warnmeldung",
    Strings.SearchBarSearch to "Suche",
    Strings.SuggestionsAvailable to "Vorschläge unten",
    Strings.DatePickerTitle to "Datum auswählen",
    Strings.DatePickerHeadline to "Ausgewähltes Datum",
    Strings.DatePickerSwitchToYearSelection to "Zur Jahresauswahl wechseln",
    Strings.DatePickerSwitchToDaySelection to "Wischen, um ein Jahr auszuwählen, oder tippen, um zur Tagesauswahl zurückzukehren",
    Strings.DatePickerSwitchToNextMonth to "Zum nächsten Monat wechseln",
    Strings.DatePickerSwitchToPreviousMonth to "Zum vorherigen Monat wechseln",
    Strings.DatePickerNavigateToYearDescription to "Zum Jahr %1\$s wechseln",
    Strings.DatePickerHeadlineDescription to "Aktuelle Auswahl: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Kein Datum",
    Strings.DatePickerTodayDescription to "Heute",
    Strings.DatePickerYearPickerPaneTitle to "Jahresauswahl sichtbar",
    Strings.DateInputTitle to "Datum auswählen",
    Strings.DateInputHeadline to "Eingabedatum",
    Strings.DateInputLabel to "Datum",
    Strings.DateInputHeadlineDescription to "Eingabedatum: %1\$s",
    Strings.DateInputNoInputDescription to "Kein Datum",
    Strings.DateInputInvalidNotAllowed to "Unzulässiges Datum: %1\$s",
    Strings.DateInputInvalidForPattern to "Datum entspricht nicht dem erwarteten Format: %1\$s",
    Strings.DateInputInvalidYearRange to "Datum liegt außerhalb des erwarteten Jahresbereichs (%1\$s–%2\$s)",
    Strings.DatePickerSwitchToCalendarMode to "In den Kalendereingabemodus wechseln",
    Strings.DatePickerSwitchToInputMode to "In den Texteingabemodus wechseln",
    Strings.DatePickerScrollToShowLaterYears to "Zum Ansehen nachfolgender Jahre scrollen",
    Strings.DatePickerScrollToShowEarlierYears to "Zum Ansehen vorheriger Jahre scrollen",
    Strings.DateRangePickerTitle to "Daten auswählen",
    Strings.DateRangePickerStartHeadline to "Startdatum",
    Strings.DateRangePickerEndHeadline to "Enddatum",
    Strings.DateRangePickerScrollToShowNextMonth to "Zum Ansehen des nächsten Monats scrollen",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Zum Ansehen des vorherigen Monats scrollen",
    Strings.DateRangePickerDayInRange to "Im Zeitraum",
    Strings.DateRangeInputTitle to "Daten eingeben",
    Strings.DateRangeInputInvalidRangeInput to "Angegebener Zeitraum ungültig",
    Strings.BottomSheetPaneTitle to "Ansicht am unteren Rand",
    Strings.BottomSheetDragHandleDescription to "Ziehpunkt",
    Strings.BottomSheetPartialExpandDescription to "Ansicht am unteren Rand minimieren",
    Strings.BottomSheetDismissDescription to "Ansicht am unteren Rand schließen",
    Strings.BottomSheetExpandDescription to "Ansicht am unteren Rand maximieren",
    Strings.FloatingToolbarCollapse to "Symbolleiste minimieren",
    Strings.FloatingToolbarExpand to "Symbolleiste maximieren",
    Strings.FloatingToolbarMoreOptions to "Weitere Optionen",
    Strings.TooltipPaneDescription to "Kurzinfo",
    Strings.TooltipLongPressLabel to "Kurzinfo anzeigen",
    Strings.TimePickerPM to "Nachmittags",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Vormittags oder nachmittags auswählen",
    Strings.TimePickerHourSelection to "Stunde auswählen",
    Strings.TimePickerMinuteSelection to "Minuten auswählen",
    Strings.TimePickerHourSuffix to "%1\$d Uhr",
    Strings.TimePicker24HourSuffix to "%1\$d Std.",
    Strings.TimePickerMinuteSuffix to "%1\$d Minuten",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Stunde",
    Strings.TimePickerMinuteTextField to "für Minuten",
    Strings.TimePickerHourTextField to "für Stunde",
    Strings.TimePickerToggleKeyboard to "In den Texteingabemodus wechseln",
    Strings.TimePickerToggleTouch to "In den Uhrmodus wechseln",
    Strings.TimePickerDialogTitle to "Uhrzeit auswählen",
    Strings.TimeInputDialogTitle to "Uhrzeit eingeben",
    Strings.TimePickerMinuteError to "Zulässige Werte: 0–59",
    Strings.TimePickerHourError to "Zulässige Werte: 1–12",
    Strings.TimePicker24HourError to "Zulässige Werte: 0–23",
    Strings.CloseRail to "Streifen schließen",
    Strings.WideNavigationRailPaneTitle to "Navigationsstreifen",
)
