/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.el() = mapOf(
    Strings.NavigationMenu to "Μενού πλοήγησης",
    Strings.ExposedDropdownMenu to "Αναπτυσσόμενο μενού",
    Strings.CloseDrawer to "Κλείσιμο του μενού πλοήγησης",
    Strings.CloseSheet to "Κλείσιμο φύλλου",
    Strings.DefaultErrorMessage to "Μη έγκυρη καταχώριση",
    Strings.SliderRangeStart to "Αρχή εύρους",
    Strings.SliderRangeEnd to "Τέλος εύρους",
    Strings.ButtonGroupMoreOptions to "Περισσότερες επιλογές",
    Strings.Dialog to "Παράθυρο διαλόγου",
    Strings.MenuExpanded to "Αναπτυγμένο",
    Strings.MenuCollapsed to "Συμπτυγμένο",
    Strings.ToggleDropdownMenu to "Εναλλαγή αναπτυσσόμενου μενού",
    Strings.SnackbarDismiss to "Παράβλεψη",
    Strings.SnackbarPaneTitle to "Ειδοποίηση",
    Strings.SearchBarSearch to "Αναζήτηση",
    Strings.SuggestionsAvailable to "Προτάσεις παρακάτω",
    Strings.DatePickerTitle to "Επιλογή ημερομηνίας",
    Strings.DatePickerHeadline to "Επιλεγμένη ημερομηνία",
    Strings.DatePickerSwitchToYearSelection to "Εναλλαγή σε επιλογή έτους",
    Strings.DatePickerSwitchToDaySelection to "Σύρετε για να επιλέξετε ένα έτος ή πατήστε για να επιστρέψετε στην επιλογή ημέρας.",
    Strings.DatePickerSwitchToNextMonth to "Αλλαγή στον επόμενο μήνα",
    Strings.DatePickerSwitchToPreviousMonth to "Αλλαγή στον προηγούμενο μήνα",
    Strings.DatePickerNavigateToYearDescription to "Μετάβαση στο έτος %1\$s",
    Strings.DatePickerHeadlineDescription to "Τρέχουσα επιλογή: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Καμία",
    Strings.DatePickerTodayDescription to "Σήμερα",
    Strings.DatePickerYearPickerPaneTitle to "Το εργαλείο επιλογής έτους είναι ορατό",
    Strings.DateInputTitle to "Επιλογή ημερομηνίας",
    Strings.DateInputHeadline to "Εισαγωγή ημερομηνίας",
    Strings.DateInputLabel to "Ημερομηνία",
    Strings.DateInputHeadlineDescription to "Εισαγωγή ημερομηνίας: %1\$s",
    Strings.DateInputNoInputDescription to "Καμία",
    Strings.DateInputInvalidNotAllowed to "Η ημερομηνία δεν επιτρέπεται: %1\$s",
    Strings.DateInputInvalidForPattern to "Η ημερομηνία δεν αντιστοιχεί στο αναμενόμενο μοτίβο: %1\$s",
    Strings.DateInputInvalidYearRange to "Η ημερομηνία είναι εκτός του αναμενόμενου εύρους ετών %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Εναλλαγή στη λειτουργία εισαγωγής ημερολογίου",
    Strings.DatePickerSwitchToInputMode to "Εναλλαγή στη λειτουργία εισαγωγής κειμένου",
    Strings.DatePickerScrollToShowLaterYears to "Κάντε κύλιση για εμφάνιση επόμενων ετών",
    Strings.DatePickerScrollToShowEarlierYears to "Κάντε κύλιση για εμφάνιση προηγούμενων ετών",
    Strings.DateRangePickerTitle to "Επιλογή ημερομηνιών",
    Strings.DateRangePickerStartHeadline to "Ημερομηνία έναρξης",
    Strings.DateRangePickerEndHeadline to "Ημερομηνία λήξης",
    Strings.DateRangePickerScrollToShowNextMonth to "Κάντε κύλιση για εμφάνιση του επόμενου μήνα",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Κάντε κύλιση για εμφάνιση του προηγούμενου μήνα",
    Strings.DateRangePickerDayInRange to "Εντός εύρους",
    Strings.DateRangeInputTitle to "Εισαγωγή ημερομηνιών",
    Strings.DateRangeInputInvalidRangeInput to "Μη έγκυρη εισαγωγή εύρους ημερομηνιών",
    Strings.BottomSheetPaneTitle to "Φύλλο κάτω μέρους",
    Strings.BottomSheetDragHandleDescription to "Λαβή μεταφοράς",
    Strings.BottomSheetPartialExpandDescription to "Σύμπτυξη φύλλου κάτω μέρους",
    Strings.BottomSheetDismissDescription to "Παράβλεψη φύλλου κάτω μέρους",
    Strings.BottomSheetExpandDescription to "Ανάπτυξη φύλλου κάτω μέρους",
    Strings.FloatingToolbarCollapse to "Σύμπτυξη γραμμής εργαλείων",
    Strings.FloatingToolbarExpand to "Ανάπτυξη γραμμής εργαλείων",
    Strings.FloatingToolbarMoreOptions to "Περισσότερες επιλογές",
    Strings.TooltipPaneDescription to "Επεξήγηση εργαλείου",
    Strings.TooltipLongPressLabel to "Προβολή επεξήγησης εργαλείου",
    Strings.TimePickerPM to "μμ",
    Strings.TimePickerAM to "πμ",
    Strings.TimePickerPeriodToggle to "Επιλέξτε π.μ. ή μ.μ.",
    Strings.TimePickerHourSelection to "Επιλογή ώρας",
    Strings.TimePickerMinuteSelection to "Επιλογή λεπτών",
    Strings.TimePickerHourSuffix to "%1\$d η ώρα",
    Strings.TimePicker24HourSuffix to "Ώρα %1\$d",
    Strings.TimePickerMinuteSuffix to "%1\$d λεπτά",
    Strings.TimePickerMinute to "Λεπτό",
    Strings.TimePickerHour to "Ώρα",
    Strings.TimePickerMinuteTextField to "για λεπτά",
    Strings.TimePickerHourTextField to "για ώρα",
    Strings.TimePickerToggleKeyboard to "Εναλλαγή στη λειτουργία εισαγωγής κειμένου",
    Strings.TimePickerToggleTouch to "Εναλλαγή στη λειτουργία ρολογιού",
    Strings.TimePickerDialogTitle to "Επιλογή ώρας",
    Strings.TimeInputDialogTitle to "Εισαγωγή ώρας",
    Strings.TimePickerMinuteError to "Τα λεπτά πρέπει να είναι μεταξύ 0–59",
    Strings.TimePickerHourError to "Η ώρα πρέπει να είναι μεταξύ 1–12",
    Strings.TimePicker24HourError to "Η ώρα πρέπει να είναι μεταξύ 0–23",
    Strings.CloseRail to "Κλείσιμο στήλης",
    Strings.WideNavigationRailPaneTitle to "Στήλη πλοήγησης",
)
