/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.et() = mapOf(
    Strings.NavigationMenu to "Navigeerimismenüü",
    Strings.ExposedDropdownMenu to "Rippmenüü",
    Strings.CloseDrawer to "Sule navigeerimismenüü",
    Strings.CloseSheet to "Sule leht",
    Strings.DefaultErrorMessage to "Sobimatu sisend",
    Strings.SliderRangeStart to "Vahemiku algus",
    Strings.SliderRangeEnd to "Vahemiku lõpp",
    Strings.ButtonGroupMoreOptions to "Rohkem valikuid",
    Strings.Dialog to "Dialoog",
    Strings.MenuExpanded to "Laiendatud",
    Strings.MenuCollapsed to "Ahendatud",
    Strings.ToggleDropdownMenu to "Rippmenüü lülitamine",
    Strings.SnackbarDismiss to "Loobu",
    Strings.SnackbarPaneTitle to "Hoiatus",
    Strings.SearchBarSearch to "Otsing",
    Strings.SuggestionsAvailable to "Soovitused on allpool",
    Strings.DatePickerTitle to "Valige kuupäev",
    Strings.DatePickerHeadline to "Valitud kuupäev",
    Strings.DatePickerSwitchToYearSelection to "Lülitu aasta valimisele",
    Strings.DatePickerSwitchToDaySelection to "Pühkige aasta valimiseks või puudutage, et minna tagasi päeva valimise juurde",
    Strings.DatePickerSwitchToNextMonth to "Vaheta järgmisele kuule",
    Strings.DatePickerSwitchToPreviousMonth to "Vaheta eelmisele kuule",
    Strings.DatePickerNavigateToYearDescription to "Liigu aasta %1\$s juurde",
    Strings.DatePickerHeadlineDescription to "Praegune valik: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Puudub",
    Strings.DatePickerTodayDescription to "Täna",
    Strings.DatePickerYearPickerPaneTitle to "Aasta valija on nähtav",
    Strings.DateInputTitle to "Valige kuupäev",
    Strings.DateInputHeadline to "Sisestatud kuupäev",
    Strings.DateInputLabel to "Kuupäev",
    Strings.DateInputHeadlineDescription to "Sisestatud kuupäev: %1\$s",
    Strings.DateInputNoInputDescription to "Puudub",
    Strings.DateInputInvalidNotAllowed to "Kuupäev pole lubatud: %1\$s",
    Strings.DateInputInvalidForPattern to "Kuupäev ei ühti eeldatud mustriga: %1\$s",
    Strings.DateInputInvalidYearRange to "Kuupäev on väljaspool eeldatud aastavahemikku %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Lülitu kalendrisisestusrežiimile",
    Strings.DatePickerSwitchToInputMode to "Lülitu tekstisisestusrežiimile",
    Strings.DatePickerScrollToShowLaterYears to "Hilisemate aastate kuvamiseks kerige",
    Strings.DatePickerScrollToShowEarlierYears to "Varasemate aastate kuvamiseks kerige",
    Strings.DateRangePickerTitle to "Valige kuupäevad",
    Strings.DateRangePickerStartHeadline to "Alguskuupäev",
    Strings.DateRangePickerEndHeadline to "Lõppkuupäev",
    Strings.DateRangePickerScrollToShowNextMonth to "Järgmise kuu kuvamiseks kerige",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Eelmise kuu kuvamiseks kerige",
    Strings.DateRangePickerDayInRange to "Vahemikus",
    Strings.DateRangeInputTitle to "Sisestage kuupäevad",
    Strings.DateRangeInputInvalidRangeInput to "Sisestati sobimatu kuupäevavahemik",
    Strings.BottomSheetPaneTitle to "Alumine leht",
    Strings.BottomSheetDragHandleDescription to "Lohistamispide",
    Strings.BottomSheetPartialExpandDescription to "Alumise lehe ahendamine",
    Strings.BottomSheetDismissDescription to "Alumisest lehest loobumine",
    Strings.BottomSheetExpandDescription to "Alumise lehe laiendamine",
    Strings.FloatingToolbarCollapse to "Tööriistariba ahendamine",
    Strings.FloatingToolbarExpand to "Tööriistariba laiendamine",
    Strings.FloatingToolbarMoreOptions to "Rohkem valikuid",
    Strings.TooltipPaneDescription to "Kohtspikker",
    Strings.TooltipLongPressLabel to "Kuva kohtspikker",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Valige AM või PM",
    Strings.TimePickerHourSelection to "Tunni valimine",
    Strings.TimePickerMinuteSelection to "Minutite valimine",
    Strings.TimePickerHourSuffix to "%1\$d.00",
    Strings.TimePicker24HourSuffix to "%1\$d tundi",
    Strings.TimePickerMinuteSuffix to "%1\$d minutit",
    Strings.TimePickerMinute to "Minut",
    Strings.TimePickerHour to "Tunnid",
    Strings.TimePickerMinuteTextField to "minutite jaoks",
    Strings.TimePickerHourTextField to "tundide jaoks",
    Strings.TimePickerToggleKeyboard to "Lülitu tekstisisestusrežiimile",
    Strings.TimePickerToggleTouch to "Lülita kellarežiimile",
    Strings.TimePickerDialogTitle to "Valige aeg",
    Strings.TimeInputDialogTitle to "Sisestage aeg",
    Strings.TimePickerMinuteError to "Minutite vahemik on 0–59",
    Strings.TimePickerHourError to "Tundide vahemik on 1–12",
    Strings.TimePicker24HourError to "Tundide vahemik on 0–23",
    Strings.CloseRail to "Modaalraja sulgemine",
    Strings.WideNavigationRailPaneTitle to "Navigeerimisrada",
)
