/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.fa() = mapOf(
    Strings.NavigationMenu to "منوی پیمایش",
    Strings.ExposedDropdownMenu to "منوی کرکره‌ای",
    Strings.CloseDrawer to "بستن منوی پیمایش",
    Strings.CloseSheet to "بستن برگ",
    Strings.DefaultErrorMessage to "ورودی نامعتبر",
    Strings.SliderRangeStart to "شروع محدوده",
    Strings.SliderRangeEnd to "پایان محدوده",
    Strings.ButtonGroupMoreOptions to "گزینه‌های بیشتر",
    Strings.Dialog to "کادر گفتگو",
    Strings.MenuExpanded to "ازهم باز شد",
    Strings.MenuCollapsed to "جمع شد",
    Strings.ToggleDropdownMenu to "جمع کردن/ ازهم باز کردن منوِ کرکره‌ای",
    Strings.SnackbarDismiss to "بستن",
    Strings.SnackbarPaneTitle to "هشدار",
    Strings.SearchBarSearch to "جستجو",
    Strings.SuggestionsAvailable to "پیشنهادهای زیر",
    Strings.DatePickerTitle to "انتخاب تاریخ",
    Strings.DatePickerHeadline to "تاریخ انتخابی",
    Strings.DatePickerSwitchToYearSelection to "رفتن به انتخاب سال",
    Strings.DatePickerSwitchToDaySelection to "برای انتخاب سال، تند بکشید یا برای برگشتن به انتخاب روز، تک‌ضرب بزنید",
    Strings.DatePickerSwitchToNextMonth to "تغییر به ماه بعدی",
    Strings.DatePickerSwitchToPreviousMonth to "تغییر به ماه قبلی",
    Strings.DatePickerNavigateToYearDescription to "‏پیمایش به سال %1\$s",
    Strings.DatePickerHeadlineDescription to "‏انتخاب فعلی: %1\$s",
    Strings.DatePickerNoSelectionDescription to "هیچ‌کدام",
    Strings.DatePickerTodayDescription to "امروز",
    Strings.DatePickerYearPickerPaneTitle to "انتخاب‌گر سال نمایان است",
    Strings.DateInputTitle to "انتخاب تاریخ",
    Strings.DateInputHeadline to "تاریخ واردشده",
    Strings.DateInputLabel to "تاریخ",
    Strings.DateInputHeadlineDescription to "‏تاریخ واردشده: %1\$s",
    Strings.DateInputNoInputDescription to "هیچ‌کدام",
    Strings.DateInputInvalidNotAllowed to "‏تاریخ مجاز نیست: %1\$s",
    Strings.DateInputInvalidForPattern to "‏تاریخ با الگوی موردانتظار مطابقت ندارد: %1\$s",
    Strings.DateInputInvalidYearRange to "‏تاریخ خارج از محدوده سال %1\$s تا %2\$s است",
    Strings.DatePickerSwitchToCalendarMode to "تعویض به حالت ورودی تقویم",
    Strings.DatePickerSwitchToInputMode to "رفتن به حالت ورودی نوشتاری",
    Strings.DatePickerScrollToShowLaterYears to "برای نمایش سال‌های بعد پیمایش کنید",
    Strings.DatePickerScrollToShowEarlierYears to "برای نمایش سال‌های قبل پیمایش کنید",
    Strings.DateRangePickerTitle to "تاریخ‌ها را انتخاب کنید",
    Strings.DateRangePickerStartHeadline to "تاریخ شروع",
    Strings.DateRangePickerEndHeadline to "تاریخ پایان",
    Strings.DateRangePickerScrollToShowNextMonth to "برای نمایش ماه بعد پیمایش کنید",
    Strings.DateRangePickerScrollToShowPreviousMonth to "برای نمایش ماه قبل پیمایش کنید",
    Strings.DateRangePickerDayInRange to "در محدوده",
    Strings.DateRangeInputTitle to "تاریخ‌ها را وارد کنید",
    Strings.DateRangeInputInvalidRangeInput to "محدوده تاریخ واردشده نامعتبر است",
    Strings.BottomSheetPaneTitle to "برگ زیرین",
    Strings.BottomSheetDragHandleDescription to "دستگیره کشاندن",
    Strings.BottomSheetPartialExpandDescription to "جمع کردن برگ زیرین",
    Strings.BottomSheetDismissDescription to "بستن برگ زیرین",
    Strings.BottomSheetExpandDescription to "ازهم باز کردن برگ زیرین",
    Strings.FloatingToolbarCollapse to "جمع کردن نوارابزار",
    Strings.FloatingToolbarExpand to "ازهم بازکردن نوارابزار",
    Strings.FloatingToolbarMoreOptions to "گزینه‌های بیشتر",
    Strings.TooltipPaneDescription to "نکته‌ابزار",
    Strings.TooltipLongPressLabel to "نمایش نکته‌ابزار",
    Strings.TimePickerPM to "ب.ظ.",
    Strings.TimePickerAM to "ق.ظ.",
    Strings.TimePickerPeriodToggle to "انتخاب ق.ظ. یا ب.ظ.",
    Strings.TimePickerHourSelection to "انتخاب ساعت",
    Strings.TimePickerMinuteSelection to "انتخاب دقیقه",
    Strings.TimePickerHourSuffix to "‏ساعت %1\$d",
    Strings.TimePicker24HourSuffix to "‏%1\$d ساعت",
    Strings.TimePickerMinuteSuffix to "‏%1\$d دقیقه",
    Strings.TimePickerMinute to "دقیقه",
    Strings.TimePickerHour to "ساعت",
    Strings.TimePickerMinuteTextField to "برای دقیقه",
    Strings.TimePickerHourTextField to "برای ساعت",
    Strings.TimePickerToggleKeyboard to "رفتن به حالت ورودی نوشتاری",
    Strings.TimePickerToggleTouch to "رفتن به حالت ساعت",
    Strings.TimePickerDialogTitle to "انتخاب زمان",
    Strings.TimeInputDialogTitle to "وارد کردن زمان",
    Strings.TimePickerMinuteError to "‏مقدار مجاز دقیقه: ۰‎–۵۹",
    Strings.TimePickerHourError to "‏مقدار مجاز ساعت: ۱‎–۱۲",
    Strings.TimePicker24HourError to "‏مقدار مجاز ساعت: ۰‎–۲۳",
    Strings.CloseRail to "بستن ریل",
    Strings.WideNavigationRailPaneTitle to "ریل پیمایش",
)
