/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.fi() = mapOf(
    Strings.NavigationMenu to "Navigointivalikko",
    Strings.ExposedDropdownMenu to "Avattava valikko",
    Strings.CloseDrawer to "Sulje navigointivalikko",
    Strings.CloseSheet to "Sulje taulukko",
    Strings.DefaultErrorMessage to "Virheellinen syöte",
    Strings.SliderRangeStart to "Alueen alku",
    Strings.SliderRangeEnd to "Alueen loppu",
    Strings.ButtonGroupMoreOptions to "Lisäasetukset",
    Strings.Dialog to "Valintaikkuna",
    Strings.MenuExpanded to "Laajennettu",
    Strings.MenuCollapsed to "Tiivistetty",
    Strings.ToggleDropdownMenu to "Laita avattava valikko päälle",
    Strings.SnackbarDismiss to "Ohita",
    Strings.SnackbarPaneTitle to "Ilmoitus",
    Strings.SearchBarSearch to "Hae",
    Strings.SuggestionsAvailable to "Ehdotuksia alla",
    Strings.DatePickerTitle to "Valitse päivämäärä",
    Strings.DatePickerHeadline to "Valittu päivämäärä",
    Strings.DatePickerSwitchToYearSelection to "Vaihda vuoden valintaan",
    Strings.DatePickerSwitchToDaySelection to "Valitse vuosi pyyhkäisemällä tai palaa päivän valintaan napauttamalla",
    Strings.DatePickerSwitchToNextMonth to "Vaihda seuraavaan kuukauteen",
    Strings.DatePickerSwitchToPreviousMonth to "Vaihda edelliseen kuukauteen",
    Strings.DatePickerNavigateToYearDescription to "Siirry vuoteen %1\$s",
    Strings.DatePickerHeadlineDescription to "Nykyinen valinta: %1\$s",
    Strings.DatePickerNoSelectionDescription to "–",
    Strings.DatePickerTodayDescription to "Tänään",
    Strings.DatePickerYearPickerPaneTitle to "Vuosivalitsin näkyvillä",
    Strings.DateInputTitle to "Valitse päivämäärä",
    Strings.DateInputHeadline to "Lisätty päivämäärä",
    Strings.DateInputLabel to "Päivämäärä",
    Strings.DateInputHeadlineDescription to "Lisätty päivämäärä: %1\$s",
    Strings.DateInputNoInputDescription to "–",
    Strings.DateInputInvalidNotAllowed to "Päivämäärä ei sallittu: %1\$s",
    Strings.DateInputInvalidForPattern to "Päivämäärä ei vastaa odotettua mallia: %1\$s",
    Strings.DateInputInvalidYearRange to "Päivämäärä ei sisälly odotettuun vuosiaikaväliin: %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Vaihda syöttötavaksi kalenteri",
    Strings.DatePickerSwitchToInputMode to "Vaihda tekstinsyöttötilaan",
    Strings.DatePickerScrollToShowLaterYears to "Vieritä nähdäksesi myöhemmät vuodet",
    Strings.DatePickerScrollToShowEarlierYears to "Vieritä nähdäksesi aiemmat vuodet",
    Strings.DateRangePickerTitle to "Valitse päivämäärät",
    Strings.DateRangePickerStartHeadline to "Alkamispäivä",
    Strings.DateRangePickerEndHeadline to "Päättymispäivä",
    Strings.DateRangePickerScrollToShowNextMonth to "Vieritä nähdäksesi seuraavan kuukauden",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Vieritä nähdäksesi edellisen kuukauden",
    Strings.DateRangePickerDayInRange to "Valitulla välillä",
    Strings.DateRangeInputTitle to "Lisää päivämäärät",
    Strings.DateRangeInputInvalidRangeInput to "Virheellinen aikaväli",
    Strings.BottomSheetPaneTitle to "Alapaneeli",
    Strings.BottomSheetDragHandleDescription to "Vetokahva",
    Strings.BottomSheetPartialExpandDescription to "Tiivistä alapaneeli",
    Strings.BottomSheetDismissDescription to "Hylkää alapaneeli",
    Strings.BottomSheetExpandDescription to "Laajenna alapaneeli",
    Strings.FloatingToolbarCollapse to "Tiivistä työkalupalkki",
    Strings.FloatingToolbarExpand to "Laajenna työkalupalkki",
    Strings.FloatingToolbarMoreOptions to "Lisää vaihtoehtoja",
    Strings.TooltipPaneDescription to "Vihjeteksti",
    Strings.TooltipLongPressLabel to "Näytä vihjeteksti",
    Strings.TimePickerPM to "IP",
    Strings.TimePickerAM to "AP",
    Strings.TimePickerPeriodToggle to "Valitse AP tai IP",
    Strings.TimePickerHourSelection to "Valitse tunti",
    Strings.TimePickerMinuteSelection to "Valitse minuutit",
    Strings.TimePickerHourSuffix to "Kello %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d h",
    Strings.TimePickerMinuteSuffix to "%1\$d minuuttia",
    Strings.TimePickerMinute to "Minuutti",
    Strings.TimePickerHour to "Tunti",
    Strings.TimePickerMinuteTextField to "minuuttien osalta",
    Strings.TimePickerHourTextField to "tuntien osalta",
    Strings.TimePickerToggleKeyboard to "Vaihda tekstinsyöttötilaan",
    Strings.TimePickerToggleTouch to "Vaihda kellotilaan",
    Strings.TimePickerDialogTitle to "Valitse aika",
    Strings.TimeInputDialogTitle to "Lisää aika",
    Strings.TimePickerMinuteError to "Minuutin on oltava 0–59",
    Strings.TimePickerHourError to "Tunnin on oltava 1–12",
    Strings.TimePicker24HourError to "Tunnin on oltava 0–23",
    Strings.CloseRail to "Sulje palkki",
    Strings.WideNavigationRailPaneTitle to "Siirtymispalkki",
)
