/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.fr() = mapOf(
    Strings.NavigationMenu to "Menu de navigation",
    Strings.ExposedDropdownMenu to "Menu déroulant",
    Strings.CloseDrawer to "Fermer le menu de navigation",
    Strings.CloseSheet to "Fermer la feuille",
    Strings.DefaultErrorMessage to "Données incorrectes",
    Strings.SliderRangeStart to "Début de plage",
    Strings.SliderRangeEnd to "Fin de plage",
    Strings.ButtonGroupMoreOptions to "Autres options",
    Strings.Dialog to "Boîte de dialogue",
    Strings.MenuExpanded to "Développé",
    Strings.MenuCollapsed to "Réduit",
    Strings.ToggleDropdownMenu to "Activer/désactiver le menu déroulant",
    Strings.SnackbarDismiss to "Fermer",
    Strings.SnackbarPaneTitle to "Alerte",
    Strings.SearchBarSearch to "Rechercher",
    Strings.SuggestionsAvailable to "Suggestions ci-dessous",
    Strings.DatePickerTitle to "Sélectionner une date",
    Strings.DatePickerHeadline to "Date sélectionnée",
    Strings.DatePickerSwitchToYearSelection to "Passer à la sélection d\'une année",
    Strings.DatePickerSwitchToDaySelection to "Balayez l\'écran pour sélectionner une année ou appuyez pour revenir à la sélection d\'un jour",
    Strings.DatePickerSwitchToNextMonth to "Passer au mois suivant",
    Strings.DatePickerSwitchToPreviousMonth to "Passer au mois précédent",
    Strings.DatePickerNavigateToYearDescription to "Accéder à l\'année %1\$s",
    Strings.DatePickerHeadlineDescription to "Sélection actuelle : %1\$s",
    Strings.DatePickerNoSelectionDescription to "Aucun",
    Strings.DatePickerTodayDescription to "Aujourd\'hui",
    Strings.DatePickerYearPickerPaneTitle to "Sélecteur d\'année visible",
    Strings.DateInputTitle to "Sélectionner une date",
    Strings.DateInputHeadline to "Date saisie",
    Strings.DateInputLabel to "Date",
    Strings.DateInputHeadlineDescription to "Date saisie : %1\$s",
    Strings.DateInputNoInputDescription to "Aucun",
    Strings.DateInputInvalidNotAllowed to "Date non autorisée : %1\$s",
    Strings.DateInputInvalidForPattern to "La date ne correspond pas au format attendu : %1\$s",
    Strings.DateInputInvalidYearRange to "Date hors de la plage d\'années attendue : %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Passer au mode de saisie Agenda",
    Strings.DatePickerSwitchToInputMode to "Passer au mode de saisie Texte",
    Strings.DatePickerScrollToShowLaterYears to "Faites défiler pour afficher les années suivantes",
    Strings.DatePickerScrollToShowEarlierYears to "Faites défiler pour afficher les années précédentes",
    Strings.DateRangePickerTitle to "Sélectionner des dates",
    Strings.DateRangePickerStartHeadline to "Date de début",
    Strings.DateRangePickerEndHeadline to "Date de fin",
    Strings.DateRangePickerScrollToShowNextMonth to "Faites défiler pour afficher le mois suivant",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Faites défiler pour afficher le mois précédent",
    Strings.DateRangePickerDayInRange to "Dans la plage",
    Strings.DateRangeInputTitle to "Saisir des dates",
    Strings.DateRangeInputInvalidRangeInput to "Plage de dates non valide",
    Strings.BottomSheetPaneTitle to "Bottom sheet",
    Strings.BottomSheetDragHandleDescription to "Poignée de déplacement",
    Strings.BottomSheetPartialExpandDescription to "Réduire la bottom sheet",
    Strings.BottomSheetDismissDescription to "Fermer la bottom sheet",
    Strings.BottomSheetExpandDescription to "Développer la bottom sheet",
    Strings.FloatingToolbarCollapse to "Réduire la barre d\'outils",
    Strings.FloatingToolbarExpand to "Développer la barre d\'outils",
    Strings.FloatingToolbarMoreOptions to "Autres options",
    Strings.TooltipPaneDescription to "Info-bulle",
    Strings.TooltipLongPressLabel to "Afficher l\'info-bulle",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Sélectionner le format AM ou PM",
    Strings.TimePickerHourSelection to "Sélectionner une heure",
    Strings.TimePickerMinuteSelection to "Sélectionner des minutes",
    Strings.TimePickerHourSuffix to "%1\$d heures",
    Strings.TimePicker24HourSuffix to "%1\$d heures",
    Strings.TimePickerMinuteSuffix to "%1\$d minutes",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Heure",
    Strings.TimePickerMinuteTextField to "en minutes",
    Strings.TimePickerHourTextField to "en heures",
    Strings.TimePickerToggleKeyboard to "Passer au mode de saisie de texte",
    Strings.TimePickerToggleTouch to "Passer en mode horloge",
    Strings.TimePickerDialogTitle to "Sélectionner l\'heure",
    Strings.TimeInputDialogTitle to "Saisir l\'heure",
    Strings.TimePickerMinuteError to "Minute : entre 0 et 59",
    Strings.TimePickerHourError to "Heure : entre 1 et 12",
    Strings.TimePicker24HourError to "Heure : entre 0 et 23",
    Strings.CloseRail to "Fermer le rail",
    Strings.WideNavigationRailPaneTitle to "Rail de navigation",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.frCA() = mapOf(
    Strings.NavigationMenu to "Menu de navigation",
    Strings.ExposedDropdownMenu to "Menu déroulant",
    Strings.CloseDrawer to "Fermer le menu de navigation",
    Strings.CloseSheet to "Fermer la feuille",
    Strings.DefaultErrorMessage to "Entrée incorrecte",
    Strings.SliderRangeStart to "Début de plage",
    Strings.SliderRangeEnd to "Fin de plage",
    Strings.ButtonGroupMoreOptions to "Autres options",
    Strings.Dialog to "Dialogue",
    Strings.MenuExpanded to "Développé",
    Strings.MenuCollapsed to "Réduit",
    Strings.ToggleDropdownMenu to "Ouvrir ou fermer le menu déroulant",
    Strings.SnackbarDismiss to "Fermer",
    Strings.SnackbarPaneTitle to "Alerte",
    Strings.SearchBarSearch to "Recherche",
    Strings.SuggestionsAvailable to "Suggestions ci-dessous",
    Strings.DatePickerTitle to "Sélectionner une date",
    Strings.DatePickerHeadline to "Date sélectionnée",
    Strings.DatePickerSwitchToYearSelection to "Passer à la sélection d\'une année",
    Strings.DatePickerSwitchToDaySelection to "Balayez l\'écran pour sélectionner une année, ou touchez pour revenir en arrière et sélectionner un jour",
    Strings.DatePickerSwitchToNextMonth to "Passer au mois suivant",
    Strings.DatePickerSwitchToPreviousMonth to "Passer au mois précédent",
    Strings.DatePickerNavigateToYearDescription to "Naviguez jusqu\'à l\'année %1\$s",
    Strings.DatePickerHeadlineDescription to "Sélection actuelle : %1\$s",
    Strings.DatePickerNoSelectionDescription to "Aucune",
    Strings.DatePickerTodayDescription to "Aujourd\'hui",
    Strings.DatePickerYearPickerPaneTitle to "Sélecteur d\'année visible",
    Strings.DateInputTitle to "Sélectionner une date",
    Strings.DateInputHeadline to "Date entrée",
    Strings.DateInputLabel to "Date",
    Strings.DateInputHeadlineDescription to "Date entrée : %1\$s",
    Strings.DateInputNoInputDescription to "Aucune",
    Strings.DateInputInvalidNotAllowed to "Date non autorisée : %1\$s",
    Strings.DateInputInvalidForPattern to "La date ne correspond pas au schéma prévu : %1\$s",
    Strings.DateInputInvalidYearRange to "Date non comprise dans la fourchette prévue des années %1\$s à %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Passer au mode d\'entrée de l\'agenda",
    Strings.DatePickerSwitchToInputMode to "Passer au mode d\'entrée de texte",
    Strings.DatePickerScrollToShowLaterYears to "Faites défiler pour afficher les années suivantes",
    Strings.DatePickerScrollToShowEarlierYears to "Faites défiler pour afficher les années précédentes",
    Strings.DateRangePickerTitle to "Sélectionner les dates",
    Strings.DateRangePickerStartHeadline to "Date de début",
    Strings.DateRangePickerEndHeadline to "Date de fin",
    Strings.DateRangePickerScrollToShowNextMonth to "Faites défiler pour afficher le mois suivant",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Faites défiler pour afficher le mois précédent",
    Strings.DateRangePickerDayInRange to "Dans la fourchette",
    Strings.DateRangeInputTitle to "Entrer les dates",
    Strings.DateRangeInputInvalidRangeInput to "Entrée de période incorrecte",
    Strings.BottomSheetPaneTitle to "Zone de contenu dans le bas de l\'écran",
    Strings.BottomSheetDragHandleDescription to "Poignée de déplacement",
    Strings.BottomSheetPartialExpandDescription to "Réduire la zone de contenu dans le bas de l\'écran",
    Strings.BottomSheetDismissDescription to "Fermer la zone de contenu dans le bas de l\'écran",
    Strings.BottomSheetExpandDescription to "Développer la zone de contenu dans le bas de l\'écran",
    Strings.FloatingToolbarCollapse to "Réduire la barre d\'outils",
    Strings.FloatingToolbarExpand to "Développer la barre d\'outils",
    Strings.FloatingToolbarMoreOptions to "Autres options",
    Strings.TooltipPaneDescription to "Infobulle",
    Strings.TooltipLongPressLabel to "Afficher une infobulle",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Sélectionner AM ou PM",
    Strings.TimePickerHourSelection to "Sélectionner l\'heure",
    Strings.TimePickerMinuteSelection to "Sélectionnez les minutes",
    Strings.TimePickerHourSuffix to "%1\$d h",
    Strings.TimePicker24HourSuffix to "%1\$d h",
    Strings.TimePickerMinuteSuffix to "%1\$d minutes",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Heure",
    Strings.TimePickerMinuteTextField to "pour les minutes",
    Strings.TimePickerHourTextField to "pour l\'heure",
    Strings.TimePickerToggleKeyboard to "Passer au mode d\'entrée de texte",
    Strings.TimePickerToggleTouch to "Passer en mode Horloge",
    Strings.TimePickerDialogTitle to "Sélectionner l\'heure",
    Strings.TimeInputDialogTitle to "Saisir l\'heure",
    Strings.TimePickerMinuteError to "Minute entre 0 et 59",
    Strings.TimePickerHourError to "Heure entre 1 et 12",
    Strings.TimePicker24HourError to "Heure entre 0 et 23",
    Strings.CloseRail to "Fermer le rail",
    Strings.WideNavigationRailPaneTitle to "Rail de navigation",
)
