/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.hi() = mapOf(
    Strings.NavigationMenu to "नेविगेशन मेन्यू",
    Strings.ExposedDropdownMenu to "ड्रॉपडाउन मेन्यू",
    Strings.CloseDrawer to "नेविगेशन मेन्यू बंद करें",
    Strings.CloseSheet to "शीट बंद करें",
    Strings.DefaultErrorMessage to "अमान्य इनपुट",
    Strings.SliderRangeStart to "रेंज की शुरुआत",
    Strings.SliderRangeEnd to "रेंज की सीमा",
    Strings.ButtonGroupMoreOptions to "ज़्यादा विकल्प",
    Strings.Dialog to "डायलॉग",
    Strings.MenuExpanded to "बड़ा किया गया",
    Strings.MenuCollapsed to "छोटा किया गया",
    Strings.ToggleDropdownMenu to "ड्रॉपडाउन मेन्यू टॉगल करें",
    Strings.SnackbarDismiss to "खारिज करें",
    Strings.SnackbarPaneTitle to "चेतावनी",
    Strings.SearchBarSearch to "खोजें",
    Strings.SuggestionsAvailable to "सुझाव यहां मौजूद हैं",
    Strings.DatePickerTitle to "तारीख चुनें",
    Strings.DatePickerHeadline to "चुनी गई तारीख",
    Strings.DatePickerSwitchToYearSelection to "साल चुनने के लिए स्विच करें",
    Strings.DatePickerSwitchToDaySelection to "किसी साल को चुनने के लिए स्वाइप करें या दिन को चुनने की सेटिंग पर वापस जाने के लिए टैप करें",
    Strings.DatePickerSwitchToNextMonth to "अगले महीने पर सेट करें",
    Strings.DatePickerSwitchToPreviousMonth to "पिछले महीने पर सेट करें",
    Strings.DatePickerNavigateToYearDescription to "साल %1\$s पर जाएं",
    Strings.DatePickerHeadlineDescription to "फ़िलहाल, यह तारीख चुनी गई है: %1\$s",
    Strings.DatePickerNoSelectionDescription to "कोई नहीं",
    Strings.DatePickerTodayDescription to "आज",
    Strings.DatePickerYearPickerPaneTitle to "साल चुनने का विकल्प दिख रहा है",
    Strings.DateInputTitle to "तारीख चुनें",
    Strings.DateInputHeadline to "डाली गई तारीख",
    Strings.DateInputLabel to "तारीख",
    Strings.DateInputHeadlineDescription to "डाली गई तारीख: %1\$s",
    Strings.DateInputNoInputDescription to "कोई नहीं",
    Strings.DateInputInvalidNotAllowed to "यह तारीख सही नहीं है: %1\$s",
    Strings.DateInputInvalidForPattern to "तारीख सही फ़ॉर्मैट में नहीं डाली गई है: %1\$s",
    Strings.DateInputInvalidYearRange to "तारीख को साल की सही रेंज में नहीं डाला गया है %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "कैलेंडर इनपुट मोड पर स्विच करें",
    Strings.DatePickerSwitchToInputMode to "टेक्स्ट इनपुट मोड पर स्विच करें",
    Strings.DatePickerScrollToShowLaterYears to "बाद वाले सालों की तारीख देखने के लिए स्क्रोल करें",
    Strings.DatePickerScrollToShowEarlierYears to "पिछले सालों की तारीख देखने के लिए स्क्रोल करें",
    Strings.DateRangePickerTitle to "तारीखें चुनें",
    Strings.DateRangePickerStartHeadline to "शुरू होने की तारीख",
    Strings.DateRangePickerEndHeadline to "खत्म होने की तारीख",
    Strings.DateRangePickerScrollToShowNextMonth to "अगले महीने की तारीख देखने के लिए स्क्रोल करें",
    Strings.DateRangePickerScrollToShowPreviousMonth to "पिछले महीने की तारीख देखने के लिए स्क्रोल करें",
    Strings.DateRangePickerDayInRange to "रेंज में",
    Strings.DateRangeInputTitle to "तारीखें डालें",
    Strings.DateRangeInputInvalidRangeInput to "तारीख की दी गई सीमा गलत है",
    Strings.BottomSheetPaneTitle to "बॉटम शीट",
    Strings.BottomSheetDragHandleDescription to "खींचकर छोड़ने वाला हैंडल",
    Strings.BottomSheetPartialExpandDescription to "बॉटम शीट को छोटा करें",
    Strings.BottomSheetDismissDescription to "बॉटम शीट को खारिज करें",
    Strings.BottomSheetExpandDescription to "बॉटम शीट को बड़ा करें",
    Strings.FloatingToolbarCollapse to "टूलबार को छोटा करें",
    Strings.FloatingToolbarExpand to "टूलबार को बड़ा करें",
    Strings.FloatingToolbarMoreOptions to "ज़्यादा विकल्प",
    Strings.TooltipPaneDescription to "टूलटिप",
    Strings.TooltipLongPressLabel to "टूलटिप देखें",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM या PM चुनें",
    Strings.TimePickerHourSelection to "घंटा चुनें",
    Strings.TimePickerMinuteSelection to "मिनट चुनें",
    Strings.TimePickerHourSuffix to "%1\$d बजे",
    Strings.TimePicker24HourSuffix to "%1\$d घंटे",
    Strings.TimePickerMinuteSuffix to "%1\$d मिनट",
    Strings.TimePickerMinute to "मिनट",
    Strings.TimePickerHour to "घंटा",
    Strings.TimePickerMinuteTextField to "मिनट के लिए",
    Strings.TimePickerHourTextField to "घंटे के लिए",
    Strings.TimePickerToggleKeyboard to "टेक्स्ट इनपुट मोड पर स्विच करें",
    Strings.TimePickerToggleTouch to "क्लॉक मोड पर स्विच करें",
    Strings.TimePickerDialogTitle to "समय चुनें",
    Strings.TimeInputDialogTitle to "समय डालें",
    Strings.TimePickerMinuteError to "यह 0-59 मिनट के बीच हो",
    Strings.TimePickerHourError to "यह 1-12 घंटे के बीच हो",
    Strings.TimePicker24HourError to "यह 0-23 घंटे के बीच हो",
    Strings.CloseRail to "मॉडल रेल को बंद करें",
    Strings.WideNavigationRailPaneTitle to "नेविगेशन रेल",
)
