/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.it() = mapOf(
    Strings.NavigationMenu to "Menu di navigazione",
    Strings.ExposedDropdownMenu to "Menu a discesa",
    Strings.CloseDrawer to "Chiudi il menu di navigazione",
    Strings.CloseSheet to "Chiudi il foglio",
    Strings.DefaultErrorMessage to "Valore non valido",
    Strings.SliderRangeStart to "Inizio intervallo",
    Strings.SliderRangeEnd to "Fine intervallo",
    Strings.ButtonGroupMoreOptions to "Altre opzioni",
    Strings.Dialog to "Finestra di dialogo",
    Strings.MenuExpanded to "Espanso",
    Strings.MenuCollapsed to "Compresso",
    Strings.ToggleDropdownMenu to "Attiva/disattiva menu a discesa",
    Strings.SnackbarDismiss to "Chiudi",
    Strings.SnackbarPaneTitle to "Avviso",
    Strings.SearchBarSearch to "Cerca",
    Strings.SuggestionsAvailable to "Suggerimenti sotto",
    Strings.DatePickerTitle to "Seleziona data",
    Strings.DatePickerHeadline to "Data selezionata",
    Strings.DatePickerSwitchToYearSelection to "Passa alla selezione di un anno",
    Strings.DatePickerSwitchToDaySelection to "Scorri per selezionare un anno o tocca per tornare alla selezione di un giorno",
    Strings.DatePickerSwitchToNextMonth to "Passa al mese successivo",
    Strings.DatePickerSwitchToPreviousMonth to "Passa al mese precedente",
    Strings.DatePickerNavigateToYearDescription to "Vai all\'anno %1\$s",
    Strings.DatePickerHeadlineDescription to "Selezione attuale: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Nessuna selezione",
    Strings.DatePickerTodayDescription to "Oggi",
    Strings.DatePickerYearPickerPaneTitle to "Selettore dell\'anno visibile",
    Strings.DateInputTitle to "Seleziona data",
    Strings.DateInputHeadline to "Data inserita",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Data inserita: %1\$s",
    Strings.DateInputNoInputDescription to "Nessuna selezione",
    Strings.DateInputInvalidNotAllowed to "Data non consentita: %1\$s",
    Strings.DateInputInvalidForPattern to "La data non corrisponde al pattern previsto: %1\$s",
    Strings.DateInputInvalidYearRange to "La data non rientra nell\'intervallo di anni previsto (%1\$s-%2\$s)",
    Strings.DatePickerSwitchToCalendarMode to "Passa alla modalità di immissione calendario",
    Strings.DatePickerSwitchToInputMode to "Passa alla modalità di immissione testo",
    Strings.DatePickerScrollToShowLaterYears to "Scorri per visualizzare gli anni successivi",
    Strings.DatePickerScrollToShowEarlierYears to "Scorri per visualizzare gli anni precedenti",
    Strings.DateRangePickerTitle to "Seleziona date",
    Strings.DateRangePickerStartHeadline to "Data di inizio",
    Strings.DateRangePickerEndHeadline to "Data di fine",
    Strings.DateRangePickerScrollToShowNextMonth to "Scorri per visualizzare il mese successivo",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scorri per visualizzare il mese precedente",
    Strings.DateRangePickerDayInRange to "Nell\'intervallo",
    Strings.DateRangeInputTitle to "Inserisci date",
    Strings.DateRangeInputInvalidRangeInput to "Intervallo di date inserito non valido",
    Strings.BottomSheetPaneTitle to "Riquadro inferiore",
    Strings.BottomSheetDragHandleDescription to "Punto di trascinamento",
    Strings.BottomSheetPartialExpandDescription to "Comprimi il riquadro inferiore",
    Strings.BottomSheetDismissDescription to "Chiudi il riquadro inferiore",
    Strings.BottomSheetExpandDescription to "Espandi il riquadro inferiore",
    Strings.FloatingToolbarCollapse to "Comprimi la barra degli strumenti",
    Strings.FloatingToolbarExpand to "Espandi la barra degli strumenti",
    Strings.FloatingToolbarMoreOptions to "Altre opzioni",
    Strings.TooltipPaneDescription to "Descrizione comando",
    Strings.TooltipLongPressLabel to "Mostra descrizione comando",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Seleziona AM o PM",
    Strings.TimePickerHourSelection to "Seleziona l\'ora",
    Strings.TimePickerMinuteSelection to "Seleziona i minuti",
    Strings.TimePickerHourSuffix to "%1\$d in punto",
    Strings.TimePicker24HourSuffix to "%1\$d ore",
    Strings.TimePickerMinuteSuffix to "%1\$d minuti",
    Strings.TimePickerMinute to "Minuto",
    Strings.TimePickerHour to "Ora",
    Strings.TimePickerMinuteTextField to "per i minuti",
    Strings.TimePickerHourTextField to "per l\'ora",
    Strings.TimePickerToggleKeyboard to "Passa alla modalità di immissione testo",
    Strings.TimePickerToggleTouch to "Passa alla modalità orologio",
    Strings.TimePickerDialogTitle to "Seleziona l\'ora",
    Strings.TimeInputDialogTitle to "Inserisci l\'ora",
    Strings.TimePickerMinuteError to "Il minuto deve essere 0-59",
    Strings.TimePickerHourError to "L\'ora deve essere 1-12",
    Strings.TimePicker24HourError to "L\'ora deve essere 0-23",
    Strings.CloseRail to "Chiudi modalità laterale",
    Strings.WideNavigationRailPaneTitle to "Modalità di navigazione laterale",
)
