/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.km() = mapOf(
    Strings.NavigationMenu to "ម៉ឺនុយរុករក",
    Strings.ExposedDropdownMenu to "ម៉ឺនុយធ្លាក់ចុះ",
    Strings.CloseDrawer to "បិទម៉ឺនុយរុករក",
    Strings.CloseSheet to "បិទសន្លឹក",
    Strings.DefaultErrorMessage to "ការបញ្ចូល​មិនត្រឹមត្រូវ",
    Strings.SliderRangeStart to "ចំណុចចាប់ផ្ដើម",
    Strings.SliderRangeEnd to "ចំណុចបញ្ចប់",
    Strings.ButtonGroupMoreOptions to "ជម្រើស​ច្រើនទៀត",
    Strings.Dialog to "ប្រអប់",
    Strings.MenuExpanded to "បាន​ពង្រីក",
    Strings.MenuCollapsed to "បាន​បង្រួម",
    Strings.ToggleDropdownMenu to "បិទ/បើកម៉ឺនុយ​ធ្លាក់​ចុះ",
    Strings.SnackbarDismiss to "ច្រានចោល",
    Strings.SnackbarPaneTitle to "ជូន​ដំណឹង",
    Strings.SearchBarSearch to "ស្វែងរក",
    Strings.SuggestionsAvailable to "ការណែនាំខាងក្រោម",
    Strings.DatePickerTitle to "ជ្រើសរើស​កាលបរិច្ឆេទ",
    Strings.DatePickerHeadline to "កាលបរិច្ឆេទដែលបាន​ជ្រើសរើស",
    Strings.DatePickerSwitchToYearSelection to "ប្ដូរទៅ​ការជ្រើសរើសឆ្នាំ",
    Strings.DatePickerSwitchToDaySelection to "អូសដើម្បីជ្រើសរើសឆ្នាំ ឬចុចដើម្បីប្ដូរត្រឡប់ទៅការជ្រើសរើសថ្ងៃវិញ",
    Strings.DatePickerSwitchToNextMonth to "ប្ដូរ​ទៅ​ខែបន្ទាប់",
    Strings.DatePickerSwitchToPreviousMonth to "ប្ដូរ​ទៅ​ខែមុន",
    Strings.DatePickerNavigateToYearDescription to "រុករកទៅកាន់ឆ្នាំ %1\$s",
    Strings.DatePickerHeadlineDescription to "ការជ្រើសរើសបច្ចុប្បន្ន៖ %1\$s",
    Strings.DatePickerNoSelectionDescription to "គ្មាន",
    Strings.DatePickerTodayDescription to "ថ្ងៃនេះ",
    Strings.DatePickerYearPickerPaneTitle to "អាចមើលឃើញផ្ទាំងជ្រើសរើសឆ្នាំ",
    Strings.DateInputTitle to "ជ្រើសរើស​កាលបរិច្ឆេទ",
    Strings.DateInputHeadline to "កាលបរិច្ឆេទដែលបានបញ្ចូល",
    Strings.DateInputLabel to "កាលបរិច្ឆេទ",
    Strings.DateInputHeadlineDescription to "កាលបរិច្ឆេទដែលបានបញ្ចូល៖ %1\$s",
    Strings.DateInputNoInputDescription to "គ្មាន",
    Strings.DateInputInvalidNotAllowed to "កាលបរិច្ឆេទដែលមិនបានអនុញ្ញាត៖ %1\$s",
    Strings.DateInputInvalidForPattern to "កាលបរិច្ឆេទមិនត្រូវគ្នានឹងលំនាំដែលរំពឹងទុកទេ៖ %1\$s",
    Strings.DateInputInvalidYearRange to "កាលបរិច្ឆេទដែលស្ថិតនៅក្រៅចន្លោះឆ្នាំដែលរំពឹងទុក %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "ប្ដូរទៅ​មុខងារបញ្ចូល​ប្រតិទិន",
    Strings.DatePickerSwitchToInputMode to "ប្ដូរទៅ​មុខងារបញ្ចូល​អក្សរ",
    Strings.DatePickerScrollToShowLaterYears to "រំកិលដើម្បី​បង្ហាញឆ្នាំក្រោយៗ",
    Strings.DatePickerScrollToShowEarlierYears to "រំកិលដើម្បី​បង្ហាញឆ្នាំមុនៗ",
    Strings.DateRangePickerTitle to "ជ្រើសរើស​កាល​បរិច្ឆេទ",
    Strings.DateRangePickerStartHeadline to "កាលបរិច្ឆេទ​ចាប់ផ្ដើម",
    Strings.DateRangePickerEndHeadline to "កាលបរិច្ឆេទ​បញ្ចប់",
    Strings.DateRangePickerScrollToShowNextMonth to "រំកិលដើម្បីបង្ហាញខែក្រោយ",
    Strings.DateRangePickerScrollToShowPreviousMonth to "រំកិលដើម្បីបង្ហាញខែមុន",
    Strings.DateRangePickerDayInRange to "ក្នុងចន្លោះ",
    Strings.DateRangeInputTitle to "បញ្ចូល​កាលបរិច្ឆេទ",
    Strings.DateRangeInputInvalidRangeInput to "ការបញ្ចូលចន្លោះកាលបរិច្ឆេទមិនត្រឹមត្រូវ",
    Strings.BottomSheetPaneTitle to "សន្លឹក​ខាងក្រោម",
    Strings.BottomSheetDragHandleDescription to "ដង​អូស",
    Strings.BottomSheetPartialExpandDescription to "បង្រួម​សន្លឹកខាងក្រោម",
    Strings.BottomSheetDismissDescription to "ច្រានចោល​សន្លឹកខាងក្រោម",
    Strings.BottomSheetExpandDescription to "ពង្រីក​សន្លឹកខាងក្រោម",
    Strings.FloatingToolbarCollapse to "បង្រួមរបារឧបករណ៍",
    Strings.FloatingToolbarExpand to "ពង្រីករបារឧបករណ៍",
    Strings.FloatingToolbarMoreOptions to "ជម្រើស​ច្រើនទៀត",
    Strings.TooltipPaneDescription to "កំណត់​ពន្យល់",
    Strings.TooltipLongPressLabel to "បង្ហាញ​កំណត់​ពន្យល់",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "ជ្រើសរើស AM ឬ PM",
    Strings.TimePickerHourSelection to "ជ្រើសរើសម៉ោង",
    Strings.TimePickerMinuteSelection to "ជ្រើស​រើសនាទី",
    Strings.TimePickerHourSuffix to "ម៉ោង %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d ម៉ោង",
    Strings.TimePickerMinuteSuffix to "%1\$d នាទី",
    Strings.TimePickerMinute to "នាទី​",
    Strings.TimePickerHour to "ម៉ោង",
    Strings.TimePickerMinuteTextField to "រយៈពេលប៉ុន្មាននាទី",
    Strings.TimePickerHourTextField to "រយៈពេលប៉ុន្មានម៉ោង",
    Strings.TimePickerToggleKeyboard to "ប្ដូរទៅ​មុខងារបញ្ចូល​អក្សរ",
    Strings.TimePickerToggleTouch to "ប្ដូរទៅ​មុខងារនាឡិកា",
    Strings.TimePickerDialogTitle to "ជ្រើសរើស​ពេលវេលា",
    Strings.TimeInputDialogTitle to "បញ្ចូលម៉ោង",
    Strings.TimePickerMinuteError to "នាទីត្រូវតែពី 0–59",
    Strings.TimePickerHourError to "ម៉ោងត្រូវតែពី 1–12",
    Strings.TimePicker24HourError to "ម៉ោងត្រូវតែពី 0–23",
    Strings.CloseRail to "បិទខ្សែ",
    Strings.WideNavigationRailPaneTitle to "ខ្សែរុករក",
)
