/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ko() = mapOf(
    Strings.NavigationMenu to "탐색 메뉴",
    Strings.ExposedDropdownMenu to "드롭다운 메뉴",
    Strings.CloseDrawer to "탐색 메뉴 닫기",
    Strings.CloseSheet to "시트 닫기",
    Strings.DefaultErrorMessage to "입력이 잘못됨",
    Strings.SliderRangeStart to "범위 시작",
    Strings.SliderRangeEnd to "범위 끝",
    Strings.ButtonGroupMoreOptions to "옵션 더보기",
    Strings.Dialog to "대화상자",
    Strings.MenuExpanded to "펼침",
    Strings.MenuCollapsed to "접힘",
    Strings.ToggleDropdownMenu to "전환 드롭다운 메뉴",
    Strings.SnackbarDismiss to "닫기",
    Strings.SnackbarPaneTitle to "주의",
    Strings.SearchBarSearch to "검색",
    Strings.SuggestionsAvailable to "아래의 추천 검색어",
    Strings.DatePickerTitle to "날짜 선택",
    Strings.DatePickerHeadline to "선택한 날짜",
    Strings.DatePickerSwitchToYearSelection to "연도 선택으로 전환",
    Strings.DatePickerSwitchToDaySelection to "스와이프하여 연도를 선택하거나 탭하여 날짜 선택으로 돌아가세요.",
    Strings.DatePickerSwitchToNextMonth to "다음 달로 변경",
    Strings.DatePickerSwitchToPreviousMonth to "이전 달로 변경",
    Strings.DatePickerNavigateToYearDescription to "%1\$s년으로 이동",
    Strings.DatePickerHeadlineDescription to "현재 선택사항: %1\$s",
    Strings.DatePickerNoSelectionDescription to "없음",
    Strings.DatePickerTodayDescription to "오늘",
    Strings.DatePickerYearPickerPaneTitle to "연도 선택 도구 표시",
    Strings.DateInputTitle to "날짜 선택",
    Strings.DateInputHeadline to "입력한 날짜",
    Strings.DateInputLabel to "날짜",
    Strings.DateInputHeadlineDescription to "입력한 날짜: %1\$s",
    Strings.DateInputNoInputDescription to "없음",
    Strings.DateInputInvalidNotAllowed to "데이터 허용 안 됨: %1\$s",
    Strings.DateInputInvalidForPattern to "데이터가 예상 패턴과 일치하지 않음: %1\$s",
    Strings.DateInputInvalidYearRange to "데이터가 예상 연도 범위(%1\$s~%2\$s)를 벗어남",
    Strings.DatePickerSwitchToCalendarMode to "캘린더 입력 모드로 전환",
    Strings.DatePickerSwitchToInputMode to "텍스트 입력 모드로 전환",
    Strings.DatePickerScrollToShowLaterYears to "스크롤하여 이후 연도 보기",
    Strings.DatePickerScrollToShowEarlierYears to "스크롤하여 이전 연도 보기",
    Strings.DateRangePickerTitle to "날짜 선택",
    Strings.DateRangePickerStartHeadline to "시작일",
    Strings.DateRangePickerEndHeadline to "종료일",
    Strings.DateRangePickerScrollToShowNextMonth to "스크롤하여 다음 달 보기",
    Strings.DateRangePickerScrollToShowPreviousMonth to "스크롤하여 이전 달 보기",
    Strings.DateRangePickerDayInRange to "범위 내",
    Strings.DateRangeInputTitle to "날짜 입력",
    Strings.DateRangeInputInvalidRangeInput to "잘못된 기간 입력",
    Strings.BottomSheetPaneTitle to "하단 시트",
    Strings.BottomSheetDragHandleDescription to "드래그 핸들",
    Strings.BottomSheetPartialExpandDescription to "하단 시트 접기",
    Strings.BottomSheetDismissDescription to "하단 시트 닫기",
    Strings.BottomSheetExpandDescription to "하단 시트 펼치기",
    Strings.FloatingToolbarCollapse to "툴바 접기",
    Strings.FloatingToolbarExpand to "툴바 펼치기",
    Strings.FloatingToolbarMoreOptions to "옵션 더보기",
    Strings.TooltipPaneDescription to "도움말",
    Strings.TooltipLongPressLabel to "도움말 표시",
    Strings.TimePickerPM to "오후",
    Strings.TimePickerAM to "오전",
    Strings.TimePickerPeriodToggle to "오전 또는 오후를 선택하세요.",
    Strings.TimePickerHourSelection to "시간 선택",
    Strings.TimePickerMinuteSelection to "분 선택",
    Strings.TimePickerHourSuffix to "%1\$d시 정각",
    Strings.TimePicker24HourSuffix to "%1\$d시간",
    Strings.TimePickerMinuteSuffix to "%1\$d분",
    Strings.TimePickerMinute to "분",
    Strings.TimePickerHour to "시간",
    Strings.TimePickerMinuteTextField to "기간(분)",
    Strings.TimePickerHourTextField to "기간(시간)",
    Strings.TimePickerToggleKeyboard to "텍스트 입력 모드로 전환",
    Strings.TimePickerToggleTouch to "시계 모드로 전환",
    Strings.TimePickerDialogTitle to "시간 선택",
    Strings.TimeInputDialogTitle to "시간 입력",
    Strings.TimePickerMinuteError to "분은 0~59여야 함",
    Strings.TimePickerHourError to "시간은 1~12여야 함",
    Strings.TimePicker24HourError to "시간은 0~23이어야 함",
    Strings.CloseRail to "레일 닫기",
    Strings.WideNavigationRailPaneTitle to "탐색 레일",
)
