/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.lt() = mapOf(
    Strings.NavigationMenu to "Naršymo meniu",
    Strings.ExposedDropdownMenu to "Išskleidžiamasis meniu",
    Strings.CloseDrawer to "Uždaryti naršymo meniu",
    Strings.CloseSheet to "Uždaryti lapą",
    Strings.DefaultErrorMessage to "Netinkama įvestis",
    Strings.SliderRangeStart to "Diapazono pradžia",
    Strings.SliderRangeEnd to "Diapazono pabaiga",
    Strings.ButtonGroupMoreOptions to "Daugiau parinkčių",
    Strings.Dialog to "Dialogo langas",
    Strings.MenuExpanded to "Išskleista",
    Strings.MenuCollapsed to "Sutraukta",
    Strings.ToggleDropdownMenu to "Perjungti išskleidžiamąjį meniu",
    Strings.SnackbarDismiss to "Atsisakyti",
    Strings.SnackbarPaneTitle to "Įspėjimas",
    Strings.SearchBarSearch to "Paieška",
    Strings.SuggestionsAvailable to "Pasiūlymai pateikti toliau",
    Strings.DatePickerTitle to "Pasirinkite datą",
    Strings.DatePickerHeadline to "Pasirinkta data",
    Strings.DatePickerSwitchToYearSelection to "Perjungti į metų pasirinkimą",
    Strings.DatePickerSwitchToDaySelection to "Perbraukite, kad pasirinktumėte metus, arba palieskite, kad grįžtumėte ir vėl pasirinktumėte dieną",
    Strings.DatePickerSwitchToNextMonth to "Pakeisti į kitą mėnesį",
    Strings.DatePickerSwitchToPreviousMonth to "Pakeisti į ankstesnį mėnesį",
    Strings.DatePickerNavigateToYearDescription to "Eiti į %1\$s m.",
    Strings.DatePickerHeadlineDescription to "Dabartinis pasirinkimas: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Nėra",
    Strings.DatePickerTodayDescription to "Šiandien",
    Strings.DatePickerYearPickerPaneTitle to "Rodomas metų parinkiklis",
    Strings.DateInputTitle to "Pasirinkite datą",
    Strings.DateInputHeadline to "Įvesta data",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Įvesta data: %1\$s",
    Strings.DateInputNoInputDescription to "Nėra",
    Strings.DateInputInvalidNotAllowed to "Data neleidžiama: %1\$s",
    Strings.DateInputInvalidForPattern to "Data neatitinka numatyto šablono: %1\$s",
    Strings.DateInputInvalidYearRange to "Data nepatenka į numatytų metų diapazoną: %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Perjungti į kalendoriaus įvesties režimą",
    Strings.DatePickerSwitchToInputMode to "Perjungti į teksto įvesties režimą",
    Strings.DatePickerScrollToShowLaterYears to "Slinkite, kol bus rodomi vėlesni metai",
    Strings.DatePickerScrollToShowEarlierYears to "Slinkite, kol bus rodomi ankstesni metai",
    Strings.DateRangePickerTitle to "Pasirinkite datas",
    Strings.DateRangePickerStartHeadline to "Pradžios data",
    Strings.DateRangePickerEndHeadline to "Pabaigos data",
    Strings.DateRangePickerScrollToShowNextMonth to "Slinkite, kol bus rodomas kitas mėnuo",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Slinkite, kol bus rodomas ankstesnis mėnuo",
    Strings.DateRangePickerDayInRange to "Diapazone",
    Strings.DateRangeInputTitle to "Įvesti datas",
    Strings.DateRangeInputInvalidRangeInput to "Netinkama dienų sekos įvestis",
    Strings.BottomSheetPaneTitle to "Apatinis lapas",
    Strings.BottomSheetDragHandleDescription to "Vilkimo rankenėlė",
    Strings.BottomSheetPartialExpandDescription to "Sutraukti apatinį lapą",
    Strings.BottomSheetDismissDescription to "Atsisakyti apatinio lapo",
    Strings.BottomSheetExpandDescription to "Išskleisti apatinį lapą",
    Strings.FloatingToolbarCollapse to "Sutraukti įrankių juostą",
    Strings.FloatingToolbarExpand to "Išskleisti įrankių juostą",
    Strings.FloatingToolbarMoreOptions to "Daugiau parinkčių",
    Strings.TooltipPaneDescription to "Patarimas",
    Strings.TooltipLongPressLabel to "Rodyti patarimą",
    Strings.TimePickerPM to "popiet",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Pasirinkite „priešpiet“ arba „popiet“",
    Strings.TimePickerHourSelection to "Pasirinkite valandą",
    Strings.TimePickerMinuteSelection to "Pasirinkite minutes",
    Strings.TimePickerHourSuffix to "%1\$d val.",
    Strings.TimePicker24HourSuffix to "%1\$d val.",
    Strings.TimePickerMinuteSuffix to "%d min.",
    Strings.TimePickerMinute to "Minutė",
    Strings.TimePickerHour to "Valanda",
    Strings.TimePickerMinuteTextField to "minutės",
    Strings.TimePickerHourTextField to "valandos",
    Strings.TimePickerToggleKeyboard to "Perjungti į teksto įvesties režimą",
    Strings.TimePickerToggleTouch to "Perjungti į laikrodžio režimą",
    Strings.TimePickerDialogTitle to "Pasirinkite laiką",
    Strings.TimeInputDialogTitle to "Įveskite laiką",
    Strings.TimePickerMinuteError to "Minutė turi būti 0–59",
    Strings.TimePickerHourError to "Valanda turi būti 1–12",
    Strings.TimePicker24HourError to "Valanda turi būti 0–23",
    Strings.CloseRail to "Uždaryti juostą",
    Strings.WideNavigationRailPaneTitle to "Naršymo juosta",
)
