/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.nl() = mapOf(
    Strings.NavigationMenu to "Navigatiemenu",
    Strings.ExposedDropdownMenu to "Dropdownmenu",
    Strings.CloseDrawer to "Navigatiemenu sluiten",
    Strings.CloseSheet to "Blad sluiten",
    Strings.DefaultErrorMessage to "Ongeldige invoer",
    Strings.SliderRangeStart to "Start bereik",
    Strings.SliderRangeEnd to "Einde bereik",
    Strings.ButtonGroupMoreOptions to "Meer opties",
    Strings.Dialog to "Dialoogvenster",
    Strings.MenuExpanded to "Uitgevouwen",
    Strings.MenuCollapsed to "Samengevouwen",
    Strings.ToggleDropdownMenu to "Dropdownmenu aan-/uitzetten",
    Strings.SnackbarDismiss to "Sluiten",
    Strings.SnackbarPaneTitle to "Melding",
    Strings.SearchBarSearch to "Zoeken",
    Strings.SuggestionsAvailable to "Suggesties hieronder",
    Strings.DatePickerTitle to "Datum selecteren",
    Strings.DatePickerHeadline to "Geselecteerde datum",
    Strings.DatePickerSwitchToYearSelection to "Schakelaar om een jaar te selecteren",
    Strings.DatePickerSwitchToDaySelection to "Swipe om een jaar te selecteren of tik om terug te gaan en een dag te selecteren",
    Strings.DatePickerSwitchToNextMonth to "Naar volgende maand gaan",
    Strings.DatePickerSwitchToPreviousMonth to "Naar vorige maand gaan",
    Strings.DatePickerNavigateToYearDescription to "Ga naar jaar %1\$s",
    Strings.DatePickerHeadlineDescription to "Huidige selectie: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Geen",
    Strings.DatePickerTodayDescription to "Vandaag",
    Strings.DatePickerYearPickerPaneTitle to "Jaarselectie zichtbaar",
    Strings.DateInputTitle to "Datum selecteren",
    Strings.DateInputHeadline to "Ingevulde datum",
    Strings.DateInputLabel to "Datum",
    Strings.DateInputHeadlineDescription to "Ingevulde datum: %1\$s",
    Strings.DateInputNoInputDescription to "Geen",
    Strings.DateInputInvalidNotAllowed to "Datum niet toegestaan: %1\$s",
    Strings.DateInputInvalidForPattern to "De datum komt niet overeen met het verwachte patroon: %1\$s",
    Strings.DateInputInvalidYearRange to "Datum buiten het verwachte jaarbereik %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Overschakelen naar agenda-invoermodus",
    Strings.DatePickerSwitchToInputMode to "Overschakelen naar tekstinvoermodus",
    Strings.DatePickerScrollToShowLaterYears to "Scroll om latere jaren te tonen",
    Strings.DatePickerScrollToShowEarlierYears to "Scroll om eerdere jaren te tonen",
    Strings.DateRangePickerTitle to "Datums selecteren",
    Strings.DateRangePickerStartHeadline to "Startdatum",
    Strings.DateRangePickerEndHeadline to "Einddatum",
    Strings.DateRangePickerScrollToShowNextMonth to "Scroll om de volgende maand te tonen",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scroll om de vorige maand te tonen",
    Strings.DateRangePickerDayInRange to "Binnen bereik",
    Strings.DateRangeInputTitle to "Datums opgeven",
    Strings.DateRangeInputInvalidRangeInput to "Ongeldige invoer voor periode",
    Strings.BottomSheetPaneTitle to "Blad onderaan",
    Strings.BottomSheetDragHandleDescription to "Handgreep voor slepen",
    Strings.BottomSheetPartialExpandDescription to "Blad onderaan samenvouwen",
    Strings.BottomSheetDismissDescription to "Blad onderaan sluiten",
    Strings.BottomSheetExpandDescription to "Blad onderaan uitvouwen",
    Strings.FloatingToolbarCollapse to "Werkbalk samenvouwen",
    Strings.FloatingToolbarExpand to "Werkbalk uitvouwen",
    Strings.FloatingToolbarMoreOptions to "Meer opties",
    Strings.TooltipPaneDescription to "Tooltip",
    Strings.TooltipLongPressLabel to "Tooltip tonen",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM of PM selecteren",
    Strings.TimePickerHourSelection to "Uur selecteren",
    Strings.TimePickerMinuteSelection to "Minuten selecteren",
    Strings.TimePickerHourSuffix to "%1\$d uur",
    Strings.TimePicker24HourSuffix to "%1\$d uur",
    Strings.TimePickerMinuteSuffix to "%1\$d minuten",
    Strings.TimePickerMinute to "Minuut",
    Strings.TimePickerHour to "Uur",
    Strings.TimePickerMinuteTextField to "voor minuten",
    Strings.TimePickerHourTextField to "voor uur",
    Strings.TimePickerToggleKeyboard to "Overschakelen naar tekstinvoermodus",
    Strings.TimePickerToggleTouch to "Overschakelen naar klokmodus",
    Strings.TimePickerDialogTitle to "Tijd selecteren",
    Strings.TimeInputDialogTitle to "Tijd invoeren",
    Strings.TimePickerMinuteError to "Minuut moet 0 - 59 zijn",
    Strings.TimePickerHourError to "Uur moet 1 - 12 zijn",
    Strings.TimePicker24HourError to "Uur moet 0 - 23 zijn",
    Strings.CloseRail to "Rail sluiten",
    Strings.WideNavigationRailPaneTitle to "Navigatierail",
)
