/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.pa() = mapOf(
    Strings.NavigationMenu to "ਨੈਵੀਗੇਸ਼ਨ ਮੀਨੂ",
    Strings.ExposedDropdownMenu to "ਡ੍ਰੌਪ-ਡਾਊਨ ਮੀਨੂ",
    Strings.CloseDrawer to "ਨੈਵੀਗੇਸ਼ਨ ਮੀਨੂ ਬੰਦ ਕਰੋ",
    Strings.CloseSheet to "ਸ਼ੀਟ ਬੰਦ ਕਰੋ",
    Strings.DefaultErrorMessage to "ਅਵੈਧ ਇਨਪੁੱਟ",
    Strings.SliderRangeStart to "ਰੇਂਜ ਸ਼ੁਰੂ",
    Strings.SliderRangeEnd to "ਰੇਂਜ ਸਮਾਪਤ",
    Strings.ButtonGroupMoreOptions to "ਹੋਰ ਵਿਕਲਪ",
    Strings.Dialog to "ਡਾਇਲੌਗ",
    Strings.MenuExpanded to "ਵਿਸਤਾਰ ਕੀਤਾ ਗਿਆ",
    Strings.MenuCollapsed to "ਸਮੇਟਿਆ ਗਿਆ",
    Strings.ToggleDropdownMenu to "ਡ੍ਰੌਪ-ਡਾਊਨ ਮੀਨੂ ਨੂੰ ਟੌਗਲ ਕਰੋ",
    Strings.SnackbarDismiss to "ਖਾਰਜ ਕਰੋ",
    Strings.SnackbarPaneTitle to "ਅਲਰਟ",
    Strings.SearchBarSearch to "ਖੋਜੋ",
    Strings.SuggestionsAvailable to "ਸੁਝਾਅ ਹੇਠਾਂ ਹਨ",
    Strings.DatePickerTitle to "ਤਾਰੀਖ ਚੁਣੋ",
    Strings.DatePickerHeadline to "ਚੁਣੀ ਗਈ ਤਾਰੀਖ",
    Strings.DatePickerSwitchToYearSelection to "ਸਾਲ ਚੁਣਨ ਲਈ ਸਵਿੱਚ ਕਰੋ",
    Strings.DatePickerSwitchToDaySelection to "ਕੋਈ ਸਾਲ ਚੁਣਨ ਲਈ ਸਵਾਈਪ ਕਰੋ ਜਾਂ ਕੋਈ ਦਿਨ ਚੁਣਨ ਲਈ ਵਾਪਸ ਜਾਣ ਵਾਸਤੇ ਟੈਪ ਕਰੋ",
    Strings.DatePickerSwitchToNextMonth to "ਅਗਲੇ ਮਹੀਨੇ \'ਤੇ ਜਾਓ",
    Strings.DatePickerSwitchToPreviousMonth to "ਪਿਛਲੇ ਮਹੀਨੇ \'ਤੇ ਜਾਓ",
    Strings.DatePickerNavigateToYearDescription to "ਸਾਲ %1\$s \'ਤੇ ਜਾਓ",
    Strings.DatePickerHeadlineDescription to "ਮੌਜੂਦਾ ਚੋਣ: %1\$s",
    Strings.DatePickerNoSelectionDescription to "ਕੋਈ ਨਹੀਂ",
    Strings.DatePickerTodayDescription to "ਅੱਜ",
    Strings.DatePickerYearPickerPaneTitle to "ਸਾਲ ਚੋਣਕਾਰ ਦਿਖਣਯੋਗ ਹੈ",
    Strings.DateInputTitle to "ਤਾਰੀਖ ਚੁਣੋ",
    Strings.DateInputHeadline to "ਦਾਖਲ ਕੀਤੀ ਗਈ ਤਾਰੀਖ",
    Strings.DateInputLabel to "ਤਾਰੀਖ",
    Strings.DateInputHeadlineDescription to "ਦਾਖਲ ਕੀਤੀ ਗਈ ਤਾਰੀਖ: %1\$s",
    Strings.DateInputNoInputDescription to "ਕੋਈ ਨਹੀਂ",
    Strings.DateInputInvalidNotAllowed to "ਇਸ ਤਾਰੀਖ ਦੀ ਆਗਿਆ ਨਹੀਂ ਹੈ: %1\$s",
    Strings.DateInputInvalidForPattern to "ਤਾਰੀਖ ਸੰਭਾਵਿਤ ਪੈਟਰਨ ਨਾਲ ਮੇਲ ਨਹੀਂ ਖਾਂਦੀ: %1\$s",
    Strings.DateInputInvalidYearRange to "ਤਾਰੀਖ ਸੰਭਾਵਿਤ ਸਾਲ ਦੀ ਰੇਂਜ, %1\$s - %2\$s ਤੋਂ ਬਾਹਰ ਹੈ",
    Strings.DatePickerSwitchToCalendarMode to "ਕੈਲੰਡਰ ਇਨਪੁੱਟ ਮੋਡ \'ਤੇ ਸਵਿੱਚ ਕਰੋ",
    Strings.DatePickerSwitchToInputMode to "ਲਿਖਤ ਇਨਪੁੱਟ ਮੋਡ \'ਤੇ ਸਵਿੱਚ ਕਰੋ",
    Strings.DatePickerScrollToShowLaterYears to "ਬਾਅਦ ਵਾਲੇ ਸਾਲਾਂ ਨੂੰ ਦਿਖਾਉਣ ਲਈ ਸਕ੍ਰੋਲ ਕਰੋ",
    Strings.DatePickerScrollToShowEarlierYears to "ਪਿਛਲੇ ਸਾਲਾਂ ਨੂੰ ਦਿਖਾਉਣ ਲਈ ਸਕ੍ਰੋਲ ਕਰੋ",
    Strings.DateRangePickerTitle to "ਤਾਰੀਖਾਂ ਚੁਣੋ",
    Strings.DateRangePickerStartHeadline to "ਸ਼ੁੁਰੂਆਤੀ ਤਾਰੀਖ",
    Strings.DateRangePickerEndHeadline to "ਸਮਾਪਤੀ ਤਾਰੀਖ",
    Strings.DateRangePickerScrollToShowNextMonth to "ਅਗਲਾ ਮਹੀਨਾ ਦਿਖਾਉਣ ਲਈ ਸਕ੍ਰੋਲ ਕਰੋ",
    Strings.DateRangePickerScrollToShowPreviousMonth to "ਪਿਛਲਾ ਮਹੀਨਾ ਦਿਖਾਉਣ ਲਈ ਸਕ੍ਰੋਲ ਕਰੋ",
    Strings.DateRangePickerDayInRange to "ਰੇਂਜ ਵਿੱਚ",
    Strings.DateRangeInputTitle to "ਤਾਰੀਖਾਂ ਦਾਖਲ ਕਰੋ",
    Strings.DateRangeInputInvalidRangeInput to "ਇਨਪੁੱਟ ਕੀਤੀ ਗਈ ਤਾਰੀਖ ਦੀ ਰੇਂਜ ਅਵੈਧ ਹੈ",
    Strings.BottomSheetPaneTitle to "ਹੇਠਲੀ ਸ਼ੀਟ",
    Strings.BottomSheetDragHandleDescription to "ਘਸੀਟਣ ਵਾਲਾ ਹੈਂਡਲ",
    Strings.BottomSheetPartialExpandDescription to "ਹੇਠਲੀ ਸ਼ੀਟ ਨੂੰ ਸਮੇਟੋ",
    Strings.BottomSheetDismissDescription to "ਹੇਠਲੀ ਸ਼ੀਟ ਨੂੰ ਖਾਰਜ ਕਰੋ",
    Strings.BottomSheetExpandDescription to "ਹੇਠਲੀ ਸ਼ੀਟ ਦਾ ਵਿਸਤਾਰ ਕਰੋ",
    Strings.FloatingToolbarCollapse to "ਟੂਲਬਾਰ ਨੂੰ ਸਮੇਟੋ",
    Strings.FloatingToolbarExpand to "ਟੂਲਬਾਰ ਦਾ ਵਿਸਤਾਰ ਕਰੋ",
    Strings.FloatingToolbarMoreOptions to "ਹੋਰ ਵਿਕਲਪ",
    Strings.TooltipPaneDescription to "ਟੂਲ-ਟਿੱਪ",
    Strings.TooltipLongPressLabel to "ਟੂਲ-ਟਿੱਪ ਦਿਖਾਓ",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM ਜਾਂ PM ਚੁਣੋ",
    Strings.TimePickerHourSelection to "ਘੰਟਾ ਚੁਣੋ",
    Strings.TimePickerMinuteSelection to "ਮਿੰਟ ਚੁਣੋ",
    Strings.TimePickerHourSuffix to "%1\$d ਵਜੇ",
    Strings.TimePicker24HourSuffix to "%1\$d ਘੰਟੇ",
    Strings.TimePickerMinuteSuffix to "%1\$d ਮਿੰਟ",
    Strings.TimePickerMinute to "ਮਿੰਟ",
    Strings.TimePickerHour to "ਘੰਟਾ",
    Strings.TimePickerMinuteTextField to "ਮਿੰਟਾਂ ਲਈ",
    Strings.TimePickerHourTextField to "ਘੰਟੇ ਲਈ",
    Strings.TimePickerToggleKeyboard to "ਲਿਖਤ ਇਨਪੁੱਟ ਮੋਡ \'ਤੇ ਸਵਿੱਚ ਕਰੋ",
    Strings.TimePickerToggleTouch to "ਘੜੀ ਮੋਡ \'ਤੇ ਸਵਿੱਚ ਕਰੋ",
    Strings.TimePickerDialogTitle to "ਸਮਾਂ ਚੁਣੋ",
    Strings.TimeInputDialogTitle to "ਸਮਾਂ ਦਾਖਲ ਕਰੋ",
    Strings.TimePickerMinuteError to "ਮਿੰਟ 0–59 ਹੋਣੇ ਲਾਜ਼ਮੀ ਹਨ",
    Strings.TimePickerHourError to "ਘੰਟੇ 1–12 ਹੋਣੇ ਲਾਜ਼ਮੀ ਹਨ",
    Strings.TimePicker24HourError to "ਘੰਟੇ 0–23 ਹੋਣੇ ਲਾਜ਼ਮੀ ਹਨ",
    Strings.CloseRail to "ਰੇਲ ਬੰਦ ਕਰੋ",
    Strings.WideNavigationRailPaneTitle to "ਨੈਵੀਗੇਸ਼ਨ ਰੇਲ",
)
