/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.pl() = mapOf(
    Strings.NavigationMenu to "Menu nawigacyjne",
    Strings.ExposedDropdownMenu to "Menu",
    Strings.CloseDrawer to "Zamknij menu nawigacyjne",
    Strings.CloseSheet to "Zamknij arkusz",
    Strings.DefaultErrorMessage to "Nieprawidłowe dane wejściowe",
    Strings.SliderRangeStart to "Początek zakresu",
    Strings.SliderRangeEnd to "Koniec zakresu",
    Strings.ButtonGroupMoreOptions to "Więcej opcji",
    Strings.Dialog to "Okno",
    Strings.MenuExpanded to "Rozwinięte",
    Strings.MenuCollapsed to "Zwinięte",
    Strings.ToggleDropdownMenu to "Pokaż lub ukryj menu",
    Strings.SnackbarDismiss to "Zamknij",
    Strings.SnackbarPaneTitle to "Alert",
    Strings.SearchBarSearch to "Szukaj",
    Strings.SuggestionsAvailable to "Sugestie znajdziesz poniżej",
    Strings.DatePickerTitle to "Wybierz datę",
    Strings.DatePickerHeadline to "Wybrana data",
    Strings.DatePickerSwitchToYearSelection to "Przełącz na wybór roku",
    Strings.DatePickerSwitchToDaySelection to "Przesuń, aby wybrać rok, lub kliknij, aby wrócić do wyboru dnia",
    Strings.DatePickerSwitchToNextMonth to "Zmień na następny miesiąc",
    Strings.DatePickerSwitchToPreviousMonth to "Zmień na poprzedni miesiąc",
    Strings.DatePickerNavigateToYearDescription to "Przejdź do roku %1\$s",
    Strings.DatePickerHeadlineDescription to "Obecnie wybrane: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Brak",
    Strings.DatePickerTodayDescription to "Dzisiaj",
    Strings.DatePickerYearPickerPaneTitle to "Widoczny selektor roku",
    Strings.DateInputTitle to "Wybierz datę",
    Strings.DateInputHeadline to "Wprowadzono datę",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Wprowadzono datę: %1\$s",
    Strings.DateInputNoInputDescription to "Brak",
    Strings.DateInputInvalidNotAllowed to "Data jest niedozwolona: %1\$s",
    Strings.DateInputInvalidForPattern to "Data nie pasuje do oczekiwanego wzorca: %1\$s",
    Strings.DateInputInvalidYearRange to "Data jest poza oczekiwanym zakresem lat %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Włącz tryb wprowadzania danych kalendarzowych",
    Strings.DatePickerSwitchToInputMode to "Przełącz na tryb wprowadzania tekstu",
    Strings.DatePickerScrollToShowLaterYears to "Przewiń, aby wyświetlić późniejsze lata",
    Strings.DatePickerScrollToShowEarlierYears to "Przewiń, aby wyświetlić wcześniejsze lata",
    Strings.DateRangePickerTitle to "Wybierz daty",
    Strings.DateRangePickerStartHeadline to "Data początkowa",
    Strings.DateRangePickerEndHeadline to "Data końcowa",
    Strings.DateRangePickerScrollToShowNextMonth to "Przewiń, aby wyświetlić następny miesiąc",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Przewiń, aby wyświetlić poprzedni miesiąc",
    Strings.DateRangePickerDayInRange to "W zakresie",
    Strings.DateRangeInputTitle to "Wprowadź daty",
    Strings.DateRangeInputInvalidRangeInput to "Nieprawidłowy zakres dat",
    Strings.BottomSheetPaneTitle to "Plansza dolna",
    Strings.BottomSheetDragHandleDescription to "Uchwyt do przeciągania",
    Strings.BottomSheetPartialExpandDescription to "Zwiń planszę dolną",
    Strings.BottomSheetDismissDescription to "Zamknij planszę dolną",
    Strings.BottomSheetExpandDescription to "Rozwiń planszę dolną",
    Strings.FloatingToolbarCollapse to "Zwiń pasek narzędzi",
    Strings.FloatingToolbarExpand to "Rozwiń pasek narzędzi",
    Strings.FloatingToolbarMoreOptions to "Więcej opcji",
    Strings.TooltipPaneDescription to "Etykietka",
    Strings.TooltipLongPressLabel to "Pokaż etykietkę",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Wybierz AM lub PM",
    Strings.TimePickerHourSelection to "Wybierz godzinę",
    Strings.TimePickerMinuteSelection to "Wybierz minuty",
    Strings.TimePickerHourSuffix to "%1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d",
    Strings.TimePickerMinuteSuffix to "Minuty: %1\$d",
    Strings.TimePickerMinute to "Minuta",
    Strings.TimePickerHour to "Godzina",
    Strings.TimePickerMinuteTextField to "aby wpisać minuty",
    Strings.TimePickerHourTextField to "aby wpisać godzinę",
    Strings.TimePickerToggleKeyboard to "Przełącz się na tryb wprowadzania tekstu",
    Strings.TimePickerToggleTouch to "Przełącz się na tryb zegara",
    Strings.TimePickerDialogTitle to "Wybierz godzinę",
    Strings.TimeInputDialogTitle to "Wpisz godzinę",
    Strings.TimePickerMinuteError to "Zakres minut to 0–59",
    Strings.TimePickerHourError to "Zakres godzin to 1–12",
    Strings.TimePicker24HourError to "Zakres godzin to 0–23",
    Strings.CloseRail to "Zamknij kolumnę",
    Strings.WideNavigationRailPaneTitle to "Kolumna nawigacji",
)
