/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.sl() = mapOf(
    Strings.NavigationMenu to "Meni za krmarjenje",
    Strings.ExposedDropdownMenu to "Spustni meni",
    Strings.CloseDrawer to "Zapri meni za krmarjenje",
    Strings.CloseSheet to "Zapri list",
    Strings.DefaultErrorMessage to "Neveljaven vnos",
    Strings.SliderRangeStart to "Začetek razpona",
    Strings.SliderRangeEnd to "Konec razpona",
    Strings.ButtonGroupMoreOptions to "Več možnosti",
    Strings.Dialog to "Pogovorno okno",
    Strings.MenuExpanded to "Razširjeno",
    Strings.MenuCollapsed to "Strnjeno",
    Strings.ToggleDropdownMenu to "Preklop spustnega menija",
    Strings.SnackbarDismiss to "Opusti",
    Strings.SnackbarPaneTitle to "Opozorilo",
    Strings.SearchBarSearch to "Iskanje",
    Strings.SuggestionsAvailable to "Predlogi so spodaj",
    Strings.DatePickerTitle to "Izbira datuma",
    Strings.DatePickerHeadline to "Izbrani datum",
    Strings.DatePickerSwitchToYearSelection to "Preklopi na izbiro leta",
    Strings.DatePickerSwitchToDaySelection to "Povlecite, da izberete leto, ali se dotaknite, da preklopite nazaj na izbiranje dneva.",
    Strings.DatePickerSwitchToNextMonth to "Spremeni na naslednji mesec",
    Strings.DatePickerSwitchToPreviousMonth to "Spremeni na prejšnji mesec",
    Strings.DatePickerNavigateToYearDescription to "Pomik na leto %1\$s",
    Strings.DatePickerHeadlineDescription to "Trenutna izbira: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Brez",
    Strings.DatePickerTodayDescription to "Danes",
    Strings.DatePickerYearPickerPaneTitle to "Izbirnik leta je viden",
    Strings.DateInputTitle to "Izbira datuma",
    Strings.DateInputHeadline to "Vneseni datum",
    Strings.DateInputLabel to "Datum",
    Strings.DateInputHeadlineDescription to "Vneseni datum: %1\$s",
    Strings.DateInputNoInputDescription to "Brez",
    Strings.DateInputInvalidNotAllowed to "Oblika datuma ni dovoljena: %1\$s",
    Strings.DateInputInvalidForPattern to "Datum se ne ujema s pričakovanim vzorcem: %1\$s",
    Strings.DateInputInvalidYearRange to "Datum je zunaj pričakovanega razpona let %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Preklop na način vnosa v koledar",
    Strings.DatePickerSwitchToInputMode to "Preklop na način vnosa besedila",
    Strings.DatePickerScrollToShowLaterYears to "Pomaknite se za prikaz poznejših let.",
    Strings.DatePickerScrollToShowEarlierYears to "Pomaknite se za prikaz zgodnejših let.",
    Strings.DateRangePickerTitle to "Izberite datume",
    Strings.DateRangePickerStartHeadline to "Začetni datum",
    Strings.DateRangePickerEndHeadline to "Končni datum",
    Strings.DateRangePickerScrollToShowNextMonth to "Pomaknite se za prikaz naslednjega meseca.",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Pomaknite se za prikaz prejšnjega meseca.",
    Strings.DateRangePickerDayInRange to "Znotraj obdobja",
    Strings.DateRangeInputTitle to "Vnesite datume",
    Strings.DateRangeInputInvalidRangeInput to "Neveljaven vnos obdobja.",
    Strings.BottomSheetPaneTitle to "Razdelek na dnu zaslona",
    Strings.BottomSheetDragHandleDescription to "Ročica za vlečenje",
    Strings.BottomSheetPartialExpandDescription to "Strnitev razdelka na dnu zaslona",
    Strings.BottomSheetDismissDescription to "Opustitev razdelka na dnu zaslona",
    Strings.BottomSheetExpandDescription to "Razširitev razdelka na dnu zaslona",
    Strings.FloatingToolbarCollapse to "Strnitev orodne vrstice",
    Strings.FloatingToolbarExpand to "Razširitev orodne vrstice",
    Strings.FloatingToolbarMoreOptions to "Več možnosti",
    Strings.TooltipPaneDescription to "Opis orodja",
    Strings.TooltipLongPressLabel to "Pokaži opis orodja",
    Strings.TimePickerPM to "pop.",
    Strings.TimePickerAM to "dop.",
    Strings.TimePickerPeriodToggle to "Izberite dopoldanski ali popoldanski čas.",
    Strings.TimePickerHourSelection to "Izbira ure",
    Strings.TimePickerMinuteSelection to "Izbira minut",
    Strings.TimePickerHourSuffix to "%1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d",
    Strings.TimePickerMinuteSuffix to "%1\$d min",
    Strings.TimePickerMinute to "Minuta",
    Strings.TimePickerHour to "Ura",
    Strings.TimePickerMinuteTextField to "za minute",
    Strings.TimePickerHourTextField to "za uro",
    Strings.TimePickerToggleKeyboard to "Preklop na način vnosa besedila",
    Strings.TimePickerToggleTouch to "Preklop na način ure",
    Strings.TimePickerDialogTitle to "Izberite uro",
    Strings.TimeInputDialogTitle to "Vnesite uro",
    Strings.TimePickerMinuteError to "Minuta mora biti 0–59",
    Strings.TimePickerHourError to "Ura mora biti 1–12",
    Strings.TimePicker24HourError to "Ura mora biti 0–23",
    Strings.CloseRail to "Zapiranje črte",
    Strings.WideNavigationRailPaneTitle to "Črta za krmarjenje",
)
