/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.tr() = mapOf(
    Strings.NavigationMenu to "Gezinme menüsü",
    Strings.ExposedDropdownMenu to "Açılır menü",
    Strings.CloseDrawer to "Gezinme menüsünü kapat",
    Strings.CloseSheet to "Sayfayı kapat",
    Strings.DefaultErrorMessage to "Geçersiz giriş",
    Strings.SliderRangeStart to "Aralık başlangıcı",
    Strings.SliderRangeEnd to "Aralık sonu",
    Strings.ButtonGroupMoreOptions to "Diğer seçenekler",
    Strings.Dialog to "Dialog",
    Strings.MenuExpanded to "Genişletildi",
    Strings.MenuCollapsed to "Daraltıldı",
    Strings.ToggleDropdownMenu to "Açılır menüyü açın/kapatın",
    Strings.SnackbarDismiss to "Kapat",
    Strings.SnackbarPaneTitle to "Uyarı",
    Strings.SearchBarSearch to "Arama",
    Strings.SuggestionsAvailable to "Önerileri aşağıda bulabilirsiniz",
    Strings.DatePickerTitle to "Tarih seç",
    Strings.DatePickerHeadline to "Seçilen tarih",
    Strings.DatePickerSwitchToYearSelection to "Yıl seçimine geç",
    Strings.DatePickerSwitchToDaySelection to "Kaydırarak bir yıl seçin veya gün seçme bölümüne geri dönmek için dokunun",
    Strings.DatePickerSwitchToNextMonth to "Sonraki aya değiştir",
    Strings.DatePickerSwitchToPreviousMonth to "Önceki aya değiştir",
    Strings.DatePickerNavigateToYearDescription to "%1\$s yılına gidin",
    Strings.DatePickerHeadlineDescription to "Geçerli seçim: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Yok",
    Strings.DatePickerTodayDescription to "Bugün",
    Strings.DatePickerYearPickerPaneTitle to "Yıl seçici görünür durumda",
    Strings.DateInputTitle to "Tarih seç",
    Strings.DateInputHeadline to "Girilen tarih",
    Strings.DateInputLabel to "Tarih",
    Strings.DateInputHeadlineDescription to "Girilen tarih: %1\$s",
    Strings.DateInputNoInputDescription to "Yok",
    Strings.DateInputInvalidNotAllowed to "Tarihe izin verilmiyor: %1\$s",
    Strings.DateInputInvalidForPattern to "Tarih, istenen biçimle eşleşmiyor: %1\$s",
    Strings.DateInputInvalidYearRange to "Tarih, istenen %1\$s-%2\$s yıl aralığının dışında",
    Strings.DatePickerSwitchToCalendarMode to "Takvim giriş moduna geç",
    Strings.DatePickerSwitchToInputMode to "Metin giriş moduna geç",
    Strings.DatePickerScrollToShowLaterYears to "Sonraki yılları göstermek için kaydırın",
    Strings.DatePickerScrollToShowEarlierYears to "Önceki yılları göstermek için kaydırın",
    Strings.DateRangePickerTitle to "Tarihleri seçin",
    Strings.DateRangePickerStartHeadline to "Başlangıç tarihi",
    Strings.DateRangePickerEndHeadline to "Bitiş tarihi",
    Strings.DateRangePickerScrollToShowNextMonth to "Sonraki ayı göstermek için kaydırın",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Önceki ayı göstermek için kaydırın",
    Strings.DateRangePickerDayInRange to "Aralıkta",
    Strings.DateRangeInputTitle to "Tarihleri girin",
    Strings.DateRangeInputInvalidRangeInput to "Geçersiz tarih aralığı girişi",
    Strings.BottomSheetPaneTitle to "Alt Sayfa",
    Strings.BottomSheetDragHandleDescription to "Sürükleme tutamacı",
    Strings.BottomSheetPartialExpandDescription to "Alt sayfayı daralt",
    Strings.BottomSheetDismissDescription to "Alt sayfayı kapat",
    Strings.BottomSheetExpandDescription to "Alt sayfayı genişlet",
    Strings.FloatingToolbarCollapse to "Araç çubuğunu daralt",
    Strings.FloatingToolbarExpand to "Araç çubuğunu genişlet",
    Strings.FloatingToolbarMoreOptions to "Diğer seçenekler",
    Strings.TooltipPaneDescription to "İpucu",
    Strings.TooltipLongPressLabel to "Araç ipucunu göster",
    Strings.TimePickerPM to "ÖS",
    Strings.TimePickerAM to "ÖÖ",
    Strings.TimePickerPeriodToggle to "ÖÖ veya ÖS\'yi seçin",
    Strings.TimePickerHourSelection to "Saat seçin",
    Strings.TimePickerMinuteSelection to "Dakikayı seçin",
    Strings.TimePickerHourSuffix to "Saat %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d saat",
    Strings.TimePickerMinuteSuffix to "%1\$d dakika",
    Strings.TimePickerMinute to "Dakika",
    Strings.TimePickerHour to "Saat",
    Strings.TimePickerMinuteTextField to "dakika",
    Strings.TimePickerHourTextField to "saat",
    Strings.TimePickerToggleKeyboard to "Metin giriş moduna geç",
    Strings.TimePickerToggleTouch to "Saat moduna geç",
    Strings.TimePickerDialogTitle to "Saat Seçin",
    Strings.TimeInputDialogTitle to "Saat Girin",
    Strings.TimePickerMinuteError to "Dakika 0-59 arasında olmalıdır",
    Strings.TimePickerHourError to "Saat 1-12 arasında olmalıdır",
    Strings.TimePicker24HourError to "Saat 0-23 arasında olmalıdır",
    Strings.CloseRail to "Sütunu kapat",
    Strings.WideNavigationRailPaneTitle to "Gezinme sütunu",
)
