/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.vi() = mapOf(
    Strings.NavigationMenu to "Trình đơn điều hướng",
    Strings.ExposedDropdownMenu to "Trình đơn thả xuống",
    Strings.CloseDrawer to "Đóng trình đơn điều hướng",
    Strings.CloseSheet to "Đóng trang tính",
    Strings.DefaultErrorMessage to "Giá trị nhập không hợp lệ",
    Strings.SliderRangeStart to "Điểm bắt đầu phạm vi",
    Strings.SliderRangeEnd to "Điểm kết thúc phạm vi",
    Strings.ButtonGroupMoreOptions to "Tuỳ chọn khác",
    Strings.Dialog to "Hộp thoại",
    Strings.MenuExpanded to "Đã mở rộng",
    Strings.MenuCollapsed to "Đã thu gọn",
    Strings.ToggleDropdownMenu to "Bật/tắt trình đơn thả xuống",
    Strings.SnackbarDismiss to "Đóng",
    Strings.SnackbarPaneTitle to "Cảnh báo",
    Strings.SearchBarSearch to "Tìm kiếm",
    Strings.SuggestionsAvailable to "Các đề xuất ở bên dưới",
    Strings.DatePickerTitle to "Chọn ngày",
    Strings.DatePickerHeadline to "Ngày đã chọn",
    Strings.DatePickerSwitchToYearSelection to "Chuyển sang chọn năm",
    Strings.DatePickerSwitchToDaySelection to "Vuốt để chọn một năm hoặc nhấn để chuyển lại về chọn một ngày",
    Strings.DatePickerSwitchToNextMonth to "Chuyển sang tháng tiếp theo",
    Strings.DatePickerSwitchToPreviousMonth to "Chuyển về tháng trước",
    Strings.DatePickerNavigateToYearDescription to "Chuyển đến năm %1\$s",
    Strings.DatePickerHeadlineDescription to "Lựa chọn hiện tại: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Không có",
    Strings.DatePickerTodayDescription to "Hôm nay",
    Strings.DatePickerYearPickerPaneTitle to "Bộ chọn năm hiển thị",
    Strings.DateInputTitle to "Chọn ngày",
    Strings.DateInputHeadline to "Ngày đã nhập",
    Strings.DateInputLabel to "Ngày",
    Strings.DateInputHeadlineDescription to "Ngày đã nhập: %1\$s",
    Strings.DateInputNoInputDescription to "Không có",
    Strings.DateInputInvalidNotAllowed to "Ngày không được phép: %1\$s",
    Strings.DateInputInvalidForPattern to "Ngày không khớp với định dạng dự kiến: %1\$s",
    Strings.DateInputInvalidYearRange to "Ngày không thuộc phạm vi năm dự kiến %1\$s – %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Chuyển sang chế độ nhập lịch",
    Strings.DatePickerSwitchToInputMode to "Chuyển sang chế độ nhập văn bản",
    Strings.DatePickerScrollToShowLaterYears to "Cuộn để hiện những năm sau",
    Strings.DatePickerScrollToShowEarlierYears to "Cuộn để hiện những năm trước",
    Strings.DateRangePickerTitle to "Chọn ngày",
    Strings.DateRangePickerStartHeadline to "Ngày bắt đầu",
    Strings.DateRangePickerEndHeadline to "Ngày kết thúc",
    Strings.DateRangePickerScrollToShowNextMonth to "Cuộn để hiện tháng sau",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Cuộn để hiện tháng trước",
    Strings.DateRangePickerDayInRange to "Trong khoảng",
    Strings.DateRangeInputTitle to "Nhập ngày",
    Strings.DateRangeInputInvalidRangeInput to "Phạm vi ngày đã nhập không hợp lệ",
    Strings.BottomSheetPaneTitle to "Bảng dưới cùng",
    Strings.BottomSheetDragHandleDescription to "Nút kéo",
    Strings.BottomSheetPartialExpandDescription to "Thu gọn bảng dưới cùng",
    Strings.BottomSheetDismissDescription to "Đóng bảng dưới cùng",
    Strings.BottomSheetExpandDescription to "Mở rộng bảng dưới cùng",
    Strings.FloatingToolbarCollapse to "Thu gọn thanh công cụ",
    Strings.FloatingToolbarExpand to "Mở rộng thanh công cụ",
    Strings.FloatingToolbarMoreOptions to "Lựa chọn khác",
    Strings.TooltipPaneDescription to "Chú giải công cụ",
    Strings.TooltipLongPressLabel to "Hiện chú giải công cụ",
    Strings.TimePickerPM to "CH",
    Strings.TimePickerAM to "SA",
    Strings.TimePickerPeriodToggle to "Chọn SA hoặc CH",
    Strings.TimePickerHourSelection to "Chọn giờ",
    Strings.TimePickerMinuteSelection to "Chọn phút",
    Strings.TimePickerHourSuffix to "%1\$d giờ",
    Strings.TimePicker24HourSuffix to "%1\$d giờ",
    Strings.TimePickerMinuteSuffix to "%1\$d phút",
    Strings.TimePickerMinute to "Phút",
    Strings.TimePickerHour to "Giờ",
    Strings.TimePickerMinuteTextField to "nhập phút",
    Strings.TimePickerHourTextField to "nhập giờ",
    Strings.TimePickerToggleKeyboard to "Chuyển sang chế độ nhập văn bản",
    Strings.TimePickerToggleTouch to "Chuyển sang chế độ đồng hồ",
    Strings.TimePickerDialogTitle to "Chọn thời gian",
    Strings.TimeInputDialogTitle to "Nhập thời gian",
    Strings.TimePickerMinuteError to "Số phút phải từ 0 đến 59",
    Strings.TimePickerHourError to "Số giờ phải từ 1 đến 12",
    Strings.TimePicker24HourError to "Số giờ phải từ 0 đến 23",
    Strings.CloseRail to "Đóng dải điều hướng",
    Strings.WideNavigationRailPaneTitle to "Dải điều hướng",
)
