/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhCN() = mapOf(
    Strings.NavigationMenu to "导航菜单",
    Strings.ExposedDropdownMenu to "下拉菜单",
    Strings.CloseDrawer to "关闭导航菜单",
    Strings.CloseSheet to "关闭工作表",
    Strings.DefaultErrorMessage to "输入无效",
    Strings.SliderRangeStart to "范围起点",
    Strings.SliderRangeEnd to "范围终点",
    Strings.ButtonGroupMoreOptions to "更多选项",
    Strings.Dialog to "对话框",
    Strings.MenuExpanded to "已展开",
    Strings.MenuCollapsed to "已收起",
    Strings.ToggleDropdownMenu to "展开/收起下拉菜单",
    Strings.SnackbarDismiss to "关闭",
    Strings.SnackbarPaneTitle to "提醒",
    Strings.SearchBarSearch to "搜索",
    Strings.SuggestionsAvailable to "以下是搜索建议",
    Strings.DatePickerTitle to "选择日期",
    Strings.DatePickerHeadline to "选定的日期",
    Strings.DatePickerSwitchToYearSelection to "切换为选择年份",
    Strings.DatePickerSwitchToDaySelection to "滑动可选择年份，点按可切换回选择日期",
    Strings.DatePickerSwitchToNextMonth to "转到下个月",
    Strings.DatePickerSwitchToPreviousMonth to "转到上个月",
    Strings.DatePickerNavigateToYearDescription to "切换到年份：%1\$s",
    Strings.DatePickerHeadlineDescription to "当前的选择：%1\$s",
    Strings.DatePickerNoSelectionDescription to "无",
    Strings.DatePickerTodayDescription to "今天",
    Strings.DatePickerYearPickerPaneTitle to "年份选择器可见",
    Strings.DateInputTitle to "选择日期",
    Strings.DateInputHeadline to "输入的日期",
    Strings.DateInputLabel to "日期",
    Strings.DateInputHeadlineDescription to "输入的日期：%1\$s",
    Strings.DateInputNoInputDescription to "无",
    Strings.DateInputInvalidNotAllowed to "日期无效：%1\$s",
    Strings.DateInputInvalidForPattern to "日期不符合格式要求：%1\$s",
    Strings.DateInputInvalidYearRange to "日期超出预期年份范围 %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "切换到日历输入模式",
    Strings.DatePickerSwitchToInputMode to "切换到文本字段输入模式",
    Strings.DatePickerScrollToShowLaterYears to "滚动即可显示之后的年份",
    Strings.DatePickerScrollToShowEarlierYears to "滚动即可显示之前的年份",
    Strings.DateRangePickerTitle to "选择日期",
    Strings.DateRangePickerStartHeadline to "开始日期",
    Strings.DateRangePickerEndHeadline to "结束日期",
    Strings.DateRangePickerScrollToShowNextMonth to "滚动即可显示下个月",
    Strings.DateRangePickerScrollToShowPreviousMonth to "滚动即可显示上个月",
    Strings.DateRangePickerDayInRange to "在范围内",
    Strings.DateRangeInputTitle to "输入日期",
    Strings.DateRangeInputInvalidRangeInput to "输入的日期范围无效",
    Strings.BottomSheetPaneTitle to "底部动作条",
    Strings.BottomSheetDragHandleDescription to "拖动手柄",
    Strings.BottomSheetPartialExpandDescription to "收起底部动作条",
    Strings.BottomSheetDismissDescription to "关闭底部动作条",
    Strings.BottomSheetExpandDescription to "展开底部动作条",
    Strings.FloatingToolbarCollapse to "收起工具栏",
    Strings.FloatingToolbarExpand to "展开工具栏",
    Strings.FloatingToolbarMoreOptions to "更多选项",
    Strings.TooltipPaneDescription to "提示",
    Strings.TooltipLongPressLabel to "显示提示",
    Strings.TimePickerPM to "下午",
    Strings.TimePickerAM to "上午",
    Strings.TimePickerPeriodToggle to "选择上午或下午",
    Strings.TimePickerHourSelection to "选择小时",
    Strings.TimePickerMinuteSelection to "选择分钟",
    Strings.TimePickerHourSuffix to "%1\$d 点",
    Strings.TimePicker24HourSuffix to "%1\$d 小时",
    Strings.TimePickerMinuteSuffix to "%1\$d 分钟",
    Strings.TimePickerMinute to "分钟",
    Strings.TimePickerHour to "小时",
    Strings.TimePickerMinuteTextField to "输入分钟",
    Strings.TimePickerHourTextField to "输入小时",
    Strings.TimePickerToggleKeyboard to "切换到文字输入模式",
    Strings.TimePickerToggleTouch to "切换到时钟模式",
    Strings.TimePickerDialogTitle to "选择时间",
    Strings.TimeInputDialogTitle to "输入时间",
    Strings.TimePickerMinuteError to "分钟值必须介于 0 到 59 间",
    Strings.TimePickerHourError to "小时值必须介于 1 到 12 间",
    Strings.TimePicker24HourError to "小时值必须介于 0 到 23 间",
    Strings.CloseRail to "关闭此栏",
    Strings.WideNavigationRailPaneTitle to "侧边导航栏",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhHK() = mapOf(
    Strings.NavigationMenu to "導覽選單",
    Strings.ExposedDropdownMenu to "下拉式選單",
    Strings.CloseDrawer to "閂導覽選單",
    Strings.CloseSheet to "閂表單",
    Strings.DefaultErrorMessage to "輸入嘅資料無效",
    Strings.SliderRangeStart to "範圍開始",
    Strings.SliderRangeEnd to "範圍結束",
    Strings.ButtonGroupMoreOptions to "更多選項",
    Strings.Dialog to "對話框",
    Strings.MenuExpanded to "已展開",
    Strings.MenuCollapsed to "已收合",
    Strings.ToggleDropdownMenu to "切換下拉式選單",
    Strings.SnackbarDismiss to "關閉",
    Strings.SnackbarPaneTitle to "警示",
    Strings.SearchBarSearch to "搜尋",
    Strings.SuggestionsAvailable to "建議如下",
    Strings.DatePickerTitle to "選取日期",
    Strings.DatePickerHeadline to "所選日期",
    Strings.DatePickerSwitchToYearSelection to "切換為選取年份",
    Strings.DatePickerSwitchToDaySelection to "滑動可選取年分，或可輕按返回選取日期",
    Strings.DatePickerSwitchToNextMonth to "變更至下個月",
    Strings.DatePickerSwitchToPreviousMonth to "變更至上個月",
    Strings.DatePickerNavigateToYearDescription to "前往 %1\$s 年",
    Strings.DatePickerHeadlineDescription to "目前選項：%1\$s",
    Strings.DatePickerNoSelectionDescription to "無",
    Strings.DatePickerTodayDescription to "今天",
    Strings.DatePickerYearPickerPaneTitle to "顯示年分挑選器",
    Strings.DateInputTitle to "選取日期",
    Strings.DateInputHeadline to "已輸入的日期",
    Strings.DateInputLabel to "日期",
    Strings.DateInputHeadlineDescription to "已輸入的日期：%1\$s",
    Strings.DateInputNoInputDescription to "無",
    Strings.DateInputInvalidNotAllowed to "不允許的日期：%1\$s",
    Strings.DateInputInvalidForPattern to "日期格式不符：%1\$s",
    Strings.DateInputInvalidYearRange to "日期超出預期的年份範圍：%1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "切換至日曆輸入模式",
    Strings.DatePickerSwitchToInputMode to "切換至文字輸入模式",
    Strings.DatePickerScrollToShowLaterYears to "碌去顯示新啲嘅年份",
    Strings.DatePickerScrollToShowEarlierYears to "碌去顯示舊啲嘅年份",
    Strings.DateRangePickerTitle to "選取日期",
    Strings.DateRangePickerStartHeadline to "開始日期",
    Strings.DateRangePickerEndHeadline to "結束日期",
    Strings.DateRangePickerScrollToShowNextMonth to "碌去顯示下一個月",
    Strings.DateRangePickerScrollToShowPreviousMonth to "碌去顯示上一個月",
    Strings.DateRangePickerDayInRange to "喺指定日期範圍內",
    Strings.DateRangeInputTitle to "輸入日期",
    Strings.DateRangeInputInvalidRangeInput to "輸入的日期範圍無效",
    Strings.BottomSheetPaneTitle to "頁底面板",
    Strings.BottomSheetDragHandleDescription to "拖曳控點",
    Strings.BottomSheetPartialExpandDescription to "收合頁底面板",
    Strings.BottomSheetDismissDescription to "關閉頁底面板",
    Strings.BottomSheetExpandDescription to "展開頁底面板",
    Strings.FloatingToolbarCollapse to "收埋工具列",
    Strings.FloatingToolbarExpand to "打展工具列",
    Strings.FloatingToolbarMoreOptions to "更多選項",
    Strings.TooltipPaneDescription to "提示",
    Strings.TooltipLongPressLabel to "顯示提示",
    Strings.TimePickerPM to "下午",
    Strings.TimePickerAM to "上午",
    Strings.TimePickerPeriodToggle to "選取上午或下午",
    Strings.TimePickerHourSelection to "選取小時",
    Strings.TimePickerMinuteSelection to "選取分鐘",
    Strings.TimePickerHourSuffix to "%1\$d 點",
    Strings.TimePicker24HourSuffix to "%1\$d 點",
    Strings.TimePickerMinuteSuffix to "%1\$d 分鐘",
    Strings.TimePickerMinute to "分鐘",
    Strings.TimePickerHour to "小時",
    Strings.TimePickerMinuteTextField to "分鐘",
    Strings.TimePickerHourTextField to "小時",
    Strings.TimePickerToggleKeyboard to "切換至文字輸入模式",
    Strings.TimePickerToggleTouch to "切換至時鐘模式",
    Strings.TimePickerDialogTitle to "選取時間",
    Strings.TimeInputDialogTitle to "輸入時間",
    Strings.TimePickerMinuteError to "分鐘必須介乎 0 至 59",
    Strings.TimePickerHourError to "小時必須介乎 1 至 12",
    Strings.TimePicker24HourError to "小時必須介乎 0 至 23",
    Strings.CloseRail to "閂咗個欄",
    Strings.WideNavigationRailPaneTitle to "導覽欄",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhTW() = mapOf(
    Strings.NavigationMenu to "導覽選單",
    Strings.ExposedDropdownMenu to "下拉式選單",
    Strings.CloseDrawer to "關閉導覽選單",
    Strings.CloseSheet to "關閉功能表",
    Strings.DefaultErrorMessage to "輸入內容無效",
    Strings.SliderRangeStart to "範圍起點",
    Strings.SliderRangeEnd to "範圍終點",
    Strings.ButtonGroupMoreOptions to "更多選項",
    Strings.Dialog to "對話方塊",
    Strings.MenuExpanded to "已展開",
    Strings.MenuCollapsed to "已收合",
    Strings.ToggleDropdownMenu to "切換鈕下拉式選單",
    Strings.SnackbarDismiss to "關閉",
    Strings.SnackbarPaneTitle to "快訊",
    Strings.SearchBarSearch to "搜尋",
    Strings.SuggestionsAvailable to "建議如下",
    Strings.DatePickerTitle to "選取日期",
    Strings.DatePickerHeadline to "所選日期",
    Strings.DatePickerSwitchToYearSelection to "改為選取年份",
    Strings.DatePickerSwitchToDaySelection to "滑動即可選取年分，也可輕觸返回選取日期",
    Strings.DatePickerSwitchToNextMonth to "改成下個月",
    Strings.DatePickerSwitchToPreviousMonth to "改成上個月",
    Strings.DatePickerNavigateToYearDescription to "前往 %1\$s 年",
    Strings.DatePickerHeadlineDescription to "目前選項：%1\$s",
    Strings.DatePickerNoSelectionDescription to "無",
    Strings.DatePickerTodayDescription to "今天",
    Strings.DatePickerYearPickerPaneTitle to "顯示年份挑選器",
    Strings.DateInputTitle to "選取日期",
    Strings.DateInputHeadline to "輸入的日期",
    Strings.DateInputLabel to "日期",
    Strings.DateInputHeadlineDescription to "輸入的日期：%1\$s",
    Strings.DateInputNoInputDescription to "無",
    Strings.DateInputInvalidNotAllowed to "不允許的日期：%1\$s",
    Strings.DateInputInvalidForPattern to "日期格式不符：%1\$s",
    Strings.DateInputInvalidYearRange to "日期超出預期的年份範圍：%1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "切換至日曆輸入模式",
    Strings.DatePickerSwitchToInputMode to "切換至文字輸入模式",
    Strings.DatePickerScrollToShowLaterYears to "捲動即可顯示之後年分",
    Strings.DatePickerScrollToShowEarlierYears to "捲動即可顯示先前年分",
    Strings.DateRangePickerTitle to "選取日期",
    Strings.DateRangePickerStartHeadline to "開始日期",
    Strings.DateRangePickerEndHeadline to "結束日期",
    Strings.DateRangePickerScrollToShowNextMonth to "捲動即可顯示下一個月",
    Strings.DateRangePickerScrollToShowPreviousMonth to "捲動即可顯示上一個月",
    Strings.DateRangePickerDayInRange to "在有效範圍內",
    Strings.DateRangeInputTitle to "輸入日期",
    Strings.DateRangeInputInvalidRangeInput to "輸入的日期範圍無效",
    Strings.BottomSheetPaneTitle to "底部功能表",
    Strings.BottomSheetDragHandleDescription to "拖曳控點",
    Strings.BottomSheetPartialExpandDescription to "收合底部功能表",
    Strings.BottomSheetDismissDescription to "關閉底部功能表",
    Strings.BottomSheetExpandDescription to "展開底部功能表",
    Strings.FloatingToolbarCollapse to "收合工具列",
    Strings.FloatingToolbarExpand to "展開工具列",
    Strings.FloatingToolbarMoreOptions to "更多選項",
    Strings.TooltipPaneDescription to "工具提示",
    Strings.TooltipLongPressLabel to "顯示工具提示",
    Strings.TimePickerPM to "下午",
    Strings.TimePickerAM to "上午",
    Strings.TimePickerPeriodToggle to "選取上午或下午",
    Strings.TimePickerHourSelection to "選取小時",
    Strings.TimePickerMinuteSelection to "選取分鐘數",
    Strings.TimePickerHourSuffix to "%1\$d 點",
    Strings.TimePicker24HourSuffix to "%1\$d 時",
    Strings.TimePickerMinuteSuffix to "%1\$d 分鐘",
    Strings.TimePickerMinute to "分鐘",
    Strings.TimePickerHour to "小時",
    Strings.TimePickerMinuteTextField to "分鐘",
    Strings.TimePickerHourTextField to "小時",
    Strings.TimePickerToggleKeyboard to "切換到文字輸入模式",
    Strings.TimePickerToggleTouch to "切換到時鐘模式",
    Strings.TimePickerDialogTitle to "選取時間",
    Strings.TimeInputDialogTitle to "輸入時間",
    Strings.TimePickerMinuteError to "分鐘值須介於 0 至 59 之間",
    Strings.TimePickerHourError to "小時值須介於 1 至 12 之間",
    Strings.TimePicker24HourError to "小時值須介於 0 至 23 之間",
    Strings.CloseRail to "關閉邊欄",
    Strings.WideNavigationRailPaneTitle to "導覽邊欄",
)
